/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.helper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.datagrade.utils.DataGradeGroupUtil;
import kd.swc.hscs.business.cal.service.AfterTaxCalService;
import kd.swc.hscs.business.cal.utils.CalUtils;

public class CalOperationHelper {
    private static final Log logger = LogFactory.getLog(CalOperationHelper.class);

    public static String getSuccessCalStateByCalType(String calType, boolean openTaxCal) {
        String calState = CalStateEnum.ALL_CALED.getCode();
        if (SWCStringUtils.isEmpty((String)calType)) {
            return String.valueOf(calState);
        }
        switch (calType) {
            case "onlyPreTaxCal": {
                calState = CalStateEnum.PARTIAL_CALED.getCode();
                break;
            }
            case "preTaxCal": {
                if (openTaxCal) {
                    calState = CalStateEnum.PRECAL_CALED.getCode();
                    break;
                }
                calState = CalStateEnum.TAX_CALED.getCode();
                break;
            }
            case "cal": {
                calState = CalStateEnum.ALL_CALED.getCode();
                break;
            }
            default: {
                calState = CalStateEnum.ALL_CALED.getCode();
            }
        }
        return String.valueOf(calState);
    }

    public static String getFailCalStateByCalType(String calType) {
        String calState = CalStateEnum.PRECAL_ERROR.getCode();
        if (SWCStringUtils.isEmpty((String)calType)) {
            return String.valueOf(calState);
        }
        calState = "afterTaxCal".equals(calType) ? CalStateEnum.AFTERCAL_ERROR.getCode() : CalStateEnum.PRECAL_ERROR.getCode();
        return String.valueOf(calState);
    }

    public static void handleFailData(Map<Long, DynamicObject> calPersonMap, String failType, String failMsg, String calState, long calTaskId, long calRecordId) {
        if (CalUtils.isTerminationCal(calRecordId)) {
            return;
        }
        Map<Long, DynamicObject> calDetailMap = CalOperationHelper.getCalDetailsDataMap(calPersonMap.keySet(), calTaskId, calRecordId);
        DynamicObjectCollection updateCalDetailList = new DynamicObjectCollection();
        DynamicObject calDetail = null;
        for (Map.Entry<Long, DynamicObject> entry : calDetailMap.entrySet()) {
            calDetail = entry.getValue();
            calDetail.set("failtype", (Object)failType);
            calDetail.set("errorelement", (Object)"-");
            calDetail.set("failmsg", (Object)failMsg);
            calDetail.set("calstatus", (Object)CalStatusEnum.FAIL.getCode());
            updateCalDetailList.add((Object)calDetail);
        }
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(calPersonMap.size());
        DynamicObjectCollection updateCalPersonList = new DynamicObjectCollection();
        DynamicObject calPerson = null;
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            calPerson = entry.getValue();
            calPerson.set("calstatus", (Object)calState);
            updateCalPersonList.add((Object)calPerson);
            personIndexIdList.add(calPerson.getLong("personhrv.personindexid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        Object[] calDetailArray = new DynamicObject[updateCalDetailList.size()];
        updateCalDetailList.toArray(calDetailArray);
        helper.update((DynamicObject[])calDetailArray);
        helper.setEntityName("hsas_calperson");
        Object[] calPersonArray = new DynamicObject[updateCalPersonList.size()];
        updateCalPersonList.toArray(calPersonArray);
        helper.update((DynamicObject[])calPersonArray);
        CalUtils.deleteSalaryCalMutexData(personIndexIdList, calTaskId);
    }

    public static Map<Long, DynamicObject> getCalDetailsDataMap(Set<Long> calPersonIdSet, long calTaskId, long calRecordId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        qFilter.and("record.id", "=", (Object)calRecordId);
        qFilter.and("calpersonid", "in", calPersonIdSet);
        DynamicObject[] calDetails = helper.query("id,calpersonid,calstatus,failtype,failmsg,errorelement", new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> calDetailMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject obj : calDetails) {
            calDetailMap.put(obj.getLong("calpersonid"), obj);
        }
        return calDetailMap;
    }

    public static void invokeTaxReleaseOpResource(String preValidateKey, String countryId) {
        HashMap<String, String> request = new HashMap<String, String>(2);
        request.put("preValidateKey", preValidateKey);
        request.put("country", countryId);
        try {
            SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"releaseOpResource", (Object[])new Object[]{request});
        }
        catch (Exception e) {
            logger.error("invokeTaxReleaseOpResource error", (Throwable)e);
        }
        ISWCAppCache appCache = SWCAppCache.get((String)("SWC_TAX_RELEASE_" + preValidateKey));
        appCache.put("invokeTaxReleaseOpResource", (Object)Boolean.TRUE);
    }

    public static DynamicObject[] addCalTableEntryDataAndReturn(Map<String, Object> pushParamMap, Map<Long, Map<String, String>> calPersonItemValMap, Map<Long, DynamicObject> calPersonMap, Map<Long, Long> taxCurrencyMap, Long calTaskId, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) throws ParseException {
        if (calPersonItemValMap.size() == 0) {
            return new DynamicObject[0];
        }
        List<Long> calTableIdList = calPersonMap.values().stream().map(obj -> obj.getLong("calresultid")).collect(Collectors.toList());
        Map<Long, DynamicObject> calTableMap = CalOperationHelper.getCalTableData(calTableIdList, calTaskId);
        Map taxItemMapperSalaryMap = (Map)pushParamMap.get("taxItemMapperSalaryMap");
        Map salaryDataTypeMap = (Map)pushParamMap.get("salaryDataTypeMap");
        HashMap<String, ExchangeRateInfo> exrateCacheMap = new HashMap<String, ExchangeRateInfo>(16);
        String currencyStr = (String)pushParamMap.get("currency");
        Long tarCurrencyId = Long.parseLong(currencyStr);
        String exratetableStr = (String)pushParamMap.get("exratetable");
        Long exratetable = Long.parseLong(exratetableStr);
        String exratedateStr = (String)pushParamMap.get("exratedate");
        Date exratedate = SWCDateTimeUtils.parseDate((String)exratedateStr, (String)"yyyy-MM-dd");
        String startDateStr = (String)pushParamMap.get("startDate");
        String endDateStr = (String)pushParamMap.get("endDate");
        Date startDate = SWCDateTimeUtils.parseDate((String)startDateStr, (String)"yyyy-MM-dd");
        Date endDate = SWCDateTimeUtils.parseDate((String)endDateStr, (String)"yyyy-MM-dd");
        DynamicObject calTable = null;
        DynamicObjectCollection entryList = null;
        DynamicObject entryObj = null;
        HashMap<String, Serializable> tempMap = null;
        ArrayList itemList = null;
        HashMap<String, Object> itemMap = null;
        int seq = 1;
        for (Map.Entry<Long, Map<String, String>> entry : calPersonItemValMap.entrySet()) {
            calTable = calTableMap.get(entry.getKey());
            entryList = calTable.getDynamicObjectCollection("hsas_caltableentry");
            if (entryList == null) {
                entryList = new DynamicObjectCollection();
            }
            tempMap = new HashMap<String, Serializable>(16);
            tempMap.put("calPersonId", entry.getKey());
            itemList = new ArrayList(10);
            tempMap.put("itemList", itemList);
            tempMap.put("success", Boolean.valueOf(true));
            seq = entryList.size() + 1;
            for (Map.Entry<String, String> itemEntry : entry.getValue().entrySet()) {
                String taxItemValue = itemEntry.getValue();
                if (SWCStringUtils.isEmpty((String)taxItemValue)) continue;
                itemMap = new HashMap<String, Object>(16);
                String salaryItemId = (String)taxItemMapperSalaryMap.get(itemEntry.getKey());
                entryObj = entryList.addNew();
                entryObj.set("seq", (Object)seq);
                entryObj.set("salaryitem", (Object)Long.parseLong(salaryItemId));
                entryObj.set("slprorationindex", (Object)0);
                entryObj.set("slstartdate", (Object)startDate);
                entryObj.set("slenddate", (Object)endDate);
                Long dataTypeId = Long.valueOf((String)salaryDataTypeMap.get(salaryItemId));
                itemMap.put("dataType", dataTypeId);
                itemMap.put("salaryItemId", Long.parseLong(salaryItemId));
                itemMap.put("startDate", startDate);
                itemMap.put("endDate", endDate);
                if (dataTypeId == 1020L) {
                    taxItemValue = CalOperationHelper.dealExrateItemValue(taxCurrencyMap.get(entry.getKey()), tarCurrencyId, exratetable, exratedate, taxItemValue, exrateCacheMap);
                    entryObj.set("calamountvalue", (Object)new BigDecimal(taxItemValue));
                    itemMap.put("itemValue", new BigDecimal(taxItemValue));
                } else if (dataTypeId == 1010L) {
                    entryObj.set("numvalue", (Object)new BigDecimal(taxItemValue));
                    itemMap.put("itemValue", new BigDecimal(taxItemValue));
                } else if (dataTypeId == 1030L) {
                    entryObj.set("textvalue", (Object)taxItemValue);
                    itemMap.put("itemValue", taxItemValue);
                } else if (dataTypeId == 1050L) {
                    try {
                        Date date = SWCDateTimeUtils.parseDate((String)taxItemValue);
                        entryObj.set("datevalue", (Object)date);
                        itemMap.put("itemValue", date);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
                itemList.add(itemMap);
                ++seq;
            }
            calTable.set("hsas_caltableentry", (Object)entryList);
            if (!isSyncCal) continue;
            responseMap.put(entry.getKey(), tempMap);
        }
        DynamicObject[] updateCalTableArray = new DynamicObject[calTableMap.size()];
        calTableMap.values().toArray(updateCalTableArray);
        return updateCalTableArray;
    }

    private static Map<Long, DynamicObject> getCalTableData(List<Long> calTableIdList, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        String fields = "id,calpersonid,hsas_caltableentry.seq,hsas_caltableentry.salaryitem,hsas_caltableentry.calamountvalue,hsas_caltableentry.numvalue,hsas_caltableentry.textvalue,hsas_caltableentry.datevalue,hsas_caltableentry.slstartdate,hsas_caltableentry.slenddate,hsas_caltableentry.slprorationindex";
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("caltask", "=", (Object)calTaskId);
        DynamicObject[] calTableArray = helper.query(fields, new QFilter[]{filter});
        return Arrays.asList(calTableArray).stream().collect(Collectors.toMap(obj -> obj.getLong("calpersonid"), obj -> obj));
    }

    private static String dealExrateItemValue(Long oriCurrencyId, Long tarCurrencyId, Long exratetable, Date exrateDate, String taxItemValue, Map<String, ExchangeRateInfo> exrateCacheMap) {
        if (tarCurrencyId.equals(oriCurrencyId)) {
            return taxItemValue;
        }
        String key = tarCurrencyId + "@" + oriCurrencyId;
        ExchangeRateInfo rateInfo = exrateCacheMap.get(key);
        if (rateInfo == null) {
            rateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)oriCurrencyId, (Long)tarCurrencyId, (Long)exratetable, (Date)exrateDate);
        }
        BigDecimal result = new BigDecimal(taxItemValue);
        BigDecimal value = null;
        if (null != rateInfo) {
            exrateCacheMap.put(key, rateInfo);
            value = rateInfo.getQuoteType().booleanValue() ? result.divide(rateInfo.getExchangeRate(), 18, 1) : result.multiply(rateInfo.getExchangeRate());
        } else {
            logger.error("getExrate null,tarCurrencyId={},orgCurId={}", (Object)tarCurrencyId, (Object)oriCurrencyId);
            value = result;
        }
        return value.toPlainString();
    }

    public static void autoCalAfterTax(List<Long> calPersonIdList, long calTaskId, long calRecordId, long calBatchId, boolean resultCheck, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) {
        if (isSyncCal) {
            AfterTaxCalService afterTaxCalService = new AfterTaxCalService();
            afterTaxCalService.autoAfterTaxCal(calTaskId, calRecordId, calBatchId, calPersonIdList, resultCheck, isSyncCal, responseMap);
        } else {
            RequestContext ctx = RequestContext.get();
            ThreadPools.executeOnce((String)"AUTOCALAFTERTAX_POOL_ASYNC", () -> {
                RequestContext.copyAndSet((RequestContext)ctx);
                logger.info("autoCalAfterTax,tranceId={}", (Object)ctx.getTraceId());
                AfterTaxCalService afterTaxCalService = new AfterTaxCalService();
                afterTaxCalService.autoAfterTaxCal(calTaskId, calRecordId, calBatchId, calPersonIdList, resultCheck);
            });
        }
    }

    public static void updateTaxCalProgress(int successCount, int failCount, long calRecordId, long calTaskId) {
        if (successCount == 0 && failCount == 0) {
            return;
        }
        if (CalUtils.isTerminationCal(calRecordId)) {
            return;
        }
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
        CalUtils.updateCalProgress(successCount, failCount, calProgressAppCache, "taxCal", calRecordId);
        boolean isCalFinish = false;
        if (failCount > 0) {
            isCalFinish = CalUtils.updateCalRecord(0, failCount, calRecordId);
        }
        if (isCalFinish) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            CalUtils.releaseCalCacheData(calRecordId);
        }
    }

    public static void addItemCodeToList(String dependOnItems, List<String> itemUniqueCodeList) {
        String[] array;
        if (SWCStringUtils.isEmpty((String)dependOnItems)) {
            return;
        }
        for (String uniqueCode : array = dependOnItems.split(",")) {
            if (itemUniqueCodeList.contains(uniqueCode)) continue;
            itemUniqueCodeList.add(uniqueCode);
        }
    }

    public static Map<String, String> getFuncMap(List<String> uniqueCodeList) {
        HashMap<String, String> fcMap = new HashMap<String, String>(16);
        SWCDataServiceHelper fcHelper = new SWCDataServiceHelper("hsbs_funcdefine");
        QFilter qFilter = new QFilter("uniquecode", "in", uniqueCodeList);
        DynamicObjectCollection fcData = fcHelper.queryOriginalCollection("number,name,funcexp", new QFilter[]{qFilter});
        if (null == fcData || fcData.size() == 0) {
            return fcMap;
        }
        for (DynamicObject fc : fcData) {
            fcMap.put(fc.getString("number"), fc.getString("funcexp"));
        }
        return fcMap;
    }

    private static void dealDataGradeConditon(Map<String, Object> dmMap, QFilter qFilter, SWCDataServiceHelper dmHelper) {
        String orderBy = "conditionentryidentify.seq asc";
        DynamicObjectCollection conditionData = dmHelper.queryOriginalCollection("id,number,name,uniquecode,matchmethod,beyondpolicy,dataround.number,failpolice,conditionentryidentify.conditionitemname,conditionentryidentify.conditionid,conditionentryidentify.conditioncurrency,conditionentryidentify.conditioncurrency.amtprecision,conditionentryidentify.conditionvaltype.number,conditionentryidentify.conditionaccuracy", new QFilter[]{qFilter}, orderBy);
        if (conditionData == null || conditionData.size() == 0) {
            return;
        }
        for (DynamicObject obj : conditionData) {
            Map<String, Integer> currencyMap;
            String valueType;
            Long conditionId;
            HashMap<String, Object> conditionMap;
            ArrayList conditionList;
            String uniquecode = obj.getString("uniquecode");
            HashMap<String, Object> dataMap = (HashMap<String, Object>)dmMap.get(uniquecode);
            String dataType = obj.getString("conditionentryidentify.conditionvaltype.number");
            int scale = 0;
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                scale = obj.getInt("conditionentryidentify.conditioncurrency.amtprecision");
            } else if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                scale = obj.getInt("conditionentryidentify.conditionaccuracy");
            }
            if (dataMap == null || dataMap.size() == 0) {
                dataMap = new HashMap<String, Object>(16);
                dataMap.put("id", obj.getLong("id"));
                dataMap.put("number", obj.getString("number"));
                dataMap.put("name", obj.getString("name"));
                dataMap.put("uniquecode", obj.getString("uniquecode"));
                dataMap.put("matchmethod", obj.getString("matchmethod"));
                dataMap.put("beyondpolicy", obj.getString("beyondpolicy"));
                dataMap.put("dataround", obj.getString("dataround.number"));
                dataMap.put("failpolice", obj.getString("failpolice"));
                conditionList = new ArrayList(10);
                conditionMap = new HashMap(10);
                conditionId = obj.getLong("conditionentryidentify.conditionid");
                conditionMap.put("conditionId", conditionId);
                conditionMap.put("conditionName", obj.getString("conditionentryidentify.conditionitemname"));
                valueType = obj.getString("conditionentryidentify.conditionvaltype.number");
                conditionMap.put("conditionValType", valueType);
                conditionMap.put("conditionCurrencyId", obj.getString("conditionentryidentify.conditioncurrency"));
                conditionMap.put("conditionCurrencyAmtp", scale);
                conditionList.add(conditionMap);
                dataMap.put("conditionList", conditionList);
                if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getCode()) || SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                    currencyMap = (Map)dataMap.get("currencyMap");
                    if (currencyMap == null) {
                        currencyMap = new HashMap(16);
                    }
                    currencyMap.put("condition-" + CalOperationHelper.getValueTypeDesc(valueType) + '-' + conditionId, scale);
                    dataMap.put("currencyMap", currencyMap);
                }
                dmMap.put(uniquecode, dataMap);
                continue;
            }
            conditionList = (ArrayList)dataMap.get("conditionList");
            if (conditionList == null || conditionList.size() == 0) {
                conditionList = new ArrayList(10);
                conditionMap = new HashMap(10);
                conditionId = obj.getLong("conditionentryidentify.conditionid");
                conditionMap.put("conditionId", conditionId);
                conditionMap.put("conditionName", obj.getString("conditionentryidentify.conditionitemname"));
                valueType = obj.getString("conditionentryidentify.conditionvaltype.number");
                conditionMap.put("conditionValType", valueType);
                conditionMap.put("conditionCurrencyId", obj.getString("conditionentryidentify.conditioncurrency"));
                conditionMap.put("conditionCurrencyAmtp", scale);
                conditionList.add(conditionMap);
                dataMap.put("conditionList", conditionList);
                if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getCode()) && !SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) continue;
                currencyMap = (Map)dataMap.get("currencyMap");
                if (currencyMap == null) {
                    currencyMap = new HashMap(16);
                }
                currencyMap.put("condition-" + CalOperationHelper.getValueTypeDesc(valueType) + '-' + conditionId, scale);
                dataMap.put("currencyMap", currencyMap);
                continue;
            }
            conditionMap = new HashMap<String, Object>(16);
            conditionId = obj.getLong("conditionentryidentify.conditionid");
            conditionMap.put("conditionId", conditionId);
            conditionMap.put("conditionName", obj.getString("conditionentryidentify.conditionitemname"));
            valueType = obj.getString("conditionentryidentify.conditionvaltype.number");
            conditionMap.put("conditionValType", valueType);
            conditionMap.put("conditionCurrencyId", obj.getString("conditionentryidentify.conditioncurrency"));
            conditionMap.put("conditionCurrencyAmtp", scale);
            conditionList.add(conditionMap);
            if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getCode()) && !SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) continue;
            currencyMap = (HashMap<String, Integer>)dataMap.get("currencyMap");
            if (currencyMap == null) {
                currencyMap = new HashMap<String, Integer>(16);
            }
            currencyMap.put("condition-" + CalOperationHelper.getValueTypeDesc(valueType) + '-' + conditionId, scale);
            dataMap.put("currencyMap", currencyMap);
        }
    }

    private static String getValueTypeDesc(String number) {
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            return DataGradeValueTypeEnum.DECIMAL.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            return DataGradeValueTypeEnum.AMOUNT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            return DataGradeValueTypeEnum.TEXT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
            return DataGradeValueTypeEnum.INTEGER.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            return DataGradeValueTypeEnum.DATE.getDesc();
        }
        return null;
    }

    private static void dealDataGradeResult(Map<String, Object> dmMap, QFilter qFilter, SWCDataServiceHelper dmHelper) {
        String orderBy = "resultentryidentify.seq asc";
        DynamicObjectCollection resultData = dmHelper.queryOriginalCollection("uniquecode,resultentryidentify.resultitemname,resultentryidentify.resultvaltype.number,resultentryidentify.resultvaltype.id,resultentryidentify.resultaccuracy,resultentryidentify.resultlength,resultentryidentify.resultcurrency.amtprecision,resultentryidentify.resultcurrency.id,resultentryidentify.resultid,resultentryidentify.resultdefaultval", new QFilter[]{qFilter}, orderBy);
        for (DynamicObject obj : resultData) {
            HashMap<String, Object> resultMap;
            String uniquecode = obj.getString("uniquecode");
            Map dataMap = (Map)dmMap.get(uniquecode);
            if (dataMap == null || dataMap.size() == 0) continue;
            ArrayList resultList = (ArrayList)dataMap.get("resultList");
            if (resultList == null || resultList.size() == 0) {
                resultList = new ArrayList(10);
                resultMap = new HashMap(10);
                resultMap.put("resultName", obj.getString("resultentryidentify.resultitemname"));
                resultMap.put("resultValTypeNumber", obj.getString("resultentryidentify.resultvaltype.number"));
                resultMap.put("resultValTypeId", obj.getString("resultentryidentify.resultvaltype.id"));
                resultMap.put("resultAccuracy", obj.getString("resultentryidentify.resultaccuracy"));
                resultMap.put("resultLength", obj.getInt("resultentryidentify.resultlength"));
                resultMap.put("resultCurrencyAmtp", obj.getInt("resultentryidentify.resultcurrency.amtprecision"));
                resultMap.put("resultCurrencyId", obj.getString("resultentryidentify.resultcurrency.id"));
                resultMap.put("resultId", obj.getString("resultentryidentify.resultid"));
                resultMap.put("resultVal", obj.getString("resultentryidentify.resultdefaultval"));
                resultList.add(resultMap);
                dataMap.put("resultList", resultList);
                continue;
            }
            resultMap = new HashMap<String, Object>(16);
            resultMap.put("resultName", obj.getString("resultentryidentify.resultitemname"));
            resultMap.put("resultValTypeNumber", obj.getString("resultentryidentify.resultvaltype.number"));
            resultMap.put("resultValTypeId", obj.getString("resultentryidentify.resultvaltype.id"));
            resultMap.put("resultAccuracy", obj.getString("resultentryidentify.resultaccuracy"));
            resultMap.put("resultLength", obj.getInt("resultentryidentify.resultlength"));
            resultMap.put("resultCurrencyAmtp", obj.getInt("resultentryidentify.resultcurrency.amtprecision"));
            resultMap.put("resultCurrencyId", obj.getString("resultentryidentify.resultcurrency.id"));
            resultMap.put("resultId", obj.getString("resultentryidentify.resultid"));
            resultMap.put("resultVal", obj.getString("resultentryidentify.resultdefaultval"));
            resultList.add(resultMap);
        }
    }

    private static void dealDataGradeData(Map<String, Object> dmMap, QFilter qFilter, SWCDataServiceHelper dmHelper) {
        String orderBy = "dataentry.rownum,dataentry.seq asc";
        DynamicObjectCollection gradeData = dmHelper.queryOriginalCollection("uniquecode,dataentry.rownum,dataentry.fieldid,dataentry.value", new QFilter[]{qFilter}, orderBy);
        HashSet<String> dmCodeSet = new HashSet<String>(16);
        for (DynamicObject obj : gradeData) {
            String value;
            String fieldId;
            HashMap<String, Integer> gradeMap;
            String uniquecode = obj.getString("uniquecode");
            dmCodeSet.add(uniquecode);
            Map dataMap = (Map)dmMap.get(uniquecode);
            if (dataMap == null || dataMap.size() == 0) continue;
            Map currencyMap = (Map)dataMap.get("currencyMap");
            ArrayList<HashMap<String, Integer>> gradeList = (ArrayList<HashMap<String, Integer>>)dataMap.get("gradeList");
            if (gradeList == null || gradeList.size() == 0) {
                gradeList = new ArrayList<HashMap<String, Integer>>(10);
                gradeMap = new HashMap<String, Integer>(10);
                gradeMap.put("rownum", obj.getInt("dataentry.rownum"));
                fieldId = obj.getString("dataentry.fieldid");
                gradeMap.put("fieldid", (Integer)((Object)fieldId));
                value = obj.getString("dataentry.value");
                gradeMap.put("value", (Integer)((Object)CalOperationHelper.setValStr(value, fieldId, currencyMap)));
                gradeList.add(gradeMap);
                dataMap.put("gradeList", gradeList);
                continue;
            }
            gradeMap = new HashMap(10);
            gradeMap.put("rownum", obj.getInt("dataentry.rownum"));
            fieldId = obj.getString("dataentry.fieldid");
            gradeMap.put("fieldid", (Integer)((Object)fieldId));
            value = obj.getString("dataentry.value");
            gradeMap.put("value", (Integer)((Object)CalOperationHelper.setValStr(value, fieldId, currencyMap)));
            gradeList.add(gradeMap);
        }
        for (String dmCode : dmCodeSet) {
            Map dataMap = (Map)dmMap.get(dmCode);
            if (dataMap == null || dataMap.size() == 0) continue;
            List gradeSourceList = (List)dataMap.get("gradeList");
            List<List<Map<String, Object>>> gradeList = DataGradeGroupUtil.groupCollection(gradeSourceList);
            HashMap<String, HashMap<String, Object>> matchSourceMap = new HashMap<String, HashMap<String, Object>>(gradeList.size());
            for (List<Map<String, Object>> row : gradeList) {
                ArrayList<String> conditionValues = new ArrayList<String>(10);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                CalOperationHelper.assembleSingleConditionResult(row, conditionValues, resultMap);
                matchSourceMap.put(String.join((CharSequence)"#", conditionValues), resultMap);
            }
            dataMap.put("matchSourceMap", matchSourceMap);
            HashMap<String, List<Map<String, Object>>> gradeDataMap = new HashMap<String, List<Map<String, Object>>>(16);
            ArrayList<String> conditionIds = new ArrayList<String>(10);
            ArrayList<String> resultIds = new ArrayList<String>(10);
            List<Map<String, Object>> firstGradeList = gradeList.get(0);
            for (Map<String, Object> firstGradeMap : firstGradeList) {
                String fieldId = (String)firstGradeMap.get("fieldid");
                if (!SWCStringUtils.isNotEmpty((String)fieldId)) continue;
                if (fieldId.startsWith("condition-")) {
                    conditionIds.add(fieldId);
                    continue;
                }
                if (!fieldId.startsWith("result-")) continue;
                resultIds.add(fieldId);
            }
            CalOperationHelper.buildDataGradeEntry(gradeSourceList, gradeDataMap, conditionIds);
            dataMap.put("gradeDataMap", gradeDataMap);
            dataMap.put("resultIds", resultIds);
        }
    }

    private static String setValStr(String value, String fieldId, Map<String, Integer> accurencyMap) {
        if (accurencyMap == null || accurencyMap.size() == 0) {
            return value;
        }
        value = value.trim();
        if (fieldId.contains(DataGradeValueTypeEnum.DECIMAL.getDesc()) || fieldId.contains(DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            Integer currency = accurencyMap.get(fieldId);
            if (currency == null) {
                return value;
            }
            BigDecimal decimalVal = new BigDecimal(value);
            return decimalVal.setScale((int)currency, RoundingMode.HALF_UP).toPlainString();
        }
        if (fieldId.contains(DataGradeValueTypeEnum.DATE.getDesc())) {
            try {
                return SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)value), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                logger.error("setValStr_error", (Throwable)e);
            }
        }
        return value;
    }

    private static void buildDataGradeEntry(List<Map<String, Object>> gradeDatas, Map<String, List<Map<String, Object>>> gradeDataMap, List<String> conditionIds) {
        ArrayList gradeDataList = new ArrayList(gradeDatas.size());
        ArrayList<String> conditionIdStrList = new ArrayList<String>(16);
        ArrayList<String> conditionIdOtherList = new ArrayList<String>(16);
        for (String conditionId : conditionIds) {
            if (conditionId.contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
                conditionIdStrList.add(conditionId);
                continue;
            }
            conditionIdOtherList.add(conditionId);
        }
        int preRowNum = 0;
        HashMap<Object, Object> rowMap = new HashMap<Object, Object>(16);
        for (Map<String, Object> map : gradeDatas) {
            int rowNum = (Integer)map.get("rownum");
            if (preRowNum != rowNum) {
                rowMap = new HashMap(16);
                preRowNum = rowNum;
                gradeDataList.add(rowMap);
            }
            String fieldId = (String)map.get("fieldid");
            Object value = map.get("value");
            if (value instanceof String) {
                if (fieldId.contains(DataGradeValueTypeEnum.DATE.getDesc())) {
                    try {
                        rowMap.put(fieldId, SWCDateTimeUtils.parseDate((String)((String)value)));
                    }
                    catch (ParseException e) {
                        logger.info("CalOperationHelper parser Date error!");
                    }
                    continue;
                }
                if (fieldId.contains(DataGradeValueTypeEnum.DECIMAL.getDesc()) || fieldId.contains(DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                    rowMap.put(fieldId, new BigDecimal((String)value));
                    continue;
                }
                rowMap.put(fieldId, value);
                continue;
            }
            rowMap.put(fieldId, value);
        }
        for (Map<String, Object> map : gradeDataList) {
            StringBuilder rowKey = new StringBuilder("###");
            for (String conditionIdStr : conditionIdStrList) {
                rowKey.append('#').append(map.get(conditionIdStr));
            }
            List<Map<String, Object>> dataList = gradeDataMap.get(rowKey.toString());
            if (dataList == null) {
                dataList = new ArrayList<Map<String, Object>>(10);
            }
            dataList.add(map);
            gradeDataMap.put(rowKey.toString(), dataList);
        }
        for (Map.Entry entry : gradeDataMap.entrySet()) {
            CalOperationHelper.sortList((List)entry.getValue(), conditionIdOtherList, "asc");
        }
    }

    public static List<Map<String, Object>> sortList(List<Map<String, Object>> dataList, List<String> arrColList, String order) {
        Comparator comparator = (o1, o2) -> {
            for (String arrCol : arrColList) {
                int compareResult;
                if (arrCol.contains(DataGradeValueTypeEnum.TEXT.getDesc())) continue;
                Object value1 = o1.get(arrCol);
                Object value2 = o2.get(arrCol);
                if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable) || (compareResult = ((Comparable)value1).compareTo((Comparable)value2)) == 0) continue;
                return order.equalsIgnoreCase("asc") ? compareResult : -compareResult;
            }
            return 0;
        };
        Collections.sort(dataList, comparator);
        return dataList;
    }

    private static void assembleSingleConditionResult(List<Map<String, Object>> rows, List<String> conditionValues, Map<String, Object> resultMap) {
        for (Map<String, Object> entry : rows) {
            String fieldId = (String)entry.get("fieldid");
            Object value = entry.get("value");
            String[] split = fieldId.split("-");
            if (SWCStringUtils.equals((String)"condition", (String)split[0])) {
                conditionValues.add(CalOperationHelper.assembleSingleConditionValue(split, value));
            }
            if (!SWCStringUtils.equals((String)"result", (String)split[0])) continue;
            resultMap.put(fieldId, CalOperationHelper.assembleSingleResultValue(split, value));
        }
    }

    private static String assembleSingleConditionValue(String[] split, Object value) {
        String dataType = split[1];
        try {
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) || SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                return new BigDecimal(value + "").stripTrailingZeros().toPlainString();
            }
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                return SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)(value + "")), (String)"yyyy-MM-dd");
            }
            return value + "";
        }
        catch (Exception exception) {
            logger.error("assembleSingleConditionValue_error", (Throwable)exception);
            return "";
        }
    }

    private static Object assembleSingleResultValue(String[] split, Object value) {
        String dataType = split[1];
        try {
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) || SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                return new BigDecimal(value + "");
            }
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                return SWCDateTimeUtils.parseDate((String)(value + ""));
            }
            return value + "";
        }
        catch (Exception exception) {
            logger.error("assembleSingleResultValue_error", (Throwable)exception);
            return "";
        }
    }

    public static Map<String, Object> getDataGradeMap(List<Long> dataGradeVidList) {
        SWCDataServiceHelper dmHelper = new SWCDataServiceHelper("hsas_datagrade");
        HashMap<String, Object> dmMap = new HashMap<String, Object>(16);
        QFilter qFilter = new QFilter("id", "in", dataGradeVidList);
        CalOperationHelper.dealDataGradeConditon(dmMap, qFilter, dmHelper);
        CalOperationHelper.dealDataGradeResult(dmMap, qFilter, dmHelper);
        CalOperationHelper.dealDataGradeData(dmMap, qFilter, dmHelper);
        return dmMap;
    }

    public static void deleteAccData(List<Long> calPersonIdList, Date exRateDate, Long exRateTableId, Long calTaskId) {
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return;
        }
        Map<Long, DynamicObject> accDetailMap = CalOperationHelper.getAccDetailMap(calPersonIdList, calTaskId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String fields = "id,currency,resultvalue,modifier,modifytime,acc.datatype.id";
        QFilter qFilter = new QFilter("id", "in", accDetailMap.keySet());
        DynamicObject[] accResult = helper.query(fields, new QFilter[]{qFilter});
        HashMap<String, ExchangeRateInfo> exRateCacheMap = new HashMap<String, ExchangeRateInfo>(16);
        ArrayList<Long> delAccResultIdList = new ArrayList<Long>(10);
        ArrayList<DynamicObject> updateAccResultObjList = new ArrayList<DynamicObject>(accResult.length);
        for (DynamicObject acc : accResult) {
            BigDecimal resultValue;
            DynamicObject tempAccDetail = accDetailMap.get(acc.getLong("id"));
            if (tempAccDetail == null) continue;
            if (SWCStringUtils.equals((String)tempAccDetail.getString("updatestatus"), (String)"1")) {
                if (BigDecimal.ZERO.compareTo(acc.getBigDecimal("resultvalue")) != 0 || tempAccDetail.getInt("index") != 1) continue;
                delAccResultIdList.add(acc.getLong("id"));
                continue;
            }
            if (BigDecimal.ZERO.compareTo(tempAccDetail.getBigDecimal("currentvalue")) == 0) {
                if (BigDecimal.ZERO.compareTo(acc.getBigDecimal("resultvalue")) != 0 || tempAccDetail.getInt("index") != 1) continue;
                delAccResultIdList.add(acc.getLong("id"));
                continue;
            }
            if (acc.getLong("currency.id") == tempAccDetail.getLong("currency.id") || acc.getLong("acc.datatype.id") == 1010L) {
                resultValue = acc.getBigDecimal("resultvalue").subtract(tempAccDetail.getBigDecimal("currentvalue"));
            } else {
                String key = acc.getLong("currency.id") + "@" + tempAccDetail.getLong("currency.id");
                ExchangeRateInfo rateInfo = (ExchangeRateInfo)exRateCacheMap.get(key);
                if (rateInfo == null) {
                    rateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)tempAccDetail.getLong("currency.id"), (Long)acc.getLong("currency.id"), (Long)exRateTableId, (Date)exRateDate);
                }
                BigDecimal updateValue = CalOperationHelper.dealExchangeRate(exRateCacheMap, tempAccDetail, key, rateInfo);
                resultValue = acc.getBigDecimal("resultvalue").subtract(updateValue);
            }
            if (BigDecimal.ZERO.compareTo(resultValue) == 0 && tempAccDetail.getInt("index") == 1) {
                delAccResultIdList.add(acc.getLong("id"));
                continue;
            }
            acc.set("resultvalue", (Object)resultValue);
            acc.set("modifytime", (Object)new Date());
            acc.set("modifier", (Object)RequestContext.get().getCurrUserId());
            updateAccResultObjList.add(acc);
        }
        if (!SWCListUtils.isEmpty(updateAccResultObjList)) {
            DynamicObject[] updateAccResultArr = new DynamicObject[updateAccResultObjList.size()];
            updateAccResultObjList.toArray(updateAccResultArr);
            helper.update(updateAccResultArr);
        }
        if (!SWCListUtils.isEmpty(delAccResultIdList)) {
            helper.delete(delAccResultIdList.toArray());
        }
        helper.setEntityName("hsas_accdetails");
        QFilter delQFilter = new QFilter("calpersonid", "in", calPersonIdList);
        delQFilter.and("caltask", "=", (Object)calTaskId);
        helper.deleteByFilter(new QFilter[]{delQFilter});
    }

    private static BigDecimal dealExchangeRate(Map<String, ExchangeRateInfo> exrateCacheMap, DynamicObject tempAccDetail, String key, ExchangeRateInfo rateInfo) {
        BigDecimal value;
        if (null != rateInfo) {
            exrateCacheMap.put(key, rateInfo);
            value = rateInfo.getQuoteType().booleanValue() ? tempAccDetail.getBigDecimal("currentvalue").divide(rateInfo.getExchangeRate(), 18, 1) : tempAccDetail.getBigDecimal("currentvalue").multiply(rateInfo.getExchangeRate());
        } else {
            logger.error("deleteAccData method,getExrate null");
            value = tempAccDetail.getBigDecimal("currentvalue");
        }
        return value;
    }

    private static Map<Long, DynamicObject> getAccDetailMap(List<Long> calPersonIdList, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        String fields = "id,accresult.id,calpersonid,initvalue,currentvalue,updatestatus,currency.id,index";
        QFilter qFilter = new QFilter("calpersonid", "in", calPersonIdList);
        qFilter.and("caltask", "=", (Object)calTaskId);
        DynamicObjectCollection accDetailData = helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        return accDetailData.stream().collect(Collectors.toMap(data -> data.getLong("accresult.id"), data -> data, (v1, v2) -> v1));
    }

    public static DynamicObjectCollection getSalaryTaxFileRelData(Set<Long> salaryFileIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        QFilter qFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        qFilter.and("status", "=", (Object)"C");
        logger.info("query salarytaxfilerel begin");
        DynamicObjectCollection list = helper.queryOriginalCollection("salaryfile.id,taxfile", new QFilter[]{qFilter});
        logger.info("query salarytaxfilerel end");
        return list;
    }

    public static void putTempDataToResponse(Map<Long, Map<String, Object>> tempResponseMap, Map<Long, Map<String, Object>> responseMap, boolean isSuccess, String msg, List<Long> calPersonIdList) {
        Map<String, Object> tempMap = null;
        if (!isSuccess) {
            for (Long calPersonId : calPersonIdList) {
                tempMap = responseMap.get(calPersonId);
                if (tempMap == null) {
                    tempMap = new HashMap<String, Object>(5);
                    tempMap.put("calPersonId", calPersonId);
                    tempMap.put("itemList", null);
                    tempMap.put("status", 400);
                    responseMap.put(calPersonId, tempMap);
                }
                tempMap.put("success", false);
                tempMap.put("message", msg);
                if (tempMap.get("itemList") == null) continue;
                tempMap.put("status", 100);
            }
            return;
        }
        for (Map.Entry<Long, Map<String, Object>> entry : tempResponseMap.entrySet()) {
            tempMap = responseMap.get(entry.getKey());
            if (tempMap == null) {
                responseMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (((Boolean)entry.getValue().get("success")).booleanValue()) {
                ArrayList itemList = (ArrayList)tempMap.get("itemList");
                if (itemList == null) {
                    itemList = new ArrayList();
                }
                itemList.addAll((List)entry.getValue().get("itemList"));
                tempMap.put("itemList", itemList);
                continue;
            }
            tempMap.put("success", false);
            tempMap.put("message", entry.getValue().get("message"));
            tempMap.put("status", 100);
        }
    }
}

