/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.helper;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.salaryitem.filter.GetValidSalaryItemInSalaryFileService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalValidSalaryItemHelper {
    private static final Log logger = LogFactory.getLog(CalValidSalaryItemHelper.class);
    private String traceId;
    private List<Long> calPersonIdList;
    private Long calTaskId;
    private String calType;

    public CalValidSalaryItemHelper(List<Long> calPersonIdList, String calTaskIdStr, String calTypeEnum, String traceId) {
        this.calPersonIdList = calPersonIdList;
        this.traceId = traceId;
        if (SWCStringUtils.isNotEmpty((String)calTaskIdStr)) {
            this.calTaskId = Long.parseLong(calTaskIdStr);
        }
        if (SWCStringUtils.isNotEmpty((String)calTypeEnum)) {
            this.calType = calTypeEnum;
        }
    }

    public HashMap<Long, HashSet<String>> getCalPersonAndRelationSIUniqueCodeMap() {
        logger.info("getValidSalaryItemMap before CalculateThreadTask,traceId={}", (Object)this.traceId);
        HashMap<String, Object> calTaskInfoMap = this.getCalTaskInfoMap();
        if (calTaskInfoMap.isEmpty()) {
            return new HashMap<Long, HashSet<String>>(0);
        }
        HashMap<Long, Long> calPersonAndFileMap = this.getCalPersonAndFileMap(this.calPersonIdList);
        if (calPersonAndFileMap.isEmpty()) {
            return new HashMap<Long, HashSet<String>>(0);
        }
        Collection<Long> validSalaryFileIdList = calPersonAndFileMap.values();
        Date calStartDate = (Date)calTaskInfoMap.get("calStartDate");
        Date calEndDate = (Date)calTaskInfoMap.get("calEndDate");
        HashSet salaryItemIDInCalRuleSet = (HashSet)calTaskInfoMap.get("salaryItemIDInCalRule");
        Map validSalaryItemMap = GetValidSalaryItemInSalaryFileService.createInstance().getValidSalaryItemMap(validSalaryFileIdList, calStartDate, calEndDate, salaryItemIDInCalRuleSet);
        HashSet<Long> sumSalaryItemIdSet = new HashSet<Long>(validSalaryItemMap.size());
        validSalaryItemMap.values().forEach(sumSalaryItemIdSet::addAll);
        HashSet<Long> preTaxSalaryItemIdSet = new HashSet<Long>(16);
        HashSet<Long> afterTaxSalaryItemIdSet = new HashSet<Long>(16);
        Map<Long, String> salaryItemUniqueCodeMap = this.getSumSalaryItemUniqueCodeMap(sumSalaryItemIdSet, preTaxSalaryItemIdSet, afterTaxSalaryItemIdSet);
        HashMap<Long, HashSet<String>> calPersonAndRelationSIUniqueCodeMap = new HashMap<Long, HashSet<String>>(validSalaryItemMap.size());
        for (Map.Entry<Long, Long> entry : calPersonAndFileMap.entrySet()) {
            HashSet salaryItemIdSet;
            block6: {
                block7: {
                    salaryItemIdSet = validSalaryItemMap.computeIfAbsent(entry.getValue(), key -> new HashSet());
                    if (!"preTaxCal".equals(this.calType)) break block6;
                    if (salaryItemIdSet.isEmpty()) break block7;
                    if (salaryItemIdSet.stream().noneMatch(preTaxSalaryItemIdSet::contains)) break block7;
                    if (!salaryItemIdSet.stream().noneMatch(afterTaxSalaryItemIdSet::contains)) break block6;
                }
                calPersonAndRelationSIUniqueCodeMap.put(entry.getKey(), new HashSet(0));
                continue;
            }
            HashSet uniqueCodeSet = salaryItemIdSet.stream().map(salaryItemUniqueCodeMap::get).collect(Collectors.toCollection(HashSet::new));
            calPersonAndRelationSIUniqueCodeMap.put(entry.getKey(), uniqueCodeSet);
        }
        return calPersonAndRelationSIUniqueCodeMap;
    }

    private HashMap<String, Object> getCalTaskInfoMap() {
        if (this.calTaskId == null) {
            return new HashMap<String, Object>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter calTaskFilter = new QFilter("id", "=", (Object)this.calTaskId);
        DynamicObject calTaskData = helper.queryOriginalOne("id,period.id,period.startdate,period.enddate,calrulev.id", new QFilter[]{calTaskFilter}, "");
        if (SWCObjectUtils.isEmpty((Object)calTaskData) || calTaskData.getLong("period.id") == 0L || calTaskData.getLong("calrulev.id") == 0L) {
            return new HashMap<String, Object>(0);
        }
        logger.info("queryCaltask end");
        SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_calrule");
        QFilter calRuleVFilter = new QFilter("id", "=", (Object)calTaskData.getLong("calrulev.id"));
        DynamicObjectCollection calRuleInfoCol = calHelper.queryOriginalCollection("calruleitementry.salaryitem.id", new QFilter[]{calRuleVFilter}, "");
        logger.info("queryCalRuleInfoCol end");
        if (SWCObjectUtils.isEmpty((Object)calRuleInfoCol)) {
            return new HashMap<String, Object>(0);
        }
        Set salaryItemIDInCalRuleSet = calRuleInfoCol.stream().map(calRuleItem -> calRuleItem.getLong("calruleitementry.salaryitem.id")).collect(Collectors.toCollection(HashSet::new));
        HashMap<String, Object> calTaskInfoMap = new HashMap<String, Object>(16);
        calTaskInfoMap.put("calStartDate", calTaskData.getDate("period.startdate"));
        calTaskInfoMap.put("calEndDate", calTaskData.getDate("period.enddate"));
        calTaskInfoMap.put("salaryItemIDInCalRule", salaryItemIDInCalRuleSet);
        return calTaskInfoMap;
    }

    private HashMap<Long, Long> getCalPersonAndFileMap(List<Long> calPersonIdList) {
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return new HashMap<Long, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("id", "in", calPersonIdList);
        DynamicObjectCollection calPersonDataColl = helper.queryOriginalCollection("id,salaryfile.id", new QFilter[]{calPersonFilter});
        if (SWCObjectUtils.isEmpty((Object)calPersonDataColl)) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> calPersonAndFileMap = new HashMap<Long, Long>(calPersonDataColl.size());
        calPersonDataColl.forEach(calPersonData -> calPersonAndFileMap.put(calPersonData.getLong("id"), calPersonData.getLong("salaryfile.id")));
        return calPersonAndFileMap;
    }

    private Map<Long, String> getSumSalaryItemUniqueCodeMap(HashSet<Long> sumSalaryItemIdSet, HashSet<Long> preTaxSalaryItemIdSet, HashSet<Long> afterTaxSalaryItemIdSet) {
        if (sumSalaryItemIdSet == null || sumSalaryItemIdSet.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter filter = new QFilter("id", "in", sumSalaryItemIdSet);
        String selectFields = "preTaxCal".equals(this.calType) ? "id,uniquecode,calblock" : "id,uniquecode";
        DynamicObjectCollection salaryItemColl = helper.queryOriginalCollection(selectFields, new QFilter[]{filter});
        if (SWCObjectUtils.isEmpty((Object)salaryItemColl)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> salaryItemUniqueCodeMap = new HashMap<Long, String>();
        for (DynamicObject salaryItemData : salaryItemColl) {
            String uniqueCode = salaryItemData.getString("uniquecode");
            if (SWCStringUtils.isNotEmpty((String)uniqueCode)) {
                uniqueCode = uniqueCode.replace('.', '_').replace('-', '_');
                salaryItemUniqueCodeMap.put(salaryItemData.getLong("id"), uniqueCode);
            }
            if (!"preTaxCal".equals(this.calType)) continue;
            if ("0".equals(salaryItemData.getString("calblock"))) {
                preTaxSalaryItemIdSet.add(salaryItemData.getLong("id"));
                continue;
            }
            if (!"1".equals(salaryItemData.getString("calblock"))) continue;
            afterTaxSalaryItemIdSet.add(salaryItemData.getLong("id"));
        }
        return salaryItemUniqueCodeMap;
    }
}

