/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalRuleDataSourceEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.common.vo.CalConvertVO;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.FormulaVO;
import kd.swc.hscs.common.vo.InsuranceItemMapping;
import kd.swc.hscs.common.vo.ProrationRuleVO;
import org.apache.commons.collections.CollectionUtils;

public class HandleCalParamsHelper {
    private static final Log logger = LogFactory.getLog(HandleCalParamsHelper.class);
    private static final String[] DATATYPEARRAY = new String[]{"1", "2"};

    public static void dealCalRuleDataAndCacheCalParam(CalParamCacheInfo calParamCacheInfo, Long calRuleVid, String calVersionNo, long countryId, long orgId) {
        logger.info("dealCalRuleDataAndCacheCalParam start\uff0ccalVersionNo={},calType={}", (Object)calVersionNo, (Object)calParamCacheInfo.getCalType());
        DynamicObjectCollection calRuleData = HandleCalParamsHelper.getCalRuleHisData(calRuleVid, calParamCacheInfo.getCalType());
        ArrayList<String> needSaveSalaryItemList = new ArrayList<String>(10);
        ArrayList<String> insuranaceSalaryItemList = new ArrayList<String>(10);
        LinkedHashMap<Long, FormulaVO> formulaMap = new LinkedHashMap<Long, FormulaVO>(16);
        HashMap<Long, List<String>> ruleSlItemRelMap = new HashMap<Long, List<String>>(16);
        HashSet<Long> formulaIdSet = new HashSet<Long>(calRuleData.size());
        ArrayList<String> salaryItemIdList = new ArrayList<String>(16);
        ArrayList<String> calRuleItemIdList = new ArrayList<String>(calRuleData.size());
        HashMap<String, Long> formulaItemRelMap = new HashMap<String, Long>(calRuleData.size());
        FormulaVO formulaInfo = null;
        Long salaryItemId = null;
        for (DynamicObject entry : calRuleData) {
            salaryItemId = entry.getLong("calruleitementry.salaryitem.id");
            String slUniqueCode = entry.getString("calruleitementry.salaryitem.uniquecode");
            String dataSource = entry.getString("calruleitementry.datasource");
            calRuleItemIdList.add(String.valueOf(salaryItemId));
            formulaInfo = new FormulaVO();
            formulaInfo.setSalaryItemUniuqeCode(slUniqueCode);
            formulaInfo.setCalBlock(entry.getString("calruleitementry.salaryitem.calblock"));
            formulaMap.put(salaryItemId, formulaInfo);
            if (CalRuleDataSourceEnum.FORMULA.getCode().equals(dataSource)) {
                needSaveSalaryItemList.add(slUniqueCode);
                formulaItemRelMap.put(slUniqueCode, entry.getLong("calruleitementry.formula.id"));
                salaryItemIdList.add(String.valueOf(salaryItemId));
                formulaIdSet.add(entry.getLong("calruleitementry.formula.id"));
                HandleCalParamsHelper.addDataToRuleRelMap(entry, ruleSlItemRelMap);
                continue;
            }
            if (CalRuleDataSourceEnum.RESULTCOVER.getCode().equals(dataSource)) {
                needSaveSalaryItemList.add(slUniqueCode);
                HandleCalParamsHelper.setFormulaExcuteExp(formulaInfo, entry);
                continue;
            }
            if (!CalRuleDataSourceEnum.INSURANCECLOUDSERVICE.getCode().equals(dataSource)) continue;
            needSaveSalaryItemList.add(slUniqueCode);
            insuranaceSalaryItemList.add(slUniqueCode);
            HandleCalParamsHelper.setFormulaExcuteExp(formulaInfo, entry);
        }
        calParamCacheInfo.setNeedSaveSalaryItemList(needSaveSalaryItemList);
        calParamCacheInfo.setFormulaItemRelMap(formulaItemRelMap);
        calParamCacheInfo.setSalaryItemIdList(salaryItemIdList);
        calParamCacheInfo.setCalRuleItemIdList(calRuleItemIdList);
        HandleCalParamsHelper.handleInsuranceData(calParamCacheInfo, countryId, orgId, insuranaceSalaryItemList);
        List<Long> dataGradeVidList = null;
        HashSet<Long> formulaVidList = new HashSet(formulaIdSet.size());
        if (SWCStringUtils.isNotEmpty((String)calVersionNo)) {
            DynamicObjectCollection calVersionData = HandleCalParamsHelper.getCalVersionData(calVersionNo, calRuleVid, formulaIdSet);
            dataGradeVidList = calVersionData.stream().filter(obj -> obj.getLong("datagradev.id") != 0L).map(obj -> obj.getLong("datagradev.id")).collect(Collectors.toList());
            formulaVidList = calVersionData.stream().map(obj -> obj.getLong("formulav.id")).collect(Collectors.toSet());
        } else {
            String field = "id,dependondatagrade,boid";
            List<DynamicObject> formulaData = HandleCalParamsHelper.getFormulaDataForConvert(calParamCacheInfo, formulaIdSet, field);
            ArrayList<String> dmUniqueCodeSet = new ArrayList<String>(10);
            for (DynamicObject obj2 : formulaData) {
                formulaVidList.add(obj2.getLong("id"));
                CalOperationHelper.addItemCodeToList(obj2.getString("dependondatagrade"), dmUniqueCodeSet);
            }
            dataGradeVidList = HandleCalParamsHelper.getDataGradeVersionIdList(dmUniqueCodeSet, calParamCacheInfo);
        }
        HandleCalParamsHelper.setFormulaInfo(formulaMap, calParamCacheInfo, formulaVidList, dataGradeVidList);
        HandleCalParamsHelper.handleProrationRuleData(calParamCacheInfo, ruleSlItemRelMap);
        logger.info("dealCalRuleDataAndCacheCalParam end");
    }

    private static void addDataToRuleRelMap(DynamicObject entry, Map<Long, List<String>> ruleSlItemRelMap) {
        if (!"2".equals(entry.getString("calruleitementry.isconvert"))) {
            return;
        }
        List<String> tempItemIdList = ruleSlItemRelMap.get(entry.getLong("calruleitementry.customprorationrule.id"));
        if (tempItemIdList == null) {
            tempItemIdList = new ArrayList<String>(10);
            ruleSlItemRelMap.put(entry.getLong("calruleitementry.customprorationrule.id"), tempItemIdList);
        }
        tempItemIdList.add(entry.getString("calruleitementry.salaryitem.uniquecode"));
    }

    private static void handleProrationRuleData(CalParamCacheInfo calParamCacheInfo, Map<Long, List<String>> ruleSlItemRelMap) {
        logger.info("handleProrationRuleData begin");
        if (!"1".equals(calParamCacheInfo.getProrationCal()) || ruleSlItemRelMap.size() == 0) {
            return;
        }
        CalConvertVO calConvert = new CalConvertVO();
        DynamicObjectCollection ruleResult = HandleCalParamsHelper.getProrationRuleData(calParamCacheInfo, ruleSlItemRelMap);
        HashSet<Long> formulaIdSet = new HashSet<Long>(16);
        List<ProrationRuleVO> ruleList = HandleCalParamsHelper.getRuleList(ruleSlItemRelMap, ruleResult, formulaIdSet);
        calConvert.setProrationRuleList(ruleList);
        String field = "id,boid,executeexp,dependonfunc,dependonbsitem,dependonftitem,name,number,dependondatagrade,bsitemprop";
        List<DynamicObject> formulaData = HandleCalParamsHelper.getFormulaDataForConvert(calParamCacheInfo, formulaIdSet, field);
        ArrayList<String> fcUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> bsUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> bsPropUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> fetchItemCodeList = new ArrayList<String>(10);
        ArrayList<String> dmUniqueCodeSet = new ArrayList<String>(10);
        HashMap<String, Map<String, String>> itemRelationMap = new HashMap<String, Map<String, String>>(formulaData.size());
        ArrayList<FormulaVO> convertFormulaList = new ArrayList<FormulaVO>(formulaData.size());
        FormulaVO formulaObj = null;
        for (DynamicObject formulaTemp : formulaData) {
            formulaObj = new FormulaVO();
            formulaObj.setName(formulaTemp.getString("name"));
            formulaObj.setExecuteCode(formulaTemp.getString("executeexp"));
            convertFormulaList.add(formulaObj);
            String formulaIdStr = String.valueOf(formulaTemp.getLong("boid"));
            HandleCalParamsHelper.handleItemData(bsUniqueCodeList, itemRelationMap, formulaTemp.getString("dependonbsitem"), formulaIdStr, "BS");
            HandleCalParamsHelper.handleItemData(fetchItemCodeList, itemRelationMap, formulaTemp.getString("dependonftitem"), formulaIdStr, "FT");
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("dependonfunc"), fcUniqueCodeList);
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("dependondatagrade"), dmUniqueCodeSet);
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("bsitemprop"), bsPropUniqueCodeList);
        }
        Map<String, String> fcMap = CalOperationHelper.getFuncMap(fcUniqueCodeList);
        List<Long> dataGradeVidList = HandleCalParamsHelper.getDataGradeVersionIdList(dmUniqueCodeSet, calParamCacheInfo);
        if (CollectionUtils.isNotEmpty(dataGradeVidList)) {
            Map<String, Object> dmMap = CalOperationHelper.getDataGradeMap(dataGradeVidList);
            calConvert.setDmMap(dmMap);
        }
        calConvert.setFormulaList(convertFormulaList);
        calConvert.setFcMap(fcMap);
        calConvert.setItemRelationMap(itemRelationMap);
        calConvert.setBsUniqueCodeList(bsUniqueCodeList);
        calConvert.setFetchItemCodeList(fetchItemCodeList);
        calParamCacheInfo.setCalConvert(calConvert);
        calParamCacheInfo.setBsUniqueCodeList(HandleCalParamsHelper.filterRepeatDataAndAdd(calParamCacheInfo.getBsUniqueCodeList(), bsUniqueCodeList));
        calParamCacheInfo.setFetchItemCodeList(HandleCalParamsHelper.filterRepeatDataAndAdd(calParamCacheInfo.getFetchItemCodeList(), fetchItemCodeList));
        calParamCacheInfo.setBsPropUniqueCodeList(HandleCalParamsHelper.filterRepeatDataAndAdd(calParamCacheInfo.getBsPropUniqueCodeList(), bsPropUniqueCodeList));
        logger.info("handleProrationRuleData end");
    }

    private static List<String> filterRepeatDataAndAdd(List<String> uniqueCodeList, List<String> codeList) {
        if (SWCListUtils.isEmpty(codeList)) {
            return uniqueCodeList;
        }
        if (SWCListUtils.isEmpty(uniqueCodeList)) {
            return codeList;
        }
        codeList.forEach(obj -> {
            if (!uniqueCodeList.contains(obj)) {
                uniqueCodeList.add((String)obj);
            }
        });
        return uniqueCodeList;
    }

    private static List<Long> getDataGradeVersionIdList(List<String> dmUniqueCodeSet, CalParamCacheInfo calParamCacheInfo) {
        if (SWCListUtils.isEmpty(dmUniqueCodeSet)) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_datagrade");
        QFilter qFilter = new QFilter("uniquecode", "in", dmUniqueCodeSet);
        HandleCalParamsHelper.addHisVerFilter(calParamCacheInfo, qFilter);
        DynamicObjectCollection result = helper.queryOriginalCollection("id,boid", new QFilter[]{qFilter}, "boid asc,bsed desc");
        HashMap<Long, Long> dataGradeMap = new HashMap<Long, Long>(result.size());
        for (DynamicObject grade : result) {
            if (dataGradeMap.containsKey(grade.getLong("boid"))) continue;
            dataGradeMap.put(grade.getLong("boid"), grade.getLong("id"));
        }
        return dataGradeMap.values().stream().collect(Collectors.toList());
    }

    private static void addHisVerFilter(CalParamCacheInfo calParamCacheInfo, QFilter qFilter) {
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        qFilter.and("bsed", "<=", (Object)calParamCacheInfo.getEndDate());
        qFilter.and("bsled", ">=", (Object)calParamCacheInfo.getStartDate());
        qFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
    }

    private static List<ProrationRuleVO> getRuleList(Map<Long, List<String>> ruleSlItemRelMap, DynamicObjectCollection ruleResult, Set<Long> formulaIdSet) {
        HashSet<Long> ruleIdSet = new HashSet<Long>(ruleResult.size());
        ProrationRuleVO ruleVO = null;
        ArrayList<ProrationRuleVO> ruleList = new ArrayList<ProrationRuleVO>(10);
        for (DynamicObject rule : ruleResult) {
            if (ruleIdSet.contains(rule.getLong("boid"))) continue;
            ruleIdSet.add(rule.getLong("boid"));
            formulaIdSet.add(rule.getLong("numerator.id"));
            formulaIdSet.add(rule.getLong("denominator.id"));
            for (String slUniqueCode : ruleSlItemRelMap.get(rule.getLong("boid"))) {
                ruleVO = new ProrationRuleVO();
                ruleVO.setSlUniqueCode(slUniqueCode);
                ruleVO.setRuleId(Long.valueOf(rule.getLong("boid")));
                ruleVO.setDenominatorId(Long.valueOf(rule.getLong("denominator.id")));
                ruleVO.setNumeratorId(Long.valueOf(rule.getLong("numerator.id")));
                ruleVO.setDataPrecisionId(Long.valueOf(rule.getLong("dataprecision.id")));
                ruleVO.setDataRoundId(Long.valueOf(rule.getLong("dataround.id")));
                ruleList.add(ruleVO);
            }
        }
        return ruleList;
    }

    private static List<DynamicObject> getFormulaDataForConvert(CalParamCacheInfo calParamCacheInfo, Set<Long> formulaIdSet, String field) {
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        QFilter qFilter = new QFilter("boid", "in", formulaIdSet);
        HandleCalParamsHelper.addHisVerFilter(calParamCacheInfo, qFilter);
        DynamicObjectCollection resultData = formulaHelper.queryOriginalCollection(field, new QFilter[]{qFilter}, "boid asc,bsed desc");
        HashMap<Long, DynamicObject> formulaMap = new HashMap<Long, DynamicObject>(resultData.size());
        for (DynamicObject formula : resultData) {
            if (formulaMap.containsKey(formula.getLong("boid"))) continue;
            formulaMap.put(formula.getLong("boid"), formula);
        }
        return formulaMap.values().stream().collect(Collectors.toList());
    }

    private static DynamicObjectCollection getProrationRuleData(CalParamCacheInfo calParamCacheInfo, Map<Long, List<String>> ruleSlItemRelMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationrule");
        QFilter filter = new QFilter("boid", "in", ruleSlItemRelMap.keySet());
        HandleCalParamsHelper.addHisVerFilter(calParamCacheInfo, filter);
        String fields = "id,boid,numerator.id,denominator.id,dataprecision.id,dataround.id";
        return helper.queryOriginalCollection(fields, new QFilter[]{filter}, "boid asc,bsed desc");
    }

    private static void handleInsuranceData(CalParamCacheInfo calParamCacheInfo, long countryId, long orgId, List<String> insuranaceSalaryItemList) {
        HashMap<String, InsuranceItemMapping> insuranceItemMap = new HashMap<String, InsuranceItemMapping>(insuranaceSalaryItemList.size());
        HandleCalParamsHelper.queryInsuranceRelation(countryId, orgId, insuranaceSalaryItemList, insuranceItemMap);
        calParamCacheInfo.setInsuranceItemMap(insuranceItemMap);
    }

    private static void queryInsuranceRelation(long countryId, long orgId, List<String> insuranaceSalaryItemList, Map<String, InsuranceItemMapping> insuranceItemMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_insurproscheme");
        QFilter qFilter = new QFilter("country.id", "=", (Object)countryId).and("org.id", "=", (Object)orgId).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject scheme = helper.queryOne("entityentity.withholdtype,entityentity.insuranceitem,entityentity.salaryitem,entityentity.salaryitem.id,entityentity.salaryitem.uniquecode,entityentity.dealmethod", qFilter.toArray());
        if (scheme == null) {
            return;
        }
        DynamicObjectCollection entitys = scheme.getDynamicObjectCollection("entityentity");
        Map<String, DynamicObject> insuranceitemMap = entitys.stream().collect(Collectors.toMap(obj -> obj.getString("salaryitem.uniquecode"), obj -> obj, (key1, key2) -> key1));
        for (String unicode : insuranaceSalaryItemList) {
            DynamicObject entry = insuranceitemMap.get(unicode);
            if (entry == null) continue;
            long insuranceitemId = entry.getLong("insuranceitem");
            String dealmethod = entry.getString("dealmethod");
            String withholdtype = entry.getString("withholdtype");
            InsuranceItemMapping map = new InsuranceItemMapping();
            map.setUnicode(unicode);
            map.setInsuranceItemId(Long.valueOf(insuranceitemId));
            map.setMethod(dealmethod);
            map.setWithholdtype(withholdtype);
            map.setSalaryItemId(Long.valueOf(entry.getLong("salaryitem.id")));
            insuranceItemMap.put(unicode, map);
        }
    }

    private static void setFormulaExcuteExp(FormulaVO formulaInfo, DynamicObject entry) {
        long dataTypeId = entry.getLong("calruleitementry.salaryitem.datatype.id");
        String uniqueCode = entry.getString("calruleitementry.salaryitem.uniquecode");
        if (dataTypeId == DataTypeEnum.AMOUNT.getDbId() || dataTypeId == DataTypeEnum.NUMBERIC.getDbId()) {
            formulaInfo.setExecuteCode(String.format(Locale.ROOT, " updateAccValueForResultCover(\"%s\");", uniqueCode));
        }
    }

    private static DynamicObjectCollection getCalRuleHisData(long calRuleVid, String calType) {
        QFilter qFilter = new QFilter("id", "=", (Object)calRuleVid);
        if (SWCStringUtils.equals((String)calType, (String)"afterTaxCal")) {
            qFilter.and("calruleitementry.salaryitem.calblock", "=", (Object)"1");
        } else if (SWCStringUtils.equals((String)calType, (String)"preTaxCal") || SWCStringUtils.equals((String)calType, (String)"onlyPreTaxCal")) {
            qFilter.and("calruleitementry.salaryitem.calblock", "=", (Object)"0");
        }
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        String fields = "name,calruleitementry.formula.id,calruleitementry.datasource,calruleitementry.isconvert,calruleitementry.customprorationrule.id,calruleitementry.salaryitem.id,calruleitementry.seq,calruleitementry.salaryitem.uniquecode,calruleitementry.salaryitem.name,calruleitementry.salaryitem.calblock,calruleitementry.salaryitem.datatype.id";
        DynamicObjectCollection calRuleHisData = calRuleHisHelper.queryOriginalCollection(fields, new QFilter[]{qFilter}, "calruleitementry.salaryitem.calblock asc,calruleitementry.seq asc");
        return calRuleHisData;
    }

    private static void setFormulaInfo(Map<Long, FormulaVO> formulaMap, CalParamCacheInfo calParamCacheInfo, Set<Long> formulaVidSet, List<Long> dataGradeVidList) {
        DynamicObject[] formulaArray;
        ArrayList<String> spUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> slUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> fcUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> bsUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> bsPropUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> fetchItemCodeList = new ArrayList<String>(10);
        ArrayList<String> accUniqueCodeList = new ArrayList<String>(10);
        HashMap<String, Map<String, String>> itemRelationMap = new HashMap<String, Map<String, String>>(formulaVidSet.size());
        HashMap<String, List<String>> slItemRelMap = new HashMap<String, List<String>>(formulaVidSet.size());
        FormulaVO formulaObj = null;
        for (DynamicObject formulaTemp : formulaArray = HandleCalParamsHelper.getFormulaData(formulaVidSet)) {
            formulaObj = formulaMap.get(formulaTemp.getLong("salaryitem.id"));
            formulaObj.setName(formulaTemp.getString("name"));
            formulaObj.setExecuteCode(formulaTemp.getString("executeexp"));
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("dependonsitem"), slUniqueCodeList);
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("dependonspitem"), spUniqueCodeList);
            HandleCalParamsHelper.handleItemData(bsUniqueCodeList, itemRelationMap, formulaTemp.getString("dependonbsitem"), formulaObj.getSalaryItemUniuqeCode(), "BS");
            HandleCalParamsHelper.handleItemData(fetchItemCodeList, itemRelationMap, formulaTemp.getString("dependonftitem"), formulaObj.getSalaryItemUniuqeCode(), "FT");
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("dependonfunc"), fcUniqueCodeList);
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("dependonacc"), accUniqueCodeList);
            CalOperationHelper.addItemCodeToList(formulaTemp.getString("bsitemprop"), bsPropUniqueCodeList);
            if (!SWCStringUtils.isNotEmpty((String)formulaTemp.getString("dependonsitem"))) continue;
            slItemRelMap.put(formulaTemp.getString("salaryitem.uniquecode"), Arrays.asList(formulaTemp.getString("dependonsitem").split(",")));
        }
        Map<String, String> fcMap = CalOperationHelper.getFuncMap(fcUniqueCodeList);
        Map<String, Object> dmMap = null;
        if (CollectionUtils.isNotEmpty(dataGradeVidList)) {
            dmMap = CalOperationHelper.getDataGradeMap(dataGradeVidList);
        }
        calParamCacheInfo.setFormulaList(formulaMap.values().stream().collect(Collectors.toList()));
        calParamCacheInfo.setFcMap(fcMap);
        calParamCacheInfo.setDmMap(dmMap);
        calParamCacheInfo.setSlUniqueCodeList(slUniqueCodeList);
        calParamCacheInfo.setBsUniqueCodeList(bsUniqueCodeList);
        calParamCacheInfo.setSpUniqueCodeList(spUniqueCodeList);
        calParamCacheInfo.setFetchItemCodeList(fetchItemCodeList);
        calParamCacheInfo.setAccUniqueCodeList(accUniqueCodeList);
        calParamCacheInfo.setBsPropUniqueCodeList(bsPropUniqueCodeList);
        calParamCacheInfo.setItemRelationMap(itemRelationMap);
        calParamCacheInfo.setSlItemRelMap(slItemRelMap);
    }

    private static void handleItemData(List<String> uniqueCodeList, Map<String, Map<String, String>> itemRelationMap, String itemStr, String slUniqueCode, String itemType) {
        if (SWCStringUtils.isEmpty((String)itemStr)) {
            return;
        }
        CalOperationHelper.addItemCodeToList(itemStr, uniqueCodeList);
        Map<String, String> itemMap = itemRelationMap.get(itemType);
        if (null == itemMap) {
            itemMap = new HashMap<String, String>(3);
            itemRelationMap.put(itemType, itemMap);
        }
        itemMap.put(slUniqueCode, itemStr);
    }

    private static DynamicObject[] getFormulaData(Set<Long> formulaVidSet) {
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        String fields = "id,executeexp,dependonfunc,dependonsitem,dependonacc,dependonbsitem,dependonspitem,dependonftitem,name,number,salaryitem.id,salaryitem.uniquecode,dependondatagrade,bsitemprop";
        DynamicObject[] formulaArray = formulaHelper.queryOriginalArray(fields, new QFilter[]{new QFilter("id", "in", formulaVidSet)});
        return formulaArray;
    }

    private static DynamicObjectCollection getCalVersionData(String calVersionNo, Long calRuleVid, Set<Long> formulaIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calversion");
        QFilter filter = new QFilter("calversionno", "=", (Object)calVersionNo);
        filter.and("calrulev.id", "=", (Object)calRuleVid);
        filter.and("datatype", "in", (Object)DATATYPEARRAY);
        filter.and("formulav.boid", "in", formulaIdSet);
        String selectFields = "calversionno,formulav.id,datagradev.id";
        return helper.queryOriginalCollection(selectFields, new QFilter[]{filter});
    }
}

