/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalConvertVO;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.ProrationRuleVO;

public class HandleCalProrationHelper {
    private static final Log logger = LogFactory.getLog(HandleCalProrationHelper.class);
    private CalParamVO calParamVO;
    private List<Long> calPersonIdList;
    private Map<Long, Map<String, List<String>>> itemSectionMap;
    private Map<Long, Map<String, List<String>>> ftItemProrateRangeQueryMap;
    private Map<Long, Map<String, List<String>>> bsItemProrateRangeQueryMap;
    private Map<Long, Map<String, List<String>>> calConvertSectionMap;
    private Map<Long, Map<String, Map<String, ProrationRuleVO>>> slItemConvertRelMap;
    private Map<Long, Map<String, Map<String, Integer>>> slItemProrationIndexMap;
    private String traceId;

    public HandleCalProrationHelper(CalParamVO calParamVO, List<Long> calPersonIdList) {
        this.calParamVO = calParamVO;
        this.calPersonIdList = calPersonIdList;
        this.traceId = RequestContext.get().getTraceId();
        this.itemSectionMap = new HashMap<Long, Map<String, List<String>>>(16);
        this.ftItemProrateRangeQueryMap = new HashMap<Long, Map<String, List<String>>>(16);
        this.bsItemProrateRangeQueryMap = new HashMap<Long, Map<String, List<String>>>(16);
        this.calConvertSectionMap = new HashMap<Long, Map<String, List<String>>>(16);
        this.slItemConvertRelMap = new HashMap<Long, Map<String, Map<String, ProrationRuleVO>>>(16);
        this.slItemProrationIndexMap = new HashMap<Long, Map<String, Map<String, Integer>>>(16);
    }

    public void dealProration() {
        logger.info("dealProration begin,calBatchId = {} ,traceId = {}", (Object)this.calParamVO.getCalBatchId(), (Object)this.traceId);
        CalParamCacheInfo calParamInfo = this.calParamVO.getCalParamMap();
        String dateRange = CalUtils.getDataRange(calParamInfo.getStartDate(), calParamInfo.getEndDate());
        if (!"1".equals(calParamInfo.getProrationCal())) {
            this.addNoProrationCalPersonToMap(dateRange, calParamInfo);
            logger.info("isHanderProration = {},traceId={}\uff0ccalTaskId={}", new Object[]{calParamInfo.getProrationCal(), this.traceId, this.calParamVO.getCalTaskId()});
            return;
        }
        CalConvertVO calConvert = calParamInfo.getCalConvert();
        Map<String, ProrationRuleVO> slRuleRelMap = null;
        Map convertItemRelationMap = null;
        Map bsConvertRelMap = null;
        Map ftConvertRelMap = null;
        if (calConvert != null) {
            slRuleRelMap = calConvert.getProrationRuleList().stream().collect(Collectors.toMap(ProrationRuleVO::getSlUniqueCode, obj -> obj));
            convertItemRelationMap = calConvert.getItemRelationMap();
            bsConvertRelMap = (Map)convertItemRelationMap.get("BS");
            ftConvertRelMap = (Map)convertItemRelationMap.get("FT");
        }
        Map itemRelationMap = calParamInfo.getItemRelationMap();
        Map bsRelMap = (Map)itemRelationMap.get("BS");
        Map ftRelMap = (Map)itemRelationMap.get("FT");
        Map<Long, Map<String, List<String>>> salaryItemProrationMap = this.getSalaryItemProrationRecordMap(calParamInfo.getSalaryItemIdList());
        Map<String, List<String>> itemDetailMap = null;
        HashMap<String, List<String>> itemSectionMap = null;
        Map convertSectionMap = null;
        List<String> dataRangeList = null;
        for (Long calPersonId : this.calPersonIdList) {
            itemSectionMap = new HashMap<String, List<String>>(16);
            this.itemSectionMap.put(calPersonId, itemSectionMap);
            convertSectionMap = this.calConvertSectionMap.getOrDefault(calPersonId, new HashMap(16));
            itemDetailMap = salaryItemProrationMap.remove(calPersonId);
            if (itemDetailMap == null) {
                this.addSalaryItemDataRangeForNoProration(calParamInfo.getNeedSaveSalaryItemList(), itemSectionMap, dateRange);
                continue;
            }
            for (String uniqueCode : calParamInfo.getNeedSaveSalaryItemList()) {
                ProrationRuleVO ruleVO;
                dataRangeList = itemDetailMap.remove(uniqueCode);
                if (dataRangeList == null) {
                    itemSectionMap.put(uniqueCode, Collections.singletonList(dateRange));
                    continue;
                }
                itemSectionMap.put(uniqueCode, this.copyList(dataRangeList));
                this.dealFtOrBsItemProratoin(bsRelMap, dataRangeList, calPersonId, uniqueCode, "BS");
                this.dealFtOrBsItemProratoin(ftRelMap, dataRangeList, calPersonId, uniqueCode, "FT");
                if (calConvert == null || slRuleRelMap == null || (ruleVO = slRuleRelMap.get(uniqueCode)) == null) continue;
                this.addConvertSectionData(ruleVO.getDenominatorId().toString(), convertSectionMap, dataRangeList);
                this.addConvertSectionData(ruleVO.getNumeratorId().toString(), convertSectionMap, dataRangeList);
                this.dealFtOrBsItemProratoin(bsConvertRelMap, dataRangeList, calPersonId, ruleVO.getDenominatorId().toString(), "BS");
                this.dealFtOrBsItemProratoin(ftConvertRelMap, dataRangeList, calPersonId, ruleVO.getDenominatorId().toString(), "FT");
                this.dealFtOrBsItemProratoin(bsConvertRelMap, dataRangeList, calPersonId, ruleVO.getNumeratorId().toString(), "BS");
                this.dealFtOrBsItemProratoin(ftConvertRelMap, dataRangeList, calPersonId, ruleVO.getNumeratorId().toString(), "FT");
                this.addSlItemCovertRelData(uniqueCode, ruleVO, dataRangeList, calPersonId);
            }
            if (itemDetailMap.size() > 0) {
                itemSectionMap.putAll(itemDetailMap);
            }
            if (calConvert == null) continue;
            this.calConvertSectionMap.put(calPersonId, convertSectionMap);
        }
        logger.info("dealProration end,calBatchId = {} ,traceId = {}", (Object)this.calParamVO.getCalBatchId(), (Object)this.traceId);
    }

    private void addSlItemCovertRelData(String uniqueCode, ProrationRuleVO ruleVO, List<String> dataRangeList, Long calPersonId) {
        Map itemCovertRelMap = this.slItemConvertRelMap.getOrDefault(calPersonId, new HashMap(16));
        Map dataRangeMap = itemCovertRelMap.getOrDefault(uniqueCode, new HashMap(16));
        for (String dataRange : dataRangeList) {
            dataRangeMap.put(dataRange, ruleVO);
        }
        itemCovertRelMap.put(uniqueCode, dataRangeMap);
        this.slItemConvertRelMap.put(calPersonId, itemCovertRelMap);
    }

    private void addConvertSectionData(String formulaId, Map<String, List<String>> convertSectionMap, List<String> dataRangeList) {
        List<String> tempList = convertSectionMap.get(formulaId);
        if (tempList == null) {
            tempList = new ArrayList<String>(10);
            convertSectionMap.put(formulaId, tempList);
        }
        this.removeRepateData(tempList, dataRangeList);
    }

    private void dealFtOrBsItemProratoin(Map<String, String> itemRelMap, List<String> dataRangeList, Long calPersonId, String slUniqueCode, String itemType) {
        if (itemRelMap == null || itemRelMap.size() == 0) {
            return;
        }
        String uniqueCodeStr = itemRelMap.get(slUniqueCode);
        if (SWCStringUtils.isEmpty((String)uniqueCodeStr)) {
            return;
        }
        String[] itemUniqueArray = uniqueCodeStr.split(",");
        Map itemRangeMap = null;
        itemRangeMap = "BS".equals(itemType) ? (Map)this.bsItemProrateRangeQueryMap.getOrDefault(calPersonId, new HashMap(16)) : (Map)this.ftItemProrateRangeQueryMap.getOrDefault(calPersonId, new HashMap(16));
        List tempList = null;
        for (String uniqueCode : itemUniqueArray) {
            tempList = (List)itemRangeMap.get(uniqueCode);
            if (tempList == null) {
                itemRangeMap.put(uniqueCode, this.copyList(dataRangeList));
                continue;
            }
            this.removeRepateData(tempList, dataRangeList);
        }
        if ("BS".equals(itemType)) {
            this.bsItemProrateRangeQueryMap.put(calPersonId, itemRangeMap);
        } else {
            this.ftItemProrateRangeQueryMap.put(calPersonId, itemRangeMap);
        }
    }

    private List<String> copyList(List<String> dataRangeList) {
        ArrayList<String> result = new ArrayList<String>(10);
        dataRangeList.forEach(obj -> result.add((String)obj));
        return result;
    }

    private void removeRepateData(List<String> tempList, List<String> dataRangeList) {
        dataRangeList.forEach(obj -> {
            if (!tempList.contains(obj)) {
                tempList.add((String)obj);
            }
        });
    }

    private void addSalaryItemDataRangeForNoProration(List<String> slUniqueCodeList, Map<String, List<String>> itemSectionMap, String dateRange) {
        for (String uniqueCode : slUniqueCodeList) {
            itemSectionMap.put(uniqueCode, Collections.singletonList(dateRange));
        }
    }

    private Map<Long, Map<String, List<String>>> getSalaryItemProrationRecordMap(List<String> salaryItemIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_slprorationrecord");
        QFilter filter = new QFilter("calpersonid", "in", this.calPersonIdList);
        String calType = this.calParamVO.getCalType();
        if ("afterTaxCal".equals(calType)) {
            CalParamCacheInfo calParamCacheInfo = this.calParamVO.getCalParamMap();
            Map slItemMap = calParamCacheInfo.getItemUniqueCodeMap();
            filter.and("salaryitem.uniquecode", "in", slItemMap.keySet());
        } else {
            List idList = salaryItemIdList.stream().map(obj -> Long.valueOf(obj)).collect(Collectors.toList());
            filter.and("salaryitem.id", "in", idList);
        }
        String fields = "calpersonid,salaryitem.uniquecode,startdate,enddate";
        DynamicObjectCollection data = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "calpersonid asc,salaryitem.id asc,startdate asc");
        HashMap<Long, Map<String, List<String>>> salaryItemProrationMap = new HashMap<Long, Map<String, List<String>>>(data.size());
        Map prorationIndexMap = null;
        Map rangeIndexMap = null;
        HashMap<String, ArrayList<String>> itemDetailMap = null;
        ArrayList<String> dataRangeList = null;
        for (DynamicObject obj2 : data) {
            itemDetailMap = (HashMap<String, ArrayList<String>>)salaryItemProrationMap.get(obj2.getLong("calpersonid"));
            if (itemDetailMap == null) {
                itemDetailMap = new HashMap<String, ArrayList<String>>(16);
                salaryItemProrationMap.put(obj2.getLong("calpersonid"), itemDetailMap);
            }
            if ((dataRangeList = (ArrayList<String>)itemDetailMap.get(obj2.getString("salaryitem.uniquecode"))) == null) {
                dataRangeList = new ArrayList<String>(10);
                itemDetailMap.put(obj2.getString("salaryitem.uniquecode"), dataRangeList);
            }
            dataRangeList.add(CalUtils.getDataRange(obj2.getDate("startdate"), obj2.getDate("enddate")));
            prorationIndexMap = this.slItemProrationIndexMap.getOrDefault(obj2.getLong("calpersonid"), new HashMap(16));
            rangeIndexMap = prorationIndexMap.getOrDefault(obj2.getString("salaryitem.uniquecode"), new HashMap(16));
            rangeIndexMap.put(CalUtils.getDataRange(obj2.getDate("startdate"), obj2.getDate("enddate")), rangeIndexMap.size() + 1);
            prorationIndexMap.put(obj2.getString("salaryitem.uniquecode"), rangeIndexMap);
            this.slItemProrationIndexMap.put(obj2.getLong("calpersonid"), prorationIndexMap);
        }
        return salaryItemProrationMap;
    }

    private void addNoProrationCalPersonToMap(String dateRange, CalParamCacheInfo calParamInfo) {
        HashMap<String, List<String>> itemSectionMap = null;
        for (Long tempId : this.calPersonIdList) {
            itemSectionMap = new HashMap<String, List<String>>(16);
            this.itemSectionMap.put(tempId, itemSectionMap);
            this.addSalaryItemDataRangeForNoProration(calParamInfo.getNeedSaveSalaryItemList(), itemSectionMap, dateRange);
        }
    }

    public Map<Long, Map<String, List<String>>> getItemSectionMap() {
        return this.itemSectionMap;
    }

    public Map<Long, Map<String, List<String>>> getFtItemProrateRangeQueryMap() {
        return this.ftItemProrateRangeQueryMap;
    }

    public Map<Long, Map<String, List<String>>> getBsItemProrateRangeQueryMap() {
        return this.bsItemProrateRangeQueryMap;
    }

    public Map<Long, Map<String, List<String>>> getCalConvertSectionMap() {
        return this.calConvertSectionMap;
    }

    public Map<Long, Map<String, Map<String, ProrationRuleVO>>> getSlItemConvertRelMap() {
        return this.slItemConvertRelMap;
    }

    public Map<Long, Map<String, Map<String, Integer>>> getSlItemProrationIndexMap() {
        return this.slItemProrationIndexMap;
    }
}

