/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hscs.business.extpoint.ISalaryCalExtService;
import kd.sdk.swc.hscs.common.events.AfterSalaryCalEvent;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.fetchdata.helper.DataReaderCalHelper;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.business.cal.result.ResultCheckService;
import kd.swc.hscs.business.cal.result.SalaryCalExtService;
import kd.swc.hscs.business.cal.result.SalaryResultService;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemHelper;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemService;
import kd.swc.hscs.business.cal.tax.service.TaxDataPushService;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.thread.CalResultCheckTask;
import kd.swc.hscs.common.enums.OperationTypeEnum;
import kd.swc.hscs.common.vo.BatchCalResultParamVO;
import kd.swc.hscs.common.vo.CalMessage;
import kd.swc.hscs.common.vo.CalOperationVO;
import kd.swc.hscs.common.vo.CalRecordVO;
import kd.swc.hscs.common.vo.CalResultItem;
import kd.swc.hscs.common.vo.CalResultItemRel;
import kd.swc.hscs.common.vo.CalResultVO;
import kd.swc.hscs.common.vo.acc.AccDetailsVO;
import kd.swc.hscs.common.vo.acc.AccInfo;
import org.jetbrains.annotations.NotNull;

public class FormulaCalRecord {
    private static final Log logger = LogFactory.getLog(FormulaCalRecord.class);
    private Long taskId;
    private Long recordId;
    private Long batchId;
    private Date startDate;
    private int successCount;
    private int failCount;
    private int sumSuccessCount;
    private int sumFailCount;
    private String traceId;
    private List<Long> pushTaxCalPersonIdList;
    private Map<String, ExchangeRateInfo> exrateCacheMap;
    private Map<Long, CalRecordVO> calRecordMap;
    private Map<Long, List<CalResultVO>> calResultMap;
    private Map<Long, List<CalResultItem>> calResultItemMap;
    private Map<Long, List<AccDetailsVO>> accDetailsMap;
    private Map<Long, List<CalMessage>> calMessageMap;
    private Map<Long, List<CalResultItemRel>> calResultItemRelMap;
    private Map<Long, AccInfo> accInfoMap;
    private boolean isSyncCal = false;
    private Map<Long, Map<String, Object>> responseMap;

    public FormulaCalRecord(Long taskId, Long recordId, Long batchId, Date startDate, String traceId) {
        this.taskId = taskId;
        this.recordId = recordId;
        this.batchId = batchId;
        this.startDate = startDate;
        this.successCount = 0;
        this.failCount = 0;
        this.sumFailCount = 0;
        this.sumSuccessCount = 0;
        this.traceId = traceId;
        this.pushTaxCalPersonIdList = new ArrayList<Long>();
        this.exrateCacheMap = new HashMap<String, ExchangeRateInfo>();
        this.isSyncCal = false;
        this.responseMap = new HashMap<Long, Map<String, Object>>();
    }

    public FormulaCalRecord(Long taskId, Long recordId, Long batchId, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) {
        this.taskId = taskId;
        this.recordId = recordId;
        this.batchId = batchId;
        this.startDate = new Date();
        this.successCount = 0;
        this.failCount = 0;
        this.sumFailCount = 0;
        this.sumSuccessCount = 0;
        this.traceId = RequestContext.get().getTraceId();
        this.pushTaxCalPersonIdList = new ArrayList<Long>();
        this.exrateCacheMap = new HashMap<String, ExchangeRateInfo>();
        this.isSyncCal = isSyncCal;
        this.responseMap = responseMap;
    }

    public void saveCalResultData(String cacheKey, String calType, boolean resultCheck, List<Long> calPersonIdList) {
        logger.info("saveCalResultData begin,calBatchId={},traceId={},time={},calPersonIdList size={},calType = {}", new Object[]{this.batchId, this.traceId, System.currentTimeMillis(), calPersonIdList.size(), calType});
        ISWCAppCache resultCache = SWCAppCache.get((String)cacheKey);
        if (CalUtils.isTerminationCal(this.recordId)) {
            resultCache.remove("result_cache_key");
            return;
        }
        DynamicObject[] calPersonArray = this.getCalPersonList(calPersonIdList, calType);
        logger.info("calBatchId={},total size is {},can deal data size is {},repeat data size is {}", new Object[]{this.batchId, calPersonIdList.size(), calPersonArray.length, calPersonIdList.size() - calPersonArray.length});
        if (calPersonArray.length == 0) {
            resultCache.remove("result_cache_key");
            return;
        }
        String batchResultJson = (String)resultCache.get("result_cache_key", String.class);
        logger.info("batchResultJson is {}", (Object)batchResultJson);
        if (SWCStringUtils.isEmpty((String)batchResultJson)) {
            logger.info("Get calResult is null from redis,traceId={},batchId={}", (Object)this.traceId, (Object)this.batchId);
            this.handleNotFoundCalResult(calPersonArray, calType);
            return;
        }
        BatchCalResultParamVO batchResult = (BatchCalResultParamVO)SerializationUtils.fromJsonString((String)batchResultJson, BatchCalResultParamVO.class);
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "periodcategory,taxitemschemev.id,number,exratedate,payrollgroupv.exratetable.id,payrollgroup.id,calrule.id,periodtype.id,periodtype.calfrequency,period.id,startdate,enddate,calrulev.id,payrollgroupv.currency.amtprecision,payrollgroupv.currency.id,country.id,payrollscene.id,tasktype,calrulev.opentaxcal,payrolldate";
        DynamicObject task = taskHelper.queryOne(fields, (Object)this.taskId);
        this.translateResultToMap(batchResult);
        boolean openTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByTask((DynamicObject)task);
        boolean isFinish = false;
        List<List<DynamicObject>> splitCalPersonList = this.splitCalPersonDataByItemCount(calPersonArray, batchResult);
        for (List<DynamicObject> tempCalPersonList : splitCalPersonList) {
            isFinish = this.batchDealCalResult(batchResult, tempCalPersonList, task, calType, resultCheck, openTaxCal);
        }
        try {
            CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), calType, this.sumSuccessCount, this.sumFailCount);
            CalUtils.addCalOperation(this.recordId, this.batchId, OperationTypeEnum.SAVE.getCode(), this.startDate, operationVO);
            this.updateCalBatch("2");
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        if (CalUtils.isTerminationCal(this.recordId)) {
            resultCache.remove("result_cache_key");
            return;
        }
        resultCache.remove("result_cache_key");
        this.clearResultDataMap();
        if (SWCStringUtils.equals((String)calType, (String)"preTaxCal") && this.pushTaxCalPersonIdList.size() > 0 && openTaxCal) {
            this.autoPushDataToTax(resultCheck);
        }
        if (SWCStringUtils.equals((String)calType, (String)"preTaxCal") || SWCStringUtils.equals((String)calType, (String)"onlyPreTaxCal")) {
            ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.recordId));
            this.invokeTaxReleaseOpResource(calType, String.valueOf(this.recordId), calPersonArray.length, calProgressAppCache, String.valueOf(task.getLong("country.id")));
        }
        AfterSalaryCalEvent event = new AfterSalaryCalEvent(this.taskId, this.recordId, this.batchId, calType, calPersonIdList, isFinish, this.traceId);
        this.invokeAfterSalaryCal(event);
        logger.info("saveCalResultData end,calBatchId={},traceId={},time={},calType = {}", new Object[]{this.batchId, this.traceId, System.currentTimeMillis(), calType});
    }

    @NotNull
    private List<List<DynamicObject>> splitCalPersonDataByItemCount(DynamicObject[] calPersonArray, BatchCalResultParamVO batchResult) {
        int splitCount = calPersonArray.length;
        if (batchResult.getItemCount() > 100) {
            splitCount = 250;
        }
        return SWCListUtils.split(Arrays.asList(calPersonArray), (int)splitCount);
    }

    private void translateResultToMap(BatchCalResultParamVO batchResult) {
        this.calRecordMap = batchResult.getCalRecordList().stream().collect(Collectors.toMap(obj -> Long.valueOf(obj.getCalPersonId()), obj -> obj));
        this.calResultMap = batchResult.getCalResultList().stream().collect(Collectors.groupingBy(CalResultItem::getCalPersonId));
        this.calResultItemMap = batchResult.getCalResultItemList().stream().collect(Collectors.groupingBy(CalResultItem::getCalPersonId));
        this.accDetailsMap = batchResult.getAccDetailsList().stream().collect(Collectors.groupingBy(AccDetailsVO::getCalPersonId));
        this.accInfoMap = batchResult.getAccInfoList().stream().collect(Collectors.toMap(AccInfo::getId, obj -> obj, (key1, key2) -> key1));
        this.calMessageMap = batchResult.getCalMessageList().stream().collect(Collectors.groupingBy(CalMessage::getCalPersonId));
        this.calResultItemRelMap = SWCListUtils.isEmpty((List)batchResult.getCalResultItemRelList()) ? new HashMap<Long, List<CalResultItemRel>>(0) : batchResult.getCalResultItemRelList().stream().collect(Collectors.groupingBy(CalResultItemRel::getCalPersonId));
    }

    private void clearResultDataMap() {
        this.calRecordMap.clear();
        this.calResultMap.clear();
        this.calResultItemMap.clear();
        this.accDetailsMap.clear();
        this.accInfoMap.clear();
        this.calMessageMap.clear();
    }

    private void invokeAfterSalaryCal(AfterSalaryCalEvent event) {
        SalaryCalExtService iSalaryCalExtService = new SalaryCalExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryCalExtService, ISalaryCalExtService.class, (String)"kd.sdk.swc.hscs.business.extpoint.ISalaryCalExtService#afterSalaryCal", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterSalaryCal(event);
            return null;
        });
    }

    private void invokeTaxReleaseOpResource(String calType, String preValidateKey, int count, ISWCAppCache calProgressAppCache, String countryId) {
        int pushedCount = 0;
        if (SWCStringUtils.equals((String)calType, (String)"preTaxCal")) {
            pushedCount = this.sumFailCount;
        } else if (SWCStringUtils.equals((String)calType, (String)"onlyPreTaxCal")) {
            pushedCount = count;
        }
        boolean isFinish = FormulaCacheUtils.updatePushDataToTaxCount((ISWCAppCache)calProgressAppCache, (int)0, (int)pushedCount, (long)this.recordId);
        if (isFinish) {
            CalOperationHelper.invokeTaxReleaseOpResource(preValidateKey, countryId);
        }
    }

    private void autoPushDataToTax(boolean resultCheck) {
        logger.info("autoPushDataToTax start,calBatchId={},traceId={}", (Object)this.batchId, (Object)this.traceId);
        if (this.isSyncCal) {
            TaxDataPushService pushService = new TaxDataPushService(this.taskId, this.recordId, this.batchId, this.isSyncCal, this.responseMap);
            pushService.pushTax(this.pushTaxCalPersonIdList, resultCheck);
        } else {
            RequestContext ctx = RequestContext.get();
            ThreadPools.executeOnce((String)"AUTOPUSHDATA_POOL_ASYNC", () -> {
                RequestContext.copyAndSet((RequestContext)ctx);
                logger.info("pushService.pushTax,traceId={}", (Object)this.traceId);
                TaxDataPushService pushService = new TaxDataPushService(this.taskId, this.recordId, this.batchId);
                pushService.pushTax(this.pushTaxCalPersonIdList, resultCheck);
            });
        }
        logger.info("autoPushDataToTax end,calBatchId={},traceId={}", (Object)this.batchId, (Object)this.traceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchDealCalResult(BatchCalResultParamVO batchResult, List<DynamicObject> calPersonDataList, DynamicObject task, String calType, boolean resultCheck, boolean openTaxCal) {
        logger.info("batchDealCalResult begin,calBatchId={},traceId={},time={}", new Object[]{this.batchId, this.traceId, System.currentTimeMillis()});
        this.successCount = 0;
        this.failCount = 0;
        boolean isFinish = false;
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(calPersonDataList.size());
        HashMap<Long, DynamicObject> calPersonMap = new HashMap<Long, DynamicObject>(calPersonDataList.size());
        for (DynamicObject calPerson : calPersonDataList) {
            calPersonMap.put(calPerson.getLong("id"), calPerson);
            calPersonIdList.add(calPerson.getLong("id"));
        }
        ArrayList<CalRecordVO> calDetailList = new ArrayList<CalRecordVO>(calPersonIdList.size());
        ArrayList<CalResultVO> calResultList = new ArrayList<CalResultVO>(10);
        ArrayList<CalResultItem> calResultItemList = new ArrayList<CalResultItem>(10);
        ArrayList<CalResultItemRel> calResultItemRelList = new ArrayList<CalResultItemRel>(10);
        HashMap<String, String> updateCalPersonStateMap = new HashMap<String, String>(16);
        DynamicObject[] updateCalPersonData = new DynamicObject[calPersonDataList.size()];
        calPersonDataList.toArray(updateCalPersonData);
        CalRecordVO tempCalRecord = null;
        List<CalResultVO> tempResultList = null;
        List<CalResultItem> tempCalResultItemList = null;
        List<CalResultItemRel> tempCalResultItemRelList = null;
        HashMap<Long, DynamicObject> successCalMap = new HashMap<Long, DynamicObject>(calPersonIdList.size());
        HashMap<Long, DynamicObject> failureCaMap = new HashMap<Long, DynamicObject>(calPersonIdList.size());
        List<AccDetailsVO> tempAccDetailsList = null;
        ArrayList<Long> sucessCalIdList = new ArrayList<Long>(10);
        ArrayList<Long> failureCalIdList = new ArrayList<Long>(10);
        ArrayList<AccDetailsVO> accDetailsList = new ArrayList<AccDetailsVO>(10);
        HashMap<Long, Map<String, Object>> tempResponseMap = new HashMap<Long, Map<String, Object>>(calPersonIdList.size());
        for (Long calPersonId : calPersonIdList) {
            DynamicObject calPerson = (DynamicObject)calPersonMap.get(calPersonId);
            if (calPerson == null || null == (tempCalRecord = this.calRecordMap.get(calPersonId))) continue;
            if (SWCStringUtils.equals((String)tempCalRecord.getCalStatus(), (String)CalStatusEnum.SUCCESS.getCode())) {
                ++this.successCount;
                sucessCalIdList.add(calPersonId);
                successCalMap.put(calPersonId, calPerson);
                updateCalPersonStateMap.put(calPersonId.toString(), CalOperationHelper.getSuccessCalStateByCalType(calType, openTaxCal));
            } else {
                ++this.failCount;
                failureCalIdList.add(calPersonId);
                failureCaMap.put(calPersonId, calPerson);
                updateCalPersonStateMap.put(calPersonId.toString(), CalOperationHelper.getFailCalStateByCalType(calType));
            }
            calDetailList.add(tempCalRecord);
            tempResultList = this.calResultMap.get(calPersonId);
            if (!SWCListUtils.isEmpty(tempResultList)) {
                calResultList.addAll(tempResultList);
            }
            if (!SWCListUtils.isEmpty(tempAccDetailsList = this.accDetailsMap.get(calPersonId))) {
                accDetailsList.addAll(tempAccDetailsList);
            }
            if (!SWCListUtils.isEmpty(tempCalResultItemList = this.calResultItemMap.get(calPersonId))) {
                calResultItemList.addAll(tempCalResultItemList);
            }
            if (!SWCListUtils.isEmpty(tempCalResultItemRelList = this.calResultItemRelMap.get(calPersonId))) {
                calResultItemRelList.addAll(tempCalResultItemRelList);
            }
            this.addCalResultToTempResponse(tempResponseMap, tempCalRecord, tempResultList);
        }
        logger.info("handleAccData begin,calBatchId = {}", (Object)this.batchId);
        DynamicObjectCollection accResultList = new DynamicObjectCollection();
        DynamicObjectCollection accDetailObjList = this.handleAccData(accDetailsList, accResultList, sucessCalIdList, task, calType, this.accInfoMap);
        logger.info("handleAccData end,calBatchId = {}", (Object)this.batchId);
        calResultList.forEach(obj -> obj.setItemEnum(CalResultItemEnum.SALARYITEM));
        calResultItemList.addAll(calResultList);
        DataReaderCalHelper dataReaderCalHelper = new DataReaderCalHelper();
        boolean isNoCountSinsurData = dataReaderCalHelper.getIsNoCountSinsurData(task.getLong("id"));
        SWCDataServiceHelper insuranceDataHelper = new SWCDataServiceHelper("hsas_insurancedata");
        DynamicObject[] insuranceDatas = new DynamicObject[]{};
        if (!isNoCountSinsurData) {
            insuranceDatas = this.getUpdateInsuranceDateArr(calPersonMap, insuranceDataHelper, batchResult);
        }
        DynamicObjectCollection calMessageList = this.handleCalMessage(successCalMap, this.calMessageMap);
        if (CalUtils.isTerminationCal(this.recordId)) {
            return isFinish;
        }
        List<Long> personIndexIdList = this.getPersonIndexIdList(calType, sucessCalIdList, calPersonMap);
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.recordId));
        boolean isSaveSuccess = true;
        logger.info("salaryCalResult save begin,calBatchId={},traceId={},time={}", new Object[]{this.batchId, this.traceId, System.currentTimeMillis()});
        TXHandle txHandle = TX.requiresNew();
        try {
            Map<Long, Long> calPersonMapCalTable = this.saveFormulaItemValueData(calResultItemList, successCalMap, failureCaMap, calType, task, calResultItemRelList);
            this.setCalState(updateCalPersonData, updateCalPersonStateMap, calPersonMapCalTable, calType);
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            calPersonHelper.update(updateCalPersonData);
            if (failureCalIdList.size() > 0) {
                Date payRollDate = task.getDate("payrolldate");
                this.updateBizDataRelAndUsageCount(failureCalIdList, calType, batchResult, payRollDate);
                this.updateAttBizDataRelAndUsageCount(failureCalIdList, calType, batchResult);
            }
            logger.info("begin save acc result");
            SWCDataServiceHelper accDetailsHelper = new SWCDataServiceHelper("hsas_accdetails");
            if (sucessCalIdList.size() > 0) {
                QFilter accDeleteFilter = new QFilter("calpersonid", "in", sucessCalIdList);
                accDeleteFilter.and("caltask", "=", (Object)this.taskId);
                accDetailsHelper.deleteByFilter(new QFilter[]{accDeleteFilter});
            }
            if (accDetailObjList.size() > 0) {
                accDetailsHelper.save(accDetailObjList);
            }
            if (accResultList.size() > 0) {
                SWCDataServiceHelper accResultHelper = new SWCDataServiceHelper("hsas_accresult");
                accResultHelper.save(accResultList);
            }
            logger.info("end save acc result");
            if (insuranceDatas != null && insuranceDatas.length > 0) {
                insuranceDataHelper.save(insuranceDatas);
            }
            if (calMessageList.size() > 0) {
                SWCDataServiceHelper messageHelper = new SWCDataServiceHelper("hsas_calmessage");
                messageHelper.save(calMessageList);
            }
            logger.info("begin delCheckNotPromptData");
            this.delCheckNotPromptData(this.taskId);
            logger.info("end delCheckNotPromptData");
            this.saveCalDetail(calDetailList, null, null, null, calType, calPersonIdList);
            CalUtils.deleteSalaryCalMutexData(personIndexIdList, this.taskId);
            if (CalUtils.isTerminationCal(this.recordId)) {
                txHandle.markRollback();
                boolean bl = isFinish;
                return bl;
            }
        }
        catch (Exception ex) {
            logger.error("salaryCalResult save error", (Throwable)ex);
            isSaveSuccess = false;
            this.successCount = 0;
            this.failCount = calPersonIdList.size();
            txHandle.markRollback();
            sucessCalIdList.clear();
        }
        finally {
            txHandle.close();
            String failMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FormulaCalRecord_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            if (!isSaveSuccess) {
                this.updateCalPersonCalStatus(updateCalPersonData, calType);
                this.cleanCalTableData(calPersonIdList, calType);
                this.saveCalDetail(calDetailList, "2", FailureTypeEnum.SAVE_FAIL.getCode(), failMsg, calType, calPersonIdList);
                Date payRollDate = task.getDate("payrolldate");
                this.updateBizDataRelAndUsageCount(calPersonIdList, calType, batchResult, payRollDate);
                this.updateAttBizDataRelAndUsageCount(calPersonIdList, calType, batchResult);
                personIndexIdList = this.getPersonIndexIdList(calType, sucessCalIdList, calPersonMap);
                CalUtils.deleteSalaryCalMutexData(personIndexIdList, this.taskId);
            }
            if (isFinish = CalUtils.updateSaveProcess(this.successCount, this.failCount, calProgressAppCache, calType, this.taskId, this.recordId)) {
                CalUtils.releaseCalCacheData(this.recordId);
            }
            this.sumSuccessCount += this.successCount;
            this.sumFailCount += this.failCount;
            this.pushTaxCalPersonIdList.addAll(sucessCalIdList);
            if (this.isSyncCal) {
                CalOperationHelper.putTempDataToResponse(tempResponseMap, this.responseMap, isSaveSuccess, failMsg, calPersonIdList);
            }
        }
        logger.info("salaryCalResult save end,calBatchId={},traceId={},time={}", new Object[]{this.batchId, this.traceId, System.currentTimeMillis()});
        if (CalUtils.isTerminationCal(this.recordId)) {
            return isFinish;
        }
        this.asynSaveSalaryResult(calPersonIdList, calResultList, task);
        if (resultCheck) {
            logger.info("beginResultCheck,calType:{},batchId={}", (Object)calType, (Object)this.batchId);
            try {
                this.asynDeleteResultCheckData(calPersonIdList, calType, task);
                this.doResultCheck(task, calPersonMap, calPersonIdList);
            }
            catch (Exception exception) {
                logger.error("doResultCheck_error", (Throwable)exception);
            }
            logger.info("endResultCheck,calType:{},batchId={}", (Object)calType, (Object)this.batchId);
        }
        logger.info("batchDealCalResult end,calBatchId={},traceId={},time={}", new Object[]{this.batchId, this.traceId, System.currentTimeMillis()});
        return isFinish;
    }

    private void updateAttBizDataRelAndUsageCount(List<Long> calPersonIdList, String calType, BatchCalResultParamVO batchResult) {
        Set attBizDataSummaryIdSet = batchResult.getAttBizDataSummaryIdSet();
        Set attBizDataDetailIdSet = batchResult.getAttBizDataDetailIdSet();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calPayRollTask = helper.queryOne("id,attstartdate, attenddate", new QFilter[]{new QFilter("id", "=", (Object)this.taskId)});
        List splitLists = SWCListUtils.split(calPersonIdList, (int)1000);
        for (List splitList : splitLists) {
            if (attBizDataSummaryIdSet != null && attBizDataSummaryIdSet.size() > 0) {
                SWCDataServiceHelper attBizDataHelper = new SWCDataServiceHelper("hsas_attbizdatasummary");
                SWCDataServiceHelper relHelper = new SWCDataServiceHelper("hsas_calattbizdatarel");
                this.updateAttBizDataRelAndUsageCount(splitList, calType, attBizDataSummaryIdSet, relHelper, attBizDataHelper, calPayRollTask, "usagecount");
                SWCDataServiceHelper noCntRelHelper = new SWCDataServiceHelper("hsas_calattnocntrel");
                this.updateAttBizDataRelAndUsageCount(splitList, calType, attBizDataSummaryIdSet, noCntRelHelper, attBizDataHelper, calPayRollTask, "nocounttimes");
            }
            if (attBizDataDetailIdSet == null || attBizDataDetailIdSet.size() <= 0) continue;
            SWCDataServiceHelper attBizDetailDataHelper = new SWCDataServiceHelper("hsas_attbizdatadetail");
            SWCDataServiceHelper detailRelHelper = new SWCDataServiceHelper("hsas_calattbsdetailrel");
            this.updateAttBizDataRelAndUsageCount(splitList, calType, attBizDataDetailIdSet, detailRelHelper, attBizDetailDataHelper, calPayRollTask, "usagecount");
            SWCDataServiceHelper noCntDetailRelHelper = new SWCDataServiceHelper("hsas_calattdetnocntrel");
            this.updateAttBizDataRelAndUsageCount(splitList, calType, attBizDataDetailIdSet, noCntDetailRelHelper, attBizDetailDataHelper, calPayRollTask, "nocounttimes");
        }
    }

    private void updateAttBizDataRelAndUsageCount(List<Long> calPersonIdList, String calType, Set<Long> attBizDataIdSet, SWCDataServiceHelper relHelper, SWCDataServiceHelper attBizDataHelper, DynamicObject calPayRollTask, String updateField) {
        QFilter filter = new QFilter("caltask.id", "=", (Object)this.taskId);
        filter.and("calpersonid", "in", calPersonIdList);
        if (!SWCObjectUtils.isEmpty((Object)calPayRollTask)) {
            Date taskAttStartDate = calPayRollTask.getDate("attstartdate");
            Date taskAttEndDate = calPayRollTask.getDate("attenddate");
            filter.and("attstartdate", ">=", (Object)taskAttStartDate);
            filter.and("attstartdate", "<=", (Object)taskAttEndDate);
            filter.and("attenddate", ">=", (Object)taskAttStartDate);
            filter.and("attenddate", "<=", (Object)taskAttEndDate);
        }
        if ("afterTaxCal".equals(calType)) {
            filter.and("attbizdataid", "in", attBizDataIdSet);
        }
        DynamicObjectCollection attBizDataRelColl = relHelper.queryOriginalCollection("id, attbizdataid", new QFilter[]{filter});
        relHelper.deleteByFilter(new QFilter[]{filter});
        Set attBizDataSet = attBizDataRelColl.stream().map(attBizData -> attBizData.getLong("attbizdataid")).collect(Collectors.toSet());
        DynamicObject[] attBizDataColl = attBizDataHelper.query("id, usagecount, nocounttimes ,modifytime", new QFilter[]{new QFilter("id", "in", attBizDataSet)});
        if (SWCObjectUtils.isEmpty((Object)attBizDataColl)) {
            return;
        }
        Date date = new Date();
        for (DynamicObject obj : attBizDataColl) {
            int updateFieldValue = obj.getInt(updateField);
            if (updateFieldValue <= 0) continue;
            obj.set(updateField, (Object)(updateFieldValue - 1));
            obj.set("modifytime", (Object)date);
        }
        relHelper.update(attBizDataColl);
    }

    private void addCalResultToTempResponse(Map<Long, Map<String, Object>> tempResponseMap, CalRecordVO tempCalRecord, List<CalResultVO> tempResultList) {
        if (!this.isSyncCal) {
            return;
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>(5);
        Long calPersonId = Long.valueOf(tempCalRecord.getCalPersonId());
        if (CalStatusEnum.FAIL.getCode().equals(tempCalRecord.getCalStatus())) {
            tempMap.put("success", false);
            tempMap.put("status", 400);
            tempMap.put("message", tempCalRecord.getFailMsg());
            tempMap.put("calPersonId", calPersonId);
            tempResponseMap.put(calPersonId, tempMap);
            return;
        }
        tempMap.put("success", true);
        tempMap.put("status", 200);
        tempMap.put("message", null);
        tempMap.put("calPersonId", calPersonId);
        ArrayList<HashMap<String, Object>> itemList = new ArrayList<HashMap<String, Object>>(10);
        if (tempResultList == null) {
            tempResultList = new ArrayList<CalResultVO>(0);
        }
        HashMap<String, Object> itemMap = null;
        for (CalResultVO obj : tempResultList) {
            itemMap = new HashMap<String, Object>(5);
            itemMap.put("salaryItemId", obj.getSalaryItemId());
            itemMap.put("startDate", obj.getStartDate());
            itemMap.put("endDate", obj.getEndDate());
            this.dealCalResultValue(obj, itemMap);
            itemList.add(itemMap);
        }
        tempMap.put("itemList", itemList);
        tempResponseMap.put(calPersonId, tempMap);
    }

    private void dealCalResultValue(CalResultVO obj, Map<String, Object> itemMap) {
        SaveDataTypeEnum dataType = SaveDataTypeEnum.getDataType((String)obj.getDataShowType());
        Object value = null;
        Long dataTypeId = 0L;
        switch (dataType) {
            case NUM: {
                value = SaveCalItemHelper.getItemBigDecimalResult(obj.getCalResultValue());
                dataTypeId = DataTypeEnum.NUMBERIC.getDbId();
                break;
            }
            case DATE: {
                value = SaveCalItemHelper.getItemDateResult(obj.getCalResultValue());
                dataTypeId = DataTypeEnum.DATE.getDbId();
                break;
            }
            case TEXT: {
                value = SaveCalItemHelper.getItemStringResult(obj.getCalResultValue());
                dataTypeId = DataTypeEnum.STRING.getDbId();
                break;
            }
            case AMOUNT: {
                value = SaveCalItemHelper.getItemBigDecimalResult(obj.getCalResultValue());
                dataTypeId = DataTypeEnum.AMOUNT.getDbId();
                break;
            }
        }
        itemMap.put("dataType", dataTypeId);
        itemMap.put("itemValue", value);
    }

    private DynamicObjectCollection handleCalMessage(Map<Long, DynamicObject> successCalMap, Map<Long, List<CalMessage>> calMessageMap) {
        if (calMessageMap == null || calMessageMap.size() == 0 || successCalMap.size() == 0) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection calMessageList = new DynamicObjectCollection();
        DynamicObject calPerson = null;
        List<CalMessage> tempList = null;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calmessage");
        DynamicObject calMessageObj = null;
        for (Map.Entry<Long, DynamicObject> entry : successCalMap.entrySet()) {
            calPerson = entry.getValue();
            tempList = calMessageMap.get(entry.getKey());
            if (SWCListUtils.isEmpty(tempList)) continue;
            int index = 1;
            for (CalMessage message : tempList) {
                calMessageObj = (DynamicObject)type.createInstance();
                calMessageObj.set("caltask", (Object)this.taskId);
                calMessageObj.set("record", (Object)this.recordId);
                calMessageObj.set("calpersonid", (Object)entry.getKey());
                calMessageObj.set("formula", (Object)message.getFormulaId());
                calMessageObj.set("message", (Object)message.getMessage());
                calMessageObj.set("salaryfile", (Object)calPerson.getLong("salaryfile.id"));
                calMessageObj.set("level", (Object)"1");
                calMessageObj.set("index", (Object)index);
                calMessageObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                calMessageObj.set("createtime", (Object)new Date());
                calMessageObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                calMessageObj.set("modifytime", (Object)new Date());
                calMessageList.add((Object)calMessageObj);
                ++index;
            }
        }
        return calMessageList;
    }

    private List<Long> getPersonIndexIdList(String calType, List<Long> sucessCalIdList, Map<Long, DynamicObject> calPersonMap) {
        if (!"preTaxCal".equals(calType)) {
            sucessCalIdList = new ArrayList<Long>(0);
        }
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(calPersonMap.size());
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            if (sucessCalIdList.contains(entry.getKey())) continue;
            personIndexIdList.add(entry.getValue().getLong("personhrv.personindexid"));
        }
        return personIndexIdList;
    }

    private void doResultCheck(DynamicObject task, Map<Long, DynamicObject> calPersonMap, List<Long> calPersonIdList) {
        long payRollGroupId;
        String taskType = task.getString("tasktype");
        if (SWCStringUtils.equals((String)"1", (String)taskType)) {
            logger.info("task_type_add no need result check");
            return;
        }
        long payRollScene = task.getLong("payrollscene.id");
        DynamicObject checkSchemeObj = this.assembleCheckScheme(payRollScene, payRollGroupId = task.getLong("payrollgroup.id"));
        if (checkSchemeObj == null) {
            logger.info("checkSchemeObj is null");
            return;
        }
        ArrayList<Long> bizItemList = new ArrayList<Long>(10);
        Map<String, List<Long>> calItemMap = this.assembleCalItemIdList(checkSchemeObj, bizItemList);
        if (calItemMap.size() == 0) {
            logger.info("calItemMap is empty");
        }
        logger.info("calItemMap:{}", (Object)calItemMap.toString());
        ArrayList<Map<String, Object>> bizResultList = new ArrayList<Map<String, Object>>(10);
        ArrayList<CalResultVO> calResultDataList = new ArrayList<CalResultVO>(10);
        this.assembleCalResultDataList(calItemMap, calPersonIdList, bizItemList, bizResultList, calResultDataList);
        if (SWCListUtils.isEmpty(calResultDataList) && SWCListUtils.isEmpty(bizResultList)) {
            logger.info("calResultDataList and tempResultList is empty");
            return;
        }
        CalResultCheckTask resultCheckTask = new CalResultCheckTask(calResultDataList, task, calPersonMap, bizResultList, RequestContext.get(), checkSchemeObj);
        SWCThreadPoolFactory.getAftercalAsyncThreadpool().submit((Callable)resultCheckTask);
        logger.info("asynSaveResultCheckData end,traceId={},time={}", (Object)this.traceId, (Object)System.currentTimeMillis());
    }

    private void assembleCalResultDataList(Map<String, List<Long>> calItemMap, List<Long> calPersonIdList, List<Long> bizItemList, List<Map<String, Object>> bizResultList, List<CalResultVO> resultDataList) {
        Map<Long, Long> calResultPersonMap = this.assembleCalResultPersonMap(calPersonIdList);
        if (calResultPersonMap.size() == 0) {
            return;
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        if (!SWCListUtils.isEmpty(calItemMap.get("0"))) {
            itemIdList.addAll((Collection)calItemMap.get("0"));
        }
        if (!SWCListUtils.isEmpty(calItemMap.get("1"))) {
            itemIdList.addAll((Collection)calItemMap.get("1"));
        }
        this.assembleCalResultData(resultDataList, itemIdList, calResultPersonMap, bizItemList, bizResultList);
    }

    private void assembleCalResultData(List<CalResultVO> resultDataList, List<Long> itemIdList, Map<Long, Long> calResultPersonMap, List<Long> bizItemList, List<Map<String, Object>> bizResultList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        ArrayList<Long> resultIdList = new ArrayList<Long>(calResultPersonMap.keySet());
        QFilter filter = new QFilter("id", "in", resultIdList);
        DynamicObject[] caltableObjs = helper.query("id,calpersonid,hsas_caltableentry,hsas_caltableentry.salaryitem,hsas_caltableentry.slprorationindex,hsas_caltableentry.calamountvalue,hsas_calbsentry,hsas_calbsentry.bizitem,hsas_calbsentry.bscalamountvalue", new QFilter[]{filter});
        if (caltableObjs == null || caltableObjs.length == 0) {
            return;
        }
        for (DynamicObject caltable : caltableObjs) {
            long calPersonId = caltable.getLong("calpersonid");
            DynamicObjectCollection caltableentry = caltable.getDynamicObjectCollection("hsas_caltableentry");
            DynamicObjectCollection calbsentry = caltable.getDynamicObjectCollection("hsas_calbsentry");
            if (!SWCListUtils.isEmpty((List)caltableentry) && !SWCListUtils.isEmpty(itemIdList)) {
                for (DynamicObject tableEntry : caltableentry) {
                    long salaryItemId = tableEntry.getLong("salaryitem.id");
                    int slprorationindex = tableEntry.getInt("slprorationindex");
                    if (!itemIdList.contains(salaryItemId) || slprorationindex != 0) continue;
                    CalResultVO resultVO = new CalResultVO();
                    resultVO.setCalPersonId(Long.valueOf(calPersonId));
                    resultVO.setCalAmountValue(tableEntry.getBigDecimal("calamountvalue"));
                    resultVO.setSalaryItemId(Long.valueOf(salaryItemId));
                    resultVO.setDataShowType(SWCShowType.AMOUNT.getCode());
                    resultDataList.add(resultVO);
                }
            }
            if (SWCListUtils.isEmpty((List)calbsentry) || SWCListUtils.isEmpty(bizItemList)) continue;
            for (DynamicObject bsEntry : calbsentry) {
                long bizItemId = bsEntry.getLong("bizitem.id");
                if (!bizItemList.contains(bizItemId)) continue;
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                resultMap.put("calPersonId", calPersonId);
                resultMap.put("itemEnum", "BIZITEM");
                resultMap.put("dataShowType", SWCShowType.AMOUNT.getCode());
                resultMap.put("itemId", bizItemId);
                resultMap.put("itemResult", bsEntry.getBigDecimal("bscalamountvalue"));
                bizResultList.add(resultMap);
            }
        }
    }

    private Map<Long, Long> assembleCalResultPersonMap(List<Long> calPersonIdList) {
        HashMap<Long, Long> calResultPersonMap = new HashMap<Long, Long>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObjectCollection objs = helper.queryOriginalCollection("id,calresultid", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)objs)) {
            return calResultPersonMap;
        }
        for (DynamicObject obj : objs) {
            long resultId = obj.getLong("calresultid");
            if (resultId <= 0L) continue;
            calResultPersonMap.put(resultId, obj.getLong("id"));
        }
        return calResultPersonMap;
    }

    private Map<String, List<Long>> assembleCalItemIdList(DynamicObject checkSchemeObj, List<Long> bizItemList) {
        HashMap<String, List<Long>> calItemMap = new HashMap<String, List<Long>>(16);
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        DynamicObjectCollection itemEntryObjs = checkSchemeObj.getDynamicObjectCollection("valueentry");
        if (SWCListUtils.isEmpty((List)itemEntryObjs)) {
            return calItemMap;
        }
        for (DynamicObject obj : itemEntryObjs) {
            if (SWCStringUtils.equals((String)"SL", (String)obj.getString("itemtype"))) {
                itemIdList.add(obj.getLong("itemid"));
            }
            if (!SWCStringUtils.equals((String)"BS", (String)obj.getString("itemtype"))) continue;
            bizItemList.add(obj.getLong("itemid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter filter = new QFilter("id", "in", itemIdList);
        DynamicObjectCollection objs = helper.queryOriginalCollection("id,calblock", new QFilter[]{filter});
        for (DynamicObject obj : objs) {
            String calBlock = obj.getString("calblock");
            List itemIds = calItemMap.computeIfAbsent(calBlock, value -> new ArrayList(10));
            itemIds.add(obj.getLong("id"));
        }
        return calItemMap;
    }

    private DynamicObject[] getUpdateInsuranceDateArr(Map<Long, DynamicObject> calPersonMap, SWCDataServiceHelper insuranceDataHelper, BatchCalResultParamVO batchResult) {
        DynamicObject[] insuranceDatas;
        Map insuranceCalpersonMap = batchResult.getInsuranceCalpersonMap();
        if (insuranceCalpersonMap == null) {
            return null;
        }
        ArrayList insuranceDataIds = new ArrayList(insuranceCalpersonMap.keySet());
        QFilter idFilter = new QFilter("id", "in", insuranceDataIds);
        for (DynamicObject insuranceData : insuranceDatas = insuranceDataHelper.query("id,calperson,salaryfile,caltask,usestatus,withholddate", idFilter.toArray())) {
            insuranceData.set("usestatus", (Object)"1");
            insuranceData.set("caltask", (Object)this.taskId);
            Long calpersonId = (Long)insuranceCalpersonMap.get(insuranceData.getLong("id"));
            insuranceData.set("calperson", (Object)calpersonId);
            DynamicObject calperson = calPersonMap.get(calpersonId);
            if (calperson == null) continue;
            insuranceData.set("salaryfile", (Object)calperson.getLong("salaryfile.id"));
        }
        return insuranceDatas;
    }

    private void delCheckNotPromptData(Long taskId) {
        ResultCheckService resultCheckService = new ResultCheckService();
        resultCheckService.delCheckNotPromptData(taskId);
    }

    private DynamicObject assembleCheckScheme(long payRollScene, long payRollGroupId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("payrollscene", "=", (Object)payRollScene);
        filter.and("payrollgroup", "=", (Object)payRollGroupId);
        String fields = "id,org,payrollgroup,payrollscene,chainincrease,chaingrowth,yearincrease,yeargrowth,valueentry,valueentry.itemid,valueentry.itemtype,valueentry.itemnumber,valueentry.itemname,valueentry.workbenchshow,valueentry.valueequals,valueentry.valueless,valueentry.valuebigger,valueentry.chainincreaseless,valueentry.chainincreasebigger,valueentry.chaingrowthless,valueentry.chaingrowthbigger,valueentry.yearincreaseless,valueentry.yearincreasebigger,valueentry.yeargrowthless,valueentry.yeargrowthbigger";
        DynamicObject[] checkScheme = helper.query(fields, new QFilter[]{filter});
        return checkScheme.length == 0 ? null : checkScheme[0];
    }

    private void asynDeleteResultCheckData(List<Long> calPersonIdList, String calType, DynamicObject task) {
        logger.info("deleteResultCheckData");
        ResultCheckService resultCheckService = new ResultCheckService();
        resultCheckService.deleteCheckDataAndReCount(calPersonIdList, calType, task.getLong("id"));
    }

    private void updateBizDataRelAndUsageCount(List<Long> calPersonIdList, String calType, BatchCalResultParamVO batchResult, Date payRollDate) {
        this.updateRecurBizDataRelAndUsageCount(calPersonIdList, calType, batchResult);
        this.updateNonRecurBizDataRelAndUsageCount(calPersonIdList, calType, batchResult, payRollDate);
    }

    private void updateRecurBizDataRelAndUsageCount(List<Long> calPersonIdList, String calType, BatchCalResultParamVO batchResult) {
        logger.info("updateRecurBizDataRelAndUsageCount begin");
        SWCDataServiceHelper relHelper = new SWCDataServiceHelper("hsas_calbizdatarel");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("caltask.id", "=", (Object)this.taskId);
        Set recurBizDataIdSet = batchResult.getRecurBizDataIdSet();
        if ("afterTaxCal".equals(calType)) {
            HashSet allBizDataIdSet = new HashSet(16);
            if (recurBizDataIdSet != null) {
                allBizDataIdSet.addAll(recurBizDataIdSet);
            }
            filter.and("bizdataid", "in", allBizDataIdSet);
        }
        DynamicObjectCollection calBizDataRelObjs = relHelper.queryOriginalCollection("id,bizdataid", new QFilter[]{filter});
        SWCDataServiceHelper noCntRelHelper = new SWCDataServiceHelper("hsas_calbsnocntrel");
        DynamicObjectCollection calBizDatanNoCntRelObjs = noCntRelHelper.queryOriginalCollection("id,bizdataid", new QFilter[]{filter});
        if (calBizDataRelObjs.size() == 0 && calBizDatanNoCntRelObjs.size() == 0) {
            return;
        }
        HashSet<Long> delBizDataRelSet = new HashSet<Long>(calBizDataRelObjs.size());
        HashSet<Long> recurBizDataSet = new HashSet<Long>(16);
        for (DynamicObject calBizDataRelObj : calBizDataRelObjs) {
            delBizDataRelSet.add(calBizDataRelObj.getLong("id"));
            recurBizDataSet.add(calBizDataRelObj.getLong("bizdataid"));
        }
        HashSet<Long> delBizDataNoCntRelSet = new HashSet<Long>(calBizDataRelObjs.size());
        HashSet<Long> recurBizDataNoCntSet = new HashSet<Long>(16);
        for (DynamicObject calBizDataRelObj : calBizDatanNoCntRelObjs) {
            delBizDataNoCntRelSet.add(calBizDataRelObj.getLong("id"));
            recurBizDataNoCntSet.add(calBizDataRelObj.getLong("bizdataid"));
        }
        if (delBizDataRelSet.size() > 0) {
            relHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", delBizDataRelSet)});
        }
        if (delBizDataNoCntRelSet.size() > 0) {
            noCntRelHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", delBizDataNoCntRelSet)});
        }
        HashSet<Long> allBizDataIdSet = new HashSet<Long>(16);
        allBizDataIdSet.addAll(recurBizDataSet);
        allBizDataIdSet.addAll(recurBizDataNoCntSet);
        if (allBizDataIdSet.size() > 0) {
            DynamicObject[] recurBizDataObjs;
            relHelper.setEntityName("hsas_recurbizdata");
            for (DynamicObject recurBizDataObj : recurBizDataObjs = relHelper.query("id, usagecount,nocounttimes", new QFilter[]{new QFilter("id", "in", allBizDataIdSet)})) {
                if (recurBizDataObj.getInt("usagecount") > 0 && recurBizDataSet.contains(recurBizDataObj.getLong("id"))) {
                    recurBizDataObj.set("usagecount", (Object)(recurBizDataObj.getInt("usagecount") - 1));
                }
                if (recurBizDataObj.getInt("nocounttimes") <= 0 || !recurBizDataNoCntSet.contains(recurBizDataObj.getLong("id"))) continue;
                recurBizDataObj.set("nocounttimes", (Object)(recurBizDataObj.getInt("nocounttimes") - 1));
            }
            relHelper.update(recurBizDataObjs);
        }
        logger.info("updateRecurBizDataRelAndUsageCount end");
    }

    private void updateNonRecurBizDataRelAndUsageCount(List<Long> calPersonIdList, String calType, BatchCalResultParamVO batchResult, Date payRollDate) {
        logger.info("updateNonRecurBizDataRelAndUsageCount begin");
        SWCDataServiceHelper relHelper = new SWCDataServiceHelper("hsas_calnonbizdatarel");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("caltask.id", "=", (Object)this.taskId);
        filter.and("payrolldate", "=", (Object)payRollDate);
        Set nonRecurBizDataIdSet = batchResult.getNonRecurBizDataIdSet();
        if ("afterTaxCal".equals(calType)) {
            HashSet allBizDataIdSet = new HashSet(16);
            if (nonRecurBizDataIdSet != null) {
                allBizDataIdSet.addAll(nonRecurBizDataIdSet);
            }
            filter.and("bizdataid", "in", allBizDataIdSet);
        }
        DynamicObjectCollection calBizDataRelObjs = relHelper.queryOriginalCollection("id, bizdataid", new QFilter[]{filter});
        SWCDataServiceHelper noCntRelHelper = new SWCDataServiceHelper("hsas_noncalbsnocntrel");
        DynamicObjectCollection calBizDataNoCntRelObjs = noCntRelHelper.queryOriginalCollection("id, bizdataid", new QFilter[]{filter});
        if (calBizDataRelObjs.size() == 0 && calBizDataNoCntRelObjs.size() == 0) {
            return;
        }
        HashSet<Long> delBizDataRelSet = new HashSet<Long>(calBizDataRelObjs.size());
        HashSet<Long> nonRecurBizDataSet = new HashSet<Long>(16);
        for (DynamicObject calBizDataRelObj : calBizDataRelObjs) {
            delBizDataRelSet.add(calBizDataRelObj.getLong("id"));
            nonRecurBizDataSet.add(calBizDataRelObj.getLong("bizdataid"));
        }
        HashSet<Long> delBizDataNoCntRelSet = new HashSet<Long>(calBizDataRelObjs.size());
        HashSet<Long> nonRecurBizDataNoCntSet = new HashSet<Long>(16);
        for (DynamicObject calBizDataRelObj : calBizDataNoCntRelObjs) {
            delBizDataNoCntRelSet.add(calBizDataRelObj.getLong("id"));
            nonRecurBizDataNoCntSet.add(calBizDataRelObj.getLong("bizdataid"));
        }
        if (delBizDataRelSet.size() > 0) {
            relHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", delBizDataRelSet)});
        }
        if (delBizDataNoCntRelSet.size() > 0) {
            noCntRelHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", delBizDataNoCntRelSet)});
        }
        HashSet<Long> allNonBizDataIdSet = new HashSet<Long>(16);
        allNonBizDataIdSet.addAll(nonRecurBizDataIdSet);
        allNonBizDataIdSet.addAll(nonRecurBizDataNoCntSet);
        if (allNonBizDataIdSet.size() > 0) {
            QFilter recordFilter;
            SWCDataServiceHelper bizDataRecordHelper;
            DynamicObject[] bizDataRecordArray;
            DynamicObject[] nonRecurBizDataObjs;
            HashMap bizDataRecordUseCountMap = new HashMap(16);
            Map recordCountMap = null;
            relHelper.setEntityName("hsas_nonrecurbizdata");
            for (DynamicObject nonRecurBizDataObj : nonRecurBizDataObjs = relHelper.query("id, usagecount,nocounttimes,bizdatarecord", new QFilter[]{new QFilter("id", "in", allNonBizDataIdSet)})) {
                long bizDataRecordId;
                int useCount = 0;
                int noCount = 0;
                if (nonRecurBizDataObj.getInt("usagecount") > 0 && nonRecurBizDataSet.contains(nonRecurBizDataObj.getLong("id"))) {
                    nonRecurBizDataObj.set("usagecount", (Object)(nonRecurBizDataObj.getInt("usagecount") - 1));
                    useCount = 1;
                }
                if (nonRecurBizDataObj.getInt("nocounttimes") > 0 && nonRecurBizDataNoCntSet.contains(nonRecurBizDataObj.getLong("id"))) {
                    nonRecurBizDataObj.set("nocounttimes", (Object)(nonRecurBizDataObj.getInt("nocounttimes") - 1));
                    noCount = 1;
                }
                if ((recordCountMap = (HashMap<String, Integer>)bizDataRecordUseCountMap.get(bizDataRecordId = nonRecurBizDataObj.getLong("bizdatarecord"))) == null) {
                    recordCountMap = new HashMap<String, Integer>(2);
                    bizDataRecordUseCountMap.put(bizDataRecordId, recordCountMap);
                }
                Integer existUseCount = (Integer)recordCountMap.get("usagecount");
                Integer existNoCount = (Integer)recordCountMap.get("nocounttimes");
                if (existNoCount == null) {
                    existNoCount = 0;
                }
                if (existUseCount == null) {
                    existUseCount = 0;
                }
                recordCountMap.put("usagecount", existUseCount + useCount);
                recordCountMap.put("nocounttimes", existNoCount + noCount);
            }
            relHelper.update(nonRecurBizDataObjs);
            if (bizDataRecordUseCountMap.size() > 0 && (bizDataRecordArray = (bizDataRecordHelper = new SWCDataServiceHelper("hsas_bizdatarecord")).query("id,usagecount,nocounttimes,modifytime", new QFilter[]{recordFilter = new QFilter("id", "in", bizDataRecordUseCountMap.keySet())})) != null && bizDataRecordArray.length > 0) {
                Date modifyTime = new Date();
                for (DynamicObject recordObj : bizDataRecordArray) {
                    int tempNoCount;
                    recordCountMap = (Map)bizDataRecordUseCountMap.get(recordObj.getLong("id"));
                    int tempUseCount = recordObj.getInt("usagecount") - (Integer)recordCountMap.get("usagecount");
                    if (tempUseCount < 0) {
                        tempUseCount = 0;
                    }
                    if ((tempNoCount = recordObj.getInt("nocounttimes") - (Integer)recordCountMap.get("nocounttimes")) < 0) {
                        tempNoCount = 0;
                    }
                    recordObj.set("usagecount", (Object)tempUseCount);
                    recordObj.set("nocounttimes", (Object)tempNoCount);
                    recordObj.set("modifytime", (Object)modifyTime);
                }
                bizDataRecordHelper.update(bizDataRecordArray);
            }
        }
        logger.info("updateNonRecurBizDataRelAndUsageCount end");
    }

    private void asynSaveSalaryResult(List<Long> calPersonIdList, List<CalResultVO> calResultList, DynamicObject task) {
        RequestContext ctx = RequestContext.get();
        SWCThreadPoolFactory.getAftercalAsyncThreadpool().execute(() -> {
            logger.info("asynSaveSalaryResult,traceId={}", (Object)ctx.getTraceId());
            RequestContext.copyAndSet((RequestContext)ctx);
            logger.info("asynSaveSalaryResult,traceId={}", (Object)ctx.getTraceId());
            SalaryResultService salaryResultService = new SalaryResultService();
            salaryResultService.saveSalaryResultList(calPersonIdList, calResultList, task);
        }, RequestContext.get());
    }

    private void cleanCalTableData(List<Long> calPersonIdList, String calType) {
        if ("afterTaxCal".equals(calType)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("caltask", "=", (Object)this.taskId);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    private DynamicObjectCollection handleAccData(List<AccDetailsVO> accDetailsList, DynamicObjectCollection accResultList, List<Long> sucessCalIdList, DynamicObject task, String calType, Map<Long, AccInfo> accInfoMap) {
        logger.info("getExistAccDetailData begin,batchId = {}", (Object)this.batchId);
        DynamicObject[] existAccDetailData = this.getExistAccDetailData(sucessCalIdList);
        logger.info("getExistAccDetailData end,batchId = {}", (Object)this.batchId);
        ArrayList<Long> accResultIdList = new ArrayList<Long>(10);
        accResultIdList.addAll(accDetailsList.stream().map(AccDetailsVO::getAccResultId).collect(Collectors.toList()));
        HashMap<String, DynamicObject> existAccDetailMap = new HashMap<String, DynamicObject>(16);
        String key = null;
        for (DynamicObject accDetail : existAccDetailData) {
            long accResultId = accDetail.getLong("accresult.id");
            if (!accResultIdList.contains(accResultId)) {
                accResultIdList.add(accResultId);
            }
            key = accDetail.getLong("calpersonid") + "@;@" + accResultId;
            existAccDetailMap.put(key, accDetail);
        }
        logger.info("getAccResultDataMap begin,batchId = {}", (Object)this.batchId);
        Map<Long, DynamicObject> accResultMap = this.getAccResultDataMap(accResultIdList, calType);
        logger.info("getAccResultDataMap end,batchId = {}", (Object)this.batchId);
        return this.handleAccDetailsData(accDetailsList, accResultMap, task, accResultList, existAccDetailMap, calType, accInfoMap);
    }

    private DynamicObjectCollection handleAccDetailsData(List<AccDetailsVO> accDetailsList, Map<Long, DynamicObject> accResultMap, DynamicObject task, DynamicObjectCollection accResultList, Map<String, DynamicObject> existAccDetailMap, String calType, Map<Long, AccInfo> accInfoMap) {
        DynamicObjectCollection accDetailObjList = new DynamicObjectCollection();
        DynamicObject accResult = null;
        String key = null;
        SWCDataServiceHelper accDetailHelper = new SWCDataServiceHelper("hsas_accdetails");
        DynamicObject accDetailObj = null;
        AccInfo accInfo = null;
        for (AccDetailsVO accDetail : accDetailsList) {
            key = accDetail.getCalPersonId() + "@;@" + accDetail.getAccResultId();
            accInfo = accInfoMap.get(accDetail.getAccId());
            accDetailObj = accDetailHelper.generateEmptyDynamicObject();
            accDetailObj.set("caltask", (Object)this.taskId);
            accDetailObj.set("accresult", (Object)accDetail.getAccResultId());
            accDetailObj.set("calpersonid", (Object)accDetail.getCalPersonId());
            accDetailObj.set("currency", (Object)accDetail.getCurrencyId());
            accDetailObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            accDetailObj.set("createtime", (Object)new Date());
            accDetailObj.set("currentvalue", (Object)this.dealResultValueScal(accDetail.getCurrentValue(), accInfo.getDataPrecisionId(), accInfo.getDataTypeId(), accInfo.getDataRoundId(), task.getInt("payrollgroupv.currency.amtprecision")));
            accDetailObj.set("memberinfo", (Object)SerializationUtils.toJsonString((Object)accDetail.getMemberInfo()));
            accDetailObj.set("initvalue", (Object)accDetail.getInitValue());
            accDetailObj.set("index", (Object)accDetail.getIndex());
            accDetailObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            accDetailObj.set("modifytime", (Object)new Date());
            accDetailObjList.add((Object)accDetailObj);
            accResult = accResultMap.get(accDetail.getAccResultId());
            if (accResult != null) {
                this.sumAccDetailValue(accDetail, accResult, task, existAccDetailMap.get(key), accInfo);
                accResultList.add((Object)accResult);
                accDetailObj.set("updatestatus", (Object)"2");
            } else {
                accDetailObj.set("updatestatus", (Object)"1");
            }
            existAccDetailMap.remove(key);
        }
        this.dealCalPreAccDetailData(existAccDetailMap, accResultMap, accResultList, accDetailObjList, calType, task);
        return accDetailObjList;
    }

    private void dealCalPreAccDetailData(Map<String, DynamicObject> existAccDetailMap, Map<Long, DynamicObject> accResultMap, DynamicObjectCollection accResultList, DynamicObjectCollection accDetailObjList, String calType, DynamicObject task) {
        if (!SWCStringUtils.equals((String)calType, (String)"afterTaxCal") || existAccDetailMap.size() == 0) {
            return;
        }
        SWCDataServiceHelper accDetailHelper = new SWCDataServiceHelper("hsas_accdetails");
        DynamicObject accDetail = null;
        DynamicObject accResult = null;
        DynamicObject accDetailObj = null;
        BigDecimal resultValue = null;
        for (Map.Entry<String, DynamicObject> entry : existAccDetailMap.entrySet()) {
            accDetail = entry.getValue();
            if (SWCStringUtils.equals((String)accDetail.getString("updatestatus"), (String)"2") || (accResult = accResultMap.get(accDetail.getLong("accresult.id"))) == null) continue;
            accDetailObj = accDetailHelper.generateEmptyDynamicObject();
            accDetailObj.set("caltask", (Object)this.taskId);
            accDetailObj.set("accresult", (Object)accDetail.getLong("accresult.id"));
            accDetailObj.set("calpersonid", (Object)accDetail.getLong("calpersonid"));
            if (accResult.getLong("acc.datatype.id") == 1010L) {
                accDetailObj.set("currency", (Object)0L);
            } else {
                accDetailObj.set("currency", (Object)accDetail.getLong("currency.id"));
            }
            accDetailObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            accDetailObj.set("createtime", (Object)new Date());
            accDetailObj.set("currentvalue", (Object)accDetail.getBigDecimal("currentvalue"));
            accDetailObj.set("memberinfo", (Object)accDetail.getString("memberinfo"));
            accDetailObj.set("initvalue", (Object)accDetail.getBigDecimal("initvalue"));
            accDetailObj.set("index", (Object)accDetail.getBigDecimal("index"));
            accDetailObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            accDetailObj.set("modifytime", (Object)new Date());
            accDetailObj.set("updatestatus", (Object)"2");
            accDetailObjList.add((Object)accDetailObj);
            if (accDetail.getLong("currency.id") == accResult.getLong("currency.id") || accResult.getLong("acc.datatype.id") == 1010L) {
                resultValue = accResult.getBigDecimal("resultvalue").add(accDetail.getBigDecimal("currentvalue"));
                accResult.set("resultvalue", (Object)this.dealResultValueScal(resultValue, accResult.getLong("acc.dataprecision.id"), accResult.getLong("acc.datatype.id"), accResult.getLong("acc.dataround.id"), task.getInt("payrollgroupv.currency.amtprecision")));
            } else {
                BigDecimal result = this.translateExchangeRate(accDetail.getLong("currency.id"), accResult, task);
                resultValue = result.add(accDetail.getBigDecimal("currentvalue"));
                accResult.set("resultvalue", (Object)this.dealResultValueScal(resultValue, accResult.getLong("acc.dataprecision.id"), accResult.getLong("acc.datatype.id"), accResult.getLong("acc.dataround.id"), task.getInt("payrollgroupv.currency.amtprecision")));
                accResult.set("currency", (Object)accDetail.getLong("currency.id"));
            }
            accResultList.add((Object)accResult);
        }
    }

    private BigDecimal dealResultValueScal(BigDecimal resultValue, long dataPrecisionId, long dataTypeId, long dataRoundId, int amtPrecision) {
        int newScale = 1020L == dataTypeId ? amtPrecision : ItemDataUtils.getScal((long)dataPrecisionId);
        return resultValue.setScale(newScale, ItemDataUtils.getRoundingMode((long)dataRoundId));
    }

    private DynamicObject[] getExistAccDetailData(List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        String fields = "calpersonid,accresult.id,index,currency.id,currentvalue,initvalue,updatestatus,memberinfo";
        QFilter qFilter = new QFilter("calpersonid", "in", calPersonIdList);
        qFilter.and("caltask", "=", (Object)this.taskId);
        return helper.query(fields, new QFilter[]{qFilter});
    }

    private void sumAccDetailValue(AccDetailsVO accDetail, DynamicObject accResult, DynamicObject task, DynamicObject accDetailObj, AccInfo accInfo) {
        BigDecimal existValue = BigDecimal.ZERO;
        if (null != accDetailObj && SWCStringUtils.equals((String)accDetailObj.getString("updatestatus"), (String)"2")) {
            existValue = accDetailObj.getBigDecimal("currentvalue") == null ? BigDecimal.ZERO : accDetailObj.getBigDecimal("currentvalue");
        }
        BigDecimal accValue = null;
        if (accDetail.getCurrencyId() == accResult.getLong("currency.id") || BigDecimal.ZERO.compareTo(accResult.getBigDecimal("resultvalue")) == 0 || accInfo.getDataTypeId() == 1010L) {
            accValue = accDetail.getCurrentValue().add(accResult.getBigDecimal("resultvalue")).subtract(existValue);
            accResult.set("resultvalue", (Object)this.dealResultValueScal(accValue, accInfo.getDataPrecisionId(), accInfo.getDataTypeId(), accInfo.getDataRoundId(), task.getInt("payrollgroupv.currency.amtprecision")));
            accResult.set("currency", (Object)accDetail.getCurrencyId());
            return;
        }
        BigDecimal result = this.translateExchangeRate(accDetail.getCurrencyId(), accResult, task);
        accValue = accDetail.getCurrentValue().add(result).subtract(existValue);
        accResult.set("resultvalue", (Object)this.dealResultValueScal(accValue, accInfo.getDataPrecisionId(), accInfo.getDataTypeId(), accInfo.getDataRoundId(), task.getInt("payrollgroupv.currency.amtprecision")));
        accResult.set("currency", (Object)accDetail.getCurrencyId());
    }

    private BigDecimal translateExchangeRate(long targetCurrencyId, DynamicObject accResult, DynamicObject task) {
        String key = targetCurrencyId + "@" + accResult.getLong("currency.id");
        ExchangeRateInfo rateInfo = this.exrateCacheMap.get(key);
        if (rateInfo == null) {
            rateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)accResult.getLong("currency.id"), (Long)targetCurrencyId, (Long)task.getLong("payrollgroupv.exratetable.id"), (Date)task.getDate("exratedate"));
        }
        BigDecimal result = null;
        if (null != rateInfo) {
            this.exrateCacheMap.put(key, rateInfo);
            result = rateInfo.getQuoteType().booleanValue() ? accResult.getBigDecimal("resultvalue").divide(rateInfo.getExchangeRate(), 18, 1) : accResult.getBigDecimal("resultvalue").multiply(rateInfo.getExchangeRate());
        } else {
            logger.error("getExrate null,accResultId={}", (Object)accResult.getLong("id"));
            result = accResult.getBigDecimal("resultvalue");
        }
        return result;
    }

    private Map<Long, DynamicObject> getAccResultDataMap(List<Long> accResultIdList, String calType) {
        if (SWCStringUtils.equals((String)calType, (String)"preTaxCal") || SWCStringUtils.equals((String)calType, (String)"onlyPreTaxCal")) {
            return new HashMap<Long, DynamicObject>(0);
        }
        DynamicObject[] accResultData = this.getAccResultData(accResultIdList);
        return Arrays.asList(accResultData).stream().collect(Collectors.toMap(accResult -> accResult.getLong("id"), accResult -> accResult));
    }

    private DynamicObject[] getAccResultData(List<Long> accResultIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String fields = "id,currency,resultvalue,acc.datatype.id,acc.dataprecision.id,acc.dataround.id";
        return helper.query(fields, new QFilter[]{new QFilter("id", "in", accResultIdList)});
    }

    private Map<Long, Long> saveFormulaItemValueData(List<CalResultItem> calResultItems, Map<Long, DynamicObject> successCalMap, Map<Long, DynamicObject> failureCalMap, String calType, DynamicObject task, List<CalResultItemRel> calResultItemRelList) {
        SaveCalItemService service;
        logger.info("begin saveFormulaItemValueData");
        Map<Long, Long> calPersonMapCalTable = null;
        if (successCalMap != null && !successCalMap.isEmpty()) {
            service = new SaveCalItemService(successCalMap, calType, this.taskId, task);
            service.saveCalItemData(calResultItems, calResultItemRelList);
            calPersonMapCalTable = service.getCalPersonMapCalTable();
        }
        if (failureCalMap != null && !failureCalMap.isEmpty()) {
            service = new SaveCalItemService(failureCalMap, calType, this.taskId, task);
            service.deleteCalItemData();
        }
        logger.info("end saveFormulaItemValueData");
        return calPersonMapCalTable;
    }

    private void saveCalDetail(List<CalRecordVO> calDetailList, String calStatus, String failType, String failMsg, String calType, List<Long> calPersonIdList) {
        SWCDataServiceHelper calDetailHelper = new SWCDataServiceHelper("hsas_caldetail");
        DynamicObject[] calDetails = this.getCalDetailData(calPersonIdList);
        HashMap<Long, DynamicObject> calDetailMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject obj : calDetails) {
            calDetailMap.put(obj.getLong("calpersonid"), obj);
        }
        DynamicObject tempCalDetail = null;
        for (CalRecordVO calDetail : calDetailList) {
            if (SWCStringUtils.equals((String)calType, (String)"preTaxCal") && SWCStringUtils.isEmpty((String)calStatus) && SWCStringUtils.equals((String)calDetail.getCalStatus(), (String)"1") || (tempCalDetail = (DynamicObject)calDetailMap.get(Long.valueOf(calDetail.getCalPersonId()))) == null) continue;
            tempCalDetail.set("modifytime", (Object)new Date());
            if (SWCStringUtils.equals((String)calStatus, (String)"2")) {
                tempCalDetail.set("failtype", (Object)failType);
                tempCalDetail.set("errorelement", (Object)"-");
                if (failMsg != null && failMsg.length() > 900) {
                    failMsg = failMsg.substring(0, 900);
                }
                tempCalDetail.set("failmsg", (Object)failMsg);
                tempCalDetail.set("calstatus", (Object)calStatus);
                continue;
            }
            tempCalDetail.set("calstatus", (Object)calDetail.getCalStatus());
            tempCalDetail.set("failtype", (Object)calDetail.getFailType());
            tempCalDetail.set("errorelement", (Object)calDetail.getErrorElement());
            if (calDetail.getFailMsg() != null && calDetail.getFailMsg().length() > 900) {
                tempCalDetail.set("failmsg", (Object)calDetail.getFailMsg().substring(0, 900));
                continue;
            }
            tempCalDetail.set("failmsg", (Object)calDetail.getFailMsg());
        }
        calDetailHelper.update(calDetailMap.values().toArray(new DynamicObject[calDetailMap.size()]));
    }

    private DynamicObject[] getCalDetailData(List<Long> calPersonIdList) {
        SWCDataServiceHelper calDetailHelper = new SWCDataServiceHelper("hsas_caldetail");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)this.taskId);
        qFilter.and("record.id", "=", (Object)this.recordId);
        qFilter.and("batch.id", "=", (Object)this.batchId);
        qFilter.and("calpersonid", "in", calPersonIdList);
        return calDetailHelper.query("id,failtype,calpersonid,record,failmsg,errorelement,calstatus,modifytime", new QFilter[]{qFilter});
    }

    private DynamicObject[] getCalPersonList(List<Long> calPersonIdList, String calType) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,calstatus,bizdatagenstatus,taxstatus,salaryfile.id,salaryfile.employee.id,modifier,modifytime,calresultid,caltask,org,belongperiod,calmainid,adminorg,iscalresult,personhrv.personindexid";
        QFilter calTaskFilter = new QFilter("caltask", "=", (Object)this.taskId);
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        filter.and(CalUtils.getFilterByCalType(calType));
        return calTableHelper.query(selectProperties, new QFilter[]{calTaskFilter, filter});
    }

    private void updateCalPersonCalStatus(DynamicObject[] objs, String calType) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        String calState = null;
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject obj : objs) {
            calState = CalOperationHelper.getFailCalStateByCalType(calType);
            obj.set("calstatus", (Object)calState);
            obj.set("modifytime", (Object)date);
            obj.set("modifier", (Object)userId);
        }
        calTableHelper.update(objs);
    }

    private void setCalState(DynamicObject[] objs, Map<String, String> calStateMap, Map<Long, Long> calPersonMapCalTable, String calType) {
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        String calState = null;
        for (DynamicObject calPerson : objs) {
            Long idLong = calPerson.getLong("id");
            String id = String.valueOf(idLong);
            calState = calStateMap.get(id);
            calPerson.set("modifytime", (Object)date);
            calPerson.set("modifier", (Object)userId);
            calPerson.set("calstatus", (Object)calState);
            calPerson.set("bizdatagenstatus", (Object)"1");
            calPerson.set("iscalresult", (Object)"1");
            if (!SWCStringUtils.equals((String)calType, (String)"afterTaxCal")) {
                calPerson.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
            }
            if (calPersonMapCalTable == null) {
                this.setFailCalResultIdByCalType(calType, calPerson);
                continue;
            }
            Long calResultId = calPersonMapCalTable.get(idLong);
            if (calResultId == null) {
                calPerson.set("calstatus", (Object)CalOperationHelper.getFailCalStateByCalType(calType));
                this.setFailCalResultIdByCalType(calType, calPerson);
                calStateMap.put(id, CalOperationHelper.getFailCalStateByCalType(calType));
                continue;
            }
            if (calResultId == 0L) {
                calPerson.set("calstatus", (Object)CalOperationHelper.getFailCalStateByCalType(calType));
                this.setFailCalResultIdByCalType(calType, calPerson);
                calStateMap.put(id, CalOperationHelper.getFailCalStateByCalType(calType));
                ++this.failCount;
                --this.successCount;
                continue;
            }
            calPerson.set("calresultid", (Object)calResultId);
        }
    }

    private void setFailCalResultIdByCalType(String calType, DynamicObject calPerson) {
        if (!"afterTaxCal".equals(calType)) {
            calPerson.set("calresultid", (Object)0L);
        }
    }

    private void updateCalBatch(String calStatus) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calbatch");
        String selectProperties = "id,calstatus";
        QFilter filter = new QFilter("id", "=", (Object)this.batchId);
        DynamicObject obj = helper.queryOne(selectProperties, new QFilter[]{filter});
        obj.set("calstatus", (Object)calStatus);
        helper.updateOne(obj);
    }

    private void insertOperationRecord(String desc) {
        SWCDataServiceHelper calOpHelper = new SWCDataServiceHelper("hsas_caloperation");
        Date date = new Date();
        DynamicObject calOp = calOpHelper.generateEmptyDynamicObject();
        calOp.set("record", (Object)this.recordId);
        calOp.set("batch", (Object)this.batchId);
        calOp.set("optype", (Object)OperationTypeEnum.SAVE.getCode());
        calOp.set("starttime", (Object)this.startDate);
        calOp.set("endtime", (Object)date);
        calOp.set("createtime", (Object)date);
        calOp.set("modifytime", (Object)date);
        calOp.set("creator", (Object)RequestContext.get().getCurrUserId());
        calOp.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if (desc != null && desc.length() > 254) {
            calOp.set("description", (Object)desc.substring(0, 254));
        } else {
            calOp.set("description", (Object)desc);
        }
        calOpHelper.saveOne(calOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotFoundCalResult(DynamicObject[] calPersonArray, String calType) {
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(calPersonArray.length);
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(calPersonArray.length);
        for (DynamicObject obj : calPersonArray) {
            calPersonIdList.add(obj.getLong("id"));
            obj.set("calstatus", (Object)CalOperationHelper.getFailCalStateByCalType(calType));
            obj.set("modifytime", (Object)new Date());
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            obj.set("iscalresult", (Object)"1");
            if (!SWCStringUtils.equals((String)calType, (String)"afterTaxCal")) {
                obj.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
                obj.set("calresultid", (Object)0L);
            }
            personIndexIdList.add(obj.getLong("personhrv.personindexid"));
        }
        DynamicObject[] calDetails = this.getCalDetailData(calPersonIdList);
        String failMsg = ResManager.loadKDString((String)"\u7f13\u5b58\u4e2d\u95f4\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u4ece\u7f13\u5b58\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"FormulaCalRecord_3", (String)"swc-hscs-business", (Object[])new Object[0]);
        for (DynamicObject calDetail : calDetails) {
            calDetail.set("calstatus", (Object)CalStatusEnum.FAIL.getCode());
            calDetail.set("errorelement", (Object)"-");
            calDetail.set("failtype", (Object)FailureTypeEnum.SAVE_FAIL.getCode());
            calDetail.set("failmsg", (Object)failMsg);
            calDetail.set("modifytime", (Object)new Date());
        }
        try (TXHandle tx = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            helper.update(calPersonArray);
            helper.setEntityName("hsas_caldetail");
            helper.update(calDetails);
            if (!"afterTaxCal".equals(calType)) {
                helper.setEntityName("hsas_caltable");
                QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
                filter.and("caltask", "=", (Object)this.taskId);
                helper.deleteByFilter(new QFilter[]{filter});
            }
            this.sumFailCount = calPersonIdList.size();
            this.sumSuccessCount = 0;
            ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.recordId));
            boolean isFinish = CalUtils.updateSaveProcess(this.sumSuccessCount, this.sumFailCount, calProgressAppCache, calType, this.taskId, this.recordId);
            if (isFinish) {
                ISWCAppCache pushAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_PUSH_%s", this.recordId));
                pushAppCache.remove(String.format(Locale.ROOT, "SWC_PUSH_%s", this.recordId));
            }
            CalUtils.deleteSalaryCalMutexData(personIndexIdList, this.taskId);
        }
        CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), calType, this.sumSuccessCount, this.sumFailCount);
        CalUtils.addCalOperation(this.recordId, this.batchId, OperationTypeEnum.SAVE.getCode(), this.startDate, operationVO);
    }
}

