/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.common.vo.CalResultVO;
import kd.swc.hscs.common.vo.check.BasicCheckResult;
import kd.swc.hscs.common.vo.check.CheckStatisticalResult;
import kd.swc.hscs.common.vo.check.DetailStatisticResult;

public class ResultCheckService {
    private static final Log logger = LogFactory.getLog(ResultCheckService.class);
    private static final String KEY_BIZITEM = "BIZITEM";
    private static final String KEY_DATASHOWTYPE = "dataShowType";
    private static final String KEY_CALPERSONID = "calPersonId";
    private static final String KEY_ITEMRESULT = "itemResult";
    private static final String KEY_ITEMCODE = "itemId";
    private static final String CHAIN_TYPE = "1";
    private static final String YEAR_TYPE = "2";
    private static ThreadLocal<Integer> errCount = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResultCheckData(DynamicObject checkSchemeObj, Map<Long, DynamicObject> successCalMap, List<CalResultVO> calResultList, List<Map<String, Object>> tempResultList, DynamicObject task) {
        logger.info("saveResultCheckData,successCalMap.size:{},calResultList.size:{},tempResultList.size:{}", new Object[]{successCalMap.size(), calResultList.size(), tempResultList.size()});
        DynamicObjectCollection itemEntryObjs = checkSchemeObj.getDynamicObjectCollection("valueentry");
        if (SWCListUtils.isEmpty((List)itemEntryObjs)) {
            return;
        }
        List<String> checkIndexList = this.assembleCheckIndexList(checkSchemeObj);
        Map<String, List<Long>> itemMap = this.assembleCheckItemMap(itemEntryObjs);
        logger.info("itemMap:{}", (Object)itemMap.toString());
        if (!SWCListUtils.isEmpty(itemMap.get(CalResultItemEnum.SALARYITEM.getCode())) || !SWCListUtils.isEmpty(itemMap.get(CalResultItemEnum.BIZITEM.getCode()))) {
            try (TXHandle txHandle = TX.requiresNew();){
                this.handleItemCheckData(checkSchemeObj, task, successCalMap, calResultList, tempResultList, itemMap, checkIndexList);
            }
        }
    }

    private void handleItemCheckData(DynamicObject checkSchemeObj, DynamicObject task, Map<Long, DynamicObject> successCalMap, List<CalResultVO> calResultList, List<Map<String, Object>> tempResultList, Map<String, List<Long>> itemIdMap, List<String> checkIndexList) {
        Map<Long, Long> personSalaryfileMap = successCalMap.values().stream().collect(Collectors.toMap(key -> key.getLong("salaryfile.id"), value -> value.getLong("id")));
        Map<Long, Map<Long, BigDecimal>> personCalResultMap = this.assembleCalItemResult(calResultList, successCalMap, tempResultList, itemIdMap);
        logger.info("personCalResultMap:{}", (Object)personCalResultMap.toString());
        HashMap<Long, Map<Long, Map<String, Object>>> itemChainYearResult = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        long start = System.currentTimeMillis();
        this.assembleItemChainYearResult(itemChainYearResult, task, checkIndexList, personSalaryfileMap, personCalResultMap, itemIdMap);
        logger.info("assembleItemChainYearResult_finish,itemChainYearResult.size:{},cost:{} ms", (Object)itemChainYearResult.size(), (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.doCheckDataCount(task, checkSchemeObj, itemChainYearResult, successCalMap, personSalaryfileMap);
        logger.info("doCheckDataCount_finish,cost:{} ms", (Object)(System.currentTimeMillis() - start));
    }

    public void doCheckDataCount(DynamicObject task, DynamicObject checkSchemeObj, Map<Long, Map<Long, Map<String, Object>>> itemChainYearResult, Map<Long, DynamicObject> successCalMap, Map<Long, Long> personSalaryfileMap) {
        DynamicObjectCollection itemEntryObjs = checkSchemeObj.getDynamicObjectCollection("valueentry");
        Map<Long, DynamicObject> itemMap = itemEntryObjs.stream().collect(Collectors.toMap(key -> key.getLong("itemid"), Function.identity(), (k1, k2) -> k2));
        long taskId = task.getLong("id");
        long checkSchemeId = checkSchemeObj.getLong("id");
        this.doSaveCheckStatsData(checkSchemeObj, itemMap, taskId, checkSchemeId, itemChainYearResult, successCalMap, personSalaryfileMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveCheckStatsData(DynamicObject checkSchemeObj, Map<Long, DynamicObject> itemMap, long taskId, long checkSchemeId, Map<Long, Map<Long, Map<String, Object>>> itemChainYearResult, Map<Long, DynamicObject> successCalMap, Map<Long, Long> personSalaryfileMap) {
        long start = System.currentTimeMillis();
        HashMap<Long, List<Long>> adminOrgPersonsMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, Long> personAdminOrgMap = new HashMap<Long, Long>(16);
        Set<Long> adminOrgIdSet = this.assembleCalResultAdmonOrgIdSet(personAdminOrgMap, adminOrgPersonsMap, successCalMap);
        ArrayList<Long> existAdminOrgIdList = new ArrayList<Long>(10);
        ArrayList<Long> newAdminOrgIdList = new ArrayList<Long>(10);
        this.checkExistAdminOrgId(adminOrgIdSet, existAdminOrgIdList, newAdminOrgIdList, checkSchemeId, taskId);
        if (!SWCListUtils.isEmpty(newAdminOrgIdList)) {
            this.saveNewCheckRetStats(newAdminOrgIdList, checkSchemeId, taskId);
        }
        Map<Long, Long> adminOrgCheckStatIdMap = this.queryAdminOrgCheckStatIdMap(adminOrgIdSet, checkSchemeId, taskId);
        List<CheckStatisticalResult> checkStatisticalResultList = this.assembleCheckStatData(checkSchemeObj, personAdminOrgMap, adminOrgPersonsMap, itemMap, adminOrgCheckStatIdMap, personSalaryfileMap, itemChainYearResult);
        List<Long> existCheckStatId = adminOrgCheckStatIdMap.values().stream().collect(Collectors.toList());
        Map<String, String> existIndexStats = this.assembleExistCheckIndexStats(existCheckStatId);
        ArrayList<Map<String, Object>> existCheckIndexStatList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> newCheckIndexStatList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> newCheckIndexPersonList = new ArrayList<Map<String, Object>>(10);
        HashSet<String> waitDeleteKey = new HashSet<String>(16);
        this.assembleCheckIndexStatAndPersonData(waitDeleteKey, existIndexStats, checkStatisticalResultList, newCheckIndexPersonList, existCheckIndexStatList, newCheckIndexStatList);
        logger.info("assembleCheckStatisticlResult_finish,cost:{} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        try (TXHandle txHandle = TX.requiresNew();){
            if (waitDeleteKey.size() > 0) {
                this.deleteChangeCheckData(waitDeleteKey);
            }
            this.saveNewIndexStatsData(newCheckIndexStatList, null, taskId);
        }
        logger.info("saveNewIndexStatsData_finish,cost:{} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.saveNewIndexPersonData(newCheckIndexPersonList);
        logger.info("saveNewIndexPersonData_finish,cost:{} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        if (!SWCListUtils.isEmpty(existCheckIndexStatList)) {
            this.updateExistCheckIndexStatData(existCheckIndexStatList, taskId);
            logger.info("updateExistCheckIndexStatData,cost:{} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void deleteChangeCheckData(Set<String> waitDeleteKey) {
        logger.info("deleteChangeCheckData_keys:{}", waitDeleteKey);
        HashSet<Long> itemIds = new HashSet<Long>(waitDeleteKey.size());
        HashSet<String> indexCodes = new HashSet<String>(waitDeleteKey.size());
        for (String waitKey : waitDeleteKey) {
            String[] split = waitKey.split("-");
            itemIds.add(Long.parseLong(split[0]));
            indexCodes.add(split[1]);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexperson");
        QFilter filter = new QFilter("itemid", "in", itemIds);
        filter.and("indexcode", "in", indexCodes);
        int cnt = helper.deleteByFilter(new QFilter[]{filter});
        logger.info("delete_checkindexperson:{}", (Object)cnt);
        helper = new SWCDataServiceHelper("hsas_checkindexstats");
        cnt = helper.deleteByFilter(new QFilter[]{filter});
        logger.info("delete_checkindexstats:{}", (Object)cnt);
    }

    private List<CheckStatisticalResult> assembleCheckStatData(DynamicObject checkSchemeObj, Map<Long, Long> personAdminOrgMap, Map<Long, List<Long>> adminOrgPersonsMap, Map<Long, DynamicObject> itemMap, Map<Long, Long> orgCheckStatIdMap, Map<Long, Long> personSalaryfileMap, Map<Long, Map<Long, Map<String, Object>>> itemChainYearResult) {
        ArrayList<CheckStatisticalResult> list = new ArrayList<CheckStatisticalResult>(10);
        HashMap<Long, Map> adminOrgMap = new HashMap<Long, Map>(16);
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : itemChainYearResult.entrySet()) {
            Long salaryFileId = entry.getKey();
            Long personId = personSalaryfileMap.get(salaryFileId);
            Long adminOrgId = personAdminOrgMap.get(personId);
            Map itemDataMap = adminOrgMap.computeIfAbsent(adminOrgId, adminMap -> new HashMap(16));
            Map<Long, Map<String, Object>> value = entry.getValue();
            for (Map.Entry<Long, Map<String, Object>> indexEntry : value.entrySet()) {
                Long itemId = indexEntry.getKey();
                Map<String, Object> dataMap = indexEntry.getValue();
                List personDataList = itemDataMap.computeIfAbsent(itemId, data -> new ArrayList(10));
                personDataList.add(dataMap);
            }
        }
        logger.info("adminOrgMap:{}", (Object)((Object)adminOrgMap).toString());
        logger.info("adminOrgPersonsMap:{}", (Object)adminOrgPersonsMap.toString());
        for (Map.Entry<Long, Object> entry : adminOrgPersonsMap.entrySet()) {
            Long adminOrgId = entry.getKey();
            Long checkStatId = orgCheckStatIdMap.get(adminOrgId);
            Map itemResultMap = (Map)adminOrgMap.get(adminOrgId);
            if (itemResultMap == null) {
                logger.info("itemResultMap is null");
                continue;
            }
            CheckStatisticalResult checkStatisticalResult = this.assembleCheckStatisticlResult(checkStatId, checkSchemeObj, itemMap, itemResultMap);
            list.add(checkStatisticalResult);
        }
        return list;
    }

    private Map<Long, Long> queryAdminOrgCheckStatIdMap(Set<Long> adminOrgIdSet, long checkSchemeId, long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkretstats");
        QFilter checkRetStatsFilter = new QFilter("checkscheme", "=", (Object)checkSchemeId);
        checkRetStatsFilter.and("adminorg", "in", adminOrgIdSet);
        checkRetStatsFilter.and("caltask", "=", (Object)taskId);
        DynamicObjectCollection checkRetStatObjs = helper.queryOriginalCollection("id,adminorg", new QFilter[]{checkRetStatsFilter});
        HashMap<Long, Long> adminOrgCheckStatIdMap = new HashMap<Long, Long>(16);
        if (!SWCListUtils.isEmpty((List)checkRetStatObjs)) {
            for (DynamicObject checkRetStatObj : checkRetStatObjs) {
                adminOrgCheckStatIdMap.put(checkRetStatObj.getLong("adminorg"), checkRetStatObj.getLong("id"));
            }
        }
        return adminOrgCheckStatIdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewCheckRetStats(List<Long> newAdminOrgIdList, long checkSchemeId, long taskId) {
        List<Object[]> insertParams = this.assembleInsertCheckRetStatParams(newAdminOrgIdList, checkSchemeId, taskId);
        String insertSql = "insert into t_hsas_checkretstats(fid,fcheckschemeid,fadminorgid,ftaskid,fcreatorid,fmodifierid,fcreatetime,fmodifytime) values(?,?,?,?,?,?,?,?)";
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, insertParams);
        }
    }

    private List<Object[]> assembleInsertCheckRetStatParams(List<Long> newAdminOrgIdList, long checkSchemeId, long taskId) {
        int size = newAdminOrgIdList.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>(size);
        long[] checkRetStatIds = DB.genLongIds((String)"t_hsas_checkretstats", (int)size);
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (int i = 0; i < size; ++i) {
            Object[] insertParam = new Object[]{checkRetStatIds[i], checkSchemeId, newAdminOrgIdList.get(i), taskId, currUserId, currUserId, now, now};
            params.add(insertParam);
        }
        return params;
    }

    private Set<Long> assembleCalResultAdmonOrgIdSet(Map<Long, Long> personAdminOrgMap, Map<Long, List<Long>> adminOrgPersonsMap, Map<Long, DynamicObject> successCalMap) {
        HashSet<Long> adminOrgIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : successCalMap.entrySet()) {
            long adminOrgId = entry.getValue().getLong("adminorg.id");
            long personId = entry.getValue().getLong("id");
            adminOrgIdSet.add(adminOrgId);
            List personList = adminOrgPersonsMap.computeIfAbsent(adminOrgId, value -> new ArrayList(10));
            personList.add(entry.getKey());
            personAdminOrgMap.put(personId, adminOrgId);
        }
        return adminOrgIdSet;
    }

    private void checkExistAdminOrgId(Set<Long> adminOrgIdSet, List<Long> existAdminOrgIdList, List<Long> newAdminOrgIdList, long checkSchemeId, long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkretstats");
        QFilter checkRetStatsFilter = new QFilter("checkscheme", "=", (Object)checkSchemeId);
        checkRetStatsFilter.and("adminorg", "in", adminOrgIdSet);
        checkRetStatsFilter.and("caltask", "=", (Object)taskId);
        DynamicObjectCollection checkRetStatObjs = helper.queryOriginalCollection("id,adminorg", new QFilter[]{checkRetStatsFilter});
        if (SWCListUtils.isEmpty((List)checkRetStatObjs)) {
            newAdminOrgIdList.addAll(adminOrgIdSet);
            return;
        }
        checkRetStatObjs.stream().forEach(single -> existAdminOrgIdList.add(single.getLong("adminorg")));
        for (Long id : adminOrgIdSet) {
            if (existAdminOrgIdList.contains(id)) continue;
            newAdminOrgIdList.add(id);
        }
    }

    private Map<String, String> assembleExistCheckIndexStats(List<Long> existCheckStatId) {
        HashMap<String, String> existData = new HashMap<String, String>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter filter = new QFilter("checkstatid", "in", existCheckStatId);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("checkstatid,itemid,indexcode,indexvalue", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return existData;
        }
        for (DynamicObject obj : dynamicObjects) {
            StringBuilder sb = new StringBuilder();
            String indexValue = obj.getString("indexvalue");
            String checkIndexKey = sb.append(obj.getLong("itemid")).append('-').append(obj.getString("indexcode")).toString();
            existData.put(checkIndexKey, indexValue);
        }
        return existData;
    }

    private void saveNewIndexPersonData(List<Map<String, Object>> newCheckIndexPersonList) {
        List<Object[]> checkIndexPersonDataObjs = this.assembleCheckIndexPersonDataObjs(newCheckIndexPersonList);
        String insertCheckIndexPersonSql = "insert into t_hsas_checkindexperson(fid,fcheckstatid,fitemid,findexcode,fpersonid) values(?,?,?,?,?)";
        if (!SWCListUtils.isEmpty(checkIndexPersonDataObjs)) {
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertCheckIndexPersonSql, checkIndexPersonDataObjs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExistCheckIndexStatData(List<Map<String, Object>> existCheckIndexStatList, long taskId) {
        DLock lock = DLock.create((String)("updateCheckIndexStatData_lockKey_" + taskId));
        try {
            if (lock.tryLock(60000L)) {
                List<Object[]> updateParamList = this.assembleExistCheckIndexStatParams(existCheckIndexStatList);
                String updateCheckIndexStatSql = "update t_hsas_checkindexstats set findexcount = findexcount + ?,findexvalue = ? where fcheckstatid = ? and fitemid = ? and findexcode = ?";
                if (!SWCListUtils.isEmpty(updateParamList)) {
                    SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateCheckIndexStatSql, updateParamList);
                }
            } else {
                logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6");
            }
        }
        catch (Exception exception) {
            logger.error("updateExistCheckIndexStatData error", (Throwable)exception);
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    private List<Object[]> assembleExistCheckIndexStatParams(List<Map<String, Object>> existCheckIndexStatList) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (int i = 0; i < existCheckIndexStatList.size(); ++i) {
            Map<String, Object> map = existCheckIndexStatList.get(i);
            Object[] updateParam = new Object[]{map.get("indexCount"), map.get("indexValue"), map.get("checkStatId"), map.get(KEY_ITEMCODE), map.get("indexCode")};
            dataList.add(updateParam);
        }
        return dataList;
    }

    private void saveNewIndexStatsData(List<Map<String, Object>> newCheckIndexStatList, List<Map<String, Object>> updateCheckIndexStatList, long taskId) {
        if (!SWCListUtils.isEmpty(updateCheckIndexStatList)) {
            this.updateExistCheckIndexStatData(updateCheckIndexStatList, taskId);
        }
        if (SWCListUtils.isEmpty(newCheckIndexStatList)) {
            return;
        }
        List<Object[]> checkIndexStatDataObjs = this.assembleCheckIndexStatDataObjs(newCheckIndexStatList);
        String insertCheckIndexStatSql = "insert into t_hsas_checkindexstats(fid,fcheckstatid,fitemid,findexcode,findexvalue,findexcount) values(?,?,?,?,?,?)";
        if (SWCListUtils.isEmpty(checkIndexStatDataObjs)) {
            return;
        }
        try {
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertCheckIndexStatSql, checkIndexStatDataObjs);
            ResultCheckService.removeErrCount();
        }
        catch (Exception exception) {
            logger.error("saveNewIndexStatsAndIndexPersonData_error", (Throwable)exception);
            Integer count = ResultCheckService.getErrCount();
            if (count <= 3) {
                logger.info("retry:{}", (Object)count);
                ResultCheckService.setErrCount();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    logger.error("saveNewIndexStatsData_sleep_error", (Throwable)ex);
                }
                this.handleErrorIndexStatData(newCheckIndexStatList, taskId);
            }
            logger.info("retry no success");
            ResultCheckService.removeErrCount();
        }
    }

    private static Integer getErrCount() {
        return errCount.get() == null ? Integer.valueOf(1) : errCount.get();
    }

    private static void setErrCount() {
        errCount.set(ResultCheckService.getErrCount() + 1);
    }

    private static void removeErrCount() {
        errCount.remove();
    }

    private void handleErrorIndexStatData(List<Map<String, Object>> newCheckIndexStatList, long taskId) {
        ArrayList<Map<String, Object>> insertDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> updateDataList = new ArrayList<Map<String, Object>>(10);
        this.assembleErrDataList(insertDataList, updateDataList, newCheckIndexStatList);
        this.saveNewIndexStatsData(insertDataList, updateDataList, taskId);
    }

    private void assembleErrDataList(List<Map<String, Object>> insertDataList, List<Map<String, Object>> updateDataList, List<Map<String, Object>> newCheckIndexStatList) {
        HashSet<Long> checkStatIds = new HashSet<Long>(16);
        HashSet<Long> itemIds = new HashSet<Long>(16);
        HashSet<String> indexCodes = new HashSet<String>(16);
        for (Map<String, Object> map : newCheckIndexStatList) {
            checkStatIds.add((Long)map.get("checkStatId"));
            itemIds.add((Long)map.get(KEY_ITEMCODE));
            indexCodes.add(map.get("indexCode") + "");
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter filter = new QFilter("checkstatid", "in", checkStatIds);
        filter.and("itemid", "in", itemIds);
        filter.and("indexcode", "in", indexCodes);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("checkstatid,itemid,indexcode", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            insertDataList.addAll(newCheckIndexStatList);
            return;
        }
        HashSet<String> existSet = new HashSet<String>(16);
        for (DynamicObject obj : dynamicObjects) {
            StringBuilder sb = new StringBuilder();
            String key = sb.append(obj.getLong("checkstatid")).append('-').append(obj.getLong("itemid")).append('-').append(obj.getString("indexcode")).toString();
            existSet.add(key);
        }
        Iterator<Map<String, Object>> iterator = newCheckIndexStatList.iterator();
        while (iterator.hasNext()) {
            StringBuilder sb1 = new StringBuilder();
            Map<String, Object> data = iterator.next();
            String key1 = sb1.append(data.get("checkStatId")).append('-').append(data.get(KEY_ITEMCODE)).append('-').append(data.get("indexCode")).toString();
            if (existSet.contains(key1)) {
                updateDataList.add(data);
                continue;
            }
            insertDataList.add(data);
        }
    }

    private List<Object[]> assembleCheckIndexPersonDataObjs(List<Map<String, Object>> newCheckIndexPersonList) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        int idSize = 0;
        for (Map<String, Object> map : newCheckIndexPersonList) {
            List personIdList = (List)map.get("personIdList");
            if (SWCListUtils.isEmpty((List)personIdList)) continue;
            idSize += personIdList.size();
        }
        long[] indexPersonFids = DB.genLongIds((String)"t_hsas_checkindexperson", (int)idSize);
        int idIndex = 0;
        for (Map<String, Object> data : newCheckIndexPersonList) {
            List personIdList = (List)data.get("personIdList");
            if (SWCListUtils.isEmpty((List)personIdList)) continue;
            Long checkStatId = (Long)data.get("checkStatId");
            Long itemId = (Long)data.get(KEY_ITEMCODE);
            String indexCode = (String)data.get("indexCode");
            for (int i = 0; i < personIdList.size(); ++i) {
                Object[] insertParam = new Object[]{indexPersonFids[idIndex++], checkStatId, itemId, indexCode, personIdList.get(i)};
                dataList.add(insertParam);
            }
        }
        return dataList;
    }

    private List<Object[]> assembleCheckIndexStatDataObjs(List<Map<String, Object>> newCheckIndexStatList) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        long[] indexStatFids = DB.genLongIds((String)"t_hsas_checkindexstats", (int)newCheckIndexStatList.size());
        for (int i = 0; i < newCheckIndexStatList.size(); ++i) {
            Map<String, Object> map = newCheckIndexStatList.get(i);
            Object[] insertParam = new Object[]{indexStatFids[i], map.get("checkStatId"), map.get(KEY_ITEMCODE), map.get("indexCode"), map.get("indexValue"), map.get("indexCount")};
            dataList.add(insertParam);
        }
        return dataList;
    }

    private void assembleCheckIndexStatAndPersonData(Set<String> waitDeleteKey, Map<String, String> existIndexStats, List<CheckStatisticalResult> checkStatisticalResultList, List<Map<String, Object>> newCheckIndexPersonList, List<Map<String, Object>> existCheckIndexStatList, List<Map<String, Object>> newCheckIndexStatList) {
        ArrayList basicCheckResults = new ArrayList(10);
        for (CheckStatisticalResult result : checkStatisticalResultList) {
            basicCheckResults.addAll(result.getBasicCheckResults());
        }
        if (SWCListUtils.isEmpty(basicCheckResults)) {
            return;
        }
        for (BasicCheckResult single : basicCheckResults) {
            DetailStatisticResult detail = single.getDetail();
            List currentResult = detail.getCurrentResult();
            List chainResult = detail.getChainResult();
            List yearResult = detail.getYearResult();
            if (!SWCListUtils.isEmpty((List)currentResult)) {
                newCheckIndexPersonList.addAll(currentResult);
                this.assembleCheckResultData(waitDeleteKey, existIndexStats, newCheckIndexStatList, existCheckIndexStatList, currentResult);
            }
            if (!SWCListUtils.isEmpty((List)chainResult)) {
                newCheckIndexPersonList.addAll(chainResult);
                this.assembleCheckResultData(waitDeleteKey, existIndexStats, newCheckIndexStatList, existCheckIndexStatList, chainResult);
            }
            if (SWCListUtils.isEmpty((List)yearResult)) continue;
            newCheckIndexPersonList.addAll(yearResult);
            this.assembleCheckResultData(waitDeleteKey, existIndexStats, newCheckIndexStatList, existCheckIndexStatList, yearResult);
        }
    }

    private void assembleCheckResultData(Set<String> waitDeleteKey, Map<String, String> existIndexStats, List<Map<String, Object>> newCheckIndexStatList, List<Map<String, Object>> existCheckIndexStatList, List<Map<String, Object>> result) {
        if (SWCListUtils.isEmpty(result)) {
            return;
        }
        for (Map<String, Object> map : result) {
            StringBuilder sb = new StringBuilder();
            String indexValue = map.get("indexValue") + "";
            String tempKey = sb.append(map.get(KEY_ITEMCODE)).append('-').append(map.get("indexCode")).toString();
            if (existIndexStats.containsKey(tempKey)) {
                String existIndexValue = existIndexStats.get(tempKey);
                if (!SWCStringUtils.equals((String)existIndexValue, (String)indexValue)) {
                    waitDeleteKey.add(tempKey);
                    newCheckIndexStatList.add(map);
                    continue;
                }
                existCheckIndexStatList.add(map);
                continue;
            }
            newCheckIndexStatList.add(map);
        }
    }

    private CheckStatisticalResult assembleCheckStatisticlResult(Long checkStatId, DynamicObject checkSchemeObj, Map<Long, DynamicObject> itemMap, Map<Long, List<Map<String, Object>>> itemResultMap) {
        CheckStatisticalResult checkStatisticalResult = new CheckStatisticalResult();
        ArrayList<BasicCheckResult> basicCheckResults = new ArrayList<BasicCheckResult>(10);
        for (Map.Entry<Long, List<Map<String, Object>>> data : itemResultMap.entrySet()) {
            Long itemId = data.getKey();
            List<Map<String, Object>> resultList = data.getValue();
            DynamicObject itemObj = itemMap.get(itemId);
            if (SWCListUtils.isEmpty(resultList)) continue;
            BasicCheckResult basicCheckResult = new BasicCheckResult();
            basicCheckResult.setItemId(itemId);
            basicCheckResult.setItemType(itemObj.getString("itemtype"));
            basicCheckResult.setItemName(itemObj.getString("itemname"));
            HashSet<Long> totalPersonList = new HashSet<Long>(0);
            basicCheckResult.setPersonList(totalPersonList);
            DetailStatisticResult detail = new DetailStatisticResult();
            basicCheckResult.setDetail(detail);
            List<Map<String, Object>> currentResultList = this.assembleCurrentResult(checkStatId, totalPersonList, itemObj, resultList);
            detail.setCurrentResult(currentResultList);
            if (checkSchemeObj.getBoolean("chainincrease") || checkSchemeObj.getBoolean("chaingrowth")) {
                detail.setChainResult(this.assembleIndexResult(checkStatId, CHAIN_TYPE, totalPersonList, itemObj, resultList, checkSchemeObj));
            }
            if (checkSchemeObj.getBoolean("yearincrease") || checkSchemeObj.getBoolean("yeargrowth")) {
                detail.setYearResult(this.assembleIndexResult(checkStatId, YEAR_TYPE, totalPersonList, itemObj, resultList, checkSchemeObj));
            }
            basicCheckResult.setCount(Integer.valueOf(totalPersonList.size()));
            basicCheckResults.add(basicCheckResult);
        }
        checkStatisticalResult.setBasicCheckResults(basicCheckResults);
        return checkStatisticalResult;
    }

    private List<Map<String, Object>> assembleIndexResult(Long checkStatId, String indexType, Set<Long> totalPersonList, DynamicObject itemObj, List<Map<String, Object>> resultList, DynamicObject checkSchemeObj) {
        ArrayList<Map<String, Object>> indexResult = new ArrayList<Map<String, Object>>(3);
        if (SWCStringUtils.equals((String)CHAIN_TYPE, (String)indexType)) {
            if (checkSchemeObj.getBoolean("chainincrease")) {
                indexResult.add(this.assembleIndexCountMap(checkStatId, "chainincreaseless", "chainincrease", totalPersonList, itemObj, resultList, -1, true));
                indexResult.add(this.assembleIndexCountMap(checkStatId, "chainincreasebigger", "chainincrease", totalPersonList, itemObj, resultList, 1, true));
            }
            if (checkSchemeObj.getBoolean("chaingrowth")) {
                indexResult.add(this.assembleIndexCountMap(checkStatId, "chaingrowthless", "chaingrowth", totalPersonList, itemObj, resultList, -1, true));
                indexResult.add(this.assembleIndexCountMap(checkStatId, "chaingrowthbigger", "chaingrowth", totalPersonList, itemObj, resultList, 1, true));
            }
        } else if (SWCStringUtils.equals((String)YEAR_TYPE, (String)indexType)) {
            if (checkSchemeObj.getBoolean("yearincrease")) {
                indexResult.add(this.assembleIndexCountMap(checkStatId, "yearincreaseless", "yearincrease", totalPersonList, itemObj, resultList, -1, true));
                indexResult.add(this.assembleIndexCountMap(checkStatId, "yearincreasebigger", "yearincrease", totalPersonList, itemObj, resultList, 1, true));
            }
            if (checkSchemeObj.getBoolean("yeargrowth")) {
                indexResult.add(this.assembleIndexCountMap(checkStatId, "yeargrowthless", "yeargrowth", totalPersonList, itemObj, resultList, -1, true));
                indexResult.add(this.assembleIndexCountMap(checkStatId, "yeargrowthbigger", "yeargrowth", totalPersonList, itemObj, resultList, 1, true));
            }
        }
        return indexResult;
    }

    private Map<String, Object> assembleIndexCountMap(Long checkStatId, String indexProperty, String dataProperty, Set<Long> totalPersonList, DynamicObject itemObj, List<Map<String, Object>> resultList, int compareValue, boolean containEquals) {
        HashMap<String, Object> indexCountMap = new HashMap<String, Object>(3);
        List<Object> personIdList = new ArrayList(0);
        int indexCount = 0;
        String indexValueStr = itemObj.getString(indexProperty);
        if (!SWCStringUtils.isEmpty((String)indexValueStr)) {
            BigDecimal indexValue = new BigDecimal(indexValueStr);
            if (compareValue == 1) {
                personIdList = containEquals ? resultList.stream().filter(data -> this.stringIsNotNull(data.get(dataProperty) + "") && (new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) > 0 || new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) == 0)).map(value -> Long.parseLong(value.get("calpersonid") + "")).collect(Collectors.toList()) : resultList.stream().filter(data -> this.stringIsNotNull(data.get(dataProperty) + "") && new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) > 0).map(value -> Long.parseLong(value.get("calpersonid") + "")).collect(Collectors.toList());
            } else if (compareValue == -1) {
                personIdList = containEquals ? resultList.stream().filter(data -> this.stringIsNotNull(data.get(dataProperty) + "") && (new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) < 0 || new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) == 0)).map(value -> Long.parseLong(value.get("calpersonid") + "")).collect(Collectors.toList()) : resultList.stream().filter(data -> this.stringIsNotNull(data.get(dataProperty) + "") && new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) < 0).map(value -> Long.parseLong(value.get("calpersonid") + "")).collect(Collectors.toList());
            } else if (compareValue == 0) {
                personIdList = resultList.stream().filter(data -> this.stringIsNotNull(data.get(dataProperty) + "") && new BigDecimal(data.get(dataProperty) + "").compareTo(indexValue) == 0).map(value -> Long.parseLong(value.get("calpersonid") + "")).collect(Collectors.toList());
            }
            indexCount = personIdList.size();
        }
        StringBuilder valueStr = new StringBuilder(indexValueStr);
        if (indexProperty.indexOf("growth") > 0) {
            valueStr.append('%');
        }
        indexCountMap.put("indexCode", indexProperty);
        indexCountMap.put("indexCount", indexCount);
        indexCountMap.put("personIdList", personIdList);
        indexCountMap.put("indexValue", valueStr.toString());
        indexCountMap.put(KEY_ITEMCODE, itemObj.getLong("itemid"));
        indexCountMap.put("checkStatId", checkStatId);
        totalPersonList.addAll(personIdList);
        return indexCountMap;
    }

    private boolean stringIsNotNull(String string) {
        return SWCStringUtils.isNotEmpty((String)string) && !SWCStringUtils.equals((String)"null", (String)string);
    }

    private List<Map<String, Object>> assembleCurrentResult(Long checkStatId, Set<Long> totalPersonList, DynamicObject itemObj, List<Map<String, Object>> resultList) {
        ArrayList<Map<String, Object>> currentResult = new ArrayList<Map<String, Object>>(3);
        currentResult.add(this.assembleIndexCountMap(checkStatId, "valueequals", "calvalue", totalPersonList, itemObj, resultList, 0, true));
        currentResult.add(this.assembleIndexCountMap(checkStatId, "valueless", "calvalue", totalPersonList, itemObj, resultList, -1, false));
        currentResult.add(this.assembleIndexCountMap(checkStatId, "valuebigger", "calvalue", totalPersonList, itemObj, resultList, 1, false));
        return currentResult;
    }

    private void assembleItemChainYearResult(Map<Long, Map<Long, Map<String, Object>>> itemChainYearResult, DynamicObject task, List<String> checkIndexList, Map<Long, Long> personSalaryfileMap, Map<Long, Map<Long, BigDecimal>> personCalResultMap, Map<String, List<Long>> itemIdMap) {
        Date curStartDate = task.getDate("startdate");
        String periodType = this.assembleTaskPeriodType(task.getLong("periodtype.calfrequency.id"));
        HashMap<String, Long> chainYearPeriodIdMap = new HashMap<String, Long>(2);
        try {
            this.assembleChainDataMap(chainYearPeriodIdMap, task.getLong("periodtype.id"), curStartDate);
        }
        catch (ParseException exception) {
            logger.error("assembleDateMap_error", (Throwable)exception);
            throw new KDException((Throwable)exception, BosErrorCode.parse, new Object[]{ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{0}\u3002", (String)"DataReaderCalHelper_1", (String)"swc-hscs-business", (Object[])new Object[]{exception.getMessage()})});
        }
        logger.info("chainYearPeriodIdMap:{}", (Object)((Object)chainYearPeriodIdMap).toString());
        HashMap<Long, Map<Long, BigDecimal>> chainResultMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        HashMap<Long, Map<Long, BigDecimal>> yearResultMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        if (checkIndexList.contains("chainincrease") || checkIndexList.contains("chaingrowth")) {
            this.assembleItemChainYearData(chainResultMap, personSalaryfileMap, itemIdMap, (Long)chainYearPeriodIdMap.get("chainPeriodId"), task);
        }
        if (checkIndexList.contains("yearincrease") || checkIndexList.contains("yeargrowth")) {
            List<String> periodTypeList = Arrays.asList("HALF_MONTH", "BIWEEKLY", "WEEK", "DAY", "OTHER");
            if (SWCStringUtils.isNotEmpty((String)periodType) && !periodTypeList.contains(periodType)) {
                this.assembleItemChainYearData(yearResultMap, personSalaryfileMap, itemIdMap, (Long)chainYearPeriodIdMap.get("yearPeriodId"), task);
            }
        }
        this.handleItemResult(personSalaryfileMap, itemChainYearResult, checkIndexList, personCalResultMap, chainResultMap, yearResultMap, itemIdMap);
    }

    private String assembleTaskPeriodType(long periodFrequency) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calfrequency");
        DynamicObject periodFrequencyObj = helper.queryOne("type", (Object)periodFrequency);
        return periodFrequencyObj.getString("type");
    }

    private void assembleChainDataMap(Map<String, Long> chainYearPeriodIdMap, long periodTypeId, Date curStartDate) throws ParseException {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiodtype");
        QFilter filter = new QFilter("id", "=", (Object)periodTypeId);
        DynamicObject object = helper.queryOne("id,entryentity,entrytity.startdate,entrytity.enddate", new QFilter[]{filter});
        Date tmpStartDate = SWCDateTimeUtils.parseDate((String)curStartDate.toString(), (String)"yyyy-MM-dd");
        if (object == null) {
            return;
        }
        DynamicObjectCollection collection = object.getDynamicObjectCollection("entryentity");
        if (collection == null || collection.size() == 0) {
            return;
        }
        HashMap<Integer, Long> dateMap1 = new HashMap<Integer, Long>(16);
        HashMap<Date, Integer> dateMap2 = new HashMap<Date, Integer>(16);
        ResultCheckService.assembleDateCollectionMap(collection, dateMap1, dateMap2);
        int index = (Integer)dateMap2.get(tmpStartDate);
        Long chainPeriodId = (Long)dateMap1.get(index + 1);
        Long yearPeriodId = (Long)dateMap1.get(index + 12);
        chainYearPeriodIdMap.put("chainPeriodId", chainPeriodId);
        chainYearPeriodIdMap.put("yearPeriodId", yearPeriodId);
    }

    private static void assembleDateCollectionMap(DynamicObjectCollection collection, Map<Integer, Long> dateMap1, Map<Date, Integer> dateMap2) throws ParseException {
        List ids = collection.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiod");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,startdate,enddate", new QFilter[]{filter}, "startdate desc");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            Date startDate = ((DynamicObject)dynamicObjects.get(i)).getDate("startdate");
            dateMap2.put(SWCDateTimeUtils.formatDateToDate((Date)startDate, (String)"yyyy-MM-dd"), i + 1);
            dateMap1.put(i + 1, ((DynamicObject)dynamicObjects.get(i)).getLong("id"));
        }
    }

    private void handleItemResult(Map<Long, Long> personSalaryfileMap, Map<Long, Map<Long, Map<String, Object>>> itemChainYearResult, List<String> checkIndexList, Map<Long, Map<Long, BigDecimal>> personCalResultMap, Map<Long, Map<Long, BigDecimal>> chainResultMap, Map<Long, Map<Long, BigDecimal>> yearResultMap, Map<String, List<Long>> itemIdMap) {
        List<Long> bizItemList = itemIdMap.get(CalResultItemEnum.BIZITEM.getCode());
        List<Long> salaryItemList = itemIdMap.get(CalResultItemEnum.SALARYITEM.getCode());
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        if (!SWCListUtils.isEmpty(bizItemList)) {
            itemIdList.addAll(bizItemList);
        }
        if (!SWCListUtils.isEmpty(salaryItemList)) {
            itemIdList.addAll(salaryItemList);
        }
        for (Map.Entry<Long, Map<Long, BigDecimal>> entry : personCalResultMap.entrySet()) {
            Long salaryFileId = entry.getKey();
            Long personId = personSalaryfileMap.get(salaryFileId);
            Map<Long, BigDecimal> calMap = entry.getValue();
            Map<Long, BigDecimal> chainValueMap = chainResultMap.get(salaryFileId);
            Map<Long, BigDecimal> yearValueMap = yearResultMap.get(salaryFileId);
            Map personResultMap = itemChainYearResult.computeIfAbsent(salaryFileId, personResult -> new HashMap(16));
            for (Long itemId : itemIdList) {
                BigDecimal yearValue;
                BigDecimal chainValue;
                Map indexMap = personResultMap.computeIfAbsent(itemId, index -> new HashMap(16));
                BigDecimal calValue = calMap.get(itemId);
                indexMap.put("calvalue", calValue);
                indexMap.put("calpersonid", personId);
                if (calValue == null) continue;
                if (chainValueMap != null && chainValueMap.size() > 0 && (chainValue = chainValueMap.get(itemId)) != null) {
                    if (checkIndexList.contains("chainincrease")) {
                        BigDecimal chainIncrease = calValue.subtract(chainValue);
                        indexMap.put("chainincrease", chainIncrease);
                    }
                    if (checkIndexList.contains("chaingrowth") && chainValue.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal chainGrowth = calValue.subtract(chainValue).divide(chainValue.abs(), 4, 4).multiply(BigDecimal.valueOf(100L));
                        indexMap.put("chaingrowth", chainGrowth);
                    }
                }
                if (yearValueMap == null || yearValueMap.size() <= 0 || (yearValue = yearValueMap.get(itemId)) == null) continue;
                if (checkIndexList.contains("yearincrease")) {
                    BigDecimal yearIncrease = calValue.subtract(yearValue);
                    indexMap.put("yearincrease", yearIncrease);
                }
                if (!checkIndexList.contains("yeargrowth") || yearValue.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal yearGrowth = calValue.subtract(yearValue).divide(yearValue.abs(), 4, 4).multiply(BigDecimal.valueOf(100L));
                indexMap.put("yeargrowth", yearGrowth);
            }
        }
    }

    private void assembleItemChainYearData(Map<Long, Map<Long, BigDecimal>> chainResultMap, Map<Long, Long> personSalaryfileMap, Map<String, List<Long>> itemIdMap, Long periodId, DynamicObject task) {
        List<Long> bizItemList;
        long payRollGroup = task.getLong("payrollgroup.id");
        long payRollScene = task.getLong("payrollscene.id");
        long currency = task.getLong("payrollgroupv.currency.id");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter taskFilter = new QFilter("payrollgroup", "=", (Object)payRollGroup);
        taskFilter.and("payrollscene", "=", (Object)payRollScene);
        taskFilter.and("period", "=", (Object)periodId);
        taskFilter.and("payrollgroupv.currency", "=", (Object)currency);
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("id", new QFilter[]{taskFilter});
        if (taskObjs.size() == 0) {
            logger.info("taskObjs.size is 0");
            return;
        }
        List taskIdList = taskObjs.stream().map(value -> value.getLong("id")).collect(Collectors.toList());
        helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter personFilter = new QFilter("caltask", "in", taskIdList);
        personFilter.and("salaryfile", "in", personSalaryfileMap.keySet());
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,calresultid,salaryfile.id", new QFilter[]{personFilter});
        if (personObjs.size() == 0) {
            logger.info("personObjs.size is 0");
            return;
        }
        Map<Long, Long> personResultIdMap = personObjs.stream().filter(person -> person.getLong("calresultid") > 0L).collect(Collectors.toMap(key -> key.getLong("calresultid"), value -> value.getLong("salaryfile.id")));
        List<Long> salaryItemList = itemIdMap.get(CalResultItemEnum.SALARYITEM.getCode());
        if (!SWCListUtils.isEmpty(salaryItemList)) {
            DynamicObjectCollection slEntryList = this.getCalTableEntryItemData(personResultIdMap.keySet(), salaryItemList);
            this.assembleCaltableEntryData(personResultIdMap, chainResultMap, slEntryList);
        }
        if (!SWCListUtils.isEmpty(bizItemList = itemIdMap.get(CalResultItemEnum.BIZITEM.getCode()))) {
            DynamicObjectCollection bsEntryList = this.getCalTableBsEntryItemData(personResultIdMap.keySet(), bizItemList);
            this.assembleBizEntryData(personResultIdMap, chainResultMap, bsEntryList);
        }
        logger.info("chainResultMap:{}", (Object)chainResultMap.toString());
    }

    private DynamicObjectCollection getCalTableBsEntryItemData(Set<Long> caltableIds, List<Long> bizItemList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        String fields = "id,hsas_calbsentry.bizitem.id,hsas_calbsentry.bscalamountvalue";
        QFilter filter = new QFilter("id", "in", caltableIds);
        filter.and("hsas_calbsentry.bizitem.id", "in", bizItemList);
        return helper.queryOriginalCollection(fields, new QFilter[]{filter});
    }

    private DynamicObjectCollection getCalTableEntryItemData(Set<Long> caltableIds, List<Long> salaryItemList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        String fields = "id,hsas_caltableentry.salaryitem.id,hsas_caltableentry.calamountvalue";
        QFilter filter = new QFilter("id", "in", caltableIds);
        filter.and("hsas_caltableentry.salaryitem.id", "in", salaryItemList);
        return helper.queryOriginalCollection(fields, new QFilter[]{filter});
    }

    private void assembleCaltableEntryData(Map<Long, Long> personResultIdMap, Map<Long, Map<Long, BigDecimal>> resultMap, DynamicObjectCollection slEntryList) {
        if (slEntryList.size() == 0) {
            return;
        }
        for (DynamicObject obj : slEntryList) {
            Map itemDataMap = resultMap.getOrDefault(personResultIdMap.get(obj.getLong("id")), new HashMap(16));
            BigDecimal value = obj.getBigDecimal("hsas_caltableentry.calamountvalue") == null ? BigDecimal.ZERO : obj.getBigDecimal("hsas_caltableentry.calamountvalue");
            BigDecimal existValue = (BigDecimal)itemDataMap.get(obj.getLong("hsas_caltableentry.salaryitem.id"));
            if (existValue == null) {
                existValue = BigDecimal.ZERO;
            }
            itemDataMap.put(obj.getLong("hsas_caltableentry.salaryitem.id"), value.add(existValue));
            resultMap.put(personResultIdMap.get(obj.getLong("id")), itemDataMap);
        }
    }

    private void assembleBizEntryData(Map<Long, Long> personResultIdMap, Map<Long, Map<Long, BigDecimal>> resultMap, DynamicObjectCollection bsEntryList) {
        if (bsEntryList.size() == 0) {
            return;
        }
        for (DynamicObject obj : bsEntryList) {
            Map itemDataMap = resultMap.getOrDefault(personResultIdMap.get(obj.getLong("id")), new HashMap(16));
            BigDecimal value = obj.getBigDecimal("hsas_calbsentry.bscalamountvalue") == null ? BigDecimal.ZERO : obj.getBigDecimal("hsas_calbsentry.bscalamountvalue");
            BigDecimal existValue = (BigDecimal)itemDataMap.get(obj.getLong("hsas_calbsentry.bizitem.id"));
            if (existValue == null) {
                existValue = BigDecimal.ZERO;
            }
            itemDataMap.put(obj.getLong("hsas_calbsentry.bizitem.id"), value.add(existValue));
            resultMap.put(personResultIdMap.get(obj.getLong("id")), itemDataMap);
        }
    }

    private Map<Long, Map<Long, BigDecimal>> assembleCalItemResult(List<CalResultVO> calResultList, Map<Long, DynamicObject> successCalMap, List<Map<String, Object>> tempResultList, Map<String, List<Long>> itemIdMap) {
        Map calResultMap;
        long salaryFileId;
        HashMap<Long, Map<Long, BigDecimal>> personCalResultMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        List<Long> bizItemList = itemIdMap.get(CalResultItemEnum.BIZITEM.getCode());
        List<Long> salaryItemList = itemIdMap.get(CalResultItemEnum.SALARYITEM.getCode());
        if (!SWCListUtils.isEmpty(salaryItemList)) {
            for (CalResultVO calResultVO : calResultList) {
                Long calPersonId = calResultVO.getCalPersonId();
                if (!successCalMap.containsKey(calPersonId)) continue;
                salaryFileId = successCalMap.get(calPersonId).getLong("salaryfile.id");
                if (!salaryItemList.contains(calResultVO.getSalaryItemId())) continue;
                calResultMap = personCalResultMap.computeIfAbsent(salaryFileId, value -> new HashMap(16));
                calResultMap.put(calResultVO.getSalaryItemId(), calResultVO.getCalAmountValue());
            }
        }
        if (!SWCListUtils.isEmpty(bizItemList)) {
            for (Map map : tempResultList) {
                Long personId = (Long)map.get(KEY_CALPERSONID);
                if (!successCalMap.containsKey(personId)) continue;
                salaryFileId = successCalMap.get(personId).getLong("salaryfile.id");
                if (!SWCStringUtils.equals((String)KEY_BIZITEM, (String)(map.get("itemEnum") + "")) || !SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)(map.get(KEY_DATASHOWTYPE) + "")) || !bizItemList.contains(map.get(KEY_ITEMCODE))) continue;
                calResultMap = personCalResultMap.computeIfAbsent(salaryFileId, value -> new HashMap(16));
                calResultMap.put((Long)map.get(KEY_ITEMCODE), new BigDecimal(map.get(KEY_ITEMRESULT) + ""));
            }
        }
        return personCalResultMap;
    }

    private Map<String, List<Long>> assembleCheckItemMap(DynamicObjectCollection itemEntryObjs) {
        HashMap<String, List<Long>> itemMap = new HashMap<String, List<Long>>(16);
        for (DynamicObject obj : itemEntryObjs) {
            String itemType = this.assembleItemTypeByName(obj.getString("itemtype"));
            List itemIdList = itemMap.computeIfAbsent(itemType, value -> new ArrayList(10));
            itemIdList.add(obj.getLong("itemid"));
        }
        return itemMap;
    }

    private String assembleItemTypeByName(String itemType) {
        if (SWCStringUtils.equals((String)"SL", (String)itemType)) {
            return CalResultItemEnum.SALARYITEM.getCode();
        }
        if (SWCStringUtils.equals((String)"BS", (String)itemType)) {
            return CalResultItemEnum.BIZITEM.getCode();
        }
        return null;
    }

    private List<String> assembleCheckIndexList(DynamicObject checkSchemeObj) {
        ArrayList<String> list = new ArrayList<String>(5);
        if (checkSchemeObj.getBoolean("chainincrease")) {
            list.add("chainincrease");
        }
        if (checkSchemeObj.getBoolean("chaingrowth")) {
            list.add("chaingrowth");
        }
        if (checkSchemeObj.getBoolean("yearincrease")) {
            list.add("yearincrease");
        }
        if (checkSchemeObj.getBoolean("yeargrowth")) {
            list.add("yeargrowth");
        }
        return list;
    }

    public void deleteCheckDataAndReCount(List<Long> calPersonIdList, String calType, Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexperson");
        QFilter personFilter = new QFilter("personid", "in", calPersonIdList);
        DynamicObjectCollection indexPersonObjs = helper.queryOriginalCollection("checkstatid,itemid,indexcode,personid", new QFilter[]{personFilter});
        if (SWCListUtils.isEmpty((List)indexPersonObjs)) {
            return;
        }
        Map<String, List<Long>> personMap = this.assembleExistIndexPersonMap(indexPersonObjs);
        helper.deleteByFilter(new QFilter[]{personFilter});
        ArrayList<Long> checkStatsIdList = new ArrayList<Long>(10);
        ArrayList<Long> checkItemIdList = new ArrayList<Long>(10);
        ArrayList<String> needDeleteIndexList = new ArrayList<String>(10);
        this.assembleCheckIndexItemList(checkStatsIdList, taskId, checkItemIdList, needDeleteIndexList);
        List<String> calTypeList = Arrays.asList("onlyPreTaxCal", "afterTaxCal", "cal");
        List<Long> itemIdList = this.assembleCheckSchemeItemList(taskId);
        boolean check = this.checkItemDiff(checkItemIdList, itemIdList);
        if (!check && calTypeList.contains(calType)) {
            logger.info("deleteCheckIndexStatData");
            this.deleteCheckIndexStatData(checkStatsIdList);
        } else {
            logger.info("updateCheckIndexStatData");
            this.updateCheckIndexStatData(personMap, taskId);
            if (!SWCListUtils.isEmpty(needDeleteIndexList)) {
                logger.info("deleteCheckIndexData,needDeleteIndexList:{}", (Object)((Object)needDeleteIndexList).toString());
                this.deleteCheckIndexData(needDeleteIndexList, checkStatsIdList);
            }
        }
    }

    private void deleteCheckIndexData(List<String> needDeleteIndexList, List<Long> checkStatsIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter filter = new QFilter("checkstatid", "in", checkStatsIdList);
        filter.and("indexcode", "in", needDeleteIndexList);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    private boolean checkItemDiff(List<Long> checkItemIdList, List<Long> itemIdList) {
        logger.info("checkItemIdList:{},itemIdList:{}", (Object)checkItemIdList.toString(), (Object)itemIdList.toString());
        if (checkItemIdList.size() != itemIdList.size()) {
            return false;
        }
        for (Long itemId : itemIdList) {
            if (checkItemIdList.contains(itemId)) continue;
            return false;
        }
        return true;
    }

    private List<Long> assembleCheckSchemeItemList(Long taskId) {
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("payrollgroup.id,payrollscene.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)taskObjs)) {
            return itemIdList;
        }
        long payrollgroupId = ((DynamicObject)taskObjs.get(0)).getLong("payrollgroup.id");
        long payrollsceneId = ((DynamicObject)taskObjs.get(0)).getLong("payrollscene.id");
        helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        QFilter filter1 = new QFilter("payrollgroup.id", "=", (Object)payrollgroupId);
        filter1.and("payrollscene.id", "=", (Object)payrollsceneId);
        DynamicObject[] checkSchemeObjs = helper.query("valueentry,valueentry.itemid", new QFilter[]{filter1});
        if (checkSchemeObjs == null || checkSchemeObjs.length == 0) {
            return itemIdList;
        }
        DynamicObjectCollection itemEntryObjs = checkSchemeObjs[0].getDynamicObjectCollection("valueentry");
        if (SWCListUtils.isEmpty((List)itemEntryObjs)) {
            return itemIdList;
        }
        for (DynamicObject itemObj : itemEntryObjs) {
            itemIdList.add(itemObj.getLong("itemid"));
        }
        return itemIdList;
    }

    private void deleteCheckIndexStatData(List<Long> checkStatsIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter filter = new QFilter("checkstatid", "in", checkStatsIdList);
        helper.deleteByFilter(new QFilter[]{filter});
        helper = new SWCDataServiceHelper("hsas_checkindexperson");
        helper.deleteByFilter(new QFilter[]{filter});
    }

    private void assembleCheckIndexItemList(List<Long> checkStatsIdList, Long taskId, List<Long> checkItemIdList, List<String> needDeleteIndexList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkretstats");
        QFilter filter = new QFilter("caltask.id", "=", (Object)taskId);
        DynamicObjectCollection objects = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)objects)) {
            return;
        }
        for (DynamicObject obj : objects) {
            checkStatsIdList.add(obj.getLong("id"));
        }
        helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter statsFilter = new QFilter("checkstatid", "in", checkStatsIdList);
        DynamicObjectCollection statsItemObjs = helper.queryOriginalCollection("itemid,indexcode", new QFilter[]{statsFilter});
        if (SWCListUtils.isEmpty((List)statsItemObjs)) {
            return;
        }
        HashSet<Long> itemIdSet = new HashSet<Long>(16);
        HashSet<String> indexCodeSet = new HashSet<String>(16);
        for (DynamicObject itemObj : statsItemObjs) {
            itemIdSet.add(itemObj.getLong("itemid"));
            indexCodeSet.add(itemObj.getString("indexcode"));
        }
        checkItemIdList.addAll(itemIdSet);
        helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("payrollgroup.id,payrollscene.id", new QFilter[]{taskFilter});
        if (SWCListUtils.isEmpty((List)taskObjs)) {
            return;
        }
        long payrollgroupId = ((DynamicObject)taskObjs.get(0)).getLong("payrollgroup.id");
        long payrollsceneId = ((DynamicObject)taskObjs.get(0)).getLong("payrollscene.id");
        helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        QFilter schemeFilter = new QFilter("payrollgroup.id", "=", (Object)payrollgroupId);
        schemeFilter.and("payrollscene.id", "=", (Object)payrollsceneId);
        DynamicObject checkSchemeObj = helper.queryOne("chainincrease,chaingrowth,yearincrease,yeargrowth", new QFilter[]{schemeFilter});
        if (checkSchemeObj == null) {
            return;
        }
        this.assembleNeedDeleteIndexList(needDeleteIndexList, indexCodeSet, checkSchemeObj);
    }

    private void assembleNeedDeleteIndexList(List<String> needDeleteIndexList, Set<String> indexCodeSet, DynamicObject checkSchemeObj) {
        if (!checkSchemeObj.getBoolean("chainincrease") && this.checkContainIndex(indexCodeSet, "chainincrease")) {
            needDeleteIndexList.addAll(Arrays.asList("chainincreaseless", "chainincreasebigger"));
        }
        if (!checkSchemeObj.getBoolean("chaingrowth") && this.checkContainIndex(indexCodeSet, "chaingrowth")) {
            needDeleteIndexList.addAll(Arrays.asList("chaingrowthless", "chaingrowthbigger"));
        }
        if (!checkSchemeObj.getBoolean("yearincrease") && this.checkContainIndex(indexCodeSet, "yearincrease")) {
            needDeleteIndexList.addAll(Arrays.asList("yearincreaseless", "yearincreasebigger"));
        }
        if (!checkSchemeObj.getBoolean("yeargrowth") && this.checkContainIndex(indexCodeSet, "yeargrowth")) {
            needDeleteIndexList.addAll(Arrays.asList("yeargrowthless", "yeargrowthbigger"));
        }
    }

    private boolean checkContainIndex(Set<String> indexCodeSet, String indexCode) {
        for (String code : indexCodeSet) {
            if (!code.startsWith(indexCode)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckIndexStatData(Map<String, List<Long>> personMap, Long taskId) {
        DLock lock = DLock.create((String)("updateCheckIndexStatData_lockKey_" + taskId));
        try {
            if (lock.tryLock(60000L)) {
                List<Object[]> updateParamList = this.assembleUpdateCheckIndexStatParams(personMap);
                String updateCheckIndexStatSql = "update t_hsas_checkindexstats set findexcount = findexcount - ? where fcheckstatid = ? and fitemid = ? and findexcode = ? ";
                if (!SWCListUtils.isEmpty(updateParamList)) {
                    SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateCheckIndexStatSql, updateParamList);
                }
            } else {
                logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6");
            }
        }
        catch (Exception exception) {
            logger.error("updateCheckIndexStatData error", (Throwable)exception);
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    private List<Object[]> assembleUpdateCheckIndexStatParams(Map<String, List<Long>> personMap) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (Map.Entry<String, List<Long>> entry : personMap.entrySet()) {
            String[] split = entry.getKey().split("-");
            List<Long> personIds = entry.getValue();
            Object[] updateParam = new Object[]{personIds.size(), Long.valueOf(split[0]), Long.valueOf(split[1]), split[2]};
            dataList.add(updateParam);
        }
        return dataList;
    }

    private Map<String, List<Long>> assembleExistIndexPersonMap(DynamicObjectCollection indexPersonObjs) {
        HashMap<String, List<Long>> personMap = new HashMap<String, List<Long>>(16);
        for (DynamicObject obj : indexPersonObjs) {
            StringBuilder keyStr = new StringBuilder();
            String key = keyStr.append(obj.getLong("checkstatid")).append('-').append(obj.getLong("itemid")).append('-').append(obj.getString("indexcode")).toString();
            List personList = personMap.computeIfAbsent(key, value -> new ArrayList(10));
            personList.add(obj.getLong("personid"));
        }
        return personMap;
    }

    public void delCheckNotPromptData(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarychecknotprompt");
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        helper.deleteByFilter(new QFilter[]{filter});
    }
}

