/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result.calitemhandle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.result.calitemhandle.BaseCalItemHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemHelper;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalResultItem;

public class CalBCHandle
extends BaseCalItemHandle {
    public CalBCHandle(CalResultItemEnum itemEnum) {
        super(itemEnum);
    }

    @Override
    protected void addEntryData(DynamicObject calTable, List<CalResultItem> itemResultList) {
        if (SWCListUtils.isEmpty(itemResultList)) {
            return;
        }
        DynamicObject task = this.getTask();
        String periodDateRange = CalUtils.getDataRange(task.getDate("startdate"), task.getDate("enddate"));
        itemResultList = itemResultList.stream().sorted(Comparator.comparing(CalResultItem::getEndDate)).collect(Collectors.toList());
        Map<Long, List<CalResultItem>> itemResulMap = itemResultList.stream().collect(Collectors.groupingBy(CalResultItem::getItemId));
        DynamicObjectCollection bcEntryList = calTable.getDynamicObjectCollection("hsas_calbcentry");
        if (bcEntryList == null) {
            bcEntryList = new DynamicObjectCollection();
        }
        Map<Long, Map<String, DynamicObject>> bcEntryMap = this.getExistFtEntryMap(bcEntryList);
        Map existBsDataMap = null;
        DynamicObject entry = null;
        int seq = bcEntryList.size() + 1;
        Boolean isSucess = Boolean.TRUE;
        CalResultItem item = null;
        String dateRange = null;
        for (Map.Entry<Long, List<CalResultItem>> itemEntry : itemResulMap.entrySet()) {
            existBsDataMap = bcEntryMap.getOrDefault(itemEntry.getKey(), new HashMap(16));
            int prorationIndex = 0;
            int size = itemEntry.getValue().size();
            for (int index = 0; index < size; ++index) {
                item = itemEntry.getValue().get(index);
                dateRange = CalUtils.getDataRange(item.getStartDate(), item.getEndDate());
                entry = (DynamicObject)existBsDataMap.get(dateRange);
                if (entry != null) {
                    entry.set("bccalblock", (Object)"2");
                    this.setItemValue(item, entry);
                    continue;
                }
                entry = bcEntryList.addNew();
                entry.set("seq", (Object)seq);
                entry.set("fetchitem", (Object)item.getItemId());
                entry.set("bccalblock", (Object)SaveCalItemHelper.getCalBlock(this.getCalType()));
                entry.set("bcstartdate", (Object)item.getStartDate());
                entry.set("bcenddate", (Object)item.getEndDate());
                entry.set("ftprorationindex", (Object)item.getProrationIndex());
                if (dateRange.equals(periodDateRange)) {
                    entry.set("ftprorationindex", (Object)0);
                } else {
                    entry.set("ftprorationindex", (Object)(++prorationIndex));
                }
                this.setItemValue(item, entry);
                ++seq;
            }
        }
        if ("afterTaxCal".equals(this.getCalType())) {
            this.resetProrationIndex(bcEntryList, periodDateRange);
        }
        calTable.set("hsas_calbcentry", (Object)bcEntryList);
    }

    private DynamicObjectCollection resetProrationIndex(DynamicObjectCollection bcEntryList, String periodDateRange) {
        List list = bcEntryList.stream().sorted(Comparator.comparing(obj -> obj.getDate("bcenddate"))).collect(Collectors.toList());
        HashMap<Long, ArrayList<DynamicObject>> resultMap = new HashMap<Long, ArrayList<DynamicObject>>(list.size());
        ArrayList<DynamicObject> tempList = null;
        for (DynamicObject temp : list) {
            long itemId = temp.getLong("fetchitem.id");
            if (itemId == 0L) {
                itemId = temp.getLong("fetchitem");
            }
            if ((tempList = (ArrayList<DynamicObject>)resultMap.get(itemId)) == null) {
                tempList = new ArrayList<DynamicObject>();
                resultMap.put(itemId, tempList);
            }
            tempList.add(temp);
        }
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        String dateRange = null;
        for (Map.Entry item : resultMap.entrySet()) {
            int prorationIndex = 0;
            for (DynamicObject obj2 : (List)item.getValue()) {
                dateRange = CalUtils.getDataRange(obj2.getDate("bcstartdate"), obj2.getDate("bcenddate"));
                if (dateRange.equals(periodDateRange)) {
                    obj2.set("ftprorationindex", (Object)0);
                } else {
                    obj2.set("ftprorationindex", (Object)(++prorationIndex));
                }
                entryList.add((Object)obj2);
            }
        }
        return entryList;
    }

    private Map<Long, Map<String, DynamicObject>> getExistFtEntryMap(DynamicObjectCollection bcEntryList) {
        HashMap<Long, Map<String, DynamicObject>> ftEntryMap = new HashMap<Long, Map<String, DynamicObject>>(bcEntryList.size());
        if (bcEntryList.size() == 0) {
            return ftEntryMap;
        }
        Map tempMap = null;
        for (DynamicObject obj : bcEntryList) {
            tempMap = ftEntryMap.getOrDefault(obj.getLong("fetchitem.id"), new HashMap(16));
            tempMap.put(CalUtils.getDataRange(obj.getDate("bcstartdate"), obj.getDate("bcenddate")), obj);
            ftEntryMap.put(obj.getLong("fetchitem.id"), tempMap);
        }
        return ftEntryMap;
    }

    private void setItemValue(CalResultItem itemParam, DynamicObject entry) {
        SaveDataTypeEnum dataType = SaveDataTypeEnum.getDataType((String)itemParam.getDataShowType());
        switch (dataType) {
            case NUM: {
                entry.set("bcnumvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getItemResult()));
                break;
            }
            case DATE: {
                entry.set("bcdatevalue", (Object)SaveCalItemHelper.getItemDateResult(itemParam.getItemResult()));
                break;
            }
            case TEXT: {
                entry.set("bctextvalue", (Object)SaveCalItemHelper.getItemStringResult(itemParam.getItemResult()));
                break;
            }
        }
    }
}

