/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result.calitemhandle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.result.calitemhandle.BaseCalItemHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemHelper;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalResultItem;

public class CalBSHandle
extends BaseCalItemHandle {
    public CalBSHandle(CalResultItemEnum itemEnum) {
        super(itemEnum);
    }

    @Override
    protected void addEntryData(DynamicObject calTable, List<CalResultItem> itemResultList) {
        if (SWCListUtils.isEmpty(itemResultList)) {
            return;
        }
        DynamicObject task = this.getTask();
        String periodDateRange = CalUtils.getDataRange(task.getDate("startdate"), task.getDate("enddate"));
        itemResultList = itemResultList.stream().sorted(Comparator.comparing(CalResultItem::getEndDate)).collect(Collectors.toList());
        Map<Long, List<CalResultItem>> itemResulMap = itemResultList.stream().collect(Collectors.groupingBy(CalResultItem::getItemId));
        DynamicObjectCollection bsEntryList = calTable.getDynamicObjectCollection("hsas_calbsentry");
        if (bsEntryList == null) {
            bsEntryList = new DynamicObjectCollection();
        }
        Map<Long, Map<String, DynamicObject>> bsEntryMap = this.getExistBsEntryMap(bsEntryList);
        DynamicObject entry = null;
        Boolean isSucess = Boolean.TRUE;
        Map existBsDataMap = null;
        int seq = bsEntryList.size() + 1;
        CalResultItem item = null;
        String dateRange = null;
        for (Map.Entry<Long, List<CalResultItem>> itemEntry : itemResulMap.entrySet()) {
            existBsDataMap = bsEntryMap.getOrDefault(itemEntry.getKey(), new HashMap(16));
            int prorationIndex = 0;
            int size = itemEntry.getValue().size();
            for (int index = 0; index < size; ++index) {
                item = itemEntry.getValue().get(index);
                dateRange = CalUtils.getDataRange(item.getStartDate(), item.getEndDate());
                entry = (DynamicObject)existBsDataMap.get(dateRange);
                if (entry != null) {
                    entry.set("bscalblock", (Object)"2");
                    this.setItemValue(item, entry);
                    continue;
                }
                entry = bsEntryList.addNew();
                entry.set("seq", (Object)seq);
                entry.set("bizitemtype", (Object)item.getItemType());
                entry.set("bizitem", (Object)item.getItemId());
                entry.set("bscalblock", (Object)SaveCalItemHelper.getCalBlock(this.getCalType()));
                entry.set("bsstartdate", (Object)item.getStartDate());
                entry.set("bsenddate", (Object)item.getEndDate());
                entry.set("bsproratetype", (Object)item.getProrateType());
                if (dateRange.equals(periodDateRange)) {
                    entry.set("bsprorationindex", (Object)0);
                } else {
                    entry.set("bsprorationindex", (Object)(++prorationIndex));
                }
                this.setItemValue(item, entry);
                ++seq;
            }
        }
        if ("afterTaxCal".equals(this.getCalType())) {
            this.resetProrationIndex(bsEntryList, periodDateRange);
        }
        calTable.set("hsas_calbsentry", (Object)bsEntryList);
    }

    private DynamicObjectCollection resetProrationIndex(DynamicObjectCollection bsEntryList, String periodDateRange) {
        List list = bsEntryList.stream().sorted(Comparator.comparing(obj -> obj.getDate("bsenddate"))).collect(Collectors.toList());
        HashMap<Long, ArrayList<DynamicObject>> resultMap = new HashMap<Long, ArrayList<DynamicObject>>(list.size());
        ArrayList<DynamicObject> tempList = null;
        for (DynamicObject temp : list) {
            long itemId = temp.getLong("bizitem.id");
            if (itemId == 0L) {
                itemId = temp.getLong("bizitem");
            }
            if ((tempList = (ArrayList<DynamicObject>)resultMap.get(itemId)) == null) {
                tempList = new ArrayList<DynamicObject>();
                resultMap.put(itemId, tempList);
            }
            tempList.add(temp);
        }
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        String dateRange = null;
        for (Map.Entry item : resultMap.entrySet()) {
            int prorationIndex = 0;
            for (DynamicObject obj2 : (List)item.getValue()) {
                dateRange = CalUtils.getDataRange(obj2.getDate("bsstartdate"), obj2.getDate("bsenddate"));
                if (dateRange.equals(periodDateRange)) {
                    obj2.set("bsprorationindex", (Object)0);
                } else {
                    obj2.set("bsprorationindex", (Object)(++prorationIndex));
                }
                entryList.add((Object)obj2);
            }
        }
        return entryList;
    }

    private Map<Long, Map<String, DynamicObject>> getExistBsEntryMap(DynamicObjectCollection bsEntryList) {
        HashMap<Long, Map<String, DynamicObject>> bsEntryMap = new HashMap<Long, Map<String, DynamicObject>>(bsEntryList.size());
        if (bsEntryList.size() == 0) {
            return bsEntryMap;
        }
        Map tempMap = null;
        for (DynamicObject obj : bsEntryList) {
            tempMap = bsEntryMap.getOrDefault(obj.getLong("bizitem.id"), new HashMap(16));
            tempMap.put(CalUtils.getDataRange(obj.getDate("bsstartdate"), obj.getDate("bsenddate")), obj);
            bsEntryMap.put(obj.getLong("bizitem.id"), tempMap);
        }
        return bsEntryMap;
    }

    private void setItemValue(CalResultItem itemParam, DynamicObject entry) {
        SaveDataTypeEnum dataType = SaveDataTypeEnum.getDataType((String)itemParam.getDataShowType());
        switch (dataType) {
            case NUM: {
                entry.set("bsnumvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getItemResult()));
                break;
            }
            case DATE: {
                entry.set("bsdatevalue", (Object)SaveCalItemHelper.getItemDateResult(itemParam.getItemResult()));
                break;
            }
            case TEXT: {
                entry.set("bstextvalue", (Object)SaveCalItemHelper.getItemStringResult(itemParam.getItemResult()));
                break;
            }
            case AMOUNT: {
                entry.set("bscalamountvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getItemResult()));
                entry.set("bsoriamountvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getOriAmountValue()));
                entry.set("bsoricurrency", (Object)itemParam.getOriCurrencyId());
                entry.set("bsexratevalue", (Object)itemParam.getExRateValue());
                entry.set("bsexratetype", (Object)(itemParam.getExRateType() != false ? "1" : "0"));
                break;
            }
        }
    }
}

