/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result.calitemhandle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;

public class SaveCalItemHelper {
    public static final Log logger = LogFactory.getLog(SaveCalItemHelper.class);

    public static BigDecimal getItemBigDecimalResult(Object itemResult) {
        String value = String.valueOf(itemResult);
        if (itemResult == null || "".equals(value)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = new BigDecimal(value);
        BigDecimal formatBigDecimal = bigDecimal.setScale(CalUtils.getSystemDefaultScal(), RoundingMode.HALF_UP);
        return formatBigDecimal;
    }

    public static String getCalBlock(String calType) {
        if ("afterTaxCal".equals(calType)) {
            return "1";
        }
        if ("onlyPreTaxCal".equals(calType) || "preTaxCal".equals(calType)) {
            return "0";
        }
        return " ";
    }

    public static String getItemStringResult(Object itemResult) {
        if (itemResult == null) {
            return "";
        }
        return String.valueOf(itemResult);
    }

    public static Date getItemDateResult(Object itemResult) {
        try {
            if (itemResult == null) {
                return null;
            }
            if (itemResult instanceof Date) {
                return (Date)itemResult;
            }
            if (itemResult instanceof Long) {
                Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
                cal.setTimeInMillis((Long)itemResult);
                return cal.getTime();
            }
            return SWCDateTimeUtils.parseDate((String)String.valueOf(itemResult), (String)"yyyy-MM-dd", (TimeZone)KDDateUtils.getSysTimeZone());
        }
        catch (ParseException e) {
            logger.info("parse date error :", (Object)e.getMessage());
            return null;
        }
    }
}

