/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result.calitemhandle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.result.calitemhandle.CalBCHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.CalBSHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.CalSLHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.CalSPHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.CalSlAndBsRelHandle;
import kd.swc.hscs.common.vo.CalResultItem;
import kd.swc.hscs.common.vo.CalResultItemRel;
import kd.swc.hscs.common.vo.CalResultVO;

public class SaveCalItemService {
    private static final Log logger = LogFactory.getLog(SaveCalItemService.class);
    private CalBCHandle bcHandle;
    private CalSPHandle spHandle;
    private CalBSHandle bsHandle;
    private CalSLHandle stHandle;
    private CalSlAndBsRelHandle relHandle;
    private Map<Long, DynamicObject> calPersonMap;
    private Map<Long, Long> calPersonMapCalTable;
    private String calType;
    private Long calTaskId;
    private DynamicObject task;

    public SaveCalItemService(Map<Long, DynamicObject> calIdMap, String calType, Long calTaskId, DynamicObject task) {
        this.calType = calType;
        this.calTaskId = calTaskId;
        this.task = task;
        this.init(calIdMap);
    }

    private void init(Map<Long, DynamicObject> calIdMap) {
        this.bcHandle = new CalBCHandle(CalResultItemEnum.SYSITEM);
        this.bcHandle.setCalType(this.calType);
        this.bcHandle.setTask(this.task);
        this.spHandle = new CalSPHandle(CalResultItemEnum.SUPPORTITEM);
        this.spHandle.setCalType(this.calType);
        this.spHandle.setTask(this.task);
        this.bsHandle = new CalBSHandle(CalResultItemEnum.BIZITEM);
        this.bsHandle.setCalType(this.calType);
        this.bsHandle.setTask(this.task);
        this.stHandle = new CalSLHandle(CalResultItemEnum.SALARYITEM);
        this.stHandle.setCalType(this.calType);
        this.stHandle.setTask(this.task);
        this.relHandle = new CalSlAndBsRelHandle();
        this.calPersonMap = calIdMap;
        this.calPersonMapCalTable = new HashMap<Long, Long>(16);
    }

    public void saveCalItemData(List<CalResultItem> itemResultList, List<CalResultItemRel> calResultItemRelList) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_caltable");
        Map<Long, DynamicObject> calTableMap = this.getCalTableMap(calTableHelper);
        this.filterNullItem(itemResultList);
        Set<Long> delCalPersonIdSet = this.calPersonMap.keySet();
        HashMap<Long, ArrayList<CalResultItem>> ftItemMap = new HashMap<Long, ArrayList<CalResultItem>>(16);
        HashMap<Long, ArrayList<CalResultItem>> bsItemMap = new HashMap<Long, ArrayList<CalResultItem>>(16);
        HashMap<Long, ArrayList<CalResultItem>> spItemMap = new HashMap<Long, ArrayList<CalResultItem>>(16);
        HashMap<Long, ArrayList<CalResultItem>> slItemMap = new HashMap<Long, ArrayList<CalResultItem>>(16);
        Map<Long, List<CalResultItemRel>> relMap = calResultItemRelList.stream().collect(Collectors.groupingBy(CalResultItemRel::getCalPersonId));
        List<Object> tempList = null;
        for (CalResultItem item : itemResultList) {
            if (item.getItemEnum() == CalResultItemEnum.SYSITEM) {
                tempList = (ArrayList<CalResultItem>)ftItemMap.get(item.getCalPersonId());
                if (tempList == null) {
                    tempList = new ArrayList<CalResultItem>(10);
                    ftItemMap.put(item.getCalPersonId(), (ArrayList<CalResultItem>)tempList);
                }
            } else if (item.getItemEnum() == CalResultItemEnum.BIZITEM) {
                tempList = (List)bsItemMap.get(item.getCalPersonId());
                if (tempList == null) {
                    tempList = new ArrayList(10);
                    bsItemMap.put(item.getCalPersonId(), (ArrayList<CalResultItem>)tempList);
                }
            } else if (item.getItemEnum() == CalResultItemEnum.SUPPORTITEM) {
                tempList = (List)spItemMap.get(item.getCalPersonId());
                if (tempList == null) {
                    tempList = new ArrayList(10);
                    spItemMap.put(item.getCalPersonId(), (ArrayList<CalResultItem>)tempList);
                }
            } else if (item.getItemEnum() == CalResultItemEnum.SALARYITEM && (tempList = (List)slItemMap.get(item.getCalPersonId())) == null) {
                tempList = new ArrayList(10);
                slItemMap.put(item.getCalPersonId(), (ArrayList<CalResultItem>)tempList);
            }
            if (tempList == null) continue;
            tempList.add(item);
        }
        DynamicObjectCollection calTableCollection = new DynamicObjectCollection();
        for (Map.Entry<Long, DynamicObject> entry : calTableMap.entrySet()) {
            this.bcHandle.addEntryData(entry.getValue(), (List)ftItemMap.get(entry.getKey()));
            this.bsHandle.addEntryData(entry.getValue(), (List)bsItemMap.get(entry.getKey()));
            this.spHandle.addEntryData(entry.getValue(), (List)spItemMap.get(entry.getKey()));
            this.stHandle.addEntryData(entry.getValue(), (List)slItemMap.get(entry.getKey()));
            this.relHandle.addEntryData(entry.getValue(), relMap.get(entry.getKey()));
            calTableCollection.add((Object)entry.getValue());
        }
        this.deleteCalTableByCalType(delCalPersonIdSet);
        logger.info("calTable data save start");
        calTableHelper.save(calTableCollection);
        logger.info("calTable data save end");
    }

    private void filterNullItem(List<CalResultItem> itemParams) {
        Iterator<CalResultItem> itemIterator = itemParams.iterator();
        while (itemIterator.hasNext()) {
            CalResultItem item = itemIterator.next();
            if (item instanceof CalResultVO) {
                CalResultVO calResult = (CalResultVO)item;
                if (calResult.getCalResultValue() != null) continue;
                itemIterator.remove();
                continue;
            }
            if (item.getItemResult() != null) continue;
            itemIterator.remove();
        }
    }

    private void deleteCalTable(Set<Long> calPersonIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdSet);
        filter.and("caltask", "=", (Object)this.calTaskId);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    private void deleteCalTableByCalType(Set<Long> calPersonIdSet) {
        logger.info("deleteCalTableByCalType start");
        if (!SWCStringUtils.equals((String)this.calType, (String)"afterTaxCal")) {
            this.deleteCalTable(calPersonIdSet);
        }
        logger.info("deleteCalTableByCalType end");
    }

    private Map<Long, DynamicObject> getCalTableMap(SWCDataServiceHelper calTableHelper) {
        Map<Object, Object> unCalpersonMap = new HashMap(16);
        ArrayList<Long> calTableIdList = new ArrayList<Long>(10);
        if ("afterTaxCal".equals(this.calType)) {
            DynamicObject calPerson = null;
            for (Map.Entry<Long, DynamicObject> entry : this.calPersonMap.entrySet()) {
                calPerson = entry.getValue();
                if (0L != calPerson.getLong("calresultid")) {
                    this.calPersonMapCalTable.put(entry.getKey(), calPerson.getLong("calresultid"));
                    calTableIdList.add(calPerson.getLong("calresultid"));
                    continue;
                }
                unCalpersonMap.put(entry.getKey(), entry.getValue());
            }
        } else {
            unCalpersonMap = this.calPersonMap;
        }
        DynamicObjectCollection calTableList = new DynamicObjectCollection();
        long[] ids = DB.genLongIds((String)"hsas_caltable", (int)unCalpersonMap.size());
        int index = 0;
        DynamicObject calTable = null;
        DynamicObject calPerson = null;
        for (Map.Entry<Object, Object> entry : unCalpersonMap.entrySet()) {
            Long calPersonId = (Long)entry.getKey();
            long calTableId = ids[index];
            calPerson = (DynamicObject)entry.getValue();
            this.calPersonMapCalTable.put(calPersonId, calTableId);
            ++index;
            calTable = calTableHelper.generateEmptyDynamicObject();
            calTable.set("id", (Object)calTableId);
            calTable.set("calpersonid", (Object)calPersonId);
            calTable.set("org", (Object)calPerson.getLong("org.id"));
            calTable.set("belongperiod", (Object)calPerson.getDate("belongperiod"));
            calTable.set("caltask", (Object)calPerson.getLong("caltask.id"));
            calTable.set("modifytime", (Object)new Date());
            calTable.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calTableList.add((Object)calTable);
        }
        DynamicObject[] calTableArray = this.getCalTableData(calTableIdList, calTableHelper);
        calTableList.addAll(Arrays.asList(calTableArray));
        return calTableList.stream().collect(Collectors.toMap(obj -> obj.getLong("calpersonid"), obj -> obj));
    }

    private DynamicObject[] getCalTableData(List<Long> calTableIdList, SWCDataServiceHelper calTableHelper) {
        if (SWCListUtils.isEmpty(calTableIdList)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("caltask", "=", (Object)this.calTaskId);
        String fields = "id,calpersonid,belongperiod,org,hsas_calbsentry.seq,hsas_calbsentry.bizitem,hsas_calbsentry.bscalblock,hsas_calbsentry.bsstartdate,hsas_calbsentry.bsenddate,hsas_calbsentry.bsnumvalue,hsas_calbsentry.bsdatevalue,hsas_calbsentry.bstextvalue,hsas_calbsentry.bscalamountvalue,hsas_calbsentry.bsoriamountvalue,hsas_calbsentry.bsoricurrency,hsas_calbsentry.bsexratevalue,hsas_calbsentry.bsexratetype,hsas_calbsentry.bsprorationindex,hsas_calbsentry.bsproratetype, hsas_calbsentry.bizitemtype,hsas_calspentry.seq,hsas_calspentry.supportitem,hsas_calspentry.spcalblock,hsas_calspentry.spstartdate,hsas_calspentry.spenddate,hsas_calspentry.spnumvalue,hsas_calspentry.spdatevalue,hsas_calspentry.sptextvalue,hsas_calspentry.spprorationindex,hsas_calbcentry.seq,hsas_calbcentry.fetchitem,hsas_calbcentry.bccalblock,hsas_calbcentry.bcstartdate,hsas_calbcentry.bcenddate,hsas_calbcentry.bcnumvalue,hsas_calbcentry.bcdatevalue,hsas_calbcentry.bctextvalue,hsas_calbcentry.ftprorationindex,hsas_caltableentry.seq,hsas_caltableentry.salaryitem,hsas_caltableentry.numvalue,hsas_caltableentry.datevalue,hsas_caltableentry.textvalue,hsas_caltableentry.calamountvalue,hsas_caltableentry.proportion,hsas_caltableentry.slstartdate,hsas_caltableentry.slenddate,hsas_caltableentry.slprorationindex,hsas_caltableentry.resultcover,hsas_calslbsrelentry.seq,hsas_calslbsrelentry.slitem,hsas_calslbsrelentry.bsitem,hsas_calslbsrelentry.relprorationindex";
        DynamicObject[] calTableArray = calTableHelper.query(fields, new QFilter[]{filter});
        return calTableArray;
    }

    public Map<Long, Long> getCalPersonMapCalTable() {
        return this.calPersonMapCalTable;
    }

    public void deleteCalItemData() {
        this.deleteCalTableByCalType(this.calPersonMap.keySet());
    }
}

