/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.rollback.helper;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;

public class TaxPushHelper {
    public static final Log log = LogFactory.getLog(TaxPushHelper.class);
    public static final String TAX_SWITCH_ON_AND_PUSH_TAX_FAILED = "1";
    public static final String TAX_SWITCH_ON_AND_PUSH_TAX_SUCCESS = "2";

    public static void updateProgress(Long calTaskId, Long calRecordId, int successCount, int failCount, String cancelType, String stopOperateKey) {
        String cacheOperateKey;
        log.info("updateProgress start,recordId = {}", (Object)calRecordId);
        if (!"stopcal".equals(cancelType) && CalUtils.isTerminationCal(calRecordId)) {
            return;
        }
        ISWCAppCache stopCancelAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        if ("stopcal".equals(cancelType) && !SWCStringUtils.equals((String)stopOperateKey, (String)(cacheOperateKey = (String)stopCancelAppCache.get("stopLastOperateKey", String.class)))) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        boolean isFinished = false;
        String lockKey = "_updateCalRecordCount_" + calRecordId;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(120000L)) {
                log.info("get lock {}", (Object)lockKey);
                ISWCAppCache appCache = SWCAppCache.get((String)"SWC_CAL");
                String cacheKey = MessageFormat.format("tax_record_progress_{0}", String.valueOf(calRecordId));
                HashMap<String, Integer> result = (HashMap<String, Integer>)appCache.get(cacheKey, Map.class);
                if (result == null) {
                    result = new HashMap<String, Integer>(2);
                }
                int oldSuccessCount = result.get("successcount") == null ? 0 : (Integer)result.get("successcount");
                int oldFailCount = result.get("failcount") == null ? 0 : (Integer)result.get("failcount");
                result.put("successcount", successCount + oldSuccessCount);
                result.put("failcount", failCount + oldFailCount);
                appCache.put(cacheKey, result);
                DynamicObject calRecord = helper.queryOne("id,sucesscount,failcount,calstatus,modifytime,totalcount,endtime", new QFilter[]{new QFilter("id", "=", (Object)calRecordId)});
                String calStatus = TAX_SWITCH_ON_AND_PUSH_TAX_SUCCESS;
                if ("stopcal".equals(cancelType)) {
                    calStatus = "3";
                }
                int totalCount = calRecord.getInt("totalcount");
                int dbSucCount = calRecord.getInt("sucesscount") + successCount;
                int dbFailCount = calRecord.getInt("failcount") + failCount;
                calRecord.set("sucesscount", (Object)dbSucCount);
                calRecord.set("failcount", (Object)dbFailCount);
                calRecord.set("modifytime", (Object)new Date());
                if (totalCount == dbSucCount + dbFailCount) {
                    isFinished = true;
                    calRecord.set("calstatus", (Object)calStatus);
                    calRecord.set("endtime", (Object)new Date());
                    CalRequestHelper.updateCalRequest((Long)calRecordId, (String)CalRequestStatusEnum.FINISHED.getCode());
                }
                helper.updateOne(calRecord);
                log.info("cancel cal,recordId = {},totalCount = {},successCount = {},failCount = {}", new Object[]{calRecordId, totalCount, dbSucCount, dbFailCount});
            } else {
                log.error("try lock updateCancelCalResult is fail\uff0crecordId = {}", (Object)calRecordId);
            }
        }
        catch (Exception e) {
            log.error("TaxPushHelper.updateProgress: updateProgress error  :", (Throwable)e);
        }
        if (isFinished) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey());
            stopCancelAppCache.remove("firstOperateStopCal");
            stopCancelAppCache.remove("stopLastOperateKey");
            stopCancelAppCache.remove(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", calRecordId));
            if ("stopcal".equals(cancelType)) {
                CalUtils.releaseCalCacheData(calRecordId);
            }
        }
        log.info("updateProgress end,recordId = {}", (Object)calRecordId);
    }

    public static DynamicObject createCalDetail(MainEntityType type, DynamicObject calPerson, String msg, Long calRecordId, String failType, String status) {
        DynamicObject calDetail = (DynamicObject)type.createInstance();
        if (SWCStringUtils.isNotEmpty((String)msg) && msg.length() > 999) {
            msg = msg.substring(0, 999);
        }
        calDetail.set("failmsg", (Object)msg);
        calDetail.set("record", (Object)calRecordId);
        calDetail.set("batch", (Object)0);
        calDetail.set("caltask", (Object)calPerson.getLong("caltask.id"));
        calDetail.set("salaryfile", (Object)calPerson.getLong("salaryfile.id"));
        calDetail.set("calpersonid", (Object)calPerson.getLong("id"));
        calDetail.set("calstatus", (Object)status);
        calDetail.set("failtype", (Object)failType);
        calDetail.set("errorelement", (Object)"-");
        calDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
        calDetail.set("createtime", (Object)new Date());
        calDetail.set("modifier", (Object)RequestContext.get().getCurrUserId());
        calDetail.set("modifytime", (Object)new Date());
        calDetail.set("caltablecalstate", (Object)calPerson.getString("calstatus"));
        return calDetail;
    }
}

