/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.business.cal.helper.SalaryCalServiceHelper;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.acc.AccDetailsVO;
import kd.swc.hscs.common.vo.acc.AccDimensionInfo;
import kd.swc.hscs.common.vo.acc.AccInfo;
import kd.swc.hscs.common.vo.acc.AccMemberInfo;
import kd.swc.hscs.common.vo.acc.AccResultVO;
import org.apache.commons.collections.MapUtils;

public class AccService {
    private static final String CONNECTOR = "@;@";
    private static final String STRING_TRUE = "1";
    private static final String STRING_FALSE = "0";
    private String traceId;
    private Map<String, ExchangeRateInfo> exrateCacheMap;
    private boolean isOnlyCal;
    private static final Log logger = LogFactory.getLog(AccService.class);

    public AccService(String traceId, Map<String, ExchangeRateInfo> exrateCacheMap, boolean isOnlyCal) {
        this.traceId = traceId;
        this.exrateCacheMap = exrateCacheMap;
        this.isOnlyCal = isOnlyCal;
    }

    public static AccInfo getAccInfoObj(DynamicObject obj) {
        AccInfo accInfo = new AccInfo();
        accInfo.setId(obj.getLong("id"));
        accInfo.setUniqueCode(obj.getString("uniquecode"));
        accInfo.setUpdateStrategy(obj.getString("updatestrategy"));
        accInfo.setPeriodType(obj.getString("periodtype"));
        accInfo.setStartDateType(obj.getString("startdatetype"));
        accInfo.setStartDate(obj.getDate("startdate"));
        accInfo.setStartDateItemCode(obj.getString("startdateitem.uniquecode"));
        accInfo.setStartMonth(obj.getString("startmonth"));
        accInfo.setStartDay(obj.getInt("startday"));
        accInfo.setBsedStrategy(obj.getString("bsedstrategy"));
        accInfo.setAccDimension(obj.getString("accdimension"));
        accInfo.setDataRoundId(obj.getLong("dataround.id"));
        accInfo.setDataPrecisionId(obj.getLong("dataprecision.id"));
        accInfo.setDataTypeId(obj.getLong("datatype.id"));
        return accInfo;
    }

    public static boolean checkAccMember(DynamicObject acc, List<Long> salaryItemIdList, List<Long> bizItemIdList, Date startDate, Date endDate, List<AccMemberInfo> accMemberList) {
        boolean isMatch = false;
        DynamicObjectCollection entryList = acc.getDynamicObjectCollection("accmemberentry");
        if (entryList.size() == 0) {
            return false;
        }
        for (DynamicObject entry : entryList) {
            AccMemberInfo memberInfo = AccService.getAccMemberObj(acc, entry);
            accMemberList.add(memberInfo);
            if (!salaryItemIdList.contains(entry.getLong("salaryitem.id")) && !bizItemIdList.contains(entry.getLong("bizitem.id"))) {
                memberInfo.setUsed(false);
                continue;
            }
            if (entry.getDate("accmemstartdate").after(endDate) || entry.getDate("accmemenddate") != null && entry.getDate("accmemenddate").before(startDate)) continue;
            isMatch = true;
            memberInfo.setUsed(true);
        }
        return isMatch;
    }

    public static void setAccDimensionInfoList(AccInfo accInfo, DynamicObject obj, List<String> fetchItemCodeList) {
        DynamicObjectCollection dimensionEntryList = obj.getDynamicObjectCollection("accdimitementry");
        if (CollectionUtils.isEmpty((Collection)dimensionEntryList)) {
            return;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dimensionEntryList.size());
        for (DynamicObject entry : dimensionEntryList) {
            AccDimensionInfo dimension = new AccDimensionInfo();
            dimension.setDimitemType(entry.getString("dimitemtype"));
            dimension.setFetchItemCode(entry.getString("fetchitem.uniquecode"));
            if (SWCStringUtils.equals((String)STRING_TRUE, (String)dimension.getDimitemType()) && !fetchItemCodeList.contains(dimension.getFetchItemCode()) && SWCStringUtils.isNotEmpty((String)dimension.getFetchItemCode())) {
                fetchItemCodeList.add(dimension.getFetchItemCode());
            }
            list.add(dimension);
        }
        accInfo.setDimensionInfoList((List)list);
    }

    public static AccMemberInfo getAccMemberObj(DynamicObject acc, DynamicObject entry) {
        AccMemberInfo memberInfo = new AccMemberInfo();
        memberInfo.setId(acc.getLong("id"));
        memberInfo.setUniqueCode(acc.getString("uniquecode"));
        memberInfo.setMemberType(entry.getString("membertype"));
        memberInfo.setSalaryItemId(entry.getLong("salaryitem.id"));
        memberInfo.setSlUniqueCode(entry.getString("salaryitem.uniquecode"));
        memberInfo.setBizItemId(entry.getLong("bizitem.id"));
        memberInfo.setBsUniqueCode(entry.getString("bizitem.uniquecode"));
        memberInfo.setStartDate(entry.getDate("accmemstartdate"));
        memberInfo.setEndDate(entry.getDate("accmemenddate"));
        memberInfo.setOperator(entry.getString("operator"));
        memberInfo.setAccPercentType(entry.getString("accpercenttype"));
        memberInfo.setPercentFixVal(entry.getBigDecimal("percentfixval"));
        return memberInfo;
    }

    private void deleteAccData(List<Long> calPersonIdList, Date exRateDate, Long exRateTableId, Long calTaskId) {
        logger.info("deleteAccData begin,traceId={}", (Object)this.traceId);
        try (TXHandle txHandle = TX.requiresNew();){
            CalOperationHelper.deleteAccData(calPersonIdList, exRateDate, exRateTableId, calTaskId);
            txHandle.commit();
        }
        logger.info("deleteAccData end,traceId={}", (Object)this.traceId);
    }

    public Map<Long, Map<String, AccDetailsVO>> instanceAcc(CalParamCacheInfo calParamInfo, DynamicObjectCollection calPersonData, Map<Long, Map<String, Object>> periodProrationRowMap, Long calTaskId, Long recordId) throws Exception {
        logger.info("instanceAcc start,calTaskId = {},traceId = {}", (Object)calTaskId, (Object)this.traceId);
        List<Long> calPersonIdList = calPersonData.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map calTaskMap = calParamInfo.getCalTaskMap();
        if (CalUtils.isTerminationCal(recordId)) {
            return new HashMap<Long, Map<String, AccDetailsVO>>(0);
        }
        Date exRateDate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
        Long exRateTableId = MapUtils.getLong((Map)calTaskMap, (Object)"exratetableId");
        String calType = calParamInfo.getCalType();
        if (!SWCStringUtils.equals((String)"afterTaxCal", (String)calType) && !this.isOnlyCal) {
            this.deleteAccData(calPersonIdList, exRateDate, exRateTableId, calTaskId);
        }
        HashMap<Long, Map<String, AccDetailsVO>> allAccDetailsMap = new HashMap<Long, Map<String, AccDetailsVO>>(16);
        List accInfoList = calParamInfo.getAccInfoList();
        if (CollectionUtils.isEmpty((Collection)accInfoList)) {
            logger.info("accDataList is empty,traceId= {}", (Object)this.traceId);
            if ("afterTaxCal".equals(calType)) {
                this.handPreTaxAccDetailData(allAccDetailsMap, calPersonIdList, calTaskId, calParamInfo);
            }
            return allAccDetailsMap;
        }
        List<Long> personIndexIdList = calPersonData.stream().map(obj -> obj.getLong("personhrv.personindexid")).collect(Collectors.toList());
        List<Long> salaryFileIdList = calPersonData.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toList());
        Date payDate = SWCDateTimeUtils.formatDateToDate((Date)calParamInfo.getPayDate(), (String)"yyyy-MM-dd");
        Date startDate = SWCDateTimeUtils.formatDateToDate((Date)calParamInfo.getStartDate(), (String)"yyyy-MM-dd");
        Date endDate = SWCDateTimeUtils.formatDateToDate((Date)calParamInfo.getEndDate(), (String)"yyyy-MM-dd");
        Map<Long, HashSet<Long>> salaryItemIdForFileMap = SalaryCalServiceHelper.getFileSalaryItemMap(calParamInfo, salaryFileIdList);
        Map<Long, Map<Long, DynamicObject>> accDetailMap = this.getAccDetailDataMap(calPersonIdList, calTaskId);
        ArrayList<Long> accResultIdList = new ArrayList<Long>(10);
        QFilter dateQFilter = this.getDateQFilter(startDate, endDate, payDate);
        List<Long> accIdList = accInfoList.stream().map(AccInfo::getId).collect(Collectors.toList());
        Map<String, List<DynamicObject>> accResultMap = this.getExistAccResultMap(personIndexIdList, accIdList, accResultIdList, dateQFilter);
        Map<String, Integer> accResultNumMap = this.getAccResultNumMap(accIdList, personIndexIdList);
        Map<Long, Integer> accDetailsIndexMap = this.getAccDetailsIndexMap(accResultIdList, calTaskId);
        ArrayList<AccResultVO> accResultList = new ArrayList<AccResultVO>(10);
        AccDetailsVO tempAccDetail = null;
        for (DynamicObject calPerson : calPersonData) {
            Long calPersonId = calPerson.getLong("id");
            Map tempAccDetailsMap = allAccDetailsMap.computeIfAbsent(calPersonId, key -> new HashMap(16));
            Map<Long, DynamicObject> existAccDetailsMap = accDetailMap.get(calPersonId);
            for (AccInfo accInfo : accInfoList) {
                DynamicObject accResultObj;
                if (!accInfo.isOnlyFormulaUse() && !this.checkAccIsCanUsedForFile((Set<Long>)salaryItemIdForFileMap.get(calPerson.getLong("salaryfile.id")), accInfo.getMemberInfoList())) continue;
                Map<String, Object> itemValueMap = periodProrationRowMap.get(calPersonId);
                String accKey = this.getAccDimensionKey(accInfo, itemValueMap, calPerson);
                List<DynamicObject> tempAccObjList = accResultMap.get(accKey);
                Date bsedStrategyDate = this.getBsedStrategyDate(startDate, endDate, payDate, accInfo);
                Long calTaskPeriodId = MapUtils.getLong((Map)calTaskMap, (Object)"period");
                String periodStartDate = MapUtils.getString((Map)calTaskMap, (Object)"periodstartdate");
                String periodEndDate = MapUtils.getString((Map)calTaskMap, (Object)"periodenddate");
                if (accInfo.isOnlyFormulaUse()) {
                    if (SWCListUtils.isEmpty(tempAccObjList) || (accResultObj = this.matchAccResultObj(tempAccObjList, bsedStrategyDate, calTaskPeriodId)) == null) continue;
                    tempAccDetail = this.buildAccDetailsObj(calPerson, accInfo, existAccDetailsMap, accResultObj, calTaskMap, accDetailsIndexMap);
                    tempAccDetail.setOnlyFormulaUse(true);
                    tempAccDetailsMap.put(accInfo.getUniqueCode(), tempAccDetail);
                    continue;
                }
                if (tempAccObjList == null || tempAccObjList.isEmpty()) {
                    accResultList.add(this.buildAccResultObj(accInfo, itemValueMap, calPerson, accResultNumMap.get(accKey), MapUtils.getLong((Map)calTaskMap, (Object)"calCurrencyId"), bsedStrategyDate, calTaskPeriodId, periodStartDate, periodEndDate));
                    tempAccDetailsMap.put(accInfo.getUniqueCode(), this.buildAccDetailsObj(calPerson, accInfo, existAccDetailsMap, null, calTaskMap, accDetailsIndexMap));
                    continue;
                }
                accResultObj = this.matchAccResultObj(tempAccObjList, bsedStrategyDate, calTaskPeriodId);
                if (accResultObj == null) {
                    accResultList.add(this.buildAccResultObj(accInfo, itemValueMap, calPerson, accResultNumMap.get(accKey), MapUtils.getLong((Map)calTaskMap, (Object)"calCurrencyId"), bsedStrategyDate, calTaskPeriodId, periodStartDate, periodEndDate));
                }
                tempAccDetailsMap.put(accInfo.getUniqueCode(), this.buildAccDetailsObj(calPerson, accInfo, existAccDetailsMap, accResultObj, calTaskMap, accDetailsIndexMap));
            }
        }
        if ("afterTaxCal".equals(calType)) {
            this.handPreTaxAccDetailData(allAccDetailsMap, calPersonIdList, calTaskId, calParamInfo);
        }
        this.saveAccResultData(allAccDetailsMap, accResultList, recordId);
        logger.info("instanceAcc end,calTaskId = {},traceId = {}", (Object)calTaskId, (Object)this.traceId);
        return allAccDetailsMap;
    }

    private void handPreTaxAccDetailData(Map<Long, Map<String, AccDetailsVO>> allAccDetailsMap, List<Long> calPersonIdList, Long calTaskId, CalParamCacheInfo calParamInfo) {
        Map preTaxAccMap = calParamInfo.getPreTaxAccMap();
        if (preTaxAccMap == null || preTaxAccMap.size() == 0) {
            return;
        }
        logger.info("handPreTaxAccDetailData start,traceId = {}", (Object)this.traceId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("caltask.id", "=", (Object)calTaskId);
        filter.and("accresult.acc.id", "in", preTaxAccMap.keySet());
        String fields = "calpersonid,accresult.id,currency.id,index,initvalue,currentvalue,updatestatus,memberinfo,accresult.acc.id";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (result.size() == 0) {
            return;
        }
        Map tempMap = null;
        AccDetailsVO accDetails = null;
        AccInfo accInfo = null;
        for (DynamicObject accDetail : result) {
            accInfo = (AccInfo)preTaxAccMap.get(accDetail.getLong("accresult.acc.id"));
            if (accInfo == null) continue;
            tempMap = allAccDetailsMap.getOrDefault(accDetail.getLong("calpersonid"), new HashMap(16));
            accDetails = new AccDetailsVO();
            accDetails.setAccId(accInfo.getId());
            accDetails.setCalPersonId(accDetail.getLong("calpersonid"));
            accDetails.setCurrencyId(accDetail.getLong("currency.id"));
            accDetails.setAccInfo(accInfo);
            accDetails.setInitValue(accDetail.getBigDecimal("initvalue"));
            accDetails.setIndex(accDetail.getInt("index"));
            accDetails.setAccResultId(accDetail.getLong("accresult.id"));
            accDetails.setCurrentValue(accDetail.getBigDecimal("currentvalue"));
            tempMap.put(accInfo.getUniqueCode(), accDetails);
            allAccDetailsMap.put(accDetail.getLong("calpersonid"), tempMap);
        }
        logger.info("handPreTaxAccDetailData end,traceId = {}", (Object)this.traceId);
    }

    private QFilter getDateQFilter(Date startDate, Date endDate, Date payDate) {
        QFilter dateQFilter = null;
        dateQFilter = startDate.before(payDate) ? new QFilter("endDate", ">=", (Object)startDate) : new QFilter("endDate", ">=", (Object)payDate);
        if (endDate.after(payDate)) {
            dateQFilter.and("startdate", "<=", (Object)endDate);
        } else {
            dateQFilter.and("startdate", "<=", (Object)payDate);
        }
        return dateQFilter;
    }

    private void saveAccResultData(Map<Long, Map<String, AccDetailsVO>> allAccDetailsMap, List<AccResultVO> accResultList, Long recordId) throws KDBizException {
        if (SWCListUtils.isEmpty(accResultList) && !this.isOnlyCal) {
            return;
        }
        SWCDataServiceHelper accResultHelper = new SWCDataServiceHelper("hsas_accresult");
        DynamicObjectCollection data = this.getSaveAccResultList(allAccDetailsMap, accResultList, accResultHelper);
        try (TXHandle txHandle = TX.requiresNew();){
            if (!data.isEmpty()) {
                accResultHelper.save(data);
            }
            if (CalUtils.isTerminationCal(recordId)) {
                txHandle.markRollback();
            }
        }
    }

    private DynamicObjectCollection getSaveAccResultList(Map<Long, Map<String, AccDetailsVO>> allAccDetailsMap, List<AccResultVO> accResultList, SWCDataServiceHelper accResultHelper) {
        DynamicObjectCollection data = new DynamicObjectCollection();
        if (SWCListUtils.isEmpty(accResultList)) {
            return data;
        }
        long[] accResultArray = DB.genLongIds((String)"t_hsas_accresult", (int)accResultList.size());
        int length = accResultList.size();
        for (int index = 0; index < length; ++index) {
            AccResultVO accResult = accResultList.get(index);
            Map<String, AccDetailsVO> tempMap = allAccDetailsMap.get(accResult.getCalPersonId());
            AccDetailsVO tempDetails = tempMap.get(accResult.getUniqueCode());
            tempDetails.setAccResultId(accResultArray[index]);
            DynamicObject accResultObj = accResultHelper.generateEmptyDynamicObject();
            accResultObj.set("id", (Object)accResultArray[index]);
            accResultObj.set("personindexid", (Object)accResult.getPersonIndexId());
            accResultObj.set("employee", (Object)accResult.getEmployeeId());
            accResultObj.set("salaryfile", (Object)accResult.getSalaryFileId());
            accResultObj.set("acc", (Object)accResult.getAccId());
            accResultObj.set("instancenum", (Object)accResult.getInstanceNum());
            accResultObj.set("startdate", (Object)accResult.getStartDate());
            accResultObj.set("enddate", (Object)accResult.getEndDate());
            accResultObj.set("dimension1", (Object)accResult.getDimension1());
            accResultObj.set("dimension2", (Object)accResult.getDimension2());
            accResultObj.set("dimension3", (Object)accResult.getDimension3());
            accResultObj.set("dimension4", (Object)accResult.getDimension4());
            accResultObj.set("dimension5", (Object)accResult.getDimension5());
            accResultObj.set("currency", (Object)accResult.getCurrencyId());
            accResultObj.set("resultvalue", (Object)accResult.getResultValue());
            accResultObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            accResultObj.set("createtime", (Object)new Date());
            accResultObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            accResultObj.set("modifytime", (Object)new Date());
            accResultObj.set("isadjust", (Object)STRING_FALSE);
            accResultObj.set("calperiodid", (Object)accResult.getCalPeriodId());
            data.add((Object)accResultObj);
        }
        return data;
    }

    private AccDetailsVO buildAccDetailsObj(DynamicObject calPerson, AccInfo accInfo, Map<Long, DynamicObject> existAccDetailsMap, DynamicObject accResultObj, Map<String, Object> calTaskMap, Map<Long, Integer> accIndexMap) throws Exception {
        AccDetailsVO accDetails = new AccDetailsVO();
        Long targetCurId = MapUtils.getLong(calTaskMap, (Object)"calCurrencyId");
        Date exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
        Long exratetableId = MapUtils.getLong(calTaskMap, (Object)"exratetableId");
        accDetails.setAccId(accInfo.getId());
        accDetails.setCalPersonId(calPerson.getLong("id"));
        if (accInfo.getDataTypeId() == 1020L) {
            accDetails.setCurrencyId(targetCurId.longValue());
        } else {
            accDetails.setCurrencyId(0L);
        }
        accDetails.setAccInfo(accInfo);
        accDetails.setInitValue(BigDecimal.ZERO);
        accDetails.setIndex(1);
        accDetails.setCurrentValue(BigDecimal.ZERO);
        long accResultId = 0L;
        if (accResultObj != null) {
            accDetails.setAccResultId(accResultObj.getLong("id"));
            Integer index = accIndexMap.get(accResultObj.getLong("id"));
            if (index != null) {
                accDetails.setIndex(index + 1);
            }
            if (accInfo.getDataTypeId() == 1020L) {
                accDetails.setInitValue(this.dealAccResultValue(accResultObj.getBigDecimal("resultvalue"), accResultObj.getLong("currency.id"), targetCurId, exratedate, exratetableId));
            } else {
                accDetails.setInitValue(accResultObj.getBigDecimal("resultvalue"));
            }
            accResultId = accResultObj.getLong("id");
        }
        if (existAccDetailsMap == null) {
            return accDetails;
        }
        DynamicObject existAccDetailObj = existAccDetailsMap.get(accResultId);
        if (existAccDetailObj == null) {
            return accDetails;
        }
        String memberInfo = existAccDetailObj.getString("memberinfo");
        if (!SWCStringUtils.isEmpty((String)memberInfo)) {
            accDetails.setMemberInfo((Map)SerializationUtils.fromJsonString((String)memberInfo, Map.class));
        }
        if (SWCStringUtils.equals((String)existAccDetailObj.getString("updatestatus"), (String)STRING_TRUE)) {
            accDetails.setCurrentValue(existAccDetailObj.getBigDecimal("currentvalue"));
        }
        return accDetails;
    }

    private BigDecimal dealAccResultValue(BigDecimal resultValue, Long oriCurId, Long targetCurId, Date exratedate, Long exratetableId) {
        if (BigDecimal.ZERO.compareTo(resultValue) == 0 || targetCurId.equals(oriCurId)) {
            return resultValue;
        }
        String key = targetCurId + "@" + oriCurId;
        ExchangeRateInfo rateInfo = this.exrateCacheMap.get(key);
        if (rateInfo == null) {
            rateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)oriCurId, (Long)targetCurId, (Long)exratetableId, (Date)exratedate);
        }
        if (null == rateInfo) {
            logger.error("rateInfo null,targetCurId= {},orgCurId = {}", (Object)targetCurId, (Object)oriCurId);
            return resultValue;
        }
        this.exrateCacheMap.put(key, rateInfo);
        BigDecimal value = rateInfo.getQuoteType() != false ? resultValue.divide(rateInfo.getExchangeRate(), 18, 1) : resultValue.multiply(rateInfo.getExchangeRate());
        return value;
    }

    private AccResultVO buildAccResultObj(AccInfo accInfo, Map<String, Object> itemValueMap, DynamicObject calPerson, Integer instanceNum, Long currencyId, Date bsedStrategyDate, Long calTaskPeriodId, String periodStartDate, String periodEndDate) {
        AccResultVO accResult = new AccResultVO();
        accResult.setAccId(accInfo.getId());
        accResult.setUniqueCode(accInfo.getUniqueCode());
        accResult.setCalPersonId(calPerson.getLong("id"));
        accResult.setPersonIndexId(calPerson.getLong("personhrv.personindexid"));
        if (SWCStringUtils.equals((String)accInfo.getAccDimension(), (String)STRING_FALSE)) {
            accResult.setEmployeeId(0L);
            accResult.setSalaryFileId(0L);
        } else {
            accResult.setEmployeeId(calPerson.getLong("salaryfile.employee.id"));
            if (SWCStringUtils.equals((String)accInfo.getAccDimension(), (String)"2")) {
                accResult.setSalaryFileId(calPerson.getLong("salaryfile.id"));
            } else {
                accResult.setSalaryFileId(0L);
            }
        }
        if (null == instanceNum) {
            accResult.setInstanceNum(1);
        } else {
            accResult.setInstanceNum(instanceNum + 1);
        }
        if (accInfo.getDataTypeId() == 1020L) {
            accResult.setCurrencyId(currencyId.longValue());
        } else {
            accResult.setCurrencyId(0L);
        }
        accResult.setResultValue(BigDecimal.ZERO);
        this.setAccResultDimension(accResult, accInfo, itemValueMap);
        if (SWCStringUtils.equals((String)accInfo.getPeriodType(), (String)STRING_TRUE)) {
            this.setDateRangeByYear(accResult, accInfo, bsedStrategyDate);
        } else if (SWCStringUtils.equals((String)accInfo.getPeriodType(), (String)"5")) {
            this.setDateRangeByHalfYear(accResult, accInfo, bsedStrategyDate);
        } else if (SWCStringUtils.equals((String)accInfo.getPeriodType(), (String)"2")) {
            this.setDateRangeByQuarter(accResult, accInfo, bsedStrategyDate);
        } else if (SWCStringUtils.equals((String)accInfo.getPeriodType(), (String)"3")) {
            this.setDateRangeByMonth(accResult, accInfo, bsedStrategyDate);
        } else if (SWCStringUtils.equals((String)accInfo.getPeriodType(), (String)"4")) {
            this.setDateRangeByCustom(accResult, accInfo, itemValueMap);
        } else if (SWCStringUtils.equals((String)accInfo.getPeriodType(), (String)"6")) {
            this.setDateRangeByCalPeriod(accResult, accInfo, calTaskPeriodId, periodStartDate, periodEndDate);
        }
        return accResult;
    }

    private void setDateRangeByCalPeriod(AccResultVO accResult, AccInfo accInfo, Long calTaskPeriodId, String periodStartDate, String periodEndDate) {
        accResult.setCalPeriodId(calTaskPeriodId.longValue());
        if (SWCStringUtils.isNotEmpty((String)periodStartDate)) {
            try {
                accResult.setStartDate(SWCDateTimeUtils.parseDate((String)periodStartDate));
            }
            catch (ParseException e) {
                logger.info("setDateRangeByCalPeriod periodStartDate parser date error!");
            }
        }
        if (SWCStringUtils.isNotEmpty((String)periodEndDate)) {
            try {
                accResult.setEndDate(SWCDateTimeUtils.parseDate((String)periodEndDate));
            }
            catch (ParseException e) {
                logger.info("setDateRangeByCalPeriod periodEndDate parser date error!");
            }
        }
    }

    private void setDateRangeByYear(AccResultVO accResult, AccInfo accInfo, Date bsedStrategyDate) {
        Calendar bsedCal = Calendar.getInstance();
        bsedCal.setTime(bsedStrategyDate);
        Calendar cal = Calendar.getInstance();
        cal.set(1, bsedCal.get(1));
        cal.set(2, Integer.parseInt(accInfo.getStartMonth()) - 1);
        cal.set(5, accInfo.getStartDay());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        if (this.checkGtCalendar(cal, bsedCal)) {
            cal.add(1, -1);
        }
        accResult.setStartDate(cal.getTime());
        cal.add(1, 1);
        cal.add(6, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        accResult.setEndDate(cal.getTime());
    }

    private boolean checkGtCalendar(Calendar cal1, Calendar cal2) {
        if (cal1.get(1) > cal2.get(1)) {
            return true;
        }
        if (cal1.get(1) < cal2.get(1)) {
            return false;
        }
        if (cal1.get(2) > cal2.get(2)) {
            return true;
        }
        if (cal1.get(2) < cal2.get(2)) {
            return false;
        }
        return cal1.get(5) > cal2.get(5);
    }

    private void setDateRangeByQuarter(AccResultVO accResult, AccInfo accInfo, Date bsedStrategyDate) {
        Calendar bsedCal = Calendar.getInstance();
        bsedCal.setTime(bsedStrategyDate);
        Calendar cal = Calendar.getInstance();
        cal.set(1, bsedCal.get(1));
        cal.set(2, Integer.parseInt(accInfo.getStartMonth()) - 1);
        cal.set(5, accInfo.getStartDay());
        int bsedMonth = bsedCal.get(2);
        int calMonth = cal.get(2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        int num = (bsedMonth - calMonth) / 3;
        int addMonth = 0;
        if (num == 0) {
            if (bsedMonth < calMonth) {
                addMonth = -3;
            }
        } else {
            addMonth = num < 0 ? (num - 1) * 3 : num * 3;
        }
        cal.add(2, addMonth);
        if (this.checkGtCalendar(cal, bsedCal)) {
            cal.add(2, -3);
        }
        accResult.setStartDate(cal.getTime());
        cal.add(2, 3);
        cal.add(6, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        accResult.setEndDate(cal.getTime());
    }

    private void setDateRangeByHalfYear(AccResultVO accResult, AccInfo accInfo, Date bsedStrategyDate) {
        Calendar bsedCal = Calendar.getInstance();
        bsedCal.setTime(bsedStrategyDate);
        bsedCal.set(11, 0);
        bsedCal.set(12, 0);
        bsedCal.set(13, 0);
        bsedCal.set(14, 0);
        Calendar cal = Calendar.getInstance();
        cal.set(1, bsedCal.get(1));
        cal.set(2, Integer.parseInt(accInfo.getStartMonth()) - 1);
        cal.set(5, accInfo.getStartDay());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (cal.after(bsedCal)) {
            cal.add(2, -6);
        } else {
            cal.add(2, 6);
            if (bsedCal.before(cal)) {
                cal.add(2, -6);
            }
        }
        accResult.setStartDate(cal.getTime());
        cal.add(2, 6);
        cal.add(6, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        accResult.setEndDate(cal.getTime());
    }

    private void setDateRangeByMonth(AccResultVO accResult, AccInfo accInfo, Date bsedStrategyDate) {
        Calendar bsedCal = Calendar.getInstance();
        bsedCal.setTime(bsedStrategyDate);
        Calendar cal = Calendar.getInstance();
        cal.set(1, bsedCal.get(1));
        cal.set(2, bsedCal.get(2));
        cal.set(5, accInfo.getStartDay());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        if (this.checkGtCalendar(cal, bsedCal)) {
            cal.add(2, -1);
        }
        accResult.setStartDate(cal.getTime());
        cal.add(2, 1);
        cal.add(6, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        accResult.setEndDate(cal.getTime());
    }

    private void setDateRangeByCustom(AccResultVO accResult, AccInfo accInfo, Map<String, Object> itemValueMap) {
        Calendar cal = Calendar.getInstance();
        cal.set(2199, 11, 31, 23, 59, 59);
        accResult.setEndDate(cal.getTime());
        if (SWCStringUtils.equals((String)accInfo.getStartDateType(), (String)"2")) {
            if (itemValueMap == null) {
                accResult.setStartDate(new Date());
            } else {
                accResult.setStartDate((Date)itemValueMap.get(accInfo.getStartDateItemCode()));
            }
        } else {
            accResult.setStartDate(accInfo.getStartDate());
        }
    }

    private void setAccResultDimension(AccResultVO accResult, AccInfo accInfo, Map<String, Object> itemValueMap) {
        if (SWCListUtils.isEmpty((List)accInfo.getDimensionInfoList())) {
            return;
        }
        int index = 1;
        for (AccDimensionInfo info : accInfo.getDimensionInfoList()) {
            if (itemValueMap == null) {
                ++index;
                continue;
            }
            Object itemValueObj = itemValueMap.get(info.getFetchItemCode());
            if (itemValueObj == null) {
                ++index;
                continue;
            }
            String value = itemValueObj instanceof Date ? SWCDateTimeUtils.format((Date)((Date)itemValueObj), (String)"yyyy-MM-dd") : (itemValueObj instanceof Boolean ? (((Boolean)itemValueObj).booleanValue() ? STRING_TRUE : STRING_FALSE) : itemValueObj.toString());
            switch (index) {
                case 1: {
                    accResult.setDimension1(value);
                    break;
                }
                case 2: {
                    accResult.setDimension2(value);
                    break;
                }
                case 3: {
                    accResult.setDimension3(value);
                    break;
                }
                case 4: {
                    accResult.setDimension4(value);
                    break;
                }
                case 5: {
                    accResult.setDimension5(value);
                    break;
                }
            }
            ++index;
        }
    }

    private DynamicObject matchAccResultObj(List<DynamicObject> tempAccObjList, Date bsedStrategyDate, Long calTaskPeriodId) {
        DynamicObject resultObj = null;
        for (DynamicObject accResultObj : tempAccObjList) {
            if (bsedStrategyDate == null) {
                resultObj = accResultObj;
                break;
            }
            String periodType = accResultObj.getString("acc.periodtype");
            if (SWCStringUtils.equals((String)periodType, (String)"6")) {
                Long calPeriodId = accResultObj.getLong("calperiodid");
                if (calTaskPeriodId != null && calPeriodId.longValue() == calTaskPeriodId.longValue()) {
                    resultObj = accResultObj;
                    break;
                }
                return null;
            }
            if (bsedStrategyDate.before(accResultObj.getDate("startdate")) || bsedStrategyDate.after(accResultObj.getDate("endDate"))) continue;
            resultObj = accResultObj;
            break;
        }
        return resultObj;
    }

    private Date getBsedStrategyDate(Date startDate, Date endDate, Date payDate, AccInfo acc) {
        if (SWCStringUtils.equals((String)"4", (String)acc.getPeriodType())) {
            return null;
        }
        Date bsedStrategyDate = null;
        switch (acc.getBsedStrategy()) {
            case "1": {
                bsedStrategyDate = startDate;
                break;
            }
            case "2": {
                bsedStrategyDate = endDate;
                break;
            }
            case "3": {
                bsedStrategyDate = payDate;
                break;
            }
        }
        return bsedStrategyDate;
    }

    private String getAccDimensionKey(AccInfo acc, Map<String, Object> itemValueMap, DynamicObject calTable) {
        StringBuilder key = new StringBuilder();
        key.append(calTable.getLong("personhrv.personindexid"));
        if (SWCStringUtils.equals((String)acc.getAccDimension(), (String)STRING_FALSE)) {
            key.append(CONNECTOR).append(0L).append(CONNECTOR).append(0L);
        } else {
            key.append(CONNECTOR).append(calTable.getLong("salaryfile.employee.id"));
            if (SWCStringUtils.equals((String)acc.getAccDimension(), (String)"2")) {
                key.append(CONNECTOR).append(calTable.getLong("salaryfile.id"));
            } else {
                key.append(CONNECTOR).append(0L);
            }
        }
        key.append(CONNECTOR).append(acc.getId());
        if (SWCListUtils.isEmpty((List)acc.getDimensionInfoList())) {
            return key.toString();
        }
        for (AccDimensionInfo info : acc.getDimensionInfoList()) {
            Object valueObj;
            if (itemValueMap == null || (valueObj = itemValueMap.get(info.getFetchItemCode())) == null) continue;
            String itemValue = valueObj instanceof Date ? SWCDateTimeUtils.format((Date)((Date)valueObj), (String)"yyyy-MM-dd") : (valueObj instanceof Boolean ? (((Boolean)valueObj).booleanValue() ? STRING_TRUE : STRING_FALSE) : valueObj.toString());
            if (!SWCStringUtils.isNotEmpty((String)itemValue)) continue;
            key.append(CONNECTOR).append(itemValue);
        }
        return key.toString();
    }

    private Map<String, Integer> getAccResultNumMap(List<Long> accIdList, List<Long> personIndexIdList) {
        logger.info("getAccResultNumMap begin,traceId = {}", (Object)this.traceId);
        HashMap<String, Integer> accResultNumMap = new HashMap<String, Integer>(16);
        List batchAccIdList = SWCListUtils.split(accIdList, (int)500);
        for (List tempAccIdList : batchAccIdList) {
            String sqlBuilder = "SELECT FPERSONINDEXID,FEMPLOYEEID,FSALARYFILEID,FACCID,FDIMENSIONONE,FDIMENSIONTWO,FDIMENSIONTHREE,FDIMENSIONFOUR,FDIMENSIONFIVE,MAX(FINSTANCENUM) FINSTANCENUM  FROM T_HSAS_ACCRESULT  WHERE FPERSONINDEXID IN (" + this.listToString(personIndexIdList) + ')' + " AND   FACCID IN (" + this.getParamsByData(tempAccIdList) + ')' + " GROUP BY FPERSONINDEXID,FEMPLOYEEID,FSALARYFILEID,FACCID,FDIMENSIONONE,FDIMENSIONTWO,FDIMENSIONTHREE,FDIMENSIONFOUR,FDIMENSIONFIVE";
            Object[] params = new Object[tempAccIdList.size()];
            tempAccIdList.toArray(params);
            DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryAccResultMaxNumService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlBuilder, (Object[])params);
            Throwable throwable = null;
            try {
                while (dateSet.hasNext()) {
                    Row row = dateSet.next();
                    accResultNumMap.put(this.getAccResultKey(row), row.getInteger("FINSTANCENUM"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dateSet == null) continue;
                if (throwable != null) {
                    try {
                        dateSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dateSet.close();
            }
        }
        logger.info("getAccResultNumMap end,traceId = {}", (Object)this.traceId);
        return accResultNumMap;
    }

    private String getParamsByData(List<Long> paramList) {
        StringBuilder param = new StringBuilder();
        if (SWCListUtils.isEmpty(paramList)) {
            return param.append(' ').toString();
        }
        paramList.forEach(key -> param.append('?').append(','));
        return param.substring(0, param.length() - 1);
    }

    private String listToString(List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isEmpty(idList)) {
            return sb.append(0L).toString();
        }
        idList.forEach(id -> sb.append(id).append(','));
        return sb.substring(0, sb.length() - 1);
    }

    private String getAccResultKey(Row accResult) {
        StringBuilder key = new StringBuilder();
        key.append(accResult.getLong("FPERSONINDEXID")).append(CONNECTOR).append(accResult.getLong("FEMPLOYEEID")).append(CONNECTOR).append(accResult.getLong("FSALARYFILEID")).append(CONNECTOR).append(accResult.getLong("FACCID"));
        if (SWCStringUtils.isNotEmpty((String)accResult.getString("FDIMENSIONONE"))) {
            key.append(CONNECTOR).append(accResult.getString("FDIMENSIONONE"));
        }
        if (SWCStringUtils.isNotEmpty((String)accResult.getString("FDIMENSIONTWO"))) {
            key.append(CONNECTOR).append(accResult.getString("FDIMENSIONTWO"));
        }
        if (SWCStringUtils.isNotEmpty((String)accResult.getString("FDIMENSIONTHREE"))) {
            key.append(CONNECTOR).append(accResult.getString("FDIMENSIONTHREE"));
        }
        if (SWCStringUtils.isNotEmpty((String)accResult.getString("FDIMENSIONFOUR"))) {
            key.append(CONNECTOR).append(accResult.getString("FDIMENSIONFOUR"));
        }
        if (SWCStringUtils.isNotEmpty((String)accResult.getString("FDIMENSIONFIVE"))) {
            key.append(CONNECTOR).append(accResult.getString("FDIMENSIONFIVE"));
        }
        return key.toString();
    }

    private Map<Long, Integer> getAccDetailsIndexMap(List<Long> accResultIdList, Long calTaskId) {
        if (accResultIdList.size() == 0) {
            return new HashMap<Long, Integer>(0);
        }
        logger.info("getAccDetailsIndexMap begin,traceId = {}", (Object)this.traceId);
        HashMap<Long, Integer> accIndexMap = new HashMap<Long, Integer>(16);
        List batchAccResultIdList = SWCListUtils.split(accResultIdList, (int)30000);
        for (List tempAccResultIdList : batchAccResultIdList) {
            StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(" FACCRESULTID,MAX(FINDEX) FINDEX ").append(" FROM T_HSAS_ACCDETAILS ").append(" WHERE FACCRESULTID IN (").append(this.getParamsByData(tempAccResultIdList)).append(") ");
            sqlBuilder.append(" AND FCALTASKID != ").append(calTaskId);
            sqlBuilder.append("  GROUP BY FACCRESULTID");
            Object[] params = new Object[tempAccResultIdList.size()];
            tempAccResultIdList.toArray(params);
            DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryAccDetailMaxIndexService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlBuilder.toString(), (Object[])params);
            Throwable throwable = null;
            try {
                while (dateSet.hasNext()) {
                    Row row = dateSet.next();
                    accIndexMap.put(row.getLong("FACCRESULTID"), row.getInteger("FINDEX"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dateSet == null) continue;
                if (throwable != null) {
                    try {
                        dateSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dateSet.close();
            }
        }
        logger.info("getAccDetailsIndexMap end,traceId = {}", (Object)this.traceId);
        return accIndexMap;
    }

    private Map<Long, Map<Long, DynamicObject>> getAccDetailDataMap(List<Long> calPersonIdList, Long calTaskId) {
        logger.info("getAccDetailDataMap begin,calTaskId = {},traceId = {}", (Object)calTaskId, (Object)this.traceId);
        HashMap<Long, Map<Long, DynamicObject>> accDetailMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        SWCDataServiceHelper accDetailHelper = new SWCDataServiceHelper("hsas_accdetails");
        String fields = "calpersonid,accresult.id,updatestatus,currentvalue,memberinfo";
        QFilter qFilter = new QFilter("calpersonid", "in", calPersonIdList);
        qFilter.and("caltask", "=", (Object)calTaskId);
        DynamicObjectCollection accDetailList = accDetailHelper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> tempMap = null;
        for (DynamicObject obj : accDetailList) {
            tempMap = (HashMap<Long, DynamicObject>)accDetailMap.get(obj.getLong("calpersonid"));
            if (null == tempMap) {
                tempMap = new HashMap<Long, DynamicObject>(16);
                accDetailMap.put(obj.getLong("calpersonid"), tempMap);
            }
            tempMap.put(obj.getLong("accresult.id"), obj);
        }
        logger.info("getAccDetailDataMap end,calTaskId = {},traceId = {}", (Object)calTaskId, (Object)this.traceId);
        return accDetailMap;
    }

    private boolean checkAccIsCanUsedForFile(Set<Long> salaryItemIdList, List<AccMemberInfo> memberInfoList) {
        boolean isUsed = false;
        if (salaryItemIdList == null) {
            salaryItemIdList = new HashSet<Long>(0);
        }
        for (AccMemberInfo member : memberInfoList) {
            if (!member.isUsed() || !SWCStringUtils.equals((String)"2", (String)member.getMemberType()) && (!SWCStringUtils.equals((String)STRING_TRUE, (String)member.getMemberType()) || !salaryItemIdList.contains(member.getSalaryItemId()))) continue;
            isUsed = true;
            break;
        }
        return isUsed;
    }

    private Map<String, List<DynamicObject>> getExistAccResultMap(List<Long> personIndexIdList, List<Long> accIdList, List<Long> accResultIdList, QFilter dateQFilter) {
        logger.info("getExistAccResultMap begin,traceId = {}", (Object)this.traceId);
        DynamicObject[] accResultList = this.getAccResultData(personIndexIdList, accIdList, dateQFilter);
        LinkedHashMap accResultMap = Maps.newLinkedHashMapWithExpectedSize((int)accResultList.length);
        StringBuilder key = new StringBuilder();
        for (DynamicObject accResult : accResultList) {
            key.setLength(0);
            key.append(accResult.getLong("personindexid")).append(CONNECTOR).append(accResult.getLong("employee.id")).append(CONNECTOR).append(accResult.getLong("salaryfile.id")).append(CONNECTOR).append(accResult.getLong("acc.id"));
            if (SWCStringUtils.isNotEmpty((String)accResult.getString("dimension1"))) {
                key.append(CONNECTOR).append(accResult.getString("dimension1"));
            }
            if (SWCStringUtils.isNotEmpty((String)accResult.getString("dimension2"))) {
                key.append(CONNECTOR).append(accResult.getString("dimension2"));
            }
            if (SWCStringUtils.isNotEmpty((String)accResult.getString("dimension3"))) {
                key.append(CONNECTOR).append(accResult.getString("dimension3"));
            }
            if (SWCStringUtils.isNotEmpty((String)accResult.getString("dimension4"))) {
                key.append(CONNECTOR).append(accResult.getString("dimension4"));
            }
            if (SWCStringUtils.isNotEmpty((String)accResult.getString("dimension5"))) {
                key.append(CONNECTOR).append(accResult.getString("dimension5"));
            }
            List tempObjList = accResultMap.computeIfAbsent(key.toString(), value -> new ArrayList(10));
            tempObjList.add(accResult);
            accResultIdList.add(accResult.getLong("id"));
        }
        logger.info("getExistAccResultMap end,traceId = {}", (Object)this.traceId);
        return accResultMap;
    }

    private DynamicObject[] getAccResultData(List<Long> personIndexIdList, List<Long> accIdList, QFilter dateQFilter) {
        SWCDataServiceHelper accResultHelper = new SWCDataServiceHelper("hsas_accresult");
        String fields = "id,personindexid,employee.id,salaryfile.id,acc.id,acc.periodtype,calperiodid,instancenum,startdate,enddate,dimension1,dimension2,dimension3,dimension4,dimension5,currency.id,resultvalue";
        QFilter qFilter = new QFilter("personindexid", "in", personIndexIdList);
        qFilter.and("acc.id", "in", accIdList);
        qFilter.and(dateQFilter);
        return accResultHelper.queryOriginalArray(fields, new QFilter[]{qFilter});
    }
}

