/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.base.FormulaParse;
import kd.swc.hscs.business.cal.check.AccCheckService;
import kd.swc.hscs.business.cal.generateclass.FormulaAnalysis;
import kd.swc.hscs.business.cal.result.FormulaCalRecord;
import kd.swc.hscs.business.cal.service.CalculationService;
import kd.swc.hscs.business.cal.service.HandleParamsBeforeCalService;
import kd.swc.hscs.business.cal.tax.service.TaxDataPullService;
import kd.swc.hscs.business.cal.tax.service.TaxDataPushService;
import kd.swc.hscs.business.cal.utils.CalReportUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.cal.utils.SalaryCalMutexUtils;
import kd.swc.hscs.business.thread.CalculateThreadTask;
import kd.swc.hscs.common.enums.OperationTypeEnum;
import kd.swc.hscs.common.vo.BatchCalResultParamVO;
import kd.swc.hscs.common.vo.CalConvertVO;
import kd.swc.hscs.common.vo.CalOperationVO;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.CalRecordVO;

public class CalService {
    private static final Log log = LogFactory.getLog(CalService.class);
    private static final int DEFAULT_SIZE = 500;
    private String calTaskId;
    private String recordId;
    private String calBatchId;
    private boolean isSyncCal = false;
    private Map<Long, Map<String, Object>> responseMap;

    public CalService(String calTaskId, String recordId, String calBatchId) {
        this.calTaskId = calTaskId;
        this.recordId = recordId;
        this.calBatchId = calBatchId;
        this.isSyncCal = false;
        this.responseMap = new HashMap<Long, Map<String, Object>>();
    }

    public CalService(String calTaskId, String recordId, String calBatchId, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) {
        this.calTaskId = calTaskId;
        this.recordId = recordId;
        this.calBatchId = calBatchId;
        this.isSyncCal = isSyncCal;
        this.responseMap = responseMap;
    }

    public void cal(List<Long> calPersonIdList, String calType, boolean resultCheck, boolean isNeedCheckOrder) {
        log.info("begin cal,recordId = {},calBatchId = {},calType = {}", new Object[]{this.recordId, this.calBatchId, calType});
        if (CalUtils.isTerminationCal(Long.valueOf(this.recordId))) {
            return;
        }
        Date startDate = new Date();
        CalRequestHelper.updateCalRequest((Long)Long.valueOf(this.recordId), (String)CalRequestStatusEnum.DOING.getCode());
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", this.recordId));
        if (isNeedCheckOrder) {
            try {
                calPersonIdList = this.checkAndAddSalaryCalMutex(calPersonIdList, calType, appCache);
                if (calPersonIdList.isEmpty()) {
                    this.addCalOperation(calType, startDate);
                    return;
                }
                AccCheckService checkService = new AccCheckService(Long.parseLong(this.calTaskId), Long.parseLong(this.recordId));
                Map<Long, String> errorMap = checkService.checkAccForCal(calPersonIdList);
                calPersonIdList = calPersonIdList.stream().filter(id -> !errorMap.containsKey(id)).collect(Collectors.toList());
                this.handleCheckErrorData(errorMap, appCache, calType, null, false);
            }
            catch (Exception ex) {
                log.error("checkAccForCal error,msg=>", (Throwable)ex);
                this.handleException(calPersonIdList, calType, resultCheck, ex, FailureTypeEnum.CHECK_FAIL.getCode());
                this.addCalOperation(calType, startDate);
                return;
            }
        }
        if (calPersonIdList.isEmpty()) {
            this.addCalOperation(calType, startDate);
            return;
        }
        if (SWCStringUtils.equals((String)calType, (String)"taxCal") || SWCStringUtils.equals((String)calType, (String)"pullTax")) {
            this.stepCalByCalType(calPersonIdList, calType, resultCheck);
            return;
        }
        try {
            calPersonIdList = this.beforeCalCheckForTax(calPersonIdList, calType, appCache);
        }
        catch (Exception e) {
            log.error("beforeCalCheckForTax error,msg=>", (Throwable)e);
            this.handleException(calPersonIdList, calType, resultCheck, e, FailureTypeEnum.CHECK_FAIL.getCode());
            this.addCalOperation(calType, startDate);
            return;
        }
        if (calPersonIdList.isEmpty()) {
            this.addCalOperation(calType, startDate);
            return;
        }
        CalParamVO calParamVO = new CalParamVO();
        FormulaParse formulaParse = null;
        FormulaParse convertFormulaCal = null;
        try {
            String key = String.format("CALPARAM_%s_%s", this.recordId, calType);
            CalParamCacheInfo calParamInfo = (CalParamCacheInfo)appCache.get(key, CalParamCacheInfo.class);
            if (calParamInfo == null) {
                HandleParamsBeforeCalService handleParamsBeforeCalService = new HandleParamsBeforeCalService();
                calParamInfo = handleParamsBeforeCalService.handleParamsBeforCal(Long.valueOf(this.calTaskId), Long.valueOf(this.recordId), calType);
                appCache.put(key, (Object)calParamInfo);
            }
            calParamVO.setCalBatchId(this.calBatchId);
            calParamVO.setRecordId(this.recordId);
            calParamVO.setCalTaskId(this.calTaskId);
            calParamVO.setCalParamMap(calParamInfo);
            calParamVO.setAccMemberMap(calParamInfo.getAccMemberMap());
            calParamVO.setCalType(calType);
            calParamVO.setUniqueCodeMap(calParamInfo.getItemUniqueCodeMap());
            calParamVO.setResultCheck(resultCheck);
            formulaParse = CalService.createAndGetCalClass(calParamInfo);
            convertFormulaCal = CalService.createConvertCalClass(calParamInfo);
        }
        catch (Exception e) {
            log.error("create cal class error,calbatchId={},msg = {}", (Object)this.calBatchId, (Object)e.getMessage());
            log.error((Throwable)e);
            this.handleException(calPersonIdList, calType, resultCheck, e, FailureTypeEnum.ANALYSIS_FAIL.getCode());
            this.addCalOperation(calType, startDate);
            return;
        }
        this.addCalOperation(calType, startDate);
        if (this.isSyncCal) {
            this.syncSalaryCal(calPersonIdList, calParamVO, formulaParse, convertFormulaCal);
        } else {
            this.asyncSalaryCal(calPersonIdList, calType, resultCheck, calParamVO, formulaParse, convertFormulaCal);
        }
        log.info("end cal,recordId = {},calBatchId = {},calType = {}", new Object[]{this.recordId, this.calBatchId, calType});
    }

    private void syncSalaryCal(List<Long> calPersonIdList, CalParamVO calParamVO, FormulaParse formulaParse, FormulaParse convertFormulaCal) {
        CalculationService calculationService = new CalculationService(calPersonIdList, formulaParse, calParamVO, convertFormulaCal, this.isSyncCal, this.responseMap);
        calculationService.calculate();
    }

    private void asyncSalaryCal(List<Long> calPersonIdList, String calType, boolean resultCheck, CalParamVO calParamVO, FormulaParse formulaParse, FormulaParse convertFormulaCal) {
        try {
            log.info("invoke CalculateThreadTask start");
            List splitList = SWCListUtils.split(calPersonIdList, (int)this.getBatchCount());
            ArrayList<CalculateThreadTask> taskList = new ArrayList<CalculateThreadTask>(splitList.size());
            ConcurrentHashMap<String, FormulaParse> threadClassMap = new ConcurrentHashMap<String, FormulaParse>(10);
            for (List list : splitList) {
                CalculateThreadTask task = new CalculateThreadTask(list, formulaParse, threadClassMap, calParamVO, RequestContext.get(), convertFormulaCal);
                taskList.add(task);
            }
            SWCThreadPoolFactory.getFormulaCalThreadpool().invokeAll(taskList);
            log.info("invoke CalculateThreadTask end");
        }
        catch (Exception e) {
            log.error("submit cal task error,calBatchId= {},msg = {}", (Object)this.calBatchId, (Object)e.getMessage());
            log.error((Throwable)e);
            this.handleException(calPersonIdList, calType, resultCheck, e, FailureTypeEnum.CAL_FAIL.getCode());
        }
    }

    private int getBatchCount() {
        Map paramDataMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"calbatchparam");
        if (paramDataMap == null || paramDataMap.size() == 0) {
            return 500;
        }
        String threadDealCount = (String)paramDataMap.get("threadDealCount");
        if (SWCStringUtils.isEmpty((String)threadDealCount)) {
            return 500;
        }
        return new BigDecimal(threadDealCount).intValue();
    }

    private void addCalOperation(String calType, Date startDate) {
        CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), calType, 0, 0);
        CalUtils.addCalOperation(Long.parseLong(this.recordId), Long.parseLong(this.calBatchId), OperationTypeEnum.ANALYSIS.getCode(), startDate, operationVO);
    }

    private void handleException(List<Long> calPersonIdList, String calType, boolean resultCheck, Exception ex, String failureType) {
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", this.calBatchId);
        ISWCAppCache resultAppCache = SWCAppCache.get((String)resultKey);
        String errorElement = CalReportUtils.getErrorElement(failureType, null);
        List<CalRecordVO> calRecordList = CalUtils.getCalRecordList(calPersonIdList, ex.getMessage(), failureType, errorElement);
        BatchCalResultParamVO batchResultVO = new BatchCalResultParamVO();
        batchResultVO.setCalRecordList(calRecordList);
        resultAppCache.put("result_cache_key", (Object)SerializationUtils.toJsonString((Object)batchResultVO));
        if (this.isSyncCal) {
            FormulaCalRecord formulaCalRecord = new FormulaCalRecord(Long.valueOf(this.calTaskId), Long.valueOf(this.recordId), Long.valueOf(this.calBatchId), this.isSyncCal, this.responseMap);
            formulaCalRecord.saveCalResultData(resultKey, calType, false, calPersonIdList);
        } else {
            CalUtils.sendSaveMessage(this.calBatchId, this.calTaskId, this.recordId, resultKey, calType, resultCheck, calPersonIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCheckErrorData(Map<Long, String> errorMap, ISWCAppCache appCache, String calType, DynamicObject[] calPersonArray, boolean isCalMutexFlag) {
        if (errorMap.size() == 0) {
            return;
        }
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.recordId));
        ArrayList<Long> finishedIdList = new ArrayList<Long>(10);
        DynamicObject[] calDetailArray = this.getUpdateCalDetails(errorMap, finishedIdList);
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(errorMap.size());
        if (calPersonArray == null) {
            Map oldCalStatusMap = (Map)appCache.get("oldCalStatusMap", Map.class);
            calPersonArray = this.getUpdateCalPerson(errorMap.keySet(), oldCalStatusMap, personIndexIdList, finishedIdList);
        } else {
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(10);
            for (DynamicObject obj : calPersonArray) {
                if (finishedIdList.contains(obj.getLong("id"))) continue;
                tempList.add(obj);
                personIndexIdList.add(obj.getLong("personhrv.personindexid"));
            }
            calPersonArray = new DynamicObject[tempList.size()];
            tempList.toArray(calPersonArray);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        try (TXHandle txHandle = TX.requiresNew();){
            int failCount;
            boolean isFinish;
            helper.update(calDetailArray);
            helper.setEntityName("hsas_calperson");
            if (calPersonArray.length > 0) {
                helper.update(calPersonArray);
            }
            if (!isCalMutexFlag) {
                CalUtils.deleteSalaryCalMutexData(personIndexIdList, Long.parseLong(this.calTaskId));
            }
            if (isFinish = CalUtils.updateSaveProcess(0, failCount = errorMap.size() - finishedIdList.size(), calProgressAppCache, calType, Long.parseLong(this.calTaskId), Long.parseLong(this.recordId))) {
                CalUtils.releaseCalCacheData(Long.parseLong(this.recordId));
                PayrollTaskHelper.updateCalPayRollTaskStatus((Long)Long.parseLong(this.calTaskId));
            }
            if (CalUtils.isTerminationCal(Long.valueOf(this.recordId))) {
                txHandle.markRollback();
                return;
            }
        }
    }

    private DynamicObject[] getUpdateCalPerson(Set<Long> calPersonIdSet, Map<String, String> oldCalStatusMap, List<Long> personIndexIdList, List<Long> finishedIdList) {
        DynamicObject[] calPersonArray;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)Long.valueOf(this.calTaskId));
        qFilter.and("id", "in", calPersonIdSet);
        for (DynamicObject calPerson : calPersonArray = helper.query("id,calstatus,personhrv.personindexid", new QFilter[]{qFilter})) {
            if (finishedIdList.contains(calPerson.getLong("id"))) continue;
            calPerson.set("calstatus", (Object)oldCalStatusMap.get(String.valueOf(calPerson.getLong("id"))));
            personIndexIdList.add(calPerson.getLong("personhrv.personindexid"));
        }
        return calPersonArray;
    }

    private DynamicObject[] getUpdateCalDetails(Map<Long, String> errorMap, List<Long> finishedIdList) {
        SWCDataServiceHelper calDetailHelper = new SWCDataServiceHelper("hsas_caldetail");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)Long.valueOf(this.calTaskId));
        qFilter.and("record.id", "=", (Object)Long.valueOf(this.recordId));
        qFilter.and("batch.id", "=", (Object)Long.valueOf(this.calBatchId));
        qFilter.and("calpersonid", "in", errorMap.keySet());
        DynamicObject[] calDetails = calDetailHelper.query("id,failtype,calpersonid,failmsg,calstatus,modifytime", new QFilter[]{qFilter});
        Map<Long, DynamicObject> calDetailMap = Arrays.asList(calDetails).stream().collect(Collectors.toMap(obj -> obj.getLong("calpersonid"), obj -> obj));
        DynamicObject calDetail = null;
        Map<String, Object> tempMap = null;
        for (Map.Entry<Long, String> entry : errorMap.entrySet()) {
            calDetail = calDetailMap.get(entry.getKey());
            if (null == calDetail) continue;
            if (!CalStatusEnum.CALING.getCode().equals(calDetail.getString("calstatus"))) {
                finishedIdList.add(entry.getKey());
                continue;
            }
            calDetail.set("failtype", (Object)FailureTypeEnum.CHECK_FAIL.getCode());
            calDetail.set("failmsg", (Object)entry.getValue());
            calDetail.set("modifytime", (Object)new Date());
            calDetail.set("calstatus", (Object)CalStatusEnum.FAIL.getCode());
            if (!this.isSyncCal) continue;
            tempMap = this.responseMap.get(entry.getKey());
            if (tempMap == null) {
                tempMap = new HashMap<String, Object>(5);
                tempMap.put("calPersonId", entry.getKey());
                tempMap.put("itemList", null);
                tempMap.put("status", 400);
                this.responseMap.put(entry.getKey(), tempMap);
            }
            tempMap.put("success", false);
            tempMap.put("message", entry.getValue());
            if (tempMap.get("itemList") == null) continue;
            tempMap.put("status", 100);
        }
        DynamicObject[] calDetailArray = new DynamicObject[calDetailMap.size()];
        calDetailMap.values().toArray(calDetailArray);
        return calDetailArray;
    }

    private void stepCalByCalType(List<Long> calPersonIdList, String calType, boolean resultCheck) {
        if (SWCStringUtils.equals((String)calType, (String)"taxCal")) {
            TaxDataPushService pushService = new TaxDataPushService(Long.parseLong(this.calTaskId), Long.parseLong(this.recordId), Long.parseLong(this.calBatchId));
            pushService.pushTax(calPersonIdList, resultCheck);
        } else if (SWCStringUtils.equals((String)calType, (String)"pullTax")) {
            TaxDataPullService pullService = new TaxDataPullService(Long.parseLong(this.calTaskId), Long.parseLong(this.recordId), Long.parseLong(this.calBatchId));
            pullService.pullTaxData(calPersonIdList, resultCheck);
        }
    }

    public static FormulaParse createAndGetCalClass(CalParamCacheInfo calParamInfo) throws Exception {
        FormulaParse formulaParse = FormulaAnalysis.getFormulaExcuteInstance(calParamInfo.getFormulaList(), calParamInfo.getFcMap());
        formulaParse.setCalBlock(SWCStringUtils.equals((String)calParamInfo.getCalType(), (String)"afterTaxCal") ? "1" : "0");
        formulaParse.setDmMap(calParamInfo.getDmMap());
        calParamInfo.setFcMap(null);
        calParamInfo.setFormulaList(null);
        return formulaParse;
    }

    public static FormulaParse createConvertCalClass(CalParamCacheInfo calParamInfo) throws Exception {
        CalConvertVO calConvert = calParamInfo.getCalConvert();
        if (!"1".equals(calParamInfo.getProrationCal()) || calConvert == null) {
            return null;
        }
        FormulaParse convertFormulaCal = FormulaAnalysis.makeConvertCalClassAndInstance(calConvert.getFormulaList(), calConvert.getFcMap());
        convertFormulaCal.setCalBlock(SWCStringUtils.equals((String)calParamInfo.getCalType(), (String)"afterTaxCal") ? "1" : "0");
        convertFormulaCal.setDmMap(calParamInfo.getDmMap());
        calConvert.setFormulaList(null);
        calConvert.setFcMap(null);
        return convertFormulaCal;
    }

    private List<Long> beforeCalCheckForTax(List<Long> calPersonIdList, String calType, ISWCAppCache appCache) throws Exception {
        log.info("beforeCalCheckForTax begin,calbatchId={}", (Object)this.calBatchId);
        if ("afterTaxCal".equals(calType)) {
            return calPersonIdList;
        }
        if (!TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)Long.valueOf(this.calTaskId)).booleanValue()) {
            return calPersonIdList;
        }
        DynamicObject[] calPersonArray = this.getCalPersonData(calPersonIdList);
        if (calPersonArray == null || calPersonArray.length == 0) {
            return calPersonIdList;
        }
        Map<Long, DynamicObject> calPersonMap = Arrays.asList(calPersonArray).stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        TaxDataPushService pushService = new TaxDataPushService(Long.parseLong(this.calTaskId), Long.parseLong(this.recordId), Long.parseLong(this.calBatchId));
        Map<String, Object> pushParamMap = pushService.getMethodParamFromCache(Long.parseLong(this.calTaskId), Long.parseLong(this.recordId));
        String country = (String)pushParamMap.get("country");
        String payDateStr = (String)pushParamMap.get("payDate");
        Date payDate = SWCDateTimeUtils.parseDate((String)payDateStr, (String)"yyyy-MM-dd");
        HashMap<Long, String> errorDataMap = new HashMap<Long, String>(16);
        DynamicObjectCollection calPersonList = new DynamicObjectCollection();
        Map<Long, Map<String, Long>> salaryFileRelMap = pushService.getSalaryTaxFileRelMap(payDate, calPersonMap, Long.valueOf(country), errorDataMap, calPersonList);
        if (salaryFileRelMap.size() == 0) {
            this.handleCheckErrorData(errorDataMap, appCache, calType, this.getNoCHeckPassCalPersonArray(calPersonList, appCache), false);
            calPersonIdList.removeAll(errorDataMap.keySet());
            return calPersonIdList;
        }
        Map<String, Object> pushTaxRequest = this.getPushTaxRequest(calPersonMap, salaryFileRelMap, pushParamMap, country);
        Map response = null;
        CalUtils.printLog("beforeCalCheckForTax request==>", pushTaxRequest);
        try {
            response = (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"calculate", (Object[])new Object[]{pushTaxRequest});
        }
        catch (Exception e) {
            log.error("beforeCalCheckForTax fail", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u8ba1\u7b97\u63a5\u53e3\u5931\u8d25\u3002", (String)"TaxDataPushService_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            salaryFileRelMap.keySet().forEach(obj -> errorDataMap.put((Long)obj, msg));
            salaryFileRelMap.keySet().forEach(obj -> calPersonList.add(calPersonMap.get(obj)));
            this.handleCheckErrorData(errorDataMap, appCache, calType, this.getNoCHeckPassCalPersonArray(calPersonList, appCache), false);
            calPersonIdList.removeAll(errorDataMap.keySet());
            return calPersonIdList;
        }
        CalUtils.printLog("beforeCalCheckForTax response==>", response);
        if (!((Boolean)response.get("success")).booleanValue()) {
            log.info("invokeTaxCal response fail");
            String message = (String)response.get("message");
            salaryFileRelMap.keySet().forEach(obj -> errorDataMap.put((Long)obj, message));
            salaryFileRelMap.keySet().forEach(obj -> calPersonList.add(calPersonMap.get(obj)));
            this.handleCheckErrorData(errorDataMap, appCache, calType, this.getNoCHeckPassCalPersonArray(calPersonList, appCache), false);
            calPersonIdList.removeAll(errorDataMap.keySet());
            return calPersonIdList;
        }
        this.handleResponseData((List)response.get("data"), calPersonMap, errorDataMap, calPersonList);
        this.handleCheckErrorData(errorDataMap, appCache, calType, this.getNoCHeckPassCalPersonArray(calPersonList, appCache), false);
        calPersonIdList.removeAll(errorDataMap.keySet());
        log.info("beforeCalCheckForTax end,calbatchId={}", (Object)this.calBatchId);
        return calPersonIdList;
    }

    private DynamicObject[] getNoCHeckPassCalPersonArray(DynamicObjectCollection calPersonList, ISWCAppCache appCache) {
        if (calPersonList.size() == 0) {
            return new DynamicObject[0];
        }
        Map oldCalStatusMap = (Map)appCache.get("oldCalStatusMap", Map.class);
        for (DynamicObject calPerson : calPersonList) {
            calPerson.set("calstatus", oldCalStatusMap.get(String.valueOf(calPerson.getLong("id"))));
        }
        Object[] calPersonArray = new DynamicObject[calPersonList.size()];
        return (DynamicObject[])calPersonList.toArray(calPersonArray);
    }

    public void handleResponseData(List<Map<String, Object>> data, Map<Long, DynamicObject> calPersonMap, Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList) {
        DynamicObject calPerson = null;
        String calPersonId = null;
        Integer status = null;
        for (Map<String, Object> dataMap : data) {
            calPersonId = (String)dataMap.get("dataKey");
            calPerson = calPersonMap.get(Long.valueOf(calPersonId));
            status = (Integer)dataMap.get("status");
            if (status < 400) continue;
            errorDataMap.put(Long.valueOf(calPersonId), (String)dataMap.get("message"));
            calPersonList.add((Object)calPerson);
        }
    }

    private Map<String, Object> getPushTaxRequest(Map<Long, DynamicObject> calPersonMap, Map<Long, Map<String, Long>> salaryFileRelMap, Map<String, Object> pushParamMap, String country) {
        HashMap<String, Object> pushTaxRequest = new HashMap<String, Object>(17);
        ArrayList dataList = new ArrayList(calPersonMap.size());
        HashMap<String, String> data = null;
        DynamicObject calPerson = null;
        Map<String, Long> taxFileInfoMap = null;
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            data = new HashMap<String, String>(16);
            calPerson = entry.getValue();
            taxFileInfoMap = salaryFileRelMap.get(calPerson.getLong("salaryfile.id"));
            if (taxFileInfoMap == null) continue;
            data.put("srcDataKey", String.valueOf(entry.getKey()));
            data.put("taxFile", String.valueOf(taxFileInfoMap.get("taxfile")));
            data.put("taxUnit", String.valueOf(taxFileInfoMap.get("taxunit")));
            data.put("salaryFileNumber", calPerson.getString("filenumber"));
            data.put("salaryPersonNumber", calPerson.getString("filenumber"));
            data.put("salaryPersonName", calPerson.getString("name"));
            dataList.add(data);
        }
        pushTaxRequest.put("srcType", "1");
        pushTaxRequest.put("calTaskNumber", pushParamMap.get("calTaskNumber"));
        pushTaxRequest.put("calTaskName", pushParamMap.get("calTaskName"));
        pushTaxRequest.put("belongStartDate", pushParamMap.get("startDate"));
        pushTaxRequest.put("belongEndDate", pushParamMap.get("endDate"));
        pushTaxRequest.put("payDate", pushParamMap.get("payDate"));
        pushTaxRequest.put("country", country);
        pushTaxRequest.put("currency", pushParamMap.get("currency"));
        pushTaxRequest.put("operator", RequestContext.get().getCurrUserId());
        pushTaxRequest.put("langCode", Lang.get().getLangTag());
        pushTaxRequest.put("operateKey", String.valueOf(this.recordId));
        pushTaxRequest.put("validate", Boolean.TRUE);
        pushTaxRequest.put("data", dataList);
        return pushTaxRequest;
    }

    private DynamicObject[] getCalPersonData(List<Long> calPersonIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        filter.and("taxstatus", "!=", (Object)TaxStateEnum.UNPUSH.getCode());
        return calPersonHelper.query("id,calstatus,empnumber,name,filenumber,taxstatus,salaryfile.id,personhrv.personindexid", new QFilter[]{filter});
    }

    public List<Long> checkAndAddSalaryCalMutex(List<Long> calPersonIdList, String calType, ISWCAppCache appCache) {
        log.info("addSalaryCalMutex start");
        DynamicObject[] calPersonArr = this.getCalPersonDataList(calPersonIdList);
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        Map<Long, DynamicObject> personIndexMap = SalaryCalMutexUtils.checkRepeatAndBuildMap(calPersonArr, errorMap, "1");
        ArrayList<DynamicObject> existDataList = new ArrayList<DynamicObject>(10);
        SalaryCalMutexUtils.checkPersonHrIsCaling(personIndexMap, errorMap, "1", Long.parseLong(this.calTaskId), existDataList);
        if (personIndexMap.size() == 0 && existDataList.size() == 0) {
            this.handleCheckErrorData(errorMap, appCache, calType, null, true);
            return new ArrayList<Long>(0);
        }
        SalaryCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorMap, "1", Long.parseLong(this.calTaskId), existDataList);
        List<Long> idList = personIndexMap.values().stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        idList.addAll(existDataList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList()));
        this.handleCheckErrorData(errorMap, appCache, calType, null, true);
        log.info("addSalaryCalMutex end");
        return idList;
    }

    private DynamicObject[] getCalPersonDataList(List<Long> calPersonIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        String fields = "id,salaryfile.id,personhrv.personindexid,caltask.number,caltask.name,employee.id";
        return calPersonHelper.queryOriginalArray(fields, new QFilter[]{filter});
    }
}

