/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.service;

import java.io.IOException;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalDataTypeEnum;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.enums.ConditionValueTypeEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.fetchdata.helper.DataReaderCalHelper;
import kd.swc.hscs.business.cal.helper.HandleCalParamsHelper;
import kd.swc.hscs.business.cal.service.AccService;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalResultItem;
import kd.swc.hscs.common.vo.ItemInfo;
import kd.swc.hscs.common.vo.SalaryItemVO;
import kd.swc.hscs.common.vo.acc.AccInfo;
import kd.swc.hscs.common.vo.acc.AccMemberInfo;
import kd.swc.hscs.common.vo.fetch.CalFetchConfigInfo;
import kd.swc.hscs.common.vo.fetch.CalResultMatchItemInfo;
import kd.swc.hscs.common.vo.fetch.FetchConfigFilterInfo;
import kd.swc.hscs.common.vo.fetch.FetchFieldInfo;
import kd.swc.hscs.common.vo.fetch.FetchSortedInfo;
import kd.swc.hscs.common.vo.fetch.FilterEntryInfo;

public class HandleParamsBeforeCalService {
    private static final Log log = LogFactory.getLog(HandleParamsBeforeCalService.class);

    public CalParamCacheInfo handleParamsBeforCal(Long calTaskId, Long recordId, String calType) throws Exception {
        log.info("handleParamsBeforCal  start, calTaskId = {},recordId = {},calType={}", new Object[]{calTaskId, recordId, calType});
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", recordId));
        String calParamCacheKey = String.format(Locale.ROOT, "CALPARAM_%s_%s", recordId, calType);
        CalParamCacheInfo calParamInfo = (CalParamCacheInfo)appCache.get(calParamCacheKey, CalParamCacheInfo.class);
        if (calParamInfo != null) {
            return calParamInfo;
        }
        calParamInfo = new CalParamCacheInfo();
        calParamInfo.setCalType(calType);
        DynamicObject calTaskInfo = HandleParamsBeforeCalService.getCalTaskInfo(calTaskId);
        this.handleCalPayRollTask(calTaskInfo, calParamInfo);
        String calVersionNo = (String)appCache.get("calversionno", String.class);
        if (SWCStringUtils.isEmpty((String)calVersionNo)) {
            calVersionNo = calTaskInfo.getString("calversionno");
        }
        HandleCalParamsHelper.dealCalRuleDataAndCacheCalParam(calParamInfo, calTaskInfo.getLong("calrulev.id"), calVersionNo, calTaskInfo.getLong("country.id"), calTaskInfo.getLong("org.id"));
        int amtPrecision = calTaskInfo.getInt("payrollgroupv.currency.amtprecision");
        List<Long> salaryItemIdList = this.cacheSalaryItemRelationMap(calParamInfo, amtPrecision);
        List<Long> bizItemIdList = this.handleBsItem(calParamInfo);
        this.handleSpItem(calParamInfo);
        this.matchAccumulator(calTaskInfo, salaryItemIdList, bizItemIdList, calParamInfo, calType);
        this.handleAccumulator(calParamInfo);
        this.handleFTItemData(calParamInfo);
        this.setBizDataUsageCfg(calParamInfo);
        DataReaderCalHelper dataReaderCalHelper = new DataReaderCalHelper();
        DynamicObject schemeAfterCalObj = dataReaderCalHelper.getSceneSchemeAfterCalObj(calTaskInfo.getLong("payrollscenev.id"));
        if (schemeAfterCalObj != null) {
            calParamInfo.setNoCountBizData(schemeAfterCalObj.getBoolean("nocountbizdata"));
            calParamInfo.setNoCountAtt(schemeAfterCalObj.getBoolean("nocountatt"));
        } else {
            calParamInfo.setNoCountBizData(false);
            calParamInfo.setNoCountAtt(false);
        }
        appCache.put(calParamCacheKey, (Object)calParamInfo);
        log.info("handleParamsBeforCal end, calTaskId = {},recordId = {},calType = {}", new Object[]{calTaskId, recordId, calType});
        return calParamInfo;
    }

    private void setBizDataUsageCfg(CalParamCacheInfo calParamInfo) {
        Map paramDataMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"bizdatausage");
        if (paramDataMap == null || paramDataMap.size() == 0) {
            calParamInfo.setRecordBizData(false);
            calParamInfo.setRecordAttBizData(false);
            return;
        }
        Boolean isRecordAttbizdata = (Boolean)paramDataMap.get("isrecordattbizdata");
        if (isRecordAttbizdata == null) {
            calParamInfo.setRecordAttBizData(false);
        } else {
            calParamInfo.setRecordAttBizData(isRecordAttbizdata.booleanValue());
        }
        Boolean isRecordBizData = (Boolean)paramDataMap.get("isrecordbizdata");
        if (isRecordBizData == null) {
            calParamInfo.setRecordBizData(false);
        } else {
            calParamInfo.setRecordBizData(isRecordBizData.booleanValue());
        }
    }

    private void handleAccumulator(CalParamCacheInfo calParamInfo) {
        log.info("handleAccumulator start");
        if (SWCListUtils.isEmpty((List)calParamInfo.getAccUniqueCodeList())) {
            return;
        }
        List<String> accUniqueCodeList = this.filterAccData(calParamInfo);
        if (SWCListUtils.isEmpty(accUniqueCodeList)) {
            return;
        }
        DynamicObject[] accData = this.getAccInfoDataByUniqueCode(accUniqueCodeList);
        if (accData == null || accData.length == 0) {
            return;
        }
        List fetchItemCodeList = calParamInfo.getFetchItemCodeList();
        ArrayList<AccInfo> accList = new ArrayList<AccInfo>(10);
        AccInfo accInfo = null;
        ArrayList accMemberList = null;
        for (DynamicObject obj : accData) {
            accMemberList = new ArrayList(10);
            accInfo = AccService.getAccInfoObj(obj);
            accInfo.setOnlyFormulaUse(true);
            if (SWCStringUtils.isNotEmpty((String)accInfo.getStartDateItemCode()) && !fetchItemCodeList.contains(accInfo.getStartDateItemCode())) {
                fetchItemCodeList.add(accInfo.getStartDateItemCode());
            }
            AccService.setAccDimensionInfoList(accInfo, obj, fetchItemCodeList);
            accInfo.setMemberInfoList(accMemberList);
            accList.add(accInfo);
        }
        ArrayList<AccInfo> existList = calParamInfo.getAccInfoList();
        if (existList != null) {
            existList.addAll(accList);
        } else {
            existList = accList;
        }
        calParamInfo.setAccInfoList(existList);
        calParamInfo.setFetchItemCodeList(fetchItemCodeList);
        log.info("handleAccumulator end");
    }

    private DynamicObject[] getAccInfoDataByUniqueCode(List<String> accUniqueCodeList) {
        SWCDataServiceHelper accHelper = new SWCDataServiceHelper("hsas_accumulator");
        String fields = "id,updatestrategy,periodtype,startdatetype,startdate,uniquecode,datatype,dataprecision,dataround,startdateitem,startmonth,startday,bsedstrategy,accdimension,accdimitementry.dimitemtype,accdimitementry.fetchitem,accmemberentry.membertype,accmemberentry.salaryitem,accmemberentry.bizitem,accmemberentry.accmemstartdate,accmemberentry.accmemenddate,accmemberentry.operator,accmemberentry.accpercenttype,accmemberentry.percentfixval";
        QFilter filter = new QFilter("uniquecode", "in", accUniqueCodeList);
        return accHelper.query(fields, new QFilter[]{filter});
    }

    private List<String> filterAccData(CalParamCacheInfo calParamInfo) {
        HashSet matchAccInfoSet = new HashSet(16);
        if (calParamInfo.getPreTaxAccMap() != null) {
            matchAccInfoSet.addAll(calParamInfo.getPreTaxAccMap().values().stream().map(AccInfo::getUniqueCode).collect(Collectors.toSet()));
        }
        if (calParamInfo.getAccInfoList() != null) {
            matchAccInfoSet.addAll(calParamInfo.getAccInfoList().stream().map(AccInfo::getUniqueCode).collect(Collectors.toSet()));
        }
        return calParamInfo.getAccUniqueCodeList().stream().filter(obj -> !matchAccInfoSet.contains(obj)).collect(Collectors.toList());
    }

    private void handleCalPayRollTask(DynamicObject calTaskInfo, CalParamCacheInfo calParamInfo) {
        HashMap<String, Object> calTaskMap = new HashMap<String, Object>(16);
        calTaskMap.put("number", calTaskInfo.get("number"));
        calTaskMap.put("periodtype", calTaskInfo.get("periodtype.id"));
        calTaskMap.put("period", calTaskInfo.get("period.id"));
        calTaskMap.put("periodstartdate", SWCDateTimeUtils.format((Date)calTaskInfo.getDate("period.startdate"), (String)"yyyy-MM-dd"));
        calTaskMap.put("periodenddate", SWCDateTimeUtils.format((Date)calTaskInfo.getDate("period.enddate"), (String)"yyyy-MM-dd"));
        calTaskMap.put("payrollgroupId", calTaskInfo.get("payrollgroup.id"));
        calTaskMap.put("payrollgroupVId", calTaskInfo.get("payrollgroupv.id"));
        calTaskMap.put("calCurrencyId", calTaskInfo.getLong("payrollgroupv.currency.id"));
        calTaskMap.put("exratetableId", calTaskInfo.getLong("payrollgroupv.exratetable.id"));
        calTaskMap.put("exratedate", SWCDateTimeUtils.format((Date)calTaskInfo.getDate("exratedate"), (String)"yyyy-MM-dd"));
        calTaskMap.put("startdate", SWCDateTimeUtils.format((Date)calTaskInfo.getDate("startdate"), (String)"yyyy-MM-dd"));
        calTaskMap.put("enddate", SWCDateTimeUtils.format((Date)calTaskInfo.getDate("enddate"), (String)"yyyy-MM-dd"));
        calTaskMap.put("payrollsceneId", calTaskInfo.getLong("payrollscene.id"));
        calTaskMap.put("calfrequencyId", calTaskInfo.getLong("calfrequency.id"));
        calTaskMap.put("coefficient", calTaskInfo.getLong("calfrequency.coefficient"));
        calTaskMap.put("payrollscenevId", calTaskInfo.getLong("payrollscenev.id"));
        Date attstartdate = calTaskInfo.getDate("attstartdate");
        Date attenddate = calTaskInfo.getDate("attenddate");
        if (!ObjectUtils.isEmpty((Object)attstartdate) && !ObjectUtils.isEmpty((Object)attenddate)) {
            calTaskMap.put("attstartdate", SWCDateTimeUtils.format((Date)attstartdate, (String)"yyyy-MM-dd"));
            calTaskMap.put("attenddate", SWCDateTimeUtils.format((Date)attenddate, (String)"yyyy-MM-dd"));
        }
        calParamInfo.setCalTaskMap(calTaskMap);
        calParamInfo.setStartDate(calTaskInfo.getDate("startdate"));
        calParamInfo.setEndDate(calTaskInfo.getDate("enddate"));
        calParamInfo.setPayDate(calTaskInfo.getDate("paydate"));
        calParamInfo.setPayrolldate(calTaskInfo.getDate("payrolldate"));
        calParamInfo.setProrationCal(calTaskInfo.getString("ishandleproration"));
    }

    public static DynamicObject getCalTaskInfo(Long calTaskId) {
        SWCDataServiceHelper calPayrollHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,number,name,tasktype,calrulev.id,startdate,enddate,country.id,ishandleproration,paydate,periodtype.id,period.id,payrollgroup.id,payrollgroupv.id,payrollgroupv.currency.id,payrollgroupv.exratetable.id,exratedate,payrollgroupv.currency.amtprecision,calfrequency.id,calfrequency.coefficient,payrollscene.id,calversionno,org.id,calrulev.opentaxcal,payrolldate, attstartdate, attenddate, payrollscenev,period.startdate,period.enddate,payrollscenev.id";
        return calPayrollHelper.queryOne(fields, (Object)calTaskId);
    }

    private void handleSpItem(CalParamCacheInfo calParamCacheInfo) {
        List spUniqueCodeList = calParamCacheInfo.getSpUniqueCodeList();
        if (SWCListUtils.isEmpty((List)spUniqueCodeList)) {
            log.info("no spItem data");
            return;
        }
        SWCDataServiceHelper spHelper = new SWCDataServiceHelper("hsbs_supportitem");
        QFilter filter = new QFilter("uniquecode", "in", (Object)spUniqueCodeList);
        String selectFields = "id,uniquecode,name,datatype.id,defaultvalue,datatype.storagetype,dataprecision.id,dataprecision.scale,dataround.id,datalength";
        DynamicObjectCollection spData = spHelper.queryOriginalCollection(selectFields, new QFilter[]{filter});
        HashMap<String, Object> spDataMap = new HashMap<String, Object>(16);
        HashMap<String, CalResultItem> spDataResultMap = new HashMap<String, CalResultItem>(16);
        HashMap<String, ItemInfo> spItemInfoMap = new HashMap<String, ItemInfo>(16);
        for (DynamicObject spItem : spData) {
            String uniquecode = spItem.getString("uniquecode");
            Object value = spItem.get("defaultvalue");
            long dataTypeId = spItem.getLong("datatype.id");
            if (dataTypeId == DataTypeEnum.NUMBERIC.getDbId() || dataTypeId == DataTypeEnum.AMOUNT.getDbId() || dataTypeId == DataTypeEnum.DATE.getDbId()) {
                value = "".equals(value) ? null : value;
            }
            spItemInfoMap.put(uniquecode, this.createItemInfoObj(spItem));
            spDataMap.put(uniquecode, value);
            CalResultItem param = new CalResultItem(CalResultItemEnum.SUPPORTITEM);
            param.setItemId(Long.valueOf(spItem.getLong("id")));
            param.setProrateType("0");
            param.setDataShowType(spItem.getString("datatype.storagetype"));
            spDataResultMap.put(uniquecode, param);
        }
        calParamCacheInfo.setSpMap(spDataMap);
        calParamCacheInfo.setSpResultMap(spDataResultMap);
        calParamCacheInfo.setSpItemInfoMap(spItemInfoMap);
    }

    private ItemInfo createItemInfoObj(DynamicObject spItem) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setId(spItem.getLong("id"));
        itemInfo.setName(spItem.getString("name"));
        itemInfo.setUniqueCode(spItem.getString("uniquecode"));
        itemInfo.setDataTypeId(spItem.getLong("datatype.id"));
        itemInfo.setShowType(spItem.getString("datatype.storagetype"));
        itemInfo.setDataPrecisionId(spItem.getLong("dataprecision.id"));
        itemInfo.setScale(Integer.valueOf(spItem.getInt("dataprecision.scale")));
        itemInfo.setDataLength(Integer.valueOf(spItem.getInt("datalength")));
        itemInfo.setDataroundId(spItem.getLong("dataround.id"));
        return itemInfo;
    }

    public void handleFTItemData(CalParamCacheInfo calParam) throws Exception {
        log.info("handleDataReader_begin");
        List fetchItemCodeList = calParam.getFetchItemCodeList();
        log.info("fetchItemCodeList:{}", (Object)fetchItemCodeList.toString());
        if (SWCListUtils.isEmpty((List)fetchItemCodeList)) {
            return;
        }
        ArrayList<String> calFetchItemCodeList = new ArrayList<String>(10);
        calFetchItemCodeList.addAll(fetchItemCodeList);
        ArrayList<CalFetchConfigInfo> fetchConfigInfoList = new ArrayList<CalFetchConfigInfo>(10);
        ArrayList<CalFetchConfigInfo> calingFetchConfigInfoList = new ArrayList<CalFetchConfigInfo>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem.uniquecode", "in", (Object)fetchItemCodeList);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchfieldentry,fetchconfig,resultfetchconfig,custfetchconfig,fetchitem.uniquecode,configtype,fetchconfig.issyspreset";
        DynamicObject[] objs = helper.query(fields, new QFilter[]{filter});
        if (objs == null || objs.length == 0) {
            log.info("\u53d6\u6570\u914d\u7f6e\u5173\u8054\u53d6\u6570\u9879\u76ee\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        log.info("fetchConfigItem_objs_size:{}", (Object)objs.length);
        HashMap<Long, CalFetchConfigInfo> configInfoMap = new HashMap<Long, CalFetchConfigInfo>(16);
        ArrayList<String> configIdList = new ArrayList<String>(10);
        ArrayList<String> filterConfigIdList = new ArrayList<String>(10);
        HashSet<String> fieldFetchItem = new HashSet<String>(16);
        HashMap<String, String> fetchItemDataTypeMap = new HashMap<String, String>(16);
        this.assembleFetchConfig(false, fetchItemDataTypeMap, fieldFetchItem, configIdList, filterConfigIdList, configInfoMap, objs, calFetchItemCodeList);
        for (Map.Entry entry : configInfoMap.entrySet()) {
            if (((CalFetchConfigInfo)entry.getValue()).getCalculationfetch() != null && ((CalFetchConfigInfo)entry.getValue()).getCalculationfetch().booleanValue()) {
                calingFetchConfigInfoList.add((CalFetchConfigInfo)entry.getValue());
                continue;
            }
            fetchConfigInfoList.add((CalFetchConfigInfo)entry.getValue());
        }
        List<String> filterConfigList = this.removeRepeat(filterConfigIdList);
        log.info("calConfigPath:{},filterConfigPath:{}", configIdList, filterConfigList);
        String pathSb = this.assembleConfigPath(configIdList, filterConfigList);
        HashMap<String, CalFetchConfigInfo> fetchItemConfigMap = new HashMap<String, CalFetchConfigInfo>(16);
        Map<String, Long> fetchItemCodeIdMap = this.assembleFetchItemCodeIdMap(calFetchItemCodeList);
        this.assembleFetchItemConfigMap(fetchItemConfigMap, fetchConfigInfoList, calingFetchConfigInfoList);
        log.info("fetchItemConfigMap:{}", (Object)SWCJSONUtils.toString(fetchItemConfigMap));
        calParam.setCalFetchConfigList(fetchConfigInfoList);
        calParam.setCalingFetchConfigList(calingFetchConfigInfoList);
        calParam.setCalConfigPath(pathSb);
        calParam.setFetchItemCodeIdMap(fetchItemCodeIdMap);
        calParam.setFetchItemConfigMap(fetchItemConfigMap);
        calParam.setFetchItemDataTypeMap(fetchItemDataTypeMap);
    }

    private List<String> removeRepeat(List<String> filterConfigIdList) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (int i = filterConfigIdList.size() - 1; i >= 0; --i) {
            String id = filterConfigIdList.get(i);
            if (list.contains(id)) continue;
            list.add(id);
        }
        Collections.reverse(list);
        return list;
    }

    private String assembleConfigPath(List<String> configIdList, List<String> filterConfigIdList) {
        StringBuilder pathSb = new StringBuilder();
        for (String configId : configIdList) {
            if (pathSb.length() > 0) {
                pathSb.append('#');
            }
            pathSb.append(configId);
        }
        if (filterConfigIdList.size() > 0) {
            for (String filterConfigId : filterConfigIdList) {
                pathSb.append('#').append(filterConfigId);
            }
        }
        return pathSb.toString();
    }

    private void assembleFetchItemConfigMap(Map<String, CalFetchConfigInfo> fetchItemConfigMap, List<CalFetchConfigInfo> fetchConfigInfoList, List<CalFetchConfigInfo> calingFetchConfigInfoList) {
        ArrayList<CalFetchConfigInfo> tempConfigList = new ArrayList<CalFetchConfigInfo>(10);
        tempConfigList.addAll(fetchConfigInfoList);
        tempConfigList.addAll(calingFetchConfigInfoList);
        for (CalFetchConfigInfo config : tempConfigList) {
            String selectType = config.getSelectType();
            if ((SWCStringUtils.equals((String)"0", (String)selectType) || SWCStringUtils.equals((String)"2", (String)selectType)) && !SWCListUtils.isEmpty((List)config.getFieldInfoList())) {
                List fieldInfoList = config.getFieldInfoList();
                for (FetchFieldInfo field : fieldInfoList) {
                    fetchItemConfigMap.put(field.getFetchItemCode(), config);
                }
            }
            if (!SWCStringUtils.equals((String)"1", (String)selectType) || SWCListUtils.isEmpty((List)config.getResultMatchItemInfo())) continue;
            List resultMatchItemInfo = config.getResultMatchItemInfo();
            for (CalResultMatchItemInfo matchItemInfo : resultMatchItemInfo) {
                fetchItemConfigMap.put(matchItemInfo.getMatchFetchItemCode(), config);
            }
        }
    }

    private Map<String, Long> assembleFetchItemCodeIdMap(List<String> fetchItemCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        QFilter filter = new QFilter("uniquecode", "in", fetchItemCodeList);
        DynamicObjectCollection objs = helper.queryOriginalCollection("id,uniquecode", new QFilter[]{filter});
        if (objs == null || objs.size() == 0) {
            return new HashMap<String, Long>(0);
        }
        Map<String, Long> collect = objs.stream().collect(Collectors.toMap(sKey -> sKey.getString("uniquecode"), sValue -> sValue.getLong("id")));
        return collect;
    }

    private void assembleFetchConfig(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, List<String> configIdList, List<String> filterConfigIdList, Map<Long, CalFetchConfigInfo> configInfoMap, DynamicObject[] objs, List<String> fetchItemCodeList) {
        HashMap<Long, String> configMap = new HashMap<Long, String>(16);
        for (DynamicObject singleObj : objs) {
            long configId = this.getConfigIdByType(singleObj);
            String configType = singleObj.getString("configtype");
            if (configMap.containsKey(configId)) continue;
            configMap.put(configId, configType);
        }
        for (Map.Entry entry : configMap.entrySet()) {
            Long configId = (Long)entry.getKey();
            String configType = (String)entry.getValue();
            this.addConfigToPathList(filterConfig, configIdList, filterConfigIdList, configId + "");
            log.info("configList:{},filterConfigList:{}", configIdList, filterConfigIdList);
            this.assembleSingleConfig(filterConfig, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, configId, configType, fetchItemCodeList);
        }
    }

    private boolean addConfigToPathList(boolean filterConfig, List<String> configIdList, List<String> filterConfigIdList, String configId) {
        if (filterConfig) {
            if (configIdList.contains(configId)) {
                configIdList.remove(configId);
                filterConfigIdList.add(0, configId);
                return true;
            }
            filterConfigIdList.add(configId);
        } else if (!configIdList.contains(configId)) {
            configIdList.add(configId);
        } else {
            return true;
        }
        return false;
    }

    private long getConfigIdByType(DynamicObject config) {
        String configType = config.getString("configtype");
        if (SWCStringUtils.equals((String)"0", (String)configType)) {
            return config.getLong("fetchconfig.id");
        }
        if (SWCStringUtils.equals((String)"1", (String)configType)) {
            return config.getLong("resultfetchconfig.id");
        }
        if (SWCStringUtils.equals((String)"2", (String)configType)) {
            return config.getLong("custfetchconfig.id");
        }
        return 0L;
    }

    private void assembleSingleConfig(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, Long configId, String configType, List<String> fetchItemCodeList) {
        log.info("assembleSingleConfig_configType:{},configId:{}", (Object)configType, (Object)configId);
        if (SWCStringUtils.equals((String)"0", (String)configType)) {
            this.assembleSingleFetchConfig(filterConfig, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, configId, fetchItemCodeList);
        }
        if (SWCStringUtils.equals((String)"1", (String)configType)) {
            this.assembleSingleResultFetchConfig(filterConfig, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, configId, fetchItemCodeList);
        }
        if (SWCStringUtils.equals((String)"2", (String)configType)) {
            this.assembleSingleCustFetchConfig(filterConfig, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, configId, fetchItemCodeList);
        }
    }

    private void assembleSingleFetchConfig(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, Long configId, List<String> fetchItemCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        QFilter filter = new QFilter("id", "=", (Object)configId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String queryFields = "sumfetch,name,number,masterid,dimensionality,fetchmethod,fetchsource.name,fetchsource.number,calculationfetch,fetchfieldentry.id,fetchfieldentry.field,fetchfieldentry.fieldname,fetchfieldentry.datatype,fetchfieldentry.sumtype,relationentity.filterfield,relationentity.filterfieldname,relationentity.filterdatatype,relationentity.condition,relationentity.comparevalue,relationentity.valuetype,relationentity.conditionnumber,fetchsortentry.sortfield,fetchsortentry.sortfieldname,fetchsortentry.sorttype,conditionlogictype,conditionlogiccode,proration,prorationstartfield,prorationendfield";
        DynamicObject fetchConfig = helper.queryOne(queryFields, new QFilter[]{filter, enableFilter});
        if (fetchConfig == null) {
            log.info("fetchConfig is null");
            return;
        }
        CalFetchConfigInfo info = new CalFetchConfigInfo(Long.valueOf(fetchConfig.getLong("id")), fetchConfig.getString("number"), "0", fetchConfig.getString("fetchsource.number"), Boolean.valueOf(fetchConfig.getBoolean("calculationfetch")), fetchConfig.getString("dimensionality"), fetchConfig.getString("fetchmethod"));
        ArrayList<FetchFieldInfo> fieldInfoList = new ArrayList<FetchFieldInfo>(10);
        ArrayList<FetchSortedInfo> sortedInfoList = new ArrayList<FetchSortedInfo>(10);
        FetchConfigFilterInfo filterInfo = new FetchConfigFilterInfo();
        this.assembleFieldList(filterConfig, fetchItemDataTypeMap, fieldInfoList, fetchConfig, fetchItemCodeList);
        List<String> fieldItemCode = fieldInfoList.stream().map(FetchFieldInfo::getFetchItemCode).collect(Collectors.toList());
        fieldFetchItem.addAll(fieldItemCode);
        this.assembleSortedList(sortedInfoList, fetchConfig);
        this.assembleConfigFilterInfo(fieldItemCode, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, fetchItemCodeList, "0", filterInfo, fetchConfig);
        info.setFieldInfoList(fieldInfoList);
        info.setSortedInfoList(sortedInfoList);
        info.setFilterInfo(filterInfo);
        info.setProration(fetchConfig.getBoolean("proration"));
        info.setProrationStartField(fetchConfig.getString("prorationstartfield"));
        info.setProrationEndField(fetchConfig.getString("prorationendfield"));
        info.setSumFetch(fetchConfig.getBoolean("sumfetch"));
        configInfoMap.put(configId, info);
    }

    private void assembleSingleResultFetchConfig(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, Long configId, List<String> fetchItemCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_resultfetchconfig");
        QFilter filter = new QFilter("id", "=", (Object)configId);
        filter.or("masterid", "=", (Object)configId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String queryFields = "name,number,masterid,selectlevel,datematch,startitem,enditem,calitemmatchentry.itemtype,scenelimit,calscene,calscene.basedata,datematchmethod,preperiodcount,calitemmatchentry.matchfetchitem.dataprecision,calitemmatchentry.matchfetchitem.dataround, calitemmatchentry.itemdatatype,calitemmatchentry.matchfetchitem,calitemmatchentry.handlestrategy,calitemmatchentry.fetchitementry,calitemmatchentry.salaryitementry,calitemmatchentry.supportitementry,calitemmatchentry.bizitementry";
        DynamicObject[] fetchConfigs = helper.query(queryFields, new QFilter[]{filter, enableFilter});
        if (fetchConfigs == null || fetchConfigs.length == 0) {
            return;
        }
        DynamicObject fetchConfig = fetchConfigs[0];
        CalFetchConfigInfo info = new CalFetchConfigInfo(Long.valueOf(fetchConfig.getLong("id")), fetchConfig.getString("number"), "1", Boolean.FALSE, "0");
        FetchConfigFilterInfo filterInfo = new FetchConfigFilterInfo();
        ArrayList<CalResultMatchItemInfo> resultMatchItemList = new ArrayList<CalResultMatchItemInfo>(10);
        this.assembleMatchItemList(fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, fetchItemCodeList, resultMatchItemList, fetchConfig);
        List<String> fieldItemCode = resultMatchItemList.stream().map(CalResultMatchItemInfo::getMatchFetchItemCode).collect(Collectors.toList());
        fieldFetchItem.addAll(fieldItemCode);
        this.assembleConfigFilterInfo(fieldItemCode, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, fetchItemCodeList, "1", filterInfo, fetchConfig);
        info.setProration(false);
        info.setFilterInfo(filterInfo);
        info.setResultMatchItemInfo(resultMatchItemList);
        configInfoMap.put(configId, info);
    }

    private void assembleMatchItemList(Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, List<String> fetchItemCodeList, List<CalResultMatchItemInfo> resultMatchItemList, DynamicObject fetchSingle) {
        DynamicObjectCollection objs = fetchSingle.getDynamicObjectCollection("calitemmatchentry");
        if (objs == null || objs.size() == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            DynamicObject itemObj;
            if (!fetchItemCodeList.contains(obj.getString("matchfetchitem.uniquecode"))) continue;
            CalResultMatchItemInfo matchItemInfo = new CalResultMatchItemInfo();
            matchItemInfo.setItemType(obj.getString("itemtype"));
            matchItemInfo.setItemId(this.getResultEntryItemIdCodeType(obj, "1"));
            matchItemInfo.setItemCode(this.getResultEntryItemIdCodeType(obj, "2"));
            matchItemInfo.setDataType(this.getResultEntryItemIdCodeType(obj, "3"));
            matchItemInfo.setMatchFetchItemId(obj.getString("matchfetchitem.id"));
            matchItemInfo.setMatchFetchItemCode(obj.getString("matchfetchitem.uniquecode"));
            matchItemInfo.setHandleStrategy(obj.getString("handlestrategy"));
            matchItemInfo.setPrecision(ItemDataUtils.getScal((long)obj.getLong("matchfetchitem.dataprecision.id")));
            matchItemInfo.setDataRound(ItemDataUtils.getRoundingMode((long)obj.getLong("matchfetchitem.dataround.id")));
            resultMatchItemList.add(matchItemInfo);
            fetchItemDataTypeMap.put(obj.getString("matchfetchitem.uniquecode"), this.getItemDataTypeById(obj.getLong("matchfetchitem.datatype.id")));
            if (!SWCStringUtils.equals((String)"4", (String)obj.getString("itemtype")) || (itemObj = this.getFetchConfigItemByItemId(obj.getLong("fetchitementry.id"))) == null) continue;
            this.assembleFetchConfig(false, fetchItemDataTypeMap, fieldFetchItem, configIdList, filterConfigIdList, configInfoMap, new DynamicObject[]{itemObj}, fetchItemCodeList);
        }
    }

    private String getItemDataTypeById(Long dataTypeId) {
        if (1050L == dataTypeId) {
            return CalDataTypeEnum.DATE.getCode();
        }
        if (1010L == dataTypeId) {
            return CalDataTypeEnum.BIGDECIMAL.getCode();
        }
        return CalDataTypeEnum.STRING.getCode();
    }

    private String getResultEntryItemIdCodeType(DynamicObject fetchSingle, String type) {
        String dataType;
        String itemCode;
        String itemId;
        String itemType;
        switch (itemType = fetchSingle.getString("itemtype")) {
            case "1": {
                itemId = fetchSingle.getString("salaryitementry.id");
                itemCode = fetchSingle.getString("salaryitementry.uniquecode");
                dataType = fetchSingle.getString("salaryitementry.datatype.id");
                break;
            }
            case "2": {
                itemId = fetchSingle.getString("supportitementry.id");
                itemCode = fetchSingle.getString("supportitementry.uniquecode");
                dataType = fetchSingle.getString("supportitementry.datatype.id");
                break;
            }
            case "3": {
                itemId = fetchSingle.getString("bizitementry.id");
                itemCode = fetchSingle.getString("bizitementry.uniquecode");
                dataType = fetchSingle.getString("bizitementry.datatype.id");
                break;
            }
            case "4": {
                itemId = fetchSingle.getString("fetchitementry.id");
                itemCode = fetchSingle.getString("fetchitementry.uniquecode");
                dataType = fetchSingle.getString("fetchitementry.datatype.id");
                break;
            }
            default: {
                itemId = "";
                itemCode = "";
                dataType = "";
            }
        }
        if (SWCStringUtils.equals((String)"1", (String)type)) {
            return itemId;
        }
        if (SWCStringUtils.equals((String)"2", (String)type)) {
            return itemCode;
        }
        if (SWCStringUtils.equals((String)"3", (String)type)) {
            return dataType;
        }
        return "";
    }

    private void assembleConfigFilterInfo(List<String> fieldItemCode, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, List<String> fetchItemCodeList, String type, FetchConfigFilterInfo filterInfo, DynamicObject fetchSingle) {
        if (SWCStringUtils.equals((String)"0", (String)type)) {
            filterInfo.setConditionLogicType(fetchSingle.getString("conditionlogictype"));
            filterInfo.setConditionLogic(fetchSingle.getString("conditionlogiccode"));
            this.assembleFetchFilterEntryList(fieldItemCode, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, fetchItemCodeList, filterInfo, fetchSingle);
        }
        if (SWCStringUtils.equals((String)"1", (String)type)) {
            List<Long> calSceneList = this.assembleCalSceneList(fetchSingle);
            this.assembleResultFetchConfigFilterCommonInfo(filterInfo, fetchSingle, calSceneList);
            if (SWCStringUtils.equals((String)"1", (String)fetchSingle.getString("datematchmethod"))) {
                filterInfo.setPrePeriodCount(fetchSingle.getInt("preperiodcount"));
            } else {
                List<String> dateItemCodeList = Arrays.asList(fetchSingle.getString("startitem.uniquecode"), fetchSingle.getString("enditem.uniquecode"));
                log.info("\u85aa\u916c\u7ed3\u679c\u53d6\u6570\u914d\u7f6e\u5173\u8054\u6761\u4ef6\u53d6\u6570\u9879\u76ee:{}", dateItemCodeList);
                DynamicObject[] objs = this.getFetchConfigItemByCodeList(dateItemCodeList);
                if (objs != null && objs.length > 0) {
                    for (String itemCode : dateItemCodeList) {
                        if (fetchItemCodeList.contains(itemCode)) continue;
                        fetchItemCodeList.add(itemCode);
                    }
                    log.info("fetchItemCodeList_addFilterItemCode:{}", fetchItemCodeList);
                    this.assembleFetchConfig(true, fetchItemDataTypeMap, fieldFetchItem, configIdList, filterConfigIdList, configInfoMap, objs, fetchItemCodeList);
                }
            }
        }
        if (SWCStringUtils.equals((String)"2", (String)type)) {
            filterInfo.setCustPath(fetchSingle.getString("fetchpath"));
            this.assembleCustFetchFilterEntryList(fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, fetchItemCodeList, filterInfo, fetchSingle);
        }
    }

    private void assembleResultFetchConfigFilterCommonInfo(FetchConfigFilterInfo filterInfo, DynamicObject fetchSingle, List<Long> calSceneList) {
        filterInfo.setSelectLevel(fetchSingle.getString("selectlevel"));
        filterInfo.setDateMatch(fetchSingle.getString("datematch"));
        filterInfo.setStartFetchItemCode(fetchSingle.getString("startitem.uniquecode"));
        filterInfo.setEndFetchItemCode(fetchSingle.getString("enditem.uniquecode"));
        filterInfo.setSceneLimit(fetchSingle.getString("scenelimit"));
        filterInfo.setCalScene(calSceneList);
        filterInfo.setDateMatchMethod(fetchSingle.getString("datematchmethod"));
    }

    private DynamicObject getFetchItemByCode(String itemCode) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        QFilter filter = new QFilter("uniquecode", "=", (Object)itemCode);
        return helper.queryOne("uniquecode", new QFilter[]{filter});
    }

    private DynamicObject getSpItemByCode(String itemCode) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_supportitem");
        QFilter filter = new QFilter("uniquecode", "=", (Object)itemCode);
        return helper.queryOne("uniquecode,defaultvalue", new QFilter[]{filter});
    }

    private List<Long> assembleCalSceneList(DynamicObject fetchSingle) {
        ArrayList<Long> list = new ArrayList<Long>(10);
        DynamicObjectCollection calscene = fetchSingle.getDynamicObjectCollection("calscene");
        if (calscene == null || calscene.size() == 0) {
            return list;
        }
        for (DynamicObject obj : calscene) {
            list.add((Long)obj.getDynamicObject("fbasedataid").getPkValue());
        }
        return list;
    }

    private DynamicObject[] getFetchConfigItemByCodeList(List<String> dateItemCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem.uniquecode", "in", dateItemCodeList);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchfieldentry,fetchconfig,resultfetchconfig,custfetchconfig,fetchitem.uniquecode,configtype";
        DynamicObject[] objs = helper.query(fields, new QFilter[]{filter});
        return objs;
    }

    private void assembleFetchFilterEntryList(List<String> fieldItemCode, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, List<String> fetchItemCodeList, FetchConfigFilterInfo filterInfo, DynamicObject fetchSingle) {
        DynamicObjectCollection dynamicObjectCollection = fetchSingle.getDynamicObjectCollection("relationentity");
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return;
        }
        String conditionLogic = filterInfo.getConditionLogic();
        ArrayList<FilterEntryInfo> filterEntryInfoList = filterInfo.getFilterEntryInfoList();
        if (SWCListUtils.isEmpty((List)filterEntryInfoList)) {
            filterEntryInfoList = new ArrayList<FilterEntryInfo>(10);
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject spItemObj;
            String conditionNumber = dynamicObject.getString("conditionnumber");
            if (!conditionLogic.contains(conditionNumber)) continue;
            String valueType = dynamicObject.getString("valuetype");
            String compareValue = dynamicObject.getString("comparevalue");
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
                DynamicObject fetchItemObj = this.getFetchItemByCode(compareValue);
                if (!SWCListUtils.isEmpty(fieldItemCode) && fieldItemCode.contains(fetchItemObj.getString("uniquecode"))) {
                    log.info("\u53d6\u6570\u9879\u76ee\u5f15\u7528\u6709\u8bef\uff0c\u67e5\u8be2\u6761\u4ef6\u5173\u8054\u7684\u53d6\u6570\u9879\u76ee\u5fc5\u987b\u5173\u8054\u53d6\u6570\u914d\u7f6e");
                    return;
                }
                DynamicObject itemObj = this.getFetchConfigItemByItemCode(compareValue);
                if (itemObj != null) {
                    fetchItemCodeList.add(itemObj.getString("fetchitem.uniquecode"));
                    this.assembleFetchConfig(true, fetchItemDataTypeMap, fieldFetchItem, configIdList, filterConfigIdList, configInfoMap, new DynamicObject[]{itemObj}, fetchItemCodeList);
                }
            }
            String spItemDefaultValue = "";
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_SPITEM.getCode(), (String)valueType) && (spItemObj = this.getSpItemByCode(compareValue)) != null) {
                spItemDefaultValue = spItemObj.getString("defaultvalue");
            }
            FilterEntryInfo filterEntryInfo = new FilterEntryInfo();
            this.assembleFetchConfigConditionEntryInfo(spItemDefaultValue, dynamicObject, valueType, compareValue, filterEntryInfo);
            filterEntryInfoList.add(filterEntryInfo);
        }
        filterInfo.setFilterEntryInfoList(filterEntryInfoList);
    }

    private void assembleFetchConfigConditionEntryInfo(String spItemDefaultValue, DynamicObject dynamicObject, String valueType, String compareValue, FilterEntryInfo filterEntryInfo) {
        filterEntryInfo.setFieldId(dynamicObject.getString("filterfield"));
        filterEntryInfo.setFieldName(dynamicObject.getString("filterfieldname"));
        filterEntryInfo.setFieldType(dynamicObject.getString("filterdatatype"));
        filterEntryInfo.setCondition(dynamicObject.getString("condition"));
        filterEntryInfo.setValueType(valueType);
        filterEntryInfo.setConditionNumber(dynamicObject.getString("conditionnumber"));
        filterEntryInfo.setValue(compareValue);
        filterEntryInfo.setSpItemDefaultValue(spItemDefaultValue);
    }

    private DynamicObject getFetchConfigItemByItemId(long itemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem.id", "=", (Object)itemId);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchfieldentry,fetchconfig,resultfetchconfig,custfetchconfig,fetchitem.uniquecode,configtype";
        DynamicObject obj = helper.queryOne(fields, new QFilter[]{filter});
        return obj;
    }

    private DynamicObject getFetchConfigItemByItemCode(String itemCode) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchitem.uniquecode", "=", (Object)itemCode);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchfieldentry,fetchconfig,resultfetchconfig,custfetchconfig,fetchitem.uniquecode,configtype,fetchconfig.issyspreset";
        DynamicObject obj = helper.queryOne(fields, new QFilter[]{filter});
        return obj;
    }

    private DynamicObjectCollection getFetchConfigItemByEntryIds(List<Long> entryIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter filter = new QFilter("fetchfieldentry", "in", entryIdList);
        filter.and("enable", "=", (Object)"1");
        String fields = "fetchfieldentry,fetchconfig,resultfetchconfig,custfetchconfig,fetchitem.uniquecode,fetchitem.datatype.showtype,configtype,fetchitem.dataprecision,fetchitem.dataround";
        DynamicObjectCollection obj = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return obj;
    }

    private void assembleSortedList(List<FetchSortedInfo> sortedInfoList, DynamicObject fetchSingle) {
        DynamicObjectCollection dynamicObjectCollection = fetchSingle.getDynamicObjectCollection("fetchsortentry");
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            FetchSortedInfo sortedInfo = new FetchSortedInfo();
            sortedInfo.setFieldId(dynamicObject.getString("sortfield"));
            sortedInfo.setFieldName(dynamicObject.getString("sortfieldname"));
            sortedInfo.setSortType(dynamicObject.getString("sorttype"));
            sortedInfoList.add(sortedInfo);
        }
    }

    private void assembleFieldList(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, List<FetchFieldInfo> fieldInfoList, DynamicObject fetchSingle, List<String> fetchItemCodeList) {
        DynamicObjectCollection dynamicObjectCollection = fetchSingle.getDynamicObjectCollection("fetchfieldentry");
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return;
        }
        List<Long> fieldEntryIdList = dynamicObjectCollection.stream().map(value -> value.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection fetchConfigItemByEntryIds = this.getFetchConfigItemByEntryIds(fieldEntryIdList);
        Map itemObjMap = fetchConfigItemByEntryIds.stream().collect(Collectors.toMap(itemObj -> itemObj.getLong("fetchfieldentry"), Function.identity()));
        Map<Long, String> fetchfieldentryMap = fetchConfigItemByEntryIds.stream().collect(Collectors.toMap(kObj -> kObj.getLong("fetchfieldentry"), vObj -> vObj.getString("fetchitem.uniquecode"), (v1, v2) -> v2));
        Map<Long, String> fetchItemDataType = fetchConfigItemByEntryIds.stream().collect(Collectors.toMap(kObj -> kObj.getLong("fetchfieldentry"), vObj -> vObj.getString("fetchitem.datatype.showtype"), (v1, v2) -> v2));
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            long id = dynamicObject.getLong("id");
            if (!fetchItemCodeList.contains(fetchfieldentryMap.get(id))) continue;
            FetchFieldInfo fieldInfo = new FetchFieldInfo();
            fieldInfo.setField(dynamicObject.getString("field"));
            fieldInfo.setFieldName(dynamicObject.getString("fieldname"));
            fieldInfo.setDataType(dynamicObject.getString("datatype"));
            fieldInfo.setFetchItemCode(fetchfieldentryMap.get(id));
            fieldInfo.setFilterField(filterConfig);
            fieldInfo.setSumType(dynamicObject.getString("sumtype"));
            DynamicObject itemObj2 = (DynamicObject)itemObjMap.get(id);
            Integer precision = ItemDataUtils.getScal((long)itemObj2.getLong("fetchitem.dataprecision"));
            if (precision != null) {
                RoundingMode roundingMode = ItemDataUtils.getRoundingMode((long)itemObj2.getLong("fetchitem.dataround"));
                fieldInfo.setPrecision(precision.intValue());
                fieldInfo.setDataRound(roundingMode);
            }
            fieldInfoList.add(fieldInfo);
            fetchItemDataTypeMap.put(fetchfieldentryMap.get(id), fetchItemDataType.get(id));
        }
    }

    private List<Long> handleBsItem(CalParamCacheInfo calParamInfo) {
        List bsUniqueCodeList = calParamInfo.getBsUniqueCodeList();
        ArrayList<Long> bsIdForFileList = new ArrayList<Long>(10);
        if (SWCListUtils.isEmpty((List)bsUniqueCodeList)) {
            log.info("no bsItem data");
            return bsIdForFileList;
        }
        List bsPropUniqueCodeList = calParamInfo.getBsPropUniqueCodeList();
        QFilter filter = new QFilter("uniquecode", "in", (Object)bsUniqueCodeList);
        SWCDataServiceHelper bsHelper = new SWCDataServiceHelper("hsbs_bizitem");
        DynamicObject[] bsData = bsHelper.query("id,datatype.showtype,uniquecode,cycle,multipleinput,consumemethod,oneoffconsume,bizitemprop,classification,attitemtype", new QFilter[]{filter});
        HashMap<String, List<String>> bsItemPropRelMap = new HashMap<String, List<String>>(16);
        HashMap<String, String> bsDataTypeMap = new HashMap<String, String>(16);
        HashMap bizItemMap = new HashMap(16);
        HashMap bizItemInfoMap = new HashMap(16);
        for (DynamicObject bs : bsData) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
            bsIdForFileList.add(bs.getLong("id"));
            bsDataTypeMap.put(bs.getString("uniquecode"), bs.getString("datatype.showtype"));
            itemMap.put("multipleinput", bs.getBoolean("multipleinput"));
            itemMap.put("consumemethod", bs.get("consumemethod"));
            itemMap.put("oneoffconsume", bs.getBoolean("oneoffconsume"));
            itemMap.put("uniquecode", bs.getString("uniquecode"));
            itemMap.put("id", String.valueOf(bs.getLong("id")));
            itemMap.put("classification", bs.getString("classification"));
            itemMap.put("attitemtype", bs.getString("attitemtype"));
            itemMap.put("datatype", bs.getString("datatype.showtype"));
            bizItemMap.put(bs.getString("id"), itemMap);
            bizItemInfoMap.put(bs.getString("uniquecode"), itemMap);
            this.addBsItemPropRelMapData(bsItemPropRelMap, bsPropUniqueCodeList, bs);
        }
        Map<String, String> bsItemPropDataTypeMap = this.getBsItemPropData(bsPropUniqueCodeList);
        HashMap<String, Object> bsDataMap = new HashMap<String, Object>(6);
        bsDataMap.put("2", bsIdForFileList);
        bsDataMap.put("bsDataTypeKey", bsDataTypeMap);
        bsDataMap.put("bsItemMapKey", bizItemMap);
        bsDataMap.put("bsItemPropRelMap", bsItemPropRelMap);
        bsDataMap.put("bizItemInfoMap", bizItemInfoMap);
        bsDataMap.put("bsItemPropDataTypeMap", bsItemPropDataTypeMap);
        calParamInfo.setBsMap(bsDataMap);
        return bsIdForFileList;
    }

    private Map<String, String> getBsItemPropData(List<String> bsPropUniqueCodeList) {
        if (SWCListUtils.isEmpty(bsPropUniqueCodeList)) {
            return new HashMap<String, String>(0);
        }
        QFilter filter = new QFilter("propuniquecode", "in", bsPropUniqueCodeList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemprop");
        String fields = "id,propuniquecode,datatype.id";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("propuniquecode"), obj -> String.valueOf(obj.getLong("datatype.id")), (key1, key2) -> key1));
    }

    private void addBsItemPropRelMapData(Map<String, List<String>> bsItemPropRelMap, List<String> bsPropUniqueCodeList, DynamicObject bs) {
        DynamicObjectCollection entryList = bs.getDynamicObjectCollection("bizitempropentry");
        if (entryList == null || entryList.size() == 0 || SWCListUtils.isEmpty(bsPropUniqueCodeList)) {
            return;
        }
        List propList = bsItemPropRelMap.getOrDefault(bs.getString("uniquecode"), new ArrayList(10));
        for (DynamicObject obj : entryList) {
            String propuniquecode = obj.getString("bizitemprop.propuniquecode");
            if (!bsPropUniqueCodeList.contains(propuniquecode) || propList.contains(propuniquecode)) continue;
            propList.add(propuniquecode);
        }
        if (propList.size() > 0) {
            bsItemPropRelMap.put(bs.getString("uniquecode"), propList);
        }
    }

    private List<Long> cacheSalaryItemRelationMap(CalParamCacheInfo calParamCacheInfo, int amtPrecision) {
        ArrayList<Long> salaryItemIdList = new ArrayList<Long>(10);
        ArrayList<String> queryUniqueCodeList = new ArrayList<String>(10);
        List slUniqueCodeList = calParamCacheInfo.getSlUniqueCodeList();
        List saveSlUniqueCodeList = calParamCacheInfo.getNeedSaveSalaryItemList();
        queryUniqueCodeList.addAll(slUniqueCodeList);
        queryUniqueCodeList.addAll(saveSlUniqueCodeList);
        DynamicObject[] collection = this.getSalaryItemCollection(queryUniqueCodeList);
        HashMap<String, SalaryItemVO> itemUniqueCodeMap = new HashMap<String, SalaryItemVO>(collection.length);
        for (DynamicObject item : collection) {
            String uniquecode = item.getString("uniquecode");
            itemUniqueCodeMap.put(uniquecode, this.getSalaryItemObj(item, amtPrecision));
            if (!saveSlUniqueCodeList.contains(uniquecode)) continue;
            salaryItemIdList.add(item.getLong("id"));
        }
        calParamCacheInfo.setItemUniqueCodeMap(itemUniqueCodeMap);
        return salaryItemIdList;
    }

    private SalaryItemVO getSalaryItemObj(DynamicObject item, int amtPrecision) {
        SalaryItemVO salaryItem = new SalaryItemVO();
        salaryItem.setUniqueCode(item.getString("uniquecode"));
        salaryItem.setName(item.getString("name"));
        salaryItem.setId(item.getLong("id"));
        salaryItem.setDataLength(Integer.valueOf(item.getInt("datalength")));
        salaryItem.setDataroundId(item.getLong("dataround.id"));
        salaryItem.setShowType(item.getString("datatype.showtype"));
        if (SWCStringUtils.equals((String)"amount", (String)salaryItem.getShowType())) {
            salaryItem.setScale(Integer.valueOf(amtPrecision));
        } else {
            salaryItem.setScale(Integer.valueOf(item.getInt("dataprecision.scale")));
        }
        return salaryItem;
    }

    private DynamicObject[] getSalaryItemCollection(List<String> uniqueCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String selectProperties = "id,name,number,uniquecode,datatype.showtype,dataprecision.scale,dataround.id,datalength";
        QFilter filter = new QFilter("uniquecode", "in", uniqueCodeList);
        DynamicObject[] collection = helper.query(selectProperties, new QFilter[]{filter});
        return collection;
    }

    private void matchAccumulator(DynamicObject calTaskInfo, List<Long> salaryItemIdList, List<Long> bizItemIdList, CalParamCacheInfo calParamCacheInfo, String calType) {
        ArrayList<AccInfo> accList = new ArrayList<AccInfo>(10);
        if (SWCListUtils.isEmpty(salaryItemIdList) && SWCListUtils.isEmpty(bizItemIdList)) {
            return;
        }
        long calTaskId = calTaskInfo.getLong("id");
        Date startDate = calTaskInfo.getDate("startdate");
        Date endDate = calTaskInfo.getDate("enddate");
        long orgId = calTaskInfo.getLong("org.id");
        DynamicObject[] accData = this.getAccumulatorData(calTaskInfo.getLong("country.id"), salaryItemIdList, bizItemIdList, endDate, orgId);
        if (accData == null || accData.length == 0) {
            if (SWCStringUtils.equals((String)"afterTaxCal", (String)calType)) {
                this.getExistPreAccId(accList, calParamCacheInfo, calTaskId);
            }
            return;
        }
        HashMap<String, List<AccMemberInfo>> accMemberMap = new HashMap<String, List<AccMemberInfo>>(16);
        List fetchItemCodeList = calParamCacheInfo.getFetchItemCodeList();
        List needSaveSalaryItemList = calParamCacheInfo.getNeedSaveSalaryItemList();
        HashSet<String> slUniqueCodeSet = new HashSet<String>(16);
        AccInfo accInfo = null;
        ArrayList<AccMemberInfo> accMemberList = null;
        SWCDataServiceHelper calTaskAccRelationHelper = new SWCDataServiceHelper("hsas_caltaskaccrel");
        ArrayList<Long> accIdList = new ArrayList<Long>(accData.length);
        HashMap<Long, List<AccMemberInfo>> accMemberRelMap = new HashMap<Long, List<AccMemberInfo>>(accData.length);
        for (DynamicObject obj : accData) {
            accMemberList = new ArrayList<AccMemberInfo>(10);
            if (!AccService.checkAccMember(obj, salaryItemIdList, bizItemIdList, startDate, endDate, accMemberList)) {
                accMemberList.clear();
                continue;
            }
            accInfo = AccService.getAccInfoObj(obj);
            accInfo.setOnlyFormulaUse(false);
            if (SWCStringUtils.isNotEmpty((String)accInfo.getStartDateItemCode()) && !fetchItemCodeList.contains(accInfo.getStartDateItemCode())) {
                fetchItemCodeList.add(accInfo.getStartDateItemCode());
            }
            AccService.setAccDimensionInfoList(accInfo, obj, fetchItemCodeList);
            accInfo.setMemberInfoList(accMemberList);
            accList.add(accInfo);
            accIdList.add(obj.getLong("id"));
            accMemberRelMap.put(obj.getLong("id"), accMemberList);
            if (!SWCStringUtils.equals((String)"3", (String)obj.getString("updatestrategy"))) {
                HandleParamsBeforeCalService.putAccMemberToMap(accMemberMap, accMemberList);
                continue;
            }
            slUniqueCodeSet.addAll(this.getAccMemberForAfterTaxCal(calType, accMemberList, needSaveSalaryItemList));
        }
        Map<Long, List<AccMemberInfo>> preCalAccRelMap = new HashMap<Long, List<AccMemberInfo>>(16);
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        if (SWCStringUtils.equals((String)"afterTaxCal", (String)calType)) {
            qFilter.and("acc.id", "in", accIdList);
            preCalAccRelMap = this.getPreCalAccMemberData(qFilter, calTaskAccRelationHelper);
            this.getExistPreAccId(accList, calParamCacheInfo, calTaskId);
        }
        DynamicObjectCollection calAccRelationList = this.getCalTaskAccRelationObj(calTaskId, calTaskAccRelationHelper, accMemberRelMap, preCalAccRelMap);
        this.saveCalAccRelationData(calAccRelationList, calTaskAccRelationHelper, qFilter);
        calParamCacheInfo.setAccInfoList(accList);
        calParamCacheInfo.setAccMemberMap(accMemberMap);
        calParamCacheInfo.setFetchItemCodeList(fetchItemCodeList);
        calParamCacheInfo.getSlUniqueCodeList().addAll(slUniqueCodeSet);
    }

    private void getExistPreAccId(List<AccInfo> accList, CalParamCacheInfo calParamCacheInfo, Long calTaskId) {
        List accUniqueCodeList = calParamCacheInfo.getAccUniqueCodeList();
        if (SWCListUtils.isEmpty((List)accUniqueCodeList)) {
            return;
        }
        List matchList = accList.stream().map(AccInfo::getUniqueCode).collect(Collectors.toList());
        ArrayList preTaxAccList = new ArrayList(accUniqueCodeList.size());
        accUniqueCodeList.forEach(obj -> {
            if (!matchList.contains(obj)) {
                preTaxAccList.add(obj);
            }
        });
        if (preTaxAccList.size() == 0) {
            return;
        }
        QFilter relFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        relFilter.and(new QFilter("acc.uniquecode", "in", preTaxAccList));
        relFilter.and(new QFilter("acc.updatestrategy", "=", (Object)"3"));
        SWCDataServiceHelper relHelper = new SWCDataServiceHelper("hsas_caltaskaccrel");
        Map<Long, List<AccMemberInfo>> preCalAccRelMap = this.getPreCalAccMemberData(relFilter, relHelper);
        if (preCalAccRelMap == null || preCalAccRelMap.size() == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accumulator");
        QFilter filter = new QFilter("id", "in", preCalAccRelMap.keySet());
        String fields = "id,updatestrategy,periodtype,startdatetype,startdate,uniquecode,datatype.id,dataprecision.id,dataround.id,startdateitem.uniquecode,startmonth,startday,bsedstrategy,accdimension";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<Long, AccInfo> preTaxAccMap = new HashMap<Long, AccInfo>(result.size());
        AccInfo accInfo = null;
        List<AccMemberInfo> memberInfoList = null;
        HashSet<String> slUniqueCodeSet = new HashSet<String>(16);
        for (DynamicObject accObj : result) {
            accInfo = AccService.getAccInfoObj(accObj);
            memberInfoList = preCalAccRelMap.get(accObj.getLong("id"));
            accInfo.setMemberInfoList(memberInfoList);
            preTaxAccMap.put(accObj.getLong("id"), accInfo);
            slUniqueCodeSet.addAll(this.getAccMemberForAfterTaxCal("afterTaxCal", memberInfoList, calParamCacheInfo.getNeedSaveSalaryItemList()));
        }
        if (slUniqueCodeSet.size() > 0) {
            calParamCacheInfo.getSlUniqueCodeList().addAll(slUniqueCodeSet);
        }
        calParamCacheInfo.setPreTaxAccMap(preTaxAccMap);
    }

    private Set<String> getAccMemberForAfterTaxCal(String calType, List<AccMemberInfo> accMemberList, List<String> needSaveSalaryItemList) {
        if (!"afterTaxCal".equals(calType)) {
            return new HashSet<String>(0);
        }
        HashSet<String> slUniqueCodeSet = new HashSet<String>(accMemberList.size());
        for (AccMemberInfo temp : accMemberList) {
            if (!SWCStringUtils.isNotEmpty((String)temp.getSlUniqueCode()) || needSaveSalaryItemList.contains(temp.getSlUniqueCode())) continue;
            slUniqueCodeSet.add(temp.getSlUniqueCode());
        }
        return slUniqueCodeSet;
    }

    private Map<Long, List<AccMemberInfo>> getPreCalAccMemberData(QFilter qFilter, SWCDataServiceHelper calTaskAccRelationHelper) {
        String fields = "acc.id,accmember";
        DynamicObjectCollection data = calTaskAccRelationHelper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        if (data.size() == 0) {
            return new HashMap<Long, List<AccMemberInfo>>(0);
        }
        HashMap<Long, List<AccMemberInfo>> accRelMap = new HashMap<Long, List<AccMemberInfo>>(data.size());
        List memberList = null;
        for (DynamicObject rel : data) {
            try {
                memberList = (List)SWCJSONUtils.cast((String)rel.getString("accmember"), List.class, (Class[])new Class[]{AccMemberInfo.class});
                if (SWCListUtils.isEmpty(memberList = memberList.stream().filter(obj -> obj.isUsed()).collect(Collectors.toList()))) continue;
                accRelMap.put(rel.getLong("acc.id"), memberList);
            }
            catch (IOException e) {
                log.error("acc member json cast error,accid={}", (Object)rel.getLong("acc.id"));
            }
        }
        return accRelMap;
    }

    public static void putAccMemberToMap(Map<String, List<AccMemberInfo>> accMemberMap, List<AccMemberInfo> accMemberList) {
        List<AccMemberInfo> tempList = null;
        String key = null;
        for (AccMemberInfo info : accMemberList) {
            if (!info.isUsed()) continue;
            key = info.getSlUniqueCode() == null ? info.getBsUniqueCode() : info.getSlUniqueCode();
            tempList = accMemberMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList<AccMemberInfo>(10);
                accMemberMap.put(key, tempList);
            }
            tempList.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCalAccRelationData(DynamicObjectCollection calAccRelationList, SWCDataServiceHelper calTaskAccRelationHelper, QFilter qFilter) {
        try (TXHandle txHandle = TX.requiresNew();){
            calTaskAccRelationHelper.deleteByFilter(new QFilter[]{qFilter});
            calTaskAccRelationHelper.save(calAccRelationList);
        }
    }

    private DynamicObjectCollection getCalTaskAccRelationObj(long calTaskId, SWCDataServiceHelper calTaskAccRelationHelper, Map<Long, List<AccMemberInfo>> accMemberRelMap, Map<Long, List<AccMemberInfo>> preCalAccRelMap) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObject calTaskAccRelation = null;
        for (Map.Entry<Long, List<AccMemberInfo>> entry : accMemberRelMap.entrySet()) {
            calTaskAccRelation = calTaskAccRelationHelper.generateEmptyDynamicObject();
            calTaskAccRelation.set("acc", (Object)entry.getKey());
            calTaskAccRelation.set("caltask", (Object)calTaskId);
            calTaskAccRelation.set("creator", (Object)RequestContext.get().getCurrUserId());
            calTaskAccRelation.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calTaskAccRelation.set("createtime", (Object)new Date());
            calTaskAccRelation.set("modifytime", (Object)new Date());
            try {
                calTaskAccRelation.set("accmember", (Object)SWCJSONUtils.toString(this.setMemberProp(entry.getValue(), preCalAccRelMap.get(entry.getKey()))));
            }
            catch (IOException e) {
                log.error("accMemberList json to string error", (Throwable)e);
            }
            result.add((Object)calTaskAccRelation);
        }
        return result;
    }

    private List<AccMemberInfo> setMemberProp(List<AccMemberInfo> memberList, List<AccMemberInfo> existList) {
        if (SWCListUtils.isEmpty(existList)) {
            return memberList;
        }
        Map<String, AccMemberInfo> memberMap = memberList.stream().collect(Collectors.toMap(AccMemberInfo::getMemberKey, obj -> obj));
        AccMemberInfo accMember = null;
        for (AccMemberInfo temp : existList) {
            accMember = memberMap.get(temp.getMemberKey());
            if (accMember == null) continue;
            accMember.setUsed(true);
        }
        return memberList;
    }

    private DynamicObject[] getAccumulatorData(long countryId, List<Long> salaryItemId, List<Long> bizItemIdList, Date endDate, Long orgId) {
        SWCDataServiceHelper accHelper = new SWCDataServiceHelper("hsas_accumulator");
        String fields = "id,updatestrategy,periodtype,startdatetype,startdate,uniquecode,datatype,dataprecision,dataround,startdateitem,startmonth,startday,bsedstrategy,accdimension,accdimitementry.dimitemtype,accdimitementry.fetchitem,accmemberentry.membertype,accmemberentry.salaryitem,accmemberentry.bizitem,accmemberentry.accmemstartdate,accmemberentry.accmemenddate,accmemberentry.operator,accmemberentry.accpercenttype,accmemberentry.percentfixval";
        QFilter qFilter = new QFilter("country", "in", (Object)new Long[]{countryId, 0L});
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("accmemberentry.accmemstartdate", "<=", (Object)endDate);
        QFilter salaryQFilter = new QFilter("accmemberentry.salaryitem", "in", salaryItemId);
        QFilter bizItemQFilter = new QFilter("accmemberentry.bizitem", "in", bizItemIdList);
        qFilter.and(salaryQFilter.or(bizItemQFilter));
        QFilter orgControlFilter = new QFilter("isorgcontrol", "=", (Object)Boolean.FALSE);
        QFilter useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (Long)orgId);
        if (null != useOrgQFilter) {
            useOrgQFilter.and(new QFilter("isorgcontrol", "=", (Object)Boolean.TRUE));
            orgControlFilter.or(useOrgQFilter);
        }
        return accHelper.query(fields, new QFilter[]{qFilter, orgControlFilter});
    }

    private void assembleSingleCustFetchConfig(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, Long configId, List<String> fetchItemCodeList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_custfetchconfig");
        QFilter filter = new QFilter("id", "=", (Object)configId);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        String queryFields = "id,number,name,enable,areatype,country,dimensionality,fetchtype,calculationfetch,description,fetchpath,fetchfieldentry.outputparam,fetchfieldentry.outputparamname,fetchfieldentry.srctype,fetchfieldentry.srcentity,fetchfieldentry.srcenum,fetchfieldentry.srcfieldnum,inputfieldentry.inputparam,inputfieldentry.inputparamname,inputfieldentry.inputparamdatatype,inputfieldentry.inputparamitemtype,inputfieldentry.inputparamfixedvalue,inputfieldentry.inputparamfetchitem,inputfieldentry.inputdescription";
        DynamicObject fetchConfig = helper.queryOne(queryFields, new QFilter[]{filter, filter});
        if (fetchConfig == null) {
            log.info("fetchConfig is null");
            return;
        }
        CalFetchConfigInfo info = new CalFetchConfigInfo(Long.valueOf(fetchConfig.getLong("id")), fetchConfig.getString("number"), "2", Boolean.FALSE, fetchConfig.getString("dimensionality"), fetchConfig.getString("fetchpath"));
        ArrayList<FetchFieldInfo> fieldInfoList = new ArrayList<FetchFieldInfo>(10);
        FetchConfigFilterInfo filterInfo = new FetchConfigFilterInfo();
        this.assembleCustFieldList(filterConfig, fetchItemDataTypeMap, fieldInfoList, fetchConfig, fetchItemCodeList);
        List<String> fieldItemCode = fieldInfoList.stream().map(FetchFieldInfo::getFetchItemCode).collect(Collectors.toList());
        fieldFetchItem.addAll(fieldItemCode);
        log.info("fieldFetchItem:{}", (Object)fieldFetchItem.toString());
        this.assembleConfigFilterInfo(fieldItemCode, fetchItemDataTypeMap, fieldFetchItem, configInfoMap, configIdList, filterConfigIdList, fetchItemCodeList, "2", filterInfo, fetchConfig);
        info.setFieldInfoList(fieldInfoList);
        info.setProration(false);
        info.setFilterInfo(filterInfo);
        configInfoMap.put(configId, info);
    }

    private void assembleCustFieldList(boolean filterConfig, Map<String, String> fetchItemDataTypeMap, List<FetchFieldInfo> fieldInfoList, DynamicObject fetchSingle, List<String> fetchItemCodeList) {
        DynamicObjectCollection dynamicObjectCollection = fetchSingle.getDynamicObjectCollection("fetchfieldentry");
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return;
        }
        List<Long> fieldEntryIdList = dynamicObjectCollection.stream().map(param -> param.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection fetchConfigItemByEntryIds = this.getFetchConfigItemByEntryIds(fieldEntryIdList);
        Map<Long, DynamicObject> fetchfieldentryMap = fetchConfigItemByEntryIds.stream().collect(Collectors.toMap(key -> key.getLong("fetchfieldentry"), value -> value, (v1, v2) -> v2));
        DynamicObject custEntryInfo = null;
        String uniqueCode = null;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            custEntryInfo = fetchfieldentryMap.get(dynamicObject.getLong("id"));
            if (custEntryInfo == null || !fetchItemCodeList.contains(uniqueCode = custEntryInfo.getString("fetchitem.uniquecode"))) continue;
            FetchFieldInfo fieldInfo = new FetchFieldInfo();
            fieldInfo.setField(dynamicObject.getString("outputparam"));
            fieldInfo.setFieldName(dynamicObject.getString("outputparamname"));
            fieldInfo.setFetchItemCode(uniqueCode);
            fieldInfo.setFilterField(filterConfig);
            fieldInfoList.add(fieldInfo);
            fetchItemDataTypeMap.put(uniqueCode, custEntryInfo.getString("fetchitem.datatype.showtype"));
        }
    }

    private void assembleCustFetchFilterEntryList(Map<String, String> fetchItemDataTypeMap, Set<String> fieldFetchItem, Map<Long, CalFetchConfigInfo> configInfoMap, List<String> configIdList, List<String> filterConfigIdList, List<String> fetchItemCodeList, FetchConfigFilterInfo filterInfo, DynamicObject fetchSingle) {
        DynamicObjectCollection dynamicObjectCollection = fetchSingle.getDynamicObjectCollection("inputfieldentry");
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return;
        }
        ArrayList<FilterEntryInfo> filterEntryInfoList = filterInfo.getFilterEntryInfoList();
        if (SWCListUtils.isEmpty((List)filterEntryInfoList)) {
            filterEntryInfoList = new ArrayList<FilterEntryInfo>(10);
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            FilterEntryInfo filterEntryInfo = new FilterEntryInfo();
            filterEntryInfo.setFieldId(dynamicObject.getString("inputparam"));
            filterEntryInfo.setFieldName(dynamicObject.getString("inputparamname"));
            filterEntryInfo.setFieldType(dynamicObject.getString("inputparamdatatype"));
            filterEntryInfo.setValueType(dynamicObject.getString("inputparamitemtype"));
            filterEntryInfo.setDescription(dynamicObject.getString("inputdescription"));
            if (SWCStringUtils.equals((String)"1", (String)dynamicObject.getString("inputparamitemtype"))) {
                filterEntryInfo.setValue(dynamicObject.getString("inputparamfixedvalue"));
            }
            if (SWCStringUtils.equals((String)"2", (String)dynamicObject.getString("inputparamitemtype"))) {
                filterEntryInfo.setValue(dynamicObject.getString("inputparamfetchitem.uniquecode"));
                DynamicObject itemObj = this.getFetchConfigItemByItemId(dynamicObject.getLong("inputparamfetchitem.id"));
                if (itemObj != null) {
                    fetchItemCodeList.add(dynamicObject.getString("inputparamfetchitem.uniquecode"));
                    this.assembleFetchConfig(true, fetchItemDataTypeMap, fieldFetchItem, configIdList, filterConfigIdList, configInfoMap, new DynamicObject[]{itemObj}, fetchItemCodeList);
                }
            }
            filterEntryInfoList.add(filterEntryInfo);
        }
        filterInfo.setFilterEntryInfoList(filterEntryInfoList);
    }
}

