/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.base.FormulaParse;
import kd.swc.hscs.business.cal.fetchdata.FormulaFecthData;
import kd.swc.hscs.business.cal.helper.CalValidSalaryItemHelper;
import kd.swc.hscs.business.cal.helper.HandleCalProrationHelper;
import kd.swc.hscs.business.cal.helper.SalaryCalServiceHelper;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemHelper;
import kd.swc.hscs.business.cal.service.CalService;
import kd.swc.hscs.business.cal.service.CalculationService;
import kd.swc.hscs.business.cal.service.HandleParamsBeforeCalService;
import kd.swc.hscs.common.vo.BatchCalResultParamVO;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.CalRecordVO;
import kd.swc.hscs.common.vo.CalResultVO;
import org.jetbrains.annotations.NotNull;

public class PreTaxCalService {
    private static final Log LOGGER = LogFactory.getLog(PreTaxCalService.class);

    public List<Map<String, Object>> salaryCal(Long calTaskId, List<Long> calPersonIdList, String calType) {
        if (calTaskId == null || calTaskId == 0L || SWCListUtils.isEmpty(calPersonIdList)) {
            LOGGER.error("calTaskId or calPersonIdList is empty.");
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreTaxCalService_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        LOGGER.info("salaryCalPreTax start,calTaskId = {}", (Object)calTaskId);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(calPersonIdList.size());
        try {
            HandleParamsBeforeCalService handleParamsBeforeCalService = new HandleParamsBeforeCalService();
            CalParamCacheInfo calParamCacheInfo = handleParamsBeforeCalService.handleParamsBeforCal(calTaskId, calTaskId, calType);
            CalParamVO calParamVO = PreTaxCalService.getCalParamVO(calTaskId, calParamCacheInfo, calType);
            FormulaParse formulaCalImpl = CalService.createAndGetCalClass(calParamCacheInfo);
            FormulaParse convertFormulaCalImpl = CalService.createConvertCalClass(calParamCacheInfo);
            HandleCalProrationHelper calProrationHelper = new HandleCalProrationHelper(calParamVO, calPersonIdList);
            calProrationHelper.dealProration();
            FormulaFecthData fecthData = new FormulaFecthData(calPersonIdList, calParamVO, calProrationHelper.getFtItemProrateRangeQueryMap(), calProrationHelper.getBsItemProrateRangeQueryMap(), true);
            Map<String, Object> calItemQueryDataMap = fecthData.getCalItemData();
            String traceId = RequestContext.get().getTraceId();
            SalaryCalServiceHelper calServiceHelper = new SalaryCalServiceHelper(calParamVO, traceId);
            CalculationService.setCalServiceHelperProp(calServiceHelper, calItemQueryDataMap, calProrationHelper);
            CalValidSalaryItemHelper calValidSalaryItemHelper = new CalValidSalaryItemHelper(calPersonIdList, calParamVO.getCalTaskId(), calType, traceId);
            BatchCalResultParamVO batchResultVO = new BatchCalResultParamVO();
            HashMap<Long, HashSet<String>> calPersonSLItemRelMap = calValidSalaryItemHelper.getCalPersonAndRelationSIUniqueCodeMap();
            for (Long calPersonId : calPersonIdList) {
                calServiceHelper.salaryItemCal(formulaCalImpl, calPersonId, calPersonSLItemRelMap, calType, convertFormulaCalImpl, batchResultVO);
            }
            DynamicObjectCollection calPersonList = this.getCalPersonRelationData(calPersonIdList, calTaskId);
            Map<Long, Long> calPersonMap = calPersonList.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("salaryfile.id")));
            List calRecordVOList = batchResultVO.getCalRecordList();
            List calResultVOList = batchResultVO.getCalResultList();
            Map<Long, CalRecordVO> calRecordMap = calRecordVOList.stream().collect(Collectors.toMap(CalRecordVO2 -> Long.parseLong(CalRecordVO2.getCalPersonId()), CalRecordVO2 -> CalRecordVO2, (k1, k2) -> k1));
            Map<Long, List<CalResultVO>> calResultMap = calResultVOList.stream().collect(Collectors.groupingBy(obj -> obj.getCalPersonId()));
            HashMap<String, Object> dataMap = null;
            CalRecordVO tempRecord = null;
            List<CalResultVO> calResultList = null;
            for (Long calPersonId : calPersonIdList) {
                dataMap = new HashMap<String, Object>(8);
                tempRecord = calRecordMap.get(calPersonId);
                dataMap.put("calPersonId", calPersonId);
                dataMap.put("salaryFileId", calPersonMap.get(calPersonId));
                if (CalStatusEnum.FAIL.getCode().equals(tempRecord.getCalStatus())) {
                    dataMap.put("success", Boolean.FALSE);
                    dataMap.put("message", tempRecord.getFailMsg());
                    dataMap.put("itemList", new ArrayList(0));
                    result.add(dataMap);
                    continue;
                }
                dataMap.put("success", Boolean.TRUE);
                dataMap.put("message", null);
                calResultList = calResultMap.get(calPersonId);
                if (!SWCListUtils.isEmpty(calResultList)) {
                    dataMap.put("itemList", this.getItemList(calResultList));
                } else {
                    dataMap.put("itemList", new ArrayList(0));
                }
                result.add(dataMap);
            }
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calTaskId));
            String calParamCacheKey = String.format(Locale.ROOT, "CALPARAM_%s_%s", calTaskId, calType);
            appCache.remove(calParamCacheKey);
        }
        catch (Exception ex) {
            LOGGER.error("salaryCalPreTax error", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{0}\u3002", (String)"PreTaxCalService_1", (String)"swc-hscs-business", (Object[])new Object[]{ex.getMessage()})), new Object[0]);
        }
        LOGGER.info("salaryCalPreTax end,calTaskId = {}", (Object)calTaskId);
        return result;
    }

    private DynamicObjectCollection getCalPersonRelationData(List<Long> calPersonIds, Long calTaskId) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIds);
        filter.and(new QFilter("caltask", "=", (Object)calTaskId));
        String selectProperties = "id,salaryfile.id";
        return calTableHelper.queryOriginalCollection(selectProperties, new QFilter[]{filter});
    }

    private List<Map<String, Object>> getItemList(List<CalResultVO> calResultList) {
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(calResultList.size());
        HashMap<String, Object> itemMap = null;
        for (CalResultVO calResult : calResultList) {
            if (calResult.getCalResultValue() == null) continue;
            itemMap = new HashMap<String, Object>(6);
            itemMap.put("salaryItemId", calResult.getSalaryItemId());
            itemMap.put("startDate", SWCDateTimeUtils.format((Date)calResult.getStartDate(), (String)"yyyy-MM-dd"));
            itemMap.put("endDate", SWCDateTimeUtils.format((Date)calResult.getEndDate(), (String)"yyyy-MM-dd"));
            SaveDataTypeEnum dataType = SaveDataTypeEnum.getDataType((String)calResult.getDataShowType());
            switch (dataType) {
                case NUM: {
                    itemMap.put("itemValue", SaveCalItemHelper.getItemBigDecimalResult(calResult.getCalResultValue()));
                    itemMap.put("dataType", DataTypeEnum.NUMBERIC.getDbId());
                    break;
                }
                case DATE: {
                    Date itemValue = null;
                    if (calResult.getCalResultValue() instanceof Long) {
                        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
                        cal.setTimeInMillis((Long)calResult.getCalResultValue());
                        itemValue = cal.getTime();
                    } else {
                        itemValue = (Date)calResult.getCalResultValue();
                    }
                    String value = SWCDateTimeUtils.format((Date)itemValue, (String)"yyyy-MM-dd");
                    itemMap.put("itemValue", value);
                    itemMap.put("dataType", DataTypeEnum.DATE.getDbId());
                    break;
                }
                case TEXT: {
                    itemMap.put("itemValue", SaveCalItemHelper.getItemStringResult(calResult.getCalResultValue()));
                    itemMap.put("dataType", DataTypeEnum.STRING.getDbId());
                    break;
                }
                case AMOUNT: {
                    itemMap.put("itemValue", SaveCalItemHelper.getItemBigDecimalResult(calResult.getCalResultValue()));
                    itemMap.put("dataType", DataTypeEnum.AMOUNT.getDbId());
                    break;
                }
            }
            itemList.add(itemMap);
        }
        return itemList;
    }

    @NotNull
    public static CalParamVO getCalParamVO(Long calTaskId, CalParamCacheInfo calParamCacheInfo, String calType) {
        CalParamVO calParamVO = new CalParamVO();
        calParamVO.setCalBatchId(calTaskId.toString());
        calParamVO.setRecordId(calTaskId.toString());
        calParamVO.setCalTaskId(calTaskId.toString());
        calParamVO.setCalParamMap(calParamCacheInfo);
        calParamVO.setAccMemberMap(calParamCacheInfo.getAccMemberMap());
        calParamVO.setCalType(calType);
        calParamVO.setUniqueCodeMap(calParamCacheInfo.getItemUniqueCodeMap());
        calParamVO.setResultCheck(false);
        return calParamVO;
    }
}

