/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.tax.service;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.enums.TaxDataBizStatusEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.business.cal.tax.service.TaxDataPushService;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.enums.OperationTypeEnum;
import kd.swc.hscs.common.vo.CalOperationVO;

public class TaxDataPullService {
    private static final Log logger = LogFactory.getLog(TaxDataPullService.class);
    private long calTaskId;
    private long calRecordId;
    private long calBatchId;
    private int successCount;
    private int failCount;

    public TaxDataPullService(long calTaskId, long calRecordId, long calBatchId) {
        this.calTaskId = calTaskId;
        this.calRecordId = calRecordId;
        this.calBatchId = calBatchId;
    }

    public void pullTaxData(List<Long> calPersonIdList, boolean resultCheck) {
        logger.info("pullTaxData begin,recordId = {},calBatchId= {}", (Object)this.calRecordId, (Object)this.calBatchId);
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObject[] calPersons = calPersonHelper.query("id,calresultid,calstatus,pushtime,pulltime,taxstatus,salaryfile.id,personhrv.personindexid", new QFilter[]{filter});
        Map<Long, DynamicObject> calPersonMap = null;
        List batchCalPersonIdList = SWCListUtils.split(calPersonIdList, (int)1000);
        for (List tempList : batchCalPersonIdList) {
            calPersonMap = Arrays.stream(calPersons).filter(person -> tempList.contains(person.getLong("id"))).collect(Collectors.toMap(calperson -> calperson.getLong("id"), calperson -> calperson));
            this.batchPullTaxData(tempList, calPersonMap, resultCheck);
        }
        logger.info("pullTaxData end,recordId = {},calBatchId= {}", (Object)this.calRecordId, (Object)this.calBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchPullTaxData(List<Long> calPersonIdList, Map<Long, DynamicObject> calPersonMap, boolean resultCheck) {
        this.successCount = 0;
        this.failCount = 0;
        Date startDate = new Date();
        try {
            this.pullTaxData(calPersonMap, calPersonIdList, resultCheck);
        }
        catch (Exception e) {
            logger.error("push tax error,", (Throwable)e);
            this.successCount = 0;
            this.failCount = calPersonMap.size();
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u4e2a\u7a0e\u9879\u76ee\u6570\u636e\u8fc7\u7a0b\u4e2d\u5904\u7406\u5931\u8d25\u3002", (String)"TaxDataPullService_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            CalOperationHelper.handleFailData(calPersonMap, FailureTypeEnum.PULLTAX_FAIL.getCode(), msg, CalStateEnum.PULLTAX_ERROR.getCode(), this.calTaskId, this.calRecordId);
        }
        finally {
            CalOperationHelper.updateTaxCalProgress(this.successCount, this.failCount, this.calRecordId, this.calTaskId);
            CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), "pullTax", this.successCount, this.failCount);
            CalUtils.addCalOperation(this.calRecordId, this.calBatchId, OperationTypeEnum.PULLTAX.getCode(), startDate, operationVO);
        }
    }

    private void pullTaxData(Map<Long, DynamicObject> calPersonMap, List<Long> calPersonIdList, boolean resultCheck) throws ParseException {
        Map<String, Object> pullParamMap = this.getItemMappingParamsMap(this.calTaskId, this.calRecordId);
        String countryId = (String)pullParamMap.get("country");
        String payDateStr = (String)pullParamMap.get("payDate");
        Date payDate = SWCDateTimeUtils.parseDate((String)payDateStr, (String)"yyyy-MM-dd");
        HashMap<String, Object> pullRequest = new HashMap<String, Object>(6);
        pullRequest.put("srcType", "1");
        pullRequest.put("country", countryId);
        pullRequest.put("payDate", payDate);
        pullRequest.put("langCode", Lang.get().getLangTag());
        pullRequest.put("data", calPersonIdList);
        CalUtils.printLog("invokeGetDataValue request==>", pullRequest);
        Map<String, Object> response = null;
        try {
            response = this.invokeGetDataValue(pullRequest);
        }
        catch (Exception e) {
            logger.error("invokeGetDataValue fail,", (Throwable)e);
            this.successCount = 0;
            this.failCount = calPersonIdList.size();
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u83b7\u53d6\u63a8\u9001\u503c\u63a5\u53e3\u5931\u8d25\u3002", (String)"TaxDataPullService_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            CalOperationHelper.handleFailData(calPersonMap, FailureTypeEnum.PULLTAX_FAIL.getCode(), msg, CalStateEnum.PULLTAX_ERROR.getCode(), this.calTaskId, this.calRecordId);
            return;
        }
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        CalUtils.printLog("invokeGetDataValue response==>", response);
        if (!((Boolean)response.get("success")).booleanValue()) {
            logger.info("invokeTaxCal response fail");
            this.successCount = 0;
            this.failCount = calPersonIdList.size();
            CalOperationHelper.handleFailData(calPersonMap, FailureTypeEnum.PULLTAX_FAIL.getCode(), (String)response.get("message"), CalStateEnum.PULLTAX_ERROR.getCode(), this.calTaskId, this.calRecordId);
            return;
        }
        HashMap<Long, Map<String, String>> calPersonItemValMap = new HashMap<Long, Map<String, String>>(calPersonMap.size());
        HashMap<Long, Long> taxCurrencyMap = new HashMap<Long, Long>(16);
        this.handleResponseData((List)response.get("data"), calPersonMap, calPersonItemValMap, taxCurrencyMap);
        DynamicObject[] updateCalTableArray = CalOperationHelper.addCalTableEntryDataAndReturn(pullParamMap, calPersonItemValMap, calPersonMap, taxCurrencyMap, this.calTaskId, false, new HashMap<Long, Map<String, Object>>());
        DynamicObject[] updateCalPersonArray = new DynamicObject[calPersonMap.size()];
        calPersonMap.values().toArray(updateCalPersonArray);
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            if (updateCalPersonArray.length > 0) {
                helper.update(updateCalPersonArray);
            }
            helper.setEntityName("hsas_caltable");
            if (updateCalTableArray.length > 0) {
                helper.update(updateCalTableArray);
            }
            this.successCount = calPersonIdList.size();
            txHandle.commit();
        }
        CalUtils.invokeTaxUpdateSrcDataStatus(calPersonIdList, countryId, payDate, TaxDataBizStatusEnum.NEW.getCode());
        CalOperationHelper.autoCalAfterTax(calPersonIdList, this.calTaskId, this.calRecordId, this.calBatchId, resultCheck, false, new HashMap<Long, Map<String, Object>>());
    }

    private void handleResponseData(List<Map<String, Object>> data, Map<Long, DynamicObject> calPersonMap, Map<Long, Map<String, String>> calPersonItemValMap, Map<Long, Long> taxCurrencyMap) {
        DynamicObject calPerson = null;
        String calPersonId = null;
        List itemList = null;
        String currency = null;
        for (Map<String, Object> dataMap : data) {
            calPersonId = (String)dataMap.get("srcDataKey");
            calPerson = calPersonMap.get(Long.valueOf(calPersonId));
            currency = (String)dataMap.get("currency");
            itemList = (List)dataMap.get("items");
            calPerson.set("calstatus", (Object)CalStateEnum.TAX_CALED.getCode());
            calPerson.set("taxstatus", (Object)TaxStateEnum.PULLED.getCode());
            calPerson.set("pulltime", (Object)new Date());
            calPersonItemValMap.put(Long.valueOf(calPersonId), this.getTaxItemValue(itemList));
            taxCurrencyMap.put(Long.valueOf(calPersonId), Long.valueOf(currency));
        }
    }

    private Map<String, String> getTaxItemValue(List<Map<String, Object>> taxItemList) {
        if (SWCListUtils.isEmpty(taxItemList)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> taxItemValueMap = new HashMap<String, String>(taxItemList.size());
        for (Map<String, Object> tempMap : taxItemList) {
            taxItemValueMap.put(tempMap.get("taxItemId") + "@@" + tempMap.get("taxCategoryId"), String.valueOf(tempMap.get("itemValue")));
        }
        return taxItemValueMap;
    }

    private Map<String, Object> invokeGetDataValue(Map<String, Object> pullRequest) {
        return (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"getDataValue", (Object[])new Object[]{pullRequest});
    }

    private Map<String, Object> getItemMappingParamsMap(long calTaskId, long calRecordId) {
        TaxDataPushService pushService = new TaxDataPushService(calTaskId, calRecordId, this.calBatchId);
        return pushService.getMethodParamFromCache(calTaskId, calRecordId);
    }
}

