/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.tax.service;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.enums.OperationTypeEnum;
import kd.swc.hscs.common.vo.CalOperationVO;

public class TaxDataPushService {
    private static final Log logger = LogFactory.getLog(TaxDataPushService.class);
    private int successCount;
    private int failCount;
    private long calTaskId;
    private long calRecordId;
    private long calBatchId;
    private boolean isSyncCal = false;
    private Map<Long, Map<String, Object>> responseMap;

    public TaxDataPushService(long calTaskId, long calRecordId, long calBatchId) {
        this.calTaskId = calTaskId;
        this.calRecordId = calRecordId;
        this.calBatchId = calBatchId;
        this.isSyncCal = false;
        this.responseMap = new HashMap<Long, Map<String, Object>>();
    }

    public TaxDataPushService(long calTaskId, long calRecordId, long calBatchId, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) {
        this.calTaskId = calTaskId;
        this.calRecordId = calRecordId;
        this.calBatchId = calBatchId;
        this.isSyncCal = isSyncCal;
        this.responseMap = responseMap;
    }

    public void pushTax(List<Long> calPersonIdList, boolean resultCheck) {
        logger.info("pushTax begin,recordId = {},calBatchId={}", (Object)this.calRecordId, (Object)this.calBatchId);
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObject[] calPersons = calPersonHelper.query("id,calresultid,calstatus,pushtime,pulltime,empnumber,name,filenumber,taxstatus,salaryfile.id,personhrv.personindexid", new QFilter[]{filter});
        Map<Long, DynamicObject> calPersonMap = null;
        List batchCalPersonIdList = SWCListUtils.split(calPersonIdList, (int)500);
        for (List tempList : batchCalPersonIdList) {
            calPersonMap = Arrays.stream(calPersons).filter(person -> tempList.contains(person.getLong("id"))).collect(Collectors.toMap(calperson -> calperson.getLong("id"), calperson -> calperson));
            this.batchPushTax(calPersonMap, resultCheck);
        }
        logger.info("pushTax end,recordId = {},calBatchId={}", (Object)this.calRecordId, (Object)this.calBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchPushTax(Map<Long, DynamicObject> calPersonMap, boolean resultCheck) {
        this.successCount = 0;
        this.failCount = 0;
        Date startDate = new Date();
        try {
            this.pushTax(calPersonMap, resultCheck);
        }
        catch (Exception e) {
            block7: {
                try {
                    logger.error("push tax error,", (Throwable)e);
                    this.successCount = 0;
                    this.failCount = calPersonMap.size();
                    String msg = ResManager.loadKDString((String)"\u63a8\u9001\u4e2a\u7a0e\u8fc7\u7a0b\u4e2d\uff0c\u5904\u7406\u5931\u8d25\u3002", (String)"TaxDataPushService_1", (String)"swc-hscs-business", (Object[])new Object[0]);
                    CalOperationHelper.handleFailData(calPersonMap, FailureTypeEnum.PUSHTAX_FAIL.getCode(), msg, CalStateEnum.PUSHTAX_ERROR.getCode(), this.calTaskId, this.calRecordId);
                    if (!this.isSyncCal) break block7;
                    List<Long> calPersonIdList = calPersonMap.keySet().stream().collect(Collectors.toList());
                    CalOperationHelper.putTempDataToResponse(new HashMap<Long, Map<String, Object>>(0), this.responseMap, false, msg, calPersonIdList);
                }
                catch (Throwable throwable) {
                    CalOperationHelper.updateTaxCalProgress(this.successCount, this.failCount, this.calRecordId, this.calTaskId);
                    ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.calRecordId));
                    boolean isFinish = FormulaCacheUtils.updatePushDataToTaxCount((ISWCAppCache)calProgressAppCache, (int)0, (int)calPersonMap.size(), (long)this.calRecordId);
                    if (isFinish) {
                        DynamicObject calTask = this.getCalTaskInfo(this.calTaskId);
                        CalOperationHelper.invokeTaxReleaseOpResource(String.valueOf(this.calRecordId), String.valueOf(calTask.getLong("country.id")));
                    }
                    CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), "taxCal", this.successCount, this.failCount);
                    CalUtils.addCalOperation(this.calRecordId, this.calBatchId, OperationTypeEnum.PUSHTAX.getCode(), startDate, operationVO);
                    throw throwable;
                }
            }
            CalOperationHelper.updateTaxCalProgress(this.successCount, this.failCount, this.calRecordId, this.calTaskId);
            ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.calRecordId));
            boolean isFinish = FormulaCacheUtils.updatePushDataToTaxCount((ISWCAppCache)calProgressAppCache, (int)0, (int)calPersonMap.size(), (long)this.calRecordId);
            if (isFinish) {
                DynamicObject calTask = this.getCalTaskInfo(this.calTaskId);
                CalOperationHelper.invokeTaxReleaseOpResource(String.valueOf(this.calRecordId), String.valueOf(calTask.getLong("country.id")));
            }
            CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), "taxCal", this.successCount, this.failCount);
            CalUtils.addCalOperation(this.calRecordId, this.calBatchId, OperationTypeEnum.PUSHTAX.getCode(), startDate, operationVO);
        }
        CalOperationHelper.updateTaxCalProgress(this.successCount, this.failCount, this.calRecordId, this.calTaskId);
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.calRecordId));
        boolean isFinish = FormulaCacheUtils.updatePushDataToTaxCount((ISWCAppCache)calProgressAppCache, (int)0, (int)calPersonMap.size(), (long)this.calRecordId);
        if (isFinish) {
            DynamicObject calTask = this.getCalTaskInfo(this.calTaskId);
            CalOperationHelper.invokeTaxReleaseOpResource(String.valueOf(this.calRecordId), String.valueOf(calTask.getLong("country.id")));
        }
        CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), "taxCal", this.successCount, this.failCount);
        CalUtils.addCalOperation(this.calRecordId, this.calBatchId, OperationTypeEnum.PUSHTAX.getCode(), startDate, operationVO);
    }

    private void pushTax(Map<Long, DynamicObject> calPersonMap, boolean resultCheck) throws ParseException {
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        Map<String, Object> pushParamMap = this.getMethodParamFromCache(this.calTaskId, this.calRecordId);
        String country = (String)pushParamMap.get("country");
        String payDateStr = (String)pushParamMap.get("payDate");
        Date payDate = SWCDateTimeUtils.parseDate((String)payDateStr, (String)"yyyy-MM-dd");
        HashMap<Long, String> errorDataMap = new HashMap<Long, String>(16);
        DynamicObjectCollection calPersonList = new DynamicObjectCollection();
        Map<Long, Map<String, Long>> salaryFileRelMap = this.getSalaryTaxFileRelMap(payDate, calPersonMap, Long.valueOf(country), errorDataMap, calPersonList);
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        if (salaryFileRelMap.size() == 0) {
            this.successCount = 0;
            this.failCount = errorDataMap.size();
            this.saveExceptionData(errorDataMap, calPersonList);
            return;
        }
        Map<String, Object> pushTaxRequest = this.packagePushTaxRequest(pushParamMap, calPersonMap, salaryFileRelMap, errorDataMap, calPersonList);
        if (calPersonMap.size() == 0) {
            this.successCount = 0;
            this.failCount = errorDataMap.size();
            this.saveExceptionData(errorDataMap, calPersonList);
            return;
        }
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        Map<String, Object> response = null;
        CalUtils.printLog("pushTax request==>", pushTaxRequest);
        try {
            response = this.invokeTaxCal(pushTaxRequest);
        }
        catch (Exception e) {
            logger.error("invokeTaxCal fail", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u8ba1\u7b97\u63a5\u53e3\u5931\u8d25\u3002", (String)"TaxDataPushService_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            this.dealPushTaxFailData(calPersonMap, errorDataMap, calPersonList, msg);
            this.successCount = 0;
            this.failCount = errorDataMap.size();
            this.saveExceptionData(errorDataMap, calPersonList);
            return;
        }
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        CalUtils.printLog("pushTax response==>", response);
        if (!((Boolean)response.get("success")).booleanValue()) {
            logger.info("invokeTaxCal response fail");
            this.dealPushTaxFailData(calPersonMap, errorDataMap, calPersonList, (String)response.get("message"));
            this.successCount = 0;
            this.failCount = errorDataMap.size();
            this.saveExceptionData(errorDataMap, calPersonList);
            return;
        }
        this.failCount = errorDataMap.size();
        HashMap<Long, Map<String, String>> calPersonItemValMap = new HashMap<Long, Map<String, String>>(calPersonMap.size());
        String currencyStr = String.valueOf(response.get("currency"));
        Long oriCurrencyId = Long.parseLong(currencyStr);
        List<Long> calAfterTaxIdList = this.handleResponseData((List)response.get("data"), calPersonMap, errorDataMap, calPersonItemValMap, calPersonList);
        HashMap<Long, Long> taxCurrencyMap = new HashMap<Long, Long>(16);
        calPersonItemValMap.keySet().stream().forEach(obj -> taxCurrencyMap.put((Long)obj, oriCurrencyId));
        HashMap<Long, Map<String, Object>> tempResponseMap = new HashMap<Long, Map<String, Object>>(16);
        DynamicObject[] updateCalTableArray = CalOperationHelper.addCalTableEntryDataAndReturn(pushParamMap, calPersonItemValMap, calPersonMap, taxCurrencyMap, this.calTaskId, this.isSyncCal, tempResponseMap);
        DynamicObject[] updateCalDetaiailArray = this.getUpdateCalDetailData(errorDataMap, this.calTaskId, this.calRecordId, FailureTypeEnum.CALTAX_FAIL.getCode());
        this.handleErrorData(tempResponseMap, errorDataMap);
        Object[] updateCalPersonArray = new DynamicObject[calPersonList.size()];
        calPersonList.toArray(updateCalPersonArray);
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        List<Long> personIndexIdList = this.getPersonIndexIdList(errorDataMap, calPersonList);
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
            if (updateCalDetaiailArray.length > 0) {
                helper.update(updateCalDetaiailArray);
            }
            if (updateCalTableArray.length > 0) {
                helper.setEntityName("hsas_caltable");
                helper.update(updateCalTableArray);
            }
            helper.setEntityName("hsas_calperson");
            helper.update((DynamicObject[])updateCalPersonArray);
            if (personIndexIdList.size() > 0) {
                CalUtils.deleteSalaryCalMutexData(personIndexIdList, this.calTaskId);
            }
            txHandle.commit();
        }
        if (this.isSyncCal) {
            CalOperationHelper.putTempDataToResponse(tempResponseMap, this.responseMap, true, null, new ArrayList<Long>(0));
        }
        if (calAfterTaxIdList.size() > 0) {
            CalOperationHelper.autoCalAfterTax(calAfterTaxIdList, this.calTaskId, this.calRecordId, this.calBatchId, resultCheck, this.isSyncCal, this.responseMap);
        }
    }

    private List<Long> getPersonIndexIdList(Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList) {
        if (errorDataMap.size() == 0) {
            return new ArrayList<Long>(0);
        }
        Map<Long, DynamicObject> calPersonMap = calPersonList.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(errorDataMap.size());
        DynamicObject calPerson = null;
        for (Map.Entry<Long, String> entry : errorDataMap.entrySet()) {
            calPerson = calPersonMap.get(entry.getKey());
            if (calPerson == null) continue;
            personIndexIdList.add(calPerson.getLong("personhrv.personindexid"));
        }
        return personIndexIdList;
    }

    private void saveExceptionData(Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList) {
        if (CalUtils.isTerminationCal(this.calRecordId)) {
            return;
        }
        DynamicObject[] updateCalDetaiailArray = this.getUpdateCalDetailData(errorDataMap, this.calTaskId, this.calRecordId, FailureTypeEnum.PUSHTAX_FAIL.getCode());
        Object[] updateCalPersonArray = new DynamicObject[calPersonList.size()];
        calPersonList.toArray(updateCalPersonArray);
        List<Long> personIndexIdList = calPersonList.stream().map(obj -> obj.getLong("personhrv.personindexid")).collect(Collectors.toList());
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
            if (updateCalDetaiailArray.length > 0) {
                helper.update(updateCalDetaiailArray);
            }
            helper.setEntityName("hsas_calperson");
            helper.update((DynamicObject[])updateCalPersonArray);
            CalUtils.deleteSalaryCalMutexData(personIndexIdList, this.calTaskId);
        }
        this.handleErrorData(this.responseMap, errorDataMap);
    }

    private void handleErrorData(Map<Long, Map<String, Object>> responseMap, Map<Long, String> errorDataMap) {
        if (!this.isSyncCal) {
            return;
        }
        for (Map.Entry<Long, String> entry : errorDataMap.entrySet()) {
            Map<String, Object> tempMap = responseMap.get(entry.getKey());
            if (tempMap == null) {
                tempMap = new HashMap<String, Object>();
                tempMap.put("success", false);
                tempMap.put("status", 400);
                tempMap.put("message", entry.getValue());
                tempMap.put("calPersonId", entry.getKey());
                responseMap.put(entry.getKey(), tempMap);
                continue;
            }
            tempMap.put("success", false);
            tempMap.put("message", entry.getValue());
            if (tempMap.get("itemList") != null) {
                tempMap.put("status", 100);
                continue;
            }
            tempMap.put("status", 400);
        }
    }

    private DynamicObject[] getUpdateCalDetailData(Map<Long, String> errorDataMap, long calTaskId, long calRecordId, String failType) {
        Map<Long, DynamicObject> calDetailMap = CalOperationHelper.getCalDetailsDataMap(errorDataMap.keySet(), calTaskId, calRecordId);
        DynamicObject calDetail = null;
        DynamicObject[] updateCalDetaiailArray = new DynamicObject[errorDataMap.size()];
        int index = 0;
        for (Map.Entry<Long, String> entry : errorDataMap.entrySet()) {
            calDetail = calDetailMap.get(entry.getKey());
            calDetail.set("failtype", (Object)failType);
            calDetail.set("errorelement", (Object)"-");
            calDetail.set("failmsg", (Object)entry.getValue());
            calDetail.set("calstatus", (Object)CalStatusEnum.FAIL.getCode());
            updateCalDetaiailArray[index] = calDetail;
            ++index;
        }
        return updateCalDetaiailArray;
    }

    public List<Long> handleResponseData(List<Map<String, Object>> data, Map<Long, DynamicObject> calPersonMap, Map<Long, String> errorDataMap, Map<Long, Map<String, String>> calPersonItemValMap, DynamicObjectCollection calPersonList) {
        DynamicObject calPerson = null;
        String calPersonId = null;
        ArrayList<Long> calAfterTaxIdList = new ArrayList<Long>(10);
        List itemList = null;
        Integer status = null;
        for (Map<String, Object> dataMap : data) {
            calPersonId = (String)dataMap.get("dataKey");
            calPerson = calPersonMap.get(Long.valueOf(calPersonId));
            status = (Integer)dataMap.get("status");
            if (status >= 200 && status < 400) {
                itemList = (List)dataMap.get("items");
                calPerson.set("calstatus", (Object)CalStateEnum.TAX_CALED.getCode());
                calPerson.set("taxstatus", (Object)TaxStateEnum.PULLED.getCode());
                calPerson.set("pushtime", (Object)new Date());
                calPerson.set("pulltime", (Object)new Date());
                calPersonItemValMap.put(Long.valueOf(calPersonId), this.getTaxItemValue(itemList));
                calAfterTaxIdList.add(Long.valueOf(calPersonId));
                ++this.successCount;
            } else if (status >= 100 && status < 200) {
                calPerson.set("taxstatus", (Object)TaxStateEnum.PUSHED.getCode());
                calPerson.set("pushtime", (Object)new Date());
            } else if (status >= 400) {
                errorDataMap.put(Long.valueOf(calPersonId), (String)dataMap.get("message"));
                calPerson.set("calstatus", (Object)CalStateEnum.TAXCAL_ERROR.getCode());
                ++this.failCount;
            }
            calPersonList.add((Object)calPerson);
        }
        return calAfterTaxIdList;
    }

    private Map<String, String> getTaxItemValue(List<Map<String, Object>> taxItemList) {
        if (SWCListUtils.isEmpty(taxItemList)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> taxItemValueMap = new HashMap<String, String>(taxItemList.size());
        for (Map<String, Object> tempMap : taxItemList) {
            taxItemValueMap.put(tempMap.get("taxItem") + "@@" + tempMap.get("taxCategory"), String.valueOf(tempMap.get("itemValue")));
        }
        return taxItemValueMap;
    }

    private Map<String, Object> invokeTaxCal(Map<String, Object> pushTaxRequest) {
        return (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"calculate", (Object[])new Object[]{pushTaxRequest});
    }

    public Map<String, Object> getMethodParamFromCache(long calTaskId, long recordId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_PUSH_%s", recordId));
        String paramJson = (String)appCache.get(String.format(Locale.ROOT, "SWC_PUSH_%s", recordId), String.class);
        if (SWCStringUtils.isNotEmpty((String)paramJson)) {
            return (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
        }
        return this.getMethodParamFromDB(calTaskId, recordId, appCache);
    }

    private Map<String, Object> getMethodParamFromDB(long calTaskId, long recordId, ISWCAppCache appCache) {
        DynamicObject calTask = this.getCalTaskInfo(calTaskId);
        HashMap<String, String> salaryItemInfoMap = new HashMap<String, String>(16);
        Map<String, List<Long>> itemMap = this.getSourceOrResultItemMap(calTask.getLong("calrulev.id"), salaryItemInfoMap);
        HashMap<String, Object> pushParamMap = new HashMap<String, Object>(16);
        this.buildTaxProjSchemeData(calTask.getLong("taxitemschemev.id"), itemMap.get("preSalaryItemIdList"), itemMap.get("afterSalaryItemIdList"), pushParamMap);
        pushParamMap.put("payDate", SWCDateTimeUtils.format((Date)calTask.getDate("paydate"), (String)"yyyy-MM-dd"));
        pushParamMap.put("startDate", SWCDateTimeUtils.format((Date)calTask.getDate("startdate"), (String)"yyyy-MM-dd"));
        pushParamMap.put("endDate", SWCDateTimeUtils.format((Date)calTask.getDate("enddate"), (String)"yyyy-MM-dd"));
        pushParamMap.put("country", String.valueOf(calTask.getLong("country.id")));
        pushParamMap.put("calTaskName", calTask.getString("name"));
        pushParamMap.put("calTaskNumber", calTask.getString("number"));
        pushParamMap.put("currency", String.valueOf(calTask.getLong("payrollgroupv.currency.id")));
        pushParamMap.put("exratetable", String.valueOf(calTask.getLong("payrollgroupv.exratetable.id")));
        pushParamMap.put("afterSalaryItemIdList", itemMap.get("afterSalaryItemIdList"));
        pushParamMap.put("preSalaryItemIdList", itemMap.get("preSalaryItemIdList"));
        pushParamMap.put("salaryItemInfoMap", salaryItemInfoMap);
        pushParamMap.put("exratedate", SWCDateTimeUtils.format((Date)calTask.getDate("exratedate"), (String)"yyyy-MM-dd"));
        appCache.put(String.format(Locale.ROOT, "SWC_PUSH_%s", recordId), (Object)SerializationUtils.toJsonString(pushParamMap));
        return pushParamMap;
    }

    private DynamicObject getCalTaskInfo(long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return helper.queryOriginalOne("number,name,startdate,enddate,calrulev.id,country.id,paydate,exratedate,payrollgroupv.currency.id,payrollgroupv.exratetable.id,taxitemschemev.id", (Object)calTaskId);
    }

    private DynamicObjectCollection getCaltableResultData(List<Long> calTableIdList, List<Long> preSalaryItemIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("hsas_caltableentry.salaryitem.id", "in", preSalaryItemIdList);
        filter.and("hsas_caltableentry.slprorationindex", "=", (Object)0);
        String fields = "id,calpersonid,hsas_caltableentry.salaryitem.id,hsas_caltableentry.salaryitem.datatype.id,hsas_caltableentry.numvalue,hsas_caltableentry.datevalue,hsas_caltableentry.calamountvalue,hsas_caltableentry.textvalue";
        return helper.queryOriginalCollection(fields, new QFilter[]{filter});
    }

    public Map<String, Object> packagePushTaxRequest(Map<String, Object> pushParamMap, Map<Long, DynamicObject> calPersonMap, Map<Long, Map<String, Long>> salaryFileRelMap, Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList) {
        HashMap<String, Object> pushTaxRequest = new HashMap<String, Object>(16);
        String country = (String)pushParamMap.get("country");
        List preSalaryItemIdList = (List)pushParamMap.get("preSalaryItemIdList");
        List<Long> calTableIdList = calPersonMap.values().stream().map(calPerson -> calPerson.getLong("calresultid")).collect(Collectors.toList());
        DynamicObjectCollection calTableCollection = this.getCaltableResultData(calTableIdList, preSalaryItemIdList);
        Map<Long, List<DynamicObject>> calTableDataMap = calTableCollection.stream().collect(Collectors.groupingBy(calTable -> calTable.getLong("id")));
        HashMap<Long, String> tempErrorMap = new HashMap<Long, String>(16);
        String msg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u65e0\u6cd5\u5339\u914d\u5230\u5bf9\u5e94\u7eb3\u7a0e\u4eba\u7c7b\u578b\u548c\u4e2a\u7a0e\u79cd\u7c7b\u7684\u4e2a\u7a0e\u9879\u76ee\uff0c\u8bf7\u5728\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"TaxDataPushService_5", (String)"swc-hscs-business", (Object[])new Object[0]);
        String noDataMsg = ResManager.loadKDString((String)"\u6240\u6709\u4e2a\u7a0e\u6e90\u9879\u76ee\u5747\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63a8\u9001\u3002", (String)"TaxDataPushService_6", (String)"swc-hscs-business", (Object[])new Object[0]);
        ArrayList dataList = new ArrayList(calPersonMap.size());
        Long taxPayerTypeId = null;
        HashMap<String, Object> data = null;
        DynamicObject calPerson2 = null;
        List<DynamicObject> tempCalTableList = null;
        List<Map<String, Object>> itemList = null;
        Map<String, Long> taxFileInfoMap = null;
        HashSet<String> errorSalaryItemNameSet = null;
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            data = new HashMap<String, Object>(16);
            calPerson2 = entry.getValue();
            taxFileInfoMap = salaryFileRelMap.get(calPerson2.getLong("salaryfile.id"));
            if (taxFileInfoMap == null) continue;
            taxPayerTypeId = taxFileInfoMap.get("taxpayertype");
            data.put("srcDataKey", String.valueOf(entry.getKey()));
            data.put("taxFile", String.valueOf(taxFileInfoMap.get("taxfile")));
            data.put("taxUnit", String.valueOf(taxFileInfoMap.get("taxunit")));
            data.put("salaryFileNumber", calPerson2.getString("filenumber"));
            data.put("salaryPersonNumber", calPerson2.getString("filenumber"));
            data.put("salaryPersonName", calPerson2.getString("name"));
            tempCalTableList = calTableDataMap.get(calPerson2.getLong("calresultid"));
            if (tempCalTableList == null || tempCalTableList.size() == 0) {
                tempErrorMap.put(entry.getKey(), noDataMsg);
                continue;
            }
            errorSalaryItemNameSet = new HashSet<String>(16);
            itemList = this.getItemDataMapList(tempCalTableList, pushParamMap, taxPayerTypeId, errorSalaryItemNameSet);
            if (SWCListUtils.isEmpty(itemList)) {
                tempErrorMap.put(entry.getKey(), MessageFormat.format(msg, SWCListUtils.join(errorSalaryItemNameSet, (String)",")));
                continue;
            }
            data.put("items", itemList);
            dataList.add(data);
        }
        pushTaxRequest.put("srcType", "1");
        pushTaxRequest.put("calTaskNumber", pushParamMap.get("calTaskNumber"));
        pushTaxRequest.put("calTaskName", pushParamMap.get("calTaskName"));
        pushTaxRequest.put("belongStartDate", pushParamMap.get("startDate"));
        pushTaxRequest.put("belongEndDate", pushParamMap.get("endDate"));
        pushTaxRequest.put("payDate", pushParamMap.get("payDate"));
        pushTaxRequest.put("country", country);
        pushTaxRequest.put("currency", pushParamMap.get("currency"));
        pushTaxRequest.put("operator", RequestContext.get().getCurrUserId());
        pushTaxRequest.put("langCode", Lang.get().getLangTag());
        pushTaxRequest.put("operateKey", String.valueOf(this.calRecordId));
        pushTaxRequest.put("data", dataList);
        this.handleCheckNoPassData(tempErrorMap, calPersonMap, calPersonList);
        errorDataMap.putAll(tempErrorMap);
        return pushTaxRequest;
    }

    private void handleCheckNoPassData(Map<Long, String> tempErrorMap, Map<Long, DynamicObject> calPersonMap, DynamicObjectCollection calPersonList) {
        if (tempErrorMap.size() == 0) {
            return;
        }
        DynamicObject calPerson = null;
        for (Map.Entry<Long, String> entry : tempErrorMap.entrySet()) {
            calPerson = calPersonMap.remove(entry.getKey());
            if (calPerson == null) continue;
            calPerson.set("calstatus", (Object)CalStateEnum.PUSHTAX_ERROR.getCode());
            calPersonList.add((Object)calPerson);
        }
    }

    public Map<Long, Map<String, Long>> getSalaryTaxFileRelMap(Date payDate, Map<Long, DynamicObject> calPersonMap, Long countryId, Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList) {
        HashMap<Long, Map<String, Long>> salaryFileRelMap = new HashMap<Long, Map<String, Long>>(16);
        Set<Long> salaryFileIdSet = calPersonMap.values().stream().map(calPerson -> calPerson.getLong("salaryfile.id")).collect(Collectors.toSet());
        DynamicObjectCollection list = CalOperationHelper.getSalaryTaxFileRelData(salaryFileIdSet);
        Map<Long, List<DynamicObject>> fileMap = list.stream().collect(Collectors.groupingBy(obj -> obj.getLong("salaryfile.id")));
        Map<Long, DynamicObject> salaryFileMap = calPersonMap.values().stream().collect(Collectors.toMap(obj -> obj.getLong("salaryfile.id"), obj -> obj));
        Set<Long> hasRelFileIdSet = list.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toSet());
        salaryFileIdSet.removeAll(hasRelFileIdSet);
        if (salaryFileIdSet.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u6ca1\u6709\u5173\u8054\u4e2a\u7a0e\u6863\u6848\u3002", (String)"TaxDataPushService_3", (String)"swc-hscs-business", (Object[])new Object[0]);
            this.dealQueryTaxFileFailData(calPersonMap, errorDataMap, calPersonList, salaryFileIdSet, msg, salaryFileMap);
        }
        if (hasRelFileIdSet.size() == 0) {
            return salaryFileRelMap;
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        ArrayList dataList = new ArrayList(10);
        HashMap<String, Object> tempMap = null;
        DynamicObject tempCalPerson = null;
        for (Map.Entry<Long, List<DynamicObject>> entry : fileMap.entrySet()) {
            tempMap = new HashMap<String, Object>(3);
            tempMap.put("salaryFile", entry.getKey());
            tempCalPerson = salaryFileMap.get(entry.getKey());
            tempMap.put("srcDataKey", String.valueOf(tempCalPerson.getLong("id")));
            tempMap.put("taxFiles", entry.getValue().stream().map(obj -> obj.getLong("taxfile")).collect(Collectors.toSet()));
            dataList.add(tempMap);
        }
        ArrayList<String> propList = new ArrayList<String>(2);
        propList.add("taxpayertype");
        propList.add("taxunit");
        requestMap.put("props", propList);
        requestMap.put("operateKey", String.valueOf(this.calRecordId));
        requestMap.put("country", countryId);
        requestMap.put("srcType", "1");
        requestMap.put("payDate", payDate);
        requestMap.put("operator", RequestContext.get().getCurrUserId());
        requestMap.put("langCode", Lang.get().getLangTag());
        requestMap.put("data", dataList);
        CalUtils.printLog("matchTaxFiles request==>", requestMap);
        Map response = null;
        try {
            response = (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"matchCalTaxFiles", (Object[])new Object[]{requestMap});
        }
        catch (Exception e) {
            logger.error("matchTaxFiles error,", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u4e2a\u7a0e\u6863\u6848\u63a5\u53e3\u5931\u8d25\u3002", (String)"TaxDataPushService_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            this.dealQueryTaxFileFailData(calPersonMap, errorDataMap, calPersonList, hasRelFileIdSet, msg, salaryFileMap);
            return salaryFileRelMap;
        }
        logger.info("matchTaxFiles end");
        if (!((Boolean)response.get("success")).booleanValue()) {
            logger.info("matchCalTaxFiles response fail");
            this.dealQueryTaxFileFailData(calPersonMap, errorDataMap, calPersonList, hasRelFileIdSet, (String)response.get("message"), salaryFileMap);
            return salaryFileRelMap;
        }
        List resultDataList = (List)response.get("data");
        String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u5173\u8054\u7684\u4e2a\u7a0e\u6863\u6848\u5728\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u6709\u6548\u7684\u7248\u672c\u3002", (String)"TaxDataPushService_4", (String)"swc-hscs-business", (Object[])new Object[0]);
        if (resultDataList == null || resultDataList.size() == 0) {
            this.dealQueryTaxFileFailData(calPersonMap, errorDataMap, calPersonList, hasRelFileIdSet, msg, salaryFileMap);
            return salaryFileRelMap;
        }
        String taxPayerTypeMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u5173\u8054\u7684\u4e2a\u7a0e\u6863\u6848\u5728\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u627e\u5230\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4fe1\u606f\u3002", (String)"TaxDataPushService_7", (String)"swc-hscs-business", (Object[])new Object[0]);
        Boolean isSuccess = null;
        Map taxFileInfoMap = null;
        Long salaryFileId = null;
        DynamicObject calPerson2 = null;
        DynamicObject tempObj = null;
        DynamicObject taxUnit = null;
        for (Map dataMap : resultDataList) {
            isSuccess = (Boolean)dataMap.get("success");
            salaryFileId = (Long)dataMap.get("salaryFile");
            tempObj = (DynamicObject)dataMap.get("taxpayertype");
            if (isSuccess != null && isSuccess.booleanValue() && tempObj != null) {
                taxUnit = (DynamicObject)dataMap.get("taxunit");
                taxFileInfoMap = salaryFileRelMap.getOrDefault(salaryFileId, new HashMap(3));
                taxFileInfoMap.put("taxfile", (Long)dataMap.get("boid"));
                taxFileInfoMap.put("taxunit", taxUnit.getLong("id"));
                taxFileInfoMap.put("taxpayertype", tempObj.getLong("id"));
                salaryFileRelMap.put(salaryFileId, taxFileInfoMap);
                continue;
            }
            calPerson2 = salaryFileMap.get(salaryFileId);
            calPersonMap.remove(calPerson2.getLong("id"));
            calPerson2.set("calstatus", (Object)CalStateEnum.PUSHTAX_ERROR.getCode());
            calPersonList.add((Object)calPerson2);
            if (tempObj == null) {
                errorDataMap.put(calPerson2.getLong("id"), taxPayerTypeMsg);
                continue;
            }
            errorDataMap.put(calPerson2.getLong("id"), msg);
        }
        return salaryFileRelMap;
    }

    private void dealQueryTaxFileFailData(Map<Long, DynamicObject> calPersonMap, Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList, Set<Long> salaryFileIdSet, String msg, Map<Long, DynamicObject> salaryFileMap) {
        DynamicObject calPerson = null;
        for (Long fileId : salaryFileIdSet) {
            calPerson = salaryFileMap.get(fileId);
            if (calPerson == null) continue;
            calPersonMap.remove(calPerson.getLong("id"));
            calPerson.set("calstatus", (Object)CalStateEnum.PUSHTAX_ERROR.getCode());
            calPersonList.add((Object)calPerson);
            errorDataMap.put(calPerson.getLong("id"), msg);
        }
    }

    private void dealPushTaxFailData(Map<Long, DynamicObject> calPersonMap, Map<Long, String> errorDataMap, DynamicObjectCollection calPersonList, String msg) {
        DynamicObject calPerson = null;
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            calPerson = entry.getValue();
            errorDataMap.put(calPerson.getLong("id"), msg);
            calPerson.set("calstatus", (Object)CalStateEnum.TAXCAL_ERROR.getCode());
            calPersonList.add((Object)calPerson);
        }
    }

    private List<Map<String, Object>> getItemDataMapList(List<DynamicObject> calTableList, Map<String, Object> pushParamMap, Long taxPayerTypeId, Set<String> errorSalaryItemNameSet) {
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(10);
        Map preSalaryTaxRelMap = (Map)pushParamMap.get("preSalaryTaxRelMap");
        Map afterSalaryTaxRelMap = (Map)pushParamMap.get("afterSalaryTaxRelMap");
        HashMap itemMap = null;
        Map tempMap = null;
        Map salaryItemInfoMap = (Map)pushParamMap.get("salaryItemInfoMap");
        List preSalaryItemIdList = (List)pushParamMap.get("preSalaryItemIdList");
        HashSet preCategorySet = new HashSet(16);
        boolean isPreNoMatch = true;
        ArrayList preErrorList = new ArrayList(10);
        ArrayList afterErrorList = new ArrayList(10);
        String itemValue = null;
        Long salaryItemId = null;
        for (DynamicObject obj : calTableList) {
            salaryItemId = obj.getLong("hsas_caltableentry.salaryitem.id");
            if (!preSalaryItemIdList.contains(salaryItemId)) continue;
            tempMap = (Map)preSalaryTaxRelMap.get(salaryItemId + "@" + taxPayerTypeId);
            if (tempMap == null) {
                preErrorList.add(salaryItemInfoMap.get(String.valueOf(salaryItemId)));
                continue;
            }
            itemValue = this.getItemValue(obj);
            logger.info("salaryitemid:{},itemValue:{}", (Object)salaryItemId, (Object)itemValue);
            if (!SWCStringUtils.isNotEmpty((String)itemValue)) continue;
            itemMap = new HashMap(5);
            itemMap.put("taxItem", tempMap.get("taxitem"));
            itemMap.put("taxCategory", tempMap.get("taxcategory"));
            itemMap.put("dataDirect", "1");
            itemMap.put("itemValueEnc", null);
            itemMap.put("itemValue", itemValue);
            itemList.add(itemMap);
            isPreNoMatch = false;
            preCategorySet.add(tempMap.get("taxcategory"));
        }
        boolean isAfterNoMatch = true;
        Map tempAfterSalaryTaxRelMap = (Map)afterSalaryTaxRelMap.get(String.valueOf(taxPayerTypeId));
        if (tempAfterSalaryTaxRelMap != null) {
            for (Map.Entry entry : tempAfterSalaryTaxRelMap.entrySet()) {
                if (!preCategorySet.contains(((Map)entry.getValue()).get("taxcategory"))) {
                    afterErrorList.add(salaryItemInfoMap.get(entry.getKey()));
                    continue;
                }
                itemMap = new HashMap(5);
                tempMap = (Map)entry.getValue();
                itemMap.put("taxItem", tempMap.get("taxitem"));
                itemMap.put("taxCategory", tempMap.get("taxcategory"));
                itemMap.put("dataDirect", "2");
                itemMap.put("itemValueEnc", null);
                itemMap.put("itemValue", null);
                itemList.add(itemMap);
                isAfterNoMatch = false;
            }
        } else {
            List afterSalaryItemIdList = (List)pushParamMap.get("afterSalaryItemIdList");
            afterSalaryItemIdList.stream().forEach(id -> afterErrorList.add(salaryItemInfoMap.get(String.valueOf(id))));
        }
        if (isPreNoMatch) {
            errorSalaryItemNameSet.addAll(preErrorList);
            itemList.clear();
        }
        if (isAfterNoMatch) {
            errorSalaryItemNameSet.addAll(afterErrorList);
            itemList.clear();
        }
        return itemList;
    }

    private String getItemValue(DynamicObject obj) {
        long dataTypeId = obj.getLong("hsas_caltableentry.salaryitem.datatype.id");
        String itemValue = null;
        if (dataTypeId == 1020L) {
            itemValue = obj.getBigDecimal("hsas_caltableentry.calamountvalue").toPlainString();
        } else if (dataTypeId == 1010L) {
            itemValue = obj.getBigDecimal("hsas_caltableentry.numvalue").toPlainString();
        } else if (dataTypeId == 1030L) {
            itemValue = obj.getString("hsas_caltableentry.textvalue");
        } else if (dataTypeId == 1050L) {
            itemValue = SWCDateTimeUtils.format((Date)obj.getDate("hsas_caltableentry.datevalue"), (String)"yyyy-MM-dd");
        }
        return itemValue;
    }

    private Map<String, List<Long>> getSourceOrResultItemMap(long calRulevId, Map<String, String> salaryItemInfoMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        QFilter filter = new QFilter("id", "=", (Object)calRulevId);
        DynamicObjectCollection calRuleCollection = helper.queryOriginalCollection("calruleitementry.salaryitem.taxtag,calruleitementry.salaryitem.id,calruleitementry.salaryitem.name", new QFilter[]{filter});
        ArrayList<Long> preSalaryItemIdList = new ArrayList<Long>(10);
        ArrayList<Long> afterSalaryItemIdList = new ArrayList<Long>(10);
        for (DynamicObject calRuleItem : calRuleCollection) {
            String taxTag;
            switch (taxTag = calRuleItem.getString("calruleitementry.salaryitem.taxtag")) {
                case "1": {
                    preSalaryItemIdList.add(calRuleItem.getLong("calruleitementry.salaryitem.id"));
                    salaryItemInfoMap.put(String.valueOf(calRuleItem.getLong("calruleitementry.salaryitem.id")), calRuleItem.getString("calruleitementry.salaryitem.name"));
                    break;
                }
                case "2": {
                    afterSalaryItemIdList.add(calRuleItem.getLong("calruleitementry.salaryitem.id"));
                    salaryItemInfoMap.put(String.valueOf(calRuleItem.getLong("calruleitementry.salaryitem.id")), calRuleItem.getString("calruleitementry.salaryitem.name"));
                    break;
                }
            }
        }
        HashMap<String, List<Long>> itemMap = new HashMap<String, List<Long>>(2);
        itemMap.put("preSalaryItemIdList", preSalaryItemIdList);
        itemMap.put("afterSalaryItemIdList", afterSalaryItemIdList);
        return itemMap;
    }

    private void buildTaxProjSchemeData(long taxProjSchemevId, List<Long> preSalaryItemIdList, List<Long> afterSalaryItemIdList, Map<String, Object> pushParamMap) {
        HashMap preSalaryTaxRelMap = new HashMap(16);
        SWCDataServiceHelper taxHelper = new SWCDataServiceHelper("hsbs_taxprojscheme");
        DynamicObject taxProjSchData = taxHelper.queryOne((Object)taxProjSchemevId);
        HashMap<String, String> taxItemMapperSalaryMap = new HashMap<String, String>(16);
        HashMap<String, String> salaryDataTypeMap = new HashMap<String, String>(16);
        HashMap<String, String> tempMap = null;
        for (DynamicObject entry : taxProjSchData.getDynamicObjectCollection("salarymapentry")) {
            if (!preSalaryItemIdList.contains(entry.getLong("presalaryitem.id"))) continue;
            tempMap = new HashMap<String, String>(2);
            tempMap.put("taxcategory", String.valueOf(entry.getLong("pretaxcategory.id")));
            tempMap.put("taxitem", String.valueOf(entry.getLong("pretaxitem.id")));
            preSalaryTaxRelMap.put(entry.getLong("presalaryitem.id") + "@" + entry.getLong("pretaxcategory.taxpayertype.id"), tempMap);
        }
        HashMap<String, HashMap<String, String>> tempAfterSalaryTaxMap = null;
        HashMap afterSalaryTaxRelMap = new HashMap(16);
        for (DynamicObject entry : taxProjSchData.getDynamicObjectCollection("taxmapentry")) {
            if (!afterSalaryItemIdList.contains(entry.getLong("aftersalaryitem.id"))) continue;
            tempAfterSalaryTaxMap = (HashMap<String, HashMap<String, String>>)afterSalaryTaxRelMap.get(String.valueOf(entry.getLong("aftertaxcategory.taxpayertype.id")));
            if (tempAfterSalaryTaxMap == null) {
                tempAfterSalaryTaxMap = new HashMap<String, HashMap<String, String>>(16);
                afterSalaryTaxRelMap.put(String.valueOf(entry.getLong("aftertaxcategory.taxpayertype.id")), tempAfterSalaryTaxMap);
            }
            tempMap = new HashMap(2);
            tempMap.put("taxcategory", String.valueOf(entry.getLong("aftertaxcategory.id")));
            tempMap.put("taxitem", String.valueOf(entry.getLong("aftertaxitem.id")));
            tempAfterSalaryTaxMap.put(String.valueOf(entry.getLong("aftersalaryitem.id")), tempMap);
            salaryDataTypeMap.put(String.valueOf(entry.getLong("aftersalaryitem.id")), String.valueOf(entry.getLong("aftersalaryitem.datatype.id")));
            taxItemMapperSalaryMap.put(entry.getLong("aftertaxitem.id") + "@@" + entry.getLong("aftertaxcategory.id"), String.valueOf(entry.getLong("aftersalaryitem.id")));
        }
        pushParamMap.put("preSalaryTaxRelMap", preSalaryTaxRelMap);
        pushParamMap.put("afterSalaryTaxRelMap", afterSalaryTaxRelMap);
        pushParamMap.put("taxItemMapperSalaryMap", taxItemMapperSalaryMap);
        pushParamMap.put("salaryDataTypeMap", salaryDataTypeMap);
    }
}

