/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.tax.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.TaxDataBizStatusEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.rollback.helper.RollBackCalFilterService;
import kd.swc.hscs.business.cal.service.HandleParamsBeforeCalService;
import kd.swc.hscs.business.cal.tax.service.TaxDataPullService;
import kd.swc.hscs.business.cal.utils.CalUtils;

public class TaxDataStateUpdateService {
    private static final Log log = LogFactory.getLog(TaxDataStateUpdateService.class);
    private static final String OPERATEKEY = "__operateKey__";
    private static final ExecutorService PULLTAXDATA_POOL = ThreadPools.newExecutorService((String)"PULLTAXDATA_POOL", (int)4);
    private static final String CAL_RECORD_ID = "calRecordId";

    public void checkAndUpdateTaxState(Map<String, Object> params) {
        CalUtils.printLog("checkAndUpdateTaxState params==>", params);
        if (params == null || params.size() == 0) {
            log.info("checkAndUpdateTaxState params is empty");
            return;
        }
        String operateKey = (String)params.remove(OPERATEKEY);
        Map<Long, DynamicObject> calTaskMap = this.getCalTaskMap(params.keySet());
        ArrayList<String> calPersonIdList = null;
        int state = 0;
        Map stateMap = null;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            stateMap = (Map)entry.getValue();
            if (stateMap == null || stateMap.size() == 0) continue;
            calPersonIdList = new ArrayList<String>(10);
            for (Map.Entry stateEntry : stateMap.entrySet()) {
                state = Integer.parseInt((String)stateEntry.getKey());
                if (!this.checkTaxState(state) || stateEntry.getValue() == null) continue;
                calPersonIdList.addAll((Collection)stateEntry.getValue());
            }
            if (SWCListUtils.isEmpty(calPersonIdList)) {
                log.info("checkAndUpdateTaxState,calTaskNumber:{},calPersonIdList is empty.", (Object)entry.getKey());
                continue;
            }
            this.taxDataStateUpdate(calPersonIdList, calTaskMap, operateKey);
        }
    }

    private boolean checkTaxState(int state) {
        return state == Integer.parseInt(TaxDataBizStatusEnum.BACK.getCode()) || state >= Integer.parseInt(TaxDataBizStatusEnum.REFER.getCode()) && state <= Integer.parseInt(TaxDataBizStatusEnum.FEEDBACK.getCode());
    }

    private void taxDataStateUpdate(List<String> calPersonIdList, Map<Long, DynamicObject> calTaskMap, String operateKey) {
        DynamicObject[] calPersonArray = this.getCalPersonList(calPersonIdList);
        if (calPersonArray == null || calPersonArray.length == 0) {
            log.info("Query calPerson is null");
            return;
        }
        DynamicObject calPerson = calPersonArray[0];
        DynamicObject calTask = calTaskMap.get(calPerson.getLong("caltask.id"));
        Map<String, Object> dataMap = this.invokeSitGetDataStatusInteface(calTask, calPersonIdList);
        if (dataMap == null) {
            return;
        }
        this.updateCalTableTaxState(dataMap, calPersonArray, calTask, operateKey);
    }

    private Map<String, Object> invokeSitGetDataStatusInteface(DynamicObject calTask, List<String> calPersonIdList) {
        String countryId = String.valueOf(calTask.getLong("country.id"));
        Date payDate = calTask.getDate("paydate");
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put("srcType", "1");
        request.put("langCode", Lang.get().getLangTag());
        request.put("data", calPersonIdList);
        request.put("country", countryId);
        request.put("payDate", payDate);
        CalUtils.printLog("getDataStatus request==>", request);
        Map responese = (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"getDataStatus", (Object[])new Object[]{request});
        CalUtils.printLog("getDataStatus responese==>", responese);
        Boolean success = (Boolean)responese.get("success");
        if (!success.booleanValue()) {
            log.error("getDataStatus error,msg= {}", responese.get("message"));
            return null;
        }
        Map dataMap = (Map)responese.get("data");
        if (dataMap == null || dataMap.size() == 0) {
            log.error("getDataStatus interface data is null");
            return null;
        }
        return dataMap;
    }

    private String getTaxState(int state) {
        if (state == Integer.parseInt(TaxDataBizStatusEnum.BACK.getCode())) {
            return TaxStateEnum.UNPUSH.getCode();
        }
        if (state == Integer.parseInt(TaxDataBizStatusEnum.FEEDBACK.getCode())) {
            return TaxStateEnum.GOBACK.getCode();
        }
        if (state >= Integer.parseInt(TaxDataBizStatusEnum.REFER.getCode()) && state < Integer.parseInt(TaxDataBizStatusEnum.LOCK.getCode())) {
            return TaxStateEnum.QUOTE.getCode();
        }
        if (state >= Integer.parseInt(TaxDataBizStatusEnum.LOCK.getCode()) && state < Integer.parseInt(TaxDataBizStatusEnum.FEEDBACK.getCode())) {
            return TaxStateEnum.LOCKED.getCode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCalTableTaxState(Map<String, Object> dataMap, DynamicObject[] calPersonObjs, DynamicObject calTask, String operateKey) {
        HashMap<Long, String> tempMap = new HashMap<Long, String>(16);
        Map tempDataMap = null;
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            tempDataMap = (Map)entry.getValue();
            String srcDataKey = (String)tempDataMap.get("srcDataKey");
            String dataState = (String)tempDataMap.get("dataStatus");
            if (SWCStringUtils.isEmpty((String)dataState)) continue;
            tempMap.put(Long.valueOf(srcDataKey), dataState);
        }
        Long calTaskId = calTask.getLong("id");
        ArrayList<Long> pullIdList = new ArrayList<Long>(calPersonObjs.length);
        ArrayList<Long> returnIdList = new ArrayList<Long>(calPersonObjs.length);
        ArrayList<Long> cancelPushIdList = new ArrayList<Long>(calPersonObjs.length);
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(calPersonObjs.length);
        this.dealCalPersonData(calPersonObjs, tempMap, pullIdList, returnIdList, cancelPushIdList, personIndexIdList);
        DynamicObject record = this.getRecordData(calTaskId);
        DynamicObject[] calDetails = null;
        if (!SWCListUtils.isEmpty(returnIdList)) {
            calDetails = this.dealCalProgress(calTaskId, returnIdList, record);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            helper.update(calPersonObjs);
            if (calDetails != null && calDetails.length > 0 && record != null) {
                helper.setEntityName("hsas_caldetail");
                helper.update(calDetails);
                long recordId = record.getLong("id");
                int size = calDetails.length;
                ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", recordId));
                this.updateCalProgress(recordId, size, calProgressAppCache);
                boolean isCalFinish = CalUtils.updateCalRecord(size, 0, recordId);
                if (isCalFinish) {
                    PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
                }
                CalUtils.deleteSalaryCalMutexData(personIndexIdList, calTaskId);
            }
        }
        if (cancelPushIdList.size() > 0) {
            this.cancelCal(calTask, cancelPushIdList, operateKey);
        }
        if (pullIdList.size() > 0) {
            this.autoPullTaxData(calTaskId, pullIdList, record);
        }
    }

    private void cancelCal(DynamicObject calTask, List<Long> calPersonIdList, String operateKey) {
        Long calTaskId = calTask.getLong("id");
        String lockKey = "_swcCancelCal_" + operateKey + '_' + calTaskId;
        Long calRecordId = null;
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(60000L)) {
                ISWCAppCache cancelAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CANCELCAL_FROM_TAX_%s_%s", operateKey, calTaskId));
                calRecordId = (Long)cancelAppCache.get(CAL_RECORD_ID, Long.class);
                if (calRecordId == null) {
                    calRecordId = DB.genLongId((String)"t_hsas_calrecord");
                    int salaryItemCount = this.assembleSalaryItemCount(calTask.getLong("calrulev.id"));
                    this.saveCalRecordData(calTaskId, calPersonIdList.size(), salaryItemCount, calRecordId);
                    CalRequestHelper.saveCalRequest((Long)calTaskId, (int)calPersonIdList.size(), (String)"uncal", (String)CalRequestStatusEnum.DOING.getCode(), (Long)calRecordId, null);
                    appCache.put(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", calRecordId), calPersonIdList);
                    cancelAppCache.put(CAL_RECORD_ID, (Object)calRecordId);
                } else {
                    this.updateCalRecordCount(calRecordId, calPersonIdList.size());
                }
            }
        }
        catch (Exception ex) {
            log.error("cancelCal from tax error,", (Throwable)ex);
        }
        if (calRecordId != null) {
            log.info("rollBackCal start,recordId = {}", calRecordId);
            DynamicObject calTaskObj = HandleParamsBeforeCalService.getCalTaskInfo(calTaskId);
            RollBackCalFilterService rollBackCalFilterService = new RollBackCalFilterService();
            rollBackCalFilterService.rollBackCal(calTaskObj, calPersonIdList, calRecordId, "cancelcal", null);
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            PayrollTaskHelper.delTaskAndAccRef((Long)calTaskId);
            appCache.remove(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", calRecordId));
            log.info("rollBackCal end,recordId = {}", (Object)calRecordId);
        } else {
            log.error("cancelCal from tax,calRecordId is null");
        }
    }

    private void updateCalRecordCount(Long calRecordId, int count) {
        log.info("updateCalRecordCount start");
        String lockKey = "_updateCalRecordCount_" + calRecordId;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(120000L)) {
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
                DynamicObject calRecord = helper.queryOne("id,totalcount", new QFilter[]{new QFilter("id", "=", (Object)calRecordId)});
                if (calRecord != null) {
                    calRecord.set("totalcount", (Object)(calRecord.getInt("totalcount") + count));
                    helper.updateOne(calRecord);
                }
                helper.setEntityName("hsas_calrequest");
                DynamicObject calRequest = helper.queryOne("id,count", new QFilter("calrecord", "=", (Object)calRecordId).toArray());
                if (calRequest != null) {
                    calRequest.set("count", (Object)(calRequest.getInt("count") + count));
                    helper.updateOne(calRequest);
                }
            }
        }
        catch (Exception ex) {
            log.error("updateCalRecordCount error,", (Throwable)ex);
        }
        log.info("updateCalRecordCount end");
    }

    private void saveCalRecordData(long calTaskId, int dataSize, int salaryItemCount, long calRecordId) {
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject calRecord = calRecordHelper.generateEmptyDynamicObject();
        calRecord.set("id", (Object)calRecordId);
        calRecord.set("caltask", (Object)calTaskId);
        calRecord.set("totalcount", (Object)dataSize);
        calRecord.set("starttime", (Object)nowDate);
        calRecord.set("calstatus", (Object)"1");
        calRecord.set("salaryitemcount", (Object)salaryItemCount);
        calRecord.set("createtime", (Object)nowDate);
        calRecord.set("modifytime", (Object)nowDate);
        calRecord.set("creator", (Object)userId);
        calRecord.set("modifier", (Object)userId);
        calRecord.set("reportnum", (Object)DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyyMMddHHmmss"}));
        calRecord.set("optype", (Object)"2");
        calRecordHelper.saveOne(calRecord);
    }

    private int assembleSalaryItemCount(Long calRuleVid) {
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        QFilter qFilter = new QFilter("id", "=", (Object)calRuleVid);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        DynamicObjectCollection calRuleData = calRuleHisHelper.queryOriginalCollection("id,name,calruleitementry.id", new QFilter[]{qFilter});
        return calRuleData.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCalProgress(long recordId, int size, ISWCAppCache calProgressAppCache) {
        String lockKey = "_swcCalUpdateSaveProcess_" + recordId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(30000L)) {
                Map calProgressMap = (Map)calProgressAppCache.get(String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId), Map.class);
                if (calProgressMap == null) {
                    FormulaCacheUtils.updateCalProgressFromDB((long)recordId);
                    return;
                }
                FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)0, (int)size, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", recordId));
                FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)0, (int)size, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
            } else {
                log.error("updateSaveProcess tryLock fail,recordId={}", (Object)recordId);
            }
        }
        catch (Exception ex) {
            log.error("updateCalProgress error.", (Throwable)ex);
        }
        finally {
            lock.unlock();
        }
    }

    private DynamicObject[] dealCalProgress(Long calTaskId, List<Long> calPersonIdList, DynamicObject record) {
        DynamicObject[] calDetails;
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            log.info("dealCalProgress calPersonIdList is null");
            return null;
        }
        Long calRecordId = 0L;
        if (record != null) {
            calRecordId = record.getLong("id");
        }
        QFilter cusFilter = new QFilter("calstatus", "=", (Object)CalStatusEnum.CALING.getCode());
        for (DynamicObject obj : calDetails = this.getCalDetailData(calTaskId, calRecordId, calPersonIdList, cusFilter)) {
            obj.set("calstatus", (Object)CalStatusEnum.SUCCESS.getCode());
            obj.set("modifytime", (Object)new Date());
        }
        return calDetails;
    }

    private void dealCalPersonData(DynamicObject[] calPersonObjs, Map<Long, String> tempMap, List<Long> pullIdList, List<Long> returnIdList, List<Long> cancelPushIdList, List<Long> personIndexIdList) {
        for (DynamicObject person : calPersonObjs) {
            String taxState;
            String dataState = tempMap.get(person.getLong("id"));
            if (dataState == null || SWCStringUtils.isEmpty((String)(taxState = this.getTaxState(Integer.parseInt(dataState))))) continue;
            if (TaxStateEnum.UNPUSH.getCode().equals(taxState)) {
                if (CalStateEnum.PRECAL_CALED.getCode().equals(person.getString("calstatus")) && TaxStateEnum.QUOTE.getCode().equals(person.getString("taxstatus"))) {
                    person.set("taxstatus", (Object)taxState);
                    person.set("calstatus", (Object)CalStateEnum.PARTIAL_CALED.getCode());
                    person.set("pushtime", null);
                    person.set("pulltime", null);
                    person.set("modifytime", (Object)new Date());
                    personIndexIdList.add(person.getLong("personhrv.personindexid"));
                    returnIdList.add(person.getLong("id"));
                    continue;
                }
                cancelPushIdList.add(person.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)person.getString("calstatus"), (String)CalStateEnum.TAX_CALED.getCode()) && SWCStringUtils.equals((String)person.getString("taxstatus"), (String)TaxStateEnum.PULLED.getCode())) continue;
            if (SWCStringUtils.equals((String)taxState, (String)TaxStateEnum.GOBACK.getCode())) {
                pullIdList.add(person.getLong("id"));
            }
            person.set("taxstatus", (Object)taxState);
            person.set("modifytime", (Object)new Date());
        }
    }

    private void autoPullTaxData(Long calTaskId, List<Long> pullIdList, DynamicObject record) {
        if (record == null) {
            log.info("no caling record");
            return;
        }
        Map<Long, List<DynamicObject>> calDetailMap = this.getCalDetailMap(calTaskId, record.getLong("id"), pullIdList);
        RequestContext rtc = RequestContext.get();
        for (Map.Entry<Long, List<DynamicObject>> entry : calDetailMap.entrySet()) {
            DynamicObject calDetail = entry.getValue().get(0);
            List calPersonIdList = entry.getValue().stream().map(obj -> obj.getLong("calpersonid")).collect(Collectors.toList());
            PULLTAXDATA_POOL.submit(() -> {
                RequestContext.copyAndSet((RequestContext)rtc);
                log.info("asyn pullTaxData,traceId= {}", (Object)rtc.getTraceId());
                TaxDataPullService pullService = new TaxDataPullService(calTaskId, calDetail.getLong("record.id"), calDetail.getLong("batch.id"));
                pullService.pullTaxData(calPersonIdList, true);
            });
        }
    }

    private Map<Long, List<DynamicObject>> getCalDetailMap(Long calTaskId, Long recordId, List<Long> calPersonIdList) {
        DynamicObject[] calDetails = this.getCalDetailData(calTaskId, recordId, calPersonIdList, null);
        return Arrays.asList(calDetails).stream().collect(Collectors.groupingBy(obj -> obj.getLong("batch.id")));
    }

    private DynamicObject[] getCalDetailData(Long calTaskId, Long recordId, List<Long> calPersonIdList, QFilter cusFilter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        qFilter.and("record.id", "=", (Object)recordId);
        qFilter.and("calpersonid", "in", calPersonIdList);
        if (cusFilter != null) {
            qFilter.and(cusFilter);
        }
        String fields = "id,caltask.id,calpersonid,record.id,batch.id,calstatus,modifytime";
        return helper.query(fields, new QFilter[]{qFilter});
    }

    public DynamicObject getRecordData(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter qFilter = new QFilter("caltask.id", "in", (Object)calTaskId);
        qFilter.and("calstatus", "=", (Object)"1");
        qFilter.and("optype", "=", (Object)"1");
        return helper.queryOriginalOne("id", new QFilter[]{qFilter}, "createtime desc");
    }

    public DynamicObject[] getCalPersonList(List<String> calPersonIdList) {
        Object[] ids = calPersonIdList.stream().map(obj -> (Long)ObjectConverter.convert((Object)obj, Long.class, (boolean)true)).toArray();
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,calstatus,taxstatus,caltask.id,modifytime,pushtime,pulltime,personhrv.personindexid";
        QFilter filter = new QFilter("id", "in", (Object)ids);
        return calTableHelper.query(selectProperties, new QFilter[]{filter});
    }

    private Map<Long, DynamicObject> getCalTaskMap(Set<String> calTaskNumberSet) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,number,country.id,paydate,calrulev.id";
        QFilter filter = new QFilter("number", "in", calTaskNumberSet);
        DynamicObjectCollection list = taskHelper.queryOriginalCollection(fields, new QFilter[]{filter});
        return list.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
    }
}

