/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.mq.BatchCalPublisher;
import kd.swc.hscs.business.mq.DataSavePublisher;
import kd.swc.hscs.common.constants.TaxRateConstants;
import kd.swc.hscs.common.vo.CalOperationVO;
import kd.swc.hscs.common.vo.CalRecordVO;
import kd.swc.hscs.common.vo.CalResultVO;

public class CalUtils {
    private static final Log logger = LogFactory.getLog(CalUtils.class);

    public static List<CalRecordVO> getCalRecordList(List<Long> calPersonIdList, String msg, String failType, String errorElement) {
        if (calPersonIdList == null || calPersonIdList.size() == 0) {
            return new ArrayList<CalRecordVO>(0);
        }
        ArrayList<CalRecordVO> calRecordList = new ArrayList<CalRecordVO>(calPersonIdList.size());
        CalRecordVO calRecord = null;
        for (Long calPersonId : calPersonIdList) {
            calRecord = CalUtils.getCalRecordObj(calPersonId, msg, failType, errorElement);
            calRecordList.add(calRecord);
        }
        return calRecordList;
    }

    public static CalRecordVO getCalRecordObj(Long calPersonId, String msg, String failType, String errorElement) {
        CalRecordVO calRecord = new CalRecordVO();
        calRecord.setCalPersonId(String.valueOf(calPersonId));
        calRecord.setFailMsg(msg);
        calRecord.setCalStatus("2");
        calRecord.setFailType(failType);
        calRecord.setErrorElement(errorElement);
        return calRecord;
    }

    public static void sendSaveMessage(String calBatchId, String calTaskId, String recordId, String resultCacheKey, String calType, boolean resultCheck, List<Long> calPersonIdList) {
        HashMap<String, Object> mqMap = new HashMap<String, Object>(8);
        mqMap.put("calTaskId", calTaskId);
        mqMap.put("calRecordId", recordId);
        mqMap.put("calBatchId", calBatchId);
        mqMap.put("result_cache_key", resultCacheKey);
        mqMap.put("calType", calType);
        mqMap.put("resultcheck", resultCheck);
        mqMap.put("calPersonIdList", calPersonIdList);
        mqMap.put("mqSendTime", System.currentTimeMillis());
        DataSavePublisher.publishSaveCalResultMsg(mqMap);
    }

    public static CalOperationVO genCalOperationObj(String traceId, String calType, int successCount, int failCount) {
        CalOperationVO operationVO = new CalOperationVO();
        operationVO.setCalType(calType);
        operationVO.setTraceId(traceId);
        operationVO.setSuccessCount(successCount);
        operationVO.setFailCount(failCount);
        return operationVO;
    }

    public static void addCalOperation(long recordId, long batchId, String opType, Date startDate, CalOperationVO operationVO) {
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caloperation");
            DynamicObject obj = helper.generateEmptyDynamicObject();
            obj.set("record", (Object)recordId);
            obj.set("batch", (Object)batchId);
            obj.set("optype", (Object)opType);
            obj.set("starttime", (Object)startDate);
            obj.set("endtime", (Object)new Date());
            obj.set("createtime", (Object)new Date());
            obj.set("modifytime", (Object)new Date());
            obj.set("creator", (Object)RequestContext.get().getCurrUserId());
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            String desc = SerializationUtils.toJsonString((Object)operationVO);
            if (desc != null && desc.length() > 255) {
                desc = desc.substring(0, 254);
            }
            obj.set("description", (Object)desc);
            helper.saveOne(obj);
        }
        catch (Exception ex) {
            logger.error("addCalOperation error.", (Throwable)ex);
        }
    }

    public static void sendBatchCalMessage(Map<String, Object> params) {
        BatchCalPublisher.publishBatchCalMsg(params);
    }

    public static CalResultVO cloneCalResultProp(CalResultVO calResult) {
        CalResultVO calResultVO = new CalResultVO();
        calResultVO.setDataShowType(calResult.getDataShowType());
        calResultVO.setSalaryItemId(calResult.getSalaryItemId());
        calResultVO.setProration(BigDecimal.ZERO);
        return calResultVO;
    }

    public static MessagePublisher createAndGetPublisher(String region, String queueName) {
        return MQFactory.get().createSimplePublisher(region, queueName);
    }

    public static Set<Long> listStringToSetLong(List<String> ids) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        if (ids == null) {
            return idSet;
        }
        for (String id : ids) {
            idSet.add(Long.valueOf(id));
        }
        return idSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateCalRecord(int successCount, int failCount, long recordId) {
        boolean isCalFinish = false;
        String lockKey = "_updateCalRecordCount_" + recordId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(120000L)) {
                if (CalUtils.isTerminationCal(recordId)) {
                    boolean bl = isCalFinish;
                    return bl;
                }
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
                DynamicObject obj = helper.queryOne("id,sucesscount,failcount,totalcount,calstatus,endtime,modifytime", (Object)recordId);
                int existSuccessCount = obj.getInt("sucesscount");
                int existFailCount = obj.getInt("failcount");
                int totalCount = obj.getInt("totalcount");
                int caledCount = (existSuccessCount += successCount) + (existFailCount += failCount);
                obj.set("sucesscount", (Object)existSuccessCount);
                obj.set("failcount", (Object)existFailCount);
                if (totalCount == caledCount) {
                    CalRequestHelper.updateCalRequest((Long)recordId, (String)CalRequestStatusEnum.FINISHED.getCode());
                    obj.set("calstatus", (Object)"2");
                    obj.set("endtime", (Object)new Date());
                    isCalFinish = true;
                }
                obj.set("modifytime", (Object)new Date());
                helper.updateOne(obj);
            } else {
                logger.error("updateCalRecord tryLock fail,recordId={}", (Object)recordId);
            }
        }
        finally {
            lock.unlock();
        }
        return isCalFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCalProgress(int succCount, int failCount, ISWCAppCache appCache, String calType, long recordId) {
        block25: {
            String lockKey = "_swcCalUpdateSaveProcess_" + recordId;
            DLock lock = DLock.create((String)lockKey);
            try {
                if (lock.tryLock(30000L)) {
                    Map calProgressMap = (Map)appCache.get(String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId), Map.class);
                    if (calProgressMap == null) {
                        FormulaCacheUtils.updateCalProgressFromDB((long)recordId);
                        return;
                    }
                    switch (calType) {
                        case "afterTaxCal": {
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)succCount, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
                            break;
                        }
                        case "onlyPreTaxCal": {
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)succCount, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId));
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)0, (int)failCount, (int)succCount, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", recordId));
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)0, (int)failCount, (int)succCount, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
                            break;
                        }
                        case "preTaxCal": {
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)succCount, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId));
                            if (failCount > 0) {
                                FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", recordId));
                                FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
                                break;
                            }
                            break block25;
                        }
                        case "taxCal": 
                        case "pullTax": {
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)succCount, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", recordId));
                            if (failCount > 0) {
                                FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
                                break;
                            }
                            break block25;
                        }
                        case "cal": {
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)succCount, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId));
                            FormulaCacheUtils.updateProgress((ISWCAppCache)appCache, (int)succCount, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
                            break;
                        }
                        default: {
                            logger.info("no match calType\uff0crecordId={},calType={}", (Object)recordId, (Object)calType);
                            break;
                        }
                    }
                    break block25;
                }
                logger.error("updateSaveProcess tryLock fail,recordId={},calType={}", (Object)recordId, (Object)calType);
            }
            catch (Exception ex) {
                logger.error("updateSaveProcess error.", (Throwable)ex);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static boolean updateSaveProcess(int succCount, int failCount, ISWCAppCache appCache, String calType, Long taskId, Long recordId) {
        boolean isCalFinish = false;
        if (SWCStringUtils.equals((String)calType, (String)"afterTaxCal") || SWCStringUtils.equals((String)calType, (String)"onlyPreTaxCal") || SWCStringUtils.equals((String)calType, (String)"cal")) {
            isCalFinish = CalUtils.updateCalRecord(succCount, failCount, recordId);
        } else if (failCount > 0) {
            isCalFinish = CalUtils.updateCalRecord(0, failCount, recordId);
        }
        CalUtils.updateCalProgress(succCount, failCount, appCache, calType, recordId);
        PayrollTaskHelper.updateCalPayRollTaskStatus((Long)taskId, (String)CalPayrollTaskStateEnum.CALPROCESSING.getCode());
        if (isCalFinish) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
        }
        return isCalFinish;
    }

    public static void printLog(String msg, Object obj) {
        try {
            String message = msg + SWCJSONUtils.toString((Object)obj);
            logger.info(message);
        }
        catch (Exception e) {
            logger.error("printLog fail,", (Throwable)e);
        }
    }

    public static void invokeTaxUpdateSrcDataStatus(List<Long> calPersonIdList, String countryId, Date payDate, String status) {
        try {
            HashMap<String, Object> request = new HashMap<String, Object>(5);
            request.put("srcType", "1");
            request.put("langCode", Lang.get().getLangTag());
            request.put("country", countryId);
            request.put("payDate", payDate);
            request.put("status", status);
            request.put("data", calPersonIdList);
            logger.info("invokeTaxUpdateSrcDataStatus request=>{}", (Object)SWCJSONUtils.toString(request));
            SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"updateSrcDataStatus", (Object[])new Object[]{request});
        }
        catch (Exception e) {
            logger.error("invokeTaxUpdateSrcDataStatus error,", (Throwable)e);
        }
    }

    public static boolean isTerminationCal(Long recordId) {
        boolean calFlag = false;
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", recordId));
        Boolean isCancel = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", recordId), Boolean.class);
        if (isCancel != null && isCancel.booleanValue()) {
            logger.info("recordId = {},termination cal is {}", (Object)recordId, (Object)calFlag);
            calFlag = true;
        }
        return calFlag;
    }

    public static QFilter getFilterByCalType(String calType) {
        QFilter filter = "afterTaxCal".equals(calType) ? new QFilter("calstatus", "in", (Object)new String[]{CalStateEnum.TAX_CALED.getCode(), CalStateEnum.PARTIAL_CALED.getCode()}) : ("pullTax".equals(calType) || "taxCal".equals(calType) ? new QFilter("calstatus", "=", (Object)CalStateEnum.PRECAL_CALED.getCode()) : new QFilter("calstatus", "=", (Object)CalStateEnum.CALING.getCode()));
        return filter;
    }

    public static String getDataRange(Date startDate, Date endDate) {
        String startDateStr = SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
        String endDateStr = SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
        return startDateStr + "@" + endDateStr;
    }

    public static void deleteSalaryCalMutexData(List<Long> personIndexIdList, Long calTaskId) {
        if (SWCListUtils.isEmpty(personIndexIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalmutex");
        QFilter filter = new QFilter("personindexid", "in", personIndexIdList);
        if (calTaskId != null) {
            filter.and("caltask", "=", (Object)calTaskId);
        }
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public static void releaseCalCacheData(Long recordId) {
        ISWCAppCache pushAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_PUSH_%s", recordId));
        pushAppCache.remove(String.format(Locale.ROOT, "SWC_PUSH_%s", recordId));
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", recordId));
        appCache.remove("oldCalStatusMap");
        appCache.remove(String.format(Locale.ROOT, "CALPARAM_%s_%s", recordId, "preTaxCal"));
        appCache.remove(String.format(Locale.ROOT, "CALPARAM_%s_%s", recordId, "onlyPreTaxCal"));
        appCache.remove(String.format(Locale.ROOT, "CALPARAM_%s_%s", recordId, "afterTaxCal"));
    }

    public static int getSystemDefaultScal() {
        return 10;
    }

    public static Map<Integer, Map<String, BigDecimal>> getTaxRateMap() {
        HashMap<Integer, Map<String, BigDecimal>> taxRateMap = new HashMap<Integer, Map<String, BigDecimal>>(9);
        HashMap<String, BigDecimal> rateInfoMap = new HashMap<String, BigDecimal>(4);
        rateInfoMap.put("taxRate", new BigDecimal("0"));
        rateInfoMap.put("salaryDeduct", BigDecimal.ZERO);
        rateInfoMap.put("bonusDeduct", BigDecimal.ZERO);
        rateInfoMap.put("taxBandValue", new BigDecimal("0"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_ZERO, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.03"));
        rateInfoMap.put("salaryDeduct", BigDecimal.ZERO);
        rateInfoMap.put("bonusDeduct", BigDecimal.ZERO);
        rateInfoMap.put("taxBandValue", new BigDecimal("36000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_ONE, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.1"));
        rateInfoMap.put("salaryDeduct", new BigDecimal("2520"));
        rateInfoMap.put("bonusDeduct", new BigDecimal("210"));
        rateInfoMap.put("taxBandValue", new BigDecimal("144000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_TWO, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.2"));
        rateInfoMap.put("salaryDeduct", new BigDecimal("16920"));
        rateInfoMap.put("bonusDeduct", new BigDecimal("1410"));
        rateInfoMap.put("taxBandValue", new BigDecimal("300000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_THREE, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.25"));
        rateInfoMap.put("salaryDeduct", new BigDecimal("31920"));
        rateInfoMap.put("bonusDeduct", new BigDecimal("2660"));
        rateInfoMap.put("taxBandValue", new BigDecimal("420000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_FOUR, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.3"));
        rateInfoMap.put("salaryDeduct", new BigDecimal("52920"));
        rateInfoMap.put("bonusDeduct", new BigDecimal("4410"));
        rateInfoMap.put("taxBandValue", new BigDecimal("660000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_FIVE, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.35"));
        rateInfoMap.put("salaryDeduct", new BigDecimal("85920"));
        rateInfoMap.put("bonusDeduct", new BigDecimal("7160"));
        rateInfoMap.put("taxBandValue", new BigDecimal("960000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_SIX, rateInfoMap);
        rateInfoMap = new HashMap(4);
        rateInfoMap.put("taxRate", new BigDecimal("0.45"));
        rateInfoMap.put("salaryDeduct", new BigDecimal("181920"));
        rateInfoMap.put("bonusDeduct", new BigDecimal("15160"));
        rateInfoMap.put("taxBandValue", new BigDecimal("100000000"));
        taxRateMap.put(TaxRateConstants.TAX_BAND_SEVEN, rateInfoMap);
        return taxRateMap;
    }
}

