/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.common.vo.ItemInfo;

public class FormulaParseUtils {
    private static final Log logger = LogFactory.getLog(FormulaParseUtils.class);

    public static String getResultFieldId(String resultId, Map<String, Object> paramsMap) {
        List resultList = (List)paramsMap.get("resultDatas");
        for (Map obj : resultList) {
            String id = (String)obj.get("resultid");
            if (!SWCStringUtils.equals((String)resultId, (String)id)) continue;
            String resultValTypeNumber = (String)obj.get("number");
            String type = "";
            if (SWCStringUtils.equals((String)resultValTypeNumber, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                type = DataGradeValueTypeEnum.DECIMAL.getDesc();
            } else if (SWCStringUtils.equals((String)resultValTypeNumber, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                type = DataGradeValueTypeEnum.AMOUNT.getDesc();
            } else if (SWCStringUtils.equals((String)resultValTypeNumber, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
                type = DataGradeValueTypeEnum.TEXT.getDesc();
            } else if (SWCStringUtils.equals((String)resultValTypeNumber, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
                type = DataGradeValueTypeEnum.INTEGER.getDesc();
            } else if (SWCStringUtils.equals((String)resultValTypeNumber, (String)DataGradeValueTypeEnum.DATE.getCode())) {
                type = DataGradeValueTypeEnum.DATE.getDesc();
            }
            return "result-" + type + "-" + resultId;
        }
        return "";
    }

    public static void getDataGradeParams(Object[] params, Map<String, Object> paramsMap, Map<String, Object> gradeData) throws KDBizException {
        FormulaParseUtils.buildGradeData(paramsMap, gradeData);
        FormulaParseUtils.buildConditionData(paramsMap, params, gradeData);
        String failPolicy = (String)gradeData.get("failpolice");
        paramsMap.put("failpolice", failPolicy);
        String beyondPolicy = (String)gradeData.get("beyondpolicy");
        paramsMap.put("beyondpolicy", beyondPolicy);
        String matchMethod = (String)gradeData.get("matchmethod");
        paramsMap.put("matchmethod", matchMethod);
        String dataRoundNumber = (String)gradeData.get("dataround");
        paramsMap.put("dataround", dataRoundNumber);
        FormulaParseUtils.buildResultData(paramsMap, gradeData);
        paramsMap.put("matchSourceMap", gradeData.get("matchSourceMap"));
        paramsMap.put("gradeDataMap", gradeData.get("gradeDataMap"));
        paramsMap.put("resultIds", gradeData.get("resultIds"));
    }

    public static void buildResultData(Map<String, Object> paramsMap, Map<String, Object> gradeData) {
        List resultData = (List)gradeData.get("resultList");
        ArrayList retList = new ArrayList(10);
        for (Map dataObj : resultData) {
            String resultCurrencyId;
            Integer resultLength;
            HashMap<String, Object> retMap = new HashMap<String, Object>(16);
            String resultName = (String)dataObj.get("resultName");
            retMap.put("resultitemname", resultName);
            String resultValTypeNumber = (String)dataObj.get("resultValTypeNumber");
            String resultValTypeId = (String)dataObj.get("resultValTypeId");
            retMap.put("number", resultValTypeNumber);
            retMap.put("resultvaltype", resultValTypeId);
            String resultAccuracy = (String)dataObj.get("resultAccuracy");
            if (!SWCStringUtils.isEmpty((String)resultAccuracy)) {
                retMap.put("resultaccuracy", resultAccuracy);
            }
            if ((resultLength = (Integer)dataObj.get("resultLength")) != null) {
                retMap.put("resultlength", resultLength);
            }
            if (!SWCStringUtils.isEmpty((String)(resultCurrencyId = (String)dataObj.get("resultCurrencyId")))) {
                retMap.put("resultcurrency", resultCurrencyId);
                int resultCurrencyAmtp = (Integer)dataObj.get("resultCurrencyAmtp");
                retMap.put("amtPrecision", resultCurrencyAmtp);
            }
            String resultId = (String)dataObj.get("resultId");
            retMap.put("resultid", resultId);
            String resultVal = (String)dataObj.get("resultVal");
            if (!SWCStringUtils.isEmpty((String)resultVal)) {
                retMap.put("resultdefaultval", resultVal);
            }
            retList.add(retMap);
        }
        paramsMap.put("resultDatas", retList);
    }

    public static void buildConditionData(Map<String, Object> paramsMap, Object[] params, Map<String, Object> gradeData) throws KDBizException {
        List conditionData = (List)gradeData.get("conditionList");
        ArrayList<String> conditionIds = new ArrayList<String>(10);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>(16);
        int index = 0;
        for (Map dataObj : conditionData) {
            Long conditionId = (Long)dataObj.get("conditionId");
            String conditionValType = (String)dataObj.get("conditionValType");
            String type = "";
            if (SWCStringUtils.equals((String)conditionValType, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                type = DataGradeValueTypeEnum.DECIMAL.getDesc();
            } else if (SWCStringUtils.equals((String)conditionValType, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                type = DataGradeValueTypeEnum.AMOUNT.getDesc();
            } else if (SWCStringUtils.equals((String)conditionValType, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
                type = DataGradeValueTypeEnum.TEXT.getDesc();
            } else if (SWCStringUtils.equals((String)conditionValType, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
                type = DataGradeValueTypeEnum.INTEGER.getDesc();
            } else if (SWCStringUtils.equals((String)conditionValType, (String)DataGradeValueTypeEnum.DATE.getCode())) {
                type = DataGradeValueTypeEnum.DATE.getDesc();
            }
            String conditionFieldId = "condition-" + type + "-" + conditionId;
            conditionIds.add(conditionFieldId);
            if (SWCStringUtils.equals((String)type, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                Date date = (Date)params[index];
                if (date == null) {
                    conditionMap.put(conditionFieldId, null);
                } else {
                    String dataStr = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                    try {
                        conditionMap.put(conditionFieldId, SWCDateTimeUtils.parseDate((String)dataStr));
                    }
                    catch (ParseException e) {
                        logger.info("FormulaParse date parse fail!");
                    }
                }
            } else if (SWCStringUtils.equals((String)type, (String)DataGradeValueTypeEnum.DECIMAL.getDesc()) || SWCStringUtils.equals((String)type, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                if (params[index] != null) {
                    conditionMap.put(conditionFieldId, new BigDecimal(params[index] + ""));
                }
            } else {
                conditionMap.put(conditionFieldId, params[index]);
            }
            ++index;
        }
        paramsMap.put("conditionIds", conditionIds);
        paramsMap.put("conditionMap", conditionMap);
    }

    private static void buildGradeData(Map<String, Object> paramsMap, Map<String, Object> gradeData) {
        List gradeList = (List)gradeData.get("gradeList");
        ArrayList retList = new ArrayList(10);
        for (Map gradeMap : gradeList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            int rownum = (Integer)gradeMap.get("rownum");
            dataMap.put("rownum", rownum);
            String fieldid = (String)gradeMap.get("fieldid");
            dataMap.put("fieldid", fieldid);
            String value = (String)gradeMap.get("value");
            int index = fieldid.indexOf(45);
            if (index != -1) {
                String valueType = fieldid.substring(index + 1, fieldid.lastIndexOf(45));
                if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc()) || SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                    dataMap.put("value", new BigDecimal(value));
                } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                    dataMap.put("value", value);
                } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
                    dataMap.put("value", Integer.valueOf(value));
                } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                    try {
                        dataMap.put("value", SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            retList.add(dataMap);
        }
        paramsMap.put("gradeDatas", retList);
    }

    public static Object dealSpItemValue(String uniqueCode, Object value, Map<String, ItemInfo> spItemInfoMap) {
        if (spItemInfoMap == null || value == null) {
            return value;
        }
        ItemInfo itemInfo = spItemInfoMap.get(uniqueCode);
        if (itemInfo == null) {
            return value;
        }
        if (DataTypeEnum.STRING.getDbId() == itemInfo.getDataTypeId()) {
            if (String.valueOf(value).length() > itemInfo.getDataLength()) {
                String msg = ResManager.loadKDString((String)"\u652f\u6301\u9879\u76ee\u201c{0}\u201d\u7684\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u957f\u5ea6\u8fc7\u957f\uff0c\u8d85\u51fa\u4e86\u6b64\u652f\u6301\u9879\u76ee\u8bbe\u7f6e\u7684\u6570\u636e\u957f\u5ea6\u201c{1}\u201d\u3002", (String)"FormulaParseUtils_0", (String)"swc-hscs-business", (Object[])new Object[]{itemInfo.getName(), itemInfo.getDataLength()});
                throw new KDBizException(msg);
            }
        } else if (DataTypeEnum.NUMBERIC.getDbId() == itemInfo.getDataTypeId()) {
            BigDecimal val = null;
            val = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(String.valueOf(value));
            value = val.setScale((int)itemInfo.getScale(), ItemDataUtils.getRoundingMode((long)itemInfo.getDataroundId()));
        }
        return value;
    }
}

