/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryCalMutexUtils {
    private static final Log LOGGER = LogFactory.getLog(SalaryCalMutexUtils.class);

    public static void checkPersonHrIsCaling(Map<Long, DynamicObject> personIndexMap, Map<Long, String> errorMap, String calType, Long calTaskId, List<DynamicObject> existDataList) {
        if (personIndexMap.size() == 0) {
            return;
        }
        DynamicObjectCollection calMutexDataList = SalaryCalMutexUtils.getSalaryCalMutexData(personIndexMap.keySet());
        DynamicObject calPerson = null;
        for (DynamicObject obj : calMutexDataList) {
            calPerson = personIndexMap.remove(obj.getLong("personindexid"));
            if (calPerson == null) continue;
            if (SWCStringUtils.equals((String)calType, (String)obj.getString("type")) && obj.getLong("caltask.id") == calTaskId.longValue() && calPerson.getLong("salaryfile.id") == obj.getLong("salaryfile.id")) {
                existDataList.add(calPerson);
                continue;
            }
            errorMap.put(calPerson.getLong("id"), SalaryCalMutexUtils.getMsgByType(obj, calType));
        }
    }

    private static String getMsgByType(DynamicObject obj, String calType) {
        String msg = "";
        if ("1".equals(calType)) {
            switch (obj.getString("type")) {
                case "1": {
                    msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u3002", (String)"SalaryCalMutexUtils_0", (String)"swc-hscs-business", (Object[])new Object[]{obj.getString("caltask.number")});
                    break;
                }
                case "2": {
                    msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\u56de\u6eda\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u56de\u6eda\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u3002", (String)"SalaryCalMutexUtils_2", (String)"swc-hscs-business", (Object[])new Object[]{obj.getString("caltask.number")});
                    break;
                }
                default: {
                    msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u7684\u7d2f\u52a0\u7ed3\u679c\u6b63\u5728\u88ab{0}{1}\u7528\u6237\u64cd\u4f5c\uff0c\u8bf7\u7b49\u5f85\u5176\u4ed6\u7528\u6237\u64cd\u4f5c\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u3002", (String)"SalaryCalMutexUtils_3", (String)"swc-hscs-business", (Object[])new Object[]{obj.getString("modifier.number"), obj.getString("modifier.name")});
                    break;
                }
            }
        } else {
            switch (obj.getString("type")) {
                case "1": {
                    msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u56de\u6eda\u3002", (String)"SalaryCalMutexUtils_4", (String)"swc-hscs-business", (Object[])new Object[]{obj.getString("caltask.number")});
                    break;
                }
                case "2": {
                    msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\u56de\u6eda\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u56de\u6eda\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u56de\u6eda\u3002", (String)"SalaryCalMutexUtils_1", (String)"swc-hscs-business", (Object[])new Object[]{obj.getString("caltask.number")});
                    break;
                }
                default: {
                    msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u7684\u7d2f\u52a0\u7ed3\u679c\u6b63\u5728\u88ab{0}{1}\u7528\u6237\u64cd\u4f5c\uff0c\u8bf7\u7b49\u5f85\u5176\u4ed6\u7528\u6237\u64cd\u4f5c\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u56de\u6eda\u3002", (String)"SalaryCalMutexUtils_5", (String)"swc-hscs-business", (Object[])new Object[]{obj.getString("modifier.number"), obj.getString("modifier.name")});
                }
            }
        }
        return msg;
    }

    public static void addSalaryCalMutexData(Map<Long, DynamicObject> personIndexMap, Map<Long, String> errorMap, String type, long calTaskId, List<DynamicObject> existDataList) {
        String lockKey = "_swc_hscs_salarycal";
        try (DLock lock = DLock.create((String)"_swc_hscs_salarycal");){
            LOGGER.info("start try lock...");
            if (lock.tryLock(30000L)) {
                LOGGER.info(" get locked...");
                SalaryCalMutexUtils.checkPersonHrIsCaling(personIndexMap, errorMap, type, calTaskId, existDataList);
                if (personIndexMap.size() > 0) {
                    SalaryCalMutexUtils.saveSalaryCalMutexData(personIndexMap, calTaskId, type);
                }
            } else {
                LOGGER.error("addSalaryCalmutex_tryLock fail");
            }
        }
        catch (Exception ex) {
            LOGGER.error("addSalaryCalMutex error.", (Throwable)ex);
        }
    }

    public static Map<Long, DynamicObject> checkRepeatAndBuildMap(DynamicObject[] calPersonArr, Map<Long, String> errorMap, String type) {
        LOGGER.info("checkRepeatAndBuildMap-start,errorMap size is {}", (Object)errorMap.size());
        HashMap<Long, DynamicObject> personIndexMap = new HashMap<Long, DynamicObject>(16);
        if (calPersonArr == null || calPersonArr.length == 0) {
            return personIndexMap;
        }
        for (DynamicObject obj : calPersonArr) {
            if (personIndexMap.containsKey(obj.getLong("personhrv.personindexid"))) {
                errorMap.put(obj.getLong("id"), SalaryCalMutexUtils.getRepeatMsgByType(type, obj.getString("caltask.number")));
                continue;
            }
            personIndexMap.put(obj.getLong("personhrv.personindexid"), obj);
        }
        LOGGER.info("checkRepeatAndBuildMap-end,errorMap size is {}", (Object)errorMap.size());
        return personIndexMap;
    }

    private static String getRepeatMsgByType(String type, String calTaskName) {
        String msg = "";
        msg = "1".equals(type) ? ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u3002", (String)"SalaryCalMutexUtils_0", (String)"swc-hscs-business", (Object[])new Object[]{calTaskName}) : ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\u56de\u6eda\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u56de\u6eda\u5b8c\u6210\u540e\uff0c\u518d\u53d1\u8d77\u672c\u85aa\u8d44\u6863\u6848\u7684\u8ba1\u7b97\u56de\u6eda\u3002", (String)"SalaryCalMutexUtils_1", (String)"swc-hscs-business", (Object[])new Object[]{calTaskName});
        return msg;
    }

    private static DynamicObjectCollection getSalaryCalMutexData(Set<Long> personIndexIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalmutex");
        QFilter filter = new QFilter("personindexid", "in", personIndexIdSet);
        return helper.queryOriginalCollection("caltask.number,caltask.id,personindexid,type,salaryfile.id,modifier.number,modifier.name", new QFilter[]{filter});
    }

    private static void saveSalaryCalMutexData(Map<Long, DynamicObject> personIndexMap, long calTaskId, String type) {
        LOGGER.info("saveSalaryCalMutexData start");
        DynamicObjectCollection calMutexCollection = new DynamicObjectCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hsas_salarycalmutex");
        DynamicObject calMutex = null;
        for (Map.Entry<Long, DynamicObject> entry : personIndexMap.entrySet()) {
            calMutex = (DynamicObject)entityType.createInstance();
            calMutex.set("caltask", (Object)calTaskId);
            calMutex.set("personindexid", (Object)entry.getKey());
            calMutex.set("employee", (Object)entry.getValue().getLong("employee.id"));
            calMutex.set("salaryfile", (Object)entry.getValue().getLong("salaryfile.id"));
            calMutex.set("createtime", (Object)new Date());
            calMutex.set("modifytime", (Object)new Date());
            calMutex.set("type", (Object)type);
            calMutex.set("creator", (Object)RequestContext.get().getCurrUserId());
            calMutex.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calMutexCollection.add((Object)calMutex);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalmutex");
        helper.save(calMutexCollection);
        LOGGER.info("saveSalaryCalMutexData end");
    }
}

