/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cost.calcostsetupchain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.swc.hscs.business.cost.calcostsetupchain.Superposition;
import kd.swc.hscs.business.cost.service.GenerateCostSetUpService;
import kd.swc.hscs.business.cost.vo.SalaryfileInfo;
import kd.swc.hscs.business.cost.vo.SetUpCommonInfo;

public class SuperpositionChain {
    private List<Superposition> superpositionNodeList = new ArrayList<Superposition>(10);
    private SalaryfileInfo salaryfileInfo;
    private Long salaryItemId;
    private BigDecimal restPercentage;
    private ORM orm;
    private DynamicObject costSetupRst;
    private DynamicObjectCollection costSetupRstColl;

    public SuperpositionChain(SalaryfileInfo salaryfileInfo, Long salaryItemId, BigDecimal restPercentage, ORM orm, DynamicObject costSetupRst, DynamicObjectCollection costSetupRstColl) {
        this.costSetupRst = costSetupRst;
        this.salaryfileInfo = salaryfileInfo;
        this.restPercentage = restPercentage;
        this.orm = orm;
        this.costSetupRstColl = costSetupRstColl;
        this.salaryItemId = salaryItemId;
    }

    public SuperpositionChain add(Superposition superposition) {
        this.superpositionNodeList.add(superposition);
        return this;
    }

    public Map<String, Object> doSuperposition(SetUpCommonInfo setUpCommonInfo, Map<Long, DynamicObject> costSegstoreIdRefObjeMap, Map<String, Long> costSetupConstMap, List<String> newCostSetupKeyList) {
        GenerateCostSetUpService generateCostSetUpService = new GenerateCostSetUpService(setUpCommonInfo, costSegstoreIdRefObjeMap, costSetupConstMap, newCostSetupKeyList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        List<Map<String, Object>> superpositionRstList = new ArrayList<Map<String, Object>>(10);
        for (Superposition superposition : this.superpositionNodeList) {
            superpositionRstList = superposition.superpositionRst(generateCostSetUpService, superpositionRstList);
            if (!generateCostSetUpService.validateSetUpRstIsFull(superpositionRstList)) continue;
            DynamicObject costSetupRstObj = generateCostSetUpService.createCostSetUpDynamicObj(this.salaryItemId, this.salaryfileInfo, superpositionRstList, this.restPercentage, this.orm, this.costSetupRst);
            this.costSetupRstColl.add((Object)costSetupRstObj);
            resultMap.put("isFull", Boolean.TRUE);
            resultMap.put("superpositionRstList", superpositionRstList);
            return resultMap;
        }
        resultMap.put("isFull", Boolean.FALSE);
        resultMap.put("superpositionRstList", superpositionRstList);
        return resultMap;
    }

    public StringBuilder getLogString() {
        StringBuilder builder = new StringBuilder();
        for (Superposition superposition : this.superpositionNodeList) {
            StringBuilder logBuilder = superposition.getLogBuilder();
            if (logBuilder.length() <= 0) continue;
            builder.append((CharSequence)logBuilder);
        }
        return builder;
    }
}

