/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cost.helper;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cost.util.CostUtils;
import kd.swc.hscs.business.cost.vo.CostCfg;
import kd.swc.hscs.business.cost.vo.CostCfgEntry;
import kd.swc.hscs.business.cost.vo.SetUpCommonInfo;
import kd.swc.hscs.common.constants.CostCfgConstants;

public class GenerateCostSetUpHelper {
    private static final Log LOGGER = LogFactory.getLog(GenerateCostSetUpHelper.class);
    public static final long DATATYPE_ID = 1020L;

    public static Map<Long, Map<String, CostCfg>> querySalaryfileCostCfgMap(Long costAdapterId, Date calTaskEndDate, List<Long> salaryfileIdList) {
        Long[] availableSourceType;
        List<Long> sourceTypeList = Arrays.asList(SWCCostConstants.COST_TYPE_SALARYFILE, SWCCostConstants.COST_TYPE_SALARYFILEITEM);
        Map<Long, Set<String>> disableMap = GenerateCostSetUpHelper.getDisableCostCfg(costAdapterId, sourceTypeList);
        String sql = GenerateCostSetUpHelper.getSalaryfileSql(salaryfileIdList);
        DataSet dataSet = DB.queryDataSet((String)"kd.swc.hscs.business.cost.helper.GenerateCostSetUpHelper.querySalaryfileCostCfgMap", (DBRoute)DBRoute.of((String)"swc"), (String)sql, (Object[])new Object[]{costAdapterId, costAdapterId});
        HashMap<Long, Map<String, CostCfg>> sourceTypeIdRegCostCfgObjMap = new HashMap<Long, Map<String, CostCfg>>(16);
        for (Long sourceType : availableSourceType = CostCfgConstants.getAvailableSourceType()) {
            sourceTypeIdRegCostCfgObjMap.put(sourceType, new HashMap(16));
        }
        try {
            for (Row row : dataSet) {
                List<Object> costCfgEntryList;
                CostCfg costCfg;
                Date bsedDate = row.getDate("BSED");
                Date bsledDate = row.getDate("BSLED");
                if (calTaskEndDate.before(bsedDate) || calTaskEndDate.after(bsledDate)) continue;
                Long sourceType = row.getLong("SOURCETYPE");
                Long sourceId = row.getLong("SOURCE");
                Long cfgId = row.getLong("ID");
                Long entryId = row.getLong("ENTRYID");
                Long creatorObjId = row.getLong("CREATOROBJ");
                BigDecimal costPropotion = row.getBigDecimal("CFGPROPORTION");
                String costStruCfgValue = row.getString("STRUCFGVAL");
                Long costSegstoreId = row.getLong("SEGSTORE");
                String sourceIdKey = SWCCostConstants.COST_TYPE_SALARYFILEITEM.equals(sourceType) ? String.join((CharSequence)"_", sourceId.toString(), creatorObjId.toString()) : sourceId.toString();
                Set<String> disableSet = disableMap.get(sourceType);
                if (!CollectionUtils.isEmpty(disableSet) && disableSet.contains(sourceIdKey)) continue;
                HashMap<String, CostCfg> sourceIdRefCfgObjInfoMap = (HashMap<String, CostCfg>)sourceTypeIdRegCostCfgObjMap.get(sourceType);
                if (sourceIdRefCfgObjInfoMap == null) {
                    sourceIdRefCfgObjInfoMap = new HashMap<String, CostCfg>(16);
                    costCfg = new CostCfg(cfgId, creatorObjId);
                    costCfgEntryList = new ArrayList(10);
                    costCfgEntryList.add(new CostCfgEntry(entryId, costPropotion, costSegstoreId, costStruCfgValue));
                    costCfg.setCostCfgEntryList(costCfgEntryList);
                    sourceIdRefCfgObjInfoMap.put(sourceIdKey, costCfg);
                    sourceTypeIdRegCostCfgObjMap.put(sourceType, sourceIdRefCfgObjInfoMap);
                    continue;
                }
                costCfg = (CostCfg)sourceIdRefCfgObjInfoMap.get(sourceIdKey);
                if (costCfg == null) {
                    costCfg = new CostCfg(cfgId, creatorObjId);
                    costCfgEntryList = costCfg.getCostCfgEntryList();
                    if (costCfgEntryList == null) {
                        costCfgEntryList = new ArrayList(10);
                        costCfg.setCostCfgEntryList(costCfgEntryList);
                    }
                    costCfgEntryList.add(new CostCfgEntry(entryId, costPropotion, costSegstoreId, costStruCfgValue));
                    sourceIdRefCfgObjInfoMap.put(sourceIdKey, costCfg);
                    sourceTypeIdRegCostCfgObjMap.put(sourceType, sourceIdRefCfgObjInfoMap);
                    continue;
                }
                costCfg.getCostCfgEntryList().add(new CostCfgEntry(entryId, costPropotion, costSegstoreId, costStruCfgValue));
            }
            HashMap<Long, Map<String, CostCfg>> hashMap = sourceTypeIdRegCostCfgObjMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "querySalaryfileCostCfgMap Error:%s", e.getMessage())});
        }
        finally {
            dataSet.close();
        }
    }

    private static String getSalaryfileSql(List<Long> salaryfileIdList) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT CFG.FID ID,ENT.FENTRYID ENTRYID,CFG.FSOURCEID SOURCE,CFG.FCOSTADAPTERID ADAPTER,CFG.FCREATOROBJID CREATOROBJ,");
        sb.append(" CFG.FSOURCETYPEID SOURCETYPE,ENT.FCOSTSTRUCFGVALUE STRUCFGVAL,ENT.FCOSTCFGPROPORTION CFGPROPORTION,ENT.FCOSTSEGSTOREID SEGSTORE,");
        sb.append(" CFG.FBSED BSED,CFG.FBSLED BSLED FROM T_PCS_COSTCFG CFG JOIN T_PCS_COSTCFGENT ENT ON CFG.FID = ENT.FID");
        sb.append(" WHERE CFG.FSOURCETYPEID=1080 AND CFG.FCOSTADAPTERID=? AND CFG.FDATASTATUS IN('0','1','2') AND CFG.FISCURRENTVERSION='0' AND CFG.FENABLE='1' AND FCREATOROBJID IN(");
        sb.append(GenerateCostSetUpHelper.list2String(salaryfileIdList));
        sb.append(')');
        sb.append(" UNION All");
        sb.append(" SELECT CFG.FID ID,ENT.FENTRYID ENTRYID,CFG.FSOURCEID SOURCE,CFG.FCOSTADAPTERID ADAPTER,CFG.FCREATOROBJID CREATOROBJ,");
        sb.append(" CFG.FSOURCETYPEID SOURCETYPE,ENT.FCOSTSTRUCFGVALUE STRUCFGVAL,ENT.FCOSTCFGPROPORTION CFGPROPORTION,ENT.FCOSTSEGSTOREID SEGSTORE,");
        sb.append(" CFG.FBSED BSED,CFG.FBSLED BSLED FROM T_PCS_COSTCFG CFG JOIN T_PCS_COSTCFGENT ENT ON CFG.FID = ENT.FID");
        sb.append(" WHERE CFG.FSOURCETYPEID=1070 AND CFG.FCOSTADAPTERID=? AND CFG.FDATASTATUS IN('0','1','2') AND CFG.FISCURRENTVERSION='0' AND CFG.FENABLE='1' AND FSOURCEID IN(");
        sb.append(GenerateCostSetUpHelper.list2String(salaryfileIdList));
        sb.append(')');
        return sb.toString();
    }

    private static String list2String(List<Long> salaryfileIdList) {
        if (salaryfileIdList == null || salaryfileIdList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        salaryfileIdList.forEach(salaryfileId -> sb.append(salaryfileId).append(','));
        return sb.substring(0, sb.length() - 1);
    }

    public static Map<Long, Map<String, CostCfg>> queryBasicCostCfgMap(Long costAdapterId, Date calTaskEndDate) {
        Long[] availableSourceType;
        List<Long> sourceTypeList = Arrays.asList(SWCCostConstants.COST_TYPE_DEPT, SWCCostConstants.COST_TYPE_POST, SWCCostConstants.COST_TYPE_EMP);
        Map<Long, Set<String>> disableMap = GenerateCostSetUpHelper.getDisableCostCfg(costAdapterId, sourceTypeList);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT CFG.FID ID,ENT.FENTRYID ENTRYID,CFG.FSOURCEID SOURCE,CFG.FCOSTADAPTERID ADAPTER,CFG.FCREATOROBJID CREATOROBJ,");
        sb.append(" CFG.FSOURCETYPEID SOURCETYPE,ENT.FCOSTSTRUCFGVALUE STRUCFGVAL,ENT.FCOSTCFGPROPORTION CFGPROPORTION,ENT.FCOSTSEGSTOREID SEGSTORE,");
        sb.append(" CFG.FBSED BSED,CFG.FBSLED BSLED FROM T_PCS_COSTCFG CFG JOIN T_PCS_COSTCFGENT ENT ON CFG.FID = ENT.FID");
        sb.append(" WHERE CFG.FSOURCETYPEID  IN(1050, 1030, 1060)");
        sb.append(" AND CFG.FCOSTADAPTERID=? AND CFG.FDATASTATUS IN('0','1','2') AND CFG.FISCURRENTVERSION='0' AND CFG.FENABLE='1'");
        DataSet dataSet = DB.queryDataSet((String)"kd.swc.hscs.business.cost.helper.GenerateCostSetUpHelper.queryBasicCostCfgMap", (DBRoute)DBRoute.of((String)"swc"), (String)sb.toString(), (Object[])new Object[]{costAdapterId});
        HashMap<Long, Map<String, CostCfg>> sourceTypeIdRegCostCfgObjMap = new HashMap<Long, Map<String, CostCfg>>(16);
        for (Long sourceType : availableSourceType = CostCfgConstants.getAvailableSourceType()) {
            sourceTypeIdRegCostCfgObjMap.put(sourceType, new HashMap(16));
        }
        try {
            for (Row row : dataSet) {
                ArrayList<CostCfgEntry> costCfgEntryList;
                CostCfg costCfg;
                Date bsedDate = row.getDate("BSED");
                Date bsledDate = row.getDate("BSLED");
                if (calTaskEndDate.before(bsedDate) || calTaskEndDate.after(bsledDate)) continue;
                Long sourceType = row.getLong("SOURCETYPE");
                Long sourceId = row.getLong("SOURCE");
                Long cfgId = row.getLong("ID");
                Long entryId = row.getLong("ENTRYID");
                Long creatorObjId = row.getLong("CREATOROBJ");
                BigDecimal costPropotion = row.getBigDecimal("CFGPROPORTION");
                String costStruCfgValue = row.getString("STRUCFGVAL");
                Long costSegstoreId = row.getLong("SEGSTORE");
                String sourceIdKey = sourceType.equals(SWCCostConstants.COST_TYPE_SALARYFILEITEM) ? String.join((CharSequence)"_", sourceId.toString(), creatorObjId.toString()) : sourceId.toString();
                Set<String> disableSet = disableMap.get(sourceType);
                if (!CollectionUtils.isEmpty(disableSet) && disableSet.contains(sourceIdKey)) continue;
                HashMap<String, CostCfg> sourceIdRefCfgObjInfoMap = (HashMap<String, CostCfg>)sourceTypeIdRegCostCfgObjMap.get(sourceType);
                if (sourceIdRefCfgObjInfoMap == null) {
                    sourceIdRefCfgObjInfoMap = new HashMap<String, CostCfg>(16);
                    costCfg = new CostCfg(cfgId, creatorObjId);
                    costCfgEntryList = new ArrayList<CostCfgEntry>(10);
                    costCfgEntryList.add(new CostCfgEntry(entryId, costPropotion, costSegstoreId, costStruCfgValue));
                    costCfg.setCostCfgEntryList(costCfgEntryList);
                    sourceIdRefCfgObjInfoMap.put(sourceIdKey, costCfg);
                    sourceTypeIdRegCostCfgObjMap.put(sourceType, sourceIdRefCfgObjInfoMap);
                    continue;
                }
                costCfg = (CostCfg)sourceIdRefCfgObjInfoMap.get(sourceIdKey);
                if (costCfg == null) {
                    costCfg = new CostCfg(cfgId, creatorObjId);
                    costCfg.setSourceId(sourceId);
                    costCfgEntryList = costCfg.getCostCfgEntryList();
                    if (costCfgEntryList == null) {
                        costCfgEntryList = new ArrayList(10);
                        costCfg.setCostCfgEntryList(costCfgEntryList);
                    }
                    costCfgEntryList.add(new CostCfgEntry(entryId, costPropotion, costSegstoreId, costStruCfgValue));
                    sourceIdRefCfgObjInfoMap.put(sourceIdKey, costCfg);
                    sourceTypeIdRegCostCfgObjMap.put(sourceType, sourceIdRefCfgObjInfoMap);
                    continue;
                }
                costCfg.getCostCfgEntryList().add(new CostCfgEntry(entryId, costPropotion, costSegstoreId, costStruCfgValue));
                costCfg.setSourceId(sourceId);
            }
            HashMap<Long, Map<String, CostCfg>> hashMap = sourceTypeIdRegCostCfgObjMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "queryBasicCostCfgMap Error:%s", e.getMessage())});
        }
        finally {
            dataSet.close();
        }
    }

    public static Map<Long, Set<String>> getDisableCostCfg(Long costAdapterId, List<Long> sourceTypeList) {
        HashMap<Long, Set<String>> disableCostCfgMap = new HashMap<Long, Set<String>>(16);
        ArrayList<Long> paramList = new ArrayList<Long>(sourceTypeList.size() + 1);
        paramList.add(costAdapterId);
        paramList.addAll(sourceTypeList);
        String sql = GenerateCostSetUpHelper.getQuerySql(sourceTypeList.size());
        try (DataSet dataSet = DB.queryDataSet((String)"kd.swc.hscs.business.cost.helper.GenerateCostSetUpHelper.getDisableCostCfg", (DBRoute)DBRoute.of((String)"swc"), (String)sql, (Object[])paramList.toArray());){
            for (Row row : dataSet) {
                Long sourceType = row.getLong("SOURCETYPE");
                Long sourceId = row.getLong("SOURCE");
                Long creatorObjId = row.getLong("CREATOROBJ");
                String sourceIdKey = sourceType.equals(SWCCostConstants.COST_TYPE_SALARYFILEITEM) ? String.join((CharSequence)"_", sourceId.toString(), creatorObjId.toString()) : sourceId.toString();
                HashSet<String> sourceIdSet = (HashSet<String>)disableCostCfgMap.get(sourceType);
                if (CollectionUtils.isEmpty((Collection)sourceIdSet)) {
                    sourceIdSet = new HashSet<String>();
                }
                sourceIdSet.add(sourceIdKey);
                disableCostCfgMap.put(sourceType, sourceIdSet);
            }
        }
        return disableCostCfgMap;
    }

    private static String getQuerySql(int size) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT CFG.FID ID,CFG.FSOURCEID SOURCE,CFG.FCREATOROBJID CREATOROBJ,CFG.FSOURCETYPEID SOURCETYPE");
        sb.append(" FROM T_PCS_COSTCFG CFG");
        sb.append(" WHERE CFG.FISCURRENTVERSION='1' AND CFG.FENABLE='0' AND CFG.FCOSTADAPTERID=? AND CFG.FSOURCETYPEID  IN(");
        for (int i = 0; i < size; ++i) {
            sb.append('?');
            if (i + 1 >= size) continue;
            sb.append(',');
        }
        sb.append(")");
        return sb.toString();
    }

    public static DynamicObject[] querySalaryfileArr(List<Long> salaryfileIdList, String salaryfileField) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter numberFilter = new QFilter("id", "in", salaryfileIdList);
        String selectProperties = "number,name,paystatus,bred,blred,adminorg.name,empgroup,empposinfo.company,empposinfo.adminorg,empposinfo.position.name,person,employee," + salaryfileField;
        DynamicObject[] salaryfileArr = serviceHelper.query(selectProperties, new QFilter[]{numberFilter});
        return salaryfileArr;
    }

    public static int[] queryDimensionStoragesetArr(Long costStruId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        DynamicObject costStruObj = serviceHelper.queryOne("dimensionentry.storageset", (Object)costStruId);
        DynamicObjectCollection dynamicObjectCollection = costStruObj.getDynamicObjectCollection("dimensionentry");
        int[] storageArr = new int[dynamicObjectCollection.size()];
        int index = 0;
        for (DynamicObject costStruEntry : dynamicObjectCollection) {
            storageArr[index++] = costStruEntry.getInt("storageset.number");
        }
        return storageArr;
    }

    public static List<String> queryisRequiredFieldList(Long costStruId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        DynamicObject costStruObj = serviceHelper.queryOne("costdimension,isrequired,storageset", (Object)costStruId);
        DynamicObjectCollection entryEntity = costStruObj.getDynamicObjectCollection("dimensionentry");
        ArrayList<String> requiredFieldList = new ArrayList<String>(entryEntity.size());
        entryEntity.forEach(entry -> {
            boolean isRequired = entry.getBoolean("isrequired");
            if (isRequired) {
                requiredFieldList.add("segment" + entry.getString("storageset.number"));
            }
        });
        return requiredFieldList;
    }

    public static DynamicObject[] queryCostSegstoreArrByIds(Object costSegstoreIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsegstore");
        QFilter idFilter = new QFilter("id", "in", costSegstoreIdList);
        return serviceHelper.queryOriginalArray("id,segment1,segment2,segment3,segment4,segment5,segment6,segment7,segment8,segment9,segment10,segment11,segment12,segment13,segment14,segment15,segment16,segment17,segment18,segment19,segment20,segment21,segment22,segment23,segment24,segment25,segment26,segment27,segment28,segment29,segment30", new QFilter[]{idFilter});
    }

    public static Map<String, Long> queryCostSetupConstMap(Long costStruId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        QFilter costStruFilter = new QFilter("coststru", "=", (Object)costStruId);
        DynamicObject[] costSetUpConstArr = serviceHelper.queryOriginalArray("id,coststru,segmentval", new QFilter[]{costStruFilter});
        HashMap<String, Long> setUpConstInfoMap = new HashMap<String, Long>(costSetUpConstArr.length);
        for (DynamicObject setUpConstObj : costSetUpConstArr) {
            String segmentVal = setUpConstObj.getString("segmentval");
            setUpConstInfoMap.put(segmentVal, setUpConstObj.getLong("id"));
        }
        return setUpConstInfoMap;
    }

    public static Map<String, Long> queryDefinedCostSetUp(Long calTaskId, List<Long> salaryfileIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        calTaskFilter.and(new QFilter("isdefined", "=", (Object)"1"));
        calTaskFilter.and(new QFilter("salaryfile.id", "in", salaryfileIdList));
        DynamicObject[] costSetUpObjjArr = serviceHelper.query("id,salaryfile,salaryitem,isdefined", new QFilter[]{calTaskFilter});
        HashMap<String, Long> isDefinedCostSetUpMap = new HashMap<String, Long>(costSetUpObjjArr.length);
        for (DynamicObject costSetUp : costSetUpObjjArr) {
            String salaryfileId = costSetUp.getString("salaryfile.id");
            String salaryItemId = costSetUp.getString("salaryitem.id");
            long costSetUpId = costSetUp.getLong("id");
            String key = String.join((CharSequence)"_", salaryfileId, salaryItemId);
            isDefinedCostSetUpMap.put(key, costSetUpId);
        }
        return isDefinedCostSetUpMap;
    }

    public static DynamicObject queryCostStruIdByCostAdapterDy(Long costAdapterId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costadaption");
        return serviceHelper.queryOriginalOne("coststru.id,createorg.id", (Object)costAdapterId);
    }

    public static DynamicObject[] queryCostItemCfg(Set<Long> salaryItemIds, Long costAdapterId, Date calTaskEndDate, List<Long> costSalaryItemEnableIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costitemcfg");
        QFilter costAdapterFilter = new QFilter("costadapter", "=", (Object)costAdapterId);
        costAdapterFilter.and(new QFilter("sourcetype", "=", (Object)SWCCostConstants.COST_TYPE_ITEM));
        costAdapterFilter.and(new QFilter("source", "in", salaryItemIds));
        GenerateCostSetUpHelper.addCostCfgCommonFilter(calTaskEndDate, costAdapterFilter);
        costAdapterFilter.and(new QFilter("boid", "in", costSalaryItemEnableIdList));
        String properties = "source,calcostproportion,coststrucfgvalue,costsegstore,costcfgtypeproportion,costtypesegstore,coststrutypecfgvalue,qualitydim,qualitynumber,groupvalue";
        DynamicObject[] costCfgArr = serviceHelper.query(properties, new QFilter[]{costAdapterFilter});
        return costCfgArr;
    }

    private static void addCostCfgCommonFilter(Date calTaskEndDate, QFilter costAdapterFilter) {
        costAdapterFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        costAdapterFilter.and(new QFilter("bsed", "<=", (Object)calTaskEndDate));
        costAdapterFilter.and(new QFilter("bsled", ">=", (Object)calTaskEndDate));
        costAdapterFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        costAdapterFilter.and(new QFilter("enable", "=", (Object)"1"));
    }

    public static Date convertDate(Date calTaskEndDate) {
        String format = SWCDateTimeUtils.format((Date)calTaskEndDate, (String)"yyyy-MM-dd");
        Date date = null;
        try {
            date = SWCDateTimeUtils.parseDate((String)format);
        }
        catch (ParseException e) {
            LOGGER.error("GenerateCostSetUpHelper convertDate error:", (Object)e.getMessage());
        }
        return date;
    }

    public static DynamicObject[] queryDeptDefalutCostCfg(Collection<Long> deptIds, Long costAdapterId, Date calTaskEndDate) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costdeptcfg");
        QFilter costAdapterFilter = new QFilter("costadapter", "=", (Object)costAdapterId);
        costAdapterFilter.and(new QFilter("sourcetype", "=", (Object)SWCCostConstants.COST_TYPE_DEPT));
        GenerateCostSetUpHelper.addCostCfgCommonFilter(calTaskEndDate, costAdapterFilter);
        String properties = "source,costcfgtypeproportion,costtypesegstore,coststrutypecfgvalue";
        DynamicObject[] costCfgArr = serviceHelper.query(properties, new QFilter[]{costAdapterFilter});
        return costCfgArr;
    }

    public static DynamicObject queryCalPalRollTaskObj(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("calrulev.id", (Object)calTaskId);
        return calTaskObj;
    }

    public static DynamicObject queryCalPalRollTask(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return serviceHelper.queryOne("org,payrollgroup,ENDDATE,payrolldate", (Object)calTaskId);
    }

    public static Map<Long, DynamicObject> getSalaryItemIdListByCalTaskId(Long calTaskId) {
        DynamicObject[] salaryFileItemArr;
        DynamicObject calTaskObj = GenerateCostSetUpHelper.queryCalPalRollTaskObj(calTaskId);
        Long calRuleHisId = calTaskObj.getLong("calrulev.id");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRuleHisObj = serviceHelper.queryOne("salaryitem,iscostallot", (Object)calRuleHisId);
        DynamicObjectCollection calRuleItemEntryColl = calRuleHisObj.getDynamicObjectCollection("calruleitementry");
        HashMap salaryItemIdRefSalaryItemMap = Maps.newHashMapWithExpectedSize((int)calRuleItemEntryColl.size());
        ArrayList salaryFileItemIdList = new ArrayList(calRuleItemEntryColl.size());
        calRuleItemEntryColl.forEach(calRuleItemEntry -> {
            String isCostAllot = calRuleItemEntry.getString("iscostallot");
            if ("1".equals(isCostAllot)) {
                salaryFileItemIdList.add(calRuleItemEntry.getLong("salaryitem.id"));
            }
        });
        serviceHelper.setEntityName("hsbs_salaryitem");
        for (DynamicObject salaryFileItem : salaryFileItemArr = serviceHelper.query("id,datatype,name,iscostallot,isfixedcost", new QFilter[]{new QFilter("id", "in", salaryFileItemIdList)})) {
            long dataTypeId = salaryFileItem.getLong("datatype.id");
            if (dataTypeId != 1020L) continue;
            salaryItemIdRefSalaryItemMap.put(salaryFileItem.getLong("id"), salaryFileItem);
        }
        return salaryItemIdRefSalaryItemMap;
    }

    public static Map<Long, Long> getSalaryItemRefCostItemMap(Collection<DynamicObject> salaryItemColl, DynamicObject calPalRollTask, Long createOrgId) {
        int salaryItemSize = salaryItemColl.size();
        HashMap<Long, Long> salaryItemRefCostItemMap = new HashMap<Long, Long>(salaryItemSize);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costpayrollgroupmap");
        ArrayList<Long> salaryItemIdList = new ArrayList<Long>(salaryItemSize);
        for (DynamicObject salaryItem : salaryItemColl) {
            salaryItemIdList.add(salaryItem.getLong("id"));
        }
        GenerateCostSetUpHelper.getSalaryItemRefCostItemFromOrg(serviceHelper, calPalRollTask, salaryItemIdList, salaryItemRefCostItemMap, createOrgId);
        GenerateCostSetUpHelper.getSalaryItemRefCostItemFromCalPayrollGrp(serviceHelper, calPalRollTask, salaryItemIdList, salaryItemRefCostItemMap, createOrgId);
        return salaryItemRefCostItemMap;
    }

    private static void getSalaryItemRefCostItemFromOrg(SWCDataServiceHelper serviceHelper, DynamicObject calPalRollTask, List<Long> salaryItemIdList, Map<Long, Long> salaryItemRefCostItemMap, Long createOrgId) {
        serviceHelper.setEntityName("pcs_costpayrollcalmap");
        Date calTaskEndDate = calPalRollTask.getDate("ENDDATE");
        calTaskEndDate = GenerateCostSetUpHelper.convertDate(calTaskEndDate);
        long orgId = calPalRollTask.getLong("org.id");
        List<Long> enableIdList = GenerateCostSetUpHelper.getSalaryEnableIdsFromCostCal(createOrgId, orgId, serviceHelper, salaryItemIdList);
        if (CollectionUtils.isEmpty(enableIdList)) {
            return;
        }
        QFilter qFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_SALARYITEM);
        qFilter.and(new QFilter("payrollcal", "=", (Object)orgId));
        qFilter.and(new QFilter("hrorg", "=", (Object)createOrgId));
        qFilter.and(new QFilter("bsed", "<=", (Object)calTaskEndDate));
        qFilter.and(new QFilter("bsled", ">=", (Object)calTaskEndDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        DynamicObject[] costPayrollCal = serviceHelper.query("costitem,salaryitem", new QFilter[]{qFilter}, "bsed");
        if (costPayrollCal == null || costPayrollCal.length == 0) {
            return;
        }
        for (DynamicObject costPayrollCalObj : costPayrollCal) {
            Long costItemId = costPayrollCalObj.getLong("costitem.id");
            Long salaryItemId = costPayrollCalObj.getLong("salaryitem.id");
            if (!enableIdList.contains(salaryItemId)) continue;
            salaryItemRefCostItemMap.put(salaryItemId, costItemId);
        }
    }

    private static List<Long> getSalaryEnableIdsFromCostCal(Long createOrgId, long orgId, SWCDataServiceHelper serviceHelper, List<Long> salaryItemIdList) {
        QFilter currentFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_SALARYITEM);
        GenerateCostSetUpHelper.addCurrentEnableCommonFilter(createOrgId, orgId, currentFilter, salaryItemIdList);
        List<Long> enableSalaryItemList = GenerateCostSetUpHelper.getEnableIdList(currentFilter, serviceHelper);
        return enableSalaryItemList;
    }

    private static List<Long> getSalaryEnableIdsFromCostGroup(Long createOrgId, long calPayrollGrpId, long orgId, SWCDataServiceHelper serviceHelper, List<Long> salaryItemIdList) {
        QFilter currentFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
        currentFilter.and(new QFilter("source", "=", (Object)calPayrollGrpId));
        GenerateCostSetUpHelper.addCurrentEnableCommonFilter(createOrgId, orgId, currentFilter, salaryItemIdList);
        List<Long> enableSalaryItemList = GenerateCostSetUpHelper.getEnableIdList(currentFilter, serviceHelper);
        return enableSalaryItemList;
    }

    private static void addCurrentEnableCommonFilter(Long createOrgId, long orgId, QFilter currentFilter, List<Long> salaryItemIdList) {
        currentFilter.and(new QFilter("hrorg", "=", (Object)createOrgId));
        currentFilter.and(new QFilter("payrollcal", "=", (Object)orgId));
        currentFilter.and(new QFilter("enable", "=", (Object)"1"));
        currentFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        currentFilter.and(new QFilter("salaryitem", "in", salaryItemIdList));
    }

    private static List<Long> getEnableIdList(QFilter currentFilter, SWCDataServiceHelper serviceHelper) {
        DynamicObject[] enableCostItemArray;
        ArrayList<Long> enableSalaryItemList = new ArrayList<Long>(10);
        for (DynamicObject enableCostItemDy : enableCostItemArray = serviceHelper.query("salaryitem", new QFilter[]{currentFilter})) {
            long salaryItemId = enableCostItemDy.getLong("salaryitem.id");
            enableSalaryItemList.add(salaryItemId);
        }
        return enableSalaryItemList;
    }

    private static void getSalaryItemRefCostItemFromCalPayrollGrp(SWCDataServiceHelper serviceHelper, DynamicObject calPalRollTask, List<Long> salaryItemIdList, Map<Long, Long> salaryItemRefCostItemMap, Long createOrgId) {
        serviceHelper.setEntityName("pcs_costpayrollgroupmap");
        long calPayrollGrpId = calPalRollTask.getLong("payrollgroup.id");
        long orgId = calPalRollTask.getLong("org.id");
        Date calTaskEndDate = calPalRollTask.getDate("ENDDATE");
        calTaskEndDate = GenerateCostSetUpHelper.convertDate(calTaskEndDate);
        List<Long> enableIdList = GenerateCostSetUpHelper.getSalaryEnableIdsFromCostGroup(createOrgId, calPayrollGrpId, orgId, serviceHelper, salaryItemIdList);
        if (CollectionUtils.isEmpty(enableIdList)) {
            return;
        }
        QFilter qFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
        qFilter.and(new QFilter("source", "=", (Object)calPayrollGrpId));
        qFilter.and(new QFilter("payrollcal", "=", (Object)orgId));
        qFilter.and(new QFilter("hrorg", "=", (Object)createOrgId));
        qFilter.and(new QFilter("bsed", "<=", (Object)calTaskEndDate));
        qFilter.and(new QFilter("bsled", ">=", (Object)calTaskEndDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        DynamicObject[] costCalPayrollGrpArray = serviceHelper.query("costitem,salaryitem", new QFilter[]{qFilter});
        if (costCalPayrollGrpArray.length == 0) {
            return;
        }
        for (DynamicObject costCalPayrollGrp : costCalPayrollGrpArray) {
            long costItemId = costCalPayrollGrp.getLong("costitem.id");
            long salaryItemId = costCalPayrollGrp.getLong("salaryitem.id");
            if (!enableIdList.contains(salaryItemId)) continue;
            salaryItemRefCostItemMap.put(salaryItemId, costItemId);
        }
    }

    public static void updateCostAllocationStatus(Long costAllocationId, String costTaskStatus) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costallocation");
        DynamicObject costAllocationObj = serviceHelper.queryOne("modifytime,costtaskstatus,modifier", (Object)costAllocationId);
        if (costAllocationObj == null) {
            return;
        }
        costAllocationObj.set("modifytime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        costAllocationObj.set("modifier", (Object)userId);
        costAllocationObj.set("costtaskstatus", (Object)costTaskStatus);
        serviceHelper.saveOne(costAllocationObj);
    }

    public static void updateCostAllocationRecordInfo(Long costAllocationRecordId, String costTaskStatus, int failCount) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costrecord");
        DynamicObject costRecordObj = serviceHelper.queryOne("costtaskstatus,downloadurl,createtime,finishtime,usetime,failcount,modifier", (Object)costAllocationRecordId);
        if (costRecordObj == null) {
            return;
        }
        Date currentTime = new Date();
        costRecordObj.set("costtaskstatus", (Object)costTaskStatus);
        costRecordObj.set("finishtime", (Object)currentTime);
        long userId = RequestContext.get().getCurrUserId();
        costRecordObj.set("modifier", (Object)userId);
        costRecordObj.set("failcount", (Object)failCount);
        serviceHelper.saveOne(costRecordObj);
    }

    public static Map<String, Map<String, List<Map<String, Object>>>> getCostSalaryItemAndQualityCfgMap(DynamicObject[] costItemCfgArr, Map<Long, List<DynamicObject>> costCfgQualityMap) {
        List<Long> costSegstoreIds = GenerateCostSetUpHelper.getCostSegstoreIds(costItemCfgArr);
        Map<Long, DynamicObject> costSegstroeIdRefObjeMap = GenerateCostSetUpHelper.queryCostSegstoreIdRefObjeMap(costSegstoreIds);
        HashMap<String, Map<String, List<Map<String, Object>>>> costItemCfgInfoMap = new HashMap<String, Map<String, List<Map<String, Object>>>>(costItemCfgArr.length);
        for (DynamicObject costItemCfg : costItemCfgArr) {
            String salaryItemId = costItemCfg.getString("source.id");
            List<DynamicObject> costCfgQualityList = costCfgQualityMap.get(costItemCfg.getLong("id"));
            String qualityNumber = costItemCfg.getString("qualitynumber");
            if (SWCStringUtils.isNotEmpty((String)qualityNumber) && !SWCListUtils.isEmpty(costCfgQualityList)) {
                salaryItemId = String.join((CharSequence)"||", salaryItemId, costCfgQualityList.get(0).getString("qualitydim.salaryfilefield"));
                StringBuilder stringBuilder = new StringBuilder();
                costCfgQualityList.forEach(costCfgQuality -> stringBuilder.append(costCfgQuality.getString("groupvalue")).append(';'));
                salaryItemId = String.join((CharSequence)"||", salaryItemId, stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            HashMap<String, List<Map<String, Object>>> costSourceTypeRefObjMap = new HashMap<String, List<Map<String, Object>>>(16);
            GenerateCostSetUpHelper.packageEntityInfo(costSourceTypeRefObjMap, costSegstroeIdRefObjeMap, costItemCfg, "COST");
            GenerateCostSetUpHelper.packageEntityInfo(costSourceTypeRefObjMap, costSegstroeIdRefObjeMap, costItemCfg, "PRIORITY");
            costItemCfgInfoMap.put(salaryItemId, costSourceTypeRefObjMap);
        }
        return costItemCfgInfoMap;
    }

    public static Map<Long, List<DynamicObject>> queryCostCfgQualityMap(DynamicObject[] costItemCfgArr, Map<Long, String> costCfgQualityFieldMap) {
        HashMap<Long, List<DynamicObject>> costCfgQualityMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject costCfgQualityObj : costItemCfgArr) {
            String qualityNumber = costCfgQualityObj.getString("qualitynumber");
            if (SWCStringUtils.isEmpty((String)qualityNumber)) continue;
            Long salaryItemId = costCfgQualityObj.getLong("source.id");
            Long costCfgHisId = costCfgQualityObj.getLong("id");
            costCfgQualityFieldMap.put(salaryItemId, costCfgQualityObj.getString("qualitydim.salaryfilefield"));
            ArrayList<DynamicObject> costCfgQualityList = (ArrayList<DynamicObject>)costCfgQualityMap.get(costCfgHisId);
            if (costCfgQualityList == null) {
                costCfgQualityList = new ArrayList<DynamicObject>(10);
                costCfgQualityMap.put(costCfgHisId, costCfgQualityList);
            }
            costCfgQualityList.add(costCfgQualityObj);
        }
        return costCfgQualityMap;
    }

    public static String getSalaryfileField(Map<Long, List<DynamicObject>> costCfgQualityMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<DynamicObject> costCfgQualityList : costCfgQualityMap.values()) {
            costCfgQualityList.forEach(costCfgQualityObj -> {
                String qualityDim = costCfgQualityObj.getString("qualitydim.salaryfilefield");
                stringBuilder.append(qualityDim).append(',');
            });
        }
        return stringBuilder.toString();
    }

    private static Map<String, List<Map<String, Object>>> packageEntityInfo(Map<String, List<Map<String, Object>>> costSourceTypeRefObjMap, Map<Long, DynamicObject> costSegstroeIdRefObjeMap, DynamicObject costItemCfg, String costType) {
        String entityName = "COST".equals(costType) ? "costcfgentryentity" : "costcfgtypeentryentity";
        DynamicObjectCollection costCfgEntryColl = costItemCfg.getDynamicObjectCollection(entityName);
        BigDecimal totalCostPercent = BigDecimal.ZERO;
        List<Map<String, Object>> costSegstoreList = costSourceTypeRefObjMap.get(costType);
        if (costSegstoreList == null) {
            costSegstoreList = new ArrayList<Map<String, Object>>(10);
            costSourceTypeRefObjMap.put(costType, costSegstoreList);
        }
        for (DynamicObject costCfgEntry : costCfgEntryColl) {
            String costSegstoreKey = "COST".equals(costType) ? "costsegstore.id" : "costtypesegstore.id";
            String calCostProportionKey = "COST".equals(costType) ? "calcostproportion" : "costcfgtypeproportion";
            String costStrucfgValueKey = "COST".equals(costType) ? "coststrucfgvalue" : "coststrutypecfgvalue";
            Long costSegstoreId = costCfgEntry.getLong(costSegstoreKey);
            BigDecimal costProportion = costCfgEntry.getBigDecimal(calCostProportionKey);
            totalCostPercent = totalCostPercent.add(costProportion);
            DynamicObject costSegstoreObj = costSegstroeIdRefObjeMap.get(costSegstoreId);
            HashMap<String, Object> salaryItemcfgMap = new HashMap<String, Object>(16);
            salaryItemcfgMap.put("costProportion", costProportion);
            salaryItemcfgMap.put("costStruCfgValue", costCfgEntry.getString(costStrucfgValueKey));
            CostUtils.setSegmentVal(costSegstoreObj, salaryItemcfgMap);
            costSegstoreList.add(salaryItemcfgMap);
        }
        if (!costSegstoreList.isEmpty() && totalCostPercent.compareTo(CostCfgConstants.HUNDRED) < 0) {
            HashMap<String, Object> costCfgValMap = new HashMap<String, Object>(2);
            costCfgValMap.put("costProportion", CostCfgConstants.HUNDRED.subtract(totalCostPercent));
            costCfgValMap.put("costStruCfgValue", "");
            costSegstoreList.add(costCfgValMap);
        }
        return costSourceTypeRefObjMap;
    }

    public static List<Long> getCostSegstoreIds(DynamicObject[] costCfgArr) {
        ArrayList<Long> costSegstoreIdList = new ArrayList<Long>(10);
        for (DynamicObject costCfg : costCfgArr) {
            Long costSegstoreId;
            if (costCfg.getDataEntityType().getProperties().containsKey((Object)"costcfgentryentity")) {
                DynamicObjectCollection costCfgEntryColl = costCfg.getDynamicObjectCollection("costcfgentryentity");
                for (DynamicObject costCfgEntry : costCfgEntryColl) {
                    costSegstoreId = costCfgEntry.getLong("costsegstore.id");
                    costSegstoreIdList.add(costSegstoreId);
                }
            }
            if (!costCfg.getDataEntityType().getProperties().containsKey((Object)"costcfgtypeentryentity")) continue;
            DynamicObjectCollection costCfgProrityEntryColl = costCfg.getDynamicObjectCollection("costcfgtypeentryentity");
            for (DynamicObject costCfgEntry : costCfgProrityEntryColl) {
                costSegstoreId = costCfgEntry.getLong("costtypesegstore.id");
                costSegstoreIdList.add(costSegstoreId);
            }
        }
        return costSegstoreIdList;
    }

    public static Map<Long, DynamicObject> queryCostSegstoreIdRefObjeMap(Object costSegStoreIds) {
        DynamicObject[] costSegstoreArr = GenerateCostSetUpHelper.queryCostSegstoreArrByIds(costSegStoreIds);
        HashMap<Long, DynamicObject> costSegstoreIdRefObjeMap = new HashMap<Long, DynamicObject>(costSegstoreArr.length);
        for (DynamicObject costSegstore : costSegstoreArr) {
            Long costSetstoreId = costSegstore.getLong("id");
            costSegstoreIdRefObjeMap.put(costSetstoreId, costSegstore);
        }
        return costSegstoreIdRefObjeMap;
    }

    public static void dealTermination(Long calTaskId) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_costallocation");
        costAllocationHelper.deleteByFilter(new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
    }

    public static Map<String, List<Map<String, Object>>> getCostSalaryItemAndQualityCfgMap(Map<String, Map<String, List<Map<String, Object>>>> costSalaryItemAndQualityCfgMap, Map<Long, String> costCfgQualityFieldMap, DynamicObject salaryFile, Long salaryItemId) {
        String costCfgQualityField = costCfgQualityFieldMap.get(salaryItemId);
        if (SWCStringUtils.isEmpty((String)costCfgQualityField)) {
            return costSalaryItemAndQualityCfgMap.get(salaryItemId.toString());
        }
        Object costCfgQualityValue = salaryFile.get(costCfgQualityField);
        if (SWCObjectUtils.isEmpty((Object)costCfgQualityValue)) {
            return costSalaryItemAndQualityCfgMap.get(salaryItemId.toString());
        }
        String qualityKey = String.join((CharSequence)"||", salaryItemId.toString(), costCfgQualityField);
        Set<String> costSalaryItemAndQualityCfgKeySet = costSalaryItemAndQualityCfgMap.keySet();
        String costQualityKey = null;
        for (String costSalaryItemAndQualityCfgKey : costSalaryItemAndQualityCfgKeySet) {
            if (costCfgQualityValue instanceof Boolean) {
                Boolean booleanVal = (Boolean)costCfgQualityValue;
                String result = booleanVal != false ? "1" : "0";
                result = qualityKey + "||" + result;
                if (!costSalaryItemAndQualityCfgKey.startsWith(qualityKey) || !costSalaryItemAndQualityCfgKey.equals(result)) continue;
                costQualityKey = costSalaryItemAndQualityCfgKey;
                break;
            }
            if (!(costCfgQualityValue instanceof Long)) continue;
            Long longVal = (Long)costCfgQualityValue;
            if (!costSalaryItemAndQualityCfgKey.startsWith(qualityKey) || !costSalaryItemAndQualityCfgKey.contains(longVal.toString())) continue;
            costQualityKey = costSalaryItemAndQualityCfgKey;
            break;
        }
        Map<String, List<Map<String, Object>>> costSalaryItemAndQualityMap = SWCStringUtils.isNotEmpty(costQualityKey) ? costSalaryItemAndQualityCfgMap.get(costQualityKey) : costSalaryItemAndQualityCfgMap.get(salaryItemId.toString());
        return costSalaryItemAndQualityMap;
    }

    public static SetUpCommonInfo getSetUpCommonInfo(Long costAllocationId, Long costAllocationRecordId, Long costAdapterId, Long calTaskId, String generateStrategy) {
        LOGGER.info("GenerateCostSetUpHelper getSetUpCommonInfo begin");
        DynamicObject calPalRollTask = GenerateCostSetUpHelper.queryCalPalRollTask(calTaskId);
        Date calTaskEndDate = calPalRollTask.getDate("ENDDATE");
        calTaskEndDate = GenerateCostSetUpHelper.convertDate(calTaskEndDate);
        Date payRollDate = calPalRollTask.getDate("payrolldate");
        DynamicObject costAdaptDy = GenerateCostSetUpHelper.queryCostStruIdByCostAdapterDy(costAdapterId);
        Long costStruId = costAdaptDy.getLong("coststru.id");
        LOGGER.info("GenerateCostSetUpHelper getSetUpCommonInfo createOrgId:{}", (Object)costStruId);
        Long createOrgId = costAdaptDy.getLong("createorg.id");
        LOGGER.info("GenerateCostSetUpHelper getSetUpCommonInfo createOrgId:{}", (Object)createOrgId);
        Map<String, Long> existedCostSetupConstInfoMap = GenerateCostSetUpHelper.queryCostSetupConstMap(costStruId);
        int[] storageArr = GenerateCostSetUpHelper.queryDimensionStoragesetArr(costStruId);
        Map<Long, DynamicObject> salaryItemInfoMap = GenerateCostSetUpHelper.getSalaryItemIdListByCalTaskId(calTaskId);
        ArrayList<Long> salaryItemList = new ArrayList<Long>(salaryItemInfoMap.keySet());
        DynamicObject[] costSalaryItemEnableArray = GenerateCostSetUpHelper.getEnableCostItemCfgByAdapterId(costAdapterId, salaryItemList);
        List<Long> costSalaryItemEnableIdList = GenerateCostSetUpHelper.getCostSalaryItemEnableIdList(costSalaryItemEnableArray);
        Map<Long, Long> salaryItemRefCostItemMap = GenerateCostSetUpHelper.getSalaryItemRefCostItemMap(salaryItemInfoMap.values(), calPalRollTask, createOrgId);
        DynamicObject[] costItemCfgArr = GenerateCostSetUpHelper.queryCostItemCfg(salaryItemInfoMap.keySet(), costAdapterId, calTaskEndDate, costSalaryItemEnableIdList);
        HashMap<Long, String> costCfgQualityFieldMap = new HashMap<Long, String>(16);
        Map<Long, List<DynamicObject>> costCfgQualityMap = GenerateCostSetUpHelper.queryCostCfgQualityMap(costItemCfgArr, costCfgQualityFieldMap);
        Map<String, Map<String, List<Map<String, Object>>>> costSalaryItemAndQualityCfgMap = GenerateCostSetUpHelper.getCostSalaryItemAndQualityCfgMap(costItemCfgArr, costCfgQualityMap);
        String salaryFileField = GenerateCostSetUpHelper.getSalaryfileField(costCfgQualityMap);
        List<String> isRequiredFieldList = GenerateCostSetUpHelper.queryisRequiredFieldList(costStruId);
        Map<Long, Map<String, CostCfg>> costBasicCfgInfoMap = GenerateCostSetUpHelper.queryBasicCostCfgMap(costAdapterId, calTaskEndDate);
        Map<String, CostCfg> adminOrgStructNumberMap = GenerateCostSetUpHelper.getAdminOrgStructNumberMap(costBasicCfgInfoMap);
        SetUpCommonInfo setUpCommonInfo = new SetUpCommonInfo.Builder(costAllocationId, costAllocationRecordId).costAdaterId(costAdapterId).calTaskId(calTaskId).createOrgId(createOrgId).generateStrategy(generateStrategy).calTaskEndDate(calTaskEndDate).payRollDate(payRollDate).costStruId(costStruId).costCfgQualityFieldMap(costCfgQualityFieldMap).salaryFileField(salaryFileField).salaryItemInfoMap(salaryItemInfoMap).costSalaryItemAndQualityCfgMap(costSalaryItemAndQualityCfgMap).storageArr(storageArr).isRequiredFieldList(isRequiredFieldList).costBasicCfgInfoMap(costBasicCfgInfoMap).salaryItemRefCostItemMap(salaryItemRefCostItemMap).existedCostSetupConstInfoMap(existedCostSetupConstInfoMap).adminOrgStructNumberMap(adminOrgStructNumberMap).builder();
        LOGGER.info("GenerateCostSetUpHelper getSetUpCommonInfo end");
        return setUpCommonInfo;
    }

    private static List<Long> getCostSalaryItemEnableIdList(DynamicObject[] costSalaryItemEnableArray) {
        ArrayList<Long> costSalaryItemEnableIdList = new ArrayList<Long>(10);
        for (DynamicObject costSalaryItemEnableDy : costSalaryItemEnableArray) {
            long costCfgId = costSalaryItemEnableDy.getLong("id");
            costSalaryItemEnableIdList.add(costCfgId);
        }
        return costSalaryItemEnableIdList;
    }

    public static DynamicObject[] getEnableCostItemCfgByAdapterId(Long costAdapterId, List<Long> salaryItemList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costitemcfg");
        QFilter filter = new QFilter("costadapter", "=", (Object)costAdapterId);
        filter.and(new QFilter("sourcetype", "=", (Object)SWCCostConstants.COST_TYPE_ITEM));
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("source", "in", salaryItemList));
        return serviceHelper.query("id,source.id", new QFilter[]{filter});
    }

    public static Map<String, CostCfg> getAdminOrgStructNumberMap(Map<Long, Map<String, CostCfg>> costBasicCfgInfoMap) {
        HashMap<String, CostCfg> adminOrgStructNumberMap = new HashMap<String, CostCfg>(16);
        Map<String, CostCfg> deptCostCfgMap = costBasicCfgInfoMap.get(SWCCostConstants.COST_TYPE_DEPT);
        if (deptCostCfgMap == null || deptCostCfgMap.isEmpty()) {
            return adminOrgStructNumberMap;
        }
        Set<String> adminOrgSet = deptCostCfgMap.keySet();
        ArrayList<Long> adminOrgIdList = new ArrayList<Long>(adminOrgSet.size());
        for (String adminOrgStr : adminOrgSet) {
            adminOrgIdList.add(Long.valueOf(adminOrgStr));
        }
        Map<String, Map<String, Object>> costCfgAdminOrgMap = GenerateCostSetUpHelper.getAdminOrgInfo(adminOrgIdList);
        for (Map.Entry<String, Map<String, Object>> next : costCfgAdminOrgMap.entrySet()) {
            String key = next.getKey();
            Map<String, Object> value = next.getValue();
            Object structNumber = value.get("structnumber");
            CostCfg costCfg = deptCostCfgMap.get(key);
            if (costCfg == null) continue;
            adminOrgStructNumberMap.put(String.valueOf(structNumber), costCfg);
        }
        return adminOrgStructNumberMap;
    }

    public static Map<String, Map<String, Object>> getAdminOrgInfo(List<Long> orgIdList) {
        return (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{orgIdList, new Date(), Boolean.TRUE});
    }
}

