/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cost.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.log.HRLog;
import kd.hr.hbp.common.log.HRLogFactory;
import kd.sdk.swc.hscs.common.events.CostCfgTypeDeptArgs;
import kd.sdk.swc.hscs.service.api.ICostSetUpService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cost.calcostsetupchain.DepartmentCostCfgNode;
import kd.swc.hscs.business.cost.calcostsetupchain.EmpCostCfgNode;
import kd.swc.hscs.business.cost.calcostsetupchain.PostCostCfgNode;
import kd.swc.hscs.business.cost.calcostsetupchain.SalaryItemCostCfgNode;
import kd.swc.hscs.business.cost.calcostsetupchain.SalaryfileCostCfgNode;
import kd.swc.hscs.business.cost.calcostsetupchain.SalaryfileItemCostCfgNode;
import kd.swc.hscs.business.cost.calcostsetupchain.SuperpositionChain;
import kd.swc.hscs.business.cost.helper.CostSetUpExtService;
import kd.swc.hscs.business.cost.helper.GenerateCostSetUpHelper;
import kd.swc.hscs.business.cost.runnable.CostSetUpSaveRunnable;
import kd.swc.hscs.business.cost.runnable.GenerateCostSetUpRunnable;
import kd.swc.hscs.business.cost.util.CostLogUtils;
import kd.swc.hscs.business.cost.util.CostUtils;
import kd.swc.hscs.business.cost.vo.CostCfg;
import kd.swc.hscs.business.cost.vo.CostCfgEntry;
import kd.swc.hscs.business.cost.vo.SalaryfileInfo;
import kd.swc.hscs.business.cost.vo.SetUpCommonInfo;
import kd.swc.hscs.common.constants.CostCfgConstants;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GenerateCostSetUpService {
    private static final HRLog HR_LOG = HRLogFactory.getLog((String)"pcs_costlog", GenerateCostSetUpService.class);
    private static final Log LOGGER = LogFactory.getLog(GenerateCostSetUpService.class);
    private static final int BATCH_SIZE = 500;
    private static final int SAVE_BATCH_SIZE = 1000;
    private SetUpCommonInfo setUpCommonInfo;
    private List<Long> salaryFileIdList;
    private Map<String, Long> salaryFileDeptMap;
    private Map<String, Long> salaryFilePosMap;
    private Map<String, Long> salaryFileEmpMap;
    private Map<String, String> adminOrgLongNumberMap;
    private Map<String, String> adminOrgStructNumberMap;
    private Map<Long, Long> costCfgEntryIdRefCostSegStoreIdMap;
    private Map<Long, Map<String, CostCfg>> costSalaryFileCfgInfoMap;
    private Map<Long, DynamicObject> costSegStoreIdRefObjMap;
    private Map<String, Long> costSetupConstMap;
    private Map<String, Map<String, Object>> deptDefaultCostCfgMap;
    private DynamicObjectCollection costSetupRstColl;
    private List<String> newCostSetupKeyList;
    private List<String> messageList;
    private HRPluginProxy<ICostSetUpService> hrPluginProxy;
    private CostCfgTypeDeptArgs costCfgTypeDeptArgs;

    public GenerateCostSetUpService() {
    }

    public GenerateCostSetUpService(SetUpCommonInfo setUpCommonInfo, Map<Long, DynamicObject> costSegstoreIdRefObjeMap, Map<String, Long> costSetupConstMap, List<String> newCostSetupKeyList) {
        this.setUpCommonInfo = setUpCommonInfo;
        this.costSegStoreIdRefObjMap = costSegstoreIdRefObjeMap;
        this.costSetupConstMap = costSetupConstMap;
        this.newCostSetupKeyList = newCostSetupKeyList;
    }

    public GenerateCostSetUpService(SetUpCommonInfo setUpCommonInfo, List<Long> salaryFileIdList) {
        this.setUpCommonInfo = setUpCommonInfo;
        this.salaryFileIdList = salaryFileIdList;
        this.costSetupRstColl = new DynamicObjectCollection();
        this.costCfgEntryIdRefCostSegStoreIdMap = new HashMap<Long, Long>(16);
        this.newCostSetupKeyList = Lists.newArrayListWithCapacity((int)10);
    }

    public void calCostSetup() {
        RequestContext requestContext = RequestContext.get();
        int batchSize = 500;
        List batchSubLists = Lists.partition(this.salaryFileIdList, (int)batchSize);
        for (List subList : batchSubLists) {
            GenerateCostSetUpRunnable runnable = new GenerateCostSetUpRunnable(this.setUpCommonInfo, subList, requestContext);
            SWCThreadPoolFactory.getCostsetupCalThreadpool().execute((Runnable)runnable);
        }
    }

    private void initData(DynamicObject[] salaryFileArr) {
        LOGGER.info("initialize data start...");
        long startTime = System.currentTimeMillis();
        this.setCostSetupConstMap();
        this.setSalaryFileRelatedInfo(salaryFileArr);
        this.setCostCfgInfoMap();
        this.initAdminOrgNumberMap();
        this.setDefaultCostCfgMap();
        this.setCostCfgEntryIdRefCostSegStoreIdMap();
        this.setCostSegStoreIdRefObjMap();
        this.setCostTypeDeptInfo();
        this.messageList = Lists.newArrayListWithCapacity((int)10);
        long endTime = System.currentTimeMillis();
        LOGGER.info("initialize data end,total time : {} ms", (Object)(endTime - startTime));
    }

    public int generateCostSetUp(String generateStrategy) {
        try {
            long startTime = System.currentTimeMillis();
            LOGGER.info("generateCostSetUp start ....");
            this.doGenerateCostSetUp(generateStrategy);
            long endTime = System.currentTimeMillis();
            LOGGER.info("generateCostSetUp end ....total time : {} ms", (Object)(endTime - startTime));
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("GenerateCostSetUpRunnable generateCostSetUp error,errorMsg: ", (Object)e.getMessage());
            return -1;
        }
    }

    private void doGenerateCostSetUp(String generateStrategy) {
        Long costAllocationRecordId = this.setUpCommonInfo.getCostAllocationRecordId();
        long startTime = System.currentTimeMillis();
        String salaryFileFiled = this.setUpCommonInfo.getSalaryFileField();
        DynamicObject[] salaryFileArr = GenerateCostSetUpHelper.querySalaryfileArr(this.salaryFileIdList, salaryFileFiled);
        LOGGER.info("this batch total salaryFile size is : {}", (Object)salaryFileArr.length);
        this.initData(salaryFileArr);
        HashMap<String, Long> definedCostSetUpMap = new HashMap(16);
        Long calTaskId = this.setUpCommonInfo.getCalTaskId();
        if ("2".equals(generateStrategy)) {
            definedCostSetUpMap = GenerateCostSetUpHelper.queryDefinedCostSetUp(calTaskId, this.salaryFileIdList);
        }
        Map<String, Map<String, List<Map<String, Object>>>> costSalaryItemAndQualityCfgMap = this.setUpCommonInfo.getCostSalaryItemAndQualityCfgMap();
        Map<Long, String> costCfgQualityFieldMap = this.setUpCommonInfo.getCostCfgQualityFieldMap();
        Map<Long, Map<String, CostCfg>> costBasicCfgInfoMap = this.setUpCommonInfo.getCostBasicCfgInfoMap();
        Map<Long, DynamicObject> salaryItemInfoMap = this.setUpCommonInfo.getSalaryItemInfoMap();
        ORM orm = ORM.create();
        for (DynamicObject salaryFile : salaryFileArr) {
            String salaryFileId = salaryFile.getString("id");
            this.messageList.add(String.format(Locale.ROOT, "########salaryfile id is : %s#############", salaryFileId));
            Long empId = this.salaryFileEmpMap.get(salaryFileId);
            CostCfg empCostCfg = empId == null ? null : costBasicCfgInfoMap.get(SWCCostConstants.COST_TYPE_EMP).get(String.valueOf(empId));
            this.messageList.add(String.format(Locale.ROOT, "empCostCfg value is: %s", JSON.toJSONString((Object)empCostCfg)));
            Long posId = this.salaryFilePosMap.get(salaryFileId);
            CostCfg posCostCfg = posId == null ? null : costBasicCfgInfoMap.get(SWCCostConstants.COST_TYPE_POST).get(String.valueOf(posId));
            this.messageList.add(String.format(Locale.ROOT, "posCostCfg value is: %s", JSON.toJSONString((Object)posCostCfg)));
            Long deptId = this.salaryFileDeptMap.get(salaryFileId);
            this.messageList.add(String.format(Locale.ROOT, "########deptId id is : %s#############", deptId));
            CostCfg deptCostCfg = this.getDeptCostCfg(deptId);
            Map<String, Object> currentDefaultCostCfgMap = this.getDefaultCostCfgMapByDeptId(String.valueOf(deptId));
            if (deptCostCfg != null) {
                deptId = deptCostCfg.getSourceId();
                currentDefaultCostCfgMap = deptId == null ? null : this.getDefaultCostCfgMapByDeptId(String.valueOf(deptId));
            }
            this.messageList.add(String.format(Locale.ROOT, "deptCostCfg value is : %s", JSON.toJSONString((Object)deptCostCfg)));
            SalaryfileInfo salaryfileInfo = new SalaryfileInfo(salaryFileId, empCostCfg, posCostCfg, deptCostCfg, currentDefaultCostCfgMap);
            for (Map.Entry<Long, DynamicObject> entry : salaryItemInfoMap.entrySet()) {
                Long salaryItemId = entry.getKey();
                if (salaryItemId == null) continue;
                String key = String.join((CharSequence)"_", salaryFileId, salaryItemId.toString());
                if ("2".equals(generateStrategy) && definedCostSetUpMap.containsKey(key)) continue;
                String salaryItemName = entry.getValue().getString("name");
                this.messageList.add(String.format(Locale.ROOT, "#####salaryItem is : %s#####", salaryItemName));
                Map<String, List<Map<String, Object>>> salaryItemCostCfgInfo = GenerateCostSetUpHelper.getCostSalaryItemAndQualityCfgMap(costSalaryItemAndQualityCfgMap, costCfgQualityFieldMap, salaryFile, salaryItemId);
                if (salaryItemCostCfgInfo == null) {
                    this.messageList.add("salaryItemCostCfgInfo is null");
                    this.calCostSetUp(null, salaryfileInfo, salaryItemId, CostCfgConstants.HUNDRED, orm, null);
                    continue;
                }
                List<Map<String, Object>> priorityCostSets = salaryItemCostCfgInfo.get("PRIORITY");
                if (priorityCostSets != null && !priorityCostSets.isEmpty()) {
                    this.messageList.add(String.format(Locale.ROOT, "priorityCostSets is not empty,is : %s", JSON.toJSONString(priorityCostSets)));
                    Map<String, Object> priorityCostSet = priorityCostSets.get(0);
                    BigDecimal costProportion = (BigDecimal)priorityCostSet.get("costProportion");
                    DynamicObject costSetupRstObj = this.createCostSetUpDynamicObj(salaryItemId, salaryfileInfo, priorityCostSets, CostCfgConstants.HUNDRED, orm, null);
                    if (costProportion.compareTo(CostCfgConstants.HUNDRED) < 0) {
                        this.messageList.add(String.format(Locale.ROOT, "priorityCostSet is %s, Less than 100 ...", costProportion.toPlainString()));
                        this.calCostSetUp(salaryItemCostCfgInfo, salaryfileInfo, salaryItemId, CostCfgConstants.HUNDRED.subtract(costProportion), orm, costSetupRstObj);
                        continue;
                    }
                    this.messageList.add("priorityCostSet is 100% ...");
                    this.costSetupRstColl.add((Object)costSetupRstObj);
                    continue;
                }
                this.messageList.add("no priorityCostSets ...");
                this.calCostSetUp(salaryItemCostCfgInfo, salaryfileInfo, salaryItemId, CostCfgConstants.HUNDRED, orm, null);
            }
            String messageStr = StringUtils.join((Object[])this.messageList.toArray(), (String)"\n");
            CostLogUtils.info(HR_LOG, costAllocationRecordId, messageStr);
            this.messageList.clear();
        }
        Map<Long, Set<Long>> createdSalaryItemMap = this.supplementDefaultCostCfInfo();
        this.supplementSalaryItemInfo(orm, createdSalaryItemMap, definedCostSetUpMap);
        this.doSaveSetUpInfo(generateStrategy, definedCostSetUpMap);
        long endTime = System.currentTimeMillis();
        LOGGER.info("save success,total time: {} ms", (Object)(endTime - startTime));
    }

    private Map<String, Object> getDefaultCostCfgMapByDeptId(String deptId) {
        if (this.adminOrgLongNumberMap == null) {
            return null;
        }
        String longNumber = this.adminOrgLongNumberMap.get(deptId);
        if (SWCStringUtils.isEmpty((String)longNumber)) {
            return this.deptDefaultCostCfgMap.get(deptId);
        }
        Map<String, Object> currentDefaultCostCfgMap = null;
        String[] split = longNumber.split("!");
        List<String> splitList = Arrays.asList(split);
        for (int i = splitList.size() - 1; i >= 0; --i) {
            Map<String, Object> defaultCostCfgMap = this.deptDefaultCostCfgMap.get(splitList.get(i));
            if (defaultCostCfgMap == null || defaultCostCfgMap.isEmpty()) continue;
            currentDefaultCostCfgMap = defaultCostCfgMap;
            break;
        }
        return currentDefaultCostCfgMap;
    }

    private CostCfg getDeptCostCfg(Long deptId) {
        Map<String, CostCfg> adminOrgStructNumberMap = this.setUpCommonInfo.getAdminOrgStructNumberMap();
        if (CollectionUtils.isEmpty(adminOrgStructNumberMap) || CollectionUtils.isEmpty(this.adminOrgLongNumberMap)) {
            return null;
        }
        String longNumber = this.adminOrgLongNumberMap.get(String.valueOf(deptId));
        this.messageList.add(String.format(Locale.ROOT, "########longNumber id is : %s#############", longNumber));
        if (SWCStringUtils.isEmpty((String)longNumber)) {
            return null;
        }
        String[] split = longNumber.split("!");
        List<String> splitList = Arrays.asList(split);
        CostCfg deptCostCfg = null;
        for (int i = splitList.size() - 1; i >= 0; --i) {
            CostCfg costCfg = adminOrgStructNumberMap.get(splitList.get(i));
            if (null == costCfg) continue;
            if (i == splitList.size() - 1) {
                deptCostCfg = costCfg;
                break;
            }
            this.costCfgTypeDeptArgs.setSelectedId(costCfg.getId());
            this.costCfgTypeDeptArgs.setCheckPass(Boolean.TRUE);
            this.hrPluginProxy.callReplaceIfPresent(proxy -> {
                proxy.checkCostTypeDept(this.costCfgTypeDeptArgs);
                return null;
            });
            if (!this.costCfgTypeDeptArgs.getCheckPass().booleanValue()) continue;
            deptCostCfg = costCfg;
            break;
        }
        return deptCostCfg;
    }

    private void initAdminOrgNumberMap() {
        this.adminOrgLongNumberMap = new HashMap<String, String>(16);
        this.adminOrgStructNumberMap = new HashMap<String, String>(16);
        Collection<Long> orgIdList = this.salaryFileDeptMap.values();
        if (CollectionUtils.isEmpty(orgIdList)) {
            return;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(orgIdList);
        LOGGER.info("GenerateCostSetUpService initAdminOrgNumberMap getAdminOrgInfo begin");
        Map<String, Map<String, Object>> adminOrgMap = GenerateCostSetUpHelper.getAdminOrgInfo(new ArrayList<Long>(orgIdSet));
        LOGGER.info("GenerateCostSetUpService initAdminOrgNumberMap getAdminOrgInfo end");
        for (Map.Entry<String, Map<String, Object>> next : adminOrgMap.entrySet()) {
            String orgId = next.getKey();
            Map<String, Object> value = next.getValue();
            Object longNumber = value.get("longnumber");
            Object structNumber = value.get("structnumber");
            this.adminOrgLongNumberMap.put(orgId, String.valueOf(longNumber));
            this.adminOrgStructNumberMap.put(orgId, String.valueOf(structNumber));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveSetUpInfo(String generateStrategy, Map<String, Long> queryDefinedCostSetUpMap) {
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetuprst");
            this.deleteSetUpByGenerateStrategy(generateStrategy, queryDefinedCostSetUpMap, serviceHelper);
            Map<String, Map<String, Object>> costSetupConstMapFromCache = this.getCostSetupConstMapFromCache();
            DynamicObjectCollection costSetupConstColl = this.addCostSetupConstId(costSetupConstMapFromCache);
            this.setCostSetupConstId(costSetupConstMapFromCache);
            if (!SWCListUtils.isEmpty((List)this.costSetupRstColl)) {
                LOGGER.info("CostSetUpSaveRunnable begin");
                List batchSubLists = Lists.partition((List)this.costSetupRstColl, (int)1000);
                for (List subList : batchSubLists) {
                    CostSetUpSaveRunnable costSetUpSaveRunnable = new CostSetUpSaveRunnable(subList);
                    SWCThreadPoolFactory.getCostsetupSaveThreadpool().execute((Runnable)costSetUpSaveRunnable);
                }
            }
            LOGGER.info("save costSetupRstColl success! costSetupRstColl size:{}", (Object)this.costSetupRstColl.size());
            serviceHelper.setEntityName("pcs_costsetupconst");
            if (!costSetupConstColl.isEmpty()) {
                serviceHelper.save(costSetupConstColl);
                LOGGER.info("save costSetupConstColl success! costSetupConstColl size:{}", (Object)costSetupConstColl.size());
            }
        }
    }

    private DynamicObjectCollection addCostSetupConstId(Map<String, Map<String, Object>> costSetupConstMapFromCache) {
        Collection<Map<String, Object>> costSetupConstCollCache = costSetupConstMapFromCache.values();
        DynamicObjectCollection costSetupConstColl = new DynamicObjectCollection();
        if (costSetupConstCollCache.isEmpty()) {
            return costSetupConstColl;
        }
        ORM orm = ORM.create();
        DynamicObject costSetupConstObj = BusinessDataServiceHelper.newDynamicObject((String)"pcs_costsetupconst");
        long[] costSetupConstObjIds = orm.genLongIds(costSetupConstObj.getDataEntityType(), this.getCostSetupConstMapFromCacheIdIsNullSize(costSetupConstCollCache));
        int index = 0;
        for (Map<String, Object> costSetupConsInfoMap : costSetupConstCollCache) {
            DynamicObject costSetupConst = this.createObjAndSetDefaultVal("pcs_costsetupconst");
            Long constId = (Long)costSetupConsInfoMap.get("id");
            if (constId != null) continue;
            long costSetupConstId = costSetupConstObjIds[index++];
            costSetupConstObj.set("id", (Object)costSetupConstId);
            costSetupConsInfoMap.put("id", costSetupConstId);
            for (Map.Entry<String, Object> entry : costSetupConsInfoMap.entrySet()) {
                costSetupConst.set(entry.getKey(), entry.getValue());
            }
            costSetupConstColl.add((Object)costSetupConst);
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"generateCostSetUp_newConst_appCache");
        appCache.put(this.setUpCommonInfo.getCostStruId().toString(), costSetupConstMapFromCache);
        return costSetupConstColl;
    }

    private void setCostSetupConstId(Map<String, Map<String, Object>> costSetupConstMapFromCache) {
        this.costSetupRstColl.forEach(costSetupRst -> {
            DynamicObjectCollection costSetupRstEnt = costSetupRst.getDynamicObjectCollection("entryentity");
            if (costSetupRstEnt != null && !costSetupRstEnt.isEmpty()) {
                costSetupRstEnt.forEach(costSetupEntryObj -> {
                    long autoCostSetupConstId = costSetupEntryObj.getLong("aotucostsetupconst");
                    if (autoCostSetupConstId == 0L) {
                        String costSetupConstVal = costSetupEntryObj.getString("aotucostsetupconstval");
                        Map costSetupConsInfoMap = (Map)costSetupConstMapFromCache.get(costSetupConstVal);
                        costSetupEntryObj.set("aotucostsetupconst", costSetupConsInfoMap.get("id"));
                        costSetupEntryObj.set("defcostsetupconst", costSetupConsInfoMap.get("id"));
                    }
                });
            }
        });
    }

    private int getCostSetupConstMapFromCacheIdIsNullSize(Collection<Map<String, Object>> costSetupConstCollCache) {
        int index = 0;
        for (Map<String, Object> costSetupConsInfoMap : costSetupConstCollCache) {
            Long constId = (Long)costSetupConsInfoMap.get("id");
            if (constId != null) continue;
            ++index;
        }
        return index;
    }

    private void supplementSalaryItemInfo(ORM orm, Map<Long, Set<Long>> createdSalaryItemMap, Map<String, Long> queryDefinedCostSetUpMap) {
        Map<Long, DynamicObject> salaryItemInfoMap = this.setUpCommonInfo.getSalaryItemInfoMap();
        List<String> isRequiredFieldList = this.setUpCommonInfo.getIsRequiredFieldList();
        Set<Long> totalSalaryItemSet = salaryItemInfoMap.keySet();
        for (Map.Entry<Long, Set<Long>> entry : createdSalaryItemMap.entrySet()) {
            Long salaryFileId = entry.getKey();
            if (salaryFileId == null) continue;
            Set<Long> createdSalaryItemIdSet = entry.getValue();
            for (Long salaryItemId : totalSalaryItemSet) {
                String dataStatus;
                SalaryfileInfo salaryfileInfo;
                DynamicObject costSetupRstObj;
                String key = String.join((CharSequence)"_", salaryFileId.toString(), salaryItemId.toString());
                if (createdSalaryItemIdSet.contains(salaryItemId) || queryDefinedCostSetUpMap.containsKey(key) || (costSetupRstObj = this.createCostSetUpDynamicObj(salaryItemId, salaryfileInfo = this.getSalaryFileInfo(salaryFileId.toString()), new ArrayList<Map<String, Object>>(), BigDecimal.ZERO, orm, null)) == null) continue;
                String string = dataStatus = SWCStringUtils.equals((String)costSetupRstObj.getString("enable"), (String)"0") ? "0" : "2";
                if (isRequiredFieldList != null && !isRequiredFieldList.isEmpty()) {
                    dataStatus = "0";
                }
                costSetupRstObj.set("enable", (Object)dataStatus);
                this.costSetupRstColl.add((Object)costSetupRstObj);
            }
        }
    }

    private SalaryfileInfo getSalaryFileInfo(String salaryFileId) {
        Map<Long, Map<String, CostCfg>> costBasicCfgInfoMap = this.setUpCommonInfo.getCostBasicCfgInfoMap();
        Long empId = this.salaryFileEmpMap.get(salaryFileId);
        CostCfg empCostCfg = empId == null ? null : costBasicCfgInfoMap.get(SWCCostConstants.COST_TYPE_EMP).get(empId.toString());
        Long posId = this.salaryFilePosMap.get(salaryFileId);
        CostCfg posCostCfg = posId == null ? null : costBasicCfgInfoMap.get(SWCCostConstants.COST_TYPE_POST).get(posId.toString());
        Long deptId = this.salaryFileDeptMap.get(salaryFileId);
        CostCfg deptCostCfg = this.getDeptCostCfg(deptId);
        Map<String, Object> currentDefaultCostCfgMap = this.getDefaultCostCfgMapByDeptId(String.valueOf(deptId));
        if (deptCostCfg != null) {
            deptId = deptCostCfg.getSourceId();
            currentDefaultCostCfgMap = deptId == null ? null : this.getDefaultCostCfgMapByDeptId(String.valueOf(deptId));
        }
        SalaryfileInfo salaryfileInfo = new SalaryfileInfo(salaryFileId, empCostCfg, posCostCfg, deptCostCfg, currentDefaultCostCfgMap);
        return salaryfileInfo;
    }

    private Map<Long, Set<Long>> supplementDefaultCostCfInfo() {
        ORM orm = ORM.create();
        HashMap createdSalaryItemMap = Maps.newHashMapWithExpectedSize((int)this.costSetupRstColl.size());
        for (DynamicObject costSetUpRst : this.costSetupRstColl) {
            boolean isHundred;
            long salaryFileId = costSetUpRst.getLong("salaryfile");
            Long salaryFileIdLong = salaryFileId;
            HashSet<Long> salaryItemIdSet = (HashSet<Long>)createdSalaryItemMap.get(salaryFileIdLong);
            if (salaryItemIdSet == null) {
                salaryItemIdSet = new HashSet<Long>(10);
                createdSalaryItemMap.put(salaryFileIdLong, salaryItemIdSet);
            }
            salaryItemIdSet.add(costSetUpRst.getLong("salaryitem"));
            Long deptId = this.salaryFileDeptMap.get(salaryFileIdLong.toString());
            Map<String, Object> costDefaultSegStoreMap = deptId == null ? null : this.getDefaultCostCfgMapByDeptId(String.valueOf(deptId));
            BigDecimal totalPercent = this.getTotalPercent(costSetUpRst);
            BigDecimal restPercent = CostCfgConstants.HUNDRED.subtract(totalPercent);
            boolean bl = isHundred = restPercent.compareTo(BigDecimal.ZERO) == 0;
            if (costDefaultSegStoreMap == null) {
                if (isHundred || SWCStringUtils.equals((String)"0", (String)costSetUpRst.getString("enable"))) continue;
                costSetUpRst.set("enable", (Object)"2");
                continue;
            }
            DynamicObjectCollection costSetUpRstEntColl = costSetUpRst.getDynamicObjectCollection("entryentity");
            int seq = costSetUpRstEntColl.size() + 1;
            if (isHundred) continue;
            costDefaultSegStoreMap.put("costProportion", restPercent);
            DynamicObject costSetupEntryObj = this.createSetUpEntryDynamicObj(costDefaultSegStoreMap, CostCfgConstants.HUNDRED, seq, true, orm);
            costSetUpRst.getDynamicObjectCollection("entryentity").add((Object)costSetupEntryObj);
        }
        return createdSalaryItemMap;
    }

    private BigDecimal getTotalPercent(DynamicObject costSetUpRst) {
        DynamicObjectCollection costSetUpRstEntColl = costSetUpRst.getDynamicObjectCollection("entryentity");
        BigDecimal bigDecimalHolder = BigDecimal.ZERO;
        for (DynamicObject costSetUpRstEnt : costSetUpRstEntColl) {
            bigDecimalHolder = bigDecimalHolder.add(costSetUpRstEnt.getBigDecimal("percentage"));
        }
        return bigDecimalHolder;
    }

    private Map<String, Map<String, Object>> getDefaultCostCfgMap() {
        Collection<Long> deptIdColl = this.salaryFileDeptMap.values();
        Long costAdapterId = this.setUpCommonInfo.getCostAdapterId();
        Date calTaskEndDate = this.setUpCommonInfo.getCalTaskEndDate();
        DynamicObject[] deptDefaultCostCfArr = GenerateCostSetUpHelper.queryDeptDefalutCostCfg(deptIdColl, costAdapterId, calTaskEndDate);
        List<Long> costSegStoreIds = GenerateCostSetUpHelper.getCostSegstoreIds(deptDefaultCostCfArr);
        Map<Long, DynamicObject> costSagStoreIdRefObjMap = GenerateCostSetUpHelper.queryCostSegstoreIdRefObjeMap(costSegStoreIds);
        ArrayList<Long> deptIdList = new ArrayList<Long>(10);
        for (DynamicObject deptCostCfg : deptDefaultCostCfArr) {
            DynamicObjectCollection costDefaultCfgEntryColl = deptCostCfg.getDynamicObjectCollection("costcfgtypeentryentity");
            if (costDefaultCfgEntryColl.isEmpty()) continue;
            Long deptId = deptCostCfg.getLong("source.id");
            deptIdList.add(deptId);
        }
        Map<String, Map<String, Object>> adminOrgInfo = GenerateCostSetUpHelper.getAdminOrgInfo(deptIdList);
        for (Map.Entry<String, Map<String, Object>> next : adminOrgInfo.entrySet()) {
            String key = next.getKey();
            Map<String, Object> value = next.getValue();
            Object structNumber = value.get("structnumber");
            if (this.adminOrgStructNumberMap.containsKey(key)) continue;
            this.adminOrgStructNumberMap.put(key, String.valueOf(structNumber));
        }
        HashMap<String, Map<String, Object>> defaultCostCfgMap = new HashMap<String, Map<String, Object>>(deptDefaultCostCfArr.length);
        for (DynamicObject deptCostCfg : deptDefaultCostCfArr) {
            DynamicObjectCollection costDefaultCfgEntryColl;
            String deptId = deptCostCfg.getString("source.id");
            String adminOrgStructNumber = this.adminOrgStructNumberMap.get(String.valueOf(deptId));
            if (adminOrgStructNumber == null || adminOrgStructNumber.isEmpty()) {
                adminOrgStructNumber = deptId;
            }
            if ((costDefaultCfgEntryColl = deptCostCfg.getDynamicObjectCollection("costcfgtypeentryentity")).isEmpty()) continue;
            HashMap<String, Object> costDefaultSegstoreMap = (HashMap<String, Object>)defaultCostCfgMap.get(adminOrgStructNumber);
            if (costDefaultSegstoreMap == null) {
                costDefaultSegstoreMap = new HashMap<String, Object>(16);
                defaultCostCfgMap.put(adminOrgStructNumber, costDefaultSegstoreMap);
            }
            DynamicObject costPriorityCfgEntry = (DynamicObject)costDefaultCfgEntryColl.get(0);
            Long costSegStoreId = costPriorityCfgEntry.getLong("costtypesegstore.id");
            String costStruCfgValue = costPriorityCfgEntry.getString("coststrutypecfgvalue");
            DynamicObject costSegStoreObj = costSagStoreIdRefObjMap.get(costSegStoreId);
            costDefaultSegstoreMap.put("costStruCfgValue", costStruCfgValue);
            costDefaultSegstoreMap.put("costProportion", CostCfgConstants.HUNDRED);
            CostUtils.setSegmentVal(costSegStoreObj, costDefaultSegstoreMap);
        }
        return defaultCostCfgMap;
    }

    private void calCostSetUp(Map<String, List<Map<String, Object>>> costItemCfgInfo, SalaryfileInfo salaryFileInfo, Long salaryItemId, BigDecimal restPercentage, ORM orm, DynamicObject costSetupRst) {
        LOGGER.info("calCostSetUp: {}", costItemCfgInfo);
        Map<Long, DynamicObject> salaryItemInfoMap = this.setUpCommonInfo.getSalaryItemInfoMap();
        DynamicObject salaryItemObj = salaryItemInfoMap.get(salaryItemId);
        boolean isFixedCost = salaryItemObj.getBoolean("isfixedcost");
        if (isFixedCost) {
            this.messageList.add("isFixedCost is true...");
            this.dealFixedCost(costItemCfgInfo, salaryFileInfo, salaryItemId, restPercentage, orm, costSetupRst);
        } else {
            this.messageList.add("isFixedCost is false...");
            Map<String, CostCfg> salaryFileItemCostCfgMap = this.costSalaryFileCfgInfoMap.get(SWCCostConstants.COST_TYPE_SALARYFILEITEM);
            String salaryFileId = salaryFileInfo.getSalaryfileId();
            String sourceIdKey = String.join((CharSequence)"_", salaryItemId.toString(), salaryFileId);
            CostCfg salaryFileItemCostCfgObj = salaryFileItemCostCfgMap.get(sourceIdKey);
            Map<String, CostCfg> salaryFileCostCfgMap = this.costSalaryFileCfgInfoMap.get(SWCCostConstants.COST_TYPE_SALARYFILE);
            CostCfg salaryFileCostCfg = salaryFileCostCfgMap.get(salaryFileId);
            CostCfg posCostCfg = salaryFileInfo.getPosCostCfg();
            CostCfg deptCostCfg = salaryFileInfo.getDeptCostCfg();
            CostCfg empCostCfg = salaryFileInfo.getEmpCostCfg();
            SuperpositionChain superpositionChain = new SuperpositionChain(salaryFileInfo, salaryItemId, restPercentage, orm, costSetupRst, this.costSetupRstColl);
            superpositionChain.add(new SalaryfileItemCostCfgNode(salaryFileItemCostCfgObj)).add(new SalaryfileCostCfgNode(salaryFileCostCfg)).add(new EmpCostCfgNode(empCostCfg)).add(new PostCostCfgNode(posCostCfg)).add(new DepartmentCostCfgNode(deptCostCfg)).add(new SalaryItemCostCfgNode(costItemCfgInfo));
            Map<String, Object> resultMap = superpositionChain.doSuperposition(this.setUpCommonInfo, this.costSegStoreIdRefObjMap, this.costSetupConstMap, this.newCostSetupKeyList);
            StringBuilder logString = superpositionChain.getLogString();
            this.messageList.add(String.valueOf(logString));
            if (((Boolean)resultMap.get("isFull")).booleanValue()) {
                return;
            }
            List superpositionRstList = (List)resultMap.get("superpositionRstList");
            if (!superpositionRstList.isEmpty()) {
                DynamicObject costSetupRstObj = this.createCostSetUpDynamicObj(salaryItemId, salaryFileInfo, superpositionRstList, restPercentage, orm, costSetupRst);
                this.costSetupRstColl.add((Object)costSetupRstObj);
            } else {
                this.messageList.add("superpositionRstList value is null");
                Map<String, Object> currentDefaultCostCfgMap = salaryFileInfo.getDeptDefaultCostCfgMap();
                if (!MapUtils.isEmpty(currentDefaultCostCfgMap)) {
                    this.messageList.add(String.format(Locale.ROOT, "deptDefaultCostCfgMap value is: %s", JSON.toJSONString(currentDefaultCostCfgMap)));
                    DynamicObject costSetupRstObj = this.setCostSetUpObjBaseInfo(salaryItemId, salaryFileInfo, costSetupRst);
                    if (costSetupRstObj != null) {
                        DynamicObjectCollection costSetUpRstEntryColl = costSetupRstObj.getDynamicObjectCollection("entryentity");
                        DynamicObject costSetupEntryObj = this.createSetUpEntryDynamicObj(currentDefaultCostCfgMap, restPercentage, 1, true, orm);
                        costSetUpRstEntryColl.add((Object)costSetupEntryObj);
                        this.costSetupRstColl.add((Object)costSetupRstObj);
                    }
                }
            }
        }
    }

    public List<Map<String, Object>> superpositionRst(List<Map<String, Object>> superpositionCostCfgRstList, CostCfg costCfg) {
        if (!superpositionCostCfgRstList.isEmpty() && costCfg != null) {
            List<Map<String, Object>> posCostCfgEntryList = this.costCfgEntry2List(costCfg);
            List<Map<String, Object>> superpositionRstList = this.superpositionCostCfg(superpositionCostCfgRstList, posCostCfgEntryList);
            return superpositionRstList;
        }
        if (costCfg != null) {
            superpositionCostCfgRstList.addAll(this.costCfgEntry2List(costCfg));
            return superpositionCostCfgRstList;
        }
        return superpositionCostCfgRstList;
    }

    private void dealFixedCost(Map<String, List<Map<String, Object>>> costItemCfgInfo, SalaryfileInfo salaryFileInfo, Long salaryItemId, BigDecimal restPercentage, ORM orm, DynamicObject costSetupRst) {
        DynamicObject costSetupRstObj;
        Map<String, CostCfg> salaryFileItemCostCfgMap = this.costSalaryFileCfgInfoMap.get(SWCCostConstants.COST_TYPE_SALARYFILEITEM);
        String salaryFileId = salaryFileInfo.getSalaryfileId();
        String sourceIdKey = String.join((CharSequence)"_", salaryItemId.toString(), salaryFileId);
        CostCfg salaryFileItemCostCfgObj = salaryFileItemCostCfgMap.get(sourceIdKey);
        if (salaryFileItemCostCfgObj == null) {
            this.saveSetUpUseSalaryItemCfg(costItemCfgInfo, salaryFileInfo, salaryItemId, orm, costSetupRst, restPercentage);
            return;
        }
        List<Map<String, Object>> salaryItemCfgEntryList = this.costCfgEntry2List(salaryFileItemCostCfgObj);
        if (costItemCfgInfo == null) {
            DynamicObject costSetupRstObj2 = this.createCostSetUpDynamicObj(salaryItemId, salaryFileInfo, salaryItemCfgEntryList, restPercentage, orm, costSetupRst);
            this.costSetupRstColl.add((Object)costSetupRstObj2);
            return;
        }
        List<Map<String, Object>> costItemCfgEntryList = costItemCfgInfo.get("COST");
        if (costItemCfgEntryList == null || costItemCfgEntryList.isEmpty()) {
            DynamicObject costSetupRstObj3 = this.createCostSetUpDynamicObj(salaryItemId, salaryFileInfo, salaryItemCfgEntryList, restPercentage, orm, costSetupRst);
            this.costSetupRstColl.add((Object)costSetupRstObj3);
            return;
        }
        boolean isFull = this.validateSalaryFileCostCfgIsFull(salaryFileItemCostCfgObj);
        if (isFull) {
            costSetupRstObj = this.createCostSetUpDynamicObj(salaryItemId, salaryFileInfo, salaryItemCfgEntryList, restPercentage, orm, costSetupRst);
        } else {
            List<Map<String, Object>> costItemCfgSuperpositionRstList = this.superpositionCostCfg(salaryItemCfgEntryList, costItemCfgEntryList);
            costSetupRstObj = this.createCostSetUpDynamicObj(salaryItemId, salaryFileInfo, costItemCfgSuperpositionRstList, restPercentage, orm, costSetupRst);
        }
        this.costSetupRstColl.add((Object)costSetupRstObj);
    }

    public List<Map<String, Object>> superpositionCostCfg(List<Map<String, Object>> priorityList, List<Map<String, Object>> costCfgEntryList) {
        if (priorityList.isEmpty()) {
            return costCfgEntryList;
        }
        if (costCfgEntryList.isEmpty()) {
            return priorityList;
        }
        boolean isRevealFlag = this.isNeedRevealFlag(costCfgEntryList);
        BigDecimal costProportionCalSum = BigDecimal.ZERO;
        ArrayList<Map<String, Object>> superpositionCfgRstList = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < costCfgEntryList.size(); ++i) {
            Map<String, Object> costItemCfgEntry = costCfgEntryList.get(i);
            BigDecimal costItemProportion = (BigDecimal)costItemCfgEntry.get("costProportion");
            BigDecimal priorityTotalProportion = BigDecimal.ZERO;
            for (int j = 0; j < priorityList.size(); ++j) {
                BigDecimal cfgProportion;
                Map<String, Object> priorityCfEntry = priorityList.get(j);
                HashMap<String, Object> calculateRstMap = new HashMap<String, Object>(16);
                StringBuilder builder = this.setSegment(costItemCfgEntry, priorityCfEntry, calculateRstMap);
                BigDecimal priorityProportion = (BigDecimal)priorityCfEntry.get("costProportion");
                if (isRevealFlag && i == costCfgEntryList.size() - 1 && j == priorityList.size() - 1) {
                    cfgProportion = CostCfgConstants.HUNDRED.subtract(costProportionCalSum);
                    LOGGER.info("pay attention to generatecostup use subtract only once,costProportionCalSum:{}", (Object)costProportionCalSum);
                } else {
                    cfgProportion = costItemProportion.multiply(priorityProportion).divide(CostCfgConstants.HUNDRED);
                    LOGGER.info("pay attention to generatecostup use divide");
                }
                priorityTotalProportion = priorityTotalProportion.add(cfgProportion);
                costProportionCalSum = costProportionCalSum.add(cfgProportion);
                calculateRstMap.put("costProportion", cfgProportion);
                calculateRstMap.put("costStruCfgValue", builder.length() > 0 ? builder.substring(0, builder.lastIndexOf(".")) : "");
                superpositionCfgRstList.add(calculateRstMap);
            }
        }
        return superpositionCfgRstList;
    }

    private boolean isNeedRevealFlag(List<Map<String, Object>> costCfgEntryList) {
        BigDecimal costProportionSum = this.getCostProPortionSum(costCfgEntryList);
        boolean isRevealFlag = false;
        if (BigDecimal.valueOf(100L).compareTo(costProportionSum) == 0) {
            isRevealFlag = true;
        }
        return isRevealFlag;
    }

    private BigDecimal getCostProPortionSum(List<Map<String, Object>> costCfgEntryList) {
        BigDecimal costProportionSum = BigDecimal.ZERO;
        for (Map<String, Object> costCfgEntryMap : costCfgEntryList) {
            Object costProportionObj = costCfgEntryMap.get("costProportion");
            String costProportionStr = String.valueOf(costProportionObj);
            if (!SWCStringUtils.isNotEmpty((String)costProportionStr)) continue;
            BigDecimal costProportion = new BigDecimal(costProportionStr);
            Object costStruCfgValueObj = costCfgEntryMap.get("costStruCfgValue");
            String costStruCfgValueStr = String.valueOf(costStruCfgValueObj);
            if (!SWCStringUtils.isNotEmpty((String)costStruCfgValueStr)) continue;
            costProportionSum = costProportionSum.add(costProportion);
        }
        return costProportionSum;
    }

    private StringBuilder setSegment(Map<String, Object> costItemCfgEntry, Map<String, Object> prorityCfgEntry, Map<String, Object> calculateRstMap) {
        StringBuilder builder = new StringBuilder();
        int[] storageArr = this.setUpCommonInfo.getStorageArr();
        int costStruDimensionLen = storageArr.length;
        for (int i = 0; i < costStruDimensionLen; ++i) {
            String segmentKey = "segment" + storageArr[i];
            String proritySegmentVal = (String)prorityCfgEntry.get(segmentKey);
            if (!SWCStringUtils.isEmpty((String)proritySegmentVal)) {
                calculateRstMap.put(segmentKey, proritySegmentVal);
                builder.append(CostUtils.getNameVal(proritySegmentVal)).append('.');
                continue;
            }
            String costCfgSegmentVal = (String)costItemCfgEntry.get(segmentKey);
            if (!SWCStringUtils.isEmpty((String)costCfgSegmentVal)) {
                calculateRstMap.put(segmentKey, costCfgSegmentVal);
                builder.append(CostUtils.getNameVal(costCfgSegmentVal)).append('.');
                continue;
            }
            builder.append(' ').append('.');
        }
        return builder;
    }

    private void saveSetUpUseSalaryItemCfg(Map<String, List<Map<String, Object>>> costItemCfgInfo, SalaryfileInfo salaryFileInfo, Long salaryItemId, ORM orm, DynamicObject costSetupRst, BigDecimal restPercentage) {
        if (costItemCfgInfo == null) {
            return;
        }
        List<Map<String, Object>> costItemCfgEntryList = costItemCfgInfo.get("COST");
        if (costItemCfgEntryList == null) {
            return;
        }
        DynamicObject costSetupRstObj = this.createCostSetUpDynamicObj(salaryItemId, salaryFileInfo, costItemCfgEntryList, restPercentage, orm, costSetupRst);
        this.costSetupRstColl.add((Object)costSetupRstObj);
    }

    private List<Map<String, Object>> costCfgEntry2List(CostCfg costCfg) {
        ArrayList<Map<String, Object>> costCfgEntryInfoList = new ArrayList<Map<String, Object>>(10);
        if (costCfg == null) {
            return costCfgEntryInfoList;
        }
        List<CostCfgEntry> costCfgEntryList = costCfg.getCostCfgEntryList();
        BigDecimal totalPercent = BigDecimal.ZERO;
        for (CostCfgEntry costCfgEntry : costCfgEntryList) {
            BigDecimal costProportion = costCfgEntry.getCostProportion();
            Long costSegStoreId = costCfgEntry.getCostSegstore();
            String costStruCfgValue = costCfgEntry.getCostStruCfgValue();
            HashMap<String, Object> costCfgValMap = new HashMap<String, Object>(16);
            costCfgValMap.put("costProportion", costProportion);
            costCfgValMap.put("costStruCfgValue", costStruCfgValue);
            DynamicObject costSegStoreObj = this.costSegStoreIdRefObjMap.get(costSegStoreId);
            totalPercent = totalPercent.add(costProportion);
            if (costSegStoreObj == null) continue;
            CostUtils.setSegmentVal(costSegStoreObj, costCfgValMap);
            costCfgEntryInfoList.add(costCfgValMap);
        }
        if (totalPercent.compareTo(CostCfgConstants.HUNDRED) < 0) {
            HashMap<String, Object> costCfgValMap = new HashMap<String, Object>(1);
            costCfgValMap.put("costProportion", CostCfgConstants.HUNDRED.subtract(totalPercent));
            costCfgValMap.put("costStruCfgValue", "");
            costCfgEntryInfoList.add(costCfgValMap);
        }
        return costCfgEntryInfoList;
    }

    private boolean validateSalaryFileCostCfgIsFull(CostCfg costCfgObj) {
        List<CostCfgEntry> costCfgEntryList = costCfgObj.getCostCfgEntryList();
        int[] storageArr = this.setUpCommonInfo.getStorageArr();
        for (CostCfgEntry costcfgEntry : costCfgEntryList) {
            Long segStoreId = costcfgEntry.getCostSegstore();
            DynamicObject costSegStoreObj = this.costSegStoreIdRefObjMap.get(segStoreId);
            for (int i = 0; i < storageArr.length; ++i) {
                String segStoreKey = "segment" + storageArr[i];
                if (!SWCObjectUtils.isEmpty((Object)costSegStoreObj.get(segStoreKey))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateSetUpRstIsFull(List<Map<String, Object>> costItemCfgSuperpositionRstList) {
        BigDecimal totalPercent = BigDecimal.ZERO;
        int[] storageArr = this.setUpCommonInfo.getStorageArr();
        for (Map<String, Object> costCfgEntry : costItemCfgSuperpositionRstList) {
            boolean isFull = true;
            for (int i = 0; i < storageArr.length; ++i) {
                String segStoreKey = "segment" + storageArr[i];
                if (!SWCObjectUtils.isEmpty((Object)costCfgEntry.get(segStoreKey))) continue;
                isFull = false;
                break;
            }
            if (!isFull) continue;
            BigDecimal costProportion = (BigDecimal)costCfgEntry.get("costProportion");
            totalPercent = totalPercent.add(costProportion);
            costCfgEntry.put("isFull", Boolean.TRUE);
        }
        return CostCfgConstants.HUNDRED.compareTo(totalPercent) == 0;
    }

    private boolean validateSuperpositionRstIsEmpty(Map<String, Object> superpositionRst) {
        int[] storageArr = this.setUpCommonInfo.getStorageArr();
        for (int i = 0; i < storageArr.length; ++i) {
            String segStoreKey = "segment" + storageArr[i];
            if (superpositionRst.get(segStoreKey) == null) continue;
            return false;
        }
        return true;
    }

    public DynamicObject createCostSetUpDynamicObj(Long salaryItemId, SalaryfileInfo salaryfileInfo, List<Map<String, Object>> costSetList, BigDecimal restPercentage, ORM orm, DynamicObject costSetupRstObj) {
        DynamicObjectCollection costSetUpRstEntryColl = (costSetupRstObj = this.setCostSetUpObjBaseInfo(salaryItemId, salaryfileInfo, costSetupRstObj)).getDynamicObjectCollection("entryentity");
        if (costSetUpRstEntryColl == null) {
            return costSetupRstObj;
        }
        int seq = costSetUpRstEntryColl.size() + 1;
        List<String> isRequiredFieldList = this.setUpCommonInfo.getIsRequiredFieldList();
        Map<String, Map<String, Object>> mergedCostSetInfoMap = this.mergerCostSetInfo(costSetList);
        for (Map<String, Object> costSetInfo : mergedCostSetInfoMap.values()) {
            for (String isRequiredField : isRequiredFieldList) {
                if (!costSetupRstObj.getBoolean("enable") || costSetInfo.get(isRequiredField) != null) continue;
                costSetupRstObj.set("enable", (Object)"0");
                break;
            }
            DynamicObject costSetupEntryObj = this.createSetUpEntryDynamicObj(costSetInfo, restPercentage, seq++, orm);
            costSetUpRstEntryColl.add((Object)costSetupEntryObj);
        }
        return costSetupRstObj;
    }

    private Map<String, Map<String, Object>> mergerCostSetInfo(List<Map<String, Object>> costSetList) {
        int costSetListSize = costSetList.size();
        HashMap mergedCostSetInfoMap = Maps.newHashMapWithExpectedSize((int)costSetListSize);
        for (Map<String, Object> costSetInfo : costSetList) {
            String costStruCfgValue;
            if (this.validateSuperpositionRstIsEmpty(costSetInfo) || SWCStringUtils.isEmpty((String)(costStruCfgValue = (String)costSetInfo.get("costStruCfgValue")))) continue;
            Map mergedCostSetInfo = (Map)mergedCostSetInfoMap.get(costStruCfgValue);
            if (mergedCostSetInfo == null) {
                mergedCostSetInfo = Maps.newHashMapWithExpectedSize((int)costSetListSize);
                mergedCostSetInfo.putAll(costSetInfo);
                mergedCostSetInfoMap.put(costStruCfgValue, mergedCostSetInfo);
                continue;
            }
            BigDecimal costProportion = (BigDecimal)mergedCostSetInfo.get("costProportion");
            mergedCostSetInfo.put("costProportion", costProportion.add((BigDecimal)costSetInfo.get("costProportion")));
        }
        return mergedCostSetInfoMap;
    }

    private DynamicObject setCostSetUpObjBaseInfo(Long salaryItemId, SalaryfileInfo salaryFileInfo, DynamicObject costSetupRstObj) {
        Long salaryFileId = Long.parseLong(salaryFileInfo.getSalaryfileId());
        if (costSetupRstObj == null) {
            costSetupRstObj = this.createObjAndSetDefaultVal("pcs_costsetuprst");
            costSetupRstObj.set("enable", (Object)"1");
            Long calTaskId = this.setUpCommonInfo.getCalTaskId();
            Long costAdapterId = this.setUpCommonInfo.getCostAdapterId();
            Map<Long, Long> salaryItemRefCostItemMap = this.setUpCommonInfo.getSalaryItemRefCostItemMap();
            costSetupRstObj.set("caltask", (Object)calTaskId);
            costSetupRstObj.set("salaryfile", (Object)salaryFileId);
            costSetupRstObj.set("costadapter", (Object)costAdapterId);
            costSetupRstObj.set("salaryitem", (Object)salaryItemId);
            costSetupRstObj.set("belongperiod", (Object)this.setUpCommonInfo.getPayRollDate());
            costSetupRstObj.set("hrorg", (Object)this.setUpCommonInfo.getCreateOrgId());
            Long costItemId = salaryItemRefCostItemMap.get(salaryItemId);
            if (costItemId == null || costItemId == 0L) {
                costSetupRstObj.set("enable", (Object)"0");
            }
            costSetupRstObj.set("costitem", (Object)costItemId);
        }
        return costSetupRstObj;
    }

    private DynamicObject createSetUpEntryDynamicObj(Map<String, Object> costSetInfo, BigDecimal restPercentage, int index, ORM orm) {
        return this.createSetUpEntryDynamicObj(costSetInfo, restPercentage, index, false, orm);
    }

    private DynamicObject createSetUpEntryDynamicObj(Map<String, Object> costSetInfo, BigDecimal restPercentage, int index, boolean isDefault, ORM orm) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pcs_costsetuprst");
        EntityType type = (EntityType)mainType.getAllEntities().get("entryentity");
        DynamicObject costSetupEntryObj = (DynamicObject)type.createInstance();
        BigDecimal costProportion = (BigDecimal)costSetInfo.get("costProportion");
        String costStruCfgValue = (String)costSetInfo.get("costStruCfgValue");
        BigDecimal multiplyResult = costProportion.multiply(restPercentage.divide(CostCfgConstants.HUNDRED));
        BigDecimal percentage = multiplyResult.setScale(6, 4);
        costSetupEntryObj.set("percentage", (Object)percentage);
        costSetupEntryObj.set("aotucostsetupconstval", (Object)costStruCfgValue);
        costSetupEntryObj.set("defcostsetupconstval", (Object)costStruCfgValue);
        costSetupEntryObj.set("seq", (Object)index);
        costSetupEntryObj.set("isrevealdetail", (Object)(isDefault ? "1" : "0"));
        String costStruCfgValueMd5 = SWCStringUtils.getMD5str((String)costStruCfgValue);
        Long costSetupConstId = this.costSetupConstMap.get(costStruCfgValue);
        if (costSetupConstId != null) {
            costSetupEntryObj.set("aotucostsetupconst", (Object)costSetupConstId);
            costSetupEntryObj.set("defcostsetupconst", (Object)costSetupConstId);
        } else {
            Map<String, Map<String, Object>> costSetupConstMapFromCache = this.getCostSetupConstMapFromCache();
            Map<String, Object> costSetupConstInfoCache = costSetupConstMapFromCache.get(costStruCfgValue);
            if (costSetupConstInfoCache == null) {
                long startTime = System.currentTimeMillis();
                HashMap costSetupConstInfo = Maps.newHashMapWithExpectedSize((int)16);
                Long costStruId = this.setUpCommonInfo.getCostStruId();
                costSetupConstInfo.put("coststru", costStruId);
                costSetupConstInfo.put("segmentval", costStruCfgValue);
                costSetupConstInfo.put("segmentvalmd5", costStruCfgValueMd5);
                for (Map.Entry<String, Object> costSetInfoEntry : costSetInfo.entrySet()) {
                    String propName = costSetInfoEntry.getKey();
                    if (!propName.startsWith("segment")) continue;
                    String segStoreValue = (String)costSetInfoEntry.getValue();
                    if (segStoreValue != null && segStoreValue.contains("||")) {
                        segStoreValue = segStoreValue.substring(0, segStoreValue.indexOf("||"));
                    }
                    costSetupConstInfo.put(propName, segStoreValue);
                }
                long endTime = System.currentTimeMillis();
                this.addCostConstMap2Cache(costStruCfgValue, costSetupConstInfo);
                this.newCostSetupKeyList.add(costStruCfgValueMd5);
                LOGGER.info("no const info in cache,put new const in cache success,total time:{} ms", (Object)(endTime - startTime));
            } else {
                Long constId = (Long)costSetupConstInfoCache.get("id");
                if (constId != null) {
                    costSetupEntryObj.set("aotucostsetupconst", (Object)constId);
                    costSetupEntryObj.set("defcostsetupconst", (Object)constId);
                    this.costSetupConstMap.put(costStruCfgValueMd5, constId);
                }
            }
        }
        return costSetupEntryObj;
    }

    private DynamicObject createObjAndSetDefaultVal(String entityName) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("modifier", (Object)userId);
        return dynamicObject;
    }

    private void setSalaryFileRelatedInfo(DynamicObject[] salaryFileArr) {
        int len = salaryFileArr.length;
        this.salaryFileDeptMap = new HashMap<String, Long>(len);
        this.salaryFilePosMap = new HashMap<String, Long>(len);
        this.salaryFileEmpMap = new HashMap<String, Long>(len);
        Long calTaskId = this.setUpCommonInfo.getCalTaskId();
        Map<Long, DynamicObject> salaryFileCalPersonMap = this.getSalaryFileIdAndCalPersonDyMap(calTaskId);
        List<Long> sourceTypeList = Arrays.asList(SWCCostConstants.COST_TYPE_DEPT, SWCCostConstants.COST_TYPE_POST, SWCCostConstants.COST_TYPE_EMP);
        Long costAdapterId = this.setUpCommonInfo.getCostAdapterId();
        Map<Long, Set<String>> disableMap = GenerateCostSetUpHelper.getDisableCostCfg(costAdapterId, sourceTypeList);
        Set<String> deptDisableSet = disableMap.get(SWCCostConstants.COST_TYPE_DEPT);
        Set<String> postDisableSet = disableMap.get(SWCCostConstants.COST_TYPE_POST);
        Set<String> empDisableSet = disableMap.get(SWCCostConstants.COST_TYPE_EMP);
        for (DynamicObject salaryFileObj : salaryFileArr) {
            DynamicObject calPersonDy;
            long salaryFileId = salaryFileObj.getLong("id");
            String salaryFileIdStr = String.valueOf(salaryFileId);
            long empId = salaryFileObj.getLong("employee.id");
            if (empId != 0L && this.isDisable(empDisableSet, empId)) {
                this.salaryFileEmpMap.put(salaryFileIdStr, empId);
            }
            if ((calPersonDy = salaryFileCalPersonMap.get(salaryFileId)) == null) continue;
            long deptId = calPersonDy.getLong("empposorgrelhrv.adminorg.id");
            long posId = calPersonDy.getLong("empposorgrelhrv.position.id");
            LOGGER.info("setSalaryFileRelatedInfo deptId :", (Object)deptId);
            LOGGER.info("setSalaryFileRelatedInfo posId :", (Object)posId);
            if (deptId != 0L) {
                this.salaryFileDeptMap.put(salaryFileIdStr, deptId);
            }
            if (posId == 0L || !this.isDisable(postDisableSet, posId)) continue;
            this.salaryFilePosMap.put(salaryFileIdStr, posId);
        }
    }

    private Map<Long, DynamicObject> getSalaryFileIdAndCalPersonDyMap(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryFileFilter = new QFilter("salaryfile.id", "in", this.salaryFileIdList);
        salaryFileFilter.and(new QFilter("caltask.id", "=", (Object)calTaskId));
        String selectProperties = "id,salaryfile,empposorgrelhrv.position,empposorgrelhrv.adminorg";
        DynamicObject[] calPersonArr = serviceHelper.query(selectProperties, new QFilter[]{salaryFileFilter});
        HashMap<Long, DynamicObject> salaryFileCalPersonMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject calPersonDy : calPersonArr) {
            long salaryFileId = calPersonDy.getLong("salaryfile.id");
            salaryFileCalPersonMap.put(salaryFileId, calPersonDy);
        }
        return salaryFileCalPersonMap;
    }

    private boolean isDisable(Set<String> disableSet, long id) {
        return CollectionUtils.isEmpty(disableSet) || !CollectionUtils.isEmpty(disableSet) && !disableSet.contains(String.valueOf(id));
    }

    private void setCostCfgEntryIdRefCostSegStoreIdMap() {
        this.putCostCfgEntryIdRefCostSegStoreIdMap(this.costSalaryFileCfgInfoMap);
        this.putCostCfgEntryIdRefCostSegStoreIdMap(this.setUpCommonInfo.getCostBasicCfgInfoMap());
    }

    private void putCostCfgEntryIdRefCostSegStoreIdMap(Map<Long, Map<String, CostCfg>> costCfgInfoMap) {
        for (Map.Entry<Long, Map<String, CostCfg>> entry : costCfgInfoMap.entrySet()) {
            Map<String, CostCfg> value = entry.getValue();
            if (value.isEmpty()) continue;
            this.initCostSegStoreIdMap(value);
        }
    }

    private void initCostSegStoreIdMap(Map<String, CostCfg> value) {
        for (Map.Entry<String, CostCfg> costEntry : value.entrySet()) {
            CostCfg costCfg = costEntry.getValue();
            List<CostCfgEntry> costCfgEntryEntity = costCfg.getCostCfgEntryList();
            for (CostCfgEntry costCfgDetail : costCfgEntryEntity) {
                this.costCfgEntryIdRefCostSegStoreIdMap.put(costCfgDetail.getEntryId(), costCfgDetail.getCostSegstore());
            }
        }
    }

    private void deleteSetUpByGenerateStrategy(String generateStrategy, Map<String, Long> queryDefinedCostSetUpMap, SWCDataServiceHelper serviceHelper) {
        Long calTaskId = this.setUpCommonInfo.getCalTaskId();
        if ("1".equals(generateStrategy)) {
            serviceHelper.deleteByFilter(new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId), new QFilter("salaryfile.id", "in", this.salaryFileIdList)});
        } else if ("2".equals(generateStrategy)) {
            serviceHelper.deleteByFilter(new QFilter[]{new QFilter("id", "not in", queryDefinedCostSetUpMap.values()), new QFilter("caltask.id", "=", (Object)calTaskId), new QFilter("salaryfile.id", "in", this.salaryFileIdList)});
        }
    }

    private void setCostCfgInfoMap() {
        Long costAdapterId = this.setUpCommonInfo.getCostAdapterId();
        Date calTaskEndDate = this.setUpCommonInfo.getCalTaskEndDate();
        this.costSalaryFileCfgInfoMap = GenerateCostSetUpHelper.querySalaryfileCostCfgMap(costAdapterId, calTaskEndDate, this.salaryFileIdList);
    }

    private void setCostSegStoreIdRefObjMap() {
        this.costSegStoreIdRefObjMap = GenerateCostSetUpHelper.queryCostSegstoreIdRefObjeMap(this.costCfgEntryIdRefCostSegStoreIdMap.values());
    }

    private void setDefaultCostCfgMap() {
        this.deptDefaultCostCfgMap = this.getDefaultCostCfgMap();
    }

    private void setCostSetupConstMap() {
        this.costSetupConstMap = GenerateCostSetUpHelper.queryCostSetupConstMap(this.setUpCommonInfo.getCostStruId());
    }

    private Map<String, Map<String, Object>> getCostSetupConstMapFromCache() {
        Long costStruId = this.setUpCommonInfo.getCostStruId();
        ISWCAppCache appCache = SWCAppCache.get((String)"generateCostSetUp_newConst_appCache");
        Map costSetupConstCacheMap = (Map)appCache.get(costStruId.toString(), Map.class);
        if (costSetupConstCacheMap == null) {
            costSetupConstCacheMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        return costSetupConstCacheMap;
    }

    private void addCostConstMap2Cache(String costStruCfgValue, Map<String, Object> costSetupConstInfo) {
        Long costStruId = this.setUpCommonInfo.getCostStruId();
        ISWCAppCache appCache = SWCAppCache.get((String)"generateCostSetUp_newConst_appCache");
        String costStruStr = costStruId.toString();
        Map<String, Map<String, Object>> costSetupConstMapFromCache = this.getCostSetupConstMapFromCache();
        costSetupConstMapFromCache.put(costStruCfgValue, costSetupConstInfo);
        appCache.put(costStruStr, costSetupConstMapFromCache);
    }

    private void clearCurrentCostSetupConstData() {
        Map<String, Map<String, Object>> costSetupConstMapFromCache = this.getCostSetupConstMapFromCache();
        if (this.newCostSetupKeyList == null || this.newCostSetupKeyList.isEmpty()) {
            return;
        }
        this.newCostSetupKeyList.forEach(newCostSetupKey -> costSetupConstMapFromCache.remove(newCostSetupKey));
        ISWCAppCache appCache = SWCAppCache.get((String)"generateCostSetUp_newConst_appCache");
        Long costStruId = this.setUpCommonInfo.getCostStruId();
        appCache.put(costStruId.toString(), costSetupConstMapFromCache);
    }

    private void setCostTypeDeptInfo() {
        Map<String, CostCfg> adminOrgStructNumberMap = this.setUpCommonInfo.getAdminOrgStructNumberMap();
        List<Object> costCfgIdList = new ArrayList(10);
        if (!CollectionUtils.isEmpty(adminOrgStructNumberMap)) {
            costCfgIdList = adminOrgStructNumberMap.entrySet().stream().map(item -> ((CostCfg)item.getValue()).getId()).collect(Collectors.toList());
        }
        CostSetUpExtService extService = new CostSetUpExtService();
        this.costCfgTypeDeptArgs = new CostCfgTypeDeptArgs();
        this.costCfgTypeDeptArgs.setCostCfgIdList(costCfgIdList);
        this.hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostSetUpService.class, (String)"kd.sdk.swc.hscs.service.api.ICostSetUpService#handleCostCfgDept", null);
        this.hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.setCostTypeDeptInfo(this.costCfgTypeDeptArgs);
            return null;
        });
    }
}

