/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.costallot.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.common.enums.CostAllotFeedbackEnum;

public class CostCreateAllotDetailHelper {
    private static final Log LOGGER = LogFactory.getLog(CostCreateAllotDetailHelper.class);
    private static final int MAX_LEN = 13;

    public static void setProgressInfo(Long calTaskId, int batchTotal, int currentSalaryfileIdSize, int result) {
        CostAllocationProgressInfo costAllocationProgressInfo = CostCreateAllotDetailHelper.getProgressInfoFromCache(calTaskId);
        int total = costAllocationProgressInfo.getTotal();
        int finishCache = costAllocationProgressInfo.getFinish();
        int totalFinish = finishCache + currentSalaryfileIdSize;
        int failCount = costAllocationProgressInfo.getFail();
        int batchFailCount = batchTotal - currentSalaryfileIdSize;
        costAllocationProgressInfo.setFinish(totalFinish);
        costAllocationProgressInfo.setFail(result == 0 ? failCount : (failCount += batchFailCount) + currentSalaryfileIdSize);
        int realTotalFinish = costAllocationProgressInfo.getFinish() + costAllocationProgressInfo.getFail();
        costAllocationProgressInfo.setStatus(realTotalFinish == total ? 2 : 1);
        String key = String.format(Locale.ROOT, "cache_costallotdetail_key_%s", calTaskId);
        SWCAppCache.get((String)"pcs").put(key, (Object)costAllocationProgressInfo);
    }

    public static CostAllocationProgressInfo getProgressInfoFromCache(Long calTaskId) {
        String key = String.format(Locale.ROOT, "cache_costallotdetail_key_%s", calTaskId);
        CostAllocationProgressInfo costAllocationProgressInfo = (CostAllocationProgressInfo)SWCAppCache.get((String)"pcs").get(key, CostAllocationProgressInfo.class);
        if (costAllocationProgressInfo == null) {
            costAllocationProgressInfo = new CostAllocationProgressInfo();
        }
        return costAllocationProgressInfo;
    }

    public static void updateProcess(String batchId, Long calTaskId, int totalNum, int successNum, HashSet<String> errorInfos) {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashMap<String, Integer> process = (HashMap<String, Integer>)appCache.get("process" + batchId + calTaskId, HashMap.class);
        HashSet<String> errorInfoSet = (HashSet<String>)appCache.get(batchId + '_' + calTaskId + "opfail", HashSet.class);
        if (process == null) {
            process = new HashMap<String, Integer>(2);
            process.put("successCount", successNum);
            process.put("failCount", totalNum - successNum);
        } else {
            process.put("successCount", (Integer)process.get("successCount") + successNum);
            process.put("failCount", (Integer)process.get("failCount") + totalNum - successNum);
        }
        if (errorInfoSet == null) {
            errorInfoSet = new HashSet<String>(16);
        }
        errorInfoSet.addAll(errorInfos);
        appCache.put("process" + batchId + calTaskId, process);
        appCache.put(batchId + '_' + calTaskId + "opfail", errorInfoSet);
    }

    public static void dealTermination(Long calTaskId) {
        SWCDataServiceHelper allotTaskHelper = new SWCDataServiceHelper("pcs_allottask");
        allotTaskHelper.deleteByFilter(new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotdetail");
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
    }

    public static void updateCostAllocationRecordInfo(Long recordId, String costTaskStatus, int failCount) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costrecord");
        DynamicObject costRecordObj = serviceHelper.queryOne("costtaskstatus,downloadurl,createtime,finishtime,usetime,failcount,modifier", (Object)recordId);
        if (costRecordObj == null) {
            return;
        }
        Date currentTime = new Date();
        costRecordObj.set("costtaskstatus", (Object)costTaskStatus);
        costRecordObj.set("finishtime", (Object)currentTime);
        long userId = RequestContext.get().getCurrUserId();
        costRecordObj.set("modifier", (Object)userId);
        costRecordObj.set("failcount", (Object)failCount);
        serviceHelper.saveOne(costRecordObj);
    }

    public static DynamicObject[] queryCalPersonIdsByCalTaskId(Long calTaskId, List<Long> salaryFileList, String strategy) {
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calTaskId);
        if (!CollectionUtils.isEmpty(salaryFileList)) {
            calPersonFilter.and(new QFilter("salaryfile.id", "in", salaryFileList));
        }
        if (SWCStringUtils.equals((String)"3", (String)strategy)) {
            calPersonFilter.and(new QFilter("allotstatus", "!=", (Object)"B"));
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        return calPersonHelper.query("id", new QFilter[]{calPersonFilter});
    }

    public static DynamicObject[] queryCalPersonIdsByCalPersonIds(String selectProperties, List<Long> calPersonIds) {
        QFilter calPersonFilter = new QFilter("id", "in", calPersonIds);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        return calPersonHelper.query(selectProperties, new QFilter[]{calPersonFilter});
    }

    public static Map<String, List<Long>> packgeCalInfo(DynamicObject[] calPersonArr) {
        int len = calPersonArr.length;
        ArrayList<Long> salaryfileIdList = new ArrayList<Long>(len);
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(len);
        ArrayList<Long> feedBackCalIdList = new ArrayList<Long>(len);
        ArrayList<Long> calTableIdList = new ArrayList<Long>(len);
        for (DynamicObject calPerson : calPersonArr) {
            salaryfileIdList.add(calPerson.getLong("salaryfile.id"));
            feedBackCalIdList.add(calPerson.getLong("id"));
            calTableIdList.add(calPerson.getLong("calresultid"));
            String allotstatus = calPerson.getString("allotstatus");
            if (!"A".equals(allotstatus)) continue;
            calPersonIdList.add(calPerson.getLong("id"));
        }
        HashMap<String, List<Long>> calPkIdInfoMap = new HashMap<String, List<Long>>(16);
        calPkIdInfoMap.put("salaryfileIdList", salaryfileIdList);
        calPkIdInfoMap.put("calPersonIdList", calPersonIdList);
        calPkIdInfoMap.put("feedBackCalIdList", feedBackCalIdList);
        calPkIdInfoMap.put("calTableIdList", calTableIdList);
        return calPkIdInfoMap;
    }

    public static DynamicObject queryCalTaskById(Long calTaskId) {
        QFilter calTaskIdFilter = new QFilter("id", "=", (Object)calTaskId);
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String selectProp = "payrollgroupv,exratedate,startdate,enddate,paydate,payrolldate";
        DynamicObject calTask = calTaskHelper.queryOne(selectProp, new QFilter[]{calTaskIdFilter});
        return calTask;
    }

    public static DynamicObject[] querySalaryfileArrByIds(List<Long> salaryfileIdList) {
        QFilter qFilter = new QFilter("id", "in", salaryfileIdList);
        SWCDataServiceHelper salaryfileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProp = "empposinfo";
        return salaryfileHelper.query(selectProp, new QFilter[]{qFilter});
    }

    public static Map<Long, DynamicObject> getSalaryfileIdRefOBjMap(List<Long> salaryfileIdList) {
        DynamicObject[] salaryfileArr = CostCreateAllotDetailHelper.querySalaryfileArrByIds(salaryfileIdList);
        HashMap<Long, DynamicObject> salaryfileIdRefOBjMap = new HashMap<Long, DynamicObject>(salaryfileArr.length);
        for (DynamicObject salaryfile : salaryfileArr) {
            salaryfileIdRefOBjMap.put(salaryfile.getLong("id"), salaryfile);
        }
        return salaryfileIdRefOBjMap;
    }

    public static DynamicObject[] queryCalTableArrByIds(String selectProperties, List<Long> calTableIdList) {
        QFilter calPersonFilter = new QFilter("id", "in", calTableIdList);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_caltable");
        DynamicObject[] calPersonArr = calPersonHelper.query(selectProperties, new QFilter[]{calPersonFilter});
        return calPersonArr;
    }

    public static Map<Long, DynamicObject> getCalTableIdRefCalTableObjMap(List<Long> calTableIdList) {
        String selectProperties = "calamountvalue,salaryitem,hsas_caltableentry,hsas_caltableentry.slprorationindex";
        DynamicObject[] calTableArr = CostCreateAllotDetailHelper.queryCalTableArrByIds(selectProperties, calTableIdList);
        return Arrays.stream(calTableArr).collect(Collectors.toMap(key -> key.getLong("id"), value -> value));
    }

    public static long saveCostRecordInfo(int costFileNumber, String calTaskId, String recordtype) {
        DynamicObject costAllocationRecordDy = CostCreateAllotDetailHelper.saveCostAllocationRecordInfo(costFileNumber, calTaskId, recordtype);
        long costAllocationRecordId = costAllocationRecordDy.getLong("id");
        String fileName = costAllocationRecordDy.getString("recordnumber");
        String fileNameKey = String.format(Locale.ROOT, "cache_costallocationrecord_id_key_%s", costAllocationRecordId);
        IAppCache appCache = AppCache.get((String)"pcs");
        appCache.put(fileNameKey, (Object)fileName);
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        costAllocationRecordDy.set("filename", (Object)fileName);
        costRecordHelper.saveOne(costAllocationRecordDy);
        return costAllocationRecordDy.getLong("id");
    }

    public static DynamicObject queryCostAdapterIdByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("payrollgroupv", (Object)calTaskId);
        Long payrollGroupVid = calTaskObj.getLong("payrollgroupv.id");
        serviceHelper.setEntityName("pcs_costadaptionmap");
        DynamicObject dynamicObject = serviceHelper.queryOne("costadaption", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "=", (Object)payrollGroupVid), new QFilter("status", "=", (Object)"C")}, "modifytime desc");
        return dynamicObject == null ? null : dynamicObject.getDynamicObject("costadaption");
    }

    private static DynamicObject saveCostAllocationRecordInfo(int costFileNum, String calTaskId, String recordtype) {
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        DynamicObject costAllocationRecordDy = costRecordHelper.generateEmptyDynamicObject();
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(calTaskId));
        DynamicObject calTaskDy = calTaskHelper.queryOne("id,number,period.number,periodtype.number,", new QFilter[]{filter});
        String calTaskNumber = calTaskDy.getString("number");
        String periodNumber = calTaskDy.getString("period.number");
        String periodTypeNumber = calTaskDy.getString("periodtype.number");
        if (periodNumber == null) {
            costAllocationRecordDy.set("calperiodnumber", (Object)"");
        } else {
            String calPeriodAndTypeNumber = periodTypeNumber + '-' + periodNumber;
            costAllocationRecordDy.set("calperiodnumber", (Object)calPeriodAndTypeNumber);
        }
        costAllocationRecordDy.set("caltask", (Object)calTaskId);
        String recordNumber = CostCreateAllotDetailHelper.getRecordNumber();
        costAllocationRecordDy.set("recordnumber", (Object)(calTaskNumber + '-' + recordNumber));
        costAllocationRecordDy.set("costtaskstatus", (Object)"2");
        costAllocationRecordDy.set("createtime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        costAllocationRecordDy.set("creator", (Object)userId);
        costAllocationRecordDy.set("modifier", (Object)userId);
        costAllocationRecordDy.set("modifytime", (Object)new Date());
        costAllocationRecordDy.set("totalcount", (Object)costFileNum);
        costAllocationRecordDy.set("failcount", (Object)0);
        costAllocationRecordDy.set("recordtype", (Object)recordtype);
        costAllocationRecordDy.set("id", (Object)DB.genLongId((String)"pcs_costrecord"));
        return costAllocationRecordDy;
    }

    private static String getRecordNumber() {
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        DynamicObject costRecordDy = costRecordHelper.generateEmptyDynamicObject();
        return CodeRuleHelper.getNumber((DynamicObject)costRecordDy, null);
    }

    public static Map<String, Object> packegeSetupInfo(Long calTaskId, List<Long> salaryfileList) {
        DynamicObject[] costSetupArr = CostCreateAllotDetailHelper.queryCostSetUpArr(calTaskId, salaryfileList);
        HashMap<String, Object> setupInfoMap = new HashMap<String, Object>(2);
        HashMap<String, HashMap<String, DynamicObject>> costSetupMap = new HashMap<String, HashMap<String, DynamicObject>>(costSetupArr.length);
        HashMap<Long, String> costSetupConstIdRefCostSetupConstValMap = new HashMap<Long, String>(costSetupArr.length);
        for (DynamicObject costSetup : costSetupArr) {
            String salaryfileId = costSetup.getString("salaryfile.id");
            String salaryitemId = costSetup.getString("salaryitem.id");
            HashMap<String, DynamicObject> salaryItemCostSetupMap = (HashMap<String, DynamicObject>)costSetupMap.get(salaryfileId);
            if (salaryItemCostSetupMap == null) {
                salaryItemCostSetupMap = new HashMap<String, DynamicObject>(11);
                salaryItemCostSetupMap.put(salaryitemId, costSetup);
                costSetupMap.put(salaryfileId, salaryItemCostSetupMap);
            }
            salaryItemCostSetupMap.put(salaryitemId, costSetup);
            DynamicObjectCollection entryentity = costSetup.getDynamicObjectCollection("entryentity");
            for (DynamicObject costSetupEnt : entryentity) {
                long defCostSetupConstId = costSetupEnt.getLong("defcostsetupconst.id");
                String defcostsetupconstval = costSetupEnt.getString("defcostsetupconstval");
                costSetupConstIdRefCostSetupConstValMap.put(defCostSetupConstId, defcostsetupconstval);
            }
        }
        setupInfoMap.put("salaryfileIdRefsalaryItemMap", costSetupMap);
        setupInfoMap.put("costSetupConstIdRefCostSetupConstValMap", costSetupConstIdRefCostSetupConstValMap);
        return setupInfoMap;
    }

    public static DynamicObject[] queryCostSetUpArr(Long calTaskId, List<Long> salaryfileList) {
        QFilter costSetUpPartitionFilter = CostCreateAllotDetailHelper.getCostSetUpPartitionFilter(calTaskId);
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        costSetUpPartitionFilter.and(new QFilter("salaryfile.id", "in", salaryfileList));
        String properties = "caltask,salaryfile,salaryitem,costadapter,percentage,defcostsetupconst,defcostsetupconstval,maxmount,isrevealdetail,costitem";
        return costSetupRstHelper.query(properties, new QFilter[]{costSetUpPartitionFilter});
    }

    private static QFilter getCostSetUpPartitionFilter(Long calTaskId) {
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskDy = calTaskHelper.queryOne("payrollgroup.costadaption.id,payrolldate", new QFilter[]{new QFilter("id", "=", (Object)calTaskId)});
        Date payrollDate = calTaskDy.getDate("payrolldate");
        QFilter qFilter = new QFilter("belongperiod", "=", (Object)payrollDate);
        qFilter.and(new QFilter("caltask.id", "=", (Object)calTaskId));
        DynamicObject costAdapterObj = CostCreateAllotDetailHelper.queryCostAdapterIdByCalTaskId(calTaskId);
        if (costAdapterObj != null) {
            long costAdapterId = costAdapterObj.getLong("id");
            SWCDataServiceHelper adaptionHelper = new SWCDataServiceHelper("lcs_costadaption");
            DynamicObject adaptionDy = adaptionHelper.queryOne("createorg.id", new QFilter[]{new QFilter("id", "=", (Object)costAdapterId)});
            long createOrgId = adaptionDy.getLong("createorg.id");
            qFilter.and(new QFilter("hrorg.id", "=", (Object)createOrgId));
        }
        return qFilter;
    }

    public static DynamicObject[] queryCalPersonArr(List<Long> calPersonIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("id", "in", calPersonIdList);
        return calPersonHelper.query("allotstatus", new QFilter[]{calPersonFilter});
    }

    public static void updateCalPersonAllotStatus(DynamicObject[] calPersonArr) {
        for (DynamicObject calPerson : calPersonArr) {
            calPerson.set("allotstatus", (Object)"B");
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        if (calPersonArr.length > 0) {
            calPersonHelper.update(calPersonArr);
        }
    }

    public static Long saveCostAllocationInfo(Long calTaskId, Long costAdapterId) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_allottask");
        String fields = "id,hrorg,costadapter,caltask,creator,modifier,createtime,modifytime,costtaskstatus";
        DynamicObject costAllocationDy = costAllocationHelper.queryOne(fields, new QFilter[]{new QFilter("caltask", "=", (Object)calTaskId)});
        if (costAllocationDy == null) {
            costAllocationDy = costAllocationHelper.generateEmptyDynamicObject();
        }
        long adaptionOrgId = CostCreateAllotDetailHelper.getAdaptionOrgId(costAdapterId);
        costAllocationDy.set("hrorg", (Object)adaptionOrgId);
        costAllocationDy.set("costadapter", (Object)costAdapterId);
        costAllocationDy.set("caltask", (Object)calTaskId);
        long userId = RequestContext.get().getCurrUserId();
        costAllocationDy.set("creator", (Object)userId);
        costAllocationDy.set("modifier", (Object)userId);
        costAllocationDy.set("createtime", (Object)new Date());
        costAllocationDy.set("modifytime", (Object)new Date());
        costAllocationDy.set("costtaskstatus", (Object)"2");
        costAllocationHelper.saveOne(costAllocationDy);
        return costAllocationDy.getLong("id");
    }

    public static long getAdaptionOrgId(Long adaptionId) {
        SWCDataServiceHelper costCfgHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter qFilter = new QFilter("id", "=", (Object)adaptionId);
        DynamicObject adaptionDy = costCfgHelper.queryOne("id,createorg", new QFilter[]{qFilter});
        return adaptionDy == null ? 0L : adaptionDy.getLong("createorg.id");
    }

    public static String validateAmtArr(String salaryItem, BigDecimal ... amtArr) {
        String validateResult = "";
        for (int i = 0; i < amtArr.length; ++i) {
            if (CostCreateAllotDetailHelper.validateAmt(amtArr[i])) continue;
            validateResult = String.format(Locale.ROOT, CostAllotFeedbackEnum.AMT_FORMAT_ERROR.getDesc().getDescription(), salaryItem);
            break;
        }
        return validateResult;
    }

    private static boolean validateAmt(BigDecimal amt) {
        if (amt == null) {
            LOGGER.error("\u3010\u91d1\u989d\u5927\u5c0f\u6821\u9a8c\u3011\u4f20\u5165\u7684\u91d1\u989d\u4e3a\u7a7a");
            return false;
        }
        BigDecimal integerAmt = amt.setScale(0, 1);
        String integerAmtStr = integerAmt.toPlainString();
        return integerAmtStr.length() <= 13;
    }

    public static DynamicObject createCostAllotDynamicObj(DynamicObject calPerson, DynamicObject calTask, DynamicObject salaryfile) {
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        DynamicObject allotDetailObj = allotDetailHelper.generateEmptyDynamicObject();
        Long userId = RequestContext.get().getCurrUserId();
        Date currentTime = new Date();
        allotDetailObj.set("createtime", (Object)currentTime);
        allotDetailObj.set("creator", (Object)userId);
        allotDetailObj.set("modifier", (Object)userId);
        allotDetailObj.set("modifytime", (Object)currentTime);
        allotDetailObj.set("onholdstatus", (Object)calPerson.getString("onholdstatus"));
        allotDetailObj.set("exratedate", (Object)calTask.getDate("exratedate"));
        allotDetailObj.set("caltableid", (Object)calPerson.getLong("id"));
        allotDetailObj.set("calcur", (Object)calTask.getLong("payrollgroupv.currency.id"));
        allotDetailObj.set("salaryfile", (Object)calPerson.getDynamicObject("salaryfile"));
        allotDetailObj.set("org", (Object)calPerson.getDynamicObject("org"));
        allotDetailObj.set("enable", (Object)"1");
        allotDetailObj.set("status", (Object)"A");
        allotDetailObj.set("allotbillstatus", (Object)"A");
        allotDetailObj.set("allotbill", (Object)0L);
        allotDetailObj.set("adminorg", (Object)calPerson.getDynamicObject("adminorg"));
        allotDetailObj.set("company", (Object)calPerson.getLong("empposorgrelhrv.company.id"));
        allotDetailObj.set("department", (Object)calPerson.getLong("empposorgrelhrv.adminorg.id"));
        allotDetailObj.set("persongroup", (Object)calPerson.getLong("empgroup.id"));
        allotDetailObj.set("payrollgroup", (Object)calTask.getLong("payrollgroupv.id"));
        allotDetailObj.set("startdate", (Object)calTask.getDate("startdate"));
        allotDetailObj.set("enddate", (Object)calTask.getDate("enddate"));
        allotDetailObj.set("paydate", (Object)calTask.getDate("paydate"));
        allotDetailObj.set("laborreltype", (Object)calPerson.getLong("empentrelv.laborreltype.id"));
        allotDetailObj.set("laborrelstatus", (Object)calPerson.getLong("empentrelv.laborrelstatus.id"));
        return allotDetailObj;
    }

    public static void updateCostAllotStatus(Long costAllotDyId, String status) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allottask");
        DynamicObject costAllotObj = serviceHelper.queryOne("modifytime,costtaskstatus,modifier", (Object)costAllotDyId);
        if (costAllotObj == null) {
            return;
        }
        costAllotObj.set("modifytime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        costAllotObj.set("modifier", (Object)userId);
        costAllotObj.set("costtaskstatus", (Object)status);
        serviceHelper.saveOne(costAllotObj);
    }
}

