/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.WriteTaskTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.hisdata.check.DataCheckServiceTask;
import kd.swc.hscs.business.hisdata.utils.DataCheckUtils;

public class DataCheckService {
    private static final Log logger = LogFactory.getLog(DataCheckService.class);
    private static final String DATASTATUS_PREPARED = "1";
    public static final String DATASTATUS_CHECKERROR = "2";
    private Long verifyRecordId;
    private Long importTaskId;
    private String writeTaskType;

    public DataCheckService(Long verifyRecordId, Long importTaskId, String writeTaskType) {
        this.verifyRecordId = verifyRecordId;
        this.importTaskId = importTaskId;
        this.writeTaskType = writeTaskType;
    }

    public void checkData() {
        logger.info("checkData start,importTaskId={}", (Object)this.importTaskId);
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
            QFilter filter = new QFilter("importtask.id", "=", (Object)this.importTaskId);
            filter.and(new QFilter("datastatus", "in", Arrays.asList(DATASTATUS_PREPARED, DATASTATUS_CHECKERROR)));
            DynamicObjectCollection result = helper.queryOriginalCollection("id,caltaskname", new QFilter[]{filter});
            Map<String, List<DynamicObject>> temporaryMap = result.stream().collect(Collectors.groupingBy(obj -> obj.getString("caltaskname")));
            Map<String, List<DynamicObject>> calTaskMap = this.getCalTaskMap(temporaryMap.keySet(), this.writeTaskType);
            for (Map.Entry<String, List<DynamicObject>> entry : temporaryMap.entrySet()) {
                List<Long> temporaryIdList = entry.getValue().stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
                this.batchCheckData(entry.getKey(), calTaskMap, temporaryIdList);
            }
        }
        catch (Exception ex) {
            logger.error("checkData error.", (Throwable)ex);
        }
        logger.info("checkData end,importTaskId={}", (Object)this.importTaskId);
    }

    private Map<String, Long> getPeriodTypeMap(Set<String> periodTypeNameSet) {
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        String fields = "id,name";
        QFilter filter = new QFilter("name", "in", periodTypeNameSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)DATASTATUS_PREPARED);
        DynamicObjectCollection result = periodHelper.queryOriginalCollection(fields, new QFilter[]{filter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj.getLong("id")));
    }

    private void batchCheckData(String calTaskName, Map<String, List<DynamicObject>> calTaskMap, List<Long> temporaryIdList) {
        logger.info("batchCheckData start,importTaskId={},calTaskName={}", (Object)this.importTaskId, (Object)calTaskName);
        if (DataCheckUtils.isCancelOperate(this.verifyRecordId)) {
            logger.info("cancelOperate\uff0cimportTaskId={}", (Object)this.importTaskId);
            return;
        }
        HashSet<String> empGroupNameSet = new HashSet<String>(16);
        HashSet<String> adminOrgNameSet = new HashSet<String>(16);
        DynamicObject[] dataArray = this.getTemporaryList(temporaryIdList, this.importTaskId);
        Set<String> periodtypeNameSet = Arrays.asList(dataArray).stream().map(obj -> obj.getString("periodtypename")).collect(Collectors.toSet());
        Map<String, Long> periodTypeMap = this.getPeriodTypeMap(periodtypeNameSet);
        DynamicObjectCollection verifyList = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        DynamicObjectCollection noCheckPassList = new DynamicObjectCollection();
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> passList = new ArrayList<DynamicObject>(10);
        List<DynamicObject> tempTaskIdList = null;
        DynamicObject calTask = null;
        for (DynamicObject obj2 : dataArray) {
            tempTaskIdList = calTaskMap.get(obj2.getString("caltaskname"));
            if (SWCListUtils.isEmpty(tempTaskIdList)) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, obj2, "0", ImportTaskFailMsgEnum.CALTASK_NOT_EXIST, this.verifyRecordId));
                noCheckPassList.add((Object)obj2);
                continue;
            }
            if (tempTaskIdList.size() > 1) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, obj2, DATASTATUS_CHECKERROR, ImportTaskFailMsgEnum.CALTASK_HAS_MULTIPLE_FORCHECK, this.verifyRecordId));
                noCheckPassList.add((Object)obj2);
                continue;
            }
            calTask = tempTaskIdList.get(0);
            obj2.set("caltask", (Object)calTask.getLong("id"));
            if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(this.writeTaskType)) {
                if (this.checkDataForHisDataImport(verifyList, periodTypeMap, (DynamicObjectType)type, calTask, obj2)) {
                    noCheckPassList.add((Object)obj2);
                    continue;
                }
                if (SWCStringUtils.isNotEmpty((String)obj2.getString("adminorgname")) && obj2.getDynamicObject("adminorg") == null) {
                    adminOrgNameSet.add(obj2.getString("adminorgname"));
                }
                if (SWCStringUtils.isEmpty((String)obj2.getString("filenumber")) && SWCStringUtils.isNotEmpty((String)obj2.getString("empgroupname"))) {
                    empGroupNameSet.add(obj2.getString("empgroupname"));
                }
            }
            if (SWCStringUtils.isEmpty((String)obj2.getString("filenumber"))) {
                passList.add(obj2);
                continue;
            }
            tempList.add(obj2);
        }
        Map<String, List<DynamicObject>> fileNumberMap = tempList.stream().collect(Collectors.groupingBy(obj -> obj.getString("filenumber")));
        for (Map.Entry<String, List<DynamicObject>> entry : fileNumberMap.entrySet()) {
            if (entry.getValue().size() > 1) {
                this.addSalaryFileRepeatErrorData(entry.getValue(), (DynamicObjectType)type, verifyList, noCheckPassList);
                continue;
            }
            passList.addAll((Collection)entry.getValue());
        }
        for (DynamicObject obj3 : noCheckPassList) {
            obj3.set("datastatus", (Object)DATASTATUS_CHECKERROR);
            obj3.set("modifytime", (Object)new Date());
            obj3.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        if (DataCheckUtils.isCancelOperate(this.verifyRecordId)) {
            logger.info("cancelOperate\uff0cimportTaskId={}", (Object)this.importTaskId);
            return;
        }
        if (!SWCListUtils.isEmpty((List)noCheckPassList)) {
            DataCheckUtils.saveDataCheckResult(verifyList, noCheckPassList, 0, noCheckPassList.size(), this.verifyRecordId);
        }
        if (passList.size() == 0) {
            return;
        }
        Map<String, Long> empGroupMap = this.getEmpGroupMap(empGroupNameSet);
        Map<String, Long> adminOrgMap = this.getAdminOrgMap(adminOrgNameSet);
        List batchPassList = SWCListUtils.split(passList, (int)500);
        DataCheckServiceTask serviceTask = null;
        for (List list : batchPassList) {
            serviceTask = new DataCheckServiceTask(RequestContext.get(), list, this.verifyRecordId, calTask, this.writeTaskType, empGroupMap, adminOrgMap);
            SWCThreadPoolFactory.getHisdataIntegrateThreadpool().submit((Callable)serviceTask);
        }
        logger.info("batchCheckData end,importTaskId={},calTaskName={}", (Object)this.importTaskId, (Object)calTaskName);
    }

    private boolean checkDataForHisDataImport(DynamicObjectCollection verifyList, Map<String, Long> periodTypeMap, DynamicObjectType type, DynamicObject calTask, DynamicObject obj) {
        if (!DATASTATUS_PREPARED.equals(obj.getString("payrollgroup.enable"))) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, "0", ImportTaskFailMsgEnum.PAYROLLGROUP_NOT_EXIST, this.verifyRecordId));
            return true;
        }
        if (calTask.getLong("payrollgroup.id") != obj.getLong("payrollgroup.id")) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, DATASTATUS_PREPARED, ImportTaskFailMsgEnum.CALTASK_AND_PAYROLLGROUP_NOT_MATCH, this.verifyRecordId));
            return true;
        }
        if (0L != obj.getLong("payrollscene.id") && !DATASTATUS_PREPARED.equals(obj.getString("payrollscene.enable"))) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, "0", ImportTaskFailMsgEnum.PAYROLLSCENCE_NOT_EXIST, this.verifyRecordId));
            return true;
        }
        if (0L != obj.getLong("payrollscene.id") && calTask.getLong("payrollscene.id") != obj.getLong("payrollscene.id")) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, DATASTATUS_PREPARED, ImportTaskFailMsgEnum.CALTASK_AND_PAYROLLSCENCE_NOT_MATCH, this.verifyRecordId));
            return true;
        }
        if (!periodTypeMap.containsKey(obj.getString("periodtypename"))) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, "0", ImportTaskFailMsgEnum.CALPERIODTYPE_NOT_EXIST, this.verifyRecordId));
            return true;
        }
        if (!SWCStringUtils.equals((String)calTask.getString("periodtype.name"), (String)obj.getString("periodtypename")) || !SWCStringUtils.equals((String)calTask.getString("period.name"), (String)obj.getString("periodname"))) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, DATASTATUS_PREPARED, ImportTaskFailMsgEnum.CALTASK_AND_CALPERIOD_NOT_MATCH, this.verifyRecordId));
            return true;
        }
        return false;
    }

    private Map<String, Long> getEmpGroupMap(Set<String> empGroupNameSet) {
        if (empGroupNameSet.size() == 0) {
            return new HashMap<String, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hbss_empgroup");
        QFilter filter = new QFilter("name", "in", empGroupNameSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)DATASTATUS_PREPARED);
        DynamicObjectCollection result = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj.getLong("id"), (key1, key2) -> key1));
    }

    private Map<String, Long> getAdminOrgMap(Set<String> adminOrgNameSet) {
        if (adminOrgNameSet.size() == 0) {
            return new HashMap<String, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("haos_adminorghr");
        QFilter filter = new QFilter("name", "in", adminOrgNameSet);
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataHisHelper.getHisCurrFilter());
        DynamicObjectCollection result = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj.getLong("id"), (key1, key2) -> key1));
    }

    private void addSalaryFileRepeatErrorData(List<DynamicObject> list, DynamicObjectType type, DynamicObjectCollection verifyList, DynamicObjectCollection noCheckPassList) {
        for (DynamicObject obj : list) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, obj, DATASTATUS_CHECKERROR, ImportTaskFailMsgEnum.SALARYFILE_HAS_EXIST, this.verifyRecordId));
            noCheckPassList.add((Object)obj);
        }
    }

    private DynamicObject[] getTemporaryList(List<Long> temporaryIdList, Long importTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        String fields = "id,datastatus,modifier,modifytime,caltaskname,caltask.id,payrollgroup,payrollscene,periodtypename,periodname,empnumber,empname,filenumber,adminorg,adminorgname,empgroup,empgroupname,workstartdate";
        QFilter filter = new QFilter("id", "in", temporaryIdList);
        filter.and(new QFilter("importtask.id", "=", (Object)importTaskId));
        filter.and("datastatus", "in", Arrays.asList(DATASTATUS_PREPARED, DATASTATUS_CHECKERROR));
        return helper.query(fields, new QFilter[]{filter});
    }

    private Map<String, List<DynamicObject>> getCalTaskMap(Set<String> nameSet, String writeTaskType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,name,payrollgroup.id,payrollscene.id,periodtype.name,period.name,period.id,startdate,enddate,tasktype";
        QFilter qFilter = new QFilter("name", "in", nameSet);
        qFilter.and("taskstatus", "!=", (Object)CalPayrollTaskStateEnum.DISUSED.getCode());
        if (WriteTaskTypeEnum.COMMON.getCode().equals(writeTaskType)) {
            qFilter.and("tasktype", "in", (Object)new String[]{"0", DATASTATUS_PREPARED});
        } else {
            qFilter.and("tasktype", "=", (Object)DATASTATUS_CHECKERROR);
        }
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        return result.stream().collect(Collectors.groupingBy(obj -> obj.getString("name")));
    }
}

