/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.helper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ImportTaskHelper {
    private static final Log logger = LogFactory.getLog(ImportTaskHelper.class);
    private static Set<String> CALED_STATUS_SET = new HashSet<String>(2);
    private static Set<String> OVER_STEP_STATUS_SET = new HashSet<String>(6);

    public static void deleteCalPerson(Set<Long> calPersonIdSet, boolean isUnWrite, Set<Long> successCalPersonIdSet, Map<Long, ImportTaskFailMsgEnum> failCalPersonMsgMap) {
        DynamicObject[] calPersons;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdSet);
        if (isUnWrite) {
            filter.and(new QFilter("iscalresult", "=", (Object)"0"));
            filter.and(new QFilter("addfiletype", "=", (Object)"2"));
        }
        if ((calPersons = helper.query("id,salarystatus,paystatus,allotstatus,calstatus,iscalresult", new QFilter[]{filter})) == null || calPersons.length == 0) {
            return;
        }
        if (isUnWrite) {
            for (DynamicObject calPerson : calPersons) {
                Long calPersonId = calPerson.getLong("id");
                String salaryStatus = calPerson.getString("salarystatus");
                String payStatus = calPerson.getString("paystatus");
                String allotStatus = calPerson.getString("allotstatus");
                if (!(!SWCStringUtils.isNotEmpty((String)salaryStatus) || SWCStringUtils.equals((String)salaryStatus, (String)"2") || SWCStringUtils.equals((String)salaryStatus, (String)"6") || "7".equals(salaryStatus) || "1".equals(salaryStatus))) {
                    failCalPersonMsgMap.put(calPersonId, ImportTaskFailMsgEnum.HAS_DEPLOY_RELEASE_SALARY_SLIP);
                    continue;
                }
                if (SWCStringUtils.isNotEmpty((String)payStatus) && !SWCStringUtils.equals((String)payStatus, (String)"0")) {
                    failCalPersonMsgMap.put(calPersonId, ImportTaskFailMsgEnum.HAS_CREATE_RELEASE_DETAIL);
                    continue;
                }
                if (SWCStringUtils.isNotEmpty((String)allotStatus) && !SWCStringUtils.equals((String)allotStatus, (String)"A")) {
                    failCalPersonMsgMap.put(calPersonId, ImportTaskFailMsgEnum.HAS_CREATE_ALLOT_DETAIL);
                    continue;
                }
                successCalPersonIdSet.add(calPersonId);
            }
        } else {
            for (DynamicObject calPerson : calPersons) {
                String calStatus = calPerson.getString("calstatus");
                Long calPersonId = calPerson.getLong("id");
                Boolean isCalResult = calPerson.getBoolean("iscalresult");
                if (SWCStringUtils.equals((String)CalStateEnum.UNCAL.getCode(), (String)calStatus)) {
                    successCalPersonIdSet.add(calPersonId);
                    continue;
                }
                if (CALED_STATUS_SET.contains(calStatus)) {
                    if (isCalResult.booleanValue()) {
                        failCalPersonMsgMap.put(calPersonId, ImportTaskFailMsgEnum.CALPERSON_NEED_UNCAL);
                        continue;
                    }
                    successCalPersonIdSet.add(calPersonId);
                    continue;
                }
                if (OVER_STEP_STATUS_SET.contains(calStatus)) {
                    failCalPersonMsgMap.put(calPersonId, ImportTaskFailMsgEnum.CALPERSON_HAS_OVER_STEP);
                    continue;
                }
                failCalPersonMsgMap.put(calPersonId, ImportTaskFailMsgEnum.CALPERSON_IS_CALLING);
            }
        }
        if (CollectionUtils.isEmpty(successCalPersonIdSet)) {
            return;
        }
        helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", successCalPersonIdSet)});
        helper.setEntityName("hsas_caltable");
        helper.deleteByFilter(new QFilter[]{new QFilter("calpersonid", "in", successCalPersonIdSet)});
    }

    public static void updateWriteInProgress(int successCount, int failCount, Long importTaskId, Long calTaskId, boolean isUnWriteIn, int changeCount, Long verifyRecordId, List<DynamicObject> verifyDetailList) {
        logger.info("start updateProgress...");
        String cacheKey = isUnWriteIn ? MessageFormat.format("dataUnWriteIn_progress_{0}", importTaskId) : MessageFormat.format("dataWriteIn_progress_{0}", importTaskId);
        try (DLock lock = DLock.create((String)cacheKey);){
            if (lock.tryLock(300000L)) {
                ISWCAppCache bgAppCache;
                String bgTaskId;
                DynamicObject calTask;
                Date date = new Date();
                ISWCAppCache appCache = SWCAppCache.get((String)cacheKey);
                Integer existSuccCount = (Integer)appCache.get("successCount", Integer.class);
                Integer existFailCount = (Integer)appCache.get("failCount", Integer.class);
                Integer totalCount = (Integer)appCache.get("totalCount", Integer.class);
                if (existSuccCount == null) {
                    existSuccCount = 0;
                }
                existSuccCount = existSuccCount + successCount;
                appCache.put("successCount", (Object)existSuccCount);
                if (existFailCount == null) {
                    existFailCount = 0;
                }
                if (totalCount == null) {
                    totalCount = 0;
                }
                existFailCount = existFailCount + failCount;
                appCache.put("failCount", (Object)existFailCount);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
                if (changeCount > 0 && (calTask = helper.queryOne("id,calpersoncount,taskstatus,tasktype", (Object)calTaskId)) != null) {
                    long calPersonCount = calTask.getLong("calpersoncount");
                    calPersonCount = isUnWriteIn ? (calPersonCount -= (long)changeCount) : (calPersonCount += (long)changeCount);
                    calTask.set("calpersoncount", (Object)calPersonCount);
                    String taskType = calTask.getString("tasktype");
                    String taskStatus = calTask.getString("taskstatus");
                    if (!SWCStringUtils.equals((String)"2", (String)taskType)) {
                        if (calPersonCount > 0L && SWCStringUtils.equals((String)taskStatus, (String)"1")) {
                            calTask.set("taskstatus", (Object)"3");
                        } else if (calPersonCount == 0L) {
                            calTask.set("taskstatus", (Object)"1");
                        }
                    }
                    helper.updateOne(calTask);
                }
                if (totalCount >= existFailCount + existSuccCount) {
                    helper.setEntityName("hsas_importtask");
                    DynamicObject importTask = helper.queryOne("id,taskstatus,modifytime,modifier", (Object)importTaskId);
                    if (importTask != null) {
                        String taskStatus = isUnWriteIn ? (existSuccCount == 0 ? (String)appCache.get("preTaskStatus", String.class) : "1") : (existFailCount == 0 ? "2" : "1");
                        importTask.set("taskstatus", (Object)taskStatus);
                        importTask.set("modifytime", (Object)date);
                        importTask.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        helper.updateOne(importTask);
                    }
                    appCache.put("isCancel", null);
                }
                helper.setEntityName("hsas_verifyrecord");
                DynamicObject verify = helper.queryOne("id,status,sucesscount,failcount,totalcount,endtime,modifytime,modifier", (Object)verifyRecordId);
                if (verify != null) {
                    if (totalCount >= existSuccCount + existFailCount) {
                        verify.set("status", (Object)"2");
                    }
                    verify.set("sucesscount", (Object)existSuccCount);
                    verify.set("failcount", (Object)existFailCount);
                    verify.set("endtime", (Object)date);
                    verify.set("modifytime", (Object)date);
                    verify.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    helper.updateOne(verify);
                }
                if (CollectionUtils.isNotEmpty(verifyDetailList)) {
                    helper.setEntityName("hsas_verifydetail");
                    helper.save(verifyDetailList.toArray(new DynamicObject[verifyDetailList.size()]));
                }
                if (SWCStringUtils.isNotEmpty((String)(bgTaskId = (String)(bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId))).get("bgTaskId", String.class))) && verify != null) {
                    int totalSize = verify.getInt("totalcount");
                    int sumCount = existSuccCount + existFailCount;
                    int progress = 0;
                    if (totalSize == sumCount) {
                        progress = 100;
                    } else {
                        progress = sumCount * 100 / totalSize;
                        if (progress == 100) {
                            progress = 99;
                        }
                    }
                    HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, progress, "", null);
                }
                logger.info(MessageFormat.format("updateProgress success:{0},fail:{1}", successCount, failCount));
            }
        }
        catch (Exception e) {
            logger.error("updateProgress error  :", (Throwable)e);
        }
    }

    public static boolean checkIsCancel(String cacheKey) {
        ISWCAppCache appCache = SWCAppCache.get((String)cacheKey);
        Boolean isCancel = (Boolean)appCache.get("isCancel", Boolean.class);
        if (isCancel == null) {
            return false;
        }
        return isCancel;
    }

    static {
        CALED_STATUS_SET.add(CalStateEnum.ALL_CALED.getCode());
        OVER_STEP_STATUS_SET.add(CalStateEnum.AUDIT.getCode());
        OVER_STEP_STATUS_SET.add(CalStateEnum.WAIT_APPROVALED.getCode());
        OVER_STEP_STATUS_SET.add(CalStateEnum.APPROVALING.getCode());
        OVER_STEP_STATUS_SET.add(CalStateEnum.APPROVALED_NOT_PASS.getCode());
        OVER_STEP_STATUS_SET.add(CalStateEnum.APPROVAL.getCode());
        OVER_STEP_STATUS_SET.add(CalStateEnum.APPROVALED.getCode());
    }
}

