/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.utils;

import java.util.Date;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataCheckUtils {
    private static final Log logger = LogFactory.getLog(DataCheckUtils.class);

    public static DynamicObject getVerifyDetailObj(DynamicObjectType type, DynamicObject temporary, String failType, ImportTaskFailMsgEnum faileTypeEnum, Long verifyRecordId) {
        DynamicObject verifyObj = (DynamicObject)type.createInstance();
        verifyObj.set("verifyrecord", (Object)verifyRecordId);
        verifyObj.set("temporarydata", (Object)temporary.getLong("id"));
        verifyObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        verifyObj.set("createtime", (Object)new Date());
        verifyObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        verifyObj.set("modifytime", (Object)new Date());
        verifyObj.set("name", (Object)temporary.getString("empname"));
        verifyObj.set("salaryfilenumber", (Object)temporary.getString("filenumber"));
        verifyObj.set("caltaskname", (Object)temporary.getString("caltaskname"));
        verifyObj.set("failtype", (Object)failType);
        verifyObj.set("failmsg", (Object)faileTypeEnum.getCode());
        verifyObj.set("errorelement", (Object)faileTypeEnum.getErrorElement());
        return verifyObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDataCheckResult(DynamicObjectCollection verifyList, DynamicObjectCollection temporaryList, int successCount, int failCount, Long verifyRecordId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        boolean isSuccess = true;
        TXHandle txHandle = TX.requiresNew();
        try {
            if (temporaryList.size() > 0) {
                helper.update((DynamicObject[])temporaryList.toArray((Object[])new DynamicObject[temporaryList.size()]));
            }
            if (verifyList.size() > 0) {
                helper.setEntityName("hsas_verifydetail");
                helper.save(verifyList);
            }
        }
        catch (Exception e) {
            isSuccess = false;
            logger.error("save error,", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            if (!isSuccess) {
                failCount = successCount + failCount;
                successCount = 0;
                DataCheckUtils.saveDataAfterException(temporaryList, verifyRecordId);
            }
            DataCheckUtils.updateDataCheckProgress(successCount, failCount, verifyRecordId);
        }
    }

    public static boolean isCancelOperate(Long verifyRecordId) {
        String key = String.format(Locale.ROOT, "dataCheck_progress_%s", verifyRecordId);
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        Boolean flag = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", verifyRecordId), Boolean.class);
        return flag != null && flag != false;
    }

    public static void saveDataAfterException(DynamicObjectCollection temporaryList, Long verifyRecordId) {
        DynamicObjectCollection verifyList = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        for (DynamicObject obj : temporaryList) {
            obj.set("datastatus", (Object)"2");
            obj.set("modifytime", (Object)new Date());
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, obj, "3", ImportTaskFailMsgEnum.UNDEFINE_EXCEPTION, verifyRecordId));
        }
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
            if (temporaryList.size() > 0) {
                helper.update((DynamicObject[])temporaryList.toArray((Object[])new DynamicObject[temporaryList.size()]));
            }
            if (verifyList.size() > 0) {
                helper.setEntityName("hsas_verifydetail");
                helper.save(verifyList);
            }
        }
        catch (Exception e) {
            logger.error("saveDataAfterException error", (Throwable)e);
        }
    }

    public static synchronized void updateDataCheckProgress(int successCount, int failCount, Long verifyRecordId) {
        String key = String.format(Locale.ROOT, "dataCheck_progress_%s", verifyRecordId);
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        Integer existSuccCount = (Integer)appCache.get("successCount", Integer.class);
        if (existSuccCount == null) {
            existSuccCount = 0;
        }
        appCache.put("successCount", (Object)(existSuccCount + successCount));
        Integer existFailCount = (Integer)appCache.get("failCount", Integer.class);
        if (existFailCount == null) {
            existFailCount = 0;
        }
        appCache.put("failCount", (Object)(existFailCount + failCount));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
        DynamicObject verify = helper.queryOne((Object)verifyRecordId);
        int totalCount = verify.getInt("totalcount");
        boolean isFinish = false;
        int sumCount = (successCount += verify.getInt("sucesscount")) + (failCount += verify.getInt("failcount"));
        if (totalCount == sumCount) {
            verify.set("status", (Object)"2");
            isFinish = true;
        }
        verify.set("sucesscount", (Object)successCount);
        verify.set("failcount", (Object)failCount);
        verify.set("endtime", (Object)new Date());
        verify.set("modifytime", (Object)new Date());
        verify.set("modifier", (Object)RequestContext.get().getCurrUserId());
        helper.updateOne(verify);
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId));
        String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
        if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
            int progress = 0;
            if (isFinish) {
                progress = 100;
            } else {
                progress = sumCount * 100 / totalCount;
                if (progress == 100) {
                    progress = 99;
                }
            }
            HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, progress, "", null);
        }
        if (isFinish) {
            DataCheckUtils.updateImportTaskStatus(verify.getLong("importtask.id"), "1");
        }
    }

    public static void updateImportTaskStatus(Long importTaskId, String taskStatus) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject task = taskHelper.queryOne((Object)importTaskId);
        task.set("taskstatus", (Object)taskStatus);
        task.set("modifytime", (Object)new Date());
        task.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskHelper.updateOne(task);
    }
}

