/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.writein;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hscs.business.hisdata.writein.ImportTaskUnWriteInAsyncTask;
import org.apache.commons.collections.CollectionUtils;

public class ImportTaskUnWriteInService {
    private static final Log logger = LogFactory.getLog(ImportTaskUnWriteInService.class);
    private static final int BATCH_SIZE = 500;
    private static String UNWRITE_PARAM_CALTASK = "unwrite_param_caltask_{0}";
    private static String UNWRITE_PARAM_TEMPORARY_BATCH = "unwrite_param_temporary_batch_{0}_{1}";
    private static String UNWRITE_PARAM_TEMPORARYID = "unwrite_param_temporaryid_{0}_{1}";

    public void unWriteIn(Long importTaskId, Long verifyRecordId) {
        HashSet calTaskIdSet;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        ISWCAppCache appCache = SWCAppCache.get((String)MessageFormat.format("dataUnWriteIn_progress_{0}", importTaskId));
        String calTaskIdSetStr = (String)appCache.get(MessageFormat.format(UNWRITE_PARAM_CALTASK, String.valueOf(verifyRecordId)), String.class);
        try {
            calTaskIdSet = (HashSet)JSONUtils.cast((String)calTaskIdSetStr, Set.class);
        }
        catch (Exception exception) {
            logger.error("\u53cd\u5199\u65f6\u6838\u7b97\u4efb\u52a1ID\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
            calTaskIdSet = new HashSet(0);
        }
        for (Long calTaskId : calTaskIdSet) {
            List batchIndexList;
            String batchIndexListStr = (String)appCache.get(MessageFormat.format(UNWRITE_PARAM_TEMPORARY_BATCH, String.valueOf(verifyRecordId), String.valueOf(calTaskId)), String.class);
            try {
                batchIndexList = (List)JSONUtils.cast((String)batchIndexListStr, List.class);
            }
            catch (Exception exception) {
                logger.error("\u53cd\u5199\u65f6\u6279\u6b21\u53f7\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
                continue;
            }
            Iterator iterator = batchIndexList.iterator();
            while (iterator.hasNext()) {
                List temporaryIdList;
                int batchIndex = (Integer)iterator.next();
                String temporaryIdListStr = (String)appCache.get(MessageFormat.format(UNWRITE_PARAM_TEMPORARYID, String.valueOf(verifyRecordId), String.valueOf(batchIndex)), String.class);
                try {
                    temporaryIdList = (List)JSONUtils.cast((String)temporaryIdListStr, List.class);
                }
                catch (Exception exception) {
                    logger.error("\u53cd\u5199\u65f6\u4e2d\u95f4\u8868\u6570\u636eID\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)temporaryIdList)) continue;
                QFilter filter = new QFilter("importtask.id", "=", (Object)importTaskId);
                filter.and(new QFilter("datastatus", "=", (Object)"5"));
                filter.and(new QFilter("id", "in", (Object)temporaryIdList));
                DynamicObject[] temporaryDatas = helper.query("id,caltask.id,calpersonid,datastatus,empname,filenumber,caltaskname", new QFilter[]{filter});
                List<DynamicObject> temporaryDataList = Arrays.asList(temporaryDatas);
                int size = temporaryDatas.length;
                int batchCount = size / 500 + 1;
                CountDownLatch countDownLatch = new CountDownLatch(batchCount);
                for (int index = 0; index < batchCount; ++index) {
                    int startIndex = index * 500;
                    int endIndex = startIndex + 500;
                    if (endIndex > size) {
                        endIndex = size;
                    }
                    List<DynamicObject> partTemporaryDataList = temporaryDataList.subList(startIndex, endIndex);
                    SWCThreadPoolFactory.getHisdataIntegrateThreadpool().execute((Runnable)new ImportTaskUnWriteInAsyncTask(importTaskId, partTemporaryDataList, calTaskId, verifyRecordId, countDownLatch));
                }
                try {
                    countDownLatch.await();
                }
                catch (Exception exception) {
                    logger.error("\u53cd\u5199\u7b49\u5f85\u5b50\u7ebf\u7a0b\u8ba1\u6570\u5931\u8d25", (Throwable)exception);
                }
            }
        }
    }
}

