/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.writein;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.MigrationFailTypeEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.addperson.service.CalAddPersonService;
import kd.swc.hscs.business.hisdata.helper.ImportTaskHelper;
import kd.swc.hscs.business.hisdata.utils.DataCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class ImportTaskWriteInAsyncTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ImportTaskWriteInAsyncTask.class);
    private Long calPayRollTaskId;
    private DynamicObject calPayRollTask;
    private boolean isPublishSalSlip = true;
    private Long importTaskId;
    private List<DynamicObject> temporaryDataList;
    private Long verifyRecordId;
    private String taskType;
    private Date startDate;
    private Date endDate;
    private Map<Long, ImportTaskFailMsgEnum> failMsgEnumMap;
    private Set<DynamicObject> withoutFileTemporaryDataSet;
    private Map<Long, DynamicObject> withoutFileCalPersonMap;
    List<DynamicObject> verifyDetailList;
    private Map<String, Integer> result;
    CountDownLatch countDownLatch;
    private Map<Long, String> bizItemTypeMap;

    public ImportTaskWriteInAsyncTask(Long importTaskId, List<DynamicObject> temporaryDataList, Long calPayRollTaskId, Long verifyRecordId, Map<Long, ImportTaskFailMsgEnum> failMsgEnumMap, CountDownLatch countDownLatch, Map<Long, String> bizItemTypeMap) {
        this.importTaskId = importTaskId;
        this.temporaryDataList = temporaryDataList;
        this.calPayRollTaskId = calPayRollTaskId;
        this.verifyRecordId = verifyRecordId;
        this.countDownLatch = countDownLatch;
        this.failMsgEnumMap = failMsgEnumMap;
        this.result = new HashMap<String, Integer>(3);
        this.result.put("successCount", 0);
        this.result.put("failCount", 0);
        this.result.put("changeCount", 0);
        this.verifyDetailList = new ArrayList<DynamicObject>(10);
        this.withoutFileTemporaryDataSet = new HashSet<DynamicObject>(temporaryDataList.size());
        for (DynamicObject temporaryData : temporaryDataList) {
            String salaryFileNumber = temporaryData.getString("filenumber");
            if (!SWCStringUtils.isEmpty((String)salaryFileNumber)) continue;
            this.withoutFileTemporaryDataSet.add(temporaryData);
        }
        this.withoutFileCalPersonMap = new HashMap<Long, DynamicObject>(this.withoutFileTemporaryDataSet.size());
        this.bizItemTypeMap = bizItemTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        ImportTaskWriteInAsyncTask.logger.info("start writeInTask");
        if (ImportTaskHelper.checkIsCancel(MessageFormat.format("dataWriteIn_progress_{0}", new Object[]{this.importTaskId}))) {
            this.countDownLatch.countDown();
            ImportTaskWriteInAsyncTask.logger.info("cancel writeInTask");
            return;
        }
        this.queryCalPayRolltask();
        type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        isAllFail = false;
        if (this.calPayRollTask == null) {
            isAllFail = true;
            for (DynamicObject temporaryData : this.temporaryDataList) {
                this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_IS_EXIST.getCode(), ImportTaskFailMsgEnum.CALTASK_NOT_EXIST, this.verifyRecordId));
            }
            this.result.put("failCount", this.temporaryDataList.size());
        }
        size = this.temporaryDataList.size();
        calPersonIdSet = new HashSet<Long>(size);
        salaryFileNumberSet = new HashSet<String>(this.temporaryDataList.size());
        if (!isAllFail) {
            for (DynamicObject temporaryData : this.temporaryDataList) {
                if (this.failMsgEnumMap.containsKey(temporaryData.getLong("id"))) continue;
                calPersonId = temporaryData.getLong("calpersonid");
                if (calPersonId != null && calPersonId != 0L) {
                    calPersonIdSet.add(calPersonId);
                }
                if (this.withoutFileTemporaryDataSet.contains(temporaryData)) continue;
                salaryFileNumberSet.add(temporaryData.getString("filenumber"));
            }
        }
        hasRollBack = false;
        required = null;
        try {
            if (!isAllFail) {
                if (CollectionUtils.isNotEmpty(salaryFileNumberSet)) {
                    salaryFileNumberSet.removeAll(this.getExistSalaryFile());
                }
                this.isPublishSalSlip = PayrollTaskHelper.isPublishPaySlip((DynamicObject)this.calPayRollTask);
                salaryFileVidMap = this.getSalaryFileVidList(salaryFileNumberSet);
                salaryFileVidList = new ArrayList<Long>(salaryFileVidMap.values());
                calPersons = new CalAddPersonService(this.calPayRollTask, salaryFileVidList, new HashMap<Long, String>(0), this.isPublishSalSlip).createWriteInCalPersonList();
                this.createCalPersonWithoutSalaryFile();
                calTableIds = this.setCalPersonParamAndGetCalTableIds((List<DynamicObject>)calPersons);
                required = TX.required();
                this.handleWriteIn(calPersonIdSet, salaryFileVidMap, calPersons, calTableIds);
            }
            ** if (required == null) goto lbl-1000
        }
        catch (Exception exception) {
            try {
                ImportTaskWriteInAsyncTask.logger.error("\u5199\u5165\u5931\u8d25\uff1a", (Throwable)exception);
                if (required != null) {
                    required.markRollback();
                }
                hasRollBack = true;
                this.result.put("failCount", size);
                this.replenishUnKnownErrorDetail();
                ** if (required == null) goto lbl-1000
            }
            catch (Throwable var12_15) {
                if (required != null) {
                    if (!hasRollBack && ImportTaskHelper.checkIsCancel(MessageFormat.format("dataWriteIn_progress_{0}", new Object[]{this.importTaskId}))) {
                        required.markRollback();
                    }
                    required.close();
                }
                throw var12_15;
            }
lbl-1000:
            // 1 sources

            {
                if (!hasRollBack && ImportTaskHelper.checkIsCancel(MessageFormat.format("dataWriteIn_progress_{0}", new Object[]{this.importTaskId}))) {
                    required.markRollback();
                }
                required.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            if (!hasRollBack && ImportTaskHelper.checkIsCancel(MessageFormat.format("dataWriteIn_progress_{0}", new Object[]{this.importTaskId}))) {
                required.markRollback();
            }
            required.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        if (!hasRollBack) {
            ImportTaskHelper.updateWriteInProgress(this.result.get("successCount"), this.result.get("failCount"), this.importTaskId, this.calPayRollTaskId, false, this.result.get("changeCount"), this.verifyRecordId, this.verifyDetailList);
        } else {
            ImportTaskHelper.updateWriteInProgress(0, this.temporaryDataList.size(), this.importTaskId, this.calPayRollTaskId, false, 0, this.verifyRecordId, this.verifyDetailList);
        }
        this.countDownLatch.countDown();
        ImportTaskWriteInAsyncTask.logger.info("end writeInTask");
    }

    private void replenishUnKnownErrorDetail() {
        Set errorTemporaryDataIdSet = this.verifyDetailList.stream().map(verifyDetail -> verifyDetail.getLong("temporarydata")).collect(Collectors.toSet());
        MainEntityType verifyType = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        for (DynamicObject temporaryData : this.temporaryDataList) {
            Long temporaryDataId = temporaryData.getLong("id");
            if (!errorTemporaryDataIdSet.add(temporaryDataId)) continue;
            this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)verifyType, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_NULL.getCode(), ImportTaskFailMsgEnum.UNDEFINE_EXCEPTION, this.verifyRecordId));
        }
    }

    private Set<String> getExistSalaryFile() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        DynamicObject[] calPersons = helper.query("salaryfile.number", new QFilter[]{new QFilter("caltask.id", "=", (Object)this.calPayRollTaskId)});
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        return Arrays.stream(calPersons).map(calPerson -> calPerson.getString("salaryfile.number")).collect(Collectors.toSet());
    }

    private Map<String, Long> getSalaryFileVidList(Set<String> salaryFileNumberSet) {
        Map<String, Long> salaryFileVidMap;
        if (CollectionUtils.isEmpty(salaryFileNumberSet)) {
            return new HashMap<String, Long>(0);
        }
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        if (!SWCStringUtils.equals((String)"2", (String)this.taskType)) {
            List effectiveFileIdList = CalPersonHelper.getCouldAddPersonList((Long)this.calPayRollTask.getLong("id"));
            QFilter filter = new QFilter("id", "in", (Object)effectiveFileIdList);
            filter.and(new QFilter("number", "in", salaryFileNumberSet));
            filter.and(new QFilter("salaryfile.status", "=", (Object)"C"));
            DynamicObjectCollection salaryFiles = salaryFileHelper.queryOriginalCollection("id,number", new QFilter[]{filter});
            salaryFileVidMap = salaryFiles.stream().collect(Collectors.toMap(salaryFile -> salaryFile.getString("number"), salaryFile -> salaryFile.getLong("id")));
        } else {
            QFilter filter = new QFilter("number", "in", salaryFileNumberSet);
            filter.and(new QFilter("paystatus", "=", (Object)"1"));
            filter.and(new QFilter("bsed", "<=", (Object)this.endDate));
            filter.and(new QFilter("bsled", ">=", (Object)this.startDate));
            filter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
            filter.and(new QFilter("salaryfile.status", "=", (Object)"C"));
            BaseDataHisHelper.addHisVerFilter((QFilter)filter);
            DynamicObjectCollection salaryFiles = salaryFileHelper.queryOriginalCollection("id,number", new QFilter[]{filter}, "bsed desc");
            logger.info("salaryFiles size:{}", (Object)salaryFiles.size());
            HashSet<String> existNumberSet = new HashSet<String>(salaryFileNumberSet.size());
            ArrayList<DynamicObject> salaryFileList = new ArrayList<DynamicObject>(salaryFileNumberSet.size());
            for (DynamicObject salaryFile2 : salaryFiles) {
                if (existNumberSet.contains(salaryFile2.getString("number"))) continue;
                salaryFileList.add(salaryFile2);
                existNumberSet.add(salaryFile2.getString("number"));
            }
            salaryFileVidMap = salaryFileList.stream().collect(Collectors.toMap(salaryFile -> salaryFile.getString("number"), salaryFile -> salaryFile.getLong("id")));
        }
        logger.info("salaryFileVidMap size : {}", (Object)salaryFileVidMap.size());
        return salaryFileVidMap;
    }

    private void handleWriteIn(Set<Long> calPersonIdSet, Map<String, Long> salaryFileVidMap, DynamicObjectCollection calPersons, long[] calTableIds) {
        HashSet<Long> successCalPersonIdSet = new HashSet<Long>(this.temporaryDataList.size());
        HashMap<Long, ImportTaskFailMsgEnum> failCalPersonMsgMap = new HashMap<Long, ImportTaskFailMsgEnum>(this.temporaryDataList.size());
        ImportTaskHelper.deleteCalPerson(calPersonIdSet, false, successCalPersonIdSet, failCalPersonMsgMap);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        Map<Long, DynamicObject> calPersonMap = calPersons.stream().collect(Collectors.toMap(calPerson -> calPerson.getLong("salaryfilev.id"), calPerson -> calPerson));
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_caltable");
        DynamicObjectCollection calTables = new DynamicObjectCollection();
        ArrayList<DynamicObject> calPersonList = new ArrayList<DynamicObject>(calPersons.size());
        this.checkAndCreateCalTable(failCalPersonMsgMap, salaryFileVidMap, calPersonMap, calPersonList, calTableIds, calTables, successCalPersonIdSet.size());
        if (CollectionUtils.isNotEmpty(calPersonList)) {
            DynamicObject[] saveCalPersons = new DynamicObject[calPersonList.size()];
            saveCalPersons = calPersonList.toArray(saveCalPersons);
            calPersonHelper.save(saveCalPersons);
        }
        if (CollectionUtils.isNotEmpty((Collection)calTables)) {
            calTableHelper.save(calTables);
        }
        this.saveTemporaryData();
    }

    private void checkAndCreateCalTable(Map<Long, ImportTaskFailMsgEnum> failCalPersonMsgMap, Map<String, Long> salaryFileVidMap, Map<Long, DynamicObject> calPersonMap, List<DynamicObject> calPersonList, long[] calTableIds, DynamicObjectCollection calTables, int successDeleteCalPersonCount) {
        int successCount = 0;
        int failCount = 0;
        int calTableIdIndex = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        MainEntityType verifyType = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        MainEntityType calTableType = EntityMetadataCache.getDataEntityType((String)"hsas_caltable");
        DynamicObjectType calTableEntryType = (DynamicObjectType)calTableType.getAllEntities().get("hsas_caltableentry");
        DynamicObjectType calTableBCEntryType = (DynamicObjectType)calTableType.getAllEntities().get("hsas_calbcentry");
        DynamicObjectType calTableSPEntryType = (DynamicObjectType)calTableType.getAllEntities().get("hsas_calspentry");
        DynamicObjectType calTableBSEntryType = (DynamicObjectType)calTableType.getAllEntities().get("hsas_calbsentry");
        for (DynamicObject temporaryData : this.temporaryDataList) {
            DynamicObject newCalPerson;
            String salaryFileNumber = temporaryData.getString("filenumber");
            Long temporaryDataId = temporaryData.getLong("id");
            if (SWCStringUtils.equals((String)"2", (String)this.taskType) && SWCStringUtils.isEmpty((String)salaryFileNumber)) {
                newCalPerson = this.withoutFileCalPersonMap.get(temporaryDataId);
                if (newCalPerson == null) {
                    ++failCount;
                    continue;
                }
                newCalPerson.set("adminorg", (Object)temporaryData.getLong("adminorg.id"));
                newCalPerson.set("empgroup", (Object)temporaryData.getLong("empgroup.id"));
            } else {
                ImportTaskFailMsgEnum msgEnum = this.failMsgEnumMap.get(temporaryDataId);
                if (msgEnum != null) {
                    this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)verifyType, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_REPEAT.getCode(), msgEnum, this.verifyRecordId));
                    logger.info("\u4e2d\u95f4\u8868{}\u9884\u6821\u9a8c\u5931\u8d25", (Object)temporaryDataId);
                    ++failCount;
                    continue;
                }
                Long oldCalPersonId = temporaryData.getLong("calpersonid");
                msgEnum = failCalPersonMsgMap.get(oldCalPersonId);
                if (msgEnum != null) {
                    this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)verifyType, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_IS_EXIST.getCode(), msgEnum, this.verifyRecordId));
                    logger.info("\u6838\u7b97\u540d\u5355\u5220\u9664{}\u5931\u8d25", (Object)oldCalPersonId);
                    ++failCount;
                    continue;
                }
                Long salaryFileId = salaryFileVidMap.get(salaryFileNumber);
                if (salaryFileId == null || salaryFileId == 0L) {
                    this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)verifyType, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_IS_EXIST.getCode(), ImportTaskFailMsgEnum.SALARYFILE_NOT_EXIST, this.verifyRecordId));
                    ++failCount;
                    logger.error("\u6863\u6848\u7f16\u7801{}\u4e0d\u5b58\u5728\u6709\u6548\u7248\u672c\u7684\u6863\u6848", (Object)salaryFileNumber);
                    continue;
                }
                newCalPerson = calPersonMap.get(salaryFileId);
                calPersonMap.put(salaryFileId, null);
            }
            if (newCalPerson == null) {
                this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)verifyType, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_NULL.getCode(), ImportTaskFailMsgEnum.UNDEFINE_EXCEPTION, this.verifyRecordId));
                ++failCount;
                logger.info("\u4e2d\u95f4\u8868{}\u521b\u5efa\u6838\u7b97\u540d\u5355\u5931\u8d25", (Object)temporaryDataId);
                continue;
            }
            calPersonList.add(newCalPerson);
            Long newCalPersonId = newCalPerson.getLong("id");
            temporaryData.set("calpersonid", (Object)newCalPersonId);
            DynamicObjectCollection itemEntry = temporaryData.getDynamicObjectCollection("itementry");
            DynamicObject newCalTable = (DynamicObject)calTableType.createInstance();
            newCalTable.set("id", (Object)calTableIds[calTableIdIndex]);
            newCalPerson.set("calresultid", (Object)calTableIds[calTableIdIndex]);
            ++calTableIdIndex;
            newCalTable.set("calpersonid", (Object)newCalPersonId);
            newCalTable.set("org", (Object)newCalPerson.getLong("org"));
            newCalTable.set("belongperiod", (Object)newCalPerson.getDate("belongperiod"));
            newCalTable.set("caltask", (Object)newCalPerson.getLong("caltask"));
            newCalTable.set("calperiod", (Object)newCalPerson.getLong("calperiod"));
            newCalTable.set("modifytime", (Object)newCalPerson.getDate("modifytime"));
            DynamicObjectCollection sLEntry = new DynamicObjectCollection();
            DynamicObjectCollection fTEntry = new DynamicObjectCollection();
            DynamicObjectCollection sPEntry = new DynamicObjectCollection();
            DynamicObjectCollection bSEntry = new DynamicObjectCollection();
            newCalTable.set("hsas_caltableentry", (Object)sLEntry);
            newCalTable.set("hsas_calbcentry", (Object)fTEntry);
            newCalTable.set("hsas_calspentry", (Object)sPEntry);
            newCalTable.set("hsas_calbsentry", (Object)bSEntry);
            for (DynamicObject entry : itemEntry) {
                DynamicObject newEntry;
                DynamicObjectCollection targetEntry;
                String itemType = entry.getString("itemtype");
                Long dataTypeId = entry.getLong("datatype.id");
                String itemValueStr = entry.getString("itemvalue");
                Long itemId = entry.getLong("itemid");
                if (SWCStringUtils.equals((String)itemType, (String)"1")) {
                    targetEntry = sLEntry;
                    newEntry = this.createNewEntry(itemId, dataTypeId, itemValueStr, itemType, simpleDateFormat, (DynamicObject)calTableEntryType.createInstance());
                } else if (SWCStringUtils.equals((String)itemType, (String)"4")) {
                    targetEntry = fTEntry;
                    newEntry = this.createNewEntry(itemId, dataTypeId, itemValueStr, itemType, simpleDateFormat, (DynamicObject)calTableBCEntryType.createInstance());
                } else if (SWCStringUtils.equals((String)itemType, (String)"2")) {
                    targetEntry = sPEntry;
                    newEntry = this.createNewEntry(itemId, dataTypeId, itemValueStr, itemType, simpleDateFormat, (DynamicObject)calTableSPEntryType.createInstance());
                } else {
                    if (!SWCStringUtils.equals((String)itemType, (String)"3")) continue;
                    targetEntry = bSEntry;
                    newEntry = this.createNewEntry(itemId, dataTypeId, itemValueStr, itemType, simpleDateFormat, (DynamicObject)calTableBSEntryType.createInstance());
                }
                if (newEntry == null) continue;
                newEntry.set("seq", (Object)targetEntry.size());
                targetEntry.add((Object)newEntry);
            }
            ++successCount;
            calTables.add((Object)newCalTable);
            temporaryData.set("datastatus", (Object)"5");
        }
        this.result.put("successCount", successCount);
        this.result.put("failCount", failCount);
        this.result.put("changeCount", successCount - successDeleteCalPersonCount);
    }

    private long[] setCalPersonParamAndGetCalTableIds(List<DynamicObject> calPersons) {
        long[] calTableIds;
        ArrayList<DynamicObject> calPersonList = new ArrayList<DynamicObject>(calPersons.size() + this.withoutFileCalPersonMap.size());
        calPersonList.addAll(calPersons);
        if (this.withoutFileCalPersonMap.size() > 0) {
            calPersonList.addAll(this.withoutFileCalPersonMap.values());
        }
        if (CollectionUtils.isNotEmpty(calPersonList)) {
            long[] calPersonIds = ORM.create().genLongIds("hsas_calperson", calPersonList.size());
            calTableIds = ORM.create().genLongIds("hsas_caltable", calPersonList.size());
            int index = 0;
            for (DynamicObject calPerson : calPersonList) {
                String calStatus = SWCStringUtils.equals((String)this.taskType, (String)"2") ? CalStateEnum.APPROVAL.getCode() : CalStateEnum.ALL_CALED.getCode();
                calPerson.set("calstatus", (Object)calStatus);
                calPerson.set("taxstatus", (Object)TaxStateEnum.PULLED.getCode());
                this.setSalaryStatus(calPerson);
                calPerson.set("paystatus", (Object)"0");
                calPerson.set("allotstatus", (Object)"A");
                calPerson.set("id", (Object)calPersonIds[index]);
                calPerson.set("iscalresult", (Object)"0");
                calPerson.set("addfiletype", (Object)"2");
                ++index;
            }
        } else {
            calTableIds = new long[]{};
        }
        return calTableIds;
    }

    private DynamicObject createNewEntry(Long itemId, Long dataTypeId, String itemValueStr, String itemType, SimpleDateFormat simpleDateFormat, DynamicObject newEntry) {
        Object itemValue;
        if (itemValueStr == null) {
            return null;
        }
        if (dataTypeId.longValue() == DataTypeEnum.NUMBERIC.getDbId()) {
            itemValue = new BigDecimal(itemValueStr);
        } else if (dataTypeId.longValue() == DataTypeEnum.AMOUNT.getDbId()) {
            itemValue = new BigDecimal(itemValueStr);
        } else if (dataTypeId.longValue() == DataTypeEnum.STRING.getDbId()) {
            itemValue = itemValueStr;
        } else if (dataTypeId.longValue() == DataTypeEnum.DATE.getDbId()) {
            try {
                itemValue = simpleDateFormat.parse(itemValueStr);
            }
            catch (Exception exception) {
                logger.error("\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff1a", (Throwable)exception);
                itemValue = null;
            }
        } else {
            return null;
        }
        String itemValueKey = this.getItemValueKey(dataTypeId, itemType);
        newEntry.set(itemValueKey, itemValue);
        if (SWCStringUtils.equals((String)itemType, (String)"1")) {
            newEntry.set("salaryitem", (Object)itemId);
        } else if (SWCStringUtils.equals((String)itemType, (String)"4")) {
            newEntry.set("fetchitem", (Object)itemId);
            newEntry.set("bcstartdate", (Object)this.startDate);
            newEntry.set("bcenddate", (Object)this.endDate);
        } else if (SWCStringUtils.equals((String)itemType, (String)"2")) {
            newEntry.set("supportitem", (Object)itemId);
            newEntry.set("spstartdate", (Object)this.startDate);
            newEntry.set("spenddate", (Object)this.endDate);
        } else if (SWCStringUtils.equals((String)itemType, (String)"3")) {
            newEntry.set("bizitem", (Object)itemId);
            newEntry.set("bsstartdate", (Object)this.startDate);
            newEntry.set("bsenddate", (Object)this.endDate);
            newEntry.set("bizitemtype", (Object)this.bizItemTypeMap.get(itemId));
        } else {
            return null;
        }
        return newEntry;
    }

    private String getItemValueKey(Long dataTypeId, String itemType) {
        String itemValueKey = null;
        if (SWCStringUtils.equals((String)itemType, (String)"1")) {
            if (dataTypeId.longValue() == DataTypeEnum.NUMBERIC.getDbId()) {
                itemValueKey = "numvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.AMOUNT.getDbId()) {
                itemValueKey = "calamountvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.STRING.getDbId()) {
                itemValueKey = "textvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.DATE.getDbId()) {
                itemValueKey = "datevalue";
            }
        } else if (SWCStringUtils.equals((String)itemType, (String)"4")) {
            if (dataTypeId.longValue() == DataTypeEnum.NUMBERIC.getDbId()) {
                itemValueKey = "bcnumvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.STRING.getDbId()) {
                itemValueKey = "bctextvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.DATE.getDbId()) {
                itemValueKey = "bcdatevalue";
            }
        } else if (SWCStringUtils.equals((String)itemType, (String)"2")) {
            if (dataTypeId.longValue() == DataTypeEnum.NUMBERIC.getDbId()) {
                itemValueKey = "spnumvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.STRING.getDbId()) {
                itemValueKey = "sptextvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.DATE.getDbId()) {
                itemValueKey = "spdatevalue";
            }
        } else if (SWCStringUtils.equals((String)itemType, (String)"3")) {
            if (dataTypeId.longValue() == DataTypeEnum.NUMBERIC.getDbId()) {
                itemValueKey = "bsnumvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.AMOUNT.getDbId()) {
                itemValueKey = "bscalamountvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.STRING.getDbId()) {
                itemValueKey = "bstextvalue";
            } else if (dataTypeId.longValue() == DataTypeEnum.DATE.getDbId()) {
                itemValueKey = "bsdatevalue";
            }
        }
        return itemValueKey;
    }

    private void queryCalPayRolltask() {
        DynamicObject calPayrollTask;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        this.calPayRollTask = calPayrollTask = helper.queryOriginalOne("id,startdate,enddate,calrulev.id,calrulev.opentaxcal,payrolldate,period,period.id,period.name,period.startdate,period.enddate,paydate,exratedate,calfrequency.id,calcount,payrollgroup.id,payrollgroupv.id,payrollgroupv.islssuepayslip,ishandleproration,payrollscene.id,payrollscenev.id,tasktype", new QFilter[]{new QFilter("id", "=", (Object)this.calPayRollTaskId)});
        if (calPayrollTask != null) {
            this.taskType = calPayrollTask.getString("tasktype");
            this.startDate = this.calPayRollTask.getDate("startdate");
            this.endDate = this.calPayRollTask.getDate("enddate");
        }
    }

    private void saveTemporaryData() {
        SWCDataServiceHelper temporaryDataHelper = new SWCDataServiceHelper("hsas_temporarydata");
        DynamicObject[] temporaryDatas = new DynamicObject[this.temporaryDataList.size()];
        temporaryDatas = this.temporaryDataList.toArray(temporaryDatas);
        temporaryDataHelper.save(temporaryDatas);
    }

    private void createCalPersonWithoutSalaryFile() {
        if (CollectionUtils.isEmpty(this.withoutFileTemporaryDataSet)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calperson");
        List<String> empNumberList = this.withoutFileTemporaryDataSet.stream().map(temporaryData -> temporaryData.getString("empnumber")).collect(Collectors.toList());
        Date payrolldate = this.calPayRollTask.getDate("payrolldate");
        Long calPeriodId = this.calPayRollTask.getLong("period.id");
        ArrayList<DynamicObject> checkPassDataList = new ArrayList<DynamicObject>(this.withoutFileTemporaryDataSet.size());
        Map<String, DynamicObject> employeeMap = this.checkAndgetEmpoyeeVersionDataMap(empNumberList, checkPassDataList);
        ArrayList<Long> personHrIdList = new ArrayList<Long>(employeeMap.size());
        ArrayList<Long> employeeIdList = new ArrayList<Long>(employeeMap.size());
        for (DynamicObject employee : employeeMap.values()) {
            personHrIdList.add(employee.getLong("person.id"));
            employeeIdList.add(employee.getLong("boid"));
        }
        Map<Long, Long> pernontspropMap = this.getPernontsprop(personHrIdList);
        Map<Long, Long> pertspropMap = this.getPertsprop(personHrIdList);
        Map<Long, Long> empentrelMap = this.getEmpentrel(employeeIdList);
        Map<Long, Long> perserlenMap = this.getPerserlen(employeeIdList);
        Map<Long, Long> trialperiodMap = this.getTrialperiod(employeeIdList);
        for (DynamicObject temporaryData2 : checkPassDataList) {
            DynamicObject newCalPerson = (DynamicObject)type.createInstance();
            newCalPerson.set("org", (Object)temporaryData2.getLong("payrollgroup.org.id"));
            newCalPerson.set("onholdstatus", (Object)" ");
            String empNumber = temporaryData2.getString("empnumber");
            DynamicObject employee = employeeMap.get(empNumber);
            if (employee != null) {
                Long personId = employee.getLong("person.id");
                Long employeeVId = employee.getLong("id");
                Long employeeId = employee.getLong("boid");
                newCalPerson.set("empnumber", (Object)employee.getString("empnumber"));
                newCalPerson.set("employeev", (Object)employeeVId);
                newCalPerson.set("employee", (Object)employeeId);
                newCalPerson.set("name", (Object)employee.getString("person.name"));
                newCalPerson.set("personhrv", (Object)personId);
                newCalPerson.set("caltask", (Object)this.calPayRollTaskId);
                newCalPerson.set("belongperiod", (Object)payrolldate);
                newCalPerson.set("calperiod", (Object)calPeriodId);
                newCalPerson.set("pernontspropv", (Object)pernontspropMap.get(personId));
                newCalPerson.set("pertspropv", (Object)pertspropMap.get(personId));
                newCalPerson.set("empentrelv", (Object)empentrelMap.get(employeeId));
                newCalPerson.set("perserlenv", (Object)perserlenMap.get(employeeId));
                newCalPerson.set("trialperiodv", (Object)trialperiodMap.get(employeeId));
                newCalPerson.set("paystatus", (Object)PayStateEnum.UNCREATE.getCode());
                newCalPerson.set("allotstatus", (Object)"A");
                newCalPerson.set("salarystatus", (Object)"1");
                this.setSalaryStatus(newCalPerson);
                this.withoutFileCalPersonMap.put(temporaryData2.getLong("id"), newCalPerson);
                continue;
            }
            this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail"), temporaryData2, MigrationFailTypeEnum.FAIL_TYPE_IS_EXIST.getCode(), ImportTaskFailMsgEnum.CAPPERIOD_NOT_EFFECTIVE_EMPLOYEEVERSION, this.verifyRecordId));
        }
    }

    public Map<Long, Long> getPerserlen(List<Long> employeeIdList) {
        if (CollectionUtils.isEmpty(employeeIdList)) {
            return new HashMap<Long, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_perserlen");
        QFilter qFilter = new QFilter("employee", "in", employeeIdList);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        String selectProperties = "id,employee.id,sourcevid";
        DynamicObjectCollection perserlens = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        HashMap<Long, Long> perserlenMap = new HashMap<Long, Long>(perserlens.size());
        for (DynamicObject perserlen : perserlens) {
            perserlenMap.put(perserlen.getLong("employee.id"), perserlen.getLong("sourcevid"));
        }
        return perserlenMap;
    }

    public Map<Long, Long> getTrialperiod(List<Long> employeeIdList) {
        if (CollectionUtils.isEmpty(employeeIdList)) {
            return new HashMap<Long, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_trialperiod");
        QFilter qFilter = new QFilter("employee", "in", employeeIdList);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = ImportTaskWriteInAsyncTask.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,employee.id,bsed";
        DynamicObjectCollection trialperiods = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, statusFilter, dateFilter}, "bsed desc");
        HashMap<Long, Long> trialperiodMap = new HashMap<Long, Long>(trialperiods.size());
        for (DynamicObject trialperiod : trialperiods) {
            Long employeeId = trialperiod.getLong("employee.id");
            if (trialperiodMap.containsKey(employeeId)) continue;
            trialperiodMap.put(employeeId, trialperiod.getLong("id"));
        }
        return trialperiodMap;
    }

    public Map<Long, Long> getEmpentrel(List<Long> employeeIdList) {
        if (CollectionUtils.isEmpty(employeeIdList)) {
            return new HashMap<Long, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empentrel");
        QFilter qFilter = new QFilter("employee", "in", employeeIdList);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = ImportTaskWriteInAsyncTask.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,employee.id,bsed";
        DynamicObjectCollection empentrels = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "bsed desc");
        HashMap<Long, Long> empentrelMap = new HashMap<Long, Long>(empentrels.size());
        for (DynamicObject empentrel : empentrels) {
            Long employeeId = empentrel.getLong("employee.id");
            if (empentrelMap.containsKey(employeeId)) continue;
            empentrelMap.put(employeeId, empentrel.getLong("id"));
        }
        return empentrelMap;
    }

    public Map<Long, Long> getPernontsprop(List<Long> personHrIds) {
        if (CollectionUtils.isEmpty(personHrIds)) {
            return new HashMap<Long, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_pernontsprop");
        QFilter qFilter = new QFilter("person", "in", personHrIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        String selectProperties = "id,person.id,sourcevid";
        DynamicObjectCollection pernontprops = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        HashMap<Long, Long> pernontspropMap = new HashMap<Long, Long>(pernontprops.size());
        for (DynamicObject pernontprop : pernontprops) {
            pernontspropMap.put(pernontprop.getLong("person.id"), pernontprop.getLong("sourcevid"));
        }
        return pernontspropMap;
    }

    public Map<Long, Long> getPertsprop(List<Long> personHrIds) {
        if (CollectionUtils.isEmpty(personHrIds)) {
            return new HashMap<Long, Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_pertsprop");
        QFilter qFilter = new QFilter("person", "in", personHrIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = ImportTaskWriteInAsyncTask.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,person.id";
        DynamicObjectCollection pertsprops = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "bsed desc");
        HashMap<Long, Long> pertspropMap = new HashMap<Long, Long>(pertsprops.size());
        for (DynamicObject pertsprop : pertsprops) {
            Long personId = pertsprop.getLong("person.id");
            if (pertspropMap.containsKey(personId)) continue;
            pertspropMap.put(personId, pertsprop.getLong("id"));
        }
        return pertspropMap;
    }

    private Map<String, DynamicObject> checkAndgetEmpoyeeVersionDataMap(List<String> empNumberList, List<DynamicObject> checkPassDataList) {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_employee");
        String selectProperties = "id,empnumber,startdate";
        QFilter qFilter = new QFilter("empnumber", "in", empNumberList);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObjectCollection employeeList = personHelper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "createtime desc");
        Map<String, List<DynamicObject>> employeeInfoMap = employeeList.stream().collect(Collectors.groupingBy(obj -> obj.getString("empnumber")));
        List<DynamicObject> tempList = null;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        Date workStartDate = null;
        HashSet<Long> employeeIdSet = new HashSet<Long>(this.withoutFileTemporaryDataSet.size());
        HashMap<Long, String> boIdNumberRelMap = new HashMap<Long, String>(this.withoutFileTemporaryDataSet.size());
        DynamicObject matchEmployeeObj = null;
        for (DynamicObject temporaryData : this.withoutFileTemporaryDataSet) {
            tempList = employeeInfoMap.get(temporaryData.getString("empnumber"));
            if (tempList == null) {
                this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_IS_EXIST.getCode(), ImportTaskFailMsgEnum.PERSON_NOT_EXIST, this.verifyRecordId));
                continue;
            }
            workStartDate = temporaryData.getDate("workstartdate");
            matchEmployeeObj = workStartDate == null ? tempList.get(0) : this.matchEmployee(workStartDate, tempList);
            if (matchEmployeeObj == null) {
                this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_RELATION.getCode(), ImportTaskFailMsgEnum.EMPNUMBER_NAME_AND_WORKSTARTDATE_NOT_MATCH, this.verifyRecordId));
                continue;
            }
            if (SWCDateUtils.after((Date)workStartDate, (Date)this.endDate)) {
                this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporaryData, MigrationFailTypeEnum.FAIL_TYPE_IS_EXIST.getCode(), ImportTaskFailMsgEnum.PERIOD_BEFORE_PERSON_STARTDATE, this.verifyRecordId));
                continue;
            }
            employeeIdSet.add(matchEmployeeObj.getLong("id"));
            boIdNumberRelMap.put(matchEmployeeObj.getLong("id"), temporaryData.getString("empnumber"));
            checkPassDataList.add(temporaryData);
        }
        selectProperties = "id,boid,empnumber,bsed,person.id,person.name";
        qFilter = new QFilter("boid", "in", employeeIdSet);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        qFilter.and(ImportTaskWriteInAsyncTask.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        DynamicObjectCollection employees = personHelper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "bsed desc");
        HashMap<String, DynamicObject> employeeMap = new HashMap<String, DynamicObject>(employees.size());
        HashMap<Long, DynamicObject> tempMap = new HashMap<Long, DynamicObject>(employees.size());
        for (DynamicObject employee : employees) {
            if (tempMap.containsKey(employee.getLong("boid"))) continue;
            tempMap.put(employee.getLong("boid"), employee);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            employeeMap.put((String)boIdNumberRelMap.get(entry.getKey()), (DynamicObject)entry.getValue());
        }
        return employeeMap;
    }

    private DynamicObject matchEmployee(Date workStartDate, List<DynamicObject> tempList) {
        DynamicObject result = null;
        for (DynamicObject obj : tempList) {
            if (!SWCDateUtils.isEqual((Date)workStartDate, (Date)obj.getDate("startdate"))) continue;
            result = obj;
            break;
        }
        return result;
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        QFilter brledFilter = new QFilter("bsled", ">=", (Object)startDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }

    private void setSalaryStatus(DynamicObject calPerson) {
        if (this.isPublishSalSlip) {
            calPerson.set("salarystatus", (Object)"2");
        } else {
            calPerson.set("salarystatus", (Object)"1");
        }
    }
}

