/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.writein;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.hisdata.writein.ImportTaskWriteInAsyncTask;

public class ImportTaskWriteInService {
    private static final Log logger = LogFactory.getLog(ImportTaskWriteInService.class);
    private static final int MAX_BATCH_SIZE = 500;
    private static final int MIN_BATCH_SIZE = 100;
    private static final int IDEAL_DATA_COUNT = 50000;
    public static final String KEY_ITEM_ID = "itemid";
    public static final String KEY_ITEM_TYPE = "itemtype";
    public static final String FIELD_ITEM_TYPE_BS = "3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIn(Long importTaskId, Long verifyReportId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("importtask.id", "=", (Object)importTaskId);
        filter.and(new QFilter("datastatus", "=", (Object)"4"));
        HashMap calTaskMap = new HashMap(16);
        try (DataSet dataSet = helper.queryDataSet("caltask.id,caltask.tasktype,caltask.payrollgroup.id,caltask.payrollscene.id,caltask.period.id", new QFilter[]{filter}, "caltask.tasktype asc", (Distinctable)WithDistinctable.get());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
                paramMap.put("taskType", row.getString("caltask.tasktype"));
                paramMap.put("payRollGroupId", row.getLong("caltask.payrollgroup.id"));
                paramMap.put("payRollSceneId", row.getLong("caltask.payrollscene.id"));
                paramMap.put("periodId", row.getLong("caltask.period.id"));
                calTaskMap.put(row.getLong("caltask.id"), paramMap);
            }
        }
        SWCDataServiceHelper importTaskHelper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject importTask = importTaskHelper.queryOne("migrationtpl.id,migrationtpl.hsas_migrationtplent,migrationtpl.hsas_migrationtplent.itemid,migrationtpl.hsas_migrationtplent.itemtype", new QFilter[]{new QFilter("id", "=", (Object)importTaskId)});
        DynamicObjectCollection entry = importTask.getDynamicObjectCollection("migrationtpl.hsas_migrationtplent");
        int batchSize = 50000 / entry.size();
        if (batchSize > 500) {
            batchSize = 500;
        } else if (batchSize < 100) {
            batchSize = 100;
        }
        Map<Long, String> bizItemTypeMap = this.getBizItemTypeMap(entry);
        block6: for (Map.Entry calTaskParam : calTaskMap.entrySet()) {
            Long calTaskId = (Long)calTaskParam.getKey();
            Map paramMap = (Map)calTaskParam.getValue();
            String taskType = (String)paramMap.get("taskType");
            Long payRollGroupId = (Long)paramMap.get("payRollGroupId");
            Long payRollSceneId = (Long)paramMap.get("payRollSceneId");
            Long periodId = (Long)paramMap.get("periodId");
            HashSet<String> usedSalaryFileNumberSet = new HashSet<String>(3 * batchSize);
            QFilter idFilter = null;
            while (true) {
                QFilter importTaskFilter = new QFilter("importtask.id", "=", (Object)importTaskId);
                importTaskFilter.and(new QFilter("datastatus", "=", (Object)"4"));
                if (calTaskId != null && calTaskId != 0L) {
                    importTaskFilter.and(new QFilter("caltask.id", "=", (Object)calTaskId));
                } else {
                    importTaskFilter.and(new QFilter("caltask.id", "not in", calTaskMap.keySet()));
                }
                if (idFilter != null) {
                    importTaskFilter.and(idFilter);
                }
                CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
                DynamicObject[] temporaryDatas = helper.query("id,caltask.id,calpersonid,filenumber,datastatus,empnumber,empname,filenumber,workstartdate,caltaskname,adminorg.id,empgroup.id,payrollgroup.org.id,itementry.itemtype,itementry.datatype,itementry.itemid,itementry.itemvalue", new QFilter[]{importTaskFilter}, "id asc", 3 * batchSize);
                CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
                if (temporaryDatas == null || temporaryDatas.length == 0) continue block6;
                HashSet<String> salaryFileNumberSet = new HashSet<String>(temporaryDatas.length);
                for (DynamicObject temporaryData : temporaryDatas) {
                    String fileNumber = temporaryData.getString("filenumber");
                    if (!SWCStringUtils.isNotEmpty((String)fileNumber)) continue;
                    salaryFileNumberSet.add(fileNumber);
                }
                Set<String> existSalaryFileNumberSet = this.getExistSalaryFileNumber(taskType, payRollGroupId, payRollSceneId, periodId, salaryFileNumberSet, calTaskId);
                Set<String> calTaskFileNumberSet = this.getCalTaskFileNumberSet(calTaskId, salaryFileNumberSet);
                int size = temporaryDatas.length;
                int batchCount = size / batchSize + 1;
                List<DynamicObject> temporaryDataList = Arrays.asList(temporaryDatas);
                CountDownLatch countDownLatch = new CountDownLatch(batchCount);
                for (int index = 0; index < batchCount; ++index) {
                    int startIndex = index * batchSize;
                    if (startIndex >= size) {
                        countDownLatch.countDown();
                        break;
                    }
                    int endIndex = startIndex + batchSize;
                    if (endIndex > size) {
                        endIndex = size;
                    }
                    List<DynamicObject> partTemporaryDataList = temporaryDataList.subList(startIndex, endIndex);
                    HashMap<Long, ImportTaskFailMsgEnum> failMsgMap = new HashMap<Long, ImportTaskFailMsgEnum>(partTemporaryDataList.size());
                    for (DynamicObject temporaryData : partTemporaryDataList) {
                        String fileNumber = temporaryData.getString("filenumber");
                        Long temporaryDataId = temporaryData.getLong("id");
                        if (calTaskFileNumberSet.contains(fileNumber) || usedSalaryFileNumberSet.contains(fileNumber)) {
                            failMsgMap.put(temporaryDataId, ImportTaskFailMsgEnum.SALARYFILE_HAS_EXIST);
                        } else if (SWCStringUtils.equals((String)taskType, (String)"0")) {
                            if (existSalaryFileNumberSet.contains(fileNumber)) {
                                failMsgMap.put(temporaryDataId, ImportTaskFailMsgEnum.SALARYFILE_HAS_EXIST_IN_CALTASK);
                            }
                        } else if (SWCStringUtils.equals((String)taskType, (String)"1") && !existSalaryFileNumberSet.contains(fileNumber)) {
                            failMsgMap.put(temporaryDataId, ImportTaskFailMsgEnum.SALARYFILE_NOT_EXIST_IN_CALTASK);
                        }
                        usedSalaryFileNumberSet.add(fileNumber);
                    }
                    SWCThreadPoolFactory.getHisdataIntegrateThreadpool().execute((Runnable)new ImportTaskWriteInAsyncTask(importTaskId, partTemporaryDataList, calTaskId, verifyReportId, failMsgMap, countDownLatch, bizItemTypeMap));
                }
                try {
                    countDownLatch.await();
                }
                catch (Exception exception) {
                    logger.error("\u5199\u5165\u7b49\u5f85\u7ebf\u7a0b\u8ba1\u6570\u5931\u8d25", (Throwable)exception);
                }
                if (temporaryDatas.length < 3 * batchSize) continue block6;
                idFilter = new QFilter("id", ">", (Object)temporaryDatas[temporaryDatas.length - 1].getLong("id"));
            }
        }
    }

    private Map<Long, String> getBizItemTypeMap(DynamicObjectCollection entry) {
        HashSet<Long> bizItemIdSet = new HashSet<Long>(entry.size());
        for (DynamicObject row : entry) {
            if (!FIELD_ITEM_TYPE_BS.equals(row.getString(KEY_ITEM_TYPE))) continue;
            bizItemIdSet.add(row.getLong(KEY_ITEM_ID));
        }
        if (CollectionUtils.isEmpty(bizItemIdSet)) {
            return new HashMap<Long, String>(0);
        }
        SWCDataServiceHelper bizItemHelper = new SWCDataServiceHelper("hsbs_bizitem");
        DynamicObjectCollection bizItems = bizItemHelper.queryOriginalCollection("id,classification", new QFilter[]{new QFilter("id", "in", bizItemIdSet)});
        return bizItems.stream().collect(Collectors.toMap(bizItem -> bizItem.getLong("id"), bizItem -> "1".equals(bizItem.getString("classification")) ? "hsbs_attbizitem" : "hsbs_bizitem"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getExistSalaryFileNumber(String taskType, Long payRollGroupId, Long payRollSceneId, Long periodId, Set<String> salaryFileNumberSet, Long calTaskId) {
        if (SWCStringUtils.equals((String)taskType, (String)"2") || CollectionUtils.isEmpty(salaryFileNumberSet)) {
            return new HashSet<String>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("tasktype", "=", (Object)"0");
        filter.and(new QFilter("payrollgroup", "=", (Object)payRollGroupId));
        filter.and(new QFilter("payrollscene", "=", (Object)payRollSceneId));
        filter.and(new QFilter("period", "=", (Object)periodId));
        filter.and(new QFilter("id", "!=", (Object)calTaskId));
        DynamicObjectCollection calTasks = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)calTasks)) {
            return new HashSet<String>(0);
        }
        List calTaskIdList = calTasks.stream().map(calTask -> calTask.getLong("id")).collect(Collectors.toList());
        helper.setEntityName("hsas_calperson");
        filter = new QFilter("caltask", "in", calTaskIdList);
        filter.and(new QFilter("salaryfile.number", "in", salaryFileNumberSet));
        HashSet<String> existSalaryFileNumber = new HashSet<String>(salaryFileNumberSet.size());
        try (DataSet dataSet = helper.queryDataSet("salaryfile.number", new QFilter[]{filter}, "", (Distinctable)WithDistinctable.get());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                existSalaryFileNumber.add(row.getString("salaryfile.number"));
            }
        }
        return existSalaryFileNumber;
    }

    private Set<String> getCalTaskFileNumberSet(Long calTaskId, Set<String> fileNumberSet) {
        if (calTaskId == null || calTaskId == 0L || CollectionUtils.isEmpty(fileNumberSet)) {
            return new HashSet<String>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask", "=", (Object)calTaskId);
        filter.and(new QFilter("salaryfile.number", "in", fileNumberSet));
        DynamicObjectCollection calPersons = helper.queryOriginalCollection("salaryfile.number", new QFilter[]{filter});
        return calPersons.stream().map(calPerson -> calPerson.getString("salaryfile.number")).collect(Collectors.toSet());
    }
}

