/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.mq;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.service.CalService;
import kd.swc.hscs.business.cal.utils.CalUtils;

public class BatchCalConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(BatchCalConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        log.info("BatchCalConsumer.onMessage start,messageId = {},resend = {}", (Object)messageId, (Object)resend);
        this.consumenMessage((Map)message);
        messageAcker.ack(messageId);
        log.info("BatchCalConsumer.onMessage end,messageId = {}", (Object)messageId);
    }

    private void consumenMessage(Map<String, Object> params) {
        String calTaskId = (String)params.get("calTaskId");
        String recordId = (String)params.get("calRecordId");
        String calBatchId = (String)params.get("calBatchId");
        String calType = (String)params.get("calType");
        boolean resultCheck = (Boolean)params.get("resultcheck");
        List calPersonIdList = (List)params.get("calPersonIdList");
        Long mqSendTime = (Long)params.get("mqSendTime");
        Long mqReceiveTime = System.currentTimeMillis();
        Long mqWaitConsumeTime = mqReceiveTime - mqSendTime;
        log.info("BatchCalConsumer.consumenMessage begin,record = {},calBatchId = {},mqWaitConsumeTime = {},calType = {}", new Object[]{recordId, calBatchId, mqWaitConsumeTime, calType});
        List<Long> canCalIdList = this.filterCalPersonData(calPersonIdList, calType);
        log.info("calBatchId={},total size is {},can deal data size is {}", new Object[]{calBatchId, calPersonIdList.size(), canCalIdList.size()});
        if (SWCListUtils.isEmpty(canCalIdList)) {
            log.info("canCalIdList is emptry,calBatchId = {}", (Object)calBatchId);
            return;
        }
        CalService calService = new CalService(calTaskId, recordId, calBatchId);
        calService.cal(canCalIdList, calType, resultCheck, true);
        log.info("BatchCalConsumer.consumenMessage end,record = {},calBatchId = {},calType = {}", new Object[]{recordId, calBatchId, calType});
    }

    private List<Long> filterCalPersonData(List<Long> calPersonIdList, String calType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id";
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        filter.and(CalUtils.getFilterByCalType(calType));
        DynamicObjectCollection dataList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return dataList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
    }
}

