/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.createobject;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hscs.business.paydetail.createobject.PayDetailDecorator;
import kd.swc.hscs.business.paydetail.createobject.PayDetailInterface;
import kd.swc.hscs.business.paydetail.entity.BankCardObserver;
import kd.swc.hscs.business.paydetail.entity.PayAmountInfoDTO;

public class PayAmountInfoDecorator
extends PayDetailDecorator {
    private static final HashSet<Long> NEEDBANKCARDIDS = new HashSet<Long>(Arrays.asList(1010L, 1020L));
    private PayAmountInfoDTO payAmountInfo;
    private BankCardObserver observer;

    public PayAmountInfoDecorator(PayDetailInterface payDetailInfo, PayAmountInfoDTO payAmountInfo, BankCardObserver observer) {
        super(payDetailInfo);
        this.payAmountInfo = payAmountInfo;
        this.observer = observer;
    }

    @Override
    public DynamicObject createInfo() {
        DynamicObject payDetail = super.createInfo();
        DynamicObject paySetting = this.payAmountInfo.getPaySetting();
        payDetail.set("salaryitem", (Object)this.payAmountInfo.getSalaryItemId());
        payDetail.set("calcurrency", (Object)this.payAmountInfo.getCalCurrency());
        payDetail.set("paycurrency", (Object)paySetting.getDynamicObject("currency"));
        payDetail.set("paysubjecthis", (Object)this.payAmountInfo.getPaySubjectVid());
        payDetail.set("calamount", (Object)this.payAmountInfo.getCalAmount());
        payDetail.set("payamount", (Object)this.payAmountInfo.getPayAmount());
        payDetail.set("paysettinghis", (Object)this.payAmountInfo.getSalaryFilePaySettingVId());
        DynamicObject payType = paySetting.getDynamicObject("paytype");
        long payTypeId = payType.getLong("id");
        boolean isMustBankCard = NEEDBANKCARDIDS.contains(payType.getLong("paycategory.id"));
        payDetail.set("paytype", (Object)payTypeId);
        payDetail.set("ismustbankcard", (Object)isMustBankCard);
        payDetail.set("perbankcard", (Object)paySetting.getLong("perbankcard.id"));
        payDetail.set("bank", (Object)paySetting.getLong("perbankcard.bankdeposit.id"));
        payDetail.set("paysettingentryid", (Object)paySetting.getLong("id"));
        if (isMustBankCard && paySetting.getLong("perbankcard.id") == 0L) {
            this.observer.setErrorMap(this.payAmountInfo.getSalaryFileDTO());
        }
        return payDetail;
    }
}

