/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.payamount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailDTO;
import kd.swc.hscs.business.paydetail.entity.ExchangeRateError;
import kd.swc.hscs.business.paydetail.entity.ExchangeRateObserver;
import kd.swc.hscs.business.paydetail.entity.PayAmountCommonDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountContext;
import kd.swc.hscs.business.paydetail.entity.PayAmountDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayItemPriorityDTO;
import kd.swc.hscs.business.paydetail.entity.PaySalaryFileDTO;
import kd.swc.hscs.business.paydetail.entity.PriorityEnum;
import kd.swc.hscs.business.paydetail.payamount.BasePayItemStrategy;
import kd.swc.hscs.business.paydetail.payamount.SpecifyAmountStrategy;
import kd.swc.hscs.business.paydetail.payamount.SpecifyProportionStrategy;

public class CalPayDetailPayAmountService {
    private static final Log logger = LogFactory.getLog(CalPayDetailPayAmountService.class);
    private Queue<PayItemPriorityDTO> priorityQueue = new PriorityQueue<PayItemPriorityDTO>(new PayComparator());
    private Map<String, ExchangeRateError> currencyIdsMapCurrencyNames = new HashMap<String, ExchangeRateError>(16);
    private static final HashSet<String> NOTTARGET = new HashSet<String>(Arrays.asList("0", "2"));

    public void createPriorityQueue(CreatePayDetailDTO detailDTO) {
        Map<Long, PayAmountDTO> payAmountMap = this.createPayAmountMap(detailDTO);
        DynamicObject paySetting = detailDTO.getPaySetting();
        this.createPayItemPriority(paySetting, payAmountMap);
    }

    public List<PayAmountInfoDTO> payAmountFormQueue() {
        logger.info("Begin Calculate PayDetail Amount :{}", (Object)this.priorityQueue.size());
        ArrayList<PayAmountInfoDTO> amountInfoDTOList = new ArrayList<PayAmountInfoDTO>(this.priorityQueue.size());
        ExchangeRateObserver observer = new ExchangeRateObserver();
        while (!this.priorityQueue.isEmpty()) {
            PayAmountContext context;
            BasePayItemStrategy strategy;
            PayItemPriorityDTO payItemPriorityDTO = this.priorityQueue.poll();
            if (payItemPriorityDTO.isAmount()) {
                strategy = new SpecifyAmountStrategy(observer);
                context = new PayAmountContext(strategy);
            } else {
                strategy = new SpecifyProportionStrategy(observer);
                context = new PayAmountContext(strategy);
            }
            PayAmountInfoDTO payAmount = context.getPayAmount(payItemPriorityDTO);
            if (!observer.getErrorMap().isEmpty()) {
                amountInfoDTOList.clear();
                this.currencyIdsMapCurrencyNames.putAll(observer.getErrorMap());
                break;
            }
            if (payAmount == null) continue;
            amountInfoDTOList.add(payAmount);
        }
        return amountInfoDTOList;
    }

    public Map<String, ExchangeRateError> getCurrencyIdsMapCurrencyNames() {
        return this.currencyIdsMapCurrencyNames;
    }

    private void createPayItemPriority(DynamicObject paySetting, Map<Long, PayAmountDTO> payAmountMap) {
        this.priorityQueue.clear();
        DynamicObjectCollection settingCol = paySetting.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> coverPaySettingList = new ArrayList<DynamicObject>(10);
        HashSet<Long> salaryItemUsedSet = new HashSet<Long>(16);
        for (DynamicObject entity : settingCol) {
            String salaryItemMark = entity.getString("salaryitemmark");
            if (NOTTARGET.contains(salaryItemMark)) {
                coverPaySettingList.add(entity);
                continue;
            }
            long salaryItemId = entity.getLong("salaryitem.id");
            PayAmountDTO amountDTO = payAmountMap.get(salaryItemId);
            if (amountDTO == null) {
                logger.info("Not This SalaryItem :{}", (Object)salaryItemId);
                continue;
            }
            PayItemPriorityDTO priorityDTO = new PayItemPriorityDTO(amountDTO, entity);
            String paymentWay = entity.getString("paymentway");
            priorityDTO.setPriority(PriorityEnum.getProportionEnumByPaymentWay(salaryItemMark, paymentWay));
            this.priorityQueue.add(priorityDTO);
            salaryItemUsedSet.add(salaryItemId);
        }
        payAmountMap.keySet().removeAll(salaryItemUsedSet);
        payAmountMap.forEach((k, val) -> coverPaySettingList.forEach(entity -> {
            String salaryItemMark = entity.getString("salaryitemmark");
            PayItemPriorityDTO priorityDTO = new PayItemPriorityDTO((PayAmountDTO)val, (DynamicObject)entity);
            String paymentWay = entity.getString("paymentway");
            priorityDTO.setPriority(PriorityEnum.getProportionEnumByPaymentWay(salaryItemMark, paymentWay));
            this.priorityQueue.add(priorityDTO);
        }));
    }

    private Map<Long, PayAmountDTO> createPayAmountMap(CreatePayDetailDTO detailDTO) {
        HashMap<Long, PayAmountDTO> map = new HashMap<Long, PayAmountDTO>(16);
        Map<Long, Long> payOutItemIdDataRoundIdMap = detailDTO.getCommonDTO().getPayOutItemIdDataRoundIdMap();
        Set<Long> payOutItemIdList = payOutItemIdDataRoundIdMap.keySet();
        DynamicObject paySetting = detailDTO.getPaySetting();
        DynamicObject calPerson = detailDTO.getCalPerson();
        List<DynamicObject> calTableEntry = detailDTO.getCalTableList();
        DynamicObject payrollGroupHis = detailDTO.getCommonDTO().getPayrollGroupHis();
        DynamicObject calCurrency = payrollGroupHis.getDynamicObject("currency");
        DynamicObject exrateTable = payrollGroupHis.getDynamicObject("exratetable");
        Date exrateDate = calPerson.getDate("caltask.exratedate");
        long paySettingVId = paySetting.getLong("id");
        PaySalaryFileDTO salaryFileDTO = new PaySalaryFileDTO(detailDTO.getCalPerson().getLong("salaryfile.id"), detailDTO.getCalPerson().getString("salaryfile.number"));
        PayAmountCommonDTO amountCommon = new PayAmountCommonDTO(calCurrency, exrateTable, exrateDate, paySettingVId, salaryFileDTO);
        logger.info("PayOutItemIds :{}", (Object)payOutItemIdList.size());
        calTableEntry.forEach(obj -> {
            if (obj.getInt("hsas_caltableentry.slprorationindex") == 0) {
                BigDecimal calAmountValue;
                Long salaryItemId = obj.getLong("hsas_caltableentry.salaryitem.id");
                Long dataRoundId = (Long)payOutItemIdDataRoundIdMap.get(salaryItemId);
                logger.info("salaryItemId :{}", (Object)salaryItemId);
                if (payOutItemIdList.contains(salaryItemId) && BigDecimal.ZERO.compareTo(calAmountValue = obj.getBigDecimal("hsas_caltableentry.calamountvalue")) < 0) {
                    PayAmountDTO amountDTO = new PayAmountDTO(salaryItemId, dataRoundId, calAmountValue, calAmountValue, amountCommon);
                    map.put(salaryItemId, amountDTO);
                }
            }
        });
        logger.info("PayOutItemIdMap Size :{}", (Object)map.size());
        return map;
    }

    static class PayComparator
    implements Comparator<PayItemPriorityDTO> {
        PayComparator() {
        }

        @Override
        public int compare(PayItemPriorityDTO o1, PayItemPriorityDTO o2) {
            PriorityEnum priority1 = o1.getPriority();
            PriorityEnum priority2 = o2.getPriority();
            return priority2.getCode() == priority1.getCode() ? o1.getPaySetting().getInt("seq") - o2.getPaySetting().getInt("seq") : priority2.getCode() - priority1.getCode();
        }
    }
}

