/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.payamount;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hscs.business.paydetail.CreatePayDetailHelper;
import kd.swc.hscs.business.paydetail.entity.ExchangeRateObserver;
import kd.swc.hscs.business.paydetail.entity.PayAmountCommonDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayItemPriorityDTO;
import kd.swc.hscs.business.paydetail.payamount.BasePayItemStrategy;

public class SpecifyAmountStrategy
extends BasePayItemStrategy {
    SpecifyAmountStrategy(ExchangeRateObserver observer) {
        this.OBSERVER = observer;
    }

    @Override
    public PayAmountInfoDTO strategyMethod(PayItemPriorityDTO payItemPriorityDTO) {
        DynamicObject paySetting = payItemPriorityDTO.getPaySetting();
        BigDecimal payAmount = paySetting.getBigDecimal("payamount");
        DynamicObject payCurrency = paySetting.getDynamicObject("currency");
        PayAmountDTO amountDTO = payItemPriorityDTO.getAmountDTO();
        Long salaryItemId = amountDTO.getSalaryItemId();
        Long dataRoundId = amountDTO.getDataRoundId();
        BigDecimal calRemain = amountDTO.getCalRemain();
        PayAmountCommonDTO payAmountCommon = amountDTO.getPayAmountCommon();
        DynamicObject calCurrency = payAmountCommon.getCalCurrency();
        Date exrateDate = payAmountCommon.getExrateDate();
        DynamicObject exrateTable = payAmountCommon.getExrateTable();
        Map<String, ExchangeRateInfo> exrateMap = payAmountCommon.getExrateMap();
        Integer calScaleInt = calCurrency.getInt("amtprecision");
        if (BigDecimal.ZERO.compareTo(calRemain) == 0) {
            return null;
        }
        PayAmountInfoDTO payAmountInfo = new PayAmountInfoDTO(salaryItemId, paySetting, calCurrency, payAmountCommon.getSalaryFileDTO());
        ExchangeRateInfo exrateInfo = CreatePayDetailHelper.getExrate(payCurrency, calCurrency, exrateDate, exrateTable, exrateMap);
        if (exrateInfo == null) {
            this.OBSERVER.setErrorMap(exrateTable, payCurrency, calCurrency);
            return null;
        }
        Boolean quoteType = exrateInfo.getQuoteType();
        BigDecimal rate = exrateInfo.getExchangeRate();
        RoundingMode roundingMode = CreatePayDetailHelper.getRoundingMode(dataRoundId);
        BigDecimal payTotal = quoteType != false ? payAmount.divide(rate, (int)calScaleInt, roundingMode) : payAmount.multiply(rate);
        if (calRemain.compareTo(payTotal = payTotal.setScale((int)calScaleInt, roundingMode)) <= 0) {
            amountDTO.setCalRemain(BigDecimal.ZERO);
            amountDTO.setCalAmountTotal(calRemain);
            exrateInfo = CreatePayDetailHelper.getExrate(calCurrency, payCurrency, exrateDate, exrateTable, exrateMap);
            if (exrateInfo == null) {
                this.OBSERVER.setErrorMap(exrateTable, calCurrency, payCurrency);
                return null;
            }
            quoteType = exrateInfo.getQuoteType();
            int payScaleInt = payCurrency.getInt("amtprecision");
            rate = exrateInfo.getExchangeRate();
            payTotal = quoteType != false ? calRemain.divide(rate, payScaleInt, roundingMode) : calRemain.multiply(rate);
            payTotal = payTotal.setScale(payScaleInt, roundingMode);
            payAmountInfo.setCalAmount(calRemain);
            payAmountInfo.setPayAmount(payTotal);
            payAmountInfo.setExrateInfo(exrateInfo);
        } else {
            payAmountInfo.setCalAmount(payTotal);
            payAmountInfo.setPayAmount(payAmount);
            payAmountInfo.setExrateInfo(exrateInfo);
            amountDTO.setCalRemain(calRemain.subtract(payTotal));
            amountDTO.setCalAmountTotal(amountDTO.getCalAmountTotal().add(payTotal));
        }
        payAmountCommon.setExrateMap(exrateMap);
        payAmountInfo.setSalaryFilePaySettingVId(payAmountCommon.getSalaryFilePaySettingVId());
        return payAmountInfo;
    }
}

