/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.payamount;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hscs.business.paydetail.CreatePayDetailHelper;
import kd.swc.hscs.business.paydetail.entity.ExchangeRateObserver;
import kd.swc.hscs.business.paydetail.entity.PayAmountCommonDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayItemPriorityDTO;
import kd.swc.hscs.business.paydetail.payamount.BasePayItemStrategy;

public class SpecifyProportionStrategy
extends BasePayItemStrategy {
    SpecifyProportionStrategy(ExchangeRateObserver observer) {
        this.OBSERVER = observer;
    }

    @Override
    public PayAmountInfoDTO strategyMethod(PayItemPriorityDTO payItemPriorityDTO) {
        BigDecimal payTotal;
        DynamicObject paySetting = payItemPriorityDTO.getPaySetting();
        BigDecimal payRate = paySetting.getBigDecimal("payrate");
        DynamicObject payCurrency = paySetting.getDynamicObject("currency");
        Integer payScaleInt = payCurrency.getInt("amtprecision");
        PayAmountDTO amountDTO = payItemPriorityDTO.getAmountDTO();
        PayAmountCommonDTO payAmountCommon = amountDTO.getPayAmountCommon();
        DynamicObject calCurrency = payAmountCommon.getCalCurrency();
        DynamicObject exrateTable = payAmountCommon.getExrateTable();
        Map<String, ExchangeRateInfo> exrateMap = payAmountCommon.getExrateMap();
        Long salaryItemId = amountDTO.getSalaryItemId();
        Long dataRoundId = amountDTO.getDataRoundId();
        BigDecimal calTotal = amountDTO.getCalProportionTotal();
        BigDecimal calRemain = amountDTO.getCalRemain();
        if (BigDecimal.ZERO.compareTo(calRemain) == 0) {
            return null;
        }
        PayAmountInfoDTO payAmountInfo = new PayAmountInfoDTO(salaryItemId, paySetting, calCurrency, payAmountCommon.getSalaryFileDTO());
        ExchangeRateInfo exrateInfo = CreatePayDetailHelper.getExrate(calCurrency, payCurrency, payAmountCommon.getExrateDate(), exrateTable, exrateMap);
        if (exrateInfo == null) {
            this.OBSERVER.setErrorMap(exrateTable, calCurrency, payCurrency);
            return null;
        }
        Boolean quoteType = exrateInfo.getQuoteType();
        BigDecimal rate = exrateInfo.getExchangeRate();
        RoundingMode roundingMode = CreatePayDetailHelper.getRoundingMode(dataRoundId);
        if (amountDTO.isLastCounter()) {
            payTotal = quoteType != false ? calRemain.divide(rate, (int)payScaleInt, roundingMode) : calRemain.multiply(rate);
            payTotal = payTotal.setScale((int)payScaleInt, roundingMode);
            amountDTO.setCalRemain(BigDecimal.ZERO);
            payAmountInfo.setCalAmount(calRemain);
        } else {
            int calScaleInt = calCurrency.getInt("amtprecision");
            BigDecimal calAmount = calTotal.multiply(payRate).divide(new BigDecimal("100"));
            calAmount = calAmount.setScale(calScaleInt, roundingMode);
            payTotal = quoteType != false ? calAmount.divide(rate, (int)payScaleInt, roundingMode) : calAmount.multiply(rate);
            payTotal = payTotal.setScale((int)payScaleInt, roundingMode);
            amountDTO.setCalRemain(calRemain.subtract(calAmount));
            payAmountInfo.setCalAmount(calAmount);
        }
        payAmountInfo.setPayAmount(payTotal);
        payAmountInfo.setExrateInfo(exrateInfo);
        payAmountInfo.setSalaryFilePaySettingVId(payAmountCommon.getSalaryFilePaySettingVId());
        return payAmountInfo;
    }
}

