/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.swc.hsbp.common.enums.CreatePayDetailType;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailDTO;
import kd.swc.hscs.business.paydetail.entity.ExchangeRateError;
import kd.swc.hscs.business.paydetail.validator.CalPayItemValidator;
import kd.swc.hscs.business.paydetail.validator.CalStatusValidator;
import kd.swc.hscs.business.paydetail.validator.ExchangeRateValidator;
import kd.swc.hscs.business.paydetail.validator.NotBankCardValidator;
import kd.swc.hscs.business.paydetail.validator.PayDetailBaseValidator;
import kd.swc.hscs.business.paydetail.validator.PaySettingValidator;
import kd.swc.hscs.business.paydetail.validator.ResendStatusValidator;

public class CalPayDetailValidatorService {
    private CreatePayDetailType type;
    private PayDetailBaseValidator calStatusValidator;
    private PayDetailBaseValidator calPayItemValidator;
    private PayDetailBaseValidator paySettingValidator;
    private ExchangeRateValidator exchangeRateValidator;
    private ResendStatusValidator resendStatusValidator;
    private NotBankCardValidator notBankCardValidator;

    public CalPayDetailValidatorService(CreatePayDetailType type) {
        this.type = type;
    }

    public void init() {
        switch (this.type) {
            case NORMAL: {
                this.calStatusValidator = new CalStatusValidator();
                this.calPayItemValidator = new CalPayItemValidator();
                this.paySettingValidator = new PaySettingValidator();
                this.exchangeRateValidator = new ExchangeRateValidator();
                this.notBankCardValidator = new NotBankCardValidator();
                this.setValidatorALG();
                break;
            }
            case RESEND: {
                this.resendStatusValidator = new ResendStatusValidator();
                this.calPayItemValidator = new CalPayItemValidator();
                this.paySettingValidator = new PaySettingValidator();
                this.exchangeRateValidator = new ExchangeRateValidator();
                this.notBankCardValidator = new NotBankCardValidator();
                this.setValidatorResendALG();
                break;
            }
        }
    }

    private void setValidatorALG() {
        this.calStatusValidator.setNextValidator(this.calPayItemValidator);
        this.calPayItemValidator.setNextValidator(this.paySettingValidator);
    }

    private void setValidatorResendALG() {
        this.resendStatusValidator.setNextValidator(this.calPayItemValidator);
        this.calPayItemValidator.setNextValidator(this.paySettingValidator);
    }

    public List<String> validator(CreatePayDetailDTO calPerson) {
        List<String> validator = new ArrayList<String>(10);
        switch (this.type) {
            case NORMAL: {
                validator = this.calStatusValidator.validator(calPerson);
                break;
            }
            case RESEND: {
                validator = this.resendStatusValidator.validator(calPerson);
                break;
            }
        }
        return validator;
    }

    public List<String> validatorExchange(Map<String, ExchangeRateError> currencyIdsMapCurrencyNames) {
        return this.exchangeRateValidator.validator(currencyIdsMapCurrencyNames);
    }

    public List<String> validatorBankCard(Map<Long, String> salaryFileNotBankCardMap) {
        return this.notBankCardValidator.validator(salaryFileNotBankCardMap);
    }
}

