/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailDTO;
import kd.swc.hscs.business.paydetail.validator.PayDetailBaseValidator;

public class CalStatusValidator
extends PayDetailBaseValidator {
    private Set<String> enablePayDetailCalStatusSet = new HashSet<String>(Arrays.asList(CalStateEnum.AUDIT.getCode(), CalStateEnum.WAIT_APPROVALED.getCode(), CalStateEnum.APPROVALING.getCode(), CalStateEnum.APPROVALED_NOT_PASS.getCode(), CalStateEnum.APPROVAL.getCode(), CalStateEnum.APPROVALED.getCode()));

    @Override
    List<String> validator(CreatePayDetailDTO detailDTO) {
        ArrayList<String> errMsg = new ArrayList<String>(10);
        DynamicObject calPerson = detailDTO.getCalPerson();
        String onHoldStatus = calPerson.getString("onholdstatus");
        if (String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()).equals(onHoldStatus)) {
            String salaryFileNumber = detailDTO.getCalPerson().getString("salaryfilev.number");
            errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u7ec8\u6b62\u53d1\u653e\u201d\uff0c\u65e0\u6cd5\u751f\u6210\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalStatusValidator_0", (String)"swc-hsas-business", (Object[])new Object[0]), salaryFileNumber));
            return errMsg;
        }
        String calStatus = calPerson.getString("calStatus");
        if (this.enablePayDetailCalStatusSet.contains(calStatus)) {
            String payStatus = calPerson.getString("payStatus");
            if (!SWCStringUtils.equals((String)payStatus, (String)PayStateEnum.UNCREATE.getCode())) {
                String salaryFileNumber = calPerson.getString("salaryfilev.number");
                errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u5df2\u751f\u6210\u53d1\u653e\u660e\u7ec6\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\u3002", (String)"CalStatusValidator_1", (String)"swc-hsas-business", (Object[])new Object[0]), salaryFileNumber));
            }
        } else {
            String salaryFileNumber = calPerson.getString("salaryfilev.number");
            errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u65e0\u6cd5\u751f\u6210\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalStatusValidator_2", (String)"swc-hsas-business", (Object[])new Object[0]), salaryFileNumber));
        }
        if (errMsg.isEmpty() && this.getNextValidator() != null) {
            return this.getNextValidator().validator(detailDTO);
        }
        return errMsg;
    }
}

