/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.salaryfile;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SalaryFileServiceHelper {
    private static final Log LOG = LogFactory.getLog(SalaryFileServiceHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";

    public List<Map<String, Object>> matchSalaryFile(List<Map<String, Object>> params, Map<Long, DynamicObject> collectFileMap) {
        long currTime = System.currentTimeMillis();
        LOG.info("SalaryFileServiceHelper matchSalaryFile {} params is: {}", (Object)currTime, params);
        this.validateParam(params);
        List<Map<String, Object>> rightParams = this.filterRightParams(params);
        DynamicObject[] fileEmps = this.queryfileEmps(rightParams);
        HashMap<Long, Long> entryFileRlsMap = new HashMap<Long, Long>(16);
        Map<String, List<DynamicObject>> empEntMap = this.getFileMap(fileEmps, entryFileRlsMap);
        Map<Long, DynamicObject> fileMap = this.queryfileMap(entryFileRlsMap);
        List<DynamicObject> empEnts = null;
        LOG.info("SalaryFileServiceHelper matchSalaryFile start query!");
        for (Map<String, Object> param : rightParams) {
            String key = String.valueOf(param.get("depEmpId"));
            empEnts = empEntMap.get(key);
            if (empEnts == null) {
                LOG.info("SalaryFileServiceHelper matchSalaryFile empEnts is null");
                param.put("queryRowCount", 0);
                continue;
            }
            Long salaryFileId = (Long)param.get("salaryFileId");
            Long payrollGrpId = (Long)param.get("payrollGrpId");
            Date endDate = (Date)param.get("endDate");
            List status = (List)param.get("status");
            Long matchSalaryFileId = null;
            HashSet<Long> matchSalaryFileIds = new HashSet<Long>(10);
            ArrayList<DynamicObject> matchSalaryFileVers = new ArrayList<DynamicObject>(10);
            for (DynamicObject empEnt : empEnts) {
                Long salaryFileIdDB = (Long)entryFileRlsMap.get(empEnt.getLong("id"));
                DynamicObject fileDy = fileMap.get(salaryFileIdDB);
                if (fileDy == null) {
                    LOG.error("SalaryFileServiceHelper.matchSalaryFile error.params..{}", (Object)JSON.toJSONString(params));
                    LOG.error("SalaryFileServiceHelper.matchSalaryFile error.entryFileRlsMap..{}", (Object)JSON.toJSONString(entryFileRlsMap));
                    LOG.error("SalaryFileServiceHelper.matchSalaryFile error.salaryFileIdDB..{}", (Object)salaryFileIdDB);
                    continue;
                }
                Long payrollGrpIdDB = fileDy.getLong("payrollgroup.id");
                Date payEndDateDB = empEnt.getDate("payenddate");
                if (status != null && !status.isEmpty() && !status.contains(fileDy.getString("status"))) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile status match fail");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile status is: {}", (Object)status);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile fileDy getStatus: {}", (Object)fileDy.getString("status"));
                    continue;
                }
                if (salaryFileId != null && salaryFileId != 0L && !salaryFileIdDB.equals(salaryFileId)) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile salaryFileId is match null");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile salaryFileId value is: {}", (Object)salaryFileId);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile salaryFileIdDB value is: {}", (Object)salaryFileIdDB);
                    continue;
                }
                if (payrollGrpId != null && payrollGrpId != 0L && !payrollGrpIdDB.equals(payrollGrpId)) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile payrollGrpId not match success");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile payrollGrpId value is: {}", (Object)payrollGrpId);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile payrollGrpIdDB value is: {}", (Object)payrollGrpIdDB);
                    continue;
                }
                if (endDate != null && (payEndDateDB == null || endDate.after(payEndDateDB))) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile date match fail");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile date endDate is: {}", (Object)endDate);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile date payEndDateDB is: {}", (Object)payEndDateDB);
                    continue;
                }
                matchSalaryFileIds.add(salaryFileIdDB);
                matchSalaryFileVers.add(fileDy);
                if (matchSalaryFileIds.size() == 1) {
                    matchSalaryFileId = salaryFileIdDB;
                }
                if (endDate == null) continue;
                break;
            }
            param.put("queryRowCount", matchSalaryFileIds.size());
            param.put("matchSalaryFileId", matchSalaryFileId);
            param.put("matchSalaryFileIds", new ArrayList(matchSalaryFileIds));
            param.put("matchSalaryFileVers", matchSalaryFileVers);
            if (collectFileMap == null) continue;
            collectFileMap.putAll(fileMap);
        }
        LOG.info("SalaryFileServiceHelper matchSalaryFile {} is end", (Object)currTime);
        return params;
    }

    private void validateParam(List<Map<String, Object>> params) {
        String depEmpIdMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4ebaID\u201cdepEmpId\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"SalaryFileServiceHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        String salaryFileIdMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848ID\uff08salaryFileId\uff09\u7c7b\u578b\u5e94\u4e3aLong\u3002", (String)"SalaryFileServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        String payrollGrpIdMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4ID\uff08payrollGrpId\uff09\u7c7b\u578b\u5e94\u4e3aLong\u3002", (String)"SalaryFileServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String endDateMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u4e3a\u65e5\u671f\u7c7b\u578b\u3002", (String)"SalaryFileServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        String statusMsg = ResManager.loadKDString((String)"\u72b6\u6001\u201cstatus\u201d\u7c7b\u578b\u5e94\u4e3a\u201cList\u201d\u3002", (String)"SalaryFileServiceHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map<String, Object> param : params) {
            Object status;
            Object depEmpId = param.get("depEmpId");
            if (depEmpId == null) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, depEmpIdMsg);
                continue;
            }
            Object salaryFileId = param.get("salaryFileId");
            if (salaryFileId != null && !(salaryFileId instanceof Long)) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, salaryFileIdMsg);
                continue;
            }
            Object payrollGrpId = param.get("payrollGrpId");
            if (payrollGrpId != null && !(payrollGrpId instanceof Long)) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, payrollGrpIdMsg);
                continue;
            }
            Object endDate = param.get("endDate");
            if (endDate != null && !(endDate instanceof Date)) {
                try {
                    Date endDateNew = SWCDateTimeUtils.parseDate((String)String.valueOf(endDate));
                    param.put("endDate", endDateNew);
                }
                catch (ParseException ex) {
                    LOG.error((Throwable)ex);
                    param.put(KEY_SUCCESS, Boolean.FALSE);
                    param.put(KEY_MSG, endDateMsg);
                    continue;
                }
            }
            if ((status = param.get("status")) == null || status instanceof List) continue;
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, statusMsg);
        }
    }

    private List<Map<String, Object>> filterRightParams(List<Map<String, Object>> params) {
        return params.stream().filter(param -> {
            Object success = param.get(KEY_SUCCESS);
            return success == null || (Boolean)success != false;
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> matchSalaryFile(List<Map<String, Object>> params) {
        return this.matchSalaryFile(params, null);
    }

    private Map<Long, DynamicObject> queryfileMap(Map<Long, Long> entryFileRlsMap) {
        QFilter fileIdFilter = new QFilter("id", "in", entryFileRlsMap.values());
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] fileDys = fileHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{fileIdFilter});
        return Arrays.stream(fileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
    }

    private DynamicObject[] queryfileEmps(List<Map<String, Object>> params) {
        HashSet<String> status = new HashSet<String>(16);
        ArrayList<Long> depempList = new ArrayList<Long>(10);
        for (Map<String, Object> param : params) {
            depempList.add(Long.parseLong(String.valueOf(param.get("depEmpId"))));
            List statusTmp = (List)param.get("status");
            if (statusTmp != null) {
                status.addAll(statusTmp);
                continue;
            }
            status.add("C");
        }
        QFilter filterStatus = new QFilter("salaryfile.status", "in", status);
        QFilter filterDepemp = new QFilter("entryentity.workrole", "in", depempList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empposorgrel");
        return helper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_empposorgrel"), new QFilter[]{filterStatus, filterDepemp});
    }

    private Map<String, List<DynamicObject>> getFileMap(DynamicObject[] files, Map<Long, Long> entryFileRlsMap) {
        HashMap<String, List<DynamicObject>> fileMap = new HashMap<String, List<DynamicObject>>(10);
        ArrayList<DynamicObject> filesTemp = null;
        for (DynamicObject file : files) {
            DynamicObjectCollection entryentity = file.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String key = entry.getString("workrole.id");
                filesTemp = (ArrayList<DynamicObject>)fileMap.get(key);
                if (filesTemp == null) {
                    filesTemp = new ArrayList<DynamicObject>(10);
                    fileMap.put(key, filesTemp);
                }
                filesTemp.add(entry);
                entryFileRlsMap.put(entry.getLong("id"), file.getLong("salaryfile.id"));
            }
        }
        for (List vals : fileMap.values()) {
            vals.sort((o1, o2) -> {
                if (o1 != null && o2 != null && o1.getDate("paystartdate") != null && o2.getDate("paystartdate") != null) {
                    return o1.getDate("paystartdate").compareTo(o2.getDate("paystartdate"));
                }
                return 1;
            });
        }
        return fileMap;
    }

    public List<Map<String, Object>> matchSalaryFileAndValidate(List<Map<String, Object>> params) {
        List<Map<String, Object>> matchSalaryFile = this.matchSalaryFile(params);
        return matchSalaryFile;
    }

    public Set<Long> filterSalaryFileById(Set<Long> idSet) {
        Set<Long> salaryFileIdSet = new HashSet<Long>(idSet.size());
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("id", "in", idSet);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection coll = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (coll == null || coll.size() == 0) {
            return salaryFileIdSet;
        }
        salaryFileIdSet = coll.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        return salaryFileIdSet;
    }

    public Map<Long, Long> getSalaryFileIdAndOrgIdRelation(Set<Long> idSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection coll = helper.queryOriginalCollection("id,org", new QFilter[]{filter});
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(idSet.size());
        if (coll == null || coll.size() == 0) {
            return retMap;
        }
        for (DynamicObject dataObj : coll) {
            retMap.put(dataObj.getLong("id"), dataObj.getLong("org"));
        }
        return retMap;
    }
}

