/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.salaryslip.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.param.AppParam;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipPersonRecordDTO;
import kd.swc.hscs.business.mq.SalarySlipBatchPublisher;
import kd.swc.hscs.business.mq.SalarySlipReleaseSavePublisher;

public class CalSalarySlipUtils {
    private static final long ORGID = 100000L;
    private static final String VIEWTYPE = "15";
    private static int UNIT = 100;

    public static List<CalSalarySlipPersonRecordDTO> getCalTableRecordList(String salaryStatus, List<Long> calPersonList) {
        ArrayList<CalSalarySlipPersonRecordDTO> list = new ArrayList<CalSalarySlipPersonRecordDTO>(calPersonList.size());
        for (Long calPersonId : calPersonList) {
            CalSalarySlipPersonRecordDTO recordDTO = new CalSalarySlipPersonRecordDTO(salaryStatus, calPersonId);
            list.add(recordDTO);
        }
        return list;
    }

    public static void setCalSalarySlipList(String status, List<CalSalarySlipDTO> calSalarySlipList, String sendStatus) {
        for (CalSalarySlipDTO calSalarySlipDTO : calSalarySlipList) {
            Boolean isInvalidNotEdit;
            Boolean isUpdate;
            String userId = RequestContext.get().getUserId();
            Boolean bl = isUpdate = calSalarySlipDTO.getUpdate() == null ? Boolean.FALSE : calSalarySlipDTO.getUpdate();
            if (isUpdate.booleanValue()) {
                calSalarySlipDTO.setModifier(userId);
            } else {
                calSalarySlipDTO.setCreator(userId);
                calSalarySlipDTO.setCreatetime(new Date());
            }
            if (!"success".equals(status)) continue;
            calSalarySlipDTO.setIssend(sendStatus);
            Boolean bl2 = isInvalidNotEdit = calSalarySlipDTO.getInvalidNotEdit() == null ? Boolean.FALSE : calSalarySlipDTO.getInvalidNotEdit();
            if (!"1".equals(sendStatus) || isInvalidNotEdit.booleanValue()) continue;
            calSalarySlipDTO.setSendtime(new Date());
        }
    }

    public static AppParam getAppParam() {
        AppParam appParam = new AppParam();
        appParam.setAppId("/UHLXNRR9KPZ");
        appParam.setOrgId(Long.valueOf(100000L));
        appParam.setViewType(VIEWTYPE);
        return appParam;
    }

    public static int getThreadCalCount() {
        return UNIT;
    }

    public static void sendBatchCalMessage(Map<String, Object> params) {
        SalarySlipBatchPublisher.publishSalarySlipBatchMsg(params);
    }

    public static void sendSaveMessage(String recordId, String resultCacheKey) {
        HashMap<String, String> mqMap = new HashMap<String, String>(2);
        mqMap.put("calRecordId", recordId);
        mqMap.put("result_cache_key", resultCacheKey);
        SalarySlipReleaseSavePublisher.publishSaveReleaseResultMsg(mqMap);
    }

    public static MessagePublisher createAndGetPublisher(String region, String queueName) {
        return MQFactory.get().createSimplePublisher(region, queueName);
    }
}

