/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.vo.SWCOperationResult;
import kd.swc.hscs.business.addperson.helper.AddCalPersonHelper;
import kd.swc.hscs.business.addperson.service.CalAddPersonService;
import kd.swc.hscs.business.addperson.service.ProrationGenerateService;

public class RefreshCalPersonTask {
    private static final Log log = LogFactory.getLog(RefreshCalPersonTask.class);
    public static final int DEFAULT_SIZE = 500;
    private static final int THREAD_COUNT = 5;
    private static final String ADD_LIST = "addFileHisId";
    private static final String UPDATE_LIST = "updateFileHisId";
    private static final String DEL_LIST = "delCalPersonId";
    private static final String UPDATE_LIST_BOID = "updateFileBoId";
    private static final String EXCEPTION_FILE_BOIDS = "exceptionFileBoIds";
    public static final String SELECT_PROP = "id,startdate,enddate,calrulev.id,calrulev.opentaxcal,payrolldate,period,period.id,period.name,period.startdate,period.enddate,paydate,exratedate,calfrequency.id,calcount,payrollgroup.id,payrollgroupv.id,payrollgroupv.islssuepayslip,ishandleproration,payrollscene.id,payrollscenev.id,tasktype";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> arg1) throws KDException {
        Long calTaskId = (Long)arg1.get("calTaskId");
        List addFileIdList = (List)arg1.get(ADD_LIST);
        List delFileIdList = (List)arg1.get(DEL_LIST);
        List updateFileIdList = (List)arg1.get(UPDATE_LIST);
        List updateFileBoIdList = (List)arg1.get(UPDATE_LIST_BOID);
        List exceptionFileBoIds = (List)arg1.get(EXCEPTION_FILE_BOIDS);
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne(SELECT_PROP, (Object)calTaskId);
        RequestContext ctx = RequestContext.get();
        int size = addFileIdList.size();
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        progress.setPageSize(500);
        progress.setStartDate(new Date());
        progress.setFileIds(addFileIdList);
        SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
        addFileIdList.addAll(updateFileIdList);
        List subList = Lists.partition((List)addFileIdList, (int)500);
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            QFilter qFilter = new QFilter("calstatus", "=", (Object)String.valueOf(CalStateEnum.UNCAL.getCode()));
            QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
            QFilter idFilter = new QFilter("salaryfilev.id", "in", (Object)delFileIdList);
            QFilter salaryFileBoFilter = new QFilter("salaryfilev.boid", "in", (Object)updateFileBoIdList);
            DynamicObject[] calPersonIdColl = calPersonHelper.query("id", new QFilter[]{qFilter, idFilter, calTaskFilter});
            HashSet<Long> delCalPersonIdSet = new HashSet<Long>(calPersonIdColl.length);
            for (DynamicObject calPersonIdObj : calPersonIdColl) {
                delCalPersonIdSet.add(calPersonIdObj.getLong("id"));
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarydtmark");
            String field = "id,calpersonentry.calpersonid";
            QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
            filter.and("calpersonentry.calpersonid", "in", delCalPersonIdSet);
            DynamicObject[] markColl = helper.query(field, new QFilter[]{filter}, null);
            if (markColl != null && markColl.length > 0) {
                ArrayList<Long> delCalPersonEntryIdList = new ArrayList<Long>(10);
                for (DynamicObject markObj : markColl) {
                    DynamicObjectCollection calPersonEntry = markObj.getDynamicObjectCollection("calpersonentry");
                    for (DynamicObject calPersonObj : calPersonEntry) {
                        long calPersonId = calPersonObj.getLong("calpersonid");
                        if (!delCalPersonIdSet.contains(calPersonId)) continue;
                        delCalPersonEntryIdList.add(calPersonObj.getLong("id"));
                    }
                }
                if (delCalPersonEntryIdList != null && delCalPersonEntryIdList.size() > 0) {
                    String deleteSqlModel = "DELETE FROM T_HSAS_CALPERSONMARK WHERE FENTRYID IN ({0})";
                    int len = delCalPersonEntryIdList.size();
                    int partCount = len / 500;
                    if (partCount * 500 < len) {
                        ++partCount;
                    }
                    for (int index = 1; index <= partCount; ++index) {
                        int start = (index - 1) * 500;
                        int end = index * 500;
                        end = end > len ? len : end;
                        List partTaskIdList = delCalPersonEntryIdList.subList(start, end);
                        StringBuilder sb = new StringBuilder();
                        Iterator iterator = partTaskIdList.iterator();
                        while (iterator.hasNext()) {
                            sb.append(String.valueOf(iterator.next()));
                            if (!iterator.hasNext()) continue;
                            sb.append(',');
                        }
                        String deleteSql = MessageFormat.format(deleteSqlModel, sb.toString());
                        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteSql, (Object[])new Object[0]);
                    }
                }
            }
            HashSet<Long> deleteCalPersonIdSet = new HashSet<Long>(16);
            DynamicObjectCollection deleteCalPersons = calPersonHelper.queryOriginalCollection("id", new QFilter[]{qFilter, idFilter, calTaskFilter});
            if (!CollectionUtils.isEmpty((Collection)deleteCalPersons)) {
                deleteCalPersonIdSet.addAll(deleteCalPersons.stream().map(deleteCalPerson -> deleteCalPerson.getLong("id")).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)(deleteCalPersons = calPersonHelper.queryOriginalCollection("id", new QFilter[]{qFilter, salaryFileBoFilter, calTaskFilter})))) {
                deleteCalPersonIdSet.addAll(deleteCalPersons.stream().map(deleteCalPerson -> deleteCalPerson.getLong("id")).collect(Collectors.toSet()));
            }
            int delSuccess = calPersonHelper.deleteByFilter(new QFilter[]{qFilter, idFilter, calTaskFilter});
            calPersonHelper.deleteByFilter(new QFilter[]{qFilter, salaryFileBoFilter, calTaskFilter});
            ProrationGenerateService.deleteProration(deleteCalPersonIdSet);
            this.cleanPersonCoverData(deleteCalPersonIdSet);
            progress.setSuccess(progress.getSuccess() + delSuccess);
            if (subList.size() == 0) {
                progress.setEndDate(new Date());
                PayrollTaskHelper.updateCalpayrollTaskPersonCount((Long)calTaskId);
                progress.setStatus(2);
                SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").remove(String.format(Locale.ROOT, "cache_addperson_count_key_%s", calTaskId));
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_REFRESH.getOperationKey());
            }
            progress.setFinish(progress.getFinish() + delFileIdList.size());
            SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
            Map<Long, String> onHoldBillMap = AddCalPersonHelper.getOnHoldBillMap(calTaskId);
            boolean isPublishSalSlip = PayrollTaskHelper.isPublishPaySlip((DynamicObject)task);
            for (List fileIds : subList) {
                SWCThreadPoolFactory.getCalpersonSaveThreadPool().execute(() -> {
                    RequestContext.copyAndSet((RequestContext)ctx);
                    CalAddPersonService service = new CalAddPersonService(task, fileIds, onHoldBillMap, isPublishSalSlip);
                    service.setExceptionFilevs(new HashSet<Long>(exceptionFileBoIds));
                    Map<String, SWCOperationResult> result = service.batchAddCalPerson();
                    RefreshCalPersonTask.setProgressToCache(calTaskId, result, calTaskId);
                });
            }
            if (subList.size() <= 0) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_REFRESH.getOperationKey());
                CalPersonHelper.releaseLock((Long)calTaskId);
            }
        }
    }

    public static synchronized void setProgressToCache(long taskId, Map<String, SWCOperationResult> result, Long calTaskId) {
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), CalPersonAddProgressInfo.class);
        if (progress != null) {
            SWCOperationResult addpersonResult = result.get("addperson");
            int finishCount = progress.getFinish() + addpersonResult.getTotal();
            int successCount = progress.getSuccess() + addpersonResult.getSuccess();
            int failCount = progress.getFailMap().size() + addpersonResult.getFailMap().size();
            int remain = progress.getTotal() - finishCount;
            progress.getFailMap().putAll(addpersonResult.getFailMap());
            progress.setFinish(finishCount);
            progress.setSuccess(successCount);
            progress.setFail(failCount);
            progress.setRemain(remain);
            progress.setStatus(1);
            if (remain == 0) {
                PayrollTaskHelper.updateCalpayrollTaskPersonCount((Long)taskId);
                progress.setStatus(2);
                SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").remove(String.format(Locale.ROOT, "cache_addperson_count_key_%s", taskId));
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_REFRESH.getOperationKey());
                CalPersonHelper.releaseLock((Long)calTaskId);
            }
            SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").put(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), (Object)progress);
        }
    }

    private void cleanPersonCoverData(Set<Long> personIdSet) {
        if (CollectionUtils.isEmpty(personIdSet)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        QFilter filter = new QFilter("calperson", "in", personIdSet);
        helper.deleteByFilter(new QFilter[]{filter});
        helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        helper.deleteByFilter(new QFilter[]{filter});
    }
}

