/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.thread;

import java.text.MessageFormat;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serverless.api.JobRequest;
import kd.bos.serverless.api.ServerlessFactory;
import kd.swc.hscs.business.salaryslip.utils.CalSalarySlipUtils;

public class CalSalaryReleaseServerlessJobThreadTask
implements Runnable {
    private static final Log log = LogFactory.getLog(CalSalaryReleaseServerlessJobThreadTask.class);
    private RequestContext requestContext;
    private JobRequest jobTask;

    public CalSalaryReleaseServerlessJobThreadTask(JobRequest jobTask, RequestContext requestContext) {
        this.jobTask = jobTask;
        this.requestContext = requestContext;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        Map params = (Map)((Object)this.jobTask.getParam());
        String recordId = (String)params.get("calRecordId");
        String calBatchId = (String)params.get("calBatchId");
        log.info("submit serverless job begin,jobId={},calbatchId={}", (Object)this.jobTask.getJobid(), (Object)calBatchId);
        int timeout = 3600;
        boolean isSuccess = this.submit(calBatchId, recordId, timeout);
        if (!isSuccess) {
            CalSalarySlipUtils.sendBatchCalMessage(params);
        }
    }

    private boolean submit(String batchId, String recordId, int timeout) {
        boolean isSucess = true;
        String msg = null;
        try {
            ServerlessFactory.createSubmitter().submit(this.jobTask, timeout);
            msg = ResManager.loadKDString((String)"\u6279\u6b21\u4e3a\u201c{0}\u201d\u63d0\u4ea4\u6269\u5bb9\u6210\u529f\uff0c\u6269\u5bb9\u4efb\u52a1ID\u4e3a{1}\u3002", (String)"SalaryCalculateAsyncTask_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            log.info(MessageFormat.format(msg, batchId, this.jobTask.getJobid()));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            msg = ResManager.loadKDString((String)"\u6279\u6b21\u4e3a\u201c{0}\u201d\u63d0\u4ea4\u6269\u5bb9\u5931\u8d25\uff1a\u6269\u5bb9\u4efb\u52a1ID\u4e3a{1}\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a{2}\u3002", (String)"SalaryCalculateAsyncTask_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            log.error(MessageFormat.format(msg, batchId, this.jobTask.getJobid(), e.getMessage()));
            isSucess = false;
        }
        return isSucess;
    }
}

