/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.thread;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hsas.common.enums.SalaryItemTypeEnum;
import kd.sdk.swc.hsas.service.spi.CalResultQueryService;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.encrypt.util.CompressUtils;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipMSGDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipPersonRecordDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipRecordDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipViewDTO;
import kd.swc.hsbp.common.dto.salary.CalTaskInfo;
import kd.swc.hsbp.common.dto.salary.IssueFlowInfoDTO;
import kd.swc.hsbp.common.dto.salary.RepeatSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.SalaryCalTableDTO;
import kd.swc.hsbp.common.dto.salary.SalaryItemInfoDTO;
import kd.swc.hsbp.common.dto.salary.SalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.StructureSalaryDTO;
import kd.swc.hsbp.common.dto.salary.SummaryInfoDTO;
import kd.swc.hsbp.common.dto.salary.item.BaseItemInfoDTO;
import kd.swc.hsbp.common.dto.salary.item.BizItemInfoDTO;
import kd.swc.hsbp.common.dto.salary.item.FetchItemInfoDTO;
import kd.swc.hsbp.common.dto.salary.item.SupportItemInfoDTO;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.salaryslip.utils.CalSalarySlipUtils;
import org.apache.commons.collections.MapUtils;

public class CalSalaryReleaseThreadTask
implements Callable<String> {
    private static final Log log = LogFactory.getLog(CalSalaryReleaseThreadTask.class);
    private static final String RECOVER = "3";
    private static final String HIS_TAG = "2";
    private static final String INVALID = "4";
    private RequestContext requestContext;
    private List<Long> calList;
    private CalSalarySlipViewDTO salarySlipViewDTO;
    private String recordId;
    private CalTaskInfo calTaskInfo;
    private MultiEncryptNewService service;
    private String calBatchId;
    private String operationType;
    private Map<Long, Integer> dataprecisionMap;
    private Boolean isUseOldView;
    private Long userId;
    private String key;
    private DynamicObject salarySlipView;
    private List<Long> salaryFailList;

    public CalSalaryReleaseThreadTask(RequestContext requestContext, List<Long> calList, CalSalarySlipViewDTO salarySlipViewDTO, MultiEncryptNewService service, String calBatchId, String recordId, String operationType, CalTaskInfo taskInfo, Map<Long, Integer> dataprecisionMap, Boolean isUseOldView) {
        this.requestContext = requestContext;
        this.calList = calList;
        this.salarySlipViewDTO = salarySlipViewDTO;
        this.calTaskInfo = taskInfo;
        this.calBatchId = calBatchId;
        this.recordId = recordId;
        this.operationType = operationType;
        this.dataprecisionMap = dataprecisionMap;
        this.isUseOldView = isUseOldView;
        this.userId = requestContext.getCurrUserId();
        this.service = service;
        this.salaryFailList = new ArrayList<Long>(10);
    }

    @Override
    public String call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        String threadName = Thread.currentThread().getName();
        log.info("begin Release call,calBatchId={} ,thread name = {}", (Object)this.calBatchId, (Object)threadName);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", this.recordId));
        if (appCache == null) {
            log.error("get cache error,calBatchId", (Object)this.calBatchId);
            this.salarySlipFail(null);
            return null;
        }
        try {
            ParamObject paramObject = new ParamObject();
            List<DynamicObject> calPersonInfoArray = this.getCalPersonData(this.calList);
            Map<Long, DynamicObject> calPersonIdToCalPersonMap = this.findCalPersonByTaskId(calPersonInfoArray);
            paramObject.setCalPersonIdToCalPersonMap(calPersonIdToCalPersonMap);
            this.key = (String)appCache.get(String.format(Locale.ROOT, "cal_key_%s", this.recordId), String.class);
            if ("1".equals(this.operationType)) {
                this.salarySlipView = this.getSalarySlipView();
                this.getDataByCalTable(this.calTaskInfo.getTaskId(), calPersonInfoArray, paramObject);
                this.getItemResultBySalaryView(paramObject, calPersonInfoArray);
                this.firstRelease(paramObject);
            } else if (RECOVER.equals(this.operationType)) {
                if (this.isUseOldView.booleanValue()) {
                    this.getDataByUseOldView(calPersonInfoArray, this.calList, paramObject);
                    this.repeatReleaseUseOldView(paramObject);
                } else {
                    this.salarySlipView = this.getSalarySlipView();
                    this.getDataByCalTable(this.calTaskInfo.getTaskId(), calPersonInfoArray, paramObject);
                    this.getItemResultBySalaryView(paramObject, calPersonInfoArray);
                    this.repeatReleaseNotUseOldView(paramObject);
                }
            }
            if (this.salaryFailList.size() > 0) {
                this.salarySlipFail(this.salaryFailList, null);
            }
        }
        catch (Exception e) {
            log.error("Release call fail,calBatchId={},exception:{}", (Object)this.calBatchId, (Object)e);
            this.salarySlipFail(null);
        }
        return null;
    }

    private void getDataByCalTable(Long taskId, List<DynamicObject> calPersonInfoArray, ParamObject paramObject) {
        if (calPersonInfoArray.isEmpty()) {
            return;
        }
        ArrayList<Long> calResultIdList = new ArrayList<Long>(calPersonInfoArray.size());
        for (DynamicObject calPerson : calPersonInfoArray) {
            calResultIdList.add(calPerson.getLong("calresultid"));
        }
        DynamicObject[] calTableInfos = this.getCalTableData(calResultIdList);
        Map<Long, DynamicObject> calPersonIdToCalTableMap = this.findCalTableByTaskId(calTableInfos);
        Map<Long, List<DynamicObject>> calPersonIdToDetailMap = this.findDetailtByTaskId(taskId, this.calList);
        paramObject.setCalPersonIdToCalTableMap(calPersonIdToCalTableMap);
        paramObject.setCalPersonIdToDetailMap(calPersonIdToDetailMap);
    }

    private void getItemResultBySalaryView(ParamObject paramObject, List<DynamicObject> calPersonInfoArray) {
        HashMap<String, Map<Long, Set<Long>>> calPersonItemMap = new HashMap<String, Map<Long, Set<Long>>>(16);
        HashMap<Long, Long> calTableCalPersonMap = new HashMap<Long, Long>(calPersonInfoArray.size());
        for (DynamicObject calPerson : calPersonInfoArray) {
            this.getSalarySlipViewItemMap(this.salarySlipView, calPerson.getLong("id"), calPersonItemMap);
            calTableCalPersonMap.put(calPerson.getLong("calresultid"), calPerson.getLong("id"));
        }
        this.getItemResultDataMap(paramObject, calTableCalPersonMap, calPersonItemMap);
    }

    private void getDataByUseOldView(List<DynamicObject> calPersonInfoArray, List<Long> calList, ParamObject paramObject) {
        ArrayList<DynamicObject> calPersonInfoList = new ArrayList<DynamicObject>(calPersonInfoArray.size());
        Map<Long, DynamicObject> calPersonIdToSalarySlipMap = this.findSalarySlipByTaskIdList(calList);
        HashMap<Long, Long> calTableCalPersonMap = new HashMap<Long, Long>(calPersonInfoArray.size());
        for (DynamicObject calPerson2 : calPersonInfoArray) {
            DynamicObject salarySlipData = calPersonIdToSalarySlipMap.get(calPerson2.getLong("id"));
            if (!calPerson2.getDate("modifytime").after(salarySlipData.getDate("sendtime"))) continue;
            calPersonInfoList.add(calPerson2);
            calTableCalPersonMap.put(calPerson2.getLong("calresultid"), calPerson2.getLong("id"));
        }
        HashMap<Long, Long> calPersonIdToSalarySlipViewIdMap = new HashMap<Long, Long>(calPersonIdToSalarySlipMap.size());
        calPersonIdToSalarySlipMap.forEach((calPersonId, salarySlip) -> calPersonIdToSalarySlipViewIdMap.put((Long)calPersonId, salarySlip.getLong("salaryviewv")));
        Map<Long, Set<Long>> calPersonIdToSalaryItemIdMap = paramObject.getCalPersonIdToSalaryItemIdMap();
        if (calPersonIdToSalaryItemIdMap == null) {
            calPersonIdToSalaryItemIdMap = new HashMap<Long, Set<Long>>(calPersonIdToSalarySlipViewIdMap.size());
        }
        Map<Long, DynamicObject> calPersonIdToSalaryViewMap = this.findSalaryViewHisByTaskIdList(calPersonIdToSalarySlipViewIdMap, calPersonIdToSalaryItemIdMap);
        paramObject.setCalPersonIdToSalaryViewMap(calPersonIdToSalaryViewMap);
        paramObject.setCalPersonIdToSalaryItemIdMap(calPersonIdToSalaryItemIdMap);
        paramObject.setCalPersonIdToSalarySlipMap(calPersonIdToSalarySlipMap);
        this.getDataByCalTable(this.calTaskInfo.getTaskId(), calPersonInfoList, paramObject);
        HashMap<String, Map<Long, Set<Long>>> calPersonItemMap = new HashMap<String, Map<Long, Set<Long>>>(16);
        calTableCalPersonMap.forEach((calTable, calPerson) -> {
            DynamicObject salarySlipView = (DynamicObject)calPersonIdToSalaryViewMap.get(calPerson);
            this.getSalarySlipViewItemMap(salarySlipView, (Long)calPerson, (Map<String, Map<Long, Set<Long>>>)calPersonItemMap);
        });
        this.getItemResultDataMap(paramObject, calTableCalPersonMap, calPersonItemMap);
    }

    private String getNotEditRepeatData(DynamicObject salarySlipData, Date calTableModifyTime) {
        String structureSalary = null;
        Date sendTime = salarySlipData.getDate("sendtime");
        if (calTableModifyTime == null || calTableModifyTime.before(sendTime)) {
            structureSalary = salarySlipData.getString("salaryslipdata");
        }
        return structureSalary;
    }

    private Date getInvalidRepeatDate(DynamicObject salarySlipData, Date calTableModifyTime) {
        if (HIS_TAG.equals(this.calTaskInfo.getTaskType())) {
            return this.getSendTime();
        }
        String issend = salarySlipData.getString("issend");
        Date sendTime = salarySlipData.getDate("sendtime");
        Date sendTimeInvalidData = INVALID.equals(issend) && (calTableModifyTime == null || calTableModifyTime.before(sendTime)) ? sendTime : new Date();
        return sendTimeInvalidData;
    }

    private Date getSendTime() {
        Date payDate = this.calTaskInfo.getPayDate();
        Date date = new Date();
        if (payDate == null) {
            return date;
        }
        try {
            if (SWCDateTimeUtils.formatDateToDate((Date)payDate, (String)"yyyy-MM").after(SWCDateTimeUtils.formatDateToDate((Date)date, (String)"yyyy-MM"))) {
                return date;
            }
        }
        catch (ParseException e) {
            log.info("date error");
        }
        return payDate;
    }

    private Long getNotEditRepeatDataSalarySlip(DynamicObject salarySlipData, Date calTableModifyTime) {
        Date sendTime = salarySlipData.getDate("sendtime");
        if (calTableModifyTime == null || calTableModifyTime.before(sendTime)) {
            return salarySlipData.getLong("id");
        }
        return null;
    }

    private void firstRelease(ParamObject paramObject) throws Exception {
        SalarySlipDTO mainSalarySlipDTO = this.initSalarySlipDTO();
        Map<Long, DynamicObject> calPersonIdToCalPersonMap = paramObject.getCalPersonIdToCalPersonMap();
        Map<Long, List<BizItemInfoDTO>> bizItemResultMap = paramObject.getCalPersonToBizItemResultMap();
        Map<Long, List<FetchItemInfoDTO>> fetchItemResultMap = paramObject.getCalPersonToFetchItemResultMap();
        Map<Long, List<SupportItemInfoDTO>> supportItemResultMap = paramObject.getCalPersonToSupportItemResultMap();
        ArrayList<SalaryCalTableDTO> salaryCalTableDTOList = new ArrayList<SalaryCalTableDTO>(calPersonIdToCalPersonMap.size());
        ArrayList<CalSalarySlipDTO> calSalarySlipDTOList = new ArrayList<CalSalarySlipDTO>(calPersonIdToCalPersonMap.size());
        for (Map.Entry<Long, DynamicObject> entry : calPersonIdToCalPersonMap.entrySet()) {
            Long calPersonId = entry.getKey();
            DynamicObject calPersonInfo = entry.getValue();
            DynamicObject calTableInfo = (DynamicObject)paramObject.getCalPersonIdToCalTableMap().get(calPersonInfo.getLong("id"));
            CalSalarySlipDTO salarySlipData = new CalSalarySlipDTO();
            SalaryCalTableDTO salaryCalTableDTO = null;
            Long salaryviewId = this.salarySlipViewDTO.getSalaryviewId();
            Long salaryviewvId = this.salarySlipViewDTO.getSalaryviewvId();
            String caption = this.salarySlipViewDTO.getCaption();
            String remark = this.salarySlipViewDTO.getRemark();
            salaryCalTableDTO = this.setCalPersonValue(calPersonInfo, salaryviewId, salaryviewvId, caption, remark, salarySlipData);
            salarySlipData.setMsgdtos(this.salarySlipViewDTO.getMsgdtos());
            List subDetailList = (List)paramObject.getCalPersonIdToDetailMap().get(calPersonId);
            StructureSalaryDTO structureDTO = this.getStructureDTO(calTableInfo, subDetailList, this.salarySlipView, bizItemResultMap.get(calPersonId), fetchItemResultMap.get(calPersonId), supportItemResultMap.get(calPersonId));
            String structureJsonString = JSON.toJSONString((Object)structureDTO);
            long personId = calPersonInfo.getLong("employee.person.id");
            String encryptStructureStr = this.getEncryptString(personId, calPersonInfo.getLong("salaryfile.id"), structureJsonString);
            if (SWCStringUtils.isEmpty((String)encryptStructureStr)) {
                this.salaryFailList.add(calPersonId);
                continue;
            }
            salaryCalTableDTO.setStructureSumSalary(this.getSysEncryptString(JSON.toJSONString((Object)structureDTO.getSummaryInfoDTO())));
            salaryCalTableDTO.setStructureSalary(encryptStructureStr);
            salaryCalTableDTOList.add(salaryCalTableDTO);
            salarySlipData.setStructureJsonString(structureJsonString);
            salarySlipData.setIssend("0");
            calSalarySlipDTOList.add(salarySlipData);
        }
        if (this.isTerminateCal()) {
            return;
        }
        this.setSalarySlipId(salaryCalTableDTOList);
        mainSalarySlipDTO.setSalaryCalTableDTOList(salaryCalTableDTOList);
        String result = this.invokeMService(mainSalarySlipDTO);
        CalSalarySlipUtils.setCalSalarySlipList(result, calSalarySlipDTOList, "1");
        if ("success".equals(result)) {
            this.salarySlipSuccess(calSalarySlipDTOList);
        } else {
            this.salarySlipFail(calSalarySlipDTOList);
        }
    }

    private void repeatReleaseNotUseOldView(ParamObject paramObject) throws Exception {
        SalarySlipDTO mainSalarySlipDTO = this.initSalarySlipDTO();
        Map<Long, DynamicObject> calPersonIdToCalPersonMap = paramObject.getCalPersonIdToCalPersonMap();
        Map<Long, List<BizItemInfoDTO>> bizItemResultMap = paramObject.getCalPersonToBizItemResultMap();
        Map<Long, List<FetchItemInfoDTO>> fetchItemResultMap = paramObject.getCalPersonToFetchItemResultMap();
        Map<Long, List<SupportItemInfoDTO>> supportItemResultMap = paramObject.getCalPersonToSupportItemResultMap();
        ArrayList<SalaryCalTableDTO> salaryCalTableDTOList = new ArrayList<SalaryCalTableDTO>(calPersonIdToCalPersonMap.size());
        ArrayList<CalSalarySlipDTO> calSalarySlipDTOList = new ArrayList<CalSalarySlipDTO>(calPersonIdToCalPersonMap.size());
        for (Map.Entry<Long, DynamicObject> entry : calPersonIdToCalPersonMap.entrySet()) {
            Long calPersonId = entry.getKey();
            DynamicObject calPersonInfo = entry.getValue();
            DynamicObject calTableInfo = (DynamicObject)paramObject.getCalPersonIdToCalTableMap().get(calPersonInfo.getLong("id"));
            CalSalarySlipDTO salarySlipData = new CalSalarySlipDTO();
            SalaryCalTableDTO salaryCalTableDTO = this.getSalaryCalTableNotUseOldView(calPersonInfo, salarySlipData);
            String structureJsonString = null;
            Long salaryviewvId = this.salarySlipViewDTO.getSalaryviewvId();
            List subDetailList = (List)paramObject.getCalPersonIdToDetailMap().get(calPersonId);
            StructureSalaryDTO structureDTO = this.getStructureDTO(calTableInfo, subDetailList, this.salarySlipView, bizItemResultMap.get(calPersonId), fetchItemResultMap.get(calPersonId), supportItemResultMap.get(calPersonId));
            structureJsonString = JSON.toJSONString((Object)structureDTO);
            long personId = calPersonInfo.getLong("employee.person.id");
            String encryptStructureStr = this.getEncryptString(personId, calPersonInfo.getLong("salaryfile.id"), structureJsonString);
            if (SWCStringUtils.isEmpty((String)encryptStructureStr)) {
                this.salaryFailList.add(calPersonId);
                continue;
            }
            salaryCalTableDTO.setStructureSumSalary(this.getSysEncryptString(JSON.toJSONString((Object)structureDTO.getSummaryInfoDTO())));
            salaryCalTableDTO.setStructureSalary(encryptStructureStr);
            salaryCalTableDTOList.add(salaryCalTableDTO);
            salarySlipData.setStructureJsonString(structureJsonString);
            salarySlipData.setIssend("0");
            calSalarySlipDTOList.add(salarySlipData);
        }
        if (this.isTerminateCal()) {
            return;
        }
        this.setSalarySlipId(salaryCalTableDTOList);
        mainSalarySlipDTO.setSalaryCalTableDTOList(salaryCalTableDTOList);
        String result = this.invokeMService(mainSalarySlipDTO);
        CalSalarySlipUtils.setCalSalarySlipList(result, calSalarySlipDTOList, "1");
        if ("success".equals(result)) {
            this.salarySlipSuccess(calSalarySlipDTOList);
        } else {
            this.salarySlipFail(calSalarySlipDTOList);
        }
    }

    private void repeatReleaseUseOldView(ParamObject paramObject) throws Exception {
        Map<Long, DynamicObject> calPersonIdToCalPersonMap = paramObject.getCalPersonIdToCalPersonMap();
        ArrayList<RepeatSalarySlipDTO> repeatSalarySlipDTOList = new ArrayList<RepeatSalarySlipDTO>(calPersonIdToCalPersonMap.size());
        ArrayList<CalSalarySlipDTO> calSalarySlipDTOList = new ArrayList<CalSalarySlipDTO>(calPersonIdToCalPersonMap.size());
        for (Map.Entry<Long, DynamicObject> entry : calPersonIdToCalPersonMap.entrySet()) {
            StructureSalaryDTO structureDTO;
            Long calPersonId = entry.getKey();
            DynamicObject calPersonInfo = entry.getValue();
            CalSalarySlipDTO salarySlipData = new CalSalarySlipDTO();
            DynamicObject salarySlip = (DynamicObject)paramObject.getCalPersonIdToSalarySlipMap().get(calPersonId);
            DynamicObject viewObj = (DynamicObject)paramObject.getCalPersonIdToSalaryViewMap().get(calPersonId);
            SalaryCalTableDTO salaryCalTableDTO = this.getSalaryCalTableUseOldView(calPersonInfo, salarySlip, salarySlipData, viewObj);
            Long salaryviewvId = salarySlip.getLong("salaryviewv");
            String structureJsonString = this.getNotEditRepeatData(salarySlip, calPersonInfo.getDate("modifytime"));
            if (SWCStringUtils.isEmpty((String)structureJsonString)) {
                DynamicObject calTableInfo = (DynamicObject)paramObject.getCalPersonIdToCalTableMap().get(calPersonInfo.getLong("id"));
                List<DynamicObject> subDetailList = (List<DynamicObject>)paramObject.getCalPersonIdToDetailMap().get(calPersonId);
                if (calTableInfo == null) {
                    Long calResultId = calPersonInfo.getLong("calresultid");
                    DynamicObject[] calTableData = this.getCalTableData(Collections.singletonList(calResultId));
                    if (calTableData == null || calTableData.length == 0) {
                        this.salaryFailList.add(calPersonId);
                        continue;
                    }
                    calTableInfo = calTableData[0];
                    if (subDetailList == null) {
                        Map<Long, List<DynamicObject>> calPersonIdToDetailMap = this.findDetailtByTaskId(this.calTaskInfo.getTaskId(), Collections.singletonList(calPersonId));
                        subDetailList = calPersonIdToDetailMap.get(calPersonId);
                    }
                }
                Map<Long, List<BizItemInfoDTO>> bizItemResultMap = paramObject.getCalPersonToBizItemResultMap();
                Map<Long, List<FetchItemInfoDTO>> fetchItemResultMap = paramObject.getCalPersonToFetchItemResultMap();
                Map<Long, List<SupportItemInfoDTO>> supportItemResultMap = paramObject.getCalPersonToSupportItemResultMap();
                structureDTO = this.getStructureDTO(calTableInfo, subDetailList, viewObj, bizItemResultMap.get(calPersonId), fetchItemResultMap.get(calPersonId), supportItemResultMap.get(calPersonId));
                structureJsonString = JSON.toJSONString((Object)structureDTO);
            } else {
                structureDTO = (StructureSalaryDTO)JSON.parseObject((String)structureJsonString, StructureSalaryDTO.class);
            }
            long personId = calPersonInfo.getLong("employee.person.id");
            String encryptStructureStr = this.getEncryptString(personId, calPersonInfo.getLong("salaryfile.id"), structureJsonString);
            if (SWCStringUtils.isEmpty((String)encryptStructureStr)) {
                this.salaryFailList.add(calPersonId);
                continue;
            }
            salaryCalTableDTO.setStructureSumSalary(this.getSysEncryptString(JSON.toJSONString((Object)structureDTO.getSummaryInfoDTO())));
            salaryCalTableDTO.setStructureSalary(encryptStructureStr);
            RepeatSalarySlipDTO repeatSalarySlipDTO = this.getRepeatSalarySlipDTO(salarySlip, viewObj);
            repeatSalarySlipDTO.setSalaryCalTableDTO(salaryCalTableDTO);
            repeatSalarySlipDTO.setSendTime(this.getInvalidRepeatDate(salarySlip, calPersonInfo.getDate("modifytime")));
            repeatSalarySlipDTOList.add(repeatSalarySlipDTO);
            salarySlipData.setStructureJsonString(structureJsonString);
            salarySlipData.setIssend("0");
            calSalarySlipDTOList.add(salarySlipData);
        }
        if (this.isTerminateCal()) {
            return;
        }
        this.setRepeatSalarySlipId(repeatSalarySlipDTOList);
        String result = this.invokeRepeatService(repeatSalarySlipDTOList);
        CalSalarySlipUtils.setCalSalarySlipList(result, calSalarySlipDTOList, "1");
        if ("success".equals(result)) {
            this.salarySlipSuccess(calSalarySlipDTOList);
        } else {
            this.salarySlipFail(calSalarySlipDTOList);
        }
    }

    private void setSalarySlipId(List<SalaryCalTableDTO> salaryCalTableList) {
        long[] calendarIds = DB.genLongIds((String)"hspp_salarycalendar", (int)salaryCalTableList.size());
        for (int index = 0; index < salaryCalTableList.size(); ++index) {
            SalaryCalTableDTO salaryCalTable = salaryCalTableList.get(index);
            salaryCalTable.setSalarySlipCalendarId(Long.valueOf(calendarIds[index]));
        }
    }

    private void setRepeatSalarySlipId(List<RepeatSalarySlipDTO> repeatSalarySlipDTOList) {
        long[] calendarIds = DB.genLongIds((String)"hspp_salarycalendar", (int)repeatSalarySlipDTOList.size());
        for (int index = 0; index < repeatSalarySlipDTOList.size(); ++index) {
            RepeatSalarySlipDTO salaryCalTable = repeatSalarySlipDTOList.get(index);
            salaryCalTable.getSalaryCalTableDTO().setSalarySlipCalendarId(Long.valueOf(calendarIds[index]));
        }
    }

    private StructureSalaryDTO getStructureDTO(DynamicObject calTableInfo, List<DynamicObject> subDetailList, DynamicObject salarySlipView, List<BizItemInfoDTO> bizItemInfoList, List<FetchItemInfoDTO> fetchItemInfoList, List<SupportItemInfoDTO> supportItemInfoList) {
        ArrayList<SalaryItemInfoDTO> salaryItemInfoDTOList = new ArrayList<SalaryItemInfoDTO>();
        SummaryInfoDTO summaryInfoDTO = new SummaryInfoDTO();
        ArrayList<IssueFlowInfoDTO> issueFlowInfoDTOList = new ArrayList<IssueFlowInfoDTO>();
        Long calCurrencyId = this.calTaskInfo.getCalCurrencyId();
        BigDecimal allCalAmount = this.composeItem(salaryItemInfoDTOList, calTableInfo, summaryInfoDTO);
        summaryInfoDTO.setPayAmount(allCalAmount.toString()).setCalCurrencyId(calCurrencyId);
        if (subDetailList != null && salarySlipView.getBoolean("isshowpayflow")) {
            for (DynamicObject subDetailObject : subDetailList) {
                if (subDetailObject.getBoolean("ismustbankcard") && subDetailObject.getLong("perbankcard.id") == 0L) {
                    issueFlowInfoDTOList.clear();
                    break;
                }
                this.setPayDetailValue(issueFlowInfoDTOList, subDetailObject);
            }
        }
        StructureSalaryDTO structureSalaryDTO = new StructureSalaryDTO();
        structureSalaryDTO.setSalaryItemInfoDTOList(salaryItemInfoDTOList).setSummaryInfoDTO(summaryInfoDTO).setIssueFlowInfoDTOList(issueFlowInfoDTOList);
        structureSalaryDTO.setBizItemInfoDTOList(bizItemInfoList);
        structureSalaryDTO.setFetchItemInfoDTOList(fetchItemInfoList);
        structureSalaryDTO.setSupportItemInfoDTOList(supportItemInfoList);
        return structureSalaryDTO;
    }

    private SalaryCalTableDTO getSalaryCalTableNotUseOldView(DynamicObject calTableInfo, CalSalarySlipDTO salarySlipData) {
        Long salaryviewId = this.salarySlipViewDTO.getSalaryviewId();
        Long salaryviewvId = this.salarySlipViewDTO.getSalaryviewvId();
        String caption = this.salarySlipViewDTO.getCaption();
        String remark = this.salarySlipViewDTO.getRemark();
        salarySlipData.setMsgdtos(this.salarySlipViewDTO.getMsgdtos());
        return this.setCalPersonValue(calTableInfo, salaryviewId, salaryviewvId, caption, remark, salarySlipData);
    }

    private SalaryCalTableDTO getSalaryCalTableUseOldView(DynamicObject calTableInfo, DynamicObject salarySlip, CalSalarySlipDTO salarySlipData, DynamicObject viewObj) {
        Long salaryviewId = salarySlip.getLong("salaryview.id");
        Long salaryviewvId = salarySlip.getLong("salaryviewv");
        String caption = salarySlip.getString("caption");
        String remark = salarySlip.getString("remark");
        salarySlipData.setMsgdtos(this.getMsgdtos(viewObj));
        Long id = this.getNotEditRepeatDataSalarySlip(salarySlip, calTableInfo.getDate("modifytime"));
        if (id != null) {
            salarySlipData.setPrimaryKey(id);
            salarySlipData.setUpdate(Boolean.TRUE);
            String issend = salarySlip.getString("issend");
            if (INVALID.equals(issend)) {
                salarySlipData.setInvalidNotEdit(Boolean.TRUE);
            }
        }
        SalaryCalTableDTO salaryCalTableDTO = this.setCalPersonValue(calTableInfo, salaryviewId, salaryviewvId, caption, remark, salarySlipData);
        return salaryCalTableDTO;
    }

    private List<CalSalarySlipMSGDTO> getMsgdtos(DynamicObject viewObj) {
        ArrayList<CalSalarySlipMSGDTO> msgdtos = new ArrayList<CalSalarySlipMSGDTO>(10);
        boolean ispushnotify = viewObj.getBoolean("ispushnotify");
        if (ispushnotify) {
            DynamicObject[] query;
            ArrayList<Long> msgIds = new ArrayList<Long>();
            DynamicObjectCollection msgs = viewObj.getDynamicObjectCollection("msgtemplate");
            for (DynamicObject msg : msgs) {
                Long id = msg.getLong("fbasedataid_id");
                msgIds.add(id);
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("msg_template");
            QFilter filter = new QFilter("id", "in", msgIds);
            for (DynamicObject msg : query = helper.query("msgchannel,msgscenevalue", new QFilter[]{filter})) {
                String channel = msg.getString("msgchannel");
                String msgscene = "hsas_releasesalaryslip";
                CalSalarySlipMSGDTO msgdto = new CalSalarySlipMSGDTO();
                msgdto.setNotifyType(channel);
                msgdto.setTplScenel(msgscene);
                msgdtos.add(msgdto);
            }
        }
        return msgdtos;
    }

    private RepeatSalarySlipDTO getRepeatSalarySlipDTO(DynamicObject salarySlip, DynamicObject viewObj) {
        RepeatSalarySlipDTO salarySlipDTO = new RepeatSalarySlipDTO();
        Long salaryviewId = salarySlip.getLong("salaryview.id");
        Long salaryviewvId = salarySlip.getLong("salaryviewv");
        String caption = salarySlip.getString("caption");
        String remark = salarySlip.getString("remark");
        int invalidDay = viewObj.getInt("validduration");
        if (viewObj.getBoolean("isunlimited")) {
            invalidDay = -1;
        }
        Date invalidTime = this.getInvalidDate(invalidDay);
        salarySlipDTO.setSalaryViewId(salaryviewId.longValue()).setSalaryViewVId(salaryviewvId.longValue()).setCaption(caption).setRemark(remark).setEncryptLevel(this.salarySlipViewDTO.getEncryptLevel().getCode()).setEncryptType(this.salarySlipViewDTO.getEncryptType().getCode()).setInvalidTime(invalidTime).setCurrUserId(this.userId).setSalarySlipSumViewList(this.calTaskInfo.getSalarySlipSumViewList()).setEncryptId(this.service.getEncryptId()).setSecretkeyId(this.service.getSecretKeyId());
        return salarySlipDTO;
    }

    private DynamicObject[] getCalTableData(List<Long> calList) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calList);
        DynamicObject[] dynamicObjects = calTableHelper.query("id,calpersonid,hsas_caltableentry.salaryitem,hsas_caltableentry.calamountvalue,hsas_caltableentry.textvalue,hsas_caltableentry.numvalue,hsas_caltableentry.datevalue,hsas_caltableentry.isnull,hsas_caltableentry.slprorationindex", new QFilter[]{filter});
        return dynamicObjects;
    }

    private DynamicObject getSalarySlipView() {
        QFilter filter = new QFilter("id", "in", (Object)this.salarySlipViewDTO.getSalaryviewvId());
        SWCDataServiceHelper viewHisHelper = new SWCDataServiceHelper("hsbs_salaryslipview");
        return viewHisHelper.queryOne("id,isshowpayflow,itemcategory,item.id", new QFilter[]{filter});
    }

    private void getSalarySlipViewItemMap(DynamicObject salarySlipView, Long calPersonId, Map<String, Map<Long, Set<Long>>> itemMap) {
        DynamicObjectCollection entryEntity = salarySlipView.getDynamicObjectCollection("entryentity");
        entryEntity.forEach(entry -> {
            DynamicObjectCollection subEntryCol = entry.getDynamicObjectCollection("subentryentity");
            if (!CollectionUtils.isEmpty((Collection)subEntryCol)) {
                subEntryCol.forEach(obj -> {
                    String itemCategory = obj.getString("itemcategory");
                    Map calPersonItemMap = itemMap.computeIfAbsent(itemCategory, key -> new HashMap(16));
                    Set itemIdSet = calPersonItemMap.computeIfAbsent(calPersonId, key -> new HashSet(16));
                    itemIdSet.add(obj.getLong("item.id"));
                });
            }
        });
    }

    private List<DynamicObject> getCalPersonData(List<Long> calList) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calList);
        DynamicObject[] dynamicObjects = calTableHelper.query("id,employee.person.id,salarystatus,salaryfile.id,salaryfilev.id,modifytime,calresultid", new QFilter[]{filter});
        return Arrays.asList(dynamicObjects);
    }

    private void getItemResultDataMap(ParamObject paramObject, Map<Long, Long> calTableCalPersonMap, Map<String, Map<Long, Set<Long>>> calPersonItemMap) {
        Map bizItemResultMap = paramObject.getCalPersonToBizItemResultMap();
        this.getCalItemResultMap(calTableCalPersonMap, "hsbs_bizitem", calPersonItemMap.get("hsbs_bizitem"), bizItemResultMap);
        Map fetchItemResultMap = paramObject.getCalPersonToFetchItemResultMap();
        this.getCalItemResultMap(calTableCalPersonMap, "hsbs_fetchitem", calPersonItemMap.get("hsbs_fetchitem"), fetchItemResultMap);
        Map supportItemResultMap = paramObject.getCalPersonToSupportItemResultMap();
        this.getCalItemResultMap(calTableCalPersonMap, "hsbs_supportitem", calPersonItemMap.get("hsbs_supportitem"), supportItemResultMap);
    }

    private <T extends BaseItemInfoDTO> void getCalItemResultMap(Map<Long, Long> calTableCalPersonMap, String entityCode, Map<Long, Set<Long>> calPersonItemIdMap, Map<Long, List<T>> calItemResult) {
        if (CollectionUtils.isEmpty(calPersonItemIdMap)) {
            return;
        }
        String code = SalaryItemTypeEnum.getCodeByEntityCode((String)entityCode);
        List itemIds = calPersonItemIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (SWCStringUtils.isNotEmpty((String)code) && !CollectionUtils.isEmpty(itemIds)) {
            CalResultQueryService calResultQueryService = CalResultQueryService.get();
            Map calItemMap = calResultQueryService.getCalItemMap(code, itemIds);
            Map itemResultDataMap = calResultQueryService.getCalResultByCalTableId(new ArrayList<Long>(calTableCalPersonMap.keySet()), code, calItemMap);
            itemResultDataMap.forEach((calTableId, itemResult) -> {
                Long calPersonId = (Long)calTableCalPersonMap.get(calTableId);
                if (calPersonId != null) {
                    List itemInfoResult = calItemResult.computeIfAbsent(calPersonId, key -> new ArrayList(itemResult.size()));
                    Set itemNeedSet = calPersonItemIdMap.getOrDefault(calPersonId, new HashSet(16));
                    itemResult.forEach((itemId, result) -> {
                        if (itemNeedSet.contains(itemId)) {
                            Object itemInfo = this.buildItemInfo(entityCode, calItemMap, (Long)itemId, result);
                            itemInfoResult.add(itemInfo);
                        }
                    });
                }
            });
        }
    }

    private <T extends BaseItemInfoDTO> T buildItemInfo(String entityCode, Map<Long, Map<String, Object>> calItemMap, Long itemId, Object value) {
        BizItemInfoDTO itemInfoDTO;
        Map<String, Object> itemDataMap = calItemMap.get(itemId);
        switch (entityCode) {
            case "hsbs_bizitem": {
                itemInfoDTO = new BizItemInfoDTO();
                break;
            }
            case "hsbs_fetchitem": {
                itemInfoDTO = new FetchItemInfoDTO();
                break;
            }
            case "hsbs_supportitem": {
                itemInfoDTO = new SupportItemInfoDTO();
                break;
            }
            default: {
                itemInfoDTO = new BaseItemInfoDTO();
            }
        }
        itemInfoDTO.setItemId(itemId);
        this.getItemValue(itemDataMap, value, (BaseItemInfoDTO)itemInfoDTO);
        return (T)itemInfoDTO;
    }

    private void getItemValue(Map<String, Object> itemDataMap, Object value, BaseItemInfoDTO itemInfoDTO) {
        String itemValue;
        String storageType = MapUtils.getString(itemDataMap, (Object)"storageType");
        itemInfoDTO.setShowType(storageType);
        switch (storageType) {
            case "text": {
                itemValue = String.valueOf(value);
                break;
            }
            case "date": {
                itemValue = value instanceof Date ? SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd") : "";
                break;
            }
            case "num": {
                int scale = MapUtils.getIntValue(itemDataMap, (Object)"scale");
                Long dataRoundId = MapUtils.getLong(itemDataMap, (Object)"dataround", (Long)1010L);
                itemValue = value instanceof BigDecimal ? this.setBigDecimalScale((BigDecimal)value, scale, dataRoundId) : "";
                break;
            }
            case "amount": {
                Integer calCurrencyScale = this.calTaskInfo.getCalCurrencyScale();
                itemValue = value instanceof BigDecimal ? this.setBigDecimalScale((BigDecimal)value, calCurrencyScale, 1010L) : "";
                itemInfoDTO.setCalCurrencyId(this.calTaskInfo.getCalCurrencyId());
                break;
            }
            default: {
                itemValue = "";
            }
        }
        itemInfoDTO.setValue(itemValue);
    }

    private SalarySlipDTO initSalarySlipDTO() {
        long salaryviewId = this.salarySlipViewDTO.getSalaryviewId();
        long salaryviewvId = this.salarySlipViewDTO.getSalaryviewvId();
        String caption = this.salarySlipViewDTO.getCaption();
        String remark = this.salarySlipViewDTO.getRemark();
        String encryptLevel = this.salarySlipViewDTO.getEncryptLevel().getCode();
        String encryptType = this.salarySlipViewDTO.getEncryptType().getCode();
        Date invalidTime = this.salarySlipViewDTO.getInvalidTime();
        Long currUserId = this.userId;
        Date sendTime = HIS_TAG.equals(this.calTaskInfo.getTaskType()) ? this.getSendTime() : new Date();
        SalarySlipDTO mainSalarySlipDTO = new SalarySlipDTO();
        mainSalarySlipDTO.setSalaryViewId(salaryviewId).setSalaryViewVId(salaryviewvId).setCaption(caption).setRemark(remark).setEncryptLevel(encryptLevel).setEncryptType(encryptType).setInvalidTime(invalidTime).setSendTime(sendTime).setCurrUserId(currUserId).setSalarySlipSumViewList(this.calTaskInfo.getSalarySlipSumViewList()).setEncryptId(this.service.getEncryptId()).setSecretkeyId(this.service.getSecretKeyId());
        return mainSalarySlipDTO;
    }

    private Map<Long, DynamicObject> findCalTableByTaskId(DynamicObject[] calList) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(calList.length);
        for (DynamicObject dynamicObject : calList) {
            Long calPersonId = dynamicObject.getLong("calpersonid");
            resultMap.put(calPersonId, dynamicObject);
        }
        return resultMap;
    }

    private Map<Long, DynamicObject> findCalPersonByTaskId(List<DynamicObject> calList) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(calList.size());
        for (DynamicObject dynamicObject : calList) {
            Long calPersonId = dynamicObject.getLong("id");
            resultMap.put(calPersonId, dynamicObject);
        }
        return resultMap;
    }

    private Map<Long, List<DynamicObject>> findDetailtByTaskId(Long taskId, List<Long> calList) {
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("caltask.id", "=", (Object)taskId);
        filter.and(new QFilter("calpersonid", "in", calList));
        filter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        DynamicObject[] detailObjects = detailHelper.query("calpersonid,salaryitem.id,calcurrency.id,calamount,paytype,payamount,paycurrency.id,paycurrency.amtprecision,ismustbankcard,salaryitem.dataprecision,perbankcard", new QFilter[]{filter});
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(calList.size());
        if (detailObjects.length > 0) {
            HashMap<Long, List> detailsMap = new HashMap<Long, List>(detailObjects.length);
            for (DynamicObject detail : detailObjects) {
                Long calPersonId = detail.getLong("calpersonid");
                List list = detailsMap.getOrDefault(calPersonId, new ArrayList(10));
                list.add(detail);
                detailsMap.put(calPersonId, list);
            }
            for (Long calPersonId : calList) {
                ArrayList detailObjct = (ArrayList)detailsMap.get(calPersonId);
                ArrayList detailList = detailObjct != null ? detailObjct : new ArrayList(10);
                resultMap.put(calPersonId, detailList);
            }
        }
        return resultMap;
    }

    private Map<Long, DynamicObject> findSalarySlipByTaskIdList(List<Long> calIdList) {
        DynamicObject[] arrays;
        HashMap<Long, DynamicObject> calPersonIdToSalarySlipMap = new HashMap<Long, DynamicObject>(calIdList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryslip");
        QFilter filter = new QFilter("calpersonid", "in", calIdList);
        filter.and(new QFilter("islastversion", "=", (Object)"1"));
        for (DynamicObject dynamicObject : arrays = helper.query("id,calpersonid,salaryview,salaryviewv,caption,remark,sendtime,encryptlevel,encrypttype,issend,salaryslipdata,modifier,modifytime", new QFilter[]{filter}, "calpersonid asc,sendtime asc")) {
            Long calPersonId = dynamicObject.getLong("calpersonid");
            calPersonIdToSalarySlipMap.put(calPersonId, dynamicObject);
        }
        return calPersonIdToSalarySlipMap;
    }

    private Map<Long, DynamicObject> findSalaryViewHisByTaskIdList(Map<Long, Long> calPersonIdToSalarySlipViewIdMap, Map<Long, Set<Long>> calPersonIdToSalaryItemIdMap) {
        HashMap<Long, DynamicObject> calPersonIdToSalaryViewMap = new HashMap<Long, DynamicObject>(calPersonIdToSalarySlipViewIdMap.size());
        QFilter filter = new QFilter("id", "in", calPersonIdToSalarySlipViewIdMap.values());
        SWCDataServiceHelper viewHisHelper = new SWCDataServiceHelper("hsbs_salaryslipview");
        DynamicObject[] arrays = viewHisHelper.query("id,validduration,isunlimited,ispushnotify,msgtemplate,isshowpayflow,itemcategory,item.id", new QFilter[]{filter});
        HashMap<Long, DynamicObject> salaryViewMap = new HashMap<Long, DynamicObject>(calPersonIdToSalarySlipViewIdMap.size());
        for (DynamicObject dynamicObject : arrays) {
            Long salaryViewId2 = dynamicObject.getLong("id");
            salaryViewMap.put(salaryViewId2, dynamicObject);
        }
        calPersonIdToSalarySlipViewIdMap.forEach((calPersonId, salaryViewId) -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)calPersonIdToSalaryViewMap.put((Long)calPersonId, (DynamicObject)salaryViewMap.get(salaryViewId));
        });
        return calPersonIdToSalaryViewMap;
    }

    private SalaryCalTableDTO setCalPersonValue(DynamicObject calPersonObject, Long salaryviewId, Long salaryviewvId, String caption, String remark, CalSalarySlipDTO salarySlipData) {
        SalaryCalTableDTO salaryCalTableDTO = new SalaryCalTableDTO();
        long primaryKey = salarySlipData.getPrimaryKey() == null ? this.getEntityPrimaryKey("hsas_salaryslip") : salarySlipData.getPrimaryKey().longValue();
        long personId = calPersonObject.getLong("employee.person.id");
        long salaryfileId = calPersonObject.getLong("salaryfile.id");
        long salaryfilevId = calPersonObject.getLong("salaryfilev.id");
        Date payrolldate = this.calTaskInfo.getPayrollDate();
        long calcount = this.calTaskInfo.getCalCount();
        Date startdate = this.calTaskInfo.getStartDate();
        Date enddate = this.calTaskInfo.getEndDate();
        Date payDate = this.calTaskInfo.getPayDate();
        salarySlipData.setPersonId(Long.valueOf(personId));
        salarySlipData.setCalpersonId(Long.valueOf(calPersonObject.getLong("id")));
        if (salarySlipData.getUpdate() == null || !salarySlipData.getUpdate().booleanValue()) {
            salarySlipData.setUpdate(Boolean.FALSE);
            salarySlipData.setPrimaryKey(Long.valueOf(primaryKey));
            salarySlipData.setSalaryfileId(Long.valueOf(salaryfileId));
            salarySlipData.setSalaryfilevId(Long.valueOf(salaryfilevId));
            salarySlipData.setPayrolldate(payrolldate);
            salarySlipData.setCalcount(Long.valueOf(calcount));
            salarySlipData.setStartdate(startdate);
            salarySlipData.setEnddate(enddate);
            salarySlipData.setCaption(caption);
            salarySlipData.setRemark(remark);
            salarySlipData.setSalaryviewId(salaryviewId);
            salarySlipData.setSalaryviewvId(salaryviewvId);
            salarySlipData.setEncryptLevel(this.salarySlipViewDTO.getEncryptLevel().getCode());
            salarySlipData.setEncryptType(this.salarySlipViewDTO.getEncryptType().getCode());
            salarySlipData.setCaltableId(Long.valueOf(calPersonObject.getLong("calresultid")));
            salarySlipData.setLastVersion(Boolean.TRUE);
        }
        salaryCalTableDTO.setSlipId(primaryKey).setPersonId(personId).setSalaryFileId(salaryfileId).setSalaryFileVId(salaryfilevId).setPayRollDate(payrolldate).setCalCount(calcount).setStartDate(startdate).setEndDate(enddate).setPayrollgroupId(this.calTaskInfo.getPayrollgroupId()).setPayDate(payDate);
        return salaryCalTableDTO;
    }

    private long getEntityPrimaryKey(String entityName) {
        return ORM.create().genLongId(entityName);
    }

    private BigDecimal composeItem(List<SalaryItemInfoDTO> salaryItemInfoDTOList, DynamicObject calTableObject, SummaryInfoDTO summaryInfoDTO) {
        BigDecimal allCalAmount = BigDecimal.ZERO;
        if (calTableObject == null) {
            return allCalAmount;
        }
        DynamicObjectCollection calTableEntryColl = calTableObject.getDynamicObjectCollection("hsas_caltableentry");
        for (DynamicObject dynamicObject : calTableEntryColl) {
            if (dynamicObject.getInt("slprorationindex") != 0) continue;
            Integer scaleInteger = this.dataprecisionMap.get(dynamicObject.getLong("salaryitem.dataprecision.id"));
            Long dataRoundId = dynamicObject.getLong("salaryitem.dataround.id");
            int scale = scaleInteger == null ? 0 : scaleInteger;
            Integer calCurrencyScale = this.calTaskInfo.getCalCurrencyScale();
            long salaryItemId = dynamicObject.getLong("salaryitem.id");
            BigDecimal calamount = dynamicObject.getBigDecimal("calamountvalue");
            SalaryItemInfoDTO salaryItemInfoDTO = new SalaryItemInfoDTO();
            salaryItemInfoDTO.setSalaryItemId(salaryItemId).setCalCurrencyId(this.calTaskInfo.getCalCurrencyId().longValue()).setCalAmount(this.setBigDecimalScale(calamount, calCurrencyScale, 1010L)).setTextValue(dynamicObject.getString("textvalue")).setNumValue(this.setBigDecimalScale(dynamicObject.getBigDecimal("numvalue"), scale, dataRoundId)).setDateValue(dynamicObject.getDate("datevalue") == null ? "" : SWCDateTimeUtils.format((Date)dynamicObject.getDate("datevalue"), (String)"yyyy-MM-dd")).setBoolValue(dynamicObject.getString("textvalue")).setNull(dynamicObject.getBoolean("isnull"));
            salaryItemInfoDTOList.add(salaryItemInfoDTO);
            if (this.calTaskInfo.getPayItemIdSet().contains(salaryItemId)) {
                allCalAmount = allCalAmount.add(calamount);
            }
            if (this.calTaskInfo.getTotalSalaryItemId().equals(salaryItemId)) {
                summaryInfoDTO.setTotalSalary(calamount.setScale((int)calCurrencyScale, 3));
            }
            if (!this.calTaskInfo.getNetSalaryItemId().equals(salaryItemId)) continue;
            summaryInfoDTO.setNetSalary(calamount.setScale((int)calCurrencyScale, 3));
        }
        return allCalAmount;
    }

    private Map<Long, Set<Long>> getNeedShowSalaryItems() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
        Long salaryviewvId = this.salarySlipViewDTO.getSalaryviewvId();
        DynamicObject slipViewv = helper.queryOne((Object)salaryviewvId);
        Set<Long> salaryItems = this.getNeedShowSalaryItems(slipViewv);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(1);
        map.put(salaryviewvId, salaryItems);
        return map;
    }

    private Set<Long> getNeedShowSalaryItems(DynamicObject slipViewv) {
        HashSet<Long> salaryItems = new HashSet<Long>(16);
        DynamicObjectCollection entryEntitys = slipViewv.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntity : entryEntitys) {
            DynamicObjectCollection subEntryEntitys = entryEntity.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntryEntity : subEntryEntitys) {
                Long itemId = subEntryEntity.getLong("salaryitem.id");
                salaryItems.add(itemId);
            }
        }
        return salaryItems;
    }

    private boolean checkSalaryItemIsNeedShow(Set<Long> salaryItemIds, Long salaryItemId) {
        return salaryItemIds.contains(salaryItemId);
    }

    private String invokeMService(SalarySlipDTO mainSalarySlipDTO) {
        String resultString = (String)SWCMServiceUtils.invokeSWCService((String)"hspp", (String)"IHSPPService", (String)"releaseSalary", (Object[])new Object[]{mainSalarySlipDTO});
        log.error("batch\uff1a{} hspp status:{}", (Object)this.calBatchId, (Object)resultString);
        return resultString;
    }

    private String invokeRepeatService(List<RepeatSalarySlipDTO> repeatSalarySlipDTOList) {
        String resultString = (String)SWCMServiceUtils.invokeSWCService((String)"hspp", (String)"IHSPPService", (String)"repeatReleaseSalary", (Object[])new Object[]{repeatSalarySlipDTOList});
        log.error("batch\uff1a{},hspp status:{}", (Object)this.calBatchId, (Object)resultString);
        return resultString;
    }

    private String setBigDecimalScale(BigDecimal bigDecimal, int scale, Long dataRoundId) {
        return bigDecimal.setScale(scale, ItemDataUtils.getRoundingMode((long)dataRoundId)).toPlainString();
    }

    private void setPayDetailValue(List<IssueFlowInfoDTO> issueFlowInfoDTOList, DynamicObject subDetailObject) {
        int scale = subDetailObject.getInt("paycurrency.amtprecision");
        IssueFlowInfoDTO issueFlowInfoDTO = new IssueFlowInfoDTO();
        issueFlowInfoDTO.setPayType(Long.valueOf(subDetailObject.getLong("paytype.id"))).setMustBankCard(Boolean.valueOf(subDetailObject.getBoolean("ismustbankcard"))).setPayAmount(this.setBigDecimalScale(subDetailObject.getBigDecimal("payamount"), scale, 1010L)).setPayCurrencyId(subDetailObject.getLong("paycurrency.id")).setPayRollacrelId(subDetailObject.getLong("perbankcard.accountrelation.id")).setBeBankId(subDetailObject.getLong("perbankcard.bankdeposit.id")).setBankAccount(subDetailObject.getString("perbankcard.bankcardnum")).setReceiverName(subDetailObject.getString("perbankcard.username"));
        issueFlowInfoDTOList.add(issueFlowInfoDTO);
    }

    private String getEncryptString(long personId, long salaryfileId, String str) throws Exception {
        ArrayList<String> secretKeyList = new ArrayList<String>(10);
        secretKeyList.add(String.valueOf(personId));
        secretKeyList.add(String.valueOf(salaryfileId));
        String compress = CompressUtils.compress((String)str);
        String result = this.service.encode(secretKeyList, compress);
        return result;
    }

    private String getSysEncryptString(String str) {
        String result = this.service.encode(str);
        return result;
    }

    private Date getInvalidDate(int invalidDay) {
        if (invalidDay == -1) {
            String dataString = "2099-12-31 23:59:59";
            try {
                return SWCDateTimeUtils.parseDate((String)dataString);
            }
            catch (ParseException e) {
                log.error("datetime convert error");
                this.salarySlipFail(null);
            }
        }
        return SWCDateTimeUtils.addDay((Date)new Date(), (long)invalidDay);
    }

    private boolean isTerminateCal() {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", this.recordId));
        Boolean isCancel = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", this.recordId), Boolean.class);
        if (isCancel != null && isCancel.booleanValue()) {
            this.salarySlipFail(null);
            return true;
        }
        return false;
    }

    private void salarySlipFail(List<CalSalarySlipDTO> calSalarySlipDTOList) {
        this.salarySlipFail(this.calList, calSalarySlipDTOList);
    }

    private void salarySlipFail(List<Long> calList, List<CalSalarySlipDTO> calSalarySlipDTOList) {
        log.info("exception calSalary,calBatchId = {}", (Object)this.calBatchId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", this.recordId));
        List<CalSalarySlipPersonRecordDTO> list = CalSalarySlipUtils.getCalTableRecordList(ReleaseStateEnum.RELEASEFAILED.getCode(), calList);
        CalSalarySlipRecordDTO recordDTO = new CalSalarySlipRecordDTO(this.recordId, this.calTaskInfo.getTaskId(), this.calBatchId, this.operationType, list, calSalarySlipDTOList);
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
        appCache.put(resultKey, (Object)recordDTO);
        CalSalarySlipUtils.sendSaveMessage(this.recordId, resultKey);
    }

    private void salarySlipSuccess(List<CalSalarySlipDTO> calSalarySlipList) {
        log.info("success calSalary,calBatchId = {}", (Object)this.calBatchId);
        if (calSalarySlipList.isEmpty()) {
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", this.recordId));
        List<CalSalarySlipPersonRecordDTO> list = CalSalarySlipUtils.getCalTableRecordList(ReleaseStateEnum.RELEASED.getCode(), calSalarySlipList.stream().map(CalSalarySlipDTO::getCalpersonId).collect(Collectors.toList()));
        CalSalarySlipRecordDTO recordDTO = new CalSalarySlipRecordDTO(this.recordId, this.calTaskInfo.getTaskId(), this.calBatchId, this.operationType, list, calSalarySlipList);
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
        appCache.put(resultKey, (Object)recordDTO);
        CalSalarySlipUtils.sendSaveMessage(this.recordId, resultKey);
    }

    static class ParamObject {
        private Map<Long, DynamicObject> calPersonIdToCalPersonMap = new HashMap<Long, DynamicObject>(16);
        private Map<Long, DynamicObject> calPersonIdToCalTableMap = new HashMap<Long, DynamicObject>(16);
        private Map<Long, List<DynamicObject>> calPersonIdToDetailMap = new HashMap<Long, List<DynamicObject>>(16);
        private Map<Long, DynamicObject> calPersonIdToSalarySlipMap = new HashMap<Long, DynamicObject>(16);
        private Map<Long, DynamicObject> calPersonIdToSalaryViewMap = new HashMap<Long, DynamicObject>(16);
        private Map<Long, Set<Long>> calPersonIdToSalaryItemIdMap = new HashMap<Long, Set<Long>>(16);
        private Map<Long, List<BizItemInfoDTO>> calPersonToBizItemResultMap = new HashMap<Long, List<BizItemInfoDTO>>(16);
        private Map<Long, List<FetchItemInfoDTO>> calPersonToFetchItemResultMap = new HashMap<Long, List<FetchItemInfoDTO>>(16);
        private Map<Long, List<SupportItemInfoDTO>> calPersonToSupportItemResultMap = new HashMap<Long, List<SupportItemInfoDTO>>(16);

        public Map<Long, DynamicObject> getCalPersonIdToCalPersonMap() {
            return this.calPersonIdToCalPersonMap;
        }

        public void setCalPersonIdToCalPersonMap(Map<Long, DynamicObject> calPersonIdToCalPersonMap) {
            this.calPersonIdToCalPersonMap = calPersonIdToCalPersonMap;
        }

        private Map<Long, DynamicObject> getCalPersonIdToCalTableMap() {
            return this.calPersonIdToCalTableMap;
        }

        private void setCalPersonIdToCalTableMap(Map<Long, DynamicObject> calPersonIdToCalTableMap) {
            this.calPersonIdToCalTableMap = calPersonIdToCalTableMap;
        }

        private Map<Long, List<DynamicObject>> getCalPersonIdToDetailMap() {
            return this.calPersonIdToDetailMap;
        }

        private void setCalPersonIdToDetailMap(Map<Long, List<DynamicObject>> calPersonIdToDetailMap) {
            this.calPersonIdToDetailMap = calPersonIdToDetailMap;
        }

        private Map<Long, DynamicObject> getCalPersonIdToSalarySlipMap() {
            return this.calPersonIdToSalarySlipMap;
        }

        private void setCalPersonIdToSalarySlipMap(Map<Long, DynamicObject> calPersonIdToSalarySlipMap) {
            this.calPersonIdToSalarySlipMap = calPersonIdToSalarySlipMap;
        }

        private Map<Long, DynamicObject> getCalPersonIdToSalaryViewMap() {
            return this.calPersonIdToSalaryViewMap;
        }

        private void setCalPersonIdToSalaryViewMap(Map<Long, DynamicObject> calPersonIdToSalaryViewMap) {
            this.calPersonIdToSalaryViewMap = calPersonIdToSalaryViewMap;
        }

        public Map<Long, Set<Long>> getCalPersonIdToSalaryItemIdMap() {
            return this.calPersonIdToSalaryItemIdMap;
        }

        public void setCalPersonIdToSalaryItemIdMap(Map<Long, Set<Long>> calPersonIdToSalaryItemIdMap) {
            this.calPersonIdToSalaryItemIdMap = calPersonIdToSalaryItemIdMap;
        }

        public Map<Long, List<BizItemInfoDTO>> getCalPersonToBizItemResultMap() {
            return this.calPersonToBizItemResultMap;
        }

        public void setCalPersonToBizItemResultMap(Map<Long, List<BizItemInfoDTO>> calPersonToBizItemResultMap) {
            this.calPersonToBizItemResultMap = calPersonToBizItemResultMap;
        }

        public Map<Long, List<FetchItemInfoDTO>> getCalPersonToFetchItemResultMap() {
            return this.calPersonToFetchItemResultMap;
        }

        public void setCalPersonToFetchItemResultMap(Map<Long, List<FetchItemInfoDTO>> calPersonToFetchItemResultMap) {
            this.calPersonToFetchItemResultMap = calPersonToFetchItemResultMap;
        }

        public Map<Long, List<SupportItemInfoDTO>> getCalPersonToSupportItemResultMap() {
            return this.calPersonToSupportItemResultMap;
        }

        public void setCalPersonToSupportItemResultMap(Map<Long, List<SupportItemInfoDTO>> calPersonToSupportItemResultMap) {
            this.calPersonToSupportItemResultMap = calPersonToSupportItemResultMap;
        }
    }
}

