/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.thread;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hscs.business.cal.rollback.helper.RollBackCalFilterService;

public class CancelCalThreadTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(CancelCalThreadTask.class);
    private DynamicObject calTask;
    private List<Long> calPersonIdList;
    private Long calRecordId;
    private RequestContext requestContext;
    private CountDownLatch countDownLatch;
    private String cancelType;
    private String stopOperateKey;

    public CancelCalThreadTask(DynamicObject calTask, List<Long> calPersonIdList, Long calRecordId, RequestContext requestContext, CountDownLatch countDownLatch, String cancelType, String stopOperateKey) {
        this.calTask = calTask;
        this.calPersonIdList = calPersonIdList;
        this.calRecordId = calRecordId;
        this.requestContext = requestContext;
        this.countDownLatch = countDownLatch;
        this.cancelType = cancelType;
        this.stopOperateKey = stopOperateKey;
    }

    @Override
    public void run() {
        try {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            LOGGER.info("cancelCal begin,calRecordId = {}", (Object)this.calRecordId);
            RollBackCalFilterService rollBackCalFilterService = new RollBackCalFilterService();
            rollBackCalFilterService.rollBackCal(this.calTask, this.calPersonIdList, this.calRecordId, this.cancelType, this.stopOperateKey);
            LOGGER.info("cancelCal end,calRecordId = {}", (Object)this.calRecordId);
        }
        catch (Exception e) {
            LOGGER.error("cancelCal fail,calRecordId = {}", (Object)this.calRecordId);
            LOGGER.error("error msg:", (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }
}

