/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.attintegrate.AttIntegrateService;
import kd.swc.hscs.business.cal.service.PreTaxCalService;
import kd.swc.hscs.business.schedule.CancelCalAsyncTask;
import kd.swc.hscs.business.schedule.SalaryCalculateAsyncTask;
import kd.swc.hscs.mservice.api.IHSCSService;

public class HSCSService
implements IHSCSService {
    private static final Log log = LogFactory.getLog(HSCSService.class);

    public void calculate(Long calTaskId, Long recordId, String calType, boolean resultCheck) {
        log.info("async calculate request start,calTaskId={},recordId={}", (Object)calTaskId, (Object)recordId);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"SALARYCAL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            log.info("asyncService.execute,tranceId= {}", (Object)ctx.getTraceId());
            SalaryCalculateAsyncTask asyncService = new SalaryCalculateAsyncTask();
            asyncService.execute(calTaskId, recordId, calType, resultCheck, false, new HashMap());
        });
        log.info("async calculate request end,calTaskId={},recordId={}", (Object)calTaskId, (Object)recordId);
    }

    public void cancelCal(Long calTaskId, Long calRecordId, List<Long> calPersonIdList, String cancelType) {
        log.info("async cancel cal request start,calTaskId={},calRecordId={}", (Object)calTaskId, (Object)calRecordId);
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("calTaskId", calTaskId);
        params.put("calPersonIdList", calPersonIdList);
        params.put("calRecordId", calRecordId);
        params.put("cancelType", cancelType);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"CANCELCAL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            log.info("cancel Cal,traceId={}", (Object)ctx.getTraceId());
            CancelCalAsyncTask asyncService = new CancelCalAsyncTask();
            asyncService.execute(params);
        });
        log.info("async cancel cal request end,calTaskId={},calRecordId = {}", (Object)calTaskId, (Object)calRecordId);
    }

    public List<Map<String, Object>> salaryCalPreTax(Long calTaskId, List<Long> calPersonIdList, String calType) {
        PreTaxCalService preTaxCalService = new PreTaxCalService();
        if (SWCStringUtils.isEmpty((String)calType)) {
            calType = "preTaxCal";
        }
        return preTaxCalService.salaryCal(calTaskId, calPersonIdList, calType);
    }

    public List<Map<String, Object>> syncSalaryCal(Long calTaskId, Long recordId, String calType) {
        log.info("syncSalaryCal start,calTaskId={},recordId={},calType={}", new Object[]{calTaskId, recordId, calType});
        HashMap responseMap = new HashMap(16);
        SalaryCalculateAsyncTask salaryCalculateAsyncTask = new SalaryCalculateAsyncTask();
        salaryCalculateAsyncTask.execute(calTaskId, recordId, calType, false, true, responseMap);
        log.info("syncSalaryCal end,calTaskId={},recordId={},calType={}", new Object[]{calTaskId, recordId, calType});
        return responseMap.values().stream().collect(Collectors.toList());
    }

    public void integrateAttData(Long batchLogId, Long creatorId) {
        new AttIntegrateService(batchLogId, creatorId).integrate();
    }
}

