/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.mservice;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hscs.business.schedule.salaryslip.CalSalaryRecoverAsyncTask;
import kd.swc.hscs.business.schedule.salaryslip.CalSalaryReleaseAsyncTask;
import kd.swc.hscs.mservice.api.ISalarySlipService;

public class SalarySlipService
implements ISalarySlipService {
    private static final Log log = LogFactory.getLog(SalarySlipService.class);

    public String calSalarySlipRelease(Long recordId) {
        log.info("async calSalaryRelease request start,recordId={}", (Object)recordId);
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("recordId", recordId);
        String taskId = "";
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"SALARYSLIPRELEASE_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            log.info("asyncService.asyncRelease");
            CalSalaryReleaseAsyncTask asyncService = new CalSalaryReleaseAsyncTask();
            asyncService.execute(ctx, params);
        });
        log.info("async calSalaryRelease request end,recordId={},taskId={}", (Object)recordId, (Object)taskId);
        return taskId;
    }

    public String calSalarySlipRecover(Long recordId) {
        log.info("async calSalaryRecover request start,recordId={}", (Object)recordId);
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("recordId", recordId);
        String taskId = "";
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"SALARYSLIPRECOVER_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            log.info("asyncService.asyncRecover");
            CalSalaryRecoverAsyncTask asyncService = new CalSalaryRecoverAsyncTask();
            asyncService.execute(ctx, params);
        });
        log.info("async calSalaryRecover request end,recordId={},taskId={}", (Object)recordId, (Object)taskId);
        return taskId;
    }
}

