/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallocation;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcommon.CostProgressCommonHelper;
import org.apache.commons.lang3.StringUtils;

public class CostAllocationProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String COST_ALLOCATION_PROGRESS_FLEX = "costallocationprogress";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_min", "btn_termination", "btn_viewresult", "btn_viewrecord"});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(COST_ALLOCATION_PROGRESS_FLEX);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getControl(COST_ALLOCATION_PROGRESS_FLEX);
        progressBar.start();
        CostProgressCommonHelper.setShowProgressInfo((String)"cache_costallocation_key_%s", (String)COST_ALLOCATION_PROGRESS_FLEX, (IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_giveup": {
                this.terminationCostAllocation();
                break;
            }
            case "viewrecord": {
                this.viewCostAllocationRecord(operateKey);
                break;
            }
            case "viewresult": {
                this.viewCostAllocationResult(operateKey);
                break;
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)COST_ALLOCATION_PROGRESS_FLEX)) {
            String message = ResManager.loadKDString((String)"\u751f\u6210\u6210\u672c\u5206\u644a\u7ed3\u6784", (String)"CostAllocationProgressPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            CostProgressCommonHelper.setCostProgressDetail((String)"cache_costallocation_key_%s", (String)message, (ProgressEvent)progressEvent, (IFormView)this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData;
        String calTaskIds = (String)this.getView().getFormShowParameter().getCustomParam("caltaskids");
        CostAllocationProgressInfo progress = CostProgressCommonHelper.getProgress((String)"cache_costallocation_key_%s", (IFormView)this.getView());
        if (progress != null) {
            this.openProgressBall(calTaskIds, progress);
        }
        if ((returnData = this.getView().getReturnData()) != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private void openProgressBall(String calTaskIds, CostAllocationProgressInfo progress) {
        int status;
        IFormView mainView = this.getView().getMainView();
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (SWCStringUtils.isNotEmpty((String)taskId)) {
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(mainView, taskId);
        }
        if ((status = progress.getStatus()) == 2) {
            CostProgressCommonHelper.refreshParentView((IFormView)this.getView());
        } else {
            String operaKey;
            Object schTaskIdObj = this.getView().getFormShowParameter().getCustomParam("sch_taskid");
            if (SWCObjectUtils.isEmpty((Object)schTaskIdObj) && SWCStringUtils.isEmpty((String)(operaKey = this.getView().getPageCache().get("btn_termination")))) {
                CostAllocationHelper.openProgressBallByCalTaskId((IFormView)this.getView(), (String)calTaskIds);
            }
        }
    }

    private void terminationCostAllocation() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        CostAllocationProgressInfo progress = CostProgressCommonHelper.getProgress((String)"cache_costallocation_key_%s", (IFormView)this.getView());
        if (progress != null) {
            int status = progress.getStatus();
            if (status == 2) {
                return;
            }
            this.terminationGenerateCostUp();
            String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
            if (SWCStringUtils.isNotEmpty((String)taskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(taskId, "ABORTED");
            }
            this.getView().getPageCache().put("btn_termination", "1");
            CostProgressCommonHelper.refreshParentView((IFormView)this.getView());
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_close"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_min", "btn_termination", "btn_viewresult", "btn_viewrecord"});
            ProgressBar progressBar = (ProgressBar)this.getControl(COST_ALLOCATION_PROGRESS_FLEX);
            progressBar.stop();
            CostProgressCommonHelper.updateTerminationContent((IFormView)this.getView());
            CostProgressCommonHelper.updateTerminationImage((IFormView)this.getView());
        }
    }

    private void viewCostAllocationResult(String operateKey) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"47150e89000000ac");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6210\u672c\u5206\u644a\u7ed3\u6784\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostAllocationProgressPlugin_8", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        String costAllocationId = (String)this.getView().getFormShowParameter().getCustomParam("costallocationid");
        returnData.put("costallocationid", costAllocationId);
        returnData.put("operationkey", operateKey);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    private void viewCostAllocationRecord(String operateKey) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"220JN+6Q4R=I");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostAllocationProgressPlugin_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        String costAllocationRecordDyIds = (String)this.getView().getFormShowParameter().getCustomParam("costallocationrecordids");
        returnData.put("costallocationrecordids", costAllocationRecordDyIds);
        returnData.put("operationkey", operateKey);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    private void terminationGenerateCostUp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String calTaskIdStr = (String)this.getView().getFormShowParameter().getCustomParam("caltaskids");
        String costAllocationIdStr = (String)formShowParameter.getCustomParam("costallocationids");
        String costAllocationRecordDyIdStr = (String)formShowParameter.getCustomParam("costallocationrecordids");
        Set caltaskids = (Set)JSON.parseObject((String)calTaskIdStr, Set.class);
        Set costallocationids = (Set)JSON.parseObject((String)costAllocationIdStr, Set.class);
        Set costallocationrecordids = (Set)JSON.parseObject((String)costAllocationRecordDyIdStr, Set.class);
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_costallocation");
        QFilter costtaskstatusFilter = new QFilter("costtaskstatus", "=", (Object)"2");
        QFilter costAllocationIdFilter = new QFilter("id", "in", (Object)costallocationids);
        DynamicObject[] costAllocationArr = costAllocationHelper.query("caltask.id", new QFilter[]{costtaskstatusFilter, costAllocationIdFilter});
        if (costAllocationArr == null || costAllocationArr.length == 0) {
            return;
        }
        List waitDelAlloIds = Arrays.stream(costAllocationArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        costAllocationHelper.delete(waitDelAlloIds.toArray());
        List waitDelCaltaskids = Arrays.stream(costAllocationArr).map(dy -> dy.getLong("caltask.id")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("caltask", "in", waitDelCaltaskids);
        SWCDataServiceHelper setUpRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        setUpRstHelper.deleteByFilter(new QFilter[]{taskFilter});
        QFilter recordIdFilter = new QFilter("id", "in", (Object)costallocationrecordids);
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        costRecordHelper.deleteByFilter(new QFilter[]{taskFilter, recordIdFilter});
        IAppCache appCache = AppCache.get((String)"pcs");
        for (Long calTaskId : caltaskids) {
            appCache.put(String.format(Locale.ROOT, "istermination_%s", calTaskId), (Object)"true");
        }
    }
}

