/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallocation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostCustomCreateEntryHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costcustomize.service.CostCustomizeService;

public class CostCustomizeSchemePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(CostCustomizeSchemePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String costSetUpIdStr = (String)formShowParameter.getCustomParam("costsetupid");
        long costSetUpId = Long.parseLong(costSetUpIdStr);
        if (costSetUpId == 0L) {
            return;
        }
        SWCDataServiceHelper setUpRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter filter = new QFilter("id", "=", (Object)costSetUpId);
        DynamicObject setUpRstQueryResult = setUpRstHelper.queryOne("id,costadapter.coststru", new QFilter[]{filter});
        long costStruId = setUpRstQueryResult.getLong("costadapter.coststru.id");
        if (costStruId == 0L) {
            return;
        }
        IAppCache appCache = AppCache.get((String)("cache_coststruid_key" + formShowParameter.getParentPageId()));
        appCache.put("cache_coststruid_key" + formShowParameter.getParentPageId(), (Object)costStruId);
        EntryAp entryAp = CostCustomCreateEntryHelper.createDynamicEntryAp();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"pcs_costcustomizescheme", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List<EntryFieldAp> baseDataFieldApList = this.batchDynamicCreateFieldAp(entityMetadata, costStruId);
        entryAp.getItems().addAll(baseDataFieldApList);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        String parentPageId = this.getView().getParentView().getPageId();
        IAppCache appCache = AppCache.get((String)("cache_coststruid_key" + parentPageId));
        Long costStruId = (Long)appCache.get("cache_coststruid_key" + parentPageId, Long.class);
        if (costStruId == null || costStruId == 0L) {
            return;
        }
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStruId, null, (String)"");
        List newColumnList = CostCustomCreateEntryHelper.addNewFixColumn((List)dimensionObjList);
        for (DynamicObject dimensionObj : newColumnList) {
            CostCustomCreateEntryHelper.createPropByType((MainEntityType)newMainType, (DynamicObject)dimensionObj);
        }
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        EntryAp dynamicEntryAp = CostCustomCreateEntryHelper.createDynamicEntryAp();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"pcs_costcustomizescheme", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        String parentPageId = this.getView().getParentView().getPageId();
        IAppCache appCache = AppCache.get((String)("cache_coststruid_key" + parentPageId));
        Long costStruId = (Long)appCache.get("cache_coststruid_key" + parentPageId, Long.class);
        if (costStruId == 0L) {
            return;
        }
        CostCustomCreateEntryHelper.dynamicCreateEntryApItem((EntryAp)dynamicEntryAp, (EntityMetadata)entityMetadata, (Long)costStruId);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        CostCustomizeSchemePlugin.setRevealUnEnable(this.getView());
    }

    private static void setRevealUnEnable(IFormView view) {
        DynamicObjectCollection salaryItemEntryDys = view.getModel().getEntryEntity("entryentity");
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        ArrayList<Integer> lockList = new ArrayList<Integer>(10);
        ArrayList<Integer> unlockList = new ArrayList<Integer>(10);
        for (int i = 0; i < salaryItemEntryDys.size(); ++i) {
            DynamicObject customizeEntryDy = (DynamicObject)salaryItemEntryDys.get(i);
            boolean checkBoxIsReveal = customizeEntryDy.getBoolean("checkbox10006");
            if (checkBoxIsReveal) {
                lockList.add(i);
                view.getModel().setValue("decimal10007", null, i);
                continue;
            }
            unlockList.add(i);
        }
        int[] lockArr = lockList.stream().mapToInt(Integer::valueOf).toArray();
        int[] unlockArr = unlockList.stream().mapToInt(Integer::valueOf).toArray();
        SWCGridUtils.lockCell((IClientViewProxy)proxy, (String)"entryentity", (int[])lockArr, (String[])new String[]{"decimal10007"}, (boolean)true);
        SWCGridUtils.lockCell((IClientViewProxy)proxy, (String)"entryentity", (int[])unlockArr, (String[])new String[]{"decimal10007"}, (boolean)false);
        view.setVisible(Boolean.FALSE, new String[]{"basedata10008"});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (SWCStringUtils.isEmpty((String)key)) {
            return;
        }
        if (key.startsWith("basedata")) {
            CostCustomCreateEntryHelper.setBaseDataControl((OnGetControlArgs)e, (String)key, (IFormView)this.getView());
        } else if (key.startsWith("text")) {
            CostCustomCreateEntryHelper.setTextControl((OnGetControlArgs)e, (String)key, (IFormView)this.getView());
        } else if (key.startsWith("checkbox")) {
            CostCustomCreateEntryHelper.setCheckBoxControl((OnGetControlArgs)e, (String)key, (IFormView)this.getView());
        } else if (key.startsWith("amount")) {
            CostCustomCreateEntryHelper.setAmountControl((OnGetControlArgs)e, (String)key, (IFormView)this.getView());
        } else if (key.startsWith("integer")) {
            CostCustomCreateEntryHelper.setIntegerControl((OnGetControlArgs)e, (String)key, (IFormView)this.getView());
        } else if (key.startsWith("decimal")) {
            CostCustomCreateEntryHelper.setDecimalControl((OnGetControlArgs)e, (String)key, (IFormView)this.getView());
        }
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String costSetUpIdStr = (String)formShowParameter.getCustomParam("costsetupid");
        long costSetUpId = Long.parseLong(costSetUpIdStr);
        if (costSetUpId == 0L) {
            return;
        }
        DynamicObject setUpRstQueryResult = this.querySetUpRstDyById(costSetUpId);
        long costStruId = setUpRstQueryResult.getLong("costadapter.coststru.id");
        if (costStruId == 0L) {
            return;
        }
        HashMap<Long, DynamicObject> salaryItemEntryIdMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> defCostSetUpConstIds = new ArrayList<Long>(10);
        DynamicObjectCollection salaryItemEntryDys = this.initCollectionInfo(setUpRstQueryResult, salaryItemEntryIdMap, defCostSetUpConstIds);
        long salaryItemId = this.updateCache(setUpRstQueryResult);
        Map<Long, DynamicObject> constEntryIdMap = this.getConstIdMap(defCostSetUpConstIds);
        if (CollectionUtils.isEmpty(constEntryIdMap)) {
            return;
        }
        Map queryCostStruMap = CostCommonHelper.queryCostStruMap((long)costStruId);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
        ArrayList myselfCreateFields = new ArrayList(10);
        HashMap baseDataMap = new HashMap(16);
        CostAllocationHelper.getCreateFields((DataEntityPropertyCollection)properties, myselfCreateFields, baseDataMap);
        Map costSetUpFixPropertiesMap = CostAllocationHelper.getCostSetUpFixPropertiesMap();
        DynamicObject salaryItemDy = BusinessDataServiceHelper.loadSingleFromCache((Object)salaryItemId, (String)"hsbs_salaryitem");
        long calCurrencyId = setUpRstQueryResult.getLong("costadapter.currency.id");
        DynamicObject bdCurrencyDy = BusinessDataServiceHelper.loadSingleFromCache((Object)calCurrencyId, (String)"bd_currency");
        for (DynamicObject setUpSalaryItemDy : salaryItemEntryDys) {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            for (String field : myselfCreateFields) {
                String value = (String)queryCostStruMap.get(field);
                if (value == null) {
                    CostAllocationHelper.setEntryFixColumnInfo(salaryItemEntryIdMap, (Map)costSetUpFixPropertiesMap, (DynamicObject)salaryItemDy, (DynamicObject)setUpSalaryItemDy, (DynamicObject)newRow, (String)field, (DynamicObject)bdCurrencyDy);
                    continue;
                }
                CostAllocationHelper.setEntryDynamicColumnInfo(constEntryIdMap, (Map)queryCostStruMap, baseDataMap, (DynamicObject)setUpSalaryItemDy, (DynamicObject)newRow, (String)field);
            }
            rows.add((Object)newRow);
        }
        e.setDataEntity((Object)dataEntity);
        CostCustomizeSchemePlugin.setSalaryItemColumnUnEnable(salaryItemEntryDys, this.getView());
    }

    private Map<Long, DynamicObject> getConstIdMap(List<Long> defCostSetUpConstIds) {
        HashMap<Long, DynamicObject> constEntryIdMap = new HashMap<Long, DynamicObject>(16);
        SWCDataServiceHelper constHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        DynamicObject[] constQueryResult = constHelper.query(defCostSetUpConstIds.toArray());
        if (constQueryResult.length == 0) {
            return constEntryIdMap;
        }
        for (DynamicObject constDy : constQueryResult) {
            long constId = constDy.getLong("id");
            constEntryIdMap.put(constId, constDy);
        }
        return constEntryIdMap;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Long costItemId = (Long)pageCache.get("costitemid", Long.class);
        Long hrOrgId = (Long)pageCache.get("hrorgid", Long.class);
        this.getView().getModel().setValue("costitem", (Object)costItemId);
        this.getView().getModel().setValue("hrorg", (Object)hrOrgId);
    }

    private static void setSalaryItemColumnUnEnable(DynamicObjectCollection salaryItemEntryDys, IFormView view) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        int[] arr = new int[salaryItemEntryDys.size()];
        for (int i = 0; i < salaryItemEntryDys.size(); ++i) {
            arr[i] = i;
        }
        SWCGridUtils.lockCell((IClientViewProxy)proxy, (String)"entryentity", (int[])arr, (String)"basedata10001", (boolean)true);
        SWCGridUtils.lockCell((IClientViewProxy)proxy, (String)"entryentity", (int[])arr, (String)"basedata10008", (boolean)true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        if ("btnok".equals(clkKey)) {
            CostCustomizeService costCustomizeService = new CostCustomizeService();
            boolean validatorCostCustomizeInfo = costCustomizeService.validatorCostCustomizeInfo(this.getView());
            if (!validatorCostCustomizeInfo || this.checkPerm()) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
            ArrayList<String> myselfCreateFields = new ArrayList<String>(10);
            HashMap<String, BasedataProp> baseDataMap = new HashMap<String, BasedataProp>(16);
            CostAllocationHelper.getCreateFields((DataEntityPropertyCollection)properties, myselfCreateFields, baseDataMap);
            Map costSetUpPropertiesMap = CostAllocationHelper.getCostSetUpFixPropertiesMap();
            ArrayList<Map<String, Object>> allFieldValueList = new ArrayList<Map<String, Object>>(10);
            this.setCollectionValue(entryEntity, myselfCreateFields, allFieldValueList, costSetUpPropertiesMap, baseDataMap);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object costSetUpId = formShowParameter.getCustomParam("costsetupid");
            long costItemId = this.getView().getModel().getDataEntity().getLong("costitem.id");
            HashMap<String, Object> returnData = new HashMap<String, Object>(1);
            returnData.put("costsetupcustomizevalue", allFieldValueList);
            returnData.put("costsetupid", costSetUpId);
            returnData.put("costitemid", costItemId);
            this.getView().setReturnData(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("isdatachanged", (Object)"true");
        CostCustomizeSchemePlugin.setRevealUnEnable(this.getView());
    }

    private boolean checkPerm() {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_costsetuprst", (String)"2Y=U/BIWCB+L");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostCustomizeSchemePlugin_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)"pcs_costsetuprst", (String)"2Y=U/BIWCB+L");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            LOGGER.info("CostCustomizeSchemePlugin checkPerm getPermOrgs :{}", (Object)hasPermOrgs);
            FormShowParameter formShowParameter = this.getView().getParentView().getFormShowParameter();
            Object hrOrgIdObj = formShowParameter.getCustomParam("hrOrgId");
            Long hrOrgId = Long.valueOf(String.valueOf(hrOrgIdObj));
            if (!hasPermOrgs.contains(hrOrgId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostCustomizeSchemePlugin_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void setCollectionValue(DynamicObjectCollection entryEntity, List<String> myselfCreateFields, List<Map<String, Object>> allFieldValueList, Map<String, String> costSetUpPropertiesMap, Map<String, BasedataProp> baseDataMap) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Long costStruId = (Long)pageCache.get("coststruid", Long.class);
        Map costStruShowDisPropMap = CostAllocationHelper.queryCostStruShowDisPropMap((long)costStruId);
        for (DynamicObject customizeEntryDy : entryEntity) {
            StringBuilder sb = new StringBuilder();
            LinkedHashMap<String, String> entryFieldValueMap = new LinkedHashMap<String, String>(16);
            for (String field : myselfCreateFields) {
                if (field.contains("basedata")) {
                    String valueName = this.getBaseDataShowValue(costStruShowDisPropMap, customizeEntryDy, field);
                    long id = customizeEntryDy.getLong(field + ".id");
                    entryFieldValueMap.put(field, String.valueOf(id));
                    if (costSetUpPropertiesMap.get(field) != null) continue;
                    String baseDataValue = this.getDyBaseDataShowValue(baseDataMap, customizeEntryDy, field);
                    sb.append(baseDataValue == null ? " " : baseDataValue).append('.');
                    continue;
                }
                Object object = customizeEntryDy.get(field);
                entryFieldValueMap.put(field, String.valueOf(object));
                if (costSetUpPropertiesMap.get(field) != null) continue;
                sb.append(object == null ? " " : object).append('.');
            }
            String dyValue = sb.length() > 0 ? sb.substring(0, sb.lastIndexOf(".")) : "";
            entryFieldValueMap.put("defcostsetupconstvalueresult", dyValue);
            allFieldValueList.add(entryFieldValueMap);
        }
    }

    private String getDyBaseDataShowValue(Map<String, BasedataProp> basedataMap, DynamicObject customizeEntryDy, String field) {
        String baseDataValue = "";
        DynamicObject dyObj = customizeEntryDy.getDynamicObject(field);
        if (dyObj == null) {
            return baseDataValue;
        }
        DataEntityPropertyCollection dyProperties = dyObj.getDataEntityType().getProperties();
        if (dyProperties.containsKey((Object)"name") || dyProperties.containsKey((Object)"number")) {
            BasedataProp basedataProp = basedataMap.get(field);
            String displayProp = basedataProp.getDisplayProp();
            String baseDataName = "number".equals(displayProp) ? field + ".number" : field + ".name";
            String name = customizeEntryDy.getString(baseDataName);
            baseDataValue = name == null ? " " : name;
        }
        return baseDataValue;
    }

    private String getBaseDataShowValue(Map<String, String> costStruShowDisPropMap, DynamicObject customizeEntryDy, String field) {
        String valueName = "";
        DynamicObject dynamicObject = customizeEntryDy.getDynamicObject(field);
        if (dynamicObject == null) {
            return valueName;
        }
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"name") || properties.containsKey((Object)"number")) {
            String showDisProp = costStruShowDisPropMap.get(field);
            String showDisPropName = "1".equals(showDisProp) ? field + ".number" : field + ".name";
            String name = customizeEntryDy.getString(showDisPropName);
            valueName = name == null ? " " : name;
        }
        return valueName;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("addentrymyself".equals(operateKey)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            DynamicObject rowDataEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            model.endInit();
            BindingContext bindCtx = new BindingContext(rowDataEntity.getDataEntityType(), rowDataEntity, rowDataEntity.getInt("seq") - 1);
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            List rowValues = CostCustomCreateEntryHelper.getRowBindValue((BindingContext)bindCtx, (IFormView)this.getView());
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.appendRow(grid.getKey(), rowValues);
            DynamicObjectCollection salaryItemEntryDys = this.getModel().getEntryEntity("entryentity");
            CostCustomizeSchemePlugin.setSalaryItemColumnUnEnable(salaryItemEntryDys, this.getView());
        } else if ("deleteentry".equals(operateKey)) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("isdatachanged", (Object)"true");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private List<EntryFieldAp> batchDynamicCreateFieldAp(EntityMetadata entityMetadata, Long costStrutId) {
        ArrayList<EntryFieldAp> fieldApList = new ArrayList<EntryFieldAp>(10);
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStrutId, null, (String)"");
        List newColumnList = CostCustomCreateEntryHelper.addNewFixColumn((List)dimensionObjList);
        Map mustInputFieldMap = CostAllocationHelper.queryCostStruMustInputField((long)costStrutId);
        for (DynamicObject dimensionObj : newColumnList) {
            EntryFieldAp fieldAp = CostCustomCreateEntryHelper.createEntryFieldByType((EntityMetadata)entityMetadata, (DynamicObject)dimensionObj, (Map)mustInputFieldMap);
            if (fieldAp == null) continue;
            fieldApList.add(fieldAp);
        }
        return fieldApList;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "costcustomizedeleteall_callback": {
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    Object costSetupId = formShowParameter.getCustomParam("costsetupid");
                    HashMap<String, Object> returnData = new HashMap<String, Object>(1);
                    returnData.put("costsetupid", costSetupId);
                    this.getView().setReturnData(returnData);
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public static void setFilter(BeforeF7SelectEvent event) {
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        Long userId = RequestContext.get().getCurrUserId();
        List orgIds = SWCPermissionServiceHelper.getUserHasPermOrgs((Long)userId);
        if (!SWCListUtils.isEmpty((List)orgIds)) {
            QFilter qFilter = new QFilter("createorg.id", "=", (Object)orgIds);
            param.getListFilterParameter().setFilter(qFilter);
        }
    }

    private long updateCache(DynamicObject setUpRstQueryResult) {
        long salaryItemId = setUpRstQueryResult.getLong("salaryitem.id");
        long costItemId = setUpRstQueryResult.getLong("costitem.id");
        long hrOrgId = setUpRstQueryResult.getLong("costadapter.org.id");
        long costStruId = setUpRstQueryResult.getLong("costadapter.coststru.id");
        long calCurrencyId = setUpRstQueryResult.getLong("costadapter.currency.id");
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("salaryitemid", (Object)salaryItemId);
        pageCache.put("calcurrencyid", (Object)calCurrencyId);
        pageCache.put("coststruid", (Object)costStruId);
        pageCache.put("costitemid", (Object)costItemId);
        pageCache.put("hrorgid", (Object)hrOrgId);
        return salaryItemId;
    }

    private DynamicObject querySetUpRstDyById(long costSetUpId) {
        SWCDataServiceHelper setUpRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter filter = new QFilter("id", "=", (Object)costSetUpId);
        return setUpRstHelper.queryOne("id,salaryitem.id,costitem,costadapter.org,costadapter.coststru,costadapter.currency,percentage,aotucostsetupconst.id,defcostsetupconst.id,isrevealdetail,maxmount", new QFilter[]{filter});
    }

    private DynamicObjectCollection initCollectionInfo(DynamicObject setUpRstQueryResult, Map<Long, DynamicObject> salaryItemEntryIdMap, List<Long> defCostSetUpConstIds) {
        DynamicObjectCollection salaryItemEntryDys = setUpRstQueryResult.getDynamicObjectCollection("entryentity");
        for (DynamicObject salaryItemEntryDy : salaryItemEntryDys) {
            long defCostSetUpConstId = salaryItemEntryDy.getLong("defcostsetupconst.id");
            defCostSetUpConstIds.add(defCostSetUpConstId);
            long id = salaryItemEntryDy.getLong("id");
            salaryItemEntryIdMap.put(id, salaryItemEntryDy);
        }
        return salaryItemEntryDys;
    }
}

