/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallocation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.pcs.business.costallot.helper.CostAllotHelper;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcfg.CostSetUpHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostGenerateSchemePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostGenerateSchemePlugin.class);
    private static final String BTN_OK = "btnok";
    public static final String KEY_SALARYFILE = "salaryfile";
    public static final String KEY_CALTASK = "caltask";

    public void initialize() {
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"pcs_costsetuprst");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().cacheFormShowParameter();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String billFormId = ((ListView)this.getView().getParentView()).getBillFormId();
        if (!"pcs_costallocation".equals(billFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CALTASK});
            this.getModel().setValue(KEY_CALTASK, (Object)new Object[]{this.getView().getFormShowParameter().getCustomParam("calTaskId")});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit salaryfileEdit = (BasedataEdit)this.getView().getControl(KEY_SALARYFILE);
        salaryfileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calTaskEdit = (BasedataEdit)this.getView().getControl(KEY_CALTASK);
        calTaskEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        if (BTN_OK.equals(clkKey)) {
            DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
            MulBasedataDynamicObjectCollection calTaskDys = (MulBasedataDynamicObjectCollection)dynamicObject.get(KEY_CALTASK);
            if (calTaskDys == null || calTaskDys.size() == 0) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u201d\u3002", (String)"CostGenerateSchemePlugin_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            String generateStrategy = dynamicObject.getString("generatestrategy");
            if (generateStrategy == null || generateStrategy.isEmpty()) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u751f\u6210\u7b56\u7565\u201d\u3002", (String)"CostGenerateSchemePlugin_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            HashSet<Long> calTaskIds = new HashSet<Long>(16);
            for (DynamicObject calTaskDy : calTaskDys) {
                long calTaskId = calTaskDy.getLong("fbasedataid_id");
                DynamicObject costAllocationObj = CostAllocationHelper.queryCostAllocationByCalTaskId((Long)calTaskId);
                AppCache.get((String)"pcs").put(String.format(Locale.ROOT, "istermination_%s", calTaskId), (Object)"false");
                if (costAllocationObj == null || !"2".equals(costAllocationObj.getString("costtaskstatus"))) continue;
                calTaskIds.add(calTaskId);
            }
            if (calTaskIds.size() > 0) {
                Map calPayrollTaskMap = CostCommonHelper.getCalPayrollTask(calTaskIds);
                StringBuilder sb = new StringBuilder();
                for (DynamicObject calTaskDy : calPayrollTaskMap.values()) {
                    if (sb.length() >= 1) {
                        sb.append('\u3001');
                    }
                    sb.append(calTaskDy.getString("name"));
                }
                String message = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u7ed3\u6784\u3002", (String)"CostGenerateSchemePlugin_4", (String)"swc-pcs-formplugin", (Object[])new Object[]{sb.toString()});
                this.getView().showErrorNotification(message);
                return;
            }
            this.generateCostSetUp();
        }
    }

    private void generateCostSetUp() {
        StringBuilder sb;
        Map calPayrollTaskMap;
        DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
        String generateStrategy = dynamicObject.getString("generatestrategy");
        MulBasedataDynamicObjectCollection calTaskDys = (MulBasedataDynamicObjectCollection)dynamicObject.get(KEY_CALTASK);
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue(KEY_SALARYFILE);
        ArrayList<Long> mulSalaryFileList = new ArrayList<Long>(rows.size());
        if (!rows.isEmpty()) {
            for (DynamicObject row : rows) {
                DynamicObject baseDataObj = row.getDynamicObject("fbasedataid");
                Long baseDataId = baseDataObj.getLong("id");
                mulSalaryFileList.add(baseDataId);
            }
        }
        HashMap<Long, List> calTaskFileRlsMap = new HashMap<Long, List>(16);
        HashSet<Long> noDataCalTaskIds = new HashSet<Long>(16);
        HashSet<Long> noItemCalTaskIds = new HashSet<Long>(16);
        int salaryFileCount = 0;
        for (DynamicObject calTaskDy : calTaskDys) {
            long calTaskId = calTaskDy.getLong("fbasedataid_id");
            Map salaryItemIdListByCalTaskId = CostAllotHelper.getSalaryItemIdListByCalTaskId((Long)calTaskId);
            boolean isEmpty = salaryItemIdListByCalTaskId.isEmpty();
            if (isEmpty) {
                noItemCalTaskIds.add(calTaskId);
                continue;
            }
            List salaryFileList = CalPersonHelper.getFileIdsByTask((Long)calTaskId, mulSalaryFileList);
            if ("3".equals(generateStrategy)) {
                List existedSalaryFileIdList = CostSetUpHelper.getExistSalaryFileNumber((long)calTaskId, (boolean)false);
                salaryFileList.removeAll(existedSalaryFileIdList);
            }
            if (salaryFileList.isEmpty()) {
                noDataCalTaskIds.add(calTaskId);
                continue;
            }
            calTaskFileRlsMap.put(calTaskId, salaryFileList);
            salaryFileCount += salaryFileList.size();
        }
        if (noItemCalTaskIds.size() > 0) {
            calPayrollTaskMap = CostCommonHelper.getCalPayrollTask(noItemCalTaskIds);
            sb = new StringBuilder();
            for (DynamicObject calTaskDy : calPayrollTaskMap.values()) {
                if (sb.length() >= 1) {
                    sb.append('\u3001');
                }
                sb.append(calTaskDy.getString("name"));
            }
            String message = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u6cd5\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u56e0\u4e3a\u8ba1\u7b97\u89c4\u5219\u4e2d\u65e0\u53c2\u4e0e\u6210\u672c\u5206\u644a\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"CostGenerateSchemePlugin_7", (String)"swc-pcs-formplugin", (Object[])new Object[]{sb.toString()});
            this.getView().showErrorNotification(message);
            return;
        }
        if (noDataCalTaskIds.size() > 0) {
            calPayrollTaskMap = CostCommonHelper.getCalPayrollTask(noDataCalTaskIds);
            sb = new StringBuilder();
            for (DynamicObject calTaskDy : calPayrollTaskMap.values()) {
                if (sb.length() >= 1) {
                    sb.append('\u3001');
                }
                sb.append(calTaskDy.getString("name"));
            }
            String message = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u6cd5\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u56e0\u4e3a\u6240\u9009\u4efb\u52a1\u4e0b\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6863\u6848\u3002", (String)"CostGenerateSchemePlugin_8", (String)"swc-pcs-formplugin", (Object[])new Object[]{sb.toString()});
            this.getView().showErrorNotification(message);
        }
        if (calTaskFileRlsMap.size() == 0) {
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("calTaskFileRlsMap", calTaskFileRlsMap);
        returnData.put("generatesStrategy", generateStrategy);
        this.getPageCache().put("generateCostSetUp", SerializationUtils.serializeToBase64(returnData));
        String format = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5904\u7406%d\u6761\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"CostAllocationHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]);
        this.getView().showConfirm(String.format(Locale.ROOT, format, salaryFileCount), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("pcs_generateschemeconfirm"));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "pcs_generateschemeconfirm": {
                    String returnDataJson = this.getPageCache().get("generateCostSetUp");
                    Map returnData = (Map)SerializationUtils.deSerializeFromBase64((String)returnDataJson);
                    this.getView().setReturnData((Object)returnData);
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        long currUserId = RequestContext.get().getCurrUserId();
        switch (fieldKey) {
            case "salaryfile": {
                MulBasedataDynamicObjectCollection calTaskDys = (MulBasedataDynamicObjectCollection)this.getView().getModel().getDataEntity().get(KEY_CALTASK);
                if (calTaskDys == null || calTaskDys.size() == 0) {
                    String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u4efb\u52a1\u201d\u3002", (String)"CostGenerateSchemePlugin_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    event.setCancel(true);
                    return;
                }
                ArrayList salaryFileList = new ArrayList(10);
                for (DynamicObject calTaskDy : calTaskDys) {
                    long calTaskId = calTaskDy.getLong("fbasedataid_id");
                    salaryFileList.addAll(CalPersonHelper.getFileIdsByTask((Long)calTaskId));
                }
                if (salaryFileList.isEmpty()) {
                    String message = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CostGenerateSchemePlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    event.setCancel(true);
                    return;
                }
                QFilter idFilter = new QFilter("id", "in", salaryFileList);
                QFilter salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_costsetuprst", (String)KEY_SALARYFILE, (String)"47150e89000000ac");
                if (salaryFileFilter != null) {
                    idFilter.and(salaryFileFilter);
                }
                event.addCustomQFilter(idFilter);
                break;
            }
            case "caltask": {
                QFilter taskFilter = CostAllocationHelper.getTaskFilter();
                QFilter calTaskFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)KEY_CALTASK, (String)"47150e89000000ac");
                if (calTaskFilter != null) {
                    taskFilter.and(calTaskFilter);
                }
                event.addCustomQFilter(taskFilter);
                break;
            }
        }
        logger.info("CostGenerateSchemePlugin beforeF7Select fieldKey :{} CustomFilters :{}", (Object)fieldKey, (Object)event.getCustomQFilters());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (KEY_CALTASK.equals(propName)) {
            MulBasedataDynamicObjectCollection newCalTaskDys = (MulBasedataDynamicObjectCollection)changeSet[0].getNewValue();
            if (newCalTaskDys == null) {
                return;
            }
            HashSet<Long> calTaskIds = new HashSet<Long>(16);
            Iterator it = newCalTaskDys.iterator();
            while (it.hasNext()) {
                DynamicObject newCalTaskDy = (DynamicObject)it.next();
                long calTaskId = newCalTaskDy.getLong("fbasedataid_id");
                Long costAdapterId = CostCommonHelper.queryCostAdapterIdByCalTaskId((Long)calTaskId);
                if (costAdapterId != null) continue;
                calTaskIds.add(calTaskId);
                it.remove();
            }
            if (calTaskIds.size() > 0) {
                Map calPayrollTaskMap = CostCommonHelper.getCalPayrollTask(calTaskIds);
                StringBuilder sb = new StringBuilder();
                for (DynamicObject calTaskDy : calPayrollTaskMap.values()) {
                    if (sb.length() >= 1) {
                        sb.append('\u3001');
                    }
                    sb.append(calTaskDy.getString("name"));
                }
                String message = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u6ca1\u6709\u5bf9\u5e94\u7684\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u3002", (String)"CostGenerateSchemePlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[]{sb.toString()});
                this.getView().showErrorNotification(message);
                IDataModel model = this.getModel();
                model.beginInit();
                this.getView().getModel().setValue(KEY_CALTASK, (Object)newCalTaskDys);
                this.getView().updateView(KEY_CALTASK);
                model.endInit();
            }
        }
    }
}

