/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostAllotDetailHelper;
import kd.swc.pcs.business.costallot.helper.AllotDetailHelper;
import kd.swc.pcs.business.costallot.helper.CostAllotHelper;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateBatchResult;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateResult;

public class CostAllotGenerateSchemePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostAllotGenerateSchemePlugin.class);
    private static final String BTN_OK = "btnok";
    public static final String KEY_CALTASK1 = "caltask";
    public static final String KEY_CALTASKS = "caltasks";
    private static final String TASK_TYPE_HIS = "2";

    public void initialize() {
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"pcs_allotdetail");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().cacheFormShowParameter();
    }

    public void beforeBindData(EventObject args) {
        boolean flag = this.isCostAllotTaskView();
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{KEY_CALTASKS, "org"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{KEY_CALTASKS, "org"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"generatestrategy", "salaryfile"});
        this.getView().setEnable(Boolean.valueOf(!flag), new String[]{"generatestrategy"});
        FieldEdit calTask = (FieldEdit)this.getView().getControl(KEY_CALTASKS);
        calTask.setMustInput(flag);
        FieldEdit org = (FieldEdit)this.getView().getControl("org");
        org.setMustInput(flag);
        FieldEdit strategy = (FieldEdit)this.getView().getControl("generatestrategy");
        strategy.setMustInput(!flag);
        this.setSalaryFileKeyStatus();
    }

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addClickListeners(new String[]{BTN_OK, "generatestrategy"});
        BasedataEdit salaryfileEdit = (BasedataEdit)this.getView().getControl("salaryfile");
        salaryfileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calTaskEdit = (BasedataEdit)this.getView().getControl(KEY_CALTASKS);
        calTaskEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        IDataEntityProperty property = args.getProperty();
        switch (key = property.getName()) {
            case "org": {
                ChangeData[] changeSet = args.getChangeSet();
                Object oldValue = changeSet[0].getOldValue();
                Object newValue = changeSet[0].getNewValue();
                if (SWCObjectUtils.equals((Object)newValue, (Object)oldValue)) break;
                this.getModel().setValue(KEY_CALTASKS, null);
                this.getView().updateView(KEY_CALTASKS);
                break;
            }
            case "generatestrategy": {
                this.setSalaryFileKeyStatus();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent args) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        long currUserId = RequestContext.get().getCurrUserId();
        switch (fieldKey = event.getProperty().getName()) {
            case "salaryfile": {
                long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
                if (calTaskId == 0L) {
                    String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u201d\u3002", (String)"CostAllotGenerateSchemePlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    event.setCancel(true);
                    return;
                }
                List salaryFileList = CostAllotDetailHelper.getFileIdsByTask((Long)calTaskId);
                if (salaryFileList.isEmpty()) {
                    String message = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u4e0b\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5206\u644a\u660e\u7ec6\u7684\u85aa\u8d44\u6863\u6848\u3002", (String)"CostAllotGenerateSchemePlugin_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    event.setCancel(true);
                    return;
                }
                this.getView().getPageCache().put("salaryFileCount", String.valueOf(salaryFileList.size()));
                QFilter idFilter = new QFilter("id", "in", (Object)salaryFileList);
                event.addCustomQFilter(idFilter);
                break;
            }
            case "caltasks": {
                long orgId = this.getModel().getDataEntity().getLong("org.id");
                if (orgId == 0L) {
                    String message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostAllotGenerateSchemePlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    event.setCancel(true);
                    return;
                }
                QFilter taskFilter = new QFilter("org.id", "=", (Object)orgId);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
                QFilter filter = new QFilter("schemeaftercal.costallot", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection sceneObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
                if (!SWCListUtils.isEmpty((List)sceneObjs)) {
                    List sceneIdList = sceneObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
                    taskFilter.and("payrollscenev.id", "in", sceneIdList);
                }
                event.addCustomQFilter(taskFilter);
                event.addCustomQFilter(new QFilter("taskstatus", "not in", (Object)new String[]{CalPayrollTaskStateEnum.CREATE.getCode(), CalPayrollTaskStateEnum.UNCAL.getCode(), CalPayrollTaskStateEnum.DISUSED.getCode(), CalPayrollTaskStateEnum.CALPROCESSING.getCode()}));
                event.addCustomQFilter(new QFilter("tasktype", "!=", (Object)TASK_TYPE_HIS));
                QFilter calTaskFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_allottask", (String)KEY_CALTASK1, (String)"47150e89000000ac");
                logger.info("costAllotGenerate salaryFile:{}", (Object)JSON.toJSONString((Object)calTaskFilter));
                if (calTaskFilter == null) break;
                event.addCustomQFilter(calTaskFilter);
                break;
            }
            case "org": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"47150e89000000ac");
                logger.info("costAllotGenerate org payRollCalSet:{}", (Object)JSON.toJSONString((Object)payRollCalSet));
                if (payRollCalSet == null) break;
                QFilter payRollCalFilter = new QFilter("id", "in", (Object)payRollCalSet);
                event.addCustomQFilter(payRollCalFilter);
                break;
            }
        }
        logger.info("CostAllotGenerateSchemePlugin beforeF7Select fieldKey:{},CustomFilters:{}", (Object)fieldKey, (Object)event.getCustomQFilters());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        if (BTN_OK.equals(clkKey)) {
            LinkedHashMap<Long, DynamicObject> taskMap;
            boolean flag = this.isCostAllotTaskView();
            DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
            DynamicObjectCollection salaryFileCollection = this.getView().getModel().getDataEntity().getDynamicObjectCollection("salaryfile");
            String strategy = this.getView().getModel().getDataEntity().getString("generatestrategy");
            DynamicObjectCollection calTasks = dynamicObject.getDynamicObjectCollection(KEY_CALTASKS);
            if (calTasks.isEmpty() && !flag) {
                Long calTaskId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("calTaskId"), Long.class, (boolean)true);
                BasedataProp property = (BasedataProp)calTasks.getDynamicObjectType().getProperty("fbasedataid");
                DynamicObject calTask = this.getModel().loadReferenceData(property.getDynamicComplexPropertyType(), (Object)calTaskId);
                if (calTask == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5df2\u88ab\u5220\u9664\u6216\u8005\u5931\u6548\u3002", (String)"CostAllotGenerateSchemePlugin_9", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                    this.getModel().setDataChanged(true);
                    return;
                }
                taskMap = new LinkedHashMap<Long, DynamicObject>(2);
                taskMap.put(calTaskId, calTask);
            } else {
                taskMap = calTasks.stream().collect(Collectors.toMap(ele -> ele.getLong("fbasedataid_id"), ele -> ele.getDynamicObject("fbasedataid"), (k1, k2) -> k1, LinkedHashMap::new));
            }
            if (flag ? this.validatorFromAllotTask(dynamicObject, (Map<Long, DynamicObject>)taskMap) : this.validatorFromAllotDetail(salaryFileCollection, strategy, (Map<Long, DynamicObject>)taskMap)) {
                return;
            }
            AllotDetailHelper allotDetailHelper = new AllotDetailHelper();
            CostAllotValidateBatchResult batchResult = new CostAllotValidateBatchResult((Map)taskMap);
            batchResult.setOperateKey(UUID.randomUUID().toString());
            logger.info("validateCostAllotDetails begin 1-3");
            allotDetailHelper.validateCostAllotDetails(batchResult);
            logger.info("validateCostAllotDetails end 1-4");
            this.dealBatchResult(batchResult);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "pcs_generateschemeconfirm".equals(callBackId = messageBoxClosedEvent.getCallBackId())) {
            IPageCache pageCache = this.getView().getPageCache();
            Map map = (Map)SerializationUtils.fromJsonString((String)pageCache.get("pcs_generateschemeconfirm_calPersonInfo"), Map.class);
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    private void dealBatchResult(CostAllotValidateBatchResult batchResult) {
        if (batchResult.isAnyFail()) {
            List messages = batchResult.allMessagesWithDetails();
            if (!CollectionUtils.isEmpty((Collection)messages)) {
                if (messages.size() == 1) {
                    this.getView().showErrorNotification((String)messages.get(0));
                } else {
                    String title = ResManager.loadKDString((String)"\u672c\u6b21\u5171\u64cd\u4f5c{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d{1}\u6761\u672a\u901a\u8fc7\u6821\u9a8c\u3002", (String)"CostAllotGenerateSchemePlugin_40", (String)"swc-pcs-formplugin", (Object[])new Object[]{batchResult.getTaskMap().size(), batchResult.failSize()});
                    String opName = ResManager.loadKDString((String)"\u751f\u6210\u5206\u644a\u660e\u7ec6", (String)"CostAllotGenerateSchemePlugin_41", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    FormShowParameter parameter = SWCShowFormServiceHelper.getOperationResultParameter((String)opName, (String)title, (List)messages);
                    this.getView().showForm(parameter);
                }
            }
            return;
        }
        Map successTaskMap = batchResult.successTaskMap();
        HashMap taskSetUpdateMap = Maps.newHashMapWithExpectedSize((int)successTaskMap.size());
        for (Map.Entry entry : successTaskMap.entrySet()) {
            CostAllotValidateResult taskRes = batchResult.resultOf((Long)entry.getKey());
            if (!SWCStringUtils.equals((String)"1", (String)taskRes.getCode())) continue;
            DynamicObject task = batchResult.taskOf((Long)entry.getKey());
            taskSetUpdateMap.put(entry.getKey(), task);
        }
        if (!taskSetUpdateMap.isEmpty()) {
            this.getPageCache().put("successTaskIds", SerializationUtils.toJsonString(successTaskMap.keySet()));
            this.getPageCache().put("setUpdateTaskIds", SerializationUtils.toJsonString(taskSetUpdateMap.keySet()));
            this.showSetupIsChangedTipDialog(taskSetUpdateMap);
        } else {
            logger.info("transferDataView begin 1-5");
            this.transferDataView(successTaskMap);
            logger.info("transferDataView end 1-6");
        }
    }

    private boolean validatorFromAllotDetail(DynamicObjectCollection salaryFileCollection, String strategy, Map<Long, DynamicObject> taskMap) {
        boolean costGenerateFlag = SWCStringUtils.equals((String)TASK_TYPE_HIS, (String)strategy);
        if (costGenerateFlag) {
            if (CollectionUtils.isEmpty((Collection)salaryFileCollection)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u8d44\u6863\u6848\u201d\u3002", (String)"CostAllotGenerateSchemePlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(true);
                return true;
            }
            ArrayList<Long> mulSalaryFileList = new ArrayList<Long>(salaryFileCollection.size());
            for (DynamicObject row : salaryFileCollection) {
                DynamicObject baseDataObj = row.getDynamicObject("fbasedataid");
                Long baseDataId = baseDataObj.getLong("id");
                mulSalaryFileList.add(baseDataId);
            }
            Object[] costSetupArr = CostAllotHelper.queryCostSetUpArr((Long)taskMap.entrySet().iterator().next().getKey(), mulSalaryFileList);
            if (ArrayUtils.isEmpty((Object[])costSetupArr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u85aa\u8d44\u6863\u6848\u5747\u672a\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u4e0d\u80fd\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"CostAllotGenerateSchemePlugin_7", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(true);
                return true;
            }
        }
        return false;
    }

    private boolean validatorFromAllotTask(DynamicObject dynamicObject, Map<Long, DynamicObject> taskMap) {
        if (CollectionUtils.isEmpty(taskMap)) {
            if (dynamicObject.get("org") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostAllotGenerateSchemePlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(true);
                return true;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u201d\u3002", (String)"CostAllotGenerateSchemePlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(true);
            return true;
        }
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            AppCache.get((String)"pcs").put("isdetailtermination_" + entry.getKey(), (Object)"false");
        }
        return false;
    }

    private void transferDataView(Map<Long, DynamicObject> taskMap) {
        boolean flag = this.isCostAllotTaskView();
        Map<String, Object> map = this.packageResult(taskMap);
        HashMap calPersonIdMap = Maps.newHashMapWithExpectedSize((int)taskMap.size());
        int totalCount = 0;
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        String noFileMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u56e0\u4e3a\u6240\u9009\u4efb\u52a1\u4e0b\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6863\u6848\u3002", (String)"CostAllotGenerateSchemePlugin_42", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
        HashMap taskMapCopy = Maps.newHashMap(taskMap);
        HashMap tasksOfMessage = Maps.newHashMapWithExpectedSize((int)taskMap.size());
        if (flag) {
            logger.info("getFileIdsByTask begin 1-7");
            Iterator<Map.Entry<Long, DynamicObject>> iterator = taskMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, DynamicObject> entry = iterator.next();
                DynamicObject[] res = new CostAllotValidateResult();
                AllotDetailHelper.validateCalPersonStatus((Long)entry.getKey(), (CostAllotValidateResult)res, (boolean)true);
                if (!res.isFlag()) continue;
                iterator.remove();
                StringBuilder builder = tasksOfMessage.computeIfAbsent(res.getMessage(), ky -> new StringBuilder());
                builder.append(entry.getValue().getString("name")).append(split);
            }
            if (!CollectionUtils.isEmpty(taskMap)) {
                DynamicObject[] calPersons;
                for (DynamicObject entry : calPersons = AllotDetailHelper.queryCalPersonIdsByCalTaskId(taskMap.keySet(), null, (String)"1")) {
                    List calPersonIds = calPersonIdMap.computeIfAbsent(entry.getLong("caltask.id"), ky -> Lists.newArrayListWithExpectedSize((int)calPersons.length));
                    calPersonIds.add(entry.getLong("id"));
                }
                logger.info("getFileIdsByTask end 1-8");
                iterator = taskMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, DynamicObject> entry = iterator.next();
                    List calPersonIds = (List)calPersonIdMap.get(entry.getKey());
                    if (CollectionUtils.isEmpty((Collection)calPersonIds)) {
                        iterator.remove();
                        StringBuilder builder = tasksOfMessage.computeIfAbsent(noFileMsg, ky -> new StringBuilder());
                        builder.append(entry.getValue().getString("name")).append(split);
                        continue;
                    }
                    totalCount += calPersonIds.size();
                }
            }
        } else {
            Map<Long, Long> calPersonIdToFileIdMap = this.dealOneTask(taskMap, (String)map.get("generatestrategy"), map, noFileMsg);
            if (CollectionUtils.isEmpty(calPersonIdToFileIdMap)) {
                return;
            }
            totalCount = calPersonIdToFileIdMap.size();
            calPersonIdMap.put(taskMap.entrySet().iterator().next().getKey(), Lists.newArrayList(calPersonIdToFileIdMap.keySet()));
        }
        if (!tasksOfMessage.isEmpty() && !this.dealTaskMessage(taskMapCopy, calPersonIdMap, split, noFileMsg, tasksOfMessage)) {
            return;
        }
        map.put("calPersonCountMap", calPersonIdMap);
        map.put("calpersoncount", totalCount);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("pcs_generateschemeconfirm_calPersonInfo", SerializationUtils.toJsonString(map));
        String format = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5904\u7406{0}\u6761\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"CostAllotTaskList_3", (String)"swc-pcs-formplugin", (Object[])new Object[]{totalCount});
        this.getView().showConfirm(format, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("pcs_generateschemeconfirm"));
    }

    private Map<String, Object> packageResult(Map<Long, DynamicObject> taskMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("caltaskids", taskMap.keySet());
        map.put("caltaskid", taskMap.keySet().iterator().next());
        String strategy = this.getView().getModel().getDataEntity().getString("generatestrategy");
        map.put("generatestrategy", strategy);
        return map;
    }

    private Map<Long, Long> dealOneTask(Map<Long, DynamicObject> taskMap, String strategy, Map<String, Object> map, String noFileMsg) {
        Map.Entry<Long, DynamicObject> entry = taskMap.entrySet().iterator().next();
        Long calTaskId = entry.getKey();
        String calTaskName = entry.getValue().getString("name");
        CostAllotValidateResult res = new CostAllotValidateResult();
        AllotDetailHelper.validateCalPersonStatus((Long)calTaskId, (CostAllotValidateResult)res, (boolean)false);
        if (res.isFlag()) {
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a{1}", (String)"CostAllotGenerateSchemePlugin_51", (String)"swc-pcs-formplugin", (Object[])new Object[]{calTaskName, res.getMessage()});
            this.getView().showErrorNotification(msg);
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, Long> calPersonIdToFileIdMap = this.queryCalPersonIdToFileMap(calTaskId, strategy, map);
        if (CollectionUtils.isEmpty(calPersonIdToFileIdMap)) {
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a{1}", (String)"CostAllotGenerateSchemePlugin_51", (String)"swc-pcs-formplugin", (Object[])new Object[]{calTaskName, noFileMsg});
            this.getView().showErrorNotification(msg);
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return calPersonIdToFileIdMap;
    }

    private boolean dealTaskMessage(Map<Long, DynamicObject> taskMap, Map<Long, List<Long>> calPersonIdMap, String split, String noFileMsg, Map<String, StringBuilder> tasksOfMessage) {
        logger.info("Trace By Quinn: dealTaskMessage - 1");
        if (calPersonIdMap.isEmpty()) {
            logger.info("Trace By Quinn: dealTaskMessage - 2");
            if (tasksOfMessage.size() == 1) {
                logger.info("Trace By Quinn: dealTaskMessage - 3");
                Map.Entry<String, StringBuilder> entry = tasksOfMessage.entrySet().iterator().next();
                StringBuilder calTaskName = entry.getValue();
                calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a{1}", (String)"CostAllotGenerateSchemePlugin_51", (String)"swc-pcs-formplugin", (Object[])new Object[]{calTaskName, entry.getKey()});
                this.getView().showErrorNotification(msg);
            } else {
                logger.info("Trace By Quinn: dealTaskMessage - 4");
                ArrayList msgList = Lists.newArrayListWithExpectedSize((int)tasksOfMessage.size());
                for (Map.Entry<String, StringBuilder> entry : tasksOfMessage.entrySet()) {
                    StringBuilder calTaskName = entry.getValue();
                    calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
                    String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a{1}", (String)"CostAllotGenerateSchemePlugin_51", (String)"swc-pcs-formplugin", (Object[])new Object[]{calTaskName, entry.getKey()});
                    msgList.add(msg);
                }
                String title = ResManager.loadKDString((String)"\u672c\u6b21\u5171\u64cd\u4f5c{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d{1}\u6761\u672a\u901a\u8fc7\u6821\u9a8c\u3002", (String)"CostAllotGenerateSchemePlugin_40", (String)"swc-pcs-formplugin", (Object[])new Object[]{taskMap.size(), taskMap.size() - tasksOfMessage.size()});
                String opName = ResManager.loadKDString((String)"\u751f\u6210\u5206\u644a\u660e\u7ec6", (String)"CostAllotGenerateSchemePlugin_41", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                FormShowParameter parameter = SWCShowFormServiceHelper.getOperationResultParameter((String)opName, (String)title, (List)msgList);
                this.getView().showForm(parameter);
            }
            return false;
        }
        logger.info("Trace By Quinn: dealTaskMessage - 5");
        StringBuilder calTaskName = new StringBuilder();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            List<Long> calPersonIds = calPersonIdMap.get(entry.getKey());
            if (!CollectionUtils.isEmpty(calPersonIds)) continue;
            calTaskName.append(entry.getValue().getString("name")).append(split);
        }
        if (calTaskName.length() > 0) {
            logger.info("Trace By Quinn: dealTaskMessage - 6");
            calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a{1}", (String)"CostAllotGenerateSchemePlugin_51", (String)"swc-pcs-formplugin", (Object[])new Object[]{calTaskName, noFileMsg});
            this.getView().showTipNotification(msg);
        }
        return true;
    }

    private Map<Long, Long> queryCalPersonIdToFileMap(Long calTaskId, String strategy, Map<String, Object> map) {
        Object[] calPersons;
        ArrayList salaryFileList = null;
        DynamicObjectCollection salaryFileCollection = this.getView().getModel().getDataEntity().getDynamicObjectCollection("salaryfile");
        if (SWCStringUtils.equals((String)TASK_TYPE_HIS, (String)strategy) && !CollectionUtils.isEmpty((Collection)salaryFileCollection)) {
            salaryFileList = Lists.newArrayListWithExpectedSize((int)salaryFileCollection.size());
            for (DynamicObject row : salaryFileCollection) {
                DynamicObject baseDataObj = row.getDynamicObject("fbasedataid");
                if (!baseDataObj.getBoolean("iscurrentversion")) continue;
                Long baseDataId = baseDataObj.getLong("id");
                salaryFileList.add(baseDataId);
            }
            map.put("salaryfile", salaryFileList);
        }
        if (ArrayUtils.isEmpty((Object[])(calPersons = AllotDetailHelper.queryCalPersonIdsByCalTaskId(Collections.singletonList(calTaskId), salaryFileList, (String)strategy)))) {
            String message = ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e0b\u6ca1\u6709\u5df2\u5ba1\u6838\u4e14\u5206\u644a\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6210\u7684\u6838\u7b97\u8bb0\u5f55\u3002", (String)"CostAllotGenerateSchemePlugin_36", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, Long> calPersonIdToFileIdMap = Arrays.stream(calPersons).collect(Collectors.toMap(ele -> ele.getLong("id"), ele -> ele.getLong("salaryfile.id"), (k1, k2) -> k1));
        if (SWCStringUtils.equals((String)"3", (String)strategy)) {
            HashSet existedSalaryFileIdList = Sets.newHashSet((Iterable)AllotDetailHelper.getExistSalaryFileNumber((long)calTaskId));
            calPersonIdToFileIdMap.entrySet().removeIf(entry -> existedSalaryFileIdList.contains(entry.getValue()));
        }
        return calPersonIdToFileIdMap;
    }

    private void showSetupIsChangedTipDialog(Map<Long, DynamicObject> taskSetUpdateMap) {
        ArrayList<String> calTaskList = new ArrayList<String>(taskSetUpdateMap.size());
        for (Map.Entry<Long, DynamicObject> entry : taskSetUpdateMap.entrySet()) {
            calTaskList.add(entry.getValue().getString("name"));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setCustomParam("costcaltask", calTaskList);
        parameter.setFormId("pcs_allotoperationresult");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_allotoperationresult"));
        this.getView().showForm(parameter);
    }

    private void setSalaryFileKeyStatus() {
        String strategy = this.getView().getModel().getDataEntity().getString("generatestrategy");
        Boolean flag = SWCStringUtils.equals((String)TASK_TYPE_HIS, (String)strategy);
        this.getView().setEnable(flag, new String[]{"salaryfile"});
        this.getView().setVisible(flag, new String[]{"salaryfile"});
        FieldEdit salaryFile = (FieldEdit)this.getView().getControl("salaryfile");
        salaryFile.setMustInput(flag.booleanValue());
    }

    private boolean isCostAllotTaskView() {
        IFormView parentView = this.getView().getParentView();
        boolean flag = false;
        if (parentView instanceof ListView) {
            String billFormId = ((ListView)parentView).getBillFormId();
            flag = SWCStringUtils.equals((String)"pcs_allottask", (String)billFormId);
        }
        return flag;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        String actionId = event.getActionId();
        if (!(returnData instanceof Map)) {
            return;
        }
        if ("pcs_allotoperationresult".equals(actionId)) {
            Map map = (Map)returnData;
            String radioGroupField = (String)map.get("radiogroupfield");
            if (SWCStringUtils.equals((String)"1", (String)radioGroupField)) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                List setUpdateTaskIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("setUpdateTaskIds"), Long.class);
                resultMap.put("isChange", "true");
                resultMap.put("setUpdateTaskIds", setUpdateTaskIds);
                this.getView().setReturnData(resultMap);
                this.getView().close();
                return;
            }
            List taskIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("successTaskIds"), Long.class);
            if (CollectionUtils.isEmpty((Collection)taskIds)) {
                return;
            }
            Object[] taskIdArr = new Long[taskIds.size()];
            for (int i = 0; i < taskIds.size(); ++i) {
                taskIdArr[i] = (Long)ObjectConverter.convert(taskIds.get(i), Long.class, (boolean)true);
            }
            DynamicObjectCollection calTasks = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_CALTASKS);
            BasedataProp property = (BasedataProp)calTasks.getDynamicObjectType().getProperty("fbasedataid");
            Map calTaskMap = this.getModel().loadReferenceDataBatch(property.getDynamicComplexPropertyType(), taskIdArr);
            HashMap taskMap = Maps.newHashMapWithExpectedSize((int)calTaskMap.size());
            if (CollectionUtils.isEmpty((Map)calTaskMap)) {
                return;
            }
            for (Map.Entry entry : calTaskMap.entrySet()) {
                taskMap.put(ObjectConverter.convert(entry.getKey(), Long.class, (boolean)true), entry.getValue());
            }
            this.transferDataView(taskMap);
        }
    }
}

